$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false,
            animate: true,
        });

        driver.defineSteps([{
            element: '#campostour',
            popover: {
                title: 'Dados Gerais',
                description: 'Aqui estão os campos disponíveis para o cadastro, os campos obrigatórios terão o * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#txtTipo',
            popover: {
                title: 'Tipo',
                description: 'Este campo é preenchido automaticamente.',
                position: 'top'
            }
        },
        {
            element: '#txtDescricao',
            popover: {
                title: 'Descrição',
                description: 'Aqui, adicionamos a descrição do tipo.',
                position: 'top'
            }
        },
        {
            element: '#area',
            popover: {
                title: 'Área',
                description: 'Aqui selecionamos qual a área do tipo.',
                position: 'top'
            }
        },
        {
            element: "#btnVoltar",
            popover: {
                title: "Botão Voltar",
                description:
                    "Ao clicar nesse botão você retorna para a tela de consulta.",
                position: "left",
            },
        },
        {
            element: '#gravar',
            popover: {
                title: 'Botão Gravar',
                description: 'Clique aqui para gravar o tipo.',
                position: 'left'
            }
        }
        ]);
        driver.start();
    });
});

$(document).ready(async function () {

    let queryString = window.location.href;
    let parametros = queryString.split('/');
    let tipo = parametros[parametros.length - 1];

    $('#btnVoltar').on('click', async function () {
        await deletaRegistro('TIPO', getCookie('usuario'), tipo);
        window.location.href = `${BASE_URI}/tipo`;
    });

    $('.rdArea').on('change', function () {
        if ($('#rdProducao').is(':checked')){
            $('#camposProducao').removeClass('d-none')
        } else{
            $('#camposProducao').addClass('d-none')
        }
    })

    $(document).ready(function () {

        $('#msform').validate({
            debug: false,
            ignore: "",
            rules: {
                txtDescricao: {
                    required: true,
                },
            },
            messages: {
                txtDescricao: {
                    required: "Informe uma descrição válida."
                },
            },
            errorElement: 'span',
            errorPlacement(error, element) {
                error.addClass('invalid-feedback');
                element.closest('.form-group').append(error);
            },
            highlight(element) {
                $(element).addClass('is-invalid');
            },
            unhighlight(element) {
                $(element).removeClass('is-invalid');
            }
        });

        $('.radio-group .radio').click(function () {
            $(this).parent().find('.radio').removeClass('selected');
            $(this).addClass('selected');
        });

        $(".submit").click(function () {
            return false;
        });
    });

    if (tipo != '' && tipo != 'create') {

        if (await liberarRegistro('TIPO', tipo) == false) {
            window.location.href = '../tipo';
        } else {

            try {
                $.LoadingOverlay("show");
                try {
                    let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"TIPO", 
                    "camposSelect":["ID_TIPO", "DESCRICAO", "ATIVO", "AREA", "ACRES_PRECOFAC", "TIPO_SOL"], 
                    "where": ["ID_TIPO = '${tipo}'"]}`, null);

                    if (!response) {
                        return;
                    }
                    let jsonStr = await response.json();
                    if (response.status != 200) {
                        msgErro(jsonStr.RESULT[0].mensagem);
                        return;
                    }

                    $('#txtTipo').val(jsonStr.RESULT[0][0].ID_TIPO);
                    $('#txtDescricao').val(jsonStr.RESULT[0][0].DESCRICAO);
                    $('#txtPrecoFac').val(jsonStr.RESULT[0][0].ACRES_PRECOFAC ?? 0);
                    $('#cbAtivo').prop('checked', jsonStr.RESULT[0][0].ATIVO == 'S')
                    $('.rdArea').filter('[value="' + jsonStr.RESULT[0][0].AREA + '"]').prop('checked', true);
                    $('.rdArea').trigger('change')
                    $('.rdTipo').filter('[value="' + jsonStr.RESULT[0][0].TIPO_SOL + '"]').prop('checked', true);

                } catch (error) {
                    console.error(error);
                    msgErro(`Não foi possível buscar os dados do tipo: ${error}`);
                }
            } finally {
                $('#txtTipo').attr('readonly', true);
                $.LoadingOverlay('hide');
            }
        }
    }

    $("#gravar").click(

        async function () {
            let validator = $("#msform").validate();
            validator.form();
            let erros = 0;
            erros = validator.numberOfInvalids();

            if (erros == 0) {
                try {
                    $.LoadingOverlay("show");

                    tipo = {};
                    
                    tipo.IDTIPO = $('#txtTipo').val()
                    tipo.DESCRICAO = $('#txtDescricao').val().toUpperCase();
                    tipo.ATIVO = $('#cbAtivo').is(':checked') == true ? 'S' : 'N';
                    tipo.AREA = $('.rdArea').filter(':checked').val();
                    if (!$('#camposProducao').hasClass('d-none')){
                        tipo.PRECOFAC = parseFloat($('#txtPrecoFac').val()).toFixed(2);
                        tipo.TIPOSOL = $('.rdTipo').filter(':checked').val()
                    }

                    let response = await requisicao('POST', '/Sisplan/Cadastros/v1/tipo?', `JSON=${encodeURIComponent(JSON.stringify(tipo))}`, null);

                    if (!response) {
                        $.LoadingOverlay("hide");
                        return;
                    };

                    let jsonStr = await response.json();
                    if (response.status != 200) {
                        $.LoadingOverlay("hide");
                        msgErro(jsonStr.mensagem);
                        return;
                    }
                    $.LoadingOverlay("hide");
                    toastr.success(
                        `Cadastro efetuado com sucesso!`,
                        'Confirmação', {
                        toastClass: 'alert',
                        iconClasses: {
                            error: 'alert-error',
                            info: 'alert-info',
                            success: 'alert-success',
                            warning: 'alert-warning'
                        },
                        positionClass: "toast-top-center",
                        progressBar: true,
                        timeOut: 3000,
                        fadeOut: 1000,
                        onHidden() {
                            window.location.href = `${BASE_URI}/tipo`;
                        }
                    }
                    ).css({
                        "margin-top": "20%",
                        "width": "500px",
                        "max-width": "500px"
                    });

                } catch (error) {
                    console.error(error);
                    $.LoadingOverlay("hide");
                }
            }
        });
});