$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
    });
    driver.defineSteps([
      {
        element: "#geral",
        popover: {
          title: "Cadastro de Dados Gerais",
          description: "Aqui você pode informar os dados gerais do cadastro de Usuário.",
          position: "bottom",
        },
      },
      {
        element: "#nomeInfoTour",
        popover: {
          title: "Campos Obrigatórios",
          description: "Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.",
          position: "top",
        },
      },
      {
        element: "#representanteInfoTour",
        popover: {
          title: "Campos Obrigatórios",
          description: "Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.",
          position: "top",
        },
      },
      {
        element: "#btnGravar",
        popover: {
          title: "Botão Gravar",
          description: "Ao clicar nesse botão você grava os dados inseridos.",
          position: "left",
        },
      },
      {
        element: "#btnVoltar",
        popover: {
          title: "Botão Voltar",
          description:
            "Ao clicar nesse botão você retorna para a tela de consulta.",
          position: "left",
        },
      },
    ]);
    driver.start();
  });
});

$(document).ready(async function () {

  $('#btnVoltar').on('click', async function () {
    await deletaRegistro('ACESSO_USUARIOS', getCookie('usuario'), usuario);
    window.location.href = `${BASE_URI}/usuario`;
  });

  let queryString = window.location.href;
  let pegaUsuario = queryString.indexOf('usuario/') + 8; // + 6 porque é a soma do "pagar/""
  let usuario = queryString.substr(pegaUsuario, queryString.length);

  if (usuario != 'create') {
    usuario = atob(usuario);
  }


  let contaFs = 1;

  $('#account').on('click', function () {
    if (aUsuario != 'create') {
      if (contaFs == 1) {
        $('#voltar').trigger('click');
      }
    }
  });

  $('#payment').on('click', function () {
    if (aUsuario != 'create') {
      if (contaFs == 1) {
        $('#avancar1').trigger('click');
      }
    }
  });

  $(".previous").click(function () {

    contaFs -= 1;

    currentFs = $(this).parent();
    previousFs = $(this).parent().prev();
    $("#progressbar li").eq($("fieldset").index(currentFs)).removeClass("active");
    previousFs.show();
    currentFs.animate({
      opacity: 0
    }, {
      step(now) {
        opacity = 1 - now;
        currentFs.css({
          'display': 'none',
          'position': 'relative'
        });
        previousFs.css({
          'opacity': opacity
        });
      },
      duration: 600
    });
  });

  $(".next").click(function () {

    contaFs += 1;

    let validator = $("#msform").validate();
    validator.form();
    let erros = 0;
    erros = validator.numberOfInvalids();

    if (erros == 0) {

      currentFs = $(this).parent();
      nextFs = $(this).parent().next();

      $("#progressbar li").eq($("fieldset").index(nextFs)).addClass("active");

      nextFs.show();
      currentFs.animate({
        opacity: 0
      }, {
        step(now) {
          opacity = 1 - now;

          currentFs.css({
            'display': 'none',
            'position': 'relative'
          });
          nextFs.css({
            'opacity': opacity
          });
        },
        duration: 600
      });

      $('#tabela-empAcesso').DataTable().columns.adjust().draw(false);
    }
  });


  $("#txtDescontoMax").maskMoney({
    decimal: ".",
    thousands: "",
    precision: 2,
  });

  $("#txtPercLimite").maskMoney({
    decimal: ".",
    thousands: "",
    precision: 2,
  });

  let dataSet = await RetornaEmpresas();

  $('#tabela-empAcesso').DataTable({
    paging: false,
    filter: false,
    info: false,
    order: true,
    destroy: true,
    scrollX: false,
    scrollY: '100px',
    "language": {
      "sEmptyTable": "Nenhum registro encontrado",
      "sInfo": "_TOTAL_ registros",
      "sInfoEmpty": " 0 registros",
      "sInfoFiltered": "(Filtrados de _MAX_ registros)",
      "sInfoPostFix": "",
      "sInfoThousands": ".",
      "sLengthMenu": "_MENU_ resultados",
      "sLoadingRecords": "Carregando...",
      "sProcessing": "Processando...",
      "sZeroRecords": "Nenhum registro encontrado",
      "sSearch": "Pesquisar",
      "oPaginate": {
        "sNext": "Próximo",
        "sPrevious": "Anterior",
        "sFirst": "Primeiro",
        "sLast": "Último"
      },
      "oAria": {
        "sSortAscending": ": Ordenar colunas de forma ascendente",
        "sSortDescending": ": Ordenar colunas de forma descendente"
      }
    }
  });

  $('#btnEmail').on('click', async function () {
    const queryString = window.location.href;
    const pegaUsuario = queryString.indexOf('usuario/') + 8; // + 6 porque é a soma do "pagar/""
    let usuario = queryString.substr(pegaUsuario, queryString.length);

    if (usuario != 'create') {
      usuario = atob(usuario);
    } else {
      msgErro('Configuração de e-mail só pode ser feita em usuários gravados.');
      return;
    }
    $('#txtEmailCodUsuario').val(usuario);
    await buscarDados();
    $('#modal-configuracao').modal('show');
  });


  $('#tabela-empAcesso').DataTable().rows().remove().draw(false);
  for (let i = 0; i < dataSet.length; i++) {
    const empresa = dataSet[i];
    $('#tabela-empAcesso').DataTable().row.add([botaoSelecionarGrid(), `${empresa.EMP_PAT} - ${empresa.EMP_NOME}`]).draw(false);
  }

  function botaoSelecionarGrid() {
    return '<div class="form-check">' +
      '<input type="checkbox" class="align-self-center checkEmpresa" value"">' +
      '</div>';
  };
  // inputs

  $('#txtRepresentante').autocompleta(1, `JSON={ "tabela":"represen", "camposSelect":[ "codrep chave", "nome descricao"], "where": null}`);
  $('#btn-Representante').pesquisa('#txtRepresentante', 'CODREP', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"represen", "camposSelect":[ "codrep", "nome"]}`, 'Pesquisa Representante', 'represen');

  $('#btn-limpa-Representante').on('click', function () {
    $('#txtRepresentante').val('');
  });

  $('#txtFuncionario').autocompleta(1, `JSON={ "tabela":"PESSOAL", "camposSelect":[ "CODIGO CHAVE", "NOME DESCRICAO"], "where": null}`);
  $('#btn-Funcionario').pesquisa('#txtFuncionario', 'CODIGO', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"PESSOAL", "camposSelect":[ "CODIGO", "NOME"]}`, 'Pesquisa Funcionario', 'PESSOAL');

  $('#btn-limpa-Funcionario').on('click', function () {
    $('#txtFuncionario').val('');
  });

  $("#txtSetores").pesquisa_variosServerside(1, '{ "tabela":"CADFLUXO", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null, "orderBy": ["CODIGO"]}', 'CODIGO', 'DESCRICAO');
  $("#btnSetores").pesquisa_serversideSel('#txtSetores', `{ "tabela":"CADFLUXO", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null, "orderBy": ["CODIGO"]}`, 'Pesquisa Setores')

  $("#btnLimpaSetores").on("click", function () {
    $("#txtSetores").empty().trigger("change");
  });

  $("#txtIdDashMob").autocompleta(1, `JSON={ "tabela":"DASH_ERP", "camposSelect":[ "DISTINCT ID_DASH CHAVE", "TITULO_DASH DESCRICAO " ], "where": ["TIPO_DASH = 'M'"], "orderBy": ["ID_DASH"]}`);
  $("#btn-idDashMob").pesquisa('#txtIdDashMob', 'ID_DASH', 'TITULO_DASH', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"DASH_ERP", "camposSelect":[ "DISTINCT ID_DASH", "TITULO_DASH"], "where": ["TIPO_DASH='M'"], "orderBy": ["ID_DASH"]}`, 'Pesquisa Dash Erp', 'DASH_ERP');

  $("#btn-limpa-idDashMob").on("click", function () {
    $("#txtIdDashMob").val('');
  });


  $('#txtWhatsapp').autocompleta(1, `JSON={ "tabela":"WHATSAPPWEB", "camposSelect":[ "ID CHAVE", "NOME DESCRICAO"], "where": null}`);
  $('#btnWhatsapp').pesquisa('#txtWhatsapp', 'ID', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"WHATSAPPWEB", "camposSelect":[ "ID", "NOME"]}`, 'Pesquisa Whatsapp', 'WHATSAPPWEB');

  $('#btnLimpaWhatsapp').on('click', function () {
    $('#txtWhatsapp').val('');
  });

  $('#txtDeposito').pesquisa_variosServerside(1, '{ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'CODIGO', 'DESCRICAO');
  $('#btn-Deposito').pesquisa_serversideSel('#txtDeposito', `{ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}`, 'Pesquisa Depósito');

  $("#btn-limpa-Deposito").on("click", function () {
    $("#txtDeposito").empty().trigger('change');
  });

  $('#tabela-empAcesso').on('click', 'td', function () {
    selecionarLinhaTabela('#tabela-empAcesso', 'checkEmpresa', this);
  });

  $('#msform').validate({
    debug: false,
    ignore: "",
    rules: {
      txtNome: { required: true, },
      txtTipo: { required: true, },
      // txtIDDashWEB: { required: true, },
    },
    messages: {
      txtNome: { required: 'Usuário precisa de um nome', },
      txtTipo: { required: 'Inserir tipo do usuário', },
      // txtIDDashWEB: { required: 'Inserir id DashBoard WEB', },
    },
    errorElement: 'span',
    errorPlacement(error, element) {
      error.addClass('invalid-feedback');
      element.closest('.form-group').append(error);
    },
    highlight(element) {
      $(element).addClass('is-invalid');
    },
    unhighlight(element) {
      $(element).removeClass('is-invalid');
    },
    async submitHandler(form, event) {
      event.preventDefault();
      try {
        $.LoadingOverlay("show");
        try {
          if ((parseFloat($('#txtValor').val()) <= 0) || ($('#txtValor').val() == "0,00")) {
            msgAlerta('Valor não pode ser 0!');
            return;
          }

          let codigo = usuario == 'create' ? await RetornaProximo('ACESSO_USUARIOS', 'ACESSO_USUARIOS', 'CODIGO', 5) : usuario;

          const objetoUsuario = {
            CODIGO: codigo,
            NOME: $('#txtNome').val().toUpperCase(),
            DESCONTOMAXIMO: $('#txtDescontoMax').val(),
            PERC_LIMITE: $('#txtPercLimite').val(),
            TIPO: $('#txtTipo').val(),
            CODFUN: pegaChave('#txtFuncionario'),
            CODREP: pegaChave('#txtRepresentante'),
            GRAVA_CONDICAO: $('#selectGravaCondicao').val(),
            ATIVO: $("#checkAtivo").is(":checked") ? "S" : "N",
            SETORES: await formataListas($("#txtSetores").val().toString()),
            VISUALIZA_BARRA_EXP: $("#cbVisualizaBarra").is(":checked") ? "S" : "N",
            ID_WHATSAPPWEB: pegaChave('#txtWhatsapp'),
            DEPOSITOS: await formataListas($('#txtDeposito').val().toString()),
            SERIE_NF: pegaValor('#txtSerie'),
            EMP_ID: getCookie('emp_id'),
            EMAIL_APP: pegaValor('#txtEmailApp'),
            ID_DASH_MOB: pegaChave('#txtIdDashMob')
          };

          let arrayEmpresas = [];
          for (let i = 0; i < $('#tabela-empAcesso').DataTable().rows('.selected').data().length; i++) {
            let empresa = {};
            let dados = $('#tabela-empAcesso').DataTable().rows('.selected').data()[i];
            empresa.EMP_PAT = dados[1].substr(0, 3);
            arrayEmpresas.push(empresa);
          }
          objetoUsuario.EMPRESA = arrayEmpresas;

          const response = await requisicao('POST', '/Sisplan/usuario/V1/usuario?', `JSON=${encodeURIComponent(JSON.stringify(objetoUsuario))}`, '', 15000);

          if (!response) {
            return;
          }

          if (response.status != 200) {
            let jsonStr = await response.json();
            msgErro(jsonStr.mensagem);
            return;
          }

          $.LoadingOverlay("hide");
          toastr.success(
            'Cadastro efetuado com sucesso!',
            'Confirmação', {
            toastClass: 'alert',
            iconClasses: {
              error: 'alert-error',
              info: 'alert-info',
              success: 'alert-success',
              warning: 'alert-warning'
            },
            positionClass: "toast-top-center",
            progressBar: true,
            timeOut: 3000,
            fadeOut: 1000,
            onHidden() {
              window.location.href = `${BASE_URI}/usuario`;
            }
          }
          ).css({
            "margin-top": "20%",
            width: "500px",
            "max-width": "500px"
          });
        } catch (error) {
          msgErro('Não foi possível gravar os dados do usuario: ');
        }
      } finally {
        $.LoadingOverlay('hide');
      }
    }
  });

  if (usuario != '' && usuario != 'create') {
    try {
      $.LoadingOverlay('show');
      try {
        let dadosUsuario = await buscaDadosUsuario(usuario);
        let dadosEmpresaUsuario = await buscaEmpresaUsuario(usuario);
        $('#txtNome').val(dadosUsuario.NOME);
        insereValor('#txtEmailApp', dadosUsuario.EMAIL_APP);
        $('#selectGravaCondicao').val(dadosUsuario.GRAVA_CONDICAO == '' ? 'N' : dadosUsuario.GRAVA_CONDICAO);
        $('#txtDescontoMax').val(dadosUsuario.DESC_MAX != null ? dadosUsuario.DESC_MAX : '100.00');
        $('#txtPercLimite').val(dadosUsuario.PERC_LIMITE);
        $('#txtTipo').val(dadosUsuario.TIPO);
        $('#txtSerie').val(dadosUsuario.SERIE_NF);


        if (dadosUsuario.ID_DASH_MOB != '') {
          const responseDash = await requisicao("GET", "/sisplan/funcoes/v1/pesquisa?", `JSON={"tabela": "DASH_ERP", "camposSelect": ["ID_DASH", "TITULO_DASH"], "where": ["ID_DASH = ${dadosUsuario.ID_DASH_MOB}"]}`);

          if (!responseDash) {
            return;
          }

          const jsonDash = await responseDash.json();
          if (responseDash.status != 200) {
            msgAlerta(jsonDash.RESULT[0].mensagem);
            return;
          }

          if (jsonDash.RESULT[0].length > 0) {
            insereValor('#txtIdDashMob', dadosUsuario.ID_DASH_MOB, jsonDash.RESULT[0][0].TITULO_DASH);
          }
        }

        if (dadosUsuario.SETORES != "") {
          const responseSetores = await requisicao("GET", "/sisplan/funcoes/v1/pesquisa?", `JSON={"tabela": "CADFLUXO", "camposSelect": ["CODIGO", "DESCRICAO"], "where": ["CODIGO IN (${dadosUsuario.SETORES})"]}`)

          if (!responseSetores) {
            return;
          }

          const jsonSetores = await responseSetores.json();
          if (responseSetores.status != 200) {
            msgAlerta(jsonSetores.RESULT[0].mensagem);
            return;
          }

          await insereValorPesquisaVarios("txtSetores", "CODIGO", "DESCRICAO", jsonSetores.RESULT[0]);
        }

        if (dadosUsuario.DEPOSITOS != '') {
          const responseDeposito = await requisicao("GET", "/sisplan/funcoes/v1/pesquisa?", `JSON={"tabela": "DEPOSITO", "camposSelect": ["CODIGO", "DESCRICAO"], "where": ["CODIGO IN (${dadosUsuario.DEPOSITOS})"]}`)

          if (!responseDeposito) {
            return;
          }

          const jsonDeposito = await responseDeposito.json();
          if (responseDeposito.status != 200) {
            msgAlerta(jsonDeposito.RESULT[0].mensagem);
            return;
          }

          await insereValorPesquisaVarios('txtDeposito', 'CODIGO', 'DESCRICAO', jsonDeposito.RESULT[0]);
        }
        if (dadosUsuario.NOME_WHATSAPPWEB != '') {
          insereValor('#txtWhatsapp', dadosUsuario.ID_WHATSAPPWEB, dadosUsuario.NOME_WHATSAPPWEB);
        }
        $("#checkAtivo").prop("checked", dadosUsuario.ATIVO == 'S')
        $('#cbVisualizaBarra').prop('checked', dadosUsuario.VISUALIZA_BARRA_EXP == 'S');
        // $('#txtIDDashWEB').val(dadosUsuario.ID_DASH_WEB);
        if (dadosUsuario.CODREP != '') {
          insereValor('#txtRepresentante', dadosUsuario.CODREP, dadosUsuario.NOME_REP);
        }

        if (dadosUsuario.CODFUN != '') {
          insereValor('#txtFuncionario', dadosUsuario.CODFUN, dadosUsuario.NOME_FUN)
        }
        if (dadosEmpresaUsuario != '') {
          for (let i = 0; i < dadosEmpresaUsuario.length; i++) {
            for (let x = 0; x < $('#tabela-empAcesso').DataTable().rows().data().length; x++) {
              let dados = $('#tabela-empAcesso').DataTable().rows().data()[x];
              let empresa = dados[1].substr(0, 3);
              if (empresa == dadosEmpresaUsuario[i].EMPRESA) {
                $($('.checkEmpresa')[x]).prop('checked', true);
                $($("table#tabela-empAcesso tr")[x + 1]).addClass("selected");
              }
            }
          }
        }

        let setores = dadosUsuario.SETORES.replaceAll("'", '').split(',');
        let dadosSetores = $('#tabelaSetores').DataTable().rows().data();

        for (let j = 0; j < setores.length; j++) {
          for (let i = 0; i < dadosSetores.length; i++) {
            if (setores[j] == dadosSetores[i].CODIGO) {
              $(`#checkSetor${i}`).prop('checked', true);
              break;
            }
          }
        }

      } catch (error) {
        console.error(error);
        msgErro('Erro ao retornar os dados o usuário');
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  } else {
    $("#checkAtivo").prop("checked", true);
  }
  async function buscaDadosUsuario(codigo) {
    try {
      const url = '/Sisplan/Funcoes/v1/pesquisa?';
      const response = await requisicao('GET', url, `JSON={ "tabela":"ACESSO_USUARIOS", "camposSelect":["ACESSO_USUARIOS.CODIGO", "ACESSO_USUARIOS.ATIVO", 
      "ACESSO_USUARIOS.NOME", "ACESSO_USUARIOS.GRAVA_CONDICAO", "ACESSO_USUARIOS.TIPO", "ACESSO_USUARIOS.DESC_MAX", "ACESSO_USUARIOS.SETORES", 
      "ACESSO_USUARIOS.CODREP", "ACESSO_USUARIOS.VISUALIZA_BARRA_EXP", "ACESSO_USUARIOS.ID_DASH_MOB", "REPRESEN.NOME NOME_REP", "PESSOAL.CODIGO CODFUN", "PESSOAL.NOME NOME_FUN", 
      "ACESSO_USUARIOS.ID_WHATSAPPWEB", "WHATSAPPWEB.NOME NOME_WHATSAPPWEB", "ACESSO_USUARIOS.DEPOSITOS", "EMP_CONFIG.VALOR SERIE_NF", "ACESSO_USUARIOS.EMAIL_APP", 
      "ACESSO_USUARIOS.PERC_LIMITE"],
      "leftjoin": [
                  {"tabela": "REPRESEN", "condicao": "REPRESEN.CODREP = ACESSO_USUARIOS.CODREP"}, 
                  {"tabela": "PESSOAL", "condicao": "PESSOAL.CODIGO = ACESSO_USUARIOS.CODFUN"},
                  {"tabela": "WHATSAPPWEB", "condicao": "WHATSAPPWEB.ID = ACESSO_USUARIOS.ID_WHATSAPPWEB"},
                  {"tabela": "EMP_CONFIG", "condicao": "EMP_CONFIG.TIPO = ('USUARIO_' || ACESSO_USUARIOS.NOME) AND EMP_CONFIG.EMP_ID = ${getCookie('emp_id')} AND EMP_CONFIG.COMPONENTE = 'edtSerieNF'"}
                  ], 
      "where": ["ACESSO_USUARIOS.CODIGO = '${codigo}'"]}`);

      if (!response) {
        return;
      }

      const jsonStr = await response.json();
      if (response.status != 200) {
        msgErro(jsonStr.mensagem);
        return;
      }

      return jsonStr.RESULT[0][0];

    } catch (error) {
      console.error(error);
      msgErro('Erro ao buscar dados do usuário');
    }
  }

  async function voltarSenhaPadrao(codUsuario) {
    try {
      $.LoadingOverlay("show");
      try {
        const url = "/sisplan/alterarsenha/v1/voltarsenhapadrao?";
        const nomeUsuario = $('#txtNome').val();
        const params = `COD_USUARIO=${codUsuario}&NOME_USUARIO=${nomeUsuario}`;

        const response = await requisicao("POST", url, params);

        if (!response) {
          return;
        }
        if (response.status !== 200) {
          const jsonStr = await response.json();
          msgErro(jsonStr.mensagem);
          return;
        }

        toastr.success(
          'Senha resetada com sucesso!',
          'Confirmação', {
          toastClass: 'alert',
          iconClasses: {
            error: 'alert-error',
            info: 'alert-info',
            success: 'alert-success',
            warning: 'alert-warning'
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000,
          onHidden() {
          }
        }
        ).css({
          "margin-top": "20%",
          width: "500px",
          "max-width": "500px"
        });
      } catch (error) {
        console.error(error);
        msgErro("Erro ao alterar senha");
        return false;
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  }

  $('#btnEmailExcluir').on('click', async function () {
    try {
      let r = confirm("Tem certeza que deseja excluir as configurações de e-mail do usuário?");
      if (r == true) {
        const codUsuario = $('#txtEmailCodUsuario').val();
        const response = await requisicao('DELETE', '/sisplan/usuario/V1/email?', `JSON={}&CODUSUARIO=${codUsuario}`, '', 15000);

        if (!response) {
          return;
        }

        if (response.status != 200) {
          const jsonStr = await response.json();
          msgErro(jsonStr.mensagem);
          return;
        }

        toastr.success(
          'Exclusão efetuada com sucesso!',
          'Confirmação', {
          toastClass: 'alert',
          iconClasses: {
            error: 'alert-error',
            info: 'alert-info',
            success: 'alert-success',
            warning: 'alert-warning'
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000,
          onHidden() {
            $('#modal-configuracao').modal('hide');
          }
        }
        ).css({
          "margin-top": "20%",
          width: "500px",
          "max-width": "500px"
        });
      } else {

      }
    } catch (error) {
      console.error(error);
    }
  });

  $('#btnResetarSenha').on('click', async function () {
    msgAlerta(`Tem certeza que deseja resetar a senha do usuário para a senha padrão?`, async function () {
      await voltarSenhaPadrao(usuario);
    });
  });

  $('#btnEmailConfirmar').on('click', async function () {
    try {
      try {
        const camposValidacao = ['txtEmailSenha', 'txtEmailServidor', 'txtEmailPorta', 'txtEmailUsuario', 'txtEmailTLS', 'txtEmailSSL'];
        const camposLabel = ['Senha', 'Servidor', 'Porta', 'Usuario', 'Usa TLS', 'Usa SSL'];
        const camposValidados = camposValidacao.map((input, index) => {
          if ($(`#${input}`).val() == '') {
            msgErro(`${camposLabel[index]} não informado(a), verifique.`);
            return false;
          }
          return true;

        }).filter(value => value === false).length == 0;

        if (!camposValidados) {
          return;
        }
        $.LoadingOverlay('show');
        const email = {
          host: $('#txtEmailServidor').val(),
          port: $('#txtEmailPorta').val(),
          username: $('#txtEmailUsuario').val(),
          password: $('#txtEmailSenha').val(),
          ssl: $('#txtEmailSSL').val() == 'S',
          tls: $('#txtEmailTLS').val() == 'S',
          email_copia: $('#txtEmailCopia').val()
        };

        const codUsuario = $('#txtEmailCodUsuario').val();
        const response = await requisicao('POST', '/sisplan/usuario/V1/email?', `JSON=${encodeURIComponent(JSON.stringify(email))}&CODUSUARIO=${codUsuario}`, '', 15000);

        if (!response) {
          return;
        }

        if (response.status != 200) {
          const jsonStr = await response.json();
          msgErro(jsonStr.mensagem);
          return;
        }

        toastr.success(
          'E-mail cadastrado com sucesso!',
          'Confirmação', {
          toastClass: 'alert',
          iconClasses: {
            error: 'alert-error',
            info: 'alert-info',
            success: 'alert-success',
            warning: 'alert-warning'
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000,
          onHidden() {
            $('#modal-configuracao').modal('hide');
          }
        }
        ).css({
          "margin-top": "20%",
          width: "500px",
          "max-width": "500px"
        });


      } catch (error) {
        console.error(error);
        msgErro('Erro ao gravar informações de e-mail.');
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  function limpaCamposEmail() {
    $('#txtEmailServidor').val('');
    $('#txtEmailPorta').val('');
    $('#txtEmailUsuario').val('');
    $('#txtEmailSenha').val('');
    $('#txtEmailSSL').prop('checked', false);
    $('#txtEmailTLS').prop('checked', false);
  }

  async function buscarDados() {
    $.LoadingOverlay("show");
    try {
      const usuario = $('#txtEmailCodUsuario').val();
      const pesquisaParam = {
        tabela: 'ACESSO_EMAILS',
        camposSelect: ['USUARIO', 'SERVIDOR', 'PORTA', 'SSL', 'LOGIN', 'SENHA', 'TLS', 'EMAIL_COPIA'],
        where: [`USUARIO = '${usuario}'`]
      };

      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

      if (jsonStr.length > 0) {
        $('#txtEmailServidor').val(jsonStr[0].SERVIDOR);
        $('#txtEmailPorta').val(jsonStr[0].PORTA);
        $('#txtEmailUsuario').val(jsonStr[0].LOGIN);
        $('#txtEmailSenha').val(jsonStr[0].SENHA);
        $('#txtEmailSSL').val(jsonStr[0].SSL == '1' ? 'S' : 'N').change();
        $('#txtEmailTLS').val(jsonStr[0].TLS == 'E' ? 'S' : 'N').change();
        $('#txtEmailCopia').val(jsonStr[0].EMAIL_COPIA);
      } else {
        limpaCamposEmail();
      }

    } finally {
      $.LoadingOverlay("hide");
    }
  };

  async function buscaEmpresaUsuario(codigo) {
    try {
      const url = '/Sisplan/Funcoes/v1/pesquisa?';
      const response = await requisicao('GET', url, `JSON={ "tabela":"acesso_empresa", "camposSelect":["EMPRESA"], "where": ["USUARIO = '${codigo}'"]}`);

      if (!response) {
        return;
      }

      let jsonStr = await response.json();
      if (response.status != 200) {
        msgErro(jsonStr.mensagem);
        return;
      }
      if (jsonStr.RESULT[0].length > 0) {
        return jsonStr.RESULT[0];
      }
      return '';


    } catch (error) {
      console.error(error);
      msgErro('Erro ao buscar dados da empresa do usuário');
    }
  }

  async function retornaCodigoUsuario() {
    try {
      const url = '/Sisplan/Funcoes/v1/pesquisa?';
      // const params = `JSON={ "tabela": "acesso_usuarios", "camposSelect": ["CODIGO", "NOME"], "where": [ NOME = '${}'] }`;
      const response = await requisicao('GET', url, `JSON={ "tabela":"acesso_usuarios", "camposSelect":["CODIGO", "NOME"], "where": ["nome = '${$('#txtNome').val()}'"]}`);

      if (!response) {
        return;
      }

      const jsonStr = await response.json();
      if (response.status === 200) {
        return jsonStr.RESULT[0][0].CODIGO;
      }

      msgErro('Erro ao retornar código do usuário!');

      return '';

    } catch (error) {
      console.error(error);
    }
  }

  $('.collapse').on('shown.bs.collapse', function (e) {
    let clicked = $(document).find(`[href='#${$(e.target).attr('id')}']`);

    clicked
      .parent()
      .find(".fa-angle-right")
      .removeClass("fa-angle-right")
      .addClass("fa-angle-down");
  })
    .on('hidden.bs.collapse', function (e) {
      let clicked = $(document).find(`[href='#${$(e.target).attr('id')}']`);

      clicked
        .parent()
        .find(".fa-angle-down")
        .removeClass("fa-angle-down")
        .addClass("fa-angle-right");
    });

  async function RetornaEmpresas() {
    let _url = `/sisplan/funcoes/v1/pesquisa?`;
    let _params = `JSON={"tabela":"empresa", "camposSelect":[ "Replace(emp_pat,'_','') emp_pat", "emp_nome"], "where": null}`;

    try {
      let response = await requisicao('GET', _url, _params, null);

      if (!response) {
        return '';
      }

      let jsonStr = await response.json();
      if (response.status != 200) {
        msgErro(jsonStr.RESULT[0].mensagem);
        return '';
      }

      const arrDados = jsonStr.RESULT[0];
      return arrDados;
    } catch (error) {
      console.error(error);
      msgErro('Não foi possível buscar as empresas.');
      return '';
    }
  }

});