$(document).ready(async function () {

  $('#tutorial').on('click', function () {
    $(document).ready(async function () {
      const driver = new Driver({
        doneBtnText: 'Sair',
        closeBtnText: 'Fechar',
        nextBtnText: 'Próximo',
        prevBtnText: 'Anterior',
        allowClose: false
      });
      driver.defineSteps([{
        element: '#btnFiltros',
        popover: {
          title: 'Botão Filtros',
          description: 'Clique aqui para abrir os filtros e realizar uma consulta.',
          position: 'right'
        }
      },
      {
        element: '#btnImprimir',
        popover: {
          title: 'Botão Imprimir',
          description: 'Clique aqui para imprimir um relatório.',
          position: 'right'
        }
      },
      {
        element: '#divTabelaVendas',
        popover: {
          title: 'Tabela Receber',
          description: 'Aqui, após clicar em consultar ficam os dados das duplicatas filtradas.',
          position: 'bottom'
        }
      }
      ]);
      driver.start();
    });
  });

  let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

  // aqui so valida se nao existe tem que criar para nao dar erro
  if (colunas == null || colunas.relReceber == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, relReceber: [] }));
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
  }

  // confirma as colunas
  $('#btnConfirmarColunas').on('click', async function () {
    try {
      $.LoadingOverlay('show');

      const novasColunas = retornaNovasColunasInvisiveis();
      localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, relReceber: novasColunas }))

      $('#tabelaRelReceber').DataTable().columns().visible(true);
      // $('#tabelaPrecosProduto').DataTable().columns(novasColunas).visible(false);

      $('#tabelaRelReceber').DataTable().columns().every(
        function () {
          if ((novasColunas).indexOf(this.dataSrc()) != -1) {
            this.visible(false);
          }
        })

    } finally {
      $.LoadingOverlay('hide');
      $('#modal-ColunasVisiveis').modal('hide');
    }
  })

  await preencheOrdenacaoTela('RelReceber');

  $('#txtOrdem').val('3');

  componenteFiltro('classe', true);
  componenteFiltro('banco', true);
  componenteFiltro('situacao', true);
  componenteFiltro('historico', true);
  componenteFiltro('conta', true);

  $('#txtClasse').autocompleta(1, `JSON={ "tabela":"classe_ger", "camposSelect":[ "codigo chave", "descricao"], "where": null}`);
  $('#txtClienteConsulta').autocompleta(3, `JSON={ "tabela":"entidade", "camposSelect":[ "codcli chave", "nome descricao"], "where": null}`);
  $('#txtRepresentanteConsulta').autocompleta(3, `JSON={ "tabela":"represen", "camposSelect":[ "codrep chave", "nome descricao"], "where":["ativo = 'S'"]}`);
  $('#txtMoeda').autocompleta(1, `JSON={ "tabela":"moeda", "camposSelect":[ "codmoe chave", "descricao descricao"], "where": null}`);
  $('#txtCaixa').autocompleta(1, `JSON={ "tabela":"caixa_loja", "camposSelect":[ "codigo CHAVE", "descricao"], "where": null}`);
  $('#txtHistorico').autocompleta(1, `JSON={ "tabela":"histcp", "camposSelect":[ "historico chave", "descricao descricao"], "where": null}`);

  $('#btn-Classe').pesquisa('#txtClasse', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"classe_ger", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa Classe', 'classe_ger');
  $('#btn-ClienteConsulta').pesquisa_serverside(['#txtClienteConsulta'], ['CODCLI'], ['NOME'], '{"tabela":"entidade", "camposSelect":[ "CODCLI", "NOME"], "where": null}', 'Pesquisa Cliente');

  $('#btn-RepresentanteConsulta').pesquisa_array(['#txtRepresentanteConsulta'], ['CODREP'], ['NOME'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"represen", "camposSelect":[ "codrep", "nome"], "where": ["ativo = 'S'"]}`, 'Pesquisa Representante', 'represen');
  $('#btnConsultaMoeda').pesquisa('#txtMoeda', 'CODMOE', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"MOEDA", "camposSelect":[ "CODMOE", "descricao"]}', 'Pesquisa Moeda', 'MOEDA');
  $('#btnCaixa').pesquisa('#txtCaixa', 'CODIGO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CAIXA_LOJA", "camposSelect":[ "CODIGO", "descricao"]}', 'Pesquisa Tabela', 'CAIXA_LOJA');
  $('#btn-Historico').pesquisa('#txtHistorico', 'HISTORICO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"histcp", "camposSelect":[ "historico", "descricao"]}`, 'Pesquisa Histórico', 'histcp');

  $('#btn-limpa-Historico').on('click', function () {
    $('#txtHistorico').val('');
  });

  $('#btn-limpa-Classe').on('click', function () {
    $('#txtClasse').val('');
  });

  $('#btn-limpa-Caixa').on('click', function () {
    $('#txtCaixa').val('');
  });

  $('#btn-limpa-ClienteConsulta').on('click', function () {
    $('#txtClienteConsulta').val('');
  });
  $('#btnLimpaMoeda').on('click', function () {
    $('#txtMoeda').val('');
  });
  $('#btn-limpa-RepresentanteConsulta').on('click', function () {
    $('#txtRepresentanteConsulta').val('');
  });

  $('#btnFiltros').on('click', async function () {
    $('#modal-filtros').modal('show');
  });

  if (await apenasClientesVinculadosAoRepresentante()) {
    bloqueiaFiltroEPreencheValorRepresentante('#txtRepresentanteConsulta', '#btn-RepresentanteConsulta', '#btn-limpa-RepresentanteConsulta');
  }

  $('#btnLimparFiltros').on('click', async function () {
    $('#txtNumero').val('');
    $('#txtFatura').val('');
    $('#txtClienteConsulta').val('');
    if (!$('#txtRepresentanteConsulta').attr('disabled')) {
      $("#txtRepresentanteConsulta").val("");
    }
    $('#txtDataEmiI').val('1200-01-01');
    $('#txtDataEmiF').val('2500-12-31');
    $('#txtVenctoI').val('1200-01-01');
    $('#txtVenctoF').val('2500-12-31');
    $('#Status').val('');
    $('#slSituacao').val('Todos');
    $('#txtMoeda').val('');
    $('#txtClasse').empty().trigger('change');
    $('#txtBanco').empty().trigger('change');
    $('#txtSituacao').empty().trigger('change');
    $('#txtHistorico').empty().trigger('change');
  });

  $('#btnSelecionarEmpresas').on('click', function () {
    carregaEmpresasDisponiveis();
  });

  async function retornaFiltros() {
    const sClasse = await formataListas($('#txtClasse').val().toString());
    const sBanco = await formataListas($('#txtBanco').val().toString());
    const sSituacao = await formataListas($('#txtSituacao').val().toString());
    const sHistorico = await formataListas($('#txtHistorico').val().toString());
    const sConta = await formataListas($('#txtConta').val().toString());
    const sNumero = $('#txtNumero').val();
    const sFatura = $('#txtFatura').val();
    const sDataEmiI = $('#txtDataEmiI').val();
    const sDataEmiF = $('#txtDataEmiF').val();
    const sDataVenctoI = $('#txtVenctoI').val();
    const sDataVenctoF = $('#txtVenctoF').val();
    const sCliente = pegaChave('#txtClienteConsulta');
    const sRepresentante = pegaChave('#txtRepresentanteConsulta');
    const sStatus = $('#Status').val();
    const sSelSituacao = $('#slSituacao').val();
    const sMoeda = pegaChave('#txtMoeda');
    const sEmp = $('.empresa_selecionada:checked').toArray().length > 0 ? $('.empresa_selecionada:checked').toArray().map(input => input.id.substring(input.id.indexOf('-') + 1, input.id.length))
      : getCookie('emp_id');
    const retorno = `NUMERO=${sNumero}` +
      `&FATURA=${sFatura}` +
      `&DTEMISSAOI=${sDataEmiI}` +
      `&DTEMISSAOF=${sDataEmiF}` +
      `&DTVENCIMENTOI=${sDataVenctoI}` +
      `&DTVENCIMENTOF=${sDataVenctoF}` +
      `&STATUS=${sStatus}` +
      `&CLIENTE=${sCliente}` +
      `&REPRESENTANTE=${sRepresentante}` +
      `&SELSITUACAO=${sSelSituacao}` +
      `&MOEDA=${sMoeda}` +
      `&CLASSE=${sClasse}` +
      `&BANCO=${sBanco}` +
      `&SITUACAO=${sSituacao}` +
      `&HISTORICO=${sHistorico}` +
      `&CONTA=${sConta}` +
      `&EMPRESAS_FILTRO=${sEmp}`;
    return retorno;
  }

  retornaHintRelatorio('btnImprimir', 'RelReceber')

  $('#btnImprimir').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      try {
        const url = `/sisplan/impressao/v1/relreceber?`;
        const filtros = await retornaFiltros();
        const ordem = `&TELA_ORDENACAO=RelReceber&ORDEM_ORDENACAO=${$('#txtOrdem').val()}`;
        const bImprimeAutomatico = await verificaImprimirAutomatico('RelReceber');
        const arquivo = await GeraRelatorio(`${url}${filtros}${ordem}&`, 'GET', 100000, false, 'RelReceber');
        if (arquivo != undefined) {
          if (!bImprimeAutomatico) {
            window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
          }
          await limparRelatorios();
        }

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $('#btnConsultar').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      if ($("#txtOrdem option").toArray().lenght > 0) {
        retornaHintRelatorio('btnImprimir', $("#txtOrdem option").toArray().map(map => { return [map.selected, $(map).attr('nome_prt')] }).filter(filter => filter[0] == true)[0][1])
      }
      try {
        let dataSetCols = [];

        const url = '/sisplan/impressao/v1/consultarelreceber?';
        const filtros = await retornaFiltros();
        const response = await requisicao('GET', url, filtros,
          null
        );

        if (!response) {
          return;
        }

        const jsonStr = await response.json();

        if (jsonStr.length == 0) {
          msgAlerta('Nenhum registro encontrado!');
          $('#txtDataEmiI').val('1200-01-01');
          $('#txtDataEmiF').val('2500-12-31');
          $('#txtVenctoI').val('1200-01-01');
          $('#txtVenctoF').val('2500-12-31');
          $('#txtClienteConsulta').val('');
          $('#txtRepresentanteConsulta').val('');
          $('#Status').val('');
          $('#txtClasse').empty().trigger('change');
          $('#txtBanco').empty().trigger('change');
          $('#txtSituacao').empty().trigger('change');
          $('#txtHistorico').empty().trigger('change');
          $(`#tabelaRelReceber`).DataTable().clear().draw(false);
          return;
        }

        if (response.status != 200) {
          console.error(jsonStr.mensagem);
          return;
        }

        let keys = Object.keys(jsonStr[0]);

        keys.forEach(k => {
          dataSetCols.push({
            'title': k,
            'data': k
          });
        });

        $('#tabelaRelReceber').DataTable({
          destroy: true,
          colReorder: true,
          filter: false,
          language: {
            sEmptyTable: 'Nenhum registro encontrado',
            sInfo: '_TOTAL_ registros',
            sInfoEmpty: ' 0 registros',
            sInfoFiltered: '(Filtrados de _MAX_ registros)',
            sInfoPostFix: '',
            sInfoThousands: '.',
            sLengthMenu: '_MENU_ resultados',
            sLoadingRecords: 'Carregando...',
            sProcessing: 'Processando...',
            sZeroRecords: 'Nenhum registro encontrado',
            sSearch: 'Pesquisar',
            oPaginate: {
              sNext: 'Próximo',
              sPrevious: 'Anterior',
              sFirst: 'Primeiro',
              sLast: 'Último',
            },
            oAria: {
              sSortAscending: ': Ordenar colunas de forma ascendente',
              sSortDescending: ': Ordenar colunas de forma descendente',
            },
          },
          autoWidth: true,
          "data": jsonStr,
          "columns": dataSetCols,
          columnDefs: [
            {
              "render": function (data) {
                return parseFloat(data).toLocaleString('pt-BR', {
                  maximumFractionDigits: 2,
                  minimumFractionDigits: 2
                });
              },
              "targets": [7, 8, 9, 10, 11, 12, 23],
              "className": 'pr-4 text-right'
            },
            {
              "targets": 6,
              "visible": false,
            },
            {
              targets: [4, 5],
              type: "date-br",
              render(data) {
                if (data) {
                  return new Intl.DateTimeFormat("pt-BR").format(
                    new Date(`${data.split(" ")[0]} 23:59:59`)
                  );
                } else {
                  return ''
                }
              },
            }
          ],
        });

        const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

        $('#tabelaRelReceber_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
        $('#tabelaRelReceber_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');

        $('#buttonColVis').prop('title', 'Configurar colunas visíveis')
        $('#buttonExcel').prop('title', 'Exportar')

        $('#buttonColVis').on('click', async function () {
          $.LoadingOverlay('show');
          $('#modal-ColunasVisiveis').modal('show');
          $.LoadingOverlay('hide');
        });

        $('#buttonExcel').on('click', async function () {
          const url = '/sisplan/impressao/v1/consultarelreceber?';
          const filtros = await retornaFiltros();
          await exportaCSV(url, filtros, false, null, 'Relatório de Contas a Receber', '#tabelaRelReceber');
        })


        $('#tabelaRelReceber').DataTable().columns().every(
          function () {
            if ((colunasInvisiveis.relReceber).indexOf(this.dataSrc()) != -1) {
              this.visible(false);
            }
          })

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
      $('#modal-filtros').modal('hide');
    }
  });

  $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
    const cols = [];

    let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

    $('#tabelaRelReceber').DataTable().columns().every(function () {
      cols.push({
        'title': $(this.header()).text(),
        'data': this.dataSrc()
      })
    });

    adicionaColunas(cols, colunasInvisiveis.relReceber ?? [])
  });
});