<?php include_once('../../../config.php') ?>

<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Sisplan Web | Relatório de Bloqueto</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="stylesheet" href="../dist/css/adminlte.min.css?versao=3.2410.16.2">
    <link rel="stylesheet" href="../plugins/fontawesome-free/css/all.min.css?versao=3.2410.16.2">
    <link href='https://fonts.googleapis.com/css?family=Roboto:400,300,500,600,700,400italic' rel='stylesheet' type='text/css'>
    <link rel="stylesheet" type="text/css" href="../dist/css/dataTables.bootstrap4.min.css?versao=3.2410.16.2" />
    <link href='../dist/css/bootstrap.min.css?versao=3.2410.16.2'>
    <link rel="stylesheet" href="../dist/css/custom.css?versao=3.2410.16.2">
    <link rel="stylesheet" href="../dist/css/sisplan.css?versao=3.2410.16.2">
    <link rel="stylesheet" href="../dist/css/PesquisaVariosSelect2.css?versao=3.2410.16.2">
    <link rel="stylesheet" href="../plugins/icheck-bootstrap/icheck-bootstrap.min.css?versao=3.2410.16.2">
    <link rel="stylesheet" type="text/css" href="../plugins/datatables-keytable/css/keyTable.bootstrap4.min.css?versao=3.2410.16.2">
    <link rel="stylesheet" type="text/css" href="../dist/css/responsive.bootstrap.min.css?versao=3.2410.16.2">
    <link rel="stylesheet" href="../plugins/select2/css/select2.min.css?versao=3.2410.16.2">
    <link rel="stylesheet" href="../plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css?versao=3.2410.16.2">
    <link rel="shortcut icon" href="../favicon.ico">
    <link rel="stylesheet" href="../dist/css/cadastro.css?versao=3.2410.16.2">
    <link rel="stylesheet" href="../plugins/toastr/toastr.min.css?versao=3.2410.16.2">
    <link rel="stylesheet" type="text/css" href="../dist/css/driver.min.css?versao=3.2410.16.2" />
    <link rel="stylesheet" href="../dist/css/jquery-ui.css?versao=3.2410.16.2">
    <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">

    <style>
        .bordaCampos {
            border: solid #e0e4e6;
            border-radius: 4px;
            border-width: 2px;
            padding-top: 2%;
            padding-bottom: 0%;
        }

        .bordaCampos:first-child {
            display: flex;
            flex-direction: row;
            flex-wrap: wrap;
            justify-content: flex-end;
            align-items: center;
        }

        .border-Field .textoBorda {
            font-size: 1.0em !important;
            text-align: left !important;
            width: auto;
            padding: 0 10px;
            border-bottom: none;
        }

        .border-Field {
            border: 1.0px solid var(--font-color) !important;
            padding: 0 1.0em 1.0em 1.0em !important;
            margin: 0 0 1.0em 0 !important;
            -webkit-box-shadow: 0px 0px 0px 0px #000;
            box-shadow: 0px 0px 0px 0px #000;
            padding-bottom: 0px !important;
        }

        .form-control:disabled,
        .form-control[readonly] {
            background-color: #f7f7f7;
            opacity: 1;
        }

        #msform {
            text-align: start;
            position: relative;
        }

        .card {
            box-shadow: none !important;
            border-radius: 0 !important;
            margin-bottom: 0 !important;
        }

        .card-header {
            box-shadow: 0px 1px rgb(0 0 0 / 20%) !important;
        }

        .card.card-header {
            border-bottom: 1px dashed #ddd;
            box-shadow: none !important;
        }

        .card-body {
            padding-left: 1.25rem !important;
            padding-top: 0px;
            padding-bottom: 0px;
            padding-right: 1.25rem !important;
        }

        .fa-angle-right,
        .fa-angle-down {
            color: #343a40;
        }

        .btnFecharModal {
            font-size: 15px;
            background-color: #616161 !important;
            border-color: #616161 !important;
        }

        .btnFecharModal:hover {
            box-shadow: 0 0 0 2px white, 0 0 0 3px #616161;
            background-color: #000000 !important;
        }

        .btnGravarModal:hover {
            box-shadow: 0 0 0 2px white, 0 0 0 3px var(--primary-color);
            background-color: #ee5555 !important;
        }

        .header-content-page .title-page,
        .title-content-page .title,
        .title-page {
            font-size: 20px;
            line-height: normal;
            font-weight: 500;
            color: var(--font-color);
            margin: 0;
            font-family: Roboto, Arial, sans-serif;
        }

        .border-Field .textoBorda {
            font-size: 1.1em !important;
            text-align: left !important;
            width: auto;
            padding: 5px 10px;
            border-bottom: none;
        }

        .border-Field {
            border: 1px solid var(--font-color) !important;
            padding: 0 1.0em 0 1.0em !important;
            margin: 0 0 0 0 !important;
            -webkit-box-shadow: 0px 0px 0px 0px #000;
            box-shadow: 0px 0px 0px 0px #000;
            border-radius: 3px !important;
        }

        td {
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis;
        }

        @media (max-width: 1194.8px) {
            .centralizaBotao {
                text-align: center;
            }
        }

        /* Estilo para telas maiores ou iguais a 992px (telas lg e maiores) */
        @media (min-width: 1195px) {
            .centralizaBotao {
                text-align: start;
            }
        }
    </style>
</head>

<body class="hold-transition sidebar-mini layout-fixed">
    <div class="wrapper">
        <?php
        include_once('../../../menu.php');
        ?>
        <div id="myModal" class="modal" tabindex="-1" role="dialog">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 id="myModalLabel" class="modal-title"></h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <p id="myModalText"></p>
                    </div>
                    <div class="modal-footer">
                        <button id="btnYes" type="button" class="btn btn-primary">Sim</button>
                        <button id="btnNo" type="button" class="btn btn-secondary" data-dismiss="modal">Não</button>
                    </div>
                </div>
            </div>
        </div>

        <div class="wrapper">
            <div id="myModal" class="modal" tabindex="-1" role="dialog">
                <div class="modal-dialog" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 id="myModalLabel" class="modal-title"></h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <div class="modal-body">
                            <p id="myModalText"></p>
                        </div>
                        <div class="modal-footer">
                            <button id="btnYes" type="button" class="btn btn-primary">Sim</button>
                            <button id="btnNo" type="button" class="btn btn-secondary" data-dismiss="modal">Não</button>
                        </div>
                    </div>
                </div>
            </div>
            <div class="content-wrapper">
                <div class="content-header">
                    <div class="container-fluid">
                        <div class="row mb-2">
                            <div class="col-sm-6 col-12">
                            </div><!-- /.col -->
                            <div class="col-sm-6 col-12">
                            </div><!-- /.col -->
                        </div><!-- /.row -->
                    </div>
                </div>
                <section class="content">
                    <div class="container-fluid">
                        <div class="row">
                            <div class="col-12">
                                <div class="card" style="height:auto;min-height:715px">
                                    <div class="card-header text-center flex" style="border: none!important;box-shadow:none!important;">
                                        <h2 class="m-0">Relatório de Bloqueto</h2>
                                        <button title="Tutorial" class="mt-2 btn btn-info btn-sm ml-2" id="tutorial">
                                            <i class="fas fa-question-circle"></i>
                                        </button>
                                    </div>
                                    <fieldset>
                                        <div class="card-body">
                                            <form style="text-align:left!important;" id="msform" name="msform">
                                                <div class="card card-header" role="tab" id="geral">
                                                    <a style="width:100%;" data-toggle="collapse" data-parent="#multiCollapseExample1" href="#multiCollapseExample1" aria-expanded="true" aria-controls="collapseOne1">
                                                        <div class="row">
                                                            <div style="max-width:20px;margin-top:auto; margin-bottom: auto" class="col-1">
                                                                <i class="fas fa-angle-down"></i>
                                                            </div>
                                                            <div class="col-11">
                                                                <h4 class="title-page">
                                                                    Geral
                                                                </h4>
                                                            </div>
                                                        </div>
                                                    </a>
                                                </div>
                                                <div class="collapse  show" id="multiCollapseExample1">
                                                    <div class="card card-body mt-2">
                                                        <div class=" tab-pane fade show active" role="tabpanel" aria-labelledby="geral-tab">
                                                            <div class="col-md-9 col-sm-12 col-9 p-0">
                                                                <div class="row col-12 col-sm-12 col-md-12 pr-0">
                                                                    <div class="col-md-10 col-10 col-sm-12 form-group">
                                                                        <label data-error="wrong" class="labelGeral" data-success="right" for="txtConta">Conta: </label>
                                                                        <div class="input-group">
                                                                            <input type="text" class="input-default focus form-control" id="txtConta" name="txtConta" placeholder="Conta">
                                                                            <div class="input-group-append">
                                                                                <button class="btn btn-sisp bg-danger" id="btnConta" name="btnConta" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                                                <button class="btn btn-sisp bg-danger" id="btnAConta" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                    <div class="col-md-2 col-2 col-sm-12 form-group p-0" style="margin-bottom: 0px !important">
                                                                        <label data-error="wrong" class="labelGeral" data-success="right" for="rgCarteira">Carteira: </label>
                                                                        <div class="input-group">
                                                                            <select id="rgCarteira" class="input-default focus custom-select">

                                                                            </select>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="row col-12 col-sm-12 col-md-12 pr-0">
                                                                    <div class="col-md-5 col-5 col-sm-12 form-group">
                                                                        <label data-error="wrong" class="labelGeral" data-success="right" for="txtBanco">Banco: </label>
                                                                        <div class="input-group">
                                                                            <input type="text" class="input-default focus form-control" disabled id="txtBanco" name="txtBanco" placeholder="Banco">
                                                                        </div>
                                                                    </div>
                                                                    <div class="col-md-2 col-2 col-sm-12 form-group pl-0" style="margin-bottom: 0px !important">
                                                                        <label data-error="wrong" class="labelGeral" data-success="right" for="rgLayout">Layout: </label>
                                                                        <div class="input-group">
                                                                            <select id="rgLayout" class="input-default focus custom-select">
                                                                                <option value="0">Pré-Impresso</option>
                                                                                <option value="1" selected>Padrão</option>
                                                                                <option value="2">Personalizado</option>
                                                                                <option value="3">Dois Boletos</option>
                                                                            </select>
                                                                        </div>
                                                                    </div>
                                                                    <div class="col-md-5 col-5 col-sm-12 form-group p-0">
                                                                        <label data-error="wrong" class="labelGeral" data-success="right" for="txtAcrescimo">Acréscimo: </label>
                                                                        <div class="input-group">
                                                                            <input type="text" class="input-default focus form-control" id="txtAcrescimo" name="txtAcrescimo" placeholder="Acréscimo">
                                                                            <div class="input-group-append">
                                                                                <button class="btn btn-sisp bg-danger" id="btnAcrescimo" title="Ao clicar será adicionado ao valor da duplicata o valor inserido em acrescimo." name="btnAcrescimo" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-check"></i></button>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="row col-12 col-sm-12 col-md-12 pr-0">
                                                                    <div class="col-md-10 col-10 col-sm-12 form-group pr-0">
                                                                        <label data-error="wrong" class="labelGeral" data-success="right" for="txtLocalPagamento">Local Pagamento: </label>
                                                                        <div class="input-group">
                                                                            <input type="text" class="input-default focus form-control" id="txtLocalPagamento" value="PAGAVEL EM QUALQUER AGENCIA BANCARIA ATE O VENCIMENTO" name="txtLocalPagamento" placeholder="Local Pagamento">
                                                                        </div>
                                                                    </div>
                                                                    <div class="col-md-2 col-2 col-sm-12 form-group pr-0">
                                                                        <label data-error="wrong" class="labelGeral" data-success="right" for="txtContaPagador">Conta Pagador: </label>
                                                                        <div class="input-group">
                                                                            <input type="number" class="input-default focus form-control" id="txtContaPagador" name="txtContaPagador" placeholder="Conta Pagador">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="row col-12 col-sm-12 col-md-12 pr-0">
                                                                    <div class="col-md-4 col-4 col-sm-12 form-group pr-0">
                                                                        <label data-error="wrong" class="labelGeral" data-success="right" for="txtInstrucao1">Instrução 1 Carteira: </label>
                                                                        <div class="input-group">
                                                                            <input type="text" class="input-default focus form-control" id="txtInstrucao1" name="txtInstrucao1" placeholder="Instrução 1 Carteira">
                                                                        </div>
                                                                    </div>
                                                                    <div class="col-md-4 col-4 col-sm-12 form-group pr-0">
                                                                        <label data-error="wrong" class="labelGeral" data-success="right" for="txtInstrucao2">Instrução 2 Carteira: </label>
                                                                        <div class="input-group">
                                                                            <input type="text" class="input-default focus form-control" id="txtInstrucao2" name="txtInstrucao2" placeholder="Instrução 2 Carteira">
                                                                        </div>
                                                                    </div>
                                                                    <div class="col-md-4 col-4 col-sm-12 form-group pr-0">
                                                                        <label data-error="wrong" class="labelGeral" data-success="right" for="txtInstrucao3">Instrução 3: </label>
                                                                        <div class="input-group">
                                                                            <input type="text" class="input-default focus form-control" id="txtInstrucao3" name="txtInstrucao3" placeholder="Instrução 3">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="row col-12 col-sm-12 col-md-12 pr-0">
                                                                    <div class="col-md-4 col-4 col-sm-12 form-group pr-0">
                                                                        <label data-error="wrong" class="labelGeral" data-success="right" for="txtInstrucao4">Instrução 4: </label>
                                                                        <div class="input-group">
                                                                            <input type="text" class="input-default focus form-control" id="txtInstrucao4" name="txtInstrucao4" placeholder="Instrução 4">
                                                                        </div>
                                                                    </div>
                                                                    <div class="col-md-2 col-2 col-sm-12 form-group pr-0">
                                                                        <label data-error="wrong" class="labelGeral" data-success="right" for="txtTaxaAcrescimo">Taxa Acréscimo: </label>
                                                                        <div class="input-group">
                                                                            <input type="text" class="input-default focus form-control" id="txtTaxaAcrescimo" name="txtTaxaAcrescimo" placeholder="Taxa Acréscimo">
                                                                        </div>
                                                                    </div>
                                                                    <div class="col-md-2 col-2 col-sm-12 form-group pr-0">
                                                                        <label data-error="wrong" class="labelGeral" data-success="right" for="txtMultaAtraso">% Multa Atraso: </label>
                                                                        <div class="input-group">
                                                                            <input type="text" class="input-default focus form-control" id="txtMultaAtraso" name="txtMultaAtraso" placeholder="% Multa Atraso">
                                                                        </div>
                                                                    </div>
                                                                    <div class="col-md-2 col-2 col-sm-12 form-group pr-0">
                                                                        <label data-error="wrong" class="labelGeral" data-success="right" for="txtProtestar">Protestar após(dias): </label>
                                                                        <div class="input-group">
                                                                            <input type="number" class="input-default focus form-control" id="txtProtestar" name="txtProtestar" placeholder="Protestar após(dias)">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-3 p-0">
                                                                <div class="col-md-12 col-12 col-sm-12 form-group">
                                                                    <fieldset class="form border-Field">
                                                                        <legend class="textoBorda pb-0 mb-0">Opções</legend>
                                                                        <div class="icheck-primary col-12 col-sm-12 col-md-12">
                                                                            <input type="checkbox" value="" id="cbNossoNumero">
                                                                            <label class="labelCheck" for="cbNossoNumero">Gerar Nosso Número</label>
                                                                        </div>
                                                                        <div class="icheck-primary col-12 col-sm-12 col-md-12">
                                                                            <input type="checkbox" value="" checked id="cbProtesto1">
                                                                            <label class="labelCheck" for="cbProtesto1">Inst. de Protesto 1</label>
                                                                        </div>
                                                                        <div class="icheck-primary col-12 col-sm-12 col-md-12">
                                                                            <input type="checkbox" value="" checked id="cbProtesto2">
                                                                            <label class="labelCheck" for="cbProtesto2">Inst. de Protesto 2</label>
                                                                        </div>
                                                                        <!-- <div class="icheck-primary col-12 col-sm-12 col-md-12">
                                                                            <input type="checkbox" value="" id="cbObsDup">
                                                                            <label class="labelCheck" for="cbObsDup">Obs da Dup.</label>
                                                                        </div>
                                                                        <div class="icheck-primary col-12 col-sm-12 col-md-12">
                                                                            <input type="checkbox" value="" id="cbObsGrid">
                                                                            <label class="labelCheck" for="cbObsGrid">Usar Obs do Grid.</label>
                                                                        </div>
                                                                        <div class="icheck-primary col-12 col-sm-12 col-md-12">
                                                                            <input type="checkbox" value="" id="cbLocalPgto">
                                                                            <label class="labelCheck" for="cbLocalPgto">Usar Local de Pgto.</label>
                                                                        </div> -->
                                                                        <div class="icheck-primary col-12 col-sm-12 col-md-12">
                                                                            <input type="checkbox" disabled value="" id="cbLayoutGrafico">
                                                                            <label class="labelCheck" for="cbLayoutGrafico">Gerar Layout Gráfico</label>
                                                                        </div>
                                                                        <!-- <div class="icheck-primary col-12 col-sm-12 col-md-12">
                                                                            <input type="checkbox" value="" disabled id="cbFdic">
                                                                            <label class="labelCheck" for="cbFdic">FDIC</label>
                                                                        </div> -->
                                                                        <div class="icheck-primary col-12 col-sm-12 col-md-12">
                                                                            <input type="checkbox" value="" id="cbAtualizaValor">
                                                                            <label class="labelCheck" for="cbAtualizaValor">Atualiza Valor Dup.</label>
                                                                        </div>
                                                                        <div class="icheck-primary col-12 col-sm-12 col-md-12 d-none">
                                                                            <input type="checkbox" value="" id="cbCalcular">
                                                                            <label class="labelCheck" for="cbCalcular">Calcular(não vencidas)</label>
                                                                        </div>
                                                                        <div class="icheck-primary col-12 col-sm-12 col-md-12 d-none">
                                                                            <input type="checkbox" value="" id="cbModoDiasUteis">
                                                                            <label class="labelCheck" for="cbModoDiasUteis">Dias Úteis para protestar</label>
                                                                        </div>
                                                                        <div class="icheck-primary col-12 col-sm-12 col-md-12">
                                                                            <input type="checkbox" value="" id="cbAtualizarVencimento">
                                                                            <label class="labelCheck" for="cbAtualizarVencimento">Atualizar Vencimento</label>
                                                                        </div>
                                                                        <div class="col-12 col-sm-12 col-md-7 mb-2 d-none">
                                                                            <input type="date" max="2500-12-31" value="1200-01-01" class="input-default focus form-control" id="dtNovoVencimento" name="dtNovoVencimento" class="form-control">
                                                                        </div>
                                                                    </fieldset>
                                                                </div>
                                                                <div class="col-md-12 col-12 col-sm-12 form-group" id="divAmbiente">
                                                                    <label data-error="wrong" class="labelGeral" data-success="right" for="selectAmbiente">Ambiente:</label>
                                                                    <div class="input-group">
                                                                        <select class="input-default focus form-control" data-dropdown-css-class="select2-danger" id="selectAmbiente" aria-describedby="tipoError" class="custom-select focus">
                                                                            <option selected value="1">Homologação</option>
                                                                            <option value="2">Produção</option>
                                                                        </select>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row col-12 col-sm-12 col-md-12 pr-0">
                                                                <div class="col-md-12 col-12 col-sm-12 form-group pr-0">
                                                                    <label data-error="wrong" class="labelGeral" data-success="right" for="txtObs">Observação:</label>
                                                                    <div class="input-group">
                                                                        <textarea class="input-default focus form-control create" id="txtObs" name="txtObs" placeholder="Observação" rows="4" cols="50" style="resize: none;"></textarea>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="card card-header" role="tab" id="duplicatas">
                                                    <a style="width:100%;" data-toggle="collapse" data-parent="#multiCollapseExample2" href="#multiCollapseExample2" aria-expanded="true" aria-controls="collapseOne1">
                                                        <div class="row">
                                                            <div style="max-width:20px;margin-top:auto; margin-bottom: auto" class="col-1">
                                                                <i class="fas fa-angle-right"></i>
                                                            </div>
                                                            <div class="col-11">
                                                                <h4 class="title-page">
                                                                    Duplicatas
                                                                </h4>
                                                            </div>
                                                        </div>
                                                    </a>
                                                </div>

                                                <div class="collapse" id="multiCollapseExample2">
                                                    <div class="card card-body mt-2">
                                                        <div class="tab-pane fade show active" role="tabpanel" aria-labelledby="duplicatas-tab">
                                                            <div class="row col-12 col-sm-12 col-md-12 pr-0">
                                                                <div class="col-sm-12 table-responsive card-body">
                                                                    <table id="tabelaDuplicatas" class="table table-sm table-select table-hover" style="white-space: nowrap;" width="100%"></table>
                                                                    <thead>
                                                                        <tr></tr>
                                                                    </thead>
                                                                    <tbody>
                                                                        <tr></tr>
                                                                    </tbody>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <!-- cabo os panel -->
                                                <button type="button" id="btnVoltar" style="font-size:15px;" class="btn-sisp action-button-previous" data-dismiss="modal">Voltar</button>
                                                <button type="button" id="btnImprimir" style="font-size:15px; background-color: var(--btn-hover) !important;" class="action-button btn-sisp btn-success" data-dismiss="modal">Imprimir</button>
                                                <button type="button" id="btnVoltarTodas" style="font-size:15px;" class="action-button btn-sisp btn-danger" data-dismiss="modal">Voltar Todas</button>
                                                <button type="button" id="btnVoltarDup" style="font-size:15px; background-color: #0069d9 !important;" class="action-button btn-sisp btn-primary" data-dismiss="modal">Voltar Dup.</button>
                                                <button type="button" id="btnRecalcular" style="font-size:15px; background-color:#25d366 !important;" class="action-button btn-sisp btn-primary" data-dismiss="modal">Recalcular</button>
                                                <button type="button" id="btnBuscarInf" style="font-size:15px;" class="btn-sisp action-button-previous" data-dismiss="modal">Busca Inf.</button>
                                                <button type="button" id="btnIntegrar" style="font-size:15px;" class="btn-sisp action-button-previous" data-dismiss="modal">Integrar</button>
                                            </form>
                                        </div>
                                    </fieldset>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
            </div>
        </div>
        <div id="modal-alterarBanco" class="modal" tabindex="-1" role="dialog">
            <div class="modal-dialog modal-lg" role="document">
                <div class="modal-content" id="modalBody">
                    <div class="modal-header">
                        <h4 class="modal-title">Alterar Banco</h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-md-3 col-3 col-sm-12 form-group" id="containerDuplicata">
                                <label data-error="wrong" class="labelGeral" data-success="right" for="txtDuplicataBanco">Duplicata: </label>
                                <div class="input-group">
                                    <input type="text" class="input-default focus form-control" id="txtDuplicataBanco" disabled name="txtDuplicataBanco" placeholder="Duplicata">
                                </div>
                            </div>
                            <div class="col-md-9 col-9 col-sm-12 form-group" id="containerBanco">
                                <label data-error="wrong" class="labelGeral" data-success="right" for="txtAlterarBanco">Banco: </label>
                                <div class="input-group">
                                    <input type="text" class="input-default focus form-control" id="txtAlterarBanco" name="txtAlterarBanco" placeholder="Banco">
                                    <div class="input-group-append">
                                        <button class="btn btn-sisp bg-danger" id="btnAlterarBanco" name="btnAlterarBanco" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                        <button class="btn btn-sisp bg-danger" id="btnAAlterarBanco" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <div class="row">
                            <button class="btn btn-danger btn-sisp mr-2 btnFecharModal" data-dismiss="modal" id="btnFecharBanco">Fechar</button>
                            <button class="btn btn-danger btn-sisp btnGravarModal" id="btnGravarBanco">Gravar</button>
                            <button class="btn btn-danger btn-sisp d-none btnGravarModal" id="btnGravarTodosBancos">Gravar</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div id="modalAlterarDuplicata" class="modal" tabindex="-1" role="dialog">
            <div class="modal-dialog modal-xl" role="document">
                <div class="modal-content" id="modalBody">
                    <div class="modal-header">
                        <h4 class="modal-title">Alterar Duplicata</h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-md-2 col-sm-4 col-12" id="panelDuplicata">
                                <label data-error="wrong" class="labelGeral" data-success="right" for="txtDuplicataDup">Duplicata: </label>
                                <div class="input-group">
                                    <input type="text" class="input-default focus form-control" id="txtDuplicataDup" disabled name="txtDuplicataDup" placeholder="Duplicata">
                                </div>
                            </div>
                            <div class="col-md-4 col-sm-8 col-12 p-0" id="panelEmissaoVencto">
                                <div class="col-md-6 col-sm-6 col-6">
                                    <label data-error="wrong" data-success="right" for="dtEmissaoDup">Emissão </label>
                                    <div class="relative">
                                        <div class="input-group">
                                            <input type="date" max="2500-12-31" class="input-default focus form-control" id="dtEmissaoDup" name="dtEmissaoDup" class="form-control">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6 col-sm-6 col-6">
                                    <label data-error="wrong" data-success="right" for="dtVenctoDup">Vencimento: </label>
                                    <div class="relative">
                                        <div class="input-group">
                                            <input type="date" max="2500-12-31" class="input-default focus form-control" id="dtVenctoDup" name="dtVenctoDup" class="form-control">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-2 col-sm-4 col-12" id="panelVenctoPrev">
                                <label data-error="wrong" data-success="right" for="dtVenctoPrevDup">Vencimento Prev: </label>
                                <div class="relative">
                                    <div class="input-group">
                                        <input type="date" max="2500-12-31" class="input-default focus form-control" id="dtVenctoPrevDup" name="dtVenctoPrevDup" class="form-control">
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4 col-sm-4 col-12 mt-4 pt-2" id="panelAlteraNum">
                                <fieldset class="form p-0">
                                    <div class="form-row justify-content-center">
                                        <div class="icheck-primary mr-2"><input type="checkbox" class="configCheck" id="cbAlteraNum"><label class="labelCheck" for="cbAlteraNum"> Alterar Num. Cartão NSU a Todos da mesma Fatura</label></div>
                                    </div>
                                </fieldset>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-4 col-sm-4 col-12" id="panelCliente">
                                <label data-error="wrong" data-success="right" for="txtClienteDup">Cliente: </label>
                                <div class="relative">
                                    <div class="input-group">
                                        <input type="text" class="input-default focus form-control" id="txtClienteDup" name="txtClienteDup" class="form-control" placeholder="Cliente">
                                        <div class="input-group-append">
                                            <button class="btn bg-danger" id="btn-ClienteDup" name="btn-ClienteDup" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                            <button class="btn bg-danger" id="btn-limpa-ClienteDup" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-4 col-sm-4 col-12" id="panelConta">
                                <label data-error="wrong" data-success="right" for="txtContaDup">Conta: </label>
                                <div class="relative">
                                    <div class="input-group">
                                        <input type="text" class="input-default focus form-control" id="txtContaDup" name="txtContaDup" class="form-control" placeholder="Conta">
                                        <div class="input-group-append">
                                            <button class="btn bg-danger" id="btn-ContaDup" name="btn-ContaDup" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                            <button class="btn bg-danger" id="btn-limpa-ContaDup" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-4 col-sm-4 col-12" id="panelClasseGer">
                                <label data-error="wrong" data-success="right" for="txtClasseGerDup">Classe Gerencial: </label>
                                <div class="relative">
                                    <div class="input-group">
                                        <input type="text" class="input-default focus form-control" id="txtClasseGerDup" name="txtClasseGerDup" class="form-control" placeholder="Classe Gerencial">
                                        <div class="input-group-append">
                                            <button class="btn bg-danger" id="btn-ClasseGerDup" name="btn-ClasseGerDup" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                            <button class="btn bg-danger" id="btn-limpa-ClasseGerDup" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-4 col-sm-4 col-12" id="panelHistorico">
                                <label data-error="wrong" data-success="right" for="txtHistoricoDup">Histórico: </label>
                                <div class="relative">
                                    <div class="input-group">
                                        <input type="text" class="input-default focus form-control" id="txtHistoricoDup" name="txtHistoricoDup" class="form-control" placeholder="Histórico">
                                        <div class="input-group-append">
                                            <button class="btn bg-danger" id="btn-HistoricoDup" name="btn-HistoricoDup" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                            <button class="btn bg-danger" id="btn-limpa-HistoricoDup" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-4 col-sm-4 col-12" id="panelBanco">
                                <label data-error="wrong" data-success="right" for="txtBancoDup">Banco: </label>
                                <div class="relative">
                                    <div class="input-group">
                                        <input type="text" class="input-default focus form-control" id="txtBancoDup" name="txtBancoDup" class="form-control" placeholder="Banco">
                                        <div class="input-group-append">
                                            <button class="btn bg-danger" id="btn-BancoDup" name="btn-BancoDup" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                            <button class="btn bg-danger" id="btn-limpa-BancoDup" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-4 col-sm-4 col-12" id="panelSituacao">
                                <label data-error="wrong" data-success="right" for="txtSituacaoDup">Situação: </label>
                                <div class="relative">
                                    <div class="input-group">
                                        <input type="text" class="input-default focus form-control" id="txtSituacaoDup" name="txtSituacaoDup" class="form-control" placeholder="Situação">
                                        <div class="input-group-append">
                                            <button class="btn bg-danger" id="btn-SituacaoDup" name="btn-SituacaoDup" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                            <button class="btn bg-danger" id="btn-limpa-SituacaoDup" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-4 col-sm-4 col-12" id="panelEndosso">
                                <label data-error="wrong" data-success="right" for="txtEndossoDup">Endosso: </label>
                                <div class="relative">
                                    <div class="input-group">
                                        <input type="text" class="input-default focus form-control" id="txtEndossoDup" name="txtEndossoDup" class="form-control" placeholder="Endosso">
                                        <div class="input-group-append">
                                            <button class="btn bg-danger" id="btn-EndossoDup" name="btn-EndossoDup" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                            <button class="btn bg-danger" id="btn-limpa-EndossoDup" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-4 col-sm-4 col-12" id="panelNrBanco">
                                <label data-error="wrong" data-success="right" for="txtNrBancoDup">Nr Banco: </label>
                                <div class="relative">
                                    <div class="input-group">
                                        <input type="text" class="input-default focus form-control" id="txtNrBancoDup" name="txtNrBancoDup" class="form-control" placeholder="Nr Banco">
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-4 col-sm-4 col-12" id="panelBordero">
                                <label data-error="wrong" data-success="right" for="txtBorderoDup">Borderô: </label>
                                <div class="relative">
                                    <div class="input-group">
                                        <input type="text" class="input-default focus form-control" id="txtBorderoDup" name="txtBorderoDup" class="form-control" placeholder="Borderô">
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-4 col-sm-4 col-12" id="panelCartaoNSU">
                                <label data-error="wrong" data-success="right" for="txtCartaoNSUDup">Cartão NSU: </label>
                                <div class="relative">
                                    <div class="input-group">
                                        <input type="text" class="input-default focus form-control" id="txtCartaoNSUDup" name="txtCartaoNSUDup" class="form-control" placeholder="Cartão NSU">
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-4 col-sm-4 col-12" id="panelMoeda">
                                <label data-error="wrong" data-success="right" for="txtMoedaDup">Moeda: </label>
                                <div class="relative">
                                    <div class="input-group">
                                        <input type="text" class="input-default focus form-control" id="txtMoedaDup" name="txtMoedaDup" class="form-control" placeholder="Moeda">
                                        <div class="input-group-append">
                                            <button class="btn bg-danger" id="btn-MoedaDup" name="btn-MoedaDup" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                            <button class="btn bg-danger" id="btn-limpa-MoedaDup" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-4 col-sm-4 col-12" id="panelDescProgramado">
                                <label data-error="wrong" data-success="right" for="txtDescProgramadoDup">Desc. Programado: </label>
                                <div class="relative">
                                    <div class="input-group">
                                        <input type="text" class="input-default focus form-control" id="txtDescProgramadoDup" name="txtDescProgramadoDup" class="form-control" placeholder="Desc. Programado">
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-4 col-sm-4 col-12" id="panelJurosProgramado">
                                <label data-error="wrong" data-success="right" for="txtJurosProgramadoDup">Juros Programado: </label>
                                <div class="relative">
                                    <div class="input-group">
                                        <input type="text" class="input-default focus form-control" id="txtJurosProgramadoDup" name="txtJurosProgramadoDup" class="form-control" placeholder="Juros Programado">
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-12 col-sm-12 col-12" id="panelObs">
                                <label data-error="wrong" data-success="right" for="txtObsDup">Observação: </label>
                                <div class="relative">
                                    <div class="input-group">
                                        <textarea class="input-default focus form-control create" id="txtObsDup" name="txtObsDup" placeholder="Observação" rows="4" cols="50" style="resize: none;"></textarea>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                    <div class="modal-footer">
                        <div class="row">
                            <button class="btn btn-danger btn-sisp mr-2 btnFecharModal" data-dismiss="modal" id="btnFecharDuplicata">Desistir</button>
                            <button class="btn btn-danger btn-sisp btnGravarModal" id="btnGravarDuplicata">Gravar</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div id="modal-alterarContas" class="modal" tabindex="-1" role="dialog">
            <div class="modal-dialog modal-lg" role="document">
                <div class="modal-content" id="modalBody">
                    <div class="modal-header">
                        <h4 class="modal-title">Alterar Contas</h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-md-12 col-12 col-sm-12 form-group" id="containerConta">
                                <label data-error="wrong" class="labelGeral" data-success="right" for="txtAlterarConta">Conta: </label>
                                <div class="input-group">
                                    <input type="text" class="input-default focus form-control" id="txtAlterarConta" name="txtAlterarConta" placeholder="Conta">
                                    <div class="input-group-append">
                                        <button class="btn btn-sisp bg-danger" id="btnAlterarConta" name="btnAlterarConta" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                        <button class="btn btn-sisp bg-danger" id="btnAAlterarConta" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <div class="row">
                            <button class="btn btn-danger btn-sisp mr-2 btnFecharModal" data-dismiss="modal" id="btnFecharConta">Fechar</button>
                            <button class="btn btn-danger btn-sisp btnGravarModal" id="btnGravarConta">Gravar</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <?php
        include_once('../../../modais.php');
        ?>

        <!-- Control Sidebar -->
        <aside class="control-sidebar control-sidebar-dark">
            <!-- Control sidebar content goes here -->
        </aside>
        <!-- /.control-sidebar -->
    </div>
    <!-- jQuery -->
    <script src="../plugins/jquery/jquery.min.js?versao=3.2410.16.2"></script>
    <script src="../plugins/jquery-ui/jquery-ui.min.js?versao=3.2410.16.2"></script>
    <script type="text/javascript" src="../dist/js/jquery.dataTables.js?versao=3.2410.16.2"></script>
    <script type="text/javascript" src="../dist/js/dataTables.bootstrap4.min.js?versao=3.2410.16.2"></script>
    <!-- SweetAlert2 -->
    <script src="../plugins/sweetalert2/sweetalert2.min.js?versao=3.2410.16.2"></script>
    <script src="../plugins/toastr/toastr.min.js?versao=3.2410.16.2"></script>

    <!-- Resolve conflict in jQuery UI tooltip with Bootstrap tooltip -->
    <script>
        $.widget.bridge('uibutton', $.ui.button);
    </script>

    <script src="../plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.2410.16.2"></script>
    <script src="../dist/js/adminlte.min.js?versao=3.2410.16.2"></script>
    <script src="../dist/js/requisicoes.js?versao=3.2410.16.2"></script>
    <script src="../dist/js/cliente/entidade.js?versao=3.2410.16.2"></script>
    <script src="../dist/js/loadingoverlay.min.js?versao=3.2410.16.2"></script>
    <script src="../dist/js/valida_cpf_cnpj.js?versao=3.2410.16.2"></script>
    <script src="../plugins/jquery-validation/jquery.validate.min.js?versao=3.2410.16.2"></script>
    <script src="../dist/js/sisplan.js?versao=3.2410.16.2"></script>
    <script src="../utils/funcoes.js?versao=3.2410.16.2"></script>
    <script src="../utils/cookies.js?versao=3.2410.16.2"></script>
    <script src="../dist/js/driver.min.js?versao=3.2410.16.2"></script>
    <script src="../dist/js/jquery.maskMoney.min.js?versao=3.2410.16.2"></script>
    <script src="../dist/js/jquery.mask.min.js?versao=3.2410.16.2"></script>
    <script src="../dist/js/dataTables.keyTable2.js?versao=3.2410.16.2"></script>
    <script type="text/javascript" src="../config.js?versao=3.2410.16.2"></script>
    <script src="../plugins/select2/js/select2.full.min.js?versao=3.2410.16.2"></script>

    <script>
        $(document).ready(async function() {
            if (getCookie('usuario') == "") {
                window.location.href = `${BASE_URI}/login`;
                return;
            }

            let usuario = getCookie('usuario');
            let empresa = getCookie('empresa');

            ipInterno = IP_INTERNO;
            ipExterno = IP_EXTERNO;
            basicAuth = BASIC_AUTH;

            const temAcesso = await temAcessoTela('RELBLOQUETO');
            if (!temAcesso.resultado) {
                toastrAcesso(temAcesso, BASE_URI);
                return;
            }

            const permissaoUsuarioLogado = await permissaoAcessos("RELBLOQUETO");

            if (permissaoUsuarioLogado.INCLUI == 'N') {
                await criaMensagemErro("Sem permissão para incluir!", () => {
                    window.location.href = `${BASE_URI}/relbloqueto`
                });
                return;
            }

            sArquivo = `${BASE_URI}/pages/relbloqueto/cadastro_relbloqueto/relbloqueto.js?versao=3.2410.16.2`;
            insereJavaScriptPagina(sArquivo);

            const nomeTela = ('<?php echo basename(__FILE__) ?>').replace('.php', '');
            habilitaCamposObrigatoriosTela(nomeTela);
        });
    </script>
</body>

</html>