$("#tutorial").on("click", function () {
    $("#geral-tab").trigger("click");
    const driver = new Driver({
        doneBtnText: "Sair",
        closeBtnText: "Fechar",
        nextBtnText: "Próximo",
        prevBtnText: "Anterior",
        allowClose: false,
        onHighlightStarted: (Element) => {
            if (Element.node.id == "dados") {
                if (!$("#multiCollapseExample1").hasClass("show"));
                $("#multiCollapseExample1").collapse("show");
            } else if (Element.node.id == "contatos") {
                if (!$("#collapseFiltros").hasClass("show")) {
                    $("#contatos").collapse("show");
                    $("#multiCollapseExample2").collapse("show");
                }
            } else if (Element.node.id == "historico") {
                if (!$("#collapseFiltros").hasClass("show")) {
                    $("#historico").collapse("show");
                    $("#multiCollapseExample3").collapse("show");
                }
            }
        },
        onPrevious: (Element) => {
            if (
                Element.node.id == "contatos-tab" ||
                Element.node.id == "contatos"
            ) {
                if (!$("#contatos>a").hasClass("collapsed")) {
                    $("#multiCollapseExample2").collapse("show");
                }
            } else if (Element.node.id == "historico") {
                if (!$("#contatos>a").hasClass("collapsed")) {
                    $("#contatos").collapse("show");
                }
            }
        },
    });

    driver.defineSteps([{
        element: "#dados",
        popover: {
            title: "Aba Dados",
            description: "Clique aqui para abrir a aba dados.",
            position: "botton",
        },
    },
    {
        element: "#multiCollapseExample1",
        popover: {
            title: "Dados de Cadastro Geral",
            description: "Esses são os campos que você informará os dados gerais de cadastro.",
            position: "top",
        },
    },
    {
        element: "#contatos",
        popover: {
            title: "Aba Contatos",
            description: "Clique aqui para abrir aba contatos.",
            position: "top",
        },
    },
    {
        element: "#multiCollapseExample2",
        popover: {
            title: "Dados de Contatos",
            description: "Aqui ficam os dados de contatos a serem preenchidos.",
            position: "top",
        },
    },
    {
        element: "#historico",
        popover: {
            title: "Aba Histórico",
            description: "Clique aqui para abrir aba histórico.",
            position: "top",
        },
    },
    {
        element: "#multiCollapseExample3",
        popover: {
            title: "Dados de Histórico",
            description: "Aqui ficam os históricos cadastrados a esta prospecção.",
            position: "top",
        },
    },
    {
        element: "#btnHistorico",
        popover: {
            title: "Incluir Histórico",
            description: "Clique aqui para incluir um histórico.",
            position: "top",
        },
    },
    {
        element: "#btnVoltar",
        popover: {
            title: "Botão Voltar",
            description: "Ao clicar nesse botão você retorna para a tela de consulta da Entidade.",
            position: "left",
        },
    },
    {
        element: "#gravar",
        popover: {
            title: "Botão Gravar",
            description: "Ao clicar nesse botão você grava os dados inseridos.",
            position: "left",
        },
    },
    ]);

    driver.start();
    driver.getHighlightedElement();
});

$(document).ready(async function () {

    $("#txtCodigo").prop("disabled", true);

    let queryString = window.location.href;
    let parametros = queryString.split("/");
    let prospeccao = parametros[parametros.length - 1];
    let bloqueiaTable = false;
    let alterando = false;
    let indiceLinha;

    $('#txtEntidade').autocompleta(1, 'JSON={ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI CHAVE", "NOME DESCRICAO" ], "where": null}');
    $('#txtRamo').autocompleta(1, 'JSON={ "tabela":"SITCLI", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO" ], "where": null}');
    $('#txtRepresentante').autocompleta(1, 'JSON={ "tabela":"REPRESEN", "camposSelect":[ "CODREP CHAVE", "NOME DESCRICAO" ], "where": null}');
    $('#txtCNAE').autocompleta(1, 'JSON={ "tabela":"CADCNAE", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO" ], "where": null}');

    $(`#btnCep`).pesquisa_serverside([`#txtCep`, `#txtCepInv`], ["CADCEP.CEP", "CIDADE.NOME"], ["CADCEP.CEP", "CIDADE.NOME"], '{"tabela":"CADCEP", "camposSelect":["CADCEP.CEP", "CIDADE.NOME", "CIDADE.COD_UF", "CADCEP.NOMCEP"], "leftJoin": [{"tabela": "CIDADE", "condicao": "CADCEP.CODMUN = CIDADE.CODIGO"}], "where": null}', 'Pesquisa de CEP', '', [true, true]);
    $('#btnEntidade').pesquisa_serverside(['#txtEntidade'], ['CODCLI'], ['NOME'], `{ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "NOME" ], "where": null}`, 'Pesquisa de Entidade');
    $('#btnRamo').pesquisa_serverside(['#txtRamo'], ['CODIGO'], ['DESCRICAO'], `{ "tabela":"SITCLI", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}`, 'Pesquisa de Ramo de Atividade');
    $('#btnRepresentante').pesquisa_serverside(['#txtRepresentante'], ['CODREP'], ['NOME'], `{ "tabela":"REPRESEN", "camposSelect":[ "CODREP", "NOME" ], "where": null}`, 'Pesquisa de Representante');
    $('#btnCNAE').pesquisa_serverside(['#txtCNAE'], ['CODIGO'], ['DESCRICAO'], `{ "tabela":"CADCNAE", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}`, 'Pesquisa de CNAE');

    $('#btnACep').on('click', function () {
        $('#txtCep').val('')
        limpaCep()
    })

    $('#btnAEntidade').on('click', function () { $('#txtEntidade').val('') })
    $('#btnARamo').on('click', function () { $('#txtRamo').val('') })
    $('#btnACNAE').on('click', function () { $('#txtCNAE').val('') })
    $('#btnARepresentante').on('click', function () { $('#txtRepresentante').val('') })

    function limpaCep() {
        $('#txtCidade').val('');
        $('#txtEstado').val('');
        $('#txtEndereco').val('');
        $('#txtNumero').val('');
        $('#txtBairro').val('');
    }

    infoCep = ''
    $("#txtCep").blur(async function () {
        limpaCep()
        infoCep = $("#txtCep");
        try {
            let retorno = await BuscaECadastraCep(infoCep);
            if (retorno != undefined) {
                if (retorno[0] != '') {
                    $("#txtCidade").val(retorno[0]);
                }
                if (retorno[1] != '') {
                    $("#txtEstado").val(retorno[1]);
                }
                if (retorno[2] != '') {
                    $("#txtEndereco").val(retorno[2]);
                }
                if (retorno[3] != '') {
                    $("#txtBairro").val(retorno[3]);
                }
            }
        } catch (error) {
            console.error(error);
        }
    });

    $('#txtQtdeColaboradores').maskMoney({
        decimal: '.',
        thousands: '',
        precision: 2
    });

    $('#txtEntidade').on('focusout', async function () {
        if ($('#txtEntidade').val() != '') {
            await carregaEntidade(pegaChave('#txtEntidade'), true)
        }
    })

    $("#txtCNPJ").on('focusout', async function () {
        if ($('#txtCNPJ').val() != '') {
            await carregaEntidade($('#txtCNPJ').val(), false)
        }

        if ($('#txtCNPJ').val().length > 14) {
            $('#rdPessoaJuridica').prop('checked', true)
        } else {
            $('#rdPessoaFisica').prop('checked', true)
        }
    })

    let options = {
        onKeyPress(cpf, ev, el, op) {
            let masks = ["000.000.000-000", "00.000.000/0000-00"];
            $("#txtCNPJ").mask(cpf.length > 14 ? masks[1] : masks[0], op);
        },
    };

    if ($("#txtCNPJ").length > 11) {
        $("#txtCNPJ").mask("00.000.000/0000-00", options);
    } else {
        $("#txtCNPJ").mask("000.000.000-00#", options);
    }

    $("#txtCNPJ").on('change', function () {
        let validaCNPJ = formata_cpf_cnpj($("#txtCNPJ").val());
        if (validaCNPJ != false) {
            $("#txtCNPJ").val(validaCNPJ);
        }
    });

    let SPMaskBehavior = function (val) {
        const cleanValue = val.replace(/\D/g, "");
        const ddd = cleanValue.substring(0, 2);

        if (ddd.length === 2) {
            return `(${ddd}) 90000-0000`;
        } else {
            return "(00) 0000-00009";
        }
    };

    let spOptions = {
        onKeyPress(val, e, field, options) {
            field.mask(SPMaskBehavior.apply({}, arguments), options);
        },
    };

    $("#txtTelefone").mask(SPMaskBehavior, spOptions);
    $("#txtTelefone2").mask(SPMaskBehavior, spOptions);
    $("#txtTelefone3").mask(SPMaskBehavior, spOptions);
    $("#txtTelefone4").mask(SPMaskBehavior, spOptions);
    $("#txtTelefone5").mask(SPMaskBehavior, spOptions);

    async function carregaEntidade(valor, bCodcli) {
        try {
            $.LoadingOverlay("show");
            try {
                let response = await requisicao(
                    "GET",
                    "/Sisplan/Funcoes/v1/pesquisa?",
                    `JSON={ "tabela":"ENTIDADE", 
                    "camposSelect":["ENTIDADE.CODCLI", "ENTIDADE.NOME", "ENTIDADE.CNPJ", "ENTIDADE.FANTASIA",
                                    "ENTIDADE.TIPO", "ENTIDADE.INSCRICAO", "ENTIDADE.ENDERECO", "ENTIDADE.NUMERO", 
                                    "ENTIDADE.BAIRRO", "ENTIDADE.COMPLEMENTO", "ENTIDADE.CEP", "CADCEP.CODMUN", 
                                    "ENTIDADE.SITE", "ENTIDADE.SIT_CLI", "SITCLI.DESCRICAO DESC_SIT",
                                    "ENTIDADE.CODREP", "REPRESEN.NOME NOME_REP"], 
                    "leftjoin": [{"tabela": "CADCEP", "condicao": "CADCEP.CEP = ENTIDADE.CEP"},
                                 {"tabela": "SITCLI", "condicao": "SITCLI.CODIGO = ENTIDADE.SIT_CLI"}, 
                                 {"tabela": "REPRESEN", "condicao": "REPRESEN.CODREP = ENTIDADE.CODREP"}],
                    "where": ["${bCodcli ? 'ENTIDADE.CODCLI' : 'ENTIDADE.CNPJ'} = '${valor}'"]}`,
                    null
                );

                if (!response) {
                    return;
                }
                let jsonStr = await response.json();
                if (response.status != 200) {
                    msgErro(jsonStr.RESULT[0].mensagem);
                    return;
                }

                if (jsonStr.RESULT[0].length <= 0) {
                    return;
                }

                $("#txtCodigo").attr("readonly", true);

                $("#txtRazao").val(jsonStr.RESULT[0][0].NOME);
                $("#txtFantasia").val(jsonStr.RESULT[0][0].FANTASIA);
                $("#txtCNPJ").val(jsonStr.RESULT[0][0].CNPJ);
                $("#txtInscricao").val(jsonStr.RESULT[0][0].INSCRICAO);
                $("#txtEndereco").val(jsonStr.RESULT[0][0].ENDERECO);
                $("#txtNumero").val(jsonStr.RESULT[0][0].NUMERO);
                $("#txtBairro").val(jsonStr.RESULT[0][0].BAIRRO);
                $("#txtComplemento").val(jsonStr.RESULT[0][0].COMPLEMENTO);
                $('#txtSite').val(jsonStr.RESULT[0][0].SITE);

                $('#txtCep').val(jsonStr.RESULT[0][0].CEP);
                insereValor('#txtEntidade', jsonStr.RESULT[0][0].CODCLI, jsonStr.RESULT[0][0].NOME);
                insereValor('#txtRamo', jsonStr.RESULT[0][0].SIT_CLI, jsonStr.RESULT[0][0].DESC_SIT);
                insereValor('#txtRepresentante', jsonStr.RESULT[0][0].CODREP, jsonStr.RESULT[0][0].NOME_REP);

                jsonStr.RESULT[0][0].TIPO == 1 ? $('#rdPessoaFisica').prop('checked', true) : $('#rdPessoaJuridica').prop('checked', true)

                $('#txtCep').blur()
            } catch (error) {
                console.error(error);
                msgErro(`Não foi possível buscar os dados da entidade: ${error}`);
            }
        } finally {
            $.LoadingOverlay("hide");
        }
    }

    $(".collapse")
        .on("shown.bs.collapse", function (e) {
            let clicked = $(document).find(`[href='#${$(e.target).attr("id")}']`);

            clicked
                .parent()
                .find(".fa-angle-right")
                .removeClass("fa-angle-right")
                .addClass("fa-angle-down");
        })
        .on("hidden.bs.collapse", function (e) {
            let clicked = $(document).find(`[href='#${$(e.target).attr("id")}']`);

            clicked
                .parent()
                .find(".fa-angle-down")
                .removeClass("fa-angle-down")
                .addClass("fa-angle-right");
        });

    $("#btnVoltar").on("click", async function () {
        await deletaRegistro("PROSPECCAO", getCookie("usuario"), prospeccao);
        window.location.href = `${BASE_URI}/prospeccao`;
    });

    $(document).ready(function () {
        $("#msform").validate({
            debug: false,
            ignore: "",
            rules: {
                txtRazao: {
                    required: true,
                },
                txtCNPJ: {
                    required: true,
                },
                txtInscricao: {
                    required: true,
                },
                txtCep: {
                    required: true,
                },
                txtOrigem: {
                    required: true,
                },
            },
            messages: {
                txtRazao: {
                    required: "Informe uma Razão Social válida.",
                },
                txtCNPJ: {
                    required: 'Informe um CNPJ válido',
                },
                txtInscricao: {
                    required: 'Informe uma Inscrição válida',
                },
                txtCep: {
                    required: 'Informe um Cep válido',
                },
                txtOrigem: {
                    required: "Selecione um tipo."
                }
            },
            errorElement: "span",
            errorPlacement(error, element) {
                error.addClass("invalid-feedback");
                element.closest(".form-group").append(error);
            },
            highlight(element) {
                $(element).addClass("is-invalid");
            },
            unhighlight(element) {
                $(element).removeClass("is-invalid");
            },
        });

        $(".radio-group .radio").click(function () {
            $(this).parent().find(".radio").removeClass("selected");
            $(this).addClass("selected");
        });

        $(".submit").click(function () {
            return false;
        });
    });

    //BUSCA DADOS AO ABRIR A TELA
    if (prospeccao != "" && prospeccao != "create") {
        if ((await liberarRegistro("PROSPECCAO", prospeccao)) == false) {
            window.location.href = "../prospeccao";
        } else {
            try {
                $.LoadingOverlay("show");
                try {
                    let response = await requisicao(
                        "GET",
                        "/Sisplan/Funcoes/v1/pesquisa?",
                        `JSON={ "tabela":"CAD_PROSP", 
                        "camposSelect":["CAD_PROSP.DATA DATA_CADASTRO","CAD_PROSP.DATA_RETORNO","CAD_PROSP.TP_ORIGEM",
                                        "CAD_PROSP.CODIGO","CAD_PROSP.NOME","CAD_PROSP.FANTASIA","CAD_PROSP.CNPJ","CAD_PROSP.INSCRICAO",
                                        "CAD_PROSP.ENDERECO","CAD_PROSP.NUMERO","CAD_PROSP.BAIRRO","CAD_PROSP.COMPLEMENTO",
                                        "CAD_PROSP.CEP","CAD_PROSP.CODCLI","CAD_PROSP.SIT_CLI","CAD_PROSP.REPRESEN","CAD_PROSP.CNAE","CAD_PROSP.SITE","CAD_PROSP.QTDE_COLAB",
                                        "CAD_PROSP.TIPO_PESSOA", "CADCEP.CODMUN", "ENTIDADE.NOME NOME_CLI", "SITCLI.DESCRICAO DESC_SIT", "REPRESEN.NOME NOME_REP", "CADCNAE.DESCRICAO DESC_CNAE",
                                        "CAD_PROSP.CONTATO","CAD_PROSP.CONTATO2","CAD_PROSP.CONTATO3","CAD_PROSP.CONTATO4","CAD_PROSP.CONTATO5",
                                        "CAD_PROSP.SETOR","CAD_PROSP.SETOR2","CAD_PROSP.SETOR3","CAD_PROSP.SETOR4","CAD_PROSP.SETOR5",
                                        "CAD_PROSP.TELEFONE","CAD_PROSP.TELEFONE2","CAD_PROSP.TELEFONE3","CAD_PROSP.TELEFONE4","CAD_PROSP.TELEFONE5",
                                        "CAD_PROSP.EMAIL","CAD_PROSP.EMAIL2","CAD_PROSP.EMAIL3","CAD_PROSP.EMAIL4","CAD_PROSP.EMAIL5",
                                        "CAD_PROSP.OBS", "CAD_PROSP.TP_CONTATO","CAD_PROSP.TP_STATUS","CAD_PROSP.CONT_LIGACAO", 
                                        "CAD_PROSP.CONT_EMAIL","CAD_PROSP.CONT_VISITA", "CAD_PROSP.CONT_WHATSAPP", "CAD_PROSP.CONT_OUTROS"], 
                        "leftjoin": [{"tabela": "CADCEP", "condicao": "CAD_PROSP.CEP = CADCEP.CEP"},
                                     {"tabela": "ENTIDADE", "condicao": "CAD_PROSP.CODCLI = ENTIDADE.CODCLI"},
                                     {"tabela": "SITCLI", "condicao": "CAD_PROSP.SIT_CLI = SITCLI.CODIGO"}, 
                                     {"tabela": "REPRESEN", "condicao": "CAD_PROSP.REPRESEN = REPRESEN.CODREP"},
                                     {"tabela": "CADCNAE", "condicao": "CAD_PROSP.CNAE = CADCNAE.CODIGO"}],
                        "where": ["CAD_PROSP.CODIGO = '${prospeccao}'"]}`,
                        null
                    );

                    if (!response) {
                        return;
                    }
                    let jsonStr = await response.json();
                    if (response.status != 200) {
                        msgErro(jsonStr.RESULT[0].mensagem);
                        return;
                    }

                    $("#txtCodigo").attr("readonly", true);

                    $("#txtCodigo").val(jsonStr.RESULT[0][0].CODIGO);
                    $("#txtRazao").val(jsonStr.RESULT[0][0].NOME);
                    $("#txtCadastro").val(jsonStr.RESULT[0][0].DATA_CADASTRO);
                    $("#txtRetorno").val(jsonStr.RESULT[0][0].DATA_RETORNO);
                    $("#txtOrigem").val(jsonStr.RESULT[0][0].TP_ORIGEM);
                    $("#txtFantasia").val(jsonStr.RESULT[0][0].FANTASIA);
                    $("#txtCNPJ").val(jsonStr.RESULT[0][0].CNPJ);
                    $("#txtInscricao").val(jsonStr.RESULT[0][0].INSCRICAO);
                    $("#txtEndereco").val(jsonStr.RESULT[0][0].ENDERECO);
                    $("#txtNumero").val(jsonStr.RESULT[0][0].NUMERO);
                    $("#txtBairro").val(jsonStr.RESULT[0][0].BAIRRO);
                    $("#txtComplemento").val(jsonStr.RESULT[0][0].COMPLEMENTO);
                    $('#txtSite').val(jsonStr.RESULT[0][0].SITE);
                    $('#txtQtdeColaboradores').val(jsonStr.RESULT[0][0].QTDE_COLAB);

                    $('#txtCep').val(jsonStr.RESULT[0][0].CEP);
                    insereValor('#txtEntidade', jsonStr.RESULT[0][0].CODCLI, jsonStr.RESULT[0][0].NOME_CLI);
                    insereValor('#txtRamo', jsonStr.RESULT[0][0].SIT_CLI, jsonStr.RESULT[0][0].DESC_SIT);
                    insereValor('#txtRepresentante', jsonStr.RESULT[0][0].REPRESEN, jsonStr.RESULT[0][0].NOME_REP);
                    insereValor('#txtCNAE', jsonStr.RESULT[0][0].CNAE, jsonStr.RESULT[0][0].DESC_CNAE);

                    $('#txtContato').val(jsonStr.RESULT[0][0].CONTATO)
                    $('#txtContato2').val(jsonStr.RESULT[0][0].CONTATO2)
                    $('#txtContato3').val(jsonStr.RESULT[0][0].CONTATO3)
                    $('#txtContato4').val(jsonStr.RESULT[0][0].CONTATO4)
                    $('#txtContato5').val(jsonStr.RESULT[0][0].CONTATO5)
                    $('#txtSetor').val(jsonStr.RESULT[0][0].SETOR)
                    $('#txtSetor2').val(jsonStr.RESULT[0][0].SETOR2)
                    $('#txtSetor3').val(jsonStr.RESULT[0][0].SETOR3)
                    $('#txtSetor4').val(jsonStr.RESULT[0][0].SETOR4)
                    $('#txtSetor5').val(jsonStr.RESULT[0][0].SETOR5)
                    $('#txtTelefone').val(jsonStr.RESULT[0][0].TELEFONE)
                    $('#txtTelefone2').val(jsonStr.RESULT[0][0].TELEFONE2)
                    $('#txtTelefone3').val(jsonStr.RESULT[0][0].TELEFONE3)
                    $('#txtTelefone4').val(jsonStr.RESULT[0][0].TELEFONE4)
                    $('#txtTelefone5').val(jsonStr.RESULT[0][0].TELEFONE5)
                    $('#txtEmail').val(jsonStr.RESULT[0][0].EMAIL)
                    $('#txtEmail2').val(jsonStr.RESULT[0][0].EMAIL2)
                    $('#txtEmail3').val(jsonStr.RESULT[0][0].EMAIL3)
                    $('#txtEmail4').val(jsonStr.RESULT[0][0].EMAIL4)
                    $('#txtEmail5').val(jsonStr.RESULT[0][0].EMAIL5)
                    $('#txtObs').val(jsonStr.RESULT[0][0].OBS)

                    jsonStr.RESULT[0][0].TP_CONTATO == 0 ? $('#rdTipoAtivo').prop('checked', true) : $('#rdTipoReceptivo').prop('checked', true)
                    jsonStr.RESULT[0][0].TIPO_PESSOA == 'FISICA' ? $('#rdPessoaFisica').prop('checked', true) : $('#rdPessoaJuridica').prop('checked', true)

                    jsonStr.RESULT[0][0].CONT_LIGACAO == 'S' ? $('#cbLigacao').prop('checked', true) : $('#cbLigacao').prop('checked', false)
                    jsonStr.RESULT[0][0].CONT_EMAIL == 'S' ? $('#cbEmail').prop('checked', true) : $('#cbEmail').prop('checked', false)
                    jsonStr.RESULT[0][0].CONT_VISITA == 'S' ? $('#cbVisita').prop('checked', true) : $('#cbVisita').prop('checked', false)
                    jsonStr.RESULT[0][0].CONT_WHATSAPP == 'S' ? $('#cbWhatsapp').prop('checked', true) : $('#cbWhatsapp').prop('checked', false)
                    jsonStr.RESULT[0][0].CONT_OUTROS == 'S' ? $('#cbOutros').prop('checked', true) : $('#cbOutros').prop('checked', false)

                    if (jsonStr.RESULT[0][0].TP_STATUS == 0) {
                        $('#rdStatusProsp').prop('checked', true)
                    } else if (jsonStr.RESULT[0][0].TP_STATUS == 1) {
                        $('#rdStatusSemCont').prop('checked', true)
                    } else if (jsonStr.RESULT[0][0].TP_STATUS == 2) {
                        $('#rdStatusSemInt').prop('checked', true)
                    } else if (jsonStr.RESULT[0][0].TP_STATUS == 3) {
                        $('#rdStatusSemOrc').prop('checked', true)
                    } else {
                        $('#rdStatusSatisfeito').prop('checked', true)
                    }

                    $('#txtCep').blur()
                } catch (error) {
                    console.error(error);
                    msgErro(`Não foi possível buscar os dados da prospecção: ${error}`);
                }
            } finally {
                $.LoadingOverlay("hide");
            }
        }
    } else {
        let date = new Date().toISOString().split('T')[0]
        $("#txtCadastro").val(date);
        $("#txtRetorno").val(date);
    }

    async function carregaHistorico(tabela) {
        if (prospeccao != '' && prospeccao != 'create') {
            $.LoadingOverlay('show')
            try {
                try {
                    let response = await requisicao(
                        "GET",
                        "/Sisplan/Funcoes/v1/pesquisa?",
                        `JSON={ "tabela":"CAD_PROSP_HIST", 
                    "camposSelect":["CAD_PROSP_HIST.DATA","CAD_PROSP_HIST.HORA","CAD_PROSP_HIST.OBS",
                                    "CAD_PROSP_HIST.RETORNO","CAD_PROSP_HIST.CODREP","REPRESEN.NOME","CAD_PROSP_HIST.PRIO",
                                    "CAD_PROSP_HIST.STATUS","SITPROD.DESCRICAO DESCSTATUS","CAD_PROSP_HIST.SIT_CLI",
                                    "SITCLI.DESCRICAO DESCSITCLI","CAD_PROSP_HIST.CONTATO","CAD_PROSP_HIST.CONT_LIGACAO",
                                    "CAD_PROSP_HIST.CONT_EMAIL","CAD_PROSP_HIST.CONT_VISITA","CAD_PROSP_HIST.CONT_WHATSAPP","CAD_PROSP_HIST.CONT_OUTROS"], 
                    "leftjoin": [{"tabela": "REPRESEN", "condicao": "REPRESEN.CODREP = CAD_PROSP_HIST.CODREP"},
                                {"tabela": "SITPROD", "condicao": "SITPROD.CODIGO = CAD_PROSP_HIST.STATUS"},
                                {"tabela": "SITCLI", "condicao": "SITCLI.CODIGO = CAD_PROSP_HIST.SIT_CLI"}],
                    "where": ["CAD_PROSP_HIST.PROSPECCAO = '${prospeccao}'"]}`,
                        null
                    );

                    if (!response) {
                        return;
                    }

                    const jsonStrHist = await response.json();

                    if (response.status != 200) {
                        msgAlerta(jsonStrHist.mensagem);
                        return;
                    };

                    if (jsonStrHist.length == 0) {
                        return;
                    }

                    let arrayHistorico = jsonStrHist.RESULT[0]
                    let novoRegistro = []
                    let hora;
                    let retorno;

                    for (let i = 0; i < arrayHistorico.length; i++) {
                        novoRegistro = []
                        hora = arrayHistorico[i].HORA
                        retorno = arrayHistorico[i].RETORNO
                        novoRegistro.push(arrayHistorico[i].DATA)
                        novoRegistro.push(hora.split(' ')[1])
                        novoRegistro.push(arrayHistorico[i].OBS)
                        novoRegistro.push(retorno.split(' ')[0])
                        novoRegistro.push(arrayHistorico[i].CODREP)
                        novoRegistro.push(arrayHistorico[i].NOME)
                        novoRegistro.push(arrayHistorico[i].PRIO)
                        novoRegistro.push(arrayHistorico[i].STATUS)
                        novoRegistro.push(arrayHistorico[i].DESCSTATUS)
                        novoRegistro.push(arrayHistorico[i].SIT_CLI)
                        novoRegistro.push(arrayHistorico[i].DESCSITCLI)
                        novoRegistro.push(arrayHistorico[i].CONTATO)
                        novoRegistro.push(arrayHistorico[i].CONT_LIGACAO)
                        novoRegistro.push(arrayHistorico[i].CONT_EMAIL)
                        novoRegistro.push(arrayHistorico[i].CONT_VISITA)
                        novoRegistro.push(arrayHistorico[i].CONT_WHATSAPP)
                        novoRegistro.push(arrayHistorico[i].CONT_OUTROS)

                        $(tabela).DataTable().row.add(novoRegistro).draw(false);
                    }
                } catch {
                    console.error(error)
                    msgErro(`Não foi possível buscar os dados do histórico: ${error}`);
                }
            } finally {
                $.LoadingOverlay('hide')
            }
        }
    }

    async function montaClassePorps(classe) {
        classe.TIPOPESSOA = $('#rdPessoaFisica').is(':checked') ? 'FISICA' : 'JURIDICA'
        classe.DATACADASTRO = $('#txtCadastro').val();
        classe.DATARETORNO = $('#txtRetorno').val();
        classe.TPORIGEM = $('#txtOrigem').val();
        classe.CODIGO = $("#txtCodigo").val() == ""
            ? await RetornaProximo("CAD_PROSP", "CAD_PROSP", "CODIGO", 5)
            : $("#txtCodigo").val();
        classe.RAZAOSOCIAL = $("#txtRazao").val().toUpperCase();
        classe.FANTASIA = $("#txtFantasia").val().toUpperCase();
        classe.CNPJ = $('#txtCNPJ').val();
        classe.INSCRICAO = $('#txtInscricao').val();
        classe.ENDERECO = $('#txtEndereco').val().toUpperCase();
        classe.NUMERO = $('#txtNumero').val().toUpperCase();
        classe.BAIRRO = $('#txtBairro').val().toUpperCase();
        classe.COMPLEMENTO = $('#txtComplemento').val().toUpperCase();
        classe.CEP = $('#txtCep').val();
        classe.CODCLI = pegaChave('#txtEntidade');
        classe.SITCLI = pegaChave('#txtRamo');
        classe.REPRESEN = pegaChave('#txtRepresentante');
        classe.CNAE = pegaChave('#txtCNAE');
        classe.SITE = $('#txtSite').val();
        classe.QTDECOLAB = $('#txtQtdeColaboradores').val();

        classe.CONTATO = $('#txtContato').val();
        classe.CONTATO2 = $('#txtContato2').val();
        classe.CONTATO3 = $('#txtContato3').val();
        classe.CONTATO4 = $('#txtContato4').val();
        classe.CONTATO5 = $('#txtContato5').val();
        classe.SETOR = $('#txtSetor').val();
        classe.SETOR2 = $('#txtSetor2').val();
        classe.SETOR3 = $('#txtSetor3').val();
        classe.SETOR4 = $('#txtSetor4').val();
        classe.SETOR5 = $('#txtSetor5').val();
        classe.TELEFONE = $('#txtTelefone').val();
        classe.TELEFONE2 = $('#txtTelefone2').val();
        classe.TELEFONE3 = $('#txtTelefone3').val();
        classe.TELEFONE4 = $('#txtTelefone4').val();
        classe.TELEFONE5 = $('#txtTelefone5').val();
        classe.EMAIL = $('#txtEmail').val();
        classe.EMAIL2 = $('#txtEmail2').val();
        classe.EMAIL3 = $('#txtEmail3').val();
        classe.EMAIL4 = $('#txtEmail4').val();
        classe.EMAIL5 = $('#txtEmail5').val();
        classe.OBS = $("#txtObs").val();
        classe.USUARIO = getCookie('usuario')

        if ($('#rdStatusProsp').is(':checked')) {
            classe.TPSTATUS = 0
        } else if ($('#rdStatusSemCont').is(':checked')) {
            classe.TPSTATUS = 1
        } else if ($('#rdStatusSemInt').is(':checked')) {
            classe.TPSTATUS = 2
        } else if ($('#rdStatusSemOrc').is(':checked')) {
            classe.TPSTATUS = 3
        } else {
            classe.TPSTATUS = 4
        }

        if ($('#rdTipoAtivo').is(':checked')) {
            classe.TPCONTATO = 0
        } else {
            classe.TPCONTATO = 1
        }

        $('#cbLigacao').is(':checked') ? classe.CONTLIGACAO = 'S' : classe.CONTLIGACAO = 'N'
        $('#cbEmail').is(':checked') ? classe.CONTEMAIL = 'S' : classe.CONTEMAIL = 'N'
        $('#cbVisita').is(':checked') ? classe.CONTVISITA = 'S' : classe.CONTVISITA = 'N'
        $('#cbWhatsapp').is(':checked') ? classe.CONTWHATSAPP = 'S' : classe.CONTWHATSAPP = 'N'
        $('#cbOutros').is(':checked') ? classe.CONTOUTROS = 'S' : classe.CONTOUTROS = 'N'

        let tabelaHistorico = $('#tabelaHistorico').DataTable().data().toArray()
        if (tabelaHistorico.length <= 0) {
            return
        }
        classe.HISTORICO = await montaArrayHistorico(tabelaHistorico);
    }

    //FUNÇÃO DE GRAVAR

    async function gravarDados(prospClasse) {
        try {
            $.LoadingOverlay("show");
            let response = await requisicao(
                "POST",
                "/Sisplan/Cadastros/v1/prospeccao?",
                `JSON=${encodeURIComponent(JSON.stringify(prospClasse))}`,
                null
            );

            if (!response) {
                return;
            }

            let jsonStr = await response.json();
            if (response.status != 200) {
                msgErro(jsonStr.mensagem);
                return;
            }
            toastr
                .success(
                    `Cadastro efetuado com sucesso!
                   Prospecção: ${prospClasse.CODIGO} - ${prospClasse.RAZAOSOCIAL}`,
                    "Confirmação",
                    {
                        toastClass: "alert",
                        iconClasses: {
                            error: "alert-error",
                            info: "alert-info",
                            success: "alert-success",
                            warning: "alert-warning",
                        },
                        positionClass: "toast-top-center",
                        progressBar: true,
                        timeOut: 5000,
                        fadeOut: 3000,
                        onHidden() {
                            window.location.href = `${BASE_URI}/prospeccao`;
                        },
                    }
                )
                .css({
                    "margin-top": "20%",
                    width: "500px",
                    "max-width": "500px",
                });
        } catch (error) {
            console.error(error);
            $.LoadingOverlay("hide");
            msgErro(`Não foi possível gravar os dados da prospecção: ${error}`);
        }
    }

    $("#txtCep").keypress(function (e) {
        if (e.key === 'Enter') {
            $(this).blur();
        }
    });

    $("#gravar").click(async function () {
        let validator = $("#msform").validate();
        validator.form();
        let erros = 0;
        erros = validator.numberOfInvalids();

        if (erros == 0) {
            let prospClasse = {};
            await montaClassePorps(prospClasse);

            let responseCNPJ = await requisicao(
                "GET",
                "/Sisplan/Funcoes/v1/pesquisa?",
                `JSON={ "tabela":"CAD_PROSP", 
                    "camposSelect":["CAD_PROSP.CODIGO"], 
                    "where": ["CAD_PROSP.CNPJ = '${prospClasse.CNPJ}'"]}`,
                null
            );

            if (!responseCNPJ) {
                return;
            }

            let jsonStrCNPJ = await responseCNPJ.json();
            if (responseCNPJ.status != 200) {
                msgErro(jsonStr.RESULT[0].mensagem);
                return;
            }

            if (jsonStrCNPJ.RESULT[0].length > 0 && prospeccao == 'create') {
                msgAlerta('Prospecção já cadastrada para esse CPF/CNPJ. Deseja continuar?', async () => {
                    await gravarDados(prospClasse)
                })
            } else {
                await gravarDados(prospClasse)
            }

        }
    });

    async function montaArrayHistorico(tabela) {
        const arrayHistorico = []
        let novaRow = {}
        for (let i = 0; i < tabela.length; i++) {
            novaRow = {}
            novaRow.DATA = tabela[i][0];
            novaRow.HORA = `1899-12-30T${tabela[i][1] == '' ? '00:00:00' : tabela[i][1]}Z`;
            novaRow.OBS = tabela[i][2];
            novaRow.DTRETORNO = tabela[i][3];
            novaRow.CODREP = tabela[i][4];
            novaRow.NOME = tabela[i][5];
            novaRow.PRIORIDADE = tabela[i][6];
            novaRow.STATUS = tabela[i][7];
            novaRow.DESCSTATUS = tabela[i][8];
            novaRow.SITCLI = tabela[i][9];
            novaRow.DESCSIT = tabela[i][10];
            novaRow.CONTATO = tabela[i][11];
            novaRow.CONTLIGACAO = tabela[i][12];
            novaRow.CONTEMAIL = tabela[i][13];
            novaRow.CONTVISITA = tabela[i][14];
            novaRow.CONTWHATSAPP = tabela[i][15];
            novaRow.CONTOUTROS = tabela[i][16];

            arrayHistorico.push(novaRow)
        }

        return arrayHistorico
    }

    $('#btnHistorico').on('click', async function () {
        $.LoadingOverlay('show')
        try {
            $('#modal-historico').modal('show')

            $('#txtHistRepresentante').autocompleta(1, 'JSON={ "tabela":"REPRESEN", "camposSelect":[ "CODREP CHAVE", "NOME DESCRICAO" ], "where": null}');
            $('#txtHistRamo').autocompleta(1, 'JSON={ "tabela":"SITCLI", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO" ], "where": null}');
            $('#txtHistStatus').autocompleta(1, 'JSON={ "tabela":"SITPROD", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO" ], "where": null}');

            $('#btnHistRepresentante').pesquisa_serverside(['#txtHistRepresentante'], ['CODREP'], ['NOME'], `{ "tabela":"REPRESEN", "camposSelect":[ "CODREP", "NOME" ], "where": null}`, 'Pesquisa de Representante');
            $('#btnHistRamo').pesquisa_serverside(['#txtHistRamo'], ['CODIGO'], ['DESCRICAO'], `{ "tabela":"SITCLI", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}`, 'Pesquisa de Ramo de Atividade');
            $('#btnHistStatus').pesquisa_serverside(['#txtHistStatus'], ['CODIGO'], ['DESCRICAO'], `{ "tabela":"SITPROD", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}`, 'Pesquisa de Ramo de Status');

            $('#btnAHistRepresentante').on('click', function () { $('#txtHistRepresentante').val('') })
            $('#btnAHistRamo').on('click', function () { $('#txtHistRamo').val('') })
            $('#btnAHistStatus').on('click', function () { $('#txtHistStatus').val('') })

            await criaDataTableHistoricoCad()
        } finally {
            $.LoadingOverlay('hide')
        }
    })

    await criaDataTableHistorico()

    async function criaDataTableHistorico() {

        if ($.fn.DataTable.isDataTable('#tabelaHistorico')) {
            $("#tabelaHistorico").DataTable().destroy();
            $("#tabelaHistorico").empty();
        };

        const dataSetCols = [];

        dataSetCols.push({
            'title': 'Data',
        })
        dataSetCols.push({
            'title': 'Hora',
        })
        dataSetCols.push({
            'title': 'Obs',
        })
        dataSetCols.push({
            'title': 'Dt_Retorno',
        })
        dataSetCols.push({
            'title': 'CodRep',
        })
        dataSetCols.push({
            'title': 'Nome',
        })
        dataSetCols.push({
            'title': 'Prioridade',
        })
        dataSetCols.push({
            'title': 'Status',
        })
        dataSetCols.push({
            'title': 'DescStatus',
        })
        dataSetCols.push({
            'title': 'SitCli',
        })
        dataSetCols.push({
            'title': 'DescSitCli',
        })
        dataSetCols.push({
            'title': 'Contato',
        })
        dataSetCols.push({
            'title': 'Cont_Ligacao',
        })
        dataSetCols.push({
            'title': 'Cont_Email',
        })
        dataSetCols.push({
            'title': 'Cont_Visita',
        })
        dataSetCols.push({
            'title': 'Cont_WhatsApp',
        })
        dataSetCols.push({
            'title': 'Cont_Outros',
        })

        $('#tabelaHistorico').DataTable({
            bPaginate: false,
            order: false,
            sort: false,
            searching: false,
            destroy: true,
            language: {
                sEmptyTable: "Nenhum registro encontrado",
                sInfo: "_TOTAL_ registros",
                sInfoEmpty: " 0 registros",
                sInfoFiltered: "(Filtrados de _MAX_ registros)",
                sInfoPostFix: "",
                sInfoThousands: ".",
                sLengthMenu: "_MENU_ resultados",
                sLoadingRecords: "Carregando...",
                sProcessing: "Processando...",
                sZeroRecords: "Nenhum registro encontrado",
                sSearch: "Pesquisar",
                oPaginate: {
                    sNext: "Próximo",
                    sPrevious: "Anterior",
                    sFirst: "Primeiro",
                    sLast: "Último",
                },
                oAria: {
                    sSortAscending: ": Ordenar colunas de forma ascendente",
                    sSortDescending: ": Ordenar colunas de forma descendente",
                },
            },
            columns: dataSetCols,
        });

        await carregaHistorico('#tabelaHistorico')
    };

    async function criaDataTableHistoricoCad() {

        if ($.fn.DataTable.isDataTable('#tabelaCadHistorico')) {
            $("#tabelaCadHistorico").DataTable().destroy();
            $("#tabelaCadHistorico").empty();
        };

        const dataSetCols = [];

        dataSetCols.push({
            'title': 'Data',
        })
        dataSetCols.push({
            'title': 'Hora',
        })
        dataSetCols.push({
            'title': 'Obs',
        })
        dataSetCols.push({
            'title': 'Dt_Retorno',
        })
        dataSetCols.push({
            'title': 'CodRep',
        })
        dataSetCols.push({
            'title': 'Nome',
        })
        dataSetCols.push({
            'title': 'Prioridade',
        })
        dataSetCols.push({
            'title': 'Status',
        })
        dataSetCols.push({
            'title': 'DescStatus',
        })
        dataSetCols.push({
            'title': 'SitCli',
        })
        dataSetCols.push({
            'title': 'DescSitCli',
        })
        dataSetCols.push({
            'title': 'Contato',
        })
        dataSetCols.push({
            'title': 'Cont_Ligacao',
        })
        dataSetCols.push({
            'title': 'Cont_Email',
        })
        dataSetCols.push({
            'title': 'Cont_Visita',
        })
        dataSetCols.push({
            'title': 'Cont_WhatsApp',
        })
        dataSetCols.push({
            'title': 'Cont_Outros',
        })

        let tabCadastro = $('#tabelaCadHistorico').DataTable({
            bPaginate: false,
            order: false,
            sort: false,
            searching: false,
            destroy: true,
            language: {
                sEmptyTable: "Nenhum registro encontrado",
                sInfo: "_TOTAL_ registros",
                sInfoEmpty: " 0 registros",
                sInfoFiltered: "(Filtrados de _MAX_ registros)",
                sInfoPostFix: "",
                sInfoThousands: ".",
                sLengthMenu: "_MENU_ resultados",
                sLoadingRecords: "Carregando...",
                sProcessing: "Processando...",
                sZeroRecords: "Nenhum registro encontrado",
                sSearch: "Pesquisar",
                oPaginate: {
                    sNext: "Próximo",
                    sPrevious: "Anterior",
                    sFirst: "Primeiro",
                    sLast: "Último",
                },
                oAria: {
                    sSortAscending: ": Ordenar colunas de forma ascendente",
                    sSortDescending: ": Ordenar colunas de forma descendente",
                },
            },
            columns: dataSetCols,
        });

        let tabPrincipal = $('#tabelaHistorico').DataTable()
        tabCadastro.clear().draw();

        let dadosHist = tabPrincipal.rows().data().toArray()

        tabCadastro.rows.add(dadosHist).draw()
    };

    $('#btnExcluirHistorico').on('click', function () {
        let tabela = $("#tabelaCadHistorico").DataTable()
        let linha = tabela.$("tr.selected");
        if (linha.length > 0) {
            msgAlerta('Você realmente deseja excluir esse registro?', async () => {
                $.LoadingOverlay('show')
                try {
                    let tabela = $("#tabelaCadHistorico").DataTable()
                    let linha = tabela.$("tr.selected");
                    if (linha.length > 0) {
                        tabela.row(linha).remove().draw();
                    }
                } finally {
                    $.LoadingOverlay('hide')
                }
            });
        } else {
            msgAlerta('Nenhum registro selecionado para excluir!')
        }
    })

    async function insereValorHistorico(alterando, indiceLinha) {
        $.LoadingOverlay('show')
        try {
            try {
                const novoRegistro = []
                // const novaRow = {}

                const data = $('#txtHistVisita').val()
                const retorno = $('#txtHistRetorno').val()
                const hora = $('#txtHistHora').val()
                const codRep = pegaChave('#txtHistRepresentante')
                const descRep = pegaDescricao('#txtHistRepresentante')
                const sitCli = pegaChave('#txtHistRamo')
                const descSit = pegaDescricao('#txtHistRamo')
                const status = pegaChave('#txtHistStatus')
                const descStatus = pegaDescricao('#txtHistStatus')
                const contato = $('#txtHistContato').val()
                const obs = $('#txtHistObs').val()
                const contLigacao = $('#cbHistLigacao').is(':checked') ? 'S' : 'N'
                const contEmail = $('#cbHistEmail').is(':checked') ? 'S' : 'N'
                const contVisita = $('#cbHistVisita').is(':checked') ? 'S' : 'N'
                const contWhatsapp = $('#cbHistWhatsapp').is(':checked') ? 'S' : 'N'
                const contOutros = $('#cbHistOutros').is(':checked') ? 'S' : 'N'
                const prioridade = $('#txtHistPrioridade').val()

                novoRegistro.push(data)
                novoRegistro.push(hora)
                novoRegistro.push(obs)
                novoRegistro.push(retorno)
                novoRegistro.push(codRep)
                novoRegistro.push(descRep)
                novoRegistro.push(prioridade)
                novoRegistro.push(status)
                novoRegistro.push(descStatus)
                novoRegistro.push(sitCli)
                novoRegistro.push(descSit)
                novoRegistro.push(contato)
                novoRegistro.push(contLigacao)
                novoRegistro.push(contEmail)
                novoRegistro.push(contVisita)
                novoRegistro.push(contWhatsapp)
                novoRegistro.push(contOutros)

                if (alterando) {
                    $('#tabelaCadHistorico').DataTable().row(indiceLinha).data(novoRegistro).draw(false);
                } else {
                    $('#tabelaCadHistorico').DataTable().row.add(novoRegistro).draw(false);
                }

                bloqueiaTable = false;
                alterando = false;
                limpaCamposHistorico()
            } catch {
                console.log(error)
            }
        } finally {
            $.LoadingOverlay('hide')
        }
    }

    function limpaCamposHistorico() {
        $('#btnAHistRepresentante').trigger('click')
        $('#btnAHistRamo').trigger('click')
        $('#btnAHistStatus').trigger('click')
        $('#txtHistContato').val('')
        $('#txtHistObs').val('')
        $('#cbHistLigacao').prop('checked', false)
        $('#cbHistEmail').prop('checked', false)
        $('#cbHistVisita').prop('checked', false)
        $('#cbHistWhatsapp').prop('checked', false)
        $('#cbHistOutros').prop('checked', false)
        $('#txtHistPrioridade').val('0')
        $('#txtHistRetorno').val('1200-01-01')
    }

    function bloqueiaCamposHist(libera) {
        $('#cbHistLigacao').prop('disabled', libera)
        $('#cbHistEmail').prop('disabled', libera)
        $('#cbHistVisita').prop('disabled', libera)
        $('#cbHistWhatsapp').prop('disabled', libera)
        $('#cbHistOutros').prop('disabled', libera)
        $('#txtHistVisita').prop('disabled', libera)
        $('#txtHistHora').prop('disabled', libera)
        $('#txtHistRetorno').prop('disabled', libera)
        $('#txtHistPrioridade').prop('disabled', libera)
        $('#txtHistRepresentante').prop('disabled', libera)
        $('#btnHistRepresentante').prop('disabled', libera)
        $('#btnAHistRepresentante').prop('disabled', libera)
        $('#txtHistRamo').prop('disabled', libera)
        $('#btnHistRamo').prop('disabled', libera)
        $('#btnAHistRamo').prop('disabled', libera)
        $('#txtHistStatus').prop('disabled', libera)
        $('#btnHistStatus').prop('disabled', libera)
        $('#btnAHistStatus').prop('disabled', libera)
        $('#txtHistContato').prop('disabled', libera)
        $('#txtHistObs').prop('disabled', libera)
        if (libera) {
            $('#btnIncluirHistorico').removeClass('d-none')
            $('#btnAlterarHistorico').removeClass('d-none')
            $('#btnExcluirHistorico').removeClass('d-none')
            $('#btnFecharHistorico').removeClass('d-none')
            $('#btnConfirmarHistorico').addClass('d-none')
            $('#btnDesistirHistorico').addClass('d-none')
        } else {
            $('#btnIncluirHistorico').addClass('d-none')
            $('#btnAlterarHistorico').addClass('d-none')
            $('#btnExcluirHistorico').addClass('d-none')
            $('#btnFecharHistorico').addClass('d-none')
            $('#btnConfirmarHistorico').removeClass('d-none')
            $('#btnDesistirHistorico').removeClass('d-none')
        }
    }

    $('#btnIncluirHistorico').on('click', function () {
        bloqueiaCamposHist(false)
        bloqueiaTable = true
        alterando = false;

        let date = new Date()
        let hora = date.getHours()
        let min = date.getMinutes()
        let sec = date.getSeconds()
        let horaFormatada = (hora < 10 ? "0" : "") + hora;
        let minutosFormatados = (min < 10 ? "0" : "") + min;
        let segundosFormatados = (sec < 10 ? "0" : "") + sec;
        let horaAtual = horaFormatada + ":" + minutosFormatados + ":" + segundosFormatados;

        $("#txtHistVisita").val(date.toISOString().split('T')[0]);
        $('#txtHistHora').val(horaAtual)
    })

    $('#btnAlterarHistorico').on('click', function () {
        let tabela = $("#tabelaCadHistorico").DataTable()
        let linha = tabela.$("tr.selected");
        if (linha.length > 0) {
            bloqueiaTable = true
            alterando = true
            indiceLinha = linha.index()

            bloqueiaCamposHist(false)
        } else {
            msgAlerta('Nenhum registro selecionado para alterar!')
        }
    })

    $('#tabelaCadHistorico').on('click', 'tr', async function () {
        if (!alterando) {
            $("#tabelaCadHistorico").dataTable().$("tr.selected").removeClass("selected");
            $(this).addClass('selected')
            let tabela = $("#tabelaCadHistorico").DataTable()
            let linha = tabela.$("tr.selected");
            let hist = tabela.row(linha).data()
            $('#cbHistLigacao').prop('checked', hist[12] == 'S' ? true : false)
            $('#cbHistEmail').prop('checked', hist[13] == 'S' ? true : false)
            $('#cbHistVisita').prop('checked', hist[14] == 'S' ? true : false)
            $('#cbHistWhatsapp').prop('checked', hist[15] == 'S' ? true : false)
            $('#cbHistOutros').prop('checked', hist[16] == 'S' ? true : false)
            $('#txtHistVisita').val(hist[0])
            $('#txtHistHora').val(hist[1])
            $('#txtHistRetorno').val(hist[3])
            $('#txtHistPrioridade').val(hist[6])
            insereValor('#txtHistRepresentante', hist[4], hist[5])
            insereValor('#txtHistRamo', hist[9], hist[10])
            insereValor('#txtHistStatus', hist[7], hist[8])
            $('#txtHistContato').val(hist[11])
            $('#txtHistObs').val(hist[2])
        }
    })

    $('#btnDesistirHistorico').on('click', function () {
        bloqueiaCamposHist(true)
        bloqueiaTable = false
        alterando = false
        limpaCamposHistorico()
    })

    $('#btnConfirmarHistorico').on('click', async function () {
        if ($('#txtHistObs').val() == '') {
            msgAlerta('Observação não informada, impossivel Continuar!')
        } else if (alterando) {
            await insereValorHistorico(true, indiceLinha)
            bloqueiaCamposHist(true)
        } else {
            await insereValorHistorico(false, 0)
            bloqueiaCamposHist(true)
        }
    })

    $('#modal-historico').on('hidden.bs.modal', function () {
        $.LoadingOverlay('show')
        try {
            let tabPrincipal = $('#tabelaHistorico').DataTable()
            let tabCadastro = $('#tabelaCadHistorico').DataTable()
            tabPrincipal.clear().draw();

            let dadosHist = tabCadastro.rows().data().toArray()

            tabPrincipal.rows.add(dadosHist).draw()
        } finally {
            $.LoadingOverlay('hide')
        }
    })
});
