$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
    });
    driver.defineSteps([
      {
        element: "#btnFiltros",
        popover: {
          title: "Botão Filtros",
          description: "Clique aqui para filtrar consulta.",
          position: "right",
        },
      },
      {
        element: "#btnNovaMoeda",
        popover: {
          title: "Botão Incluir",
          description:
            "Clique aqui para iniciar o cadastro de uma faixa de tamanho.",
          position: "right",
        },
      },
      {
        element: "#tabelaFaixaTamanho",
        popover: {
          title: "Tabela Faixa de Tamanho",
          description: "Aqui estão os dados das faixas de tamanho cadastradas.",
          position: "top",
        },
      },
    ]);
    driver.start();
  });
});
$(document).ready(async function () {
  // autocompleta
  $("#txtFaixaTamanhoConsulta").autocompleta(
    1,
    `JSON={ "tabela":"pcpfaixa", "camposSelect":[ "faixa chave", "tipo descricao"], "where": null}`
  );
  // pesquisa
  $("#btn-FaixaTamanho").pesquisa(
    "#txtFaixaTamanhoConsulta",
    "FAIXA",
    "TIPO",
    `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"pcpfaixa", "camposSelect":[ "faixa", "tipo"]}`,
    "Pesquisa Faixa",
    "pcpfaixa"
  );
  // limpacampo
  $("#btn-limpa-FaixaTamanho").on("click", function () {
    $("#txtFaixaTamanhoConsulta").val("");
  });

  $("#btnFiltros").on("click", function () {
    $("#modal-filtros").modal("show");
  });

  function retornaBotaoOpcoes() {
    return (
      '<div class="divBtnOpcoes"> ' +
      '    <button class="botaoOpcoes" type="button" title="Editar" id="btn-editar"><span class="fas fa-edit" style="color:green"></span></button>      ' +
      '    <button class="botaoOpcoes" type="button" title="Excluir" id="btn-excluir"><span class="fas fa-trash-alt" style="color:red"></span></button>  ' +
      "   </div>"
    );
  }

  consultaFaixaTamanho();

  $("#btnConsultar").on("click", async function () {
    $("#modal-filtros").modal("hide");
    await consultaFaixaTamanho(true);
  });

  $("#btnLimparFiltros").on("click", async function () {
    $("#txtFaixaTamanhoConsulta").val("");
  });

  async function consultaFaixaTamanho(bBotao = false) {
    try {
      $.LoadingOverlay("show");
      let response;
      let codigo =
        pegaChave("#txtFaixaTamanhoConsulta") != ""
          ? ` AND FAIXA = '${pegaChave("#txtFaixaTamanhoConsulta")}'`
          : "";
      if (bBotao) {
        response = await requisicao(
          "GET",
          "/Sisplan/Funcoes/V1/pesquisa?",
          `JSON={ "tabela":"pcpfaixa", "camposSelect":[ "faixa", "DESCRICAO"], "where": ["1=1 ${codigo}"]}`,
          null
        );
      } else {
        response = await requisicao(
          "GET",
          "/Sisplan/Funcoes/V1/pesquisa?",
          'JSON={ "tabela":"pcpfaixa", "camposSelect":[ "faixa", "DESCRICAO"], "where": null, "limit": 10000}',
          null
        );
      }

      if (!response) {
        $.LoadingOverlay("hide");
        return;
      }

      let jsonStr = await response.json();
      if (response.status != 200) {
        $.LoadingOverlay("hide");
        msgErro(jsonStr.RESULT[0].mensagem);
        return;
      }

      $("#tabelaFaixaTamanho").DataTable({
        destroy: true,
        lengthChange: false,
        serverside: true,
        language: {
          sEmptyTable: "Nenhum registro encontrado",
          sInfo: "_TOTAL_ registros",
          sInfoEmpty: " 0 registros",
          sInfoFiltered: "(Filtrados de _MAX_ registros)",
          sInfoPostFix: "",
          sInfoThousands: ".",
          sLengthMenu: "_MENU_ resultados",
          sLoadingRecords: "Carregando...",
          sProcessing: "Processando...",
          sZeroRecords: "Nenhum registro encontrado",
          sSearch: "Pesquisar",
          oPaginate: {
            sNext: "Próximo",
            sPrevious: "Anterior",
            sFirst: "Primeiro",
            sLast: "Último",
          },
          oAria: {
            sSortAscending: ": Ordenar colunas de forma ascendente",
            sSortDescending: ": Ordenar colunas de forma descendente",
          },
        },

        autoWidth: true,
        data: jsonStr.RESULT[0],
        columns: [
          {
            data: "FAIXA",
          },
          {
            data: "DESCRICAO",
          },
          {
            data: null,
          },
        ],
        columnDefs: [
          {
            targets: -1,
            data: null,
            className: "tdBtnOpcoes",
            defaultContent: retornaBotaoOpcoes(),
          },
        ],
      });

      $.LoadingOverlay("hide");
    } catch (error) {
      console.error(error);
      $.LoadingOverlay("hide");
    }
  }

  $("#tabelaFaixaTamanho").on("click", "#btn-editar", async function () {
    let data = $("#tabelaFaixaTamanho")
      .DataTable()
      .row($(this).parents("tr"))
      .data();
    // let registroLiberado = await verificarRegistro("FAIXATAMANHO", data.CODIGO);
    // if (registroLiberado) {
    window.location.href = `pcpfaixa/${data.FAIXA}`;
    // }
  });

  $("#tabelaFaixaTamanho").on("dblclick", "tr", async function () {
    let data = $("#tabelaFaixaTamanho").DataTable().row($(this)).data();
    // let registroLiberado = await verificarRegistro("FAIXATAMANHO", data.CODIGO);
    // if (registroLiberado) {
    window.location.href = `pcpfaixa/${data.FAIXA}`;
    // }
  });

  $("#tabelaFaixaTamanho").on("click", "#btn-excluir", async function () {
    if (confirm("Você realmente deseja excluir esse registro?")) {
      try {
        let data = $("#tabelaFaixaTamanho")
          .DataTable()
          .row($(this).parents("tr"))
          .data();

        let response = await requisicao(
          "DELETE",
          "/Sisplan/Cadastros/v1/pcpfaixa?",
          `CODIGOFAIXA=${encodeURIComponent(data.FAIXA)}`,
          null
        );

        if (!response) {
          $.LoadingOverlay("hide");
          return;
        }

        let jsonStr = await response.json();
        if (response.status != 200) {
          $.LoadingOverlay("hide");
          msgErro(jsonStr.mensagem);
          return;
        }
        // location.reload();
        $.LoadingOverlay("hide");
        toastr
          .success("Exclusão efetuada com sucesso!", "Confirmação", {
            toastClass: "alert",
            iconClasses: {
              error: "alert-error",
              info: "alert-info",
              success: "alert-success",
              warning: "alert-warning",
            },
            positionClass: "toast-top-center",
            progressBar: true,
            timeOut: 3000,
            fadeOut: 1000,

            onHidden() {
              location.reload();
            },
          })
          .css({
            "margin-top": "20%",
            width: "500px",
            "max-width": "500px",
          });
      } catch (error) {
        console.error(error);
      }
    }
  });
});
