$(document).ready(async function () {

  const orcamento = $(window.location.href.split('/')).get(-1);
  const parametrosComercial = await BuscaParametrosPedido();
  let itensAlteracao = []

  const colunasItens = [
    { title: 'Ordem', data: 'ORDEM' },
    { title: 'Código', data: 'CODIGO' },
    { title: 'Descrição', data: 'DESCRICAO' },
    { title: 'Cor', data: 'COR' },
    { title: 'Desc. Cor', data: 'DESCCOR' },
    { title: 'Tam', data: 'TAM' },
    { title: 'Qtde', data: 'QTDE' },
    { title: 'Preço', data: 'PRECO' },
    { title: 'Valor', data: 'VALOR' },
    { title: 'Custom', data: 'CUSTOMIZACAO' },
    { title: 'ObsProd', data: 'OBS2' },
    { title: 'ObsProducao', data: 'OBS3' },
    { title: 'ObsEspec', data: 'OBSERVACAO' },
    { title: 'Faixa', data: 'FAIXA' },
    { title: 'Excluir', data: 'EXCLUIR' },
  ];

  const colunasCaracteristicas = [
    { title: 'SEL', data: 'SEL' },
    { title: 'Código', data: 'CODIGO' },
    { title: 'Descrição', data: 'DESCRICAO' },
    { title: 'Valor', data: 'VALOR' },
    { title: 'Existe', data: 'EXISTE' },
    { title: 'Id', data: 'ID' },
    { title: 'Cons. Tecido.', data: 'CONS_TECIDO' },
    { title: 'Cod. Apl.', data: 'COD_APL' },
  ];

  const colunasComposicao = [
    { title: 'Código', data: 'CODIGO' },
    { title: 'Descrição', data: 'DESCRICAO' },
    { title: 'Cor', data: 'COR' },
    { title: 'Desc Cor', data: 'DESC_COR' },
    { title: 'Fornecedor', data: 'FORNECEDOR' },
    { title: 'Nome Fornecedor', data: 'NOME_FORNECEDOR' },
    { title: 'Ações', data: 'ACOES' },
  ];

  const colunasFt = [
    { title: 'Tipo', data: 'TIPO' },
    { title: 'Ordem', data: 'ORDEM' },
    { title: 'Código', data: 'CODIGO' },
    { title: 'Descrição', data: 'DESCRICAO' },
    { title: 'Consumo', data: 'CONSUMO' },
    { title: 'Cor', data: 'COR' },
  ];

  const colunasGrade = [
    { title: 'Tamanho', data: 'TAMANHO' },
    { title: 'Qtde', data: 'QTDE' },
    { title: 'Preço', data: 'PRECO' },
    { title: '% Acresc.', data: 'PERC_ACRESC' },
    { title: 'Val Acresc.', data: 'VAL_ACRESC' },
    { title: '% Desc.', data: 'PERC_DESC' },
    { title: 'Val Desc.', data: 'VAL_DESC' },
    { title: 'Preço Líq.', data: 'PRECO_LIQ' },
    { title: 'Total', data: 'TOTAL' },
  ];

  const colunasAplicacoes = [
    { title: 'Característica', data: 'CARACTERISTICA' },
    { title: 'Subcaracterística', data: 'SUBCARACTERISTICA' },
    { title: 'ID', data: 'ID' },
    { title: 'Cod. Apl.', data: 'COD_APL' },
  ];

  const colunasTecidosUtilizados = [
    { title: 'SEL', data: 'SEL' },
    { title: 'Código', data: 'CODIGO' },
    { title: 'Descrição', data: 'DESCRICAO' },
    { title: 'Altura', data: 'ALTURA' },
    { title: 'Largura', data: 'LARGURA' },
    { title: 'Fundo', data: 'FUNDO' },
    { title: 'Visor', data: 'VISOR' },
    { title: 'Consumo', data: 'CONSUMO' },
    { title: 'Cor', data: 'COR' },
    { title: 'Fornecedor', data: 'FORNECEDOR' },
    { title: 'Id', data: 'ID' },
    { title: 'Cod. Apl', data: 'COD_APL' },
  ];

  const colunasConsumos = [
    { title: 'Código', data: 'CODIGO' },
    { title: 'Descrição', data: 'DESCRICAO' },
    { title: 'Qtde', data: 'QTDE' },
    { title: 'Custo', data: 'CUSTO' },
    { title: 'Setor', data: 'SETOR' },
    { title: 'Desc Setor', data: 'DESC_SETOR' },
    { title: 'Cor', data: 'COR' },
    { title: 'Desc Cor', data: 'DESC_COR' },
  ];

  const colunasSerigrafiaTipo = [
    { title: 'Código', data: 'CODIGO' },
    { title: 'Qtde Cores', data: 'QTDE_CORES' },
    { title: 'Descrição', data: 'DESCRICAO' },
    { title: 'Preço', data: 'PRECO' },
  ];

  const colunasSerigrafiaLocal = [
    { title: 'Código', data: 'CODIGO' },
    { title: 'Descrição', data: 'DESCRICAO' },
    { title: 'Preço', data: 'PRECO' },
  ];

  const colunasSerigrafiaTamanho = [
    { title: 'Código', data: 'CODIGO' },
    { title: 'Descrição', data: 'DESCRICAO' },
  ];

  const colunasSerigrafia = [
    { title: 'Nome', data: 'NOME' },
    { title: 'Tipo', data: 'TIPO' },
    { title: 'Tamanho', data: 'TAMANHO' },
    { title: 'Local', data: 'LOCAL' },
    { title: 'Qtde Cores', data: 'QTDE_CORES' },
    { title: 'Total', data: 'TOTAL' },
    { title: 'Altura', data: 'ALTURA' },
    { title: 'Largura', data: 'LARGURA' },
    { title: 'Preço', data: 'PRECO' },
  ];

  const colunasBordadoProgramacao = [
    { title: 'Código', data: 'CODIGO' },
    { title: 'Descrição', data: 'DESCRICAO' },
    { title: 'Preço', data: 'PRECO' }
  ];

  const colunasBordadoTamanho = [
    { title: 'Código', data: 'CODIGO' },
    { title: 'Descrição', data: 'DESCRICAO' },
    { title: 'Preço', data: 'PRECO' }
  ];

  const colunasBordadoLocal = [
    { title: 'Código', data: 'CODIGO' },
    { title: 'Descrição', data: 'DESCRICAO' },
    { title: 'Preço', data: 'PRECO' },
    { title: 'Margem', data: 'MARGEM' }
  ];

  const colunasBordado = [
    { title: 'Nome', data: 'NOME' },
    { title: 'Programação', data: 'PROGRAMACAO' },
    { title: 'Tamanho', data: 'TAMANHO' },
    { title: 'Local', data: 'LOCAL' },
    { title: 'Qtde Prog', data: 'QTDE_PROG' },
    { title: 'Total', data: 'TOTAL' },
    { title: 'Altura', data: 'ALTURA' },
    { title: 'Largura', data: 'LARGURA' },
    { title: 'Preço', data: 'PRECO' },
  ];

  const colunasSublimacao = [
    { title: 'SEL', data: 'SEL' },
    { title: 'Código', data: 'CODIGO' },
    { title: 'Descrição', data: 'DESCRICAO' },
    { title: 'Preço', data: 'PRECO' },
  ];

  const colunasTermotapeTipo = [
    { title: 'Código', data: 'CODIGO' },
    { title: 'Descrição', data: 'DESCRICAO' },
    { title: 'Preço', data: 'PRECO' },
  ];

  const colunasTermotape = [
    { title: 'Código', data: 'CODIGO' },
    { title: 'Descrição', data: 'DESCRICAO' },
    { title: 'Tam CM²', data: 'TAM_CM2' },
    { title: 'Total', data: 'TOTAL' },
    { title: 'Preço', data: 'PRECO' },
  ];

  let idCaracteristica = '';

  await verificaPermissoes('ORCAMENTO');
  await adicionaEmpresas();
  await setarDataAtual('dtDigitacao');
  await setarDataAtual('dtEmissao');
  await carregaValoresPadroes();

  addPesquisaAutocompleta();
  criaMascaraCampos();
  addBotoesAvancarVoltar();
  addValidacaoCamposObrigatorios();

  const retornaBotaoOpcoes = () => {
    return '<div class="p-0 d-flex"> ' +
      '     <button class="botaoOpcoes btn-sm" type="button" title="Editar" id="btn-editar" style="background-color:var(--blue); padding: 5px 1px 5px 6px;"><span class="fas fa-edit" style="color:white !important"></span></button>  ' +
      '     <button class="divBtnItens botaoOpcoes btn-sm" type="button" title="Excluir" id="btn-excluir" style="padding: 5px 2px 5px 4px;"><span class="fas fa-trash-alt" style="color:white !important"></span></button>  ' +
      '   </div>';
  };

  criaDataTablePadrao('#tabelaDuplicatas', false, false, false, false, true, false, '193px');
  criaDataTablePadrao('#tabelaItens', false, false, false, false, true, false, '300px', undefined, colunasItens, [10, 11, 12, 13], [], [], [], { targets: 14, funcao: function (data, type, row) { return retornaBotaoOpcoes() } });
  criaDataTablePadrao('#tabelaCaracteristicas', false, false, false, false, true, false, '300px', undefined, colunasCaracteristicas, [4, 5, 6, 7]);
  criaDataTablePadrao('#tabelaComposicao', false, false, false, false, true, false, '300px', undefined, colunasComposicao);
  criaDataTablePadrao('#tabelaFt', false, false, false, false, true, false, '300px', undefined, colunasFt);
  criaDataTablePadrao('#tabelaGrade', false, false, false, false, true, false, '300px', undefined, colunasGrade);
  criaDataTablePadrao('#tabelaAplicacoes', false, false, false, false, true, false, '300px', undefined, colunasAplicacoes, [2, 3]);
  criaDataTablePadrao('#tabelaTecidosUtilizados', false, false, false, false, true, false, '300px', undefined, colunasTecidosUtilizados, [8, 9, 10, 11]);
  criaDataTablePadrao('#tabelaConsumos', false, false, false, false, true, false, '300px', undefined, colunasConsumos, [], [], [], [], {}, null, null, null, null, [], [2, 3]);
  criaDataTablePadrao('#tabelaSerigrafia', false, false, false, false, true, false, '400px', undefined, colunasSerigrafia);
  criaDataTablePadrao('#tabelaSerigrafiaTipo', false, false, false, false, true, false, '200px', undefined, colunasSerigrafiaTipo, [0, 1, 3]);
  criaDataTablePadrao('#tabelaSerigrafiaLocal', false, false, false, false, true, false, '200px', undefined, colunasSerigrafiaLocal, [0, 2]);
  criaDataTablePadrao('#tabelaSerigrafiaTamanho', false, false, false, false, true, false, '200px', undefined, colunasSerigrafiaTamanho, [0]);
  criaDataTablePadrao('#tabelaBordado', false, false, false, false, true, false, '400px', undefined, colunasBordado);
  criaDataTablePadrao('#tabelaBordadoProgramacao', false, false, false, false, true, false, '200px', undefined, colunasBordadoProgramacao, [0, 2]);
  criaDataTablePadrao('#tabelaBordadoTamanho', false, false, false, false, true, false, '200px', undefined, colunasBordadoTamanho, [0, 2]);
  criaDataTablePadrao('#tabelaBordadoLocal', false, false, false, false, true, false, '200px', undefined, colunasBordadoLocal, [0, 2, 3]);
  criaDataTablePadrao('#tabelaSublimacao', false, false, false, false, true, false, '400px', undefined, colunasSublimacao);
  criaDataTablePadrao('#tabelaTermotapeTipo', false, false, false, false, true, false, '200px', undefined, colunasTermotapeTipo, [2]);
  criaDataTablePadrao('#tabelaTermotape', false, false, false, false, true, false, '400px', undefined, colunasTermotape, [0]);

  await carregaCustomSerigrafiaTipo();
  await carregaCustomSerigrafiaLocal();
  await carregaCustomSerigrafiaTam();

  await carregaCustomBordadoProg();
  await carregaCustomBordadoTam();
  await carregaCustomBordadoLocal();

  await carregaCustomSublimacao();
  await carregaCustomTermotape();

  await validaEdicao();

  let alterandoComposicao = false;
  let indexComposicao = -1;
  const usaPrecoCorTam = await CopiaParametro("VENDA", 5) == 1

  $(".radio-group .radio").click(function () {
    $(this).parent().find(".radio").removeClass("selected");
    $(this).addClass("selected");
  });

  $(".submit").click(function () {
    return false;
  });

  $('#txtLinha, #txtGrupo, #txtEtiqueta').on('blur', async function () {
    const linha = pegaChave('#txtLinha');
    const grupo = pegaChave('#txtGrupo');
    const etiqueta = pegaChave('#txtEtiqueta');

    if ((linha == '') || (grupo == '') || (etiqueta == '')) {
      return;
    }

    await buscaCaracteristica(linha, grupo, etiqueta);
  });

  $('#btnAddSerigrafia').on('click', function () {
    addSerigrafia();
  });

  $('#btnRemoveSerigrafia').on('click', function () {
    removeSerigrafia();
  });

  $('#btnAddBordado').on('click', function () {
    addBordado();
  });

  $('#btnRemoveBordado').on('click', function () {
    removeBordado();
  });

  $('#btnAddTermotape').on('click', function () {
    addTermotape();
  });

  $('#btnAddComposicao').on('click', function () {
    $('#modalComposicao').modal('show');
  });

  $('#btnAddItem').on('click', function () {
    $('#modalItem').modal('show');
    $('#txtFaixa').prop('disabled', true)
    $('#btnFaixa').prop('disabled', true)
    $('#btnAFaixa').prop('disabled', true)

    $('#txtCodigo').prop('disabled', false)
    $('#btn-Codigo').prop('disabled', false)
    $('#btn-limpa-Codigo').prop('disabled', false)

    $('#txtCor').prop('disabled', false)
    $('#btn-Cor').prop('disabled', false)
    $('#btn-limpa-Cor').prop('disabled', false)

    $('#txtQtde').prop('disabled', false)
  });

  $('#btnConfirmarComposicao').on('click', function () {
    adicionaComposicao();
  });

  $('#tabelaComposicao').on('click', '#btn-excluir-composicao', async function () {
    await msgAguardaConfirmacao('Você realmente deseja excluir esse registro?', async () => {
      $.LoadingOverlay('show')
      try {
        $('#tabelaComposicao').DataTable().row($(this).parents('tr')).remove().draw(false);
      } finally {
        $.LoadingOverlay('hide')
      }
    })
  });

  $('#tabelaComposicao').on('click', '#btn-editar-composicao', async function () {
    $.LoadingOverlay('show')
    try {
      let item = $('#tabelaComposicao').DataTable().row($(this).parents('tr')).data()
      indexComposicao = $('#tabelaComposicao').DataTable().row($(this).parents('tr')).index()
      $('#modalComposicao').modal('show')
      insereValor('#txtFornecedor', item.FORNECEDOR, item.NOME_FORNECEDOR)
      insereValor('#txtMaterial', item.CODIGO, item.DESCRICAO)
      insereValor('#txtCorItem', item.COR, item.DESC_COR)
      alterandoComposicao = true;
    } finally {
      $.LoadingOverlay('hide')
    }
  })

  $("#modalItem").on('shown.bs.modal', async function () {
    ajustaTabelasModalItem();
    if ($('#dtEntrega').val() != '') {
      $('#dtEntregaItem').val($('#dtEntrega').val());
    }
  });

  $('#tabCaracteristicas, #tabComposicao, #tabAplicacoes, #tabConsumos, #tabGrade, #tabObs, #tabFt, #tabSerigrafia, #tabBordado, #tabSublimacao, #tabTermotape').on('click', async function () {
    setTimeout(() => { ajustaTabelasModalItem() }, 200);
    if ($(this)[0].id == 'tabAplicacoes' && $('#tabelaTecidosUtilizados').DataTable().rows('.selected').data().toArray().length <= 0) {
      let existeCorVazia = false;
      for (let i = 0; i < $('#tabelaComposicao').DataTable().data().toArray().length; i++) {
        const item = $('#tabelaComposicao').DataTable().data().toArray()[0]

        if (item.COR == '') {
          existeCorVazia = true
          break
        }
      }

      if (existeCorVazia) {
        msgAlerta('Existem composições sem cor informada, impossível continuar!')
        setTimeout(() => { $('#tabComposicao').trigger('click') }, 200);
      } else {
        carregaAplicacoes();
      }
    }
    if ((($(this)[0].id == 'tabGrade') && (pegaValor('#txtFaixa') != '')) || ((pegaValor('#txtCodigo') != ''))) {
      // if ($('#txtMarkup').val() == '') {
      //   msgAlerta('Selecione um Markup')
      //   $('#txtMarkup').focus()
      //   setTimeout(() => { $('#tabComposicao').trigger('click') }, 200);
      //   return
      // }

      if ((pegaValor('#txtCodigo') == '') && (pegaValor('#txtCor') == '')) {
        await explodeFaixa(pegaChave('#txtFaixa'));
      } else {
        let tabela = pegaChave('#txtTabPreco')
        if (tabela == '') {
          const pesquisaParam = {
            tabela: 'REGIAO',
            camposSelect: ['REGIAO'],
            where: [`PADRAO = 'S'`],
          }

          const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

          tabela = jsonStr[0].REGIAO
        }
        await explodeFaixaExpress(pegaChave('#txtFaixa'), tabela, pegaChave('#txtCodigo'));
      }
      atualizaTotaisGrade()
    }
  });

  $('#txtFaixa').on('blur', async function () {
    if (!$('#txtFaixa').val()) {
      return
    }
    if (!$('#txtCodigo').val()) {
      throw msgAlerta('É necessário inserir um código para explodir a grade.')
    }
    $.LoadingOverlay('show')
    try {
      if ((pegaValor('#txtCodigo') == '') && (pegaValor('#txtCor') == '')) {
        await explodeFaixa(pegaChave('#txtFaixa'));
      } else {
        let tabela = pegaChave('#txtTabPreco')
        if (tabela == '') {
          const pesquisaParam = {
            tabela: 'REGIAO',
            camposSelect: ['REGIAO'],
            where: [`PADRAO = 'S'`],
          }

          const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

          tabela = jsonStr[0].REGIAO
        }
        await explodeFaixaExpress(pegaChave('#txtFaixa'), tabela, pegaChave('#txtCodigo'));
      }
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }
  })

  $('#tabCustomizacoes').on('click', function () {
    setTimeout(() => { $('#tabSerigrafia').trigger('click') }, 200);
    setTimeout(() => { ajustaTabelasModalItem() }, 200);
  });

  $('#txtCliente').on('blur', async function () {
    await buscaRepresentanteCliente();
    await buscaContatoCliente();
    await buscaTabelaCliente();
  });

  $('#txtRepresentante').on('blur', async function () {
    await buscaComissaoRepresentante();
  });

  $("#edtVencimento1, #edtVencimento2, #edtVencimento3, #edtVencimento4, #edtVencimento5, #edtVencimento6, #edtVencimento7, #edtVencimento8, #edtVencimento9, #edtVencimento10, #edtVencimento11, #edtVencimento12").change(async function () {
    await simulaFinanceiro();
  });

  $('#txtDias').on('blur', function () {
    const dias = pegaValor('#txtDias');

    if (dias == '') {
      return;
    }

    if ($('#rdSumDiasCorridos').is(':checked')) {
      consideraDiasCorridos(dias)
    }

    if ($('#rdSumDiasUteis').is(':checked')) {
      consideraDiasUteis(dias)
    }

  });

  $('#rdSumDiasCorridos, #rdSumDiasUteis').on('change', function () {
    const dias = pegaValor('#txtDias');

    if (dias == '') {
      return;
    }

    if ($('#rdSumDiasCorridos').is(':checked')) {
      consideraDiasCorridos(dias)
    }

    if ($('#rdSumDiasUteis').is(':checked')) {
      consideraDiasUteis(dias)
    }
  })

  function consideraDiasCorridos(dias) {
    setarDataAtual('dtEntrega', false, parseFloat(dias));
    setarDataAtual('dtSaida', false, parseFloat(dias));
  }

  function consideraDiasUteis(dias) {
    var dataInicial = new Date();

    var data = new Date(dataInicial);

    var contadorDias = 0;
    while (contadorDias < dias) {
      data.setDate(data.getDate() + 1);
      if (data.getDay() !== 0 && data.getDay() !== 6) {
        contadorDias++;
      }
    }

    var ano = data.getFullYear();
    var mes = ("0" + (data.getMonth() + 1)).slice(-2);
    var dia = ("0" + data.getDate()).slice(-2);
    var dataFinalFormatada = ano + "-" + mes + "-" + dia;

    $("#dtEntrega").val(dataFinalFormatada);
    $("#dtSaida").val(dataFinalFormatada);
  }

  $('#tabelaCaracteristicas').on('click', 'td', function () {
    selecionarLinhaTabela('#tabelaCaracteristicas', 'checkCaracteristica', this);
  });

  $('#tabelaTecidosUtilizados').on('click', 'td', function () {
    selecionarLinhaTabela('#tabelaTecidosUtilizados', 'checkAplicacoes', this);
  });

  $('#tabelaBordadoProgramacao').on('click', 'tr', async function () {
    $('#tabelaBordadoProgramacao > tbody > tr').removeClass('selected');
    $(this).closest('tr').addClass('selected');
  });

  $('#tabelaBordadoTamanho').on('click', 'tr', async function () {
    $('#tabelaBordadoTamanho > tbody > tr').removeClass('selected');
    $(this).closest('tr').addClass('selected');
  });

  $('#tabelaBordadoLocal').on('click', 'tr', async function () {
    $('#tabelaBordadoLocal > tbody > tr').removeClass('selected');
    $(this).closest('tr').addClass('selected');
  });

  $('#tabelaSerigrafiaTipo').on('click', 'tr', async function () {
    $('#tabelaSerigrafiaTipo > tbody > tr').removeClass('selected');
    $(this).closest('tr').addClass('selected');
    await carregaCustomSerigrafiaTam();
  });

  $('#tabelaSerigrafiaLocal').on('click', 'tr', function () {
    $('#tabelaSerigrafiaLocal > tbody > tr').removeClass('selected');
    $(this).closest('tr').addClass('selected');
  });

  $('#tabelaSerigrafiaTamanho').on('click', 'tr', function () {
    $('#tabelaSerigrafiaTamanho > tbody > tr').removeClass('selected');
    $(this).closest('tr').addClass('selected');
  });

  $('#tabelaSerigrafia').on('click', 'tr', function () {
    $('#tabelaSerigrafia > tbody > tr').removeClass('selected');
    $(this).closest('tr').addClass('selected');
  });

  $('#tabelaBordado').on('click', 'tr', function () {
    $('#tabelaBordado > tbody > tr').removeClass('selected');
    $(this).closest('tr').addClass('selected');
  });

  $('#tabelaSublimacao').on('click', 'tr', function () {
    $('#tabelaSublimacao > tbody > tr').removeClass('selected');
    $(this).closest('tr').addClass('selected');
  });

  $('#tabelaTermotapeTipo').on('click', 'tr', function () {
    $('#tabelaTermotapeTipo > tbody > tr').removeClass('selected');
    $(this).closest('tr').addClass('selected');
  });

  $('#txtCodigo').on('blur', async function () {

    $.LoadingOverlay('show')
    try {
      const codigo = pegaChave('#txtCodigo');
      const cor = pegaChave('#txtCor')
      if (codigo == '') {
        return;
      }

      $('#txtCor').unbind('autocompleta');
      $('#txtCor').autocompleta(1, `JSON={ "tabela":"PA_ITEN", "camposSelect":["PA_ITEN.COR CHAVE, CADCOR.DESCRICAO"], "leftjoin": [{ "tabela" : "CADCOR", "condicao" : "PA_ITEN.COR = CADCOR.COR" }], "groupBy": ["PA_ITEN.COR", "CADCOR.DESCRICAO"], "where": ["PA_ITEN.CODIGO = '${codigo}' AND PA_ITEN.ATIVO = 'S'"] }`);
      $('#btn-Cor').off();
      $('#btn-Cor').unbind();
      $('#btn-Cor').pesquisa_array(['#txtCor'], ['COR'], ['DESCRICAO'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"PA_ITEN", "camposSelect":[ "PA_ITEN.COR", "CADCOR.DESCRICAO" ],"leftjoin": [{ "tabela" : "CADCOR", "condicao" : "PA_ITEN.COR = CADCOR.COR" }], "groupBy": ["PA_ITEN.COR", "CADCOR.DESCRICAO"], "where": ["PA_ITEN.CODIGO = '${codigo}' AND PA_ITEN.ATIVO = 'S'"]}`, 'Pesquisa Cor', 'CADCOR');
      await preencheFaixa()

      if (!cor) {
        const pesquisaCor = {
          tabela: "PA_ITEN",
          camposSelect: [
            "PA_ITEN.COR",
            "CADCOR.DESCRICAO"
          ],
          leftJoin: [{ tabela: "CADCOR", condicao: "PA_ITEN.COR = CADCOR.COR" }],
          groupBy: [
            "PA_ITEN.COR",
            "CADCOR.DESCRICAO"
          ],
          where: [`PA_ITEN.CODIGO = '${codigo}' AND PA_ITEN.ATIVO = 'S'`],
        }
        const jsonStrCor = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaCor));

        if (jsonStrCor && jsonStrCor.length == 1) {
          insereValor('#txtCor', jsonStrCor[0].COR, jsonStrCor[0].DESCRICAO)
          $('#txtCor').trigger('blur')
        }
      }

    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }

  });

  $('#txtCor').on('focusout', async function () {
    const codigo = pegaChave('#txtCodigo');
    const cor = pegaChave('#txtCor');

    if ((codigo == '') || (cor == '')) {
      return;
    }

    await carregaConsumosExpress(codigo, cor)
  });

  async function validaEdicao() {
    if (orcamento == 'create') {
      insereValor('#txtNumero', await RetornaProximo('OS', 'OS', 'NUMERO', 5));
      const codrep = (await buscaValor('ACESSO_USUARIOS', 'CODREP', 'CODIGO', getCookie('cod_usuario'))).CODREP
      if (codrep) insereValor('#txtRepresentante', codrep, { tabela: 'REPRESEN', campoBusca: 'NOME', campoWhere: 'CODREP', valorWhere: codrep })
      return;
    } else {
      await buscarOrcamento(orcamento)
    }
  }

  async function buscaRepresentanteCliente() {
    const codcli = pegaChave('#txtCliente');

    if (codcli == '') {
      return;
    }

    if (pegaChave('#txtRepresentante') != '') {
      await buscaComissaoRepresentante();
      return;
    }

    const pesquisaParam = {
      tabela: 'ENTIDADE',
      camposSelect: ['ENTIDADE.CODREP', 'REPRESEN.NOME'],
      leftJoin: [{ tabela: 'REPRESEN', condicao: `ENTIDADE.CODREP = REPRESEN.CODREP` }],
      where: [`ENTIDADE.CODCLI = '${codcli}'`]
    }

    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

    if (jsonStr[0].CODREP != '') {
      insereValor('#txtRepresentante', jsonStr[0].CODREP, jsonStr[0].NOME);
      await buscaComissaoRepresentante();
    }
  }

  async function buscaContatoCliente() {
    const codcli = pegaChave('#txtCliente');

    if (codcli == '') {
      return;
    }

    const pesquisaParam = {
      tabela: 'CONTATO',
      camposSelect: ['ID', 'NOME'],
      where: [`CODCLI = '${codcli}' AND TIPO = 'Orçamento'`]
    }

    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

    if (jsonStr.length > 0 && jsonStr[0].NOME != '') {
      insereValor('#txtSolicitante', jsonStr[0].ID, jsonStr[0].NOME);
    } else {
      limpaValor('#txtSolicitante');
    }
  }

  async function buscaComissaoRepresentante() {
    const codrep = pegaChave('#txtRepresentante');

    if (codrep == '') {
      return;
    }

    const pesquisaParam = {
      tabela: 'REPRESEN',
      camposSelect: ['COMISSAO', 'COMISSAO2'],
      where: [`CODREP = '${codrep}'`]
    }

    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

    insereValor('#txtComissaoFat', jsonStr[0].COMISSAO);
    insereValor('#txtComissaoRec', jsonStr[0].COMISSAO2);
  }

  async function carregaCustomSerigrafiaTam() {
    $.LoadingOverlay('show');
    $('#tabelaSerigrafiaTamanho').DataTable().clear().draw(false);
    try {
      if ($('#tabelaSerigrafiaTipo').DataTable().rows().count() == 0) {
        return;
      }

      const descTipo = $('#tabelaSerigrafiaTipo').DataTable().rows('.selected').data()[0].DESCRICAO;
      const qtdeCores = $('#tabelaSerigrafiaTipo').DataTable().rows('.selected').data()[0].QTDE_CORES;

      const pesquisaParam = {
        tabela: 'CUSTOMIZA',
        camposSelect: ['CUSTOMIZA.ID_TAMANHO', 'TAM.DESCRICAO'],
        leftJoin: [{ tabela: 'CUSTOMIZA', alias: 'TAM', condicao: `TAM.ID = CUSTOMIZA.ID_TAMANHO AND TAM.TIPO = 'SERIGTAM'` }],
        where: [`CUSTOMIZA.TIPO = 'SERIGTIPO' AND CUSTOMIZA.DESCRICAO = '${descTipo}'`]
      }

      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

      jsonStr.map(item => {
        $('#tabelaSerigrafiaTamanho').DataTable().row.add({
          CODIGO: item.ID_TAMANHO,
          DESCRICAO: item.DESCRICAO,
        }).draw(false);
      });

      insereValor('#txtQtdeCores', qtdeCores);

      if ($('#tabelaSerigrafiaTamanho').DataTable().rows().count() > 0) {
        $($('#tabelaSerigrafiaTamanho > tbody > tr')[0]).addClass('selected');
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  };

  async function carregaCustomSerigrafiaLocal() {
    const pesquisaParam = {
      tabela: 'CUSTOMIZA',
      camposSelect: ['ID', 'DESCRICAO', 'COALESCE(PRECO, 0) PRECO', 'MARGEM', 'ATIVO'],
      where: [`TIPO = 'SERIGLOCAL'`],
    }

    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

    jsonStr.map(item => {
      $('#tabelaSerigrafiaLocal').DataTable().row.add({
        CODIGO: item.ID,
        DESCRICAO: item.DESCRICAO,
        PRECO: item.PRECO,
      }).draw(false);
    });

    if ($('#tabelaSerigrafiaLocal').DataTable().rows().count() > 0) {
      $($('#tabelaSerigrafiaLocal > tbody > tr')[0]).addClass('selected');
    }
  };

  async function carregaCustomSerigrafiaTipo() {
    const pesquisaParam = {
      tabela: 'CUSTOMIZA',
      camposSelect: ['ID', 'DESCRICAO', 'QTDE_COR', 'COALESCE(VAL_TELA [SOMA] VAL_FOTO [SOMA] VAL_COR, 0) PRECO'],
      where: [`TIPO = 'SERIGTIPO'`],
    }

    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

    jsonStr.map(item => {
      $('#tabelaSerigrafiaTipo').DataTable().row.add({
        CODIGO: item.ID,
        QTDE_CORES: item.QTDE_COR,
        DESCRICAO: item.DESCRICAO,
        PRECO: item.PRECO,
      }).draw(false);
    });

    if ($('#tabelaSerigrafiaTipo').DataTable().rows().count() > 0) {
      $($('#tabelaSerigrafiaTipo > tbody > tr')[0]).addClass('selected');
    }
  };

  async function carregaCustomBordadoProg() {
    const pesquisaParam = {
      tabela: 'CUSTOMIZA',
      camposSelect: ['ID', 'DESCRICAO', 'COALESCE(PRECO, 0) PRECO'],
      where: [`TIPO = 'BORDPROG'`],
    }

    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

    jsonStr.map(item => {
      $('#tabelaBordadoProgramacao').DataTable().row.add({
        CODIGO: item.ID,
        DESCRICAO: item.DESCRICAO,
        PRECO: item.PRECO,
      }).draw(false);
    });

    if ($('#tabelaBordadoProgramacao').DataTable().rows().count() > 0) {
      $($('#tabelaBordadoProgramacao > tbody > tr')[0]).addClass('selected');
    }
  };

  async function carregaCustomBordadoTam() {
    const pesquisaParam = {
      tabela: 'CUSTOMIZA',
      camposSelect: ['ID', 'DESCRICAO', 'COALESCE(PRECO, 0) PRECO'],
      where: [`TIPO = 'BORDTAM'`],
    }

    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

    jsonStr.map(item => {
      $('#tabelaBordadoTamanho').DataTable().row.add({
        CODIGO: item.ID,
        DESCRICAO: item.DESCRICAO,
        PRECO: item.PRECO,
      }).draw(false);
    });

    if ($('#tabelaBordadoTamanho').DataTable().rows().count() > 0) {
      $($('#tabelaBordadoTamanho > tbody > tr')[0]).addClass('selected');
    }
  };

  async function carregaCustomBordadoLocal() {
    const pesquisaParam = {
      tabela: 'CUSTOMIZA',
      camposSelect: ['ID', 'DESCRICAO', 'COALESCE(PRECO, 0) PRECO', 'MARGEM'],
      where: [`TIPO = 'BORDLOCAL'`],
    }

    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

    jsonStr.map(item => {
      $('#tabelaBordadoLocal').DataTable().row.add({
        CODIGO: item.ID,
        DESCRICAO: item.DESCRICAO,
        PRECO: item.PRECO,
        MARGEM: item.MARGEM,
      }).draw(false);
    });

    if ($('#tabelaBordadoLocal').DataTable().rows().count() > 0) {
      $($('#tabelaBordadoLocal > tbody > tr')[0]).addClass('selected');
    }
  };

  async function carregaCustomSublimacao() {
    const pesquisaParam = {
      tabela: 'CUSTOMIZA',
      camposSelect: ['ID', 'DESCRICAO', 'VAL_PROG'],
      where: [`TIPO = 'SUBLI'`],
    }

    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

    jsonStr.map(item => {
      $('#tabelaSublimacao').DataTable().row.add({
        SEL: botaoSelecionarGrid('checkSublimacao'),
        CODIGO: item.ID,
        DESCRICAO: item.DESCRICAO,
        PRECO: item.VAL_PROG
      }).draw(false);
    });

    if ($('#tabelaSublimacao').DataTable().rows().count() > 0) {
      $($('#tabelaSublimacao > tbody > tr')[0]).addClass('selected');
    }
  };

  async function carregaCustomTermotape() {
    const pesquisaParam = {
      tabela: 'CUSTOMIZA',
      camposSelect: ['ID', 'DESCRICAO', 'PRECO'],
      where: [`TIPO = 'TERMO'`],
    }

    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

    jsonStr.map(item => {
      $('#tabelaTermotapeTipo').DataTable().row.add({
        CODIGO: item.ID,
        DESCRICAO: item.DESCRICAO,
        PRECO: item.PRECO
      }).draw(false);
    });

    if ($('#tabelaTermotapeTipo').DataTable().rows().count() > 0) {
      $($('#tabelaTermotapeTipo > tbody > tr')[0]).addClass('selected');
    }
  };

  async function carregaComposicao() {
    $.LoadingOverlay('show');
    $('#tabelaComposicao').DataTable().clear().draw();
    try {
      const response = await requisicao('GET', '/sisplan/orcamento/v1/buscacomposicao?', `ID=${idCaracteristica}`);

      if (!response) {
        return;
      }

      const jsonStr = await response.json();

      jsonStr.map(item => {
        $('#tabelaComposicao').DataTable().row.add({
          CODIGO: item.COD_MAT,
          DESCRICAO: item.DESC_MAT,
          COR: item.COR,
          DESC_COR: item.DESC_COR,
          FORNECEDOR: '',
          NOME_FORNECEDOR: '',
          ACOES: retornaBotaoExcluir(),
        }).draw(false);
      });

    } finally {
      $.LoadingOverlay('hide');
    }
  };

  async function carregaConsumos() {
    $.LoadingOverlay('show');
    $('#tabelaConsumos').DataTable().clear().draw();
    try {
      const response = await requisicao('GET', '/sisplan/orcamento/v1/buscaconsumos?', `ID=${idCaracteristica}`);

      if (!response) {
        return;
      }

      const jsonStr = await response.json();

      jsonStr.map(item => {
        $('#tabelaConsumos').DataTable().row.add({
          CODIGO: item.COD_MAT,
          DESCRICAO: item.DESC_MAT,
          QTDE: item.QTDE,
          CUSTO: item.CUSTO,
          SETOR: item.SETOR,
          DESC_SETOR: item.DESC_SETOR,
          COR: item.COR,
          DESC_COR: item.DESC_COR,
        }).draw(false);
      });

    } finally {
      $.LoadingOverlay('hide');
    }
  };

  async function buscaCaracteristica(sLinha, sGrupo, sEtiqueta) {
    const pesquisaParam = {
      tabela: 'CARACT',
      camposSelect: ['CARACT.ID', 'CARACT.COD_FAIXA', 'FAIXA.DESCRICAO DESC_FAIXA'],
      where: [`CARACT.COD_ETQ = '${sEtiqueta}' AND CARACT.COD_GRUPO = '${sGrupo}' AND CARACT.COD_LINHA = '${sLinha}'`],
      leftJoin: [{ tabela: 'FAIXA', condicao: `FAIXA.CODIGO = CARACT.COD_FAIXA` }],
    }

    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

    if (jsonStr.length == 0) {
      msgAlerta('Nenhuma característica encontrada para o grupo, etiqueta e linha informados. Favor verificar.');
      return;
    }

    idCaracteristica = jsonStr[0].ID;

    insereValor('#txtFaixa', jsonStr[0].COD_FAIXA, jsonStr[0].DESC_FAIXA);

    await carregaCaracteristicas();
    await carregaComposicao();
    await carregaConsumos();
  };

  async function explodeFaixa(sFaixa) {
    if (pegaValor('#txtValTotal') > 0) {
      return;
    }

    $.LoadingOverlay('show');
    $('#tabelaGrade').DataTable().clear();
    try {
      const pesquisaParam = {
        tabela: 'FAIXA_ITEN',
        camposSelect: ['TAMANHO', 'POSICAO'],
        where: [`FAIXA = '${sFaixa}'`],
        orderBy: ['POSICAO'],
      }

      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

      const precoVenda = await montaPrecoVenda();

      jsonStr.map((item, index) => {
        $('#tabelaGrade').DataTable().row.add({
          TAMANHO: item.TAMANHO,
          QTDE: retornaInputValor('txtQtdeGrade txtCamposGrade', index, true),
          PRECO: precoVenda,
          PERC_ACRESC: retornaInputValor('txtPercAcresGrade txtCamposGrade', index),
          VAL_ACRESC: retornaInputValor('txtValAcresGrade txtCamposGrade', index),
          PERC_DESC: retornaInputValor('txtPercDescGrade txtCamposGrade', index),
          VAL_DESC: retornaInputValor('txtValDescGrade txtCamposGrade', index),
          PRECO_LIQ: '0.00',
          TOTAL: '0.00',
        }).draw(false);
      });
    } finally {
      $('.txtCamposGrade').on('blur', function () {
        calculaTotaisGrade($(this).attr('data-campo').replace(' txtCamposGrade', ''), $(this).attr('data-index'));
      });

      insereValor('#txtQtdeTotal', '0.00');
      insereValor('#txtValTotal', '0.00');

      aplicaMascara();

      $.LoadingOverlay('hide');
    }
  };

  async function carregaCaracteristicas() {
    $.LoadingOverlay('show');
    $('#tabelaCaracteristicas').DataTable().clear().draw();
    try {
      const response = await requisicao('GET', '/sisplan/orcamento/v1/buscacaracteristicas?', `ID=${idCaracteristica}&CODIGO=${pegaChave('#txtCodigo')}`);

      if (!response) {
        return;
      }

      const jsonStr = await response.json();

      jsonStr.map(item => {
        $('#tabelaCaracteristicas').DataTable().row.add({
          SEL: botaoSelecionarGrid('checkCaracteristica'),
          CODIGO: item.OPCIONAL,
          DESCRICAO: item.DESC_OPCIONAL,
          VALOR: item.VALOR,
          EXISTE: item.EXISTE,
          ID: item.ID,
          CONS_TECIDO: item.CONS_TECIDO,
          COD_APL: item.COD_APL,
        }).draw(false);
      });

      $('#tabelaCaracteristicas').DataTable().rows().every(function () {
        let data = this.data()
        let index = this.index()


        if (data.EXISTE == 'S' && data.ID != null) {
          $($('.checkCaracteristica')[index]).trigger('click')
        }
      })

      $('#tabelaCaracteristicas').DataTable().rows().every(function () {
        let data = this.data()

        if (data.ID == null) {
          $(this.node()).find('.form-check').remove()
          $(this.node()).addClass('disabledCaracteristica');
        }
      })

    } finally {
      $.LoadingOverlay('hide');
    }
  };

  async function adicionaEmpresas() {
    const pesquisaParam = {
      tabela: 'EMPRESA',
      camposSelect: ['EMP_PAT', 'EMP_NOME'],
      where: ['1 = 1'],
    }
    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));
    jsonStr.map(emp => {
      $("#selectEmpresa").append(new Option(`${emp.EMP_PAT} - ${emp.EMP_NOME}`, emp.EMP_PAT.replace('_', ''), null, emp.EMP_PAT == getCookie('empresa')));
    });
  };

  function removeSerigrafia() {
    $('#tabelaSerigrafia').DataTable().row('.selected').remove().draw(false);

    if ($('#tabelaSerigrafia').DataTable().rows().count() > 0) {
      $($('#tabelaSerigrafia > tbody > tr')[0]).addClass('selected');
    }
  };

  async function montaPrecoVenda(express = false) {
    let precoVenda = 0
    if (parametrosComercial[9].VALOR == '1') {
      if (!$('#txtPreco').val()) {
        throw new Error('Parametro nº10 da aba comercial na tela de parametros está ativo, favor inserir um preço manualmente.')
      }
      if (!$('#txtQtde').val()) {
        throw new Error('Parametro nº10 da aba comercial na tela de parametros está ativo, favor inserir uma quantidade manualmente.')
      }
      precoVenda = parseFloat($('#txtQtde').val()) * parseFloat($('#txtPreco').val())
    } else {
      if (!express) {
        precoVenda = await retornaCustoFixo();
      }

      for (let j = 0; j < $('#tabelaCaracteristicas').DataTable().rows('.selected').data().length; j++) {
        const item = $('#tabelaCaracteristicas').DataTable().rows('.selected').data()[j]

        precoVenda += item.VALOR;
        for (let i = 0; i < $('#tabelaTecidosUtilizados').DataTable().rows('.selected').data().length; i++) {
          const aplicacao = $('#tabelaTecidosUtilizados').DataTable().rows('.selected').data()[i]

          if (item.COD_APL == aplicacao.COD_APL && item.ID == aplicacao.ID) {
            const precoMat = await retornaPrecoMat(idCaracteristica, aplicacao.COD_APL, item.CODIGO, aplicacao.CODIGO, aplicacao.COR)
            precoVenda += parseFloat(precoMat)
          }
        }
      }


      $('#tabelaConsumos').DataTable().rows().data().map(item => {
        precoVenda += (item.CUSTO * item.QTDE);
      });

      precoVenda += $('#tabelaSerigrafia').DataTable().column(8, {}).data().sum();

      precoVenda += $('#tabelaBordado').DataTable().column(8, {}).data().sum();

      let precoMarkup = 0

      if ($('#txtMarkup').val() != '') {
        precoMarkup = await retornaIndMarkup()
      }

      if (precoMarkup > 0) {
        precoVenda = precoVenda / (1 - (precoMarkup / 100))
      }
    }


    return precoVenda.toFixed(2);
  };

  async function retornaPrecoMat(id, codApl, opcional, codigo, cor) {
    $.LoadingOverlay('show')
    try {
      const response = await requisicao('GET', '/sisplan/orcamento/v1/buscaprecomat?', `ID=${id}&COD_APL=${codApl}&OPCIONAL=${opcional}&CODIGO=${codigo}&COR=${cor}`);

      if (!response) {
        return;
      }

      const jsonPrecoMat = await response.json();

      if (jsonPrecoMat.length > 0) {
        let valor = (jsonPrecoMat[0].QTDE_TECIDO * jsonPrecoMat[0].PRECO)
        return valor.toFixed(2)
      } else {
        return 0;
      }
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }
  };

  async function retornaCustoFixo() {
    const pesquisaParam = {
      tabela: 'CARACT',
      camposSelect: ['(VALOR_COST [SOMA] VALOR_LINHA [SOMA] MARGEM) CUSTO_FIXO'],
      where: [`ID = ${idCaracteristica}`]
    }

    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

    return jsonStr[0].CUSTO_FIXO;
  };

  async function retornaIndMarkup() {
    const pesquisaParam = {
      tabela: 'PRECO_INDICE',
      camposSelect: ['SUM(PRECO_INDICE.INDICE) INDICE'],
      where: [`MARKUP = '${pegaChave('#txtMarkup')}'`]
    }

    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

    if (!jsonStr) {
      return 0
    }

    return jsonStr[0].INDICE;
  }

  function addSerigrafia() {
    try {
      $('#tabelaSerigrafia').DataTable().row.add({
        NOME: pegaValor('#txtNomeSerigrafia'),
        TIPO: $('#tabelaSerigrafiaTipo').DataTable().row('.selected').data().DESCRICAO,
        TAMANHO: $('#tabelaSerigrafiaTamanho').DataTable().row('.selected').data().DESCRICAO,
        LOCAL: $('#tabelaSerigrafiaLocal').DataTable().row('.selected').data().DESCRICAO,
        QTDE_CORES: pegaValor('#txtQtdeCores'),
        TOTAL: pegaValor('#txtTotalPecasSerigrafia'),
        ALTURA: pegaValor('#txtAlturaSerigrafia'),
        LARGURA: pegaValor('#txtLarguraSerigrafia'),
        PRECO: $('#tabelaSerigrafiaTipo').DataTable().row('.selected').data().PRECO + $('#tabelaSerigrafiaLocal').DataTable().row('.selected').data().PRECO
      }).draw(false);

      if ($('#tabelaSerigrafia').DataTable().rows().count() > 0) {
        $('#tabelaSerigrafia > tbody > tr').removeClass('selected');
        $($('#tabelaSerigrafia > tbody > tr')[$('#tabelaSerigrafia').DataTable().rows().count() - 1]).addClass('selected');
      }
    } finally {
      limpaValor('#txtNomeSerigrafia');
      limpaValor('#txtAlturaSerigrafia');
      limpaValor('#txtLarguraSerigrafia');
      limpaValor('#txtTotalPecasSerigrafia');
    }
  };

  function addTermotape() {
    try {
      $('#tabelaTermotape').DataTable().row.add({
        CODIGO: $('#tabelaTermotapeTipo').DataTable().row('.selected').data().CODIGO,
        DESCRICAO: $('#tabelaTermotapeTipo').DataTable().row('.selected').data().DESCRICAO,
        TAM_CM2: pegaValor('#txtTamCm2'),
        TOTAL: pegaValor('#txtTotalPecasTermotape'),
        PRECO: $('#tabelaTermotapeTipo').DataTable().row('.selected').data().PRECO,
      }).draw(false);

      if ($('#tabelaTermotape').DataTable().rows().count() > 0) {
        $('#tabelaTermotape > tbody > tr').removeClass('selected');
        $($('#tabelaTermotape > tbody > tr')[$('#tabelaTermotape').DataTable().rows().count() - 1]).addClass('selected');
      }
    } finally {
      limpaValor('#txtTamCm2');
      limpaValor('#txtTotalPecasTermotape');
    }
  };

  function removeBordado() {
    $('#tabelaBordado').DataTable().row('.selected').remove().draw(false);

    if ($('#tabelaBordado').DataTable().rows().count() > 0) {
      $($('#tabelaBordado > tbody > tr')[0]).addClass('selected');
    }
  };

  function addBordado() {
    try {
      $('#tabelaBordado').DataTable().row.add({
        NOME: pegaValor('#txtNomeBordado'),
        PROGRAMACAO: $('#tabelaBordadoProgramacao').DataTable().row('.selected').data().DESCRICAO,
        TAMANHO: $('#tabelaBordadoTamanho').DataTable().row('.selected').data().DESCRICAO,
        LOCAL: $('#tabelaBordadoLocal').DataTable().row('.selected').data().DESCRICAO,
        QTDE_PROG: pegaValor('#txtQtdeProg'),
        TOTAL: pegaValor('#txtTotalPecasBordado'),
        ALTURA: pegaValor('#txtAlturaBordado'),
        LARGURA: pegaValor('#txtLarguraBordado'),
        PRECO: $('#tabelaBordadoProgramacao').DataTable().row('.selected').data().PRECO + $('#tabelaBordadoTamanho').DataTable().row('.selected').data().PRECO + $('#tabelaBordadoLocal').DataTable().row('.selected').data().PRECO
      }).draw(false);

      if ($('#tabelaBordado').DataTable().rows().count() > 0) {
        $('#tabelaBordado > tbody > tr').removeClass('selected');
        $($('#tabelaBordado > tbody > tr')[$('#tabelaBordado').DataTable().rows().count() - 1]).addClass('selected');
      }
    } finally {
      limpaValor('#txtNomeBordado');
      limpaValor('#txtQtdeProg');
      limpaValor('#txtAlturaBordado');
      limpaValor('#txtLarguraBordado');
      limpaValor('#txtTotalPecasBordado');
    }
  };

  function carregaAplicacoes() {
    $('#tabelaAplicacoes').DataTable().clear();
    $('#tabelaTecidosUtilizados').DataTable().clear();

    try {
      $('#tabelaCaracteristicas').DataTable().rows('.selected').data().map(item => {
        if (item.CONS_TECIDO != 'N') {
          $('#tabelaAplicacoes').DataTable().row.add({
            CARACTERISTICA: item.CODIGO,
            SUBCARACTERISTICA: item.DESCRICAO,
            COD_APL: item.COD_APL,
            ID: item.ID,
          }).draw(false);
        }
      });

      $('#tabelaComposicao').DataTable().rows().data().map(item => {
        $('#tabelaTecidosUtilizados').DataTable().row.add({
          SEL: botaoSelecionarGrid('checkAplicacoes'),
          CODIGO: item.CODIGO,
          DESCRICAO: item.DESCRICAO,
          ALTURA: retornaInputValor('txtAltura'),
          LARGURA: retornaInputValor('txtLargura'),
          FUNDO: retornaInputValor('txtFundo'),
          VISOR: retornaInputValor('txtVisor'),
          CONSUMO: retornaInputValor('txtConsumo'),
          COR: item.COR,
          FORNECEDOR: item.FORNECEDOR,
          ID: -1,
          COD_APL: -1,
        }).draw(false);
      });
    } finally {
      aplicaMascara();
    }
  };

  function botaoSelecionarGrid(sNomeCheck) {
    return '<div class="form-check">' +
      `<input type="checkbox" class="align-self-center ${sNomeCheck}" value"">` +
      '</div>';
  };

  function adicionaComposicao() {
    if ((pegaValor('#txtFornecedor') == '') || (pegaValor('#txtMaterial') == '') || (pegaValor('#txtCorItem') == '')) {
      msgAlerta('Necessário preencher todos os campos para adicionar composição.');
      return;
    }

    try {
      const composicao = {
        CODIGO: pegaChave('#txtMaterial'),
        DESCRICAO: pegaDescricao('#txtMaterial'),
        COR: pegaChave('#txtCorItem'),
        DESC_COR: pegaDescricao('#txtCorItem'),
        FORNECEDOR: pegaChave('#txtFornecedor'),
        NOME_FORNECEDOR: pegaDescricao('#txtFornecedor'),
        ACOES: retornaBotaoExcluir(),
      };

      if (alterandoComposicao && indexComposicao >= 0) {
        $('#tabelaComposicao').DataTable().row(indexComposicao).data(composicao).draw(false);
      } else {
        $('#tabelaComposicao').DataTable().row.add(composicao).draw(false);
      }
    } finally {
      $('#modalComposicao').modal('hide');
    }
  };

  $('#modalComposicao').on('hidden.bs.modal', async function () {
    $.LoadingOverlay('show')
    try {
      $('#txtMaterial').val('');
      $('#txtCorItem').val('');
      $('#txtFornecedor').val('');
      alterandoComposicao = false;
      indexComposicao = -1;
    } finally {
      $.LoadingOverlay('hide')
    }
  })

  function retornaBotaoExcluir() {
    return '<div class="divBtnOpcoes p-0"> ' +
      '     <button class="botaoOpcoes btn-sm" type="button" title="Excluir" id="btn-excluir-composicao"><span class="fas fa-trash-alt" style="color:red"></span></button>  ' +
      '     <button class="botaoOpcoes btn-sm" type="button" title="Editar" id="btn-editar-composicao"><span class="fas fa-edit" style="color:blue"></span></button>     ' +
      '   </div>';
  }

  function retornaInputValor(sNomeInput, iIndex = 0, campoQtde = false) {
    return !campoQtde ? `<input type="text" class="input-default focus form-control camposMascara ${sNomeInput}" data-campo="${sNomeInput}" data-index="${iIndex}" value="0.00">` : `<input type="text" class="input-default focus form-control camposMascaraQtde ${sNomeInput}" data-campo="${sNomeInput}" data-index="${iIndex}" value="0">`
  };

  function aplicaMascara() {
    $(".camposMascara").maskMoney({
      decimal: ".",
      thousands: "",
      precision: 2,
    });

    $(".camposMascara").on('blur', function () {
      if (($(this).val() == '0.00') || ($(this).val() == '')) {
        $(this).val('0.00');
      }
    });

    $('.camposMascaraQtde').maskMoney({
      decimal: ".",
      thousands: "",
      precision: 0,
    })

    $(".camposMascaraQtde").on('blur', function () {
      if (($(this).val() == '0') || ($(this).val() == '')) {
        $(this).val('0');
      }
    });

    $("#txtDias").maskMoney({
      decimal: ".",
      thousands: "",
      precision: 0,
    });
    $("#txtDiasValidade").maskMoney({
      decimal: ".",
      thousands: "",
      precision: 0,
    });
  };

  function ajustaTabelasModalItem() {
    $('#tabelaCaracteristicas').DataTable().columns.adjust().draw(false);
    $('#tabelaComposicao').DataTable().columns.adjust().draw(false);
    $('#tabelaFt').DataTable().columns.adjust().draw(false);
    $('#tabelaGrade').DataTable().columns.adjust().draw(false);
    $('#tabelaAplicacoes').DataTable().columns.adjust().draw(false);
    $('#tabelaTecidosUtilizados').DataTable().columns.adjust().draw(false);
    $('#tabelaConsumos').DataTable().columns.adjust().draw(false);
    $('#tabelaSerigrafia').DataTable().columns.adjust().draw(false);
    $('#tabelaSerigrafiaTipo').DataTable().columns.adjust().draw(false);
    $('#tabelaSerigrafiaLocal').DataTable().columns.adjust().draw(false);
    $('#tabelaSerigrafiaTamanho').DataTable().columns.adjust().draw(false);
    $('#tabelaBordado').DataTable().columns.adjust().draw(false);
    $('#tabelaBordadoProgramacao').DataTable().columns.adjust().draw(false);
    $('#tabelaBordadoTamanho').DataTable().columns.adjust().draw(false);
    $('#tabelaBordadoLocal').DataTable().columns.adjust().draw(false);
    $('#tabelaSublimacao').DataTable().columns.adjust().draw(false);
    $('#tabelaTermotapeTipo').DataTable().columns.adjust().draw(false);
    $('#tabelaTermotape').DataTable().columns.adjust().draw(false);
  };

  function calculaTotaisGrade(sCampo, iIndex) {
    const valor = parseFloat($($('.' + sCampo)[iIndex]).val());
    const qtde = parseInt($($('.txtQtdeGrade')[iIndex]).val());

    switch (sCampo) {
      case 'txtQtdeGrade': {
        const dados = $('#tabelaGrade').DataTable().row(iIndex).data();
        dados.TOTAL = (parseFloat(dados.PRECO) * valor).toFixed(2);
        dados.PRECO_LIQ = dados.TOTAL;

        $('#tabelaGrade').DataTable().row(iIndex).data(dados).draw(false);
        $($('.txtPercAcresGrade')[iIndex]).val('0.00');
        $($('.txtValAcresGrade')[iIndex]).val('0.00');
        $($('.txtPercDescGrade')[iIndex]).val('0.00');
        $($('.txtValDescGrade')[iIndex]).val('0.00');
        break;
      }
      case 'txtPercAcresGrade': {
        const dados = $('#tabelaGrade').DataTable().row(iIndex).data();
        const valorAcres = TruncaDecimaisNova(2, (parseFloat(dados.PRECO_LIQ) * valor) / 100);
        dados.TOTAL = (parseFloat(dados.PRECO_LIQ) + valorAcres).toFixed(2);

        $('#tabelaGrade').DataTable().row(iIndex).data(dados).draw(false);
        $($('.txtValAcresGrade')[iIndex]).val(valorAcres.toFixed(2));
        $($('.txtPercDescGrade')[iIndex]).val('0.00');
        $($('.txtValDescGrade')[iIndex]).val('0.00');
        break;
      }
      case 'txtValAcresGrade': {
        const dados = $('#tabelaGrade').DataTable().row(iIndex).data();
        const percAcres = TruncaDecimaisNova(2, valor / (parseFloat(dados.PRECO_LIQ) / 100));
        dados.TOTAL = (parseFloat(dados.PRECO_LIQ) + valor).toFixed(2);

        $('#tabelaGrade').DataTable().row(iIndex).data(dados).draw(false);
        $($('.txtPercAcresGrade')[iIndex]).val(percAcres.toFixed(2));
        $($('.txtPercDescGrade')[iIndex]).val('0.00');
        $($('.txtValDescGrade')[iIndex]).val('0.00');
        break;
      }
      case 'txtPercDescGrade': {
        const dados = $('#tabelaGrade').DataTable().row(iIndex).data();
        const valorDesc = TruncaDecimaisNova(2, (parseFloat(dados.PRECO_LIQ) * valor) / 100);
        dados.TOTAL = (parseFloat(dados.PRECO_LIQ) - valorDesc).toFixed(2);

        $('#tabelaGrade').DataTable().row(iIndex).data(dados).draw(false);
        $($('.txtValDescGrade')[iIndex]).val(valorDesc.toFixed(2));
        $($('.txtPercAcresGrade')[iIndex]).val('0.00');
        $($('.txtValAcresGrade')[iIndex]).val('0.00');
        break;
      }
      case 'txtValDescGrade': {
        const dados = $('#tabelaGrade').DataTable().row(iIndex).data();
        const percDesc = TruncaDecimaisNova(2, valor / (parseFloat(dados.PRECO_LIQ) / 100));
        dados.TOTAL = (parseFloat(dados.PRECO_LIQ) - valor).toFixed(2);

        $('#tabelaGrade').DataTable().row(iIndex).data(dados).draw(false);
        $($('.txtPercDescGrade')[iIndex]).val(percDesc.toFixed(2));
        $($('.txtPercAcresGrade')[iIndex]).val('0.00');
        $($('.txtValAcresGrade')[iIndex]).val('0.00');
        break;
      }
    }

    $('.camposMascara').unbind();
    $('.txtCamposGrade').unbind('blur');

    $('.txtCamposGrade').on('blur', function () {
      calculaTotaisGrade($(this).attr('data-campo').replace(' txtCamposGrade', ''), $(this).attr('data-index'));
    });

    aplicaMascara();

    $($('.' + sCampo)[iIndex]).val(valor.toFixed(2));
    $($('.txtQtdeGrade')[iIndex]).val(qtde.toFixed(0));

    atualizaTotaisGrade();
  };

  function atualizaTotaisGrade() {
    let qtdeTotal = 0;
    $('.txtQtdeGrade').each(index => { qtdeTotal += parseInt($($('.txtQtdeGrade')[index]).val()) });

    const valTotal = $("#tabelaGrade").DataTable().column(8, {}).data().sum();

    insereValor('#txtQtdeTotal', qtdeTotal.toFixed(2));
    insereValor('#txtValTotal', valTotal.toFixed(2));
  };

  function zeraQtdeGrade() {
    calculaTotaisGrade('txtQtdeGrade', 0);
  }

  async function simulaFinanceiro() {
    let parcelas = [];
    for (let i = 0; i < 12; i++) {
      if ($(`#edtVencimento${i + 1}`).val() != "") {
        parcelas.push($(`#edtVencimento${i + 1}`).val());
      }
    }
    let i = 1;
    let diferenca;
    let valorNota = parseFloat($('#txtValorTotalItens').text().replace(/R\$\s*/, '').replace('.', '').replace(',', '.'));
    let vValor = parseFloat((valorNota / parcelas.length).toFixed(2));
    let valorTotal = 0
    if (
      valorNota > vValor * parcelas.length ||
      valorNota < vValor * parcelas.length
    ) {
      diferenca = (valorNota - vValor * parcelas.length).toFixed(2);
    }
    let guardaValor = vValor;
    let arrVenctos = await RetornaVencimentos(parcelas);
    $("#tabelaDuplicatas").DataTable().rows().remove().draw(false);
    parcelas.forEach((element) => {
      if (element != "") {
        if (diferenca > 0 || i == 0) {
          vValor = (vValor + parseFloat(diferenca)).toFixed(2);
          diferenca = 0;
        } else {
          vValor = guardaValor;
        }
        if (diferenca < 0 && i == parcelas.length) {
          vValor = (vValor + parseFloat(diferenca)).toFixed(2);
        }
        vValor = `<input type="text" maxlength="8" class="classeValorFin inputs input-default focus form-control maskItens" min="0" id="txtValorRec-${i}" name="txtValorRec-${i}" value="${vValor}">`;
        $("#tabelaDuplicatas").DataTable().row.add([
          i
          ,
          arrVenctos[i - 1],
          vValor,
        ]).draw(false);
      }
      i++;
    });
    focuValor();
    $('#txtValorFinanceiro').html(parseFloat(valorNota).toLocaleString("pt-BR", { style: "currency", currency: "BRL", }))
  };

  async function RetornaVencimentos(arrDias) {
    let arrVencimentos = [];
    try {
      let dataAtual = new Date();
      for (let index = 0; index < arrDias.length; index++) {
        if (arrDias[index] != "") {
          let novoPrazo = new Date();
          novoPrazo.setDate(dataAtual.getDate() + parseInt(arrDias[index]));

          const response = await requisicao("GET", "/sisplan/nfe/v1/datavencimento?", `CODCLI=${pegaChave('#txtCliente')}&DATA=${formataData(novoPrazo)}`);
          const jsonStr = await response.text();

          let novaData = jsonStr.split('/')[2] + '-' + jsonStr.split('/')[1] + '-' + jsonStr.split('/')[0];
          novaData = `<input type="date" max="2500-12-31" class="input-default focus form-control validate" id="txtDataRec-${index}" name="txtDataRec" value="${novaData}"></input>`
          arrVencimentos.push(novaData);
        }
      }
      return arrVencimentos;
    } catch (error) {
      console.error(error);
    }
  };

  function focuValor() {
    $('.classeValorFin').unbind('blur')
    $('.classeValorFin').on('blur', async function () {
      let parcelas = [];
      let vValor = 0;
      for (let i = 0; i < 12; i++) {
        if ($(`#edtVencimento${i + 1}`).val() != "") {
          parcelas.push($(`#edtVencimento${i + 1}`).val());
          vValor += parseFloat($(`#txtValorRec-${i + 1}`).val());
        }
      }
      const valorNota = parseFloat($('#txtValorTotalItens').text().replace(/R\$\s*/, '').replace('.', '').replace(',', '.'));
      vValor = parseFloat((valorNota - vValor).toFixed(2));
      const valAtual = parseFloat($(`#txtValorRec-${parcelas.length}`).val());
      const valorInput = $(this).val()

      const valorRestante = valorNota - valorInput

      const arrVenctos = await RetornaVencimentos(parcelas)

      if (parseFloat((valorInput)) < parseFloat((valorNota))) {
        const tabela = $('#tabelaDuplicatas').DataTable().rows().data()

        $('#tabelaDuplicatas').DataTable().clear().draw(false);
        for (let i = 0; i < tabela.length; i++) {
          if ($(tabela[i][2])[0].id == $(this)[0].id) {
            $("#tabelaDuplicatas").DataTable().row.add([
              i + 1,
              arrVenctos[i],
              `<input type="text" maxlength="8" class="classeValorFin inputs input-default focus form-control maskItens" min="0" id="txtValorRec-${i + 1}" name="txtValorRec-${i + 1}" value="${valorInput}">`,
            ]).draw(false);
            continue
          }

          const resto = valorRestante / (parcelas.length - 1)

          $("#tabelaDuplicatas").DataTable().row.add([
            i + 1,
            arrVenctos[i],
            `<input type="text" maxlength="8" class="classeValorFin inputs input-default focus form-control maskItens" min="0" id="txtValorRec-${i + 1}" name="txtValorRec-${i + 1}" value="${resto}">`,
          ]).draw(false);
          focuValor()
        }
      } else {
        msgAlerta('Valor das parcelas é superior ao total da nota, recalculo será efetuado!');
        simulaFinanceiro();
      }
    });
  };

  async function calculaTotaisItens() {
    $.LoadingOverlay("show");
    try {
      let itens = $('#tabelaItens').DataTable().data().toArray();

      let nota = {};
      nota.CODCLI = pegaChave("#txtCliente");
      nota.DTEMISSAO = $("#dtEmissao").val();
      nota.NATUREZA = pegaChave("#txtNatureza");
      nota.ITENS = [];

      for (let i = 0; i < itens.length; i++) {
        if (itens[i].CODIGO != "" && itens[i].PRECO != "" && itens[i].QTDE != "") {
          if (itens[i].CODIGO != undefined && itens[i].CODIGO != "") {
            let item = {};
            item.CODIGO = itens[i].CODIGO;
            item.QTDE = parseFloat(itens[i].QTDE);
            item.PRECO = parseFloat(itens[i].PRECO);
            item.NATUREZA = nota.NATUREZA;
            item.VALOR = item.PRECO * item.QTDE;
            nota.ITENS.push(item);
          }
        }
      }

      if (nota.ITENS.length == 0) {
        zeraTotais();
        return;
      }

      try {
        const response = await requisicao("POST", "/sisplan/fatservico/v1/retornatotais?", '', JSON.stringify(nota), 300000);

        if (!response) {
          return;
        }

        const jsonStr = await response.json();

        let qtdeTotal = 0;
        jsonStr.itens.map(item => { qtdeTotal += item.qtde; });

        $(".txtTotalLiquido").html(parseFloat(jsonStr.valor_liq).toLocaleString("pt-BR", { style: "currency", currency: "BRL", }));
        $(".txtValorTotal").html(parseFloat(jsonStr.valor).toLocaleString("pt-BR", { style: "currency", currency: "BRL", }));
        $(".txtTotalQtde").html(parseFloat(qtdeTotal));

        $(".txtValorPis").html(parseFloat(jsonStr.val_pis).toLocaleString("pt-BR", { style: "currency", currency: "BRL", }));
        $(".txtValorCofins").html(parseFloat(jsonStr.val_cofins).toLocaleString("pt-BR", { style: "currency", currency: "BRL", }));
        $(".txtValorIss").html(parseFloat(jsonStr.valor_iss).toLocaleString("pt-BR", { style: "currency", currency: "BRL", }));

        $(".txtValorCsll").html(parseFloat(jsonStr.val_csll).toLocaleString("pt-BR", { style: "currency", currency: "BRL", }));
        $(".txtValorInss").html(parseFloat(jsonStr.val_inss).toLocaleString("pt-BR", { style: "currency", currency: "BRL", }));
        $(".txtValorIrrf").html(parseFloat(jsonStr.val_irrf).toLocaleString("pt-BR", { style: "currency", currency: "BRL", }));

        $("#txtValorFinanceiro").html(parseFloat(jsonStr.valor).toLocaleString("pt-BR", { style: "currency", currency: "BRL", }));

      } catch (error) {
        console.error(error);
      }

    } finally {
      $.LoadingOverlay("hide");
    }
  };

  $(".collapse").on("shown.bs.collapse", function (e) {
    let clicked = $(document).find(`[href='#${$(e.target).attr("id")}']`);
    clicked.parent().find(".fa-angle-right").removeClass("fa-angle-right").addClass("fa-angle-down");
  }).on("hidden.bs.collapse", function (e) {
    let clicked = $(document).find(`[href='#${$(e.target).attr("id")}']`);
    clicked.parent().find(".fa-angle-down").removeClass("fa-angle-down").addClass("fa-angle-right");
  });

  $("#txtValorNota, #txtQuantidade").bind("DOMSubtreeModified", function () {
    setTimeout(() => { $(this).css("color", "red"); }, 200);
    setTimeout(() => { $(this).css("color", "inherit"); }, 2000);
  });

  $("#dropdown").trigger("change");

  async function retornaPrazoMed() {
    $.LoadingOverlay('show')
    try {
      const pesquisaParam = {
        tabela: 'OS_SIMULA',
        camposSelect: ['PRZ_PRIM_PARC', 'INTERV_PARC', 'PRZ_MEDIO'],
        where: [`NUMERO = '${$('#txtNumero').val()}'`]
      }

      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

      if (jsonStr.length == 0) {
        let diasDeVencimento = []
        let intervalos = []
        for (let i = 0; i < 11; i++) {
          if ($(`#edtVencimento${i + 1}`).val() != '') {
            diasDeVencimento.push(parseInt($(`#edtVencimento${i + 1}`).val()))
          }
        }

        for (let i = 1; i < diasDeVencimento.length; i++) {
          let intervalo = diasDeVencimento[i] - diasDeVencimento[i - 1];
          intervalos.push(intervalo);
        }

        const somaDiasDeVencimento = diasDeVencimento.reduce((acc, val) => acc + val, 0);
        const prazoMedio = somaDiasDeVencimento / diasDeVencimento.length;

        return { przPrim: diasDeVencimento[0], intervalo: intervalos[0], prazoMedio: prazoMedio }
      } else {
        return { przPrim: jsonStr[0].PRZ_PRIM_PARC, intervalo: jsonStr[0].INTERV_PARC, prazoMedio: jsonStr[0].PRZ_MEDIO }
      }
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }
  }

  $("#gravar").click(async function () {
    $(this).attr('disabled', true);

    if (!validaDadosItens()) {
      return;
    }

    $.LoadingOverlay("show");
    try {

      let arrayItens = [];
      let arrayFinanceiro = [];
      for (let i = 0; i < $('#tabelaItens').DataTable().data().toArray().length; i++) {
        const item = $('#tabelaItens').DataTable().data().toArray()[i]
        arrayItens.push({
          ORDEM_DIG: item.ORDEM,
          ORDEM: 1,
          CODIGO: item.CODIGO,
          DESCRICAO: item.DESCRICAO,
          QUALIDADE: '1',
          COR: item.COR,
          TAM: item.TAM,
          QTDE: item.QTDE,
          PRECO: item.PRECO,
          VALOR_TOTAL: item.VALOR,
          TIPO_PROD: 'E',
          OBS2: item.OBS2,
          OBS3: item.OBS3,
          OBSERVACAO: item.OBSERVACAO,
          FAIXA: item.FAIXA,
        });
      }

      const przMed = await retornaPrazoMed()

      for (let i = 0; i < $('#tabelaDuplicatas').DataTable().data().toArray().length; i++) {
        const item = $('#tabelaDuplicatas').DataTable().data().toArray()[i]
        arrayFinanceiro.push({
          NUM_PARCELA: item[0],
          VENCTO: $(`#txtDataRec-${i}`).val() ?? item[1],
          VALOR_PARCELA: parseFloat($(`#txtValorRec-${i + 1}`).val()) > 0 ? parseFloat($(`#txtValorRec-${i + 1}`).val()) : item[2],
          QUANT_PARC: $('#tabelaDuplicatas').DataTable().data().toArray().length,
          VALOR_TOTAL: $('#txtValorFinanceiro').text().replace(/R\$\s*/, '').replace('.', '').replace(',', '.'),
          PRZ_PRIM_PARC: przMed.przPrim,
          INTERV_PARC: przMed.intervalo,
          PRZ_MEDIO: przMed.prazoMedio,
          CONSIDERARSIMULACAO: $('#checkConsiderarSimulação').is(':checked') ? 'S' : 'N',
        });
      }

      if (arrayItens.length <= 0) {
        throw new Error('Nenhum item no orçamento!')
      }

      if (arrayFinanceiro.length <= 0) {
        throw new Error('Nenhuma parcela criada no orçamento!')
      }

      const classOs = {
        USUARIO: getCookie('usuario'),
        NUMERO: pegaValor('#txtNumero'),
        EMP_FAT: pegaValor('#selectEmpresa'),
        CLIENTE: pegaChave('#txtCliente'),
        PED_CLI: pegaValor('#txtPedcli'),
        DTDIGITA: pegaValor('#dtDigitacao'),
        CODREP: pegaChave('#txtRepresentante'),
        COM1: pegaValor('#txtComissaoFat'),
        COM2: pegaValor('#txtComissaoRec'),
        CODAGENCIA: pegaChave('#txtAgencia'),
        COM1_AGENCIA: pegaValor('#txtComissao'),
        PEDIDO: pegaChave('#txtPedido'),
        SOLICITANTE: pegaChave('#txtSolicitante'),
        TAB_PRE: pegaChave('#txtTabPreco'),
        BLOQ_COM: pegaValor('#selectStatusComercial'),
        DT_CADASTRO: $('#dtEmissao').val(),
        DT_VALIDADE: pegaValor('#dtValidade'),
        DIAS_ENTREGA: pegaValor('#txtDias'),
        DT_ENTREGA: $('#dtEntrega').val(),
        DT_SAIDA: $('#dtSaida').val(),
        OBSERVACAO: pegaValor('#txtObservacoes'),
        SITUACAO: $('#rdSituacaoAberto').is(':checked') ? 'A' : $('#rdSituacaoFechado').is(':checked') ? 'F' : $('#rdSituacaoEmAprov').is(':checked') ? 'E' : $('#rdSituacaoPerdido').is(':checked') ? 'P' : '',
        SOMA_DIAS_ENT: $('#rdSumDiasCorridos').is(':checked') ? 'C' : 'U',
        MOEDA: pegaChave('#txtMoeda'),
        HISTORICO: pegaChave('#txtHistorico'),
        SIT_DUP: pegaChave('#txtSituacao'),
        CLASSE_GER: pegaChave('#txtClasseGer'),
        TAB_TRANS: pegaChave('#txtTransportadora'),
        CIF: $('#rgTransportador').val(),
        NATUREZA: pegaChave('#txtNatureza'),
        ALIQUOTA: pegaValor('#txtAliquota'),
        FRETE: pegaValor('#txtValFrete'),
        PESO_BRUTO: pegaValor('#txtPesoBruto'),
        PESO_LIQ: pegaValor('#txtPesoLiquido'),
        VOLUMES: pegaValor('#txtVolumes'),
        END_ENT: pegaValor('#txtEndEntrega'),
        BAIRRO_ENT: pegaValor('#txtBairroEntrega'),
        NOME_CIDADE: pegaValor('#txtCidadeEntrega'),
        COD_UF: pegaValor('#txtEstadoEntrega'),
        NUM_ENT: pegaValor('#txtNumeroEntrega'),
        CEP: pegaValor('#txtCepEntrega'),
        MARKUP: pegaChave('#txtMarkup'),
        ITENS: arrayItens,
        OS_SIMULA: arrayFinanceiro,
        EMP_ID: getCookie('emp_id')
      };

      const response = await requisicao('POST', '/sisplan/os/v1/ordemservico?', '', `JSON=${encodeURIComponent(JSON.stringify(classOs))}`, 90000);

      if (!response) {
        return;
      }

      const jsonStr = await response.json();
      if (response.status != 200) {
        msgErro(jsonStr.mensagem);
        return;
      }

      criaMensagemSucesso('Orçamento gravado com sucesso.', () => { window.location.href = `${BASE_URI}/orcamento`; });

    } catch (error) {
      console.error(error);
      msgErro(`Não foi possível gravar os dados da ordem de serviço: ${error}`);
    } finally {
      $(this).attr('disabled', false);
      $.LoadingOverlay('hide')
    }
  });

  function trocaIdClass(seletor, indice) {
    const classe = seletor.substring(1);
    $(`${seletor}-${indice}`).addClass(`${classe}-atual`).removeClass(`${classe}-${indice}`);
    $(`${seletor}-atual`).addClass(`${classe}-${indice - 1}`).removeClass(`${classe}-atual`);
  };

  async function DeleteItem(id) {
    let itens = $(".itens");
    for (let i = 0; i < itens.length; i++) {
      if (i == id) {
        $(`.item-${i}`).addClass(`removido`).removeClass(`item-${i}`);
      } else if (i > id) {
        $(`.item-${i}`).addClass(`atual`).removeClass(`item-${i}`);
        $(`.atual`).addClass(`item-${i - 1}`).removeClass(`atual`);
        trocaIdClass(`.btn-limpa`, i);
        trocaIdClass(`.btn-edit`, i);
        trocaIdClass(`.btn-add`, i);
        trocaIdClass(`.txtItem`, i);
        $(`.contador.item-${i - 1}>span`).html(i);
      }
    }
    await calculaTotaisItens();
  };

  function validaDadosItens() {
    const servico = $($(".classeProduto")[0]).val();
    const qtde = $($(".classeQuantidade")[0]).val();
    const preco = $($(".classePreco")[0]).val();

    if ([servico, qtde, preco].includes('')) {
      msgAlerta('Serviço, quantidade ou preço não informados.\nFavor voltar a aba de itens e verificar.');
      return false;
    }
    return true;
  };

  function zeraTotais() {
    $("#txtTotalLiquido").html(parseFloat(0).toLocaleString("pt-BR", { style: "currency", currency: "BRL", }));
    $("#txtValorTotal").html(parseFloat(0).toLocaleString("pt-BR", { style: "currency", currency: "BRL", }));
    $("#txtTotalQtde").html(parseFloat(0));

    $("#txtValorPis").html(parseFloat(0).toLocaleString("pt-BR", { style: "currency", currency: "BRL", }));
    $("#txtValorCofins").html(parseFloat(0).toLocaleString("pt-BR", { style: "currency", currency: "BRL", }));
    $("#txtValorIss").html(parseFloat(0).toLocaleString("pt-BR", { style: "currency", currency: "BRL", }));

    $("#txtValorCsll").html(parseFloat(0).toLocaleString("pt-BR", { style: "currency", currency: "BRL", }));
    $("#txtValorInss").html(parseFloat(0).toLocaleString("pt-BR", { style: "currency", currency: "BRL", }));
    $("#txtValorIrrf").html(parseFloat(0).toLocaleString("pt-BR", { style: "currency", currency: "BRL", }));

    $("#txtValorFinanceiro").html(parseFloat(0).toLocaleString("pt-BR", { style: "currency", currency: "BRL", }));
  };

  async function carregaValoresPadroes() {
    if (orcamento != 'create') {
      return;
    }

    const pesquisa = {
      camposSelect: ['CAMPO', 'VALOR'],
      tabela: 'TABPADRAO',
      where: [`TABELA = 'ORCAMENTO'`]
    }
    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

    jsonStr.map(item => {
      switch (item.CAMPO) {
        case 'MOEDA': {
          if (item.VALOR != '') {
            insereValor('#txtMoeda', item.VALOR, { tabela: 'MOEDA', campoBusca: 'DESCRICAO', campoWhere: 'CODMOE', valorWhere: item.VALOR });
          }
          break;
        }
        case 'HISTORICO': {
          if (item.VALOR != '') {
            insereValor('#txtHistorico', item.VALOR, { tabela: 'HISTCP', campoBusca: 'DESCRICAO', campoWhere: 'HISTORICO', valorWhere: item.VALOR });
          }
          break;
        }
        case 'BANCO': {
          if (item.VALOR != '') {
            insereValor('#txtBanco', item.VALOR, { tabela: 'CADBAN', campoBusca: 'NOME_BANCO', campoWhere: 'BANCO', valorWhere: item.VALOR });
          }
          break;
        }
        case 'SITUACAO': {
          if (item.VALOR != '') {
            insereValor('#txtSituacao', item.VALOR, { tabela: 'TABSIT', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR });
          }
          break;
        }
        case 'CLASSEGER': {
          if (item.VALOR != '') {
            insereValor('#txtClasseGer', item.VALOR, { tabela: 'CLASSE_GER', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR });
          }
          break;
        }
        case 'TABPRECO': {
          if (item.VALOR != '') {
            insereValor('#txtTabPreco', item.VALOR, { tabela: 'REGIAO', campoBusca: 'DESCRICAO', campoWhere: 'REGIAO', valorWhere: item.VALOR });
          }
          break;
        }

      }
    });
  };

  function seletorPorNome(name, i) {
    return `.item-${i}>div>input[name*="${name}"]`;
  };

  function addPesquisaAutocompleta() {
    $("#txtCliente").autocompleta(3, `JSON={ "tabela":"entidade", "camposSelect":["CODCLI CHAVE, NOME DESCRICAO"], "where": ["nome <> 'CONSUMIDOR FINAL' and ativo = 'S'"] }`);
    $("#btn-cliente").pesquisa_serverside(["#txtCliente"],
      ["CODCLI"], ["ENTIDADE.NOME"],
      `{
        "tabela":"ENTIDADE", 
        "camposSelect":[
          "CODCLI", 
          "ENTIDADE.NOME", 
          "FANTASIA", 
          "CNPJ", 
          "COD_UF", 
          "CIDADE.NOME" 
        ], 
        "leftJoin":[
          {"tabela": "CADCEP", "condicao": "ENTIDADE.CEP = CADCEP.CEP"},
          {"tabela": "CIDADE", "condicao": "CIDADE.CODIGO = CADCEP.CODMUN"}
        ],
        "where": ["ENTIDADE.nome <> 'CONSUMIDOR FINAL' and ENTIDADE.ativo = 'S'"]
       }`,
      "Pesquisa Cliente");
    $("#btn-limpa-cliente").on("click", function () {
      $("#txtCliente").val("")
      $("#txtCliente").trigger("blur");
    });

    $("#txtRepresentante").autocompleta(1, `JSON={ "tabela":"REPRESEN", "camposSelect":["CODREP CHAVE, NOME DESCRICAO"], "where": null }`);
    $("#btn-Representante").pesquisa_serverside(["#txtRepresentante"], ["CODREP"], ["NOME"], `{"tabela":"REPRESEN", "camposSelect":[ "CODREP", "NOME" ], "where": null}`, "Pesquisa Representante");
    $("#btn-limpa-Representante").on("click", function () { $("#txtRepresentante").val(""); });

    $("#txtAgencia").autocompleta(1, `JSON={ "tabela":"REPRESEN", "camposSelect":["CODREP CHAVE, NOME DESCRICAO"], "where": null }`);
    $("#btn-Agencia").pesquisa_serverside(["#txtAgencia"], ["CODREP"], ["NOME"], `{"tabela":"REPRESEN", "camposSelect":[ "CODREP", "NOME" ], "where": null}`, "Pesquisa Agência");
    $("#btn-limpa-Agencia").on("click", function () { $("#txtAgencia").val(""); });

    $("#txtSolicitante").autocompleta(1, `JSON={ "tabela":"CONTATO", "camposSelect":["ID CHAVE, NOME DESCRICAO"], "where": ["NOME <> ''"] }`, [], [], []);
    $("#btn-Solicitante").pesquisa_serverside(["#txtSolicitante"], ["ID"], ["NOME"], `{"tabela":"CONTATO", "camposSelect":[ "ID", "NOME" ], "where": ["NOME <> ''"]}`, "Pesquisa Solicitante",);
    $("#btn-limpa-Solicitante").on("click", function () { $("#txtSolicitante").val(""); });

    $("#txtTabPreco").autocompleta(1, `JSON={ "tabela":"REGIAO", "camposSelect":["REGIAO CHAVE, DESCRICAO DESCRICAO"], "where": null }`);
    $("#btn-TabPreco").pesquisa_serverside(["#txtTabPreco"], ["REGIAO"], ["DESCRICAO"], `{"tabela":"REGIAO", "camposSelect":[ "REGIAO", "DESCRICAO" ], "where": null}`, "Pesquisa Tabela de Preço");
    $("#btn-limpa-TabPreco").on("click", function () { $("#txtTabPreco").val(""); });

    $("#txtSituacao").autocompleta(1, `JSON={ "tabela":"tabsit", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`);
    $("#btn-situacao").pesquisa("#txtSituacao", "CODIGO", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"tabsit", "camposSelect":[ "codigo", "descricao" ], "where": null}', "Pesquisa Situação", "tabsit");
    $("#btn-limpa-situacao").on("click", function () { $("#txtSituacao").val(""); });

    $("#txtClasseGer").autocompleta(1, `JSON={ "tabela":"classe_ger", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`);
    $("#btn-classeGer").pesquisa("#txtClasseGer", "CODIGO", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"classe_ger", "camposSelect":[ "codigo", "descricao" ], "where": null}', "Pesquisa Classe Gerencial", "classe_ger");
    $("#btn-limpa-classeGer").on("click", function () { $("#txtClasseGer").val(""); });

    $("#txtMoeda").autocompleta(1, `JSON={ "tabela":"moeda", "camposSelect":["codmoe CHAVE, DESCRICAO"], "where": [] }`);
    $("#btnMoeda").pesquisa("#txtMoeda", "CODMOE", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"moeda", "camposSelect":[ "codmoe", "descricao" ], "where": null}', "Pesquisa Moeda", "moeda");
    $("#btnAMoeda").on("click", function () { $("#txtMoeda").val(""); });

    $("#txtHistorico").autocompleta(1, `JSON={ "tabela":"histcp", "camposSelect":["HISTORICO CHAVE, DESCRICAO"], "where": [] }`);
    $("#btn-historico").pesquisa("#txtHistorico", "HISTORICO", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"histcp", "camposSelect":[ "historico", "descricao" ], "where": null}', "Pesquisa Histórico", "histcp");
    $("#btn-limpa-historico").on("click", function () { $("#txtHistorico").val(""); });

    $("#txtBanco").autocompleta(1, `JSON={ "tabela":"cadban", "camposSelect":["BANCO CHAVE, NOME_BANCO DESCRICAO"], "where": [] }`);
    $("#btn-banco").pesquisa("#txtBanco", "BANCO", "NOME_BANCO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"cadban", "camposSelect":[ "banco", "nome_banco" ], "where": null}', "Pesquisa Banco", "cadban");
    $("#btn-limpa-banco").on("click", function () { $("#txtBanco").val(""); });

    $("#txtNatureza").autocompleta(1, `JSON={ "tabela":"natureza", "camposSelect":["NATUREZA CHAVE, DESCRICAO DESCRICAO"], "where": ["ativo = 'S'"] }`);
    $("#btn-natureza").pesquisa("#txtNatureza", "NATUREZA", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"natureza", "camposSelect":[ "natureza", "descricao" ], "where": ["ativo = 'S'"]}`, "Pesquisa Natureza", "natureza");
    $("#btn-limpa-natureza").on("click", function () { $("#txtNatureza").val(""); });

    $("#txtTransportadora").autocompleta(1, `JSON={ "tabela":"tabtran", "camposSelect":["CODIGO CHAVE, NOME DESCRICAO"], "where": [] }`);
    $("#btnTransportadora").pesquisa("#txtTransportadora", "CODIGO", "NOME", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"tabtran", "camposSelect":[ "codigo", "nome" ], "where": null}', "Pesquisa Transportadora", "tabtran");
    $("#btnATransportadora").on("click", function () { $("#txtTransportadora").val(""); });

    $("#txtCodigo").autocompleta(1, `JSON={ "tabela":"PRODUTO", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`);
    $("#btn-Codigo").pesquisa("#txtCodigo", "CODIGO", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"PRODUTO", "camposSelect":[ "codigo", "descricao" ], "where": null}', "Pesquisa Produto", "PRODUTO");
    $("#btn-limpa-Codigo").on("click", function () { $("#txtCodigo").val(""); });

    $("#txtCor").autocompleta(1, `JSON={ "tabela":"CADCOR", "camposSelect":["COR CHAVE, DESCRICAO"], "where": [] }`);
    $("#btn-Cor").pesquisa("#txtCor", "COR", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CADCOR", "camposSelect":[ "COR", "descricao" ], "where": null}', "Pesquisa Cor", "CADCOR");
    $("#btn-limpa-Cor").on("click", function () { $("#txtCor").val(""); });

    $("#txtLinha").autocompleta(1, `JSON={ "tabela":"TABLIN", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`);
    $("#btn-Linha").pesquisa("#txtLinha", "CODIGO", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABLIN", "camposSelect":[ "CODIGO", "descricao" ], "where": null}', "Pesquisa Linha", "TABLIN");
    $("#btn-limpa-Linha").on("click", function () { $("#txtLinha").val(""); });

    $("#txtGrupo").autocompleta(1, `JSON={ "tabela":"GRUPO_PA", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`);
    $("#btn-Grupo").pesquisa("#txtGrupo", "CODIGO", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"GRUPO_PA", "camposSelect":[ "CODIGO", "descricao" ], "where": null}', "Pesquisa Grupo", "GRUPO_PA");
    $("#btn-limpa-Grupo").on("click", function () { $("#txtGrupo").val(""); });

    $("#txtEtiqueta").autocompleta(1, `JSON={ "tabela":"ETQ_PROD", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`);
    $("#btn-Etiqueta").pesquisa("#txtEtiqueta", "CODIGO", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"ETQ_PROD", "camposSelect":[ "CODIGO", "descricao" ], "where": null}', "Pesquisa Etiqueta", "ETQ_PROD");
    $("#btn-limpa-Etiqueta").on("click", function () { $("#txtEtiqueta").val(""); });

    $("#txtMarkup").autocompleta(1, `JSON={ "tabela":"CAD_MARKUP", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`);
    $("#btn-Markup").pesquisa("#txtMarkup", "CODIGO", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CAD_MARKUP", "camposSelect":[ "CODIGO", "descricao" ], "where": null}', "Pesquisa Markup", "CAD_MARKUP");
    $("#btn-limpa-Markup").on("click", function () { $("#txtMarkup").val(""); });

    $("#txtDeposito").autocompleta(1, `JSON={ "tabela":"DEPOSITO", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`);
    $("#btn-Deposito").pesquisa("#txtDeposito", "CODIGO", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO", "descricao" ], "where": null}', "Pesquisa Depósito", "DEPOSITO");
    $("#btn-limpa-Deposito").on("click", function () { $("#txtDeposito").val(""); });

    $("#txtFornecedor").autocompleta(3, `JSON={ "tabela":"entidade", "camposSelect":["CODCLI CHAVE, NOME DESCRICAO"], "where": ["nome <> 'CONSUMIDOR FINAL' and ativo = 'S'"] }`);
    $("#btnFornecedor").pesquisa_serverside(["#txtFornecedor"], ["CODCLI", "CNPJ"], ["NOME"], `{"tabela":"entidade", "camposSelect":[ "CODCLI", "NOME" ], "where": ["nome <> 'CONSUMIDOR FINAL' and ativo = 'S'"]}`, "Pesquisa Fornecedor");
    $("#btnAFornecedor").on("click", function () { $("#txtFornecedor").val(""); });

    $("#txtMaterial").autocompleta(1, `JSON={ "tabela":"MATERIAL", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`);
    $("#btnMaterial").pesquisa("#txtMaterial", "CODIGO", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"MATERIAL", "camposSelect":[ "CODIGO", "descricao" ], "where": null}', "Pesquisa Material", "MATERIAL");
    $("#btnAMaterial").on("click", function () { $("#txtMaterial").val(""); });

    $("#txtCorItem").autocompleta(1, `JSON={ "tabela":"CADCOR", "camposSelect":["COR CHAVE, DESCRICAO"], "where": [] }`);
    $("#btnCor").pesquisa("#txtCorItem", "COR", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CADCOR", "camposSelect":[ "COR", "descricao" ], "where": null}', "Pesquisa Cor", "CADCOR");
    $("#btnACor").on("click", function () { $("#txtCorItem").val(""); });

    $("#txtCorGrade").autocompleta(1, `JSON={ "tabela":"CADCOR", "camposSelect":["COR CHAVE, DESCRICAO"], "where": [] }`);
    $("#btnCorGrade").pesquisa("#txtCorGrade", "COR", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CADCOR", "camposSelect":[ "COR", "descricao" ], "where": null}', "Pesquisa Cor", "CADCOR");
    $("#btnACorGrade").on("click", function () { $("#txtCorGrade").val(""); });

    $("#txtFaixa").autocompleta(1, `JSON={ "tabela":"FAIXA", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`);
    $("#btnFaixa").pesquisa("#txtFaixa", "CODIGO", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"FAIXA", "camposSelect":[ "CODIGO", "descricao" ], "where": null}', "Pesquisa Faixa", "Faixa");
    $("#btnAFaixa").on("click", function () { $("#txtFaixa").val(""); });
  };

  function criaMascaraCampos() {
    $("#txtTamCm2, #txtLarguraBordado, #txtAlturaBordado, #txtLarguraSerigrafia, #txtAlturaSerigrafia, #txtComissaoFat, #txtComissaoRec, #txtComissao, #txtAliquota, #txtValFrete, #txtPesoBruto, #txtPesoLiquido, #txtFrete, #txtPreco").maskMoney({
      decimal: ".",
      thousands: "",
      precision: 2,
    });

    $("#txtTotalPecasTermotape, #txtTotalPecasBordado, #txtQtdeProg, #txtTotalPecasSerigrafia, #txtVolumes, #txtQtdeCores").maskMoney({
      decimal: ".",
      thousands: "",
      precision: 0,
    });
  };

  function addBotoesAvancarVoltar() {
    $(".next").click(async function () {
      currentFs = $(this).parent();
      nextFs = $(this).parent().next();

      if (currentFs.prevObject[0].id == 'avancar1') {
        if (!$('#txtCliente').val()) {
          throw msgAlerta('Necessário inserir um cliente, verifique!')
        }
      }

      if (currentFs.prevObject[0].id == 'avancarFinanceiro') {
        if (!$('#txtMoeda').val()) {
          throw msgAlerta('Necessário inserir uma moeda, verifique!')
        }
        if (!$('#txtHistorico').val()) {
          throw msgAlerta('Necessário inserir um histórico, verifique!')
        }
        if (!$('#txtBanco').val()) {
          throw msgAlerta('Necessário inserir um banco, verifique!')
        }
        if (!$('#txtSituacao').val()) {
          throw msgAlerta('Necessário inserir uma situação, verifique!')
        }
        if (!$('#txtClasseGer').val()) {
          throw msgAlerta('Necessário inserir uma classe, verifique!')
        }
      }

      $("#progressbar li").eq($("fieldset").index(nextFs) - 2).addClass("active");
      nextFs.show();
      currentFs.animate(
        {
          opacity: 0,
        },
        {
          step(now) {
            opacity = 1 - now;
            currentFs.css({
              display: "none",
              position: "relative",
            });
            nextFs.css({
              opacity,
            });
          },
          duration: 600,
        }
      );
      $("#tabelaDuplicatas").DataTable().columns.adjust().draw(false);
      $("#tabelaItens").DataTable().columns.adjust().draw(false);
    });

    $(".previous").click(async function () {
      let currentFs = $(this).parent();
      let previousFs = $(this).parent().prev();
      $("#progressbar li").eq($("fieldset").index(currentFs) - 2).removeClass("active");
      previousFs.show();
      currentFs.animate(
        {
          opacity: 0,
        },
        {
          step(now) {
            opacity = 1 - now;
            currentFs.css({ display: "none", position: "relative" });
            previousFs.css({ opacity });
          },
          duration: 600,
        }
      );
      $("#tabelaDuplicatas").DataTable().columns.adjust().draw(false);
      $("#tabelaItens").DataTable().columns.adjust().draw(false);
    });
  };

  function addValidacaoCamposObrigatorios() {
    $("#msform").validate({
      debug: false,
      ignore: "",
      rules: {
        txtCliente: {
          required: true,
        },
        txtDeposito: {
          required: true,
        },
        txtTransportadora: {
          required: true,
        },
        "txtProduto-0": {
          required: true,
        },
        "txtQuantidade-0": {
          required: true,
        },
        "txtPreco-0": {
          required: true,
        }
      },
      messages: {
        txtCliente: {
          required: "Informe um cliente válido.",
        },
        txtDeposito: {
          required: "Informe um depósito válido.",
        },
        txtTransportadora: {
          required: "Informe uma transportadora válida.",
        },
        "txtProduto-0": {
          required: "Informe um produto válido.",
        },
        "txtQuantidade-0": {
          required: "Informe uma quantidade válida.",
        },
        "txtPreco-0": {
          required: "Informe um preço válido.",
        }
      },
      errorElement: "span",
      errorPlacement(error, element) {
        error.addClass("invalid-feedback");
        element.closest(".form-group").append(error);
      },
      highlight(element) {
        $(element).addClass("is-invalid");
      },
      unhighlight(element) {
        $(element).removeClass("is-invalid");
      },
    });
  };

  $('#txtDiasValidade').on('blur', function () {
    const dias = pegaValor('#txtDiasValidade');

    if (dias == '') {
      return;
    }

    setarDataAtual('dtValidade', false, parseFloat(dias));
  });

  $('#btn-adiciona-cliente').on('click', async function () {
    $('#modal-entid-simpl').modal('show')
    $('#btnModalNovaEntidSimpl').trigger('click')
  })

  $("#txtMaterial").on('blur', async function () {
    if ($("#txtMaterial").val() == '') {
      return
    }
    $.LoadingOverlay('show')
    try {
      $("#txtCorItem").autocompleta(1, `JSON={ "tabela":"CADCOR", "camposSelect":["CADCOR.COR CHAVE, CADCOR.DESCRICAO DESCRICAO"], "innerjoin": [{"tabela": "MAT_ITEN", "condicao": "MAT_ITEN.COR = CADCOR.COR"}], "where": ["MAT_ITEN.CODIGO = '${pegaChave('#txtMaterial')}' AND CADCOR.INATIVO <> 'S'"] }`);
      $("#btnCor").pesquisa("#txtCorItem", "COR", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CADCOR", "camposSelect":[ "CADCOR.COR", "CADCOR.DESCRICAO" ], "innerjoin": [{"tabela": "MAT_ITEN", "condicao": "MAT_ITEN.COR = CADCOR.COR"}], "where": ["MAT_ITEN.CODIGO = '${pegaChave('#txtMaterial')}' AND CADCOR.INATIVO <> 'S'"]}`, "Pesquisa Cor", "CADCOR");
    } finally {
      $.LoadingOverlay('hide')
    }
  })

  $('#modalComposicao').on('shown.bs.modal', async function () {
    $.LoadingOverlay('show')
    try {
      if ($("#txtMaterial").val() != '') {
        $("#txtCorItem").autocompleta(1, `JSON={ "tabela":"CADCOR", "camposSelect":["CADCOR.COR CHAVE, CADCOR.DESCRICAO DESCRICAO"], "innerjoin": [{"tabela": "MAT_ITEN", "condicao": "MAT_ITEN.COR = CADCOR.COR"}], "where": ["MAT_ITEN.CODIGO = '${pegaChave('#txtMaterial')}' AND CADCOR.INATIVO <> 'S'"] }`);
        $("#btnCor").pesquisa("#txtCorItem", "COR", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CADCOR", "camposSelect":[ "CADCOR.COR", "CADCOR.DESCRICAO" ], "innerjoin": [{"tabela": "MAT_ITEN", "condicao": "MAT_ITEN.COR = CADCOR.COR"}], "where": ["MAT_ITEN.CODIGO = '${pegaChave('#txtMaterial')}' AND CADCOR.INATIVO <> 'S'"]}`, "Pesquisa Cor", "CADCOR");
      }
    } finally {
      $.LoadingOverlay('hide')
    }
  })

  async function limpaValoresItens() {
    limpaValor('#txtCodigo')
    limpaValor('#txtCor')
    limpaValor('#txtLinha')
    limpaValor('#txtGrupo')
    limpaValor('#txtEtiqueta')
    // limpaValor('#txtMarkup')
    limpaValor('#txtDeposito')
    limpaValor('#txtFrete')
    limpaValor('#txtQtde')
    limpaValor('#txtPreco')
    limpaValor('#dtEntregaItem')
    limpaValor('#txtObsProduto')
    limpaValor('#txtObsProducao')
    limpaValor('#txtObsEspecificacoes')
    limpaValor('#txtCorGrade')
    limpaValor('#txtFaixa')
    limpaValor('#txtNomeSerigrafia')
    limpaValor('#txtQtdeCores')
    limpaValor('#txtAlturaSerigrafia')
    limpaValor('#txtLarguraSerigrafia')
    limpaValor('#txtTotalPecasSerigrafia')
    limpaValor('#txtTamCm2')
    limpaValor('#txtTotalPecasTermotape')
    $('#txtQtdeTotal').val(0)
    $('#txtValTotal').val(0)

    $('#tabelaCaracteristicas').DataTable().rows().clear().draw(false)
    $('#tabelaComposicao').DataTable().rows().clear().draw(false)
    $('#tabelaAplicacoes').DataTable().rows().clear().draw(false)
    $('#tabelaTecidosUtilizados').DataTable().rows().clear().draw(false)
    $('#tabelaConsumos').DataTable().rows().clear().draw(false)
    $('#tabelaSerigrafia').DataTable().rows().clear().draw(false)
    $('#tabelaBordado').DataTable().rows().clear().draw(false)
    $('#tabelaSublimacao').DataTable().rows().clear().draw(false)
    $('#tabelaTermotape').DataTable().rows().clear().draw(false)
    $('#tabelaTermotapeTipo').DataTable().rows().clear().draw(false)
    $('#tabelaGrade').DataTable().rows().clear().draw(false)
  }

  $('#btnDesistirInfos').on('click', async function () {
    $.LoadingOverlay('show')
    try {
      await limpaValoresItens()
    } finally {
      $.LoadingOverlay('hide')
    }
  })

  $('#tabelaTecidosUtilizados').on('click', '.checkAplicacoes', async function () {
    $.LoadingOverlay('show')
    try {
      let item = $('#tabelaTecidosUtilizados').DataTable().row($(this).parents('tr')).data()
      if ($(this).is(':checked')) {
        for (let j = 0; j < $('#tabelaAplicacoes').DataTable().data().toArray().length; j++) {
          const aplicacao = $('#tabelaAplicacoes').DataTable().data().toArray()[j]
          for (let i = 0; i < $('#tabelaComposicao').DataTable().data().toArray().length; i++) {
            const composicao = $('#tabelaComposicao').DataTable().data().toArray()[i]

            if (item.CODIGO == composicao.CODIGO) {
              item.COR = composicao.COR
              item.ID = aplicacao.ID
              item.COD_APL = aplicacao.COD_APL
            }
          }
        }
        $('#tabelaTecidosUtilizados').DataTable().row($(this).parents('tr')).draw(false);
      }
    } finally {
      $.LoadingOverlay('hide')
    }
  })

  async function buscarOrcamento(orcamento) {
    $.LoadingOverlay('show')
    try {
      const pesquisaParam = {
        tabela: 'OS',
        camposSelect: ['OS.NUMERO', 'OS.CLIENTE', 'ENTIDADE.NOME NOME_CLI', 'OS.PED_CLI', 'OS.DTDIGITA',
          'OS.CODREP', 'REPRESEN.NOME NOME_REP', 'OS.COM1', 'OS.COM2', 'OS.CODAGENCIA', 'AGENCIA.NOME NOME_AGEN',
          'OS.COM1_AGENCIA', 'OS.PEDIDO', 'OS.TERCEIRO SOLICITANTE', 'CONTATO.NOME NOME_SOL',
          'OS.TAB_PRE', 'REGIAO.DESCRICAO DESC_TABPRECO', 'OS.BLOQ_COM', 'OS.DT_CADASTRO DT_EMI', 'OS.VALIDADE',
          'OS.DT_VALIDADE', 'OS.DIAS_ENTREGA', 'OS.DT_ENTREGA', 'OS.DT_SAIDA', 'OS.OBSERVACAO', 'OS.SITUACAO', 'OS.SOMA_DIAS_ENT',
          'OS.MOEDA', 'MOEDA.DESCRICAO DESC_MOE', 'OS.HISTORICO', 'HISTCP.DESCRICAO DESC_HIST', 'OS.SIT_DUP',
          'TABSIT.DESCRICAO DESC_SIT', 'OS.CLASSE_GER', 'CLASSE_GER.DESCRICAO DESC_CLASSE', 'OS.TAB_TRANS',
          'TABTRAN.NOME NOME_TRANSP', 'OS.CIF, OS.NATUREZA', 'NATUREZA.DESCRICAO DESC_NATUREZA', 'NATUREZA.ALIQUOTA',
          'OS.FRETE', 'OS.PESO_BRUTO', 'OS.PESO_LIQ', 'OS.VOLUMES', 'ENTIDADE.END_ENT', 'ENTIDADE.BAIRRO_ENT',
          'CIDADE.NOME NOME_CIDADE', 'CIDADE.COD_UF', 'ENTIDADE.NUM_ENT', 'ENTIDADE.CEP', 'OS.MARKUP'],
        leftJoin: [{ tabela: "ENTIDADE", alias: "ENTIDADE", condicao: "ENTIDADE.CODCLI = OS.CLIENTE" },
        { tabela: "REPRESEN", alias: "REPRESEN", condicao: "REPRESEN.CODREP = OS.CODREP" },
        { tabela: "REPRESEN", alias: "AGENCIA", condicao: "AGENCIA.CODREP = OS.CODAGENCIA" },
        { tabela: "CONTATO", alias: "CONTATO", condicao: "CONTATO.NUMERO = OS.TERCEIRO " },
        { tabela: "REGIAO", alias: "REGIAO", condicao: "REGIAO.REGIAO = OS.TAB_PRE " },
        { tabela: "MOEDA", alias: "MOEDA", condicao: "CAST(MOEDA.CODMOE AS VARCHAR(3)) = OS.MOEDA" },
        { tabela: "HISTCP", alias: "HISTCP", condicao: "HISTCP.HISTORICO = OS.HISTORICO " },
        { tabela: "TABSIT", alias: "TABSIT", condicao: "TABSIT.CODIGO = OS.SIT_DUP " },
        { tabela: "CLASSE_GER", alias: "CLASSE_GER", condicao: "CLASSE_GER.CODIGO = OS.CLASSE_GER " },
        { tabela: "TABTRAN", alias: "TABTRAN", condicao: "TABTRAN.CODIGO = OS.TAB_TRANS" },
        { tabela: "NATUREZA", alias: "NATUREZA", condicao: "NATUREZA.NATUREZA = OS.NATUREZA " },
        { tabela: "CADCEP", alias: "CADCEP", condicao: "ENTIDADE.CEP = CADCEP.CEP " },
        { tabela: "CI", alias: "CIDADE", condicao: "CIDADE.CODIGO = CADCEP.CODMUN" }],
        where: [`OS.NUMERO = '${orcamento}'`],
        limit: 1
      }

      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));
      const os = jsonStr[0]

      //PREENCHE OS CAMPOS DO ORCAMENTO
      $('#txtNumero').val(orcamento)
      insereValor('#txtCliente', os.CLIENTE, os.NOME_CLI)
      $('#txtPedcli').val(os.PED_CLI)
      $('#dtDigitacao').val(os.DTDIGITA)
      insereValor('#txtRepresentante', os.CODREP, os.NOME_REP)
      $('#txtComissaoFat').val(os.COM1)
      $('#txtComissaoRec').val(os.COM2)
      insereValor('#txtAgencia', os.CODAGENCIA, os.NOME_AGEN)
      $('#txtComissao').val(os.COM1_AGENCIA)
      $('#txtPedido').val(os.PEDIDO)
      insereValor('#txtSolicitante', os.SOLICITANTE, os.NOME_SOL)
      insereValor('#txtTabPreco', os.TAB_PRE, os.DESC_TABPRECO)
      $('#selectStatusComercial').val(os.BLOQ_COM)
      $('#dtEmissao').val(os.DT_EMI)
      $('#txtDiasValidade').val(os.VALIDADE)
      $('#dtValidade').val(os.DT_VALIDADE)
      $('#txtDias').val(os.DIAS_ENTREGA)
      $('#dtEntrega').val(os.DT_ENTREGA)
      $('#dtSaida').val(os.DT_SAIDA)
      $('#txtObservacoes').val(os.OBSERVACAO)
      switch (os.SITUACAO) {
        case 'A': {
          $('#rdSituacaoAberto').prop('checked', true)
          break
        }
        case 'F': {
          $('#rdSituacaoFechado').prop('checked', true)
          break
        }
        case 'E': {
          $('#rdSituacaoEmAprov').prop('checked', true)
          break
        }
        case 'P': {
          $('#rdSituacaoPerdido').prop('checked', true)
          break
        }
        default: break
      }
      $('#rdSumDiasCorridos').prop('checked', os.SOMA_DIAS_ENT == 'C')
      $('#rdSumDiasUteis').prop('checked', os.SOMA_DIAS_ENT != 'C')
      //ABA FINANCEIRO
      insereValor('#txtMoeda', os.MOEDA, os.DESC_MOE)
      insereValor('#txtHistorico', os.HISTORICO, os.DESC_HIST)
      insereValor('#txtSituacao', os.SIT_DUP, os.DESC_SIT)
      insereValor('#txtClasseGer', os.CLASSE_GER, os.DESC_CLASSE)
      const codBanco = (await buscaValor('MOEDA', 'BANCO', 'CODMOE', os.MOEDA)).BANCO
      insereValor('#txtBanco', codBanco, { tabela: 'CADBAN', campoBusca: 'NOME_BANCO', campoWhere: 'BANCO', valorWhere: codBanco })
      //ABA TRANSPORTE
      insereValor('#txtTransportadora', os.TAB_TRANS, os.NOME_TRANSP)
      $('#rgTransportador').val(os.CIF)
      insereValor('#txtNatureza', os.NATUREZA, os.DESC_NATUREZA)
      $('#txtAliquota').val(os.ALIQUOTA)
      $('#txtValFrete').val(os.FRETE)
      $('#txtPesoBruto').val(os.PESO_BRUTO)
      $('#txtPesoLiquido').val(os.PESO_LIQ)
      $('#txtVolumes').val(os.VOLUMES)
      $('#txtEndEntrega').val(os.END_ENT)
      $('#txtBairroEntrega').val(os.BAIRRO_ENT)
      $('#txtCidadeEntrega').val(os.NOME_CIDADE)
      $('#txtEstadoEntrega').val(os.COD_UF)
      $('#txtNumeroEntrega').val(os.NUM_ENT)
      $('#txtCepEntrega').val(os.CEP)

      await buscaItens(orcamento, os)
      await buscaFinanceiro(orcamento)
      await calculaTotaisItens()

    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }
  }

  async function buscaItens(orcamento, os) {
    const pesquisaParam = {
      tabela: 'OS_ITEN',
      camposSelect: ['OS_ITEN.ORDEM_DIG', 'OS_ITEN.CODIGO', 'OS_ITEN.TIPO_PROD',
        'PRODUTO.DESCRICAO DESCPRO', 'PROTOTIPO.DESCRICAO DESCPROT',
        'OS_ITEN.COR', 'CADCOR.DESCRICAO DESCCOR',
        'OS_ITEN.TAM', 'OS_ITEN.QTDE', 'OS_ITEN.PRECO', 'OS_ITEN.FAIXA',
        'OS_ITEN.VALOR_TOTAL VALOR', 'OS_ITEN.CUSTOMIZACAO', 'OS_ITEN.OBS_APROV', 'OS_ITEN.OBS2', 'OS_ITEN.OBS3', 'OS_ITEN.OBSERVACAO'],
      leftJoin: [{ tabela: "CADCOR", condicao: "CADCOR.COR = OS_ITEN.COR" },
      { tabela: "PRODUTO", condicao: "OS_ITEN.CODIGO = PRODUTO.CODIGO AND PRODUTO.CODIGO <> ''" },
      { tabela: "PRODUTO", alias: "PROTOTIPO", condicao: "OS_ITEN.PROTOTIPO = PROTOTIPO.PROTOTIPO AND OS_ITEN.PROTOTIPO IS NOT NULL AND OS_ITEN.PROTOTIPO <> ''" }
      ],
      where: [`OS_ITEN.NUMERO = '${orcamento}'`]
    }

    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));


    insereValor('#txtMarkup', os.MARKUP, { tabela: 'CAD_MARKUP', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: os.MARKUP })
    jsonStr.map(item => {
      $('#tabelaItens').DataTable().row.add({
        ORDEM: item.ORDEM_DIG,
        CODIGO: item.CODIGO,
        DESCRICAO: item.TIPO_PROD == 'E' ? item.DESCPRO : item.DESCPROT,
        COR: item.COR,
        DESCCOR: item.DESCCOR,
        TAM: item.TAM,
        QTDE: item.QTDE,
        PRECO: item.PRECO,
        VALOR: item.VALOR,
        CUSTOMIZACAO: item.CUSTOMIZACAO,
        OBS2: item.OBS2,
        OBS3: item.OBS3,
        OBSERVACAO: item.OBSERVACAO,
        FAIXA: item.FAIXA,
      }).draw(false);
    });
  }

  async function buscaFinanceiro(orcamento) {
    const pesquisaParam = {
      tabela: 'OS_SIMULA',
      camposSelect: ['NUM_PARCELA', 'VENCTO', 'VALOR_PARCELA', 'CONSIDERAR'],
      where: [`NUMERO = '${orcamento}'`]
    }

    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

    jsonStr.map(item => {
      $('#tabelaDuplicatas').DataTable().row.add([
        item.NUM_PARCELA,
        item.VENCTO,
        item.VALOR_PARCELA
      ]).draw(false);
    });

    $('#checkConsiderarSimulação').prop('checked', jsonStr[0].CONSIDERAR != 'N');
  }

  async function buscaTabelaCliente() {
    if (pegaChave('#txtCliente') == '') {
      return
    }
    $.LoadingOverlay('show')
    try {
      const pesquisaParam = {
        tabela: 'ENTIDADE',
        camposSelect: ['ENTIDADE.TABELA', 'REGIAO.DESCRICAO'],
        leftJoin: [{ tabela: "REGIAO", condicao: "REGIAO.REGIAO = ENTIDADE.TABELA" }],
        where: [`ENTIDADE.CODCLI = '${pegaChave('#txtCliente')}'`]
      }

      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

      if (jsonStr.length > 0) {
        insereValor('#txtTabPreco', jsonStr[0].TABELA, jsonStr[0].DESCRICAO)
      }

    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }
  }

  async function carregaConsumosExpress(sCodigo, sCor) {
    $.LoadingOverlay('show');
    $('#tabelaConsumos').DataTable().clear().draw();
    try {
      const response = await requisicao('GET', '/sisplan/orcamento/v1/buscaconsumosexpress?', `CODIGO=${sCodigo}&COR=${sCor}`);

      if (!response) {
        return;
      }

      const jsonStr = await response.json();

      jsonStr.map(item => {
        $('#tabelaConsumos').DataTable().row.add({
          CODIGO: item.INSUMO,
          DESCRICAO: item.DESCRICAO,
          QTDE: item.CONSUMO,
          CUSTO: item.PRECO_1,
          SETOR: '',
          DESC_SETOR: '',
          COR: item.COR_I,
          DESC_COR: item.DESCCOR,
        }).draw(false);
      });

    } finally {
      $.LoadingOverlay('hide');
    }
  };

  async function explodeFaixaExpress(sFaixa, sTabPreco, sCodigo) {
    if (pegaValor('#txtValTotal') > 0) {
      return;
    }

    $.LoadingOverlay('show');
    $('#tabelaGrade').DataTable().clear();
    try {
      let pesquisaParam;
      if (!usaPrecoCorTam) {
        pesquisaParam = {
          tabela: 'FAIXA_ITEN',
          camposSelect: ['FAIXA_ITEN.TAMANHO', 'FAIXA_ITEN.POSICAO', 'TABPRECO.PRECO_00 PRECO'],
          leftJoin: [{ tabela: "TABPRECO", condicao: `TABPRECO.REGIAO = '${sTabPreco}' AND TABPRECO.CODIGO = '${sCodigo}'` }],
          where: [`FAIXA_ITEN.FAIXA = '${sFaixa}'`],
          orderBy: ['FAIXA_ITEN.POSICAO'],
        }
      } else {
        pesquisaParam = {
          tabela: 'FAIXA_ITEN',
          camposSelect: ['FAIXA_ITEN.TAMANHO', 'FAIXA_ITEN.POSICAO', 'PRECO_COR_TAM.PRECO'],
          leftJoin: [{ tabela: "PRECO_COR_TAM", condicao: `PRECO_COR_TAM.REGIAO = '${sTabPreco}' AND PRECO_COR_TAM.CODIGO = '${sCodigo}' AND PRECO_COR_TAM.COR = '${pegaChave('#txtCor')}' AND PRECO_COR_TAM.TAM = FAIXA_ITEN.TAMANHO` }],
          where: [`FAIXA_ITEN.FAIXA = '${sFaixa}'`],
          orderBy: ['FAIXA_ITEN.POSICAO'],
        }
      }

      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

      const precoVenda = await montaPrecoVenda(true);

      jsonStr.map((item, index) => {
        $('#tabelaGrade').DataTable().row.add({
          TAMANHO: item.TAMANHO,
          QTDE: retornaInputValor('txtQtdeGrade txtCamposGrade', index, true),
          PRECO: item.PRECO > 0 && usaPrecoCorTam ? item.PRECO : precoVenda,
          PERC_ACRESC: retornaInputValor('txtPercAcresGrade txtCamposGrade', index),
          VAL_ACRESC: retornaInputValor('txtValAcresGrade txtCamposGrade', index),
          PERC_DESC: retornaInputValor('txtPercDescGrade txtCamposGrade', index),
          VAL_DESC: retornaInputValor('txtValDescGrade txtCamposGrade', index),
          PRECO_LIQ: '0.00',
          TOTAL: '0.00',
        }).draw(false);
      });

      if (itensAlteracao.length > 0) {
        $('#tabelaGrade').DataTable().data().toArray().forEach((item, index) => {
          const itemAlteracao = itensAlteracao.find(item2 => item2.TAM == item.TAMANHO);
          if (itemAlteracao) {
            $($('.txtQtdeGrade')[index]).val(itemAlteracao.QTDE)
            calculaTotaisGrade($($('.txtQtdeGrade')[index]).attr('data-campo').replace(' txtCamposGrade', ''), $($('.txtQtdeGrade')[index]).attr('data-index'));
          }
        })
      }
    } finally {
      $('.txtCamposGrade').on('blur', function () {
        calculaTotaisGrade($(this).attr('data-campo').replace(' txtCamposGrade', ''), $(this).attr('data-index'));
      });

      insereValor('#txtQtdeTotal', '0.00');
      insereValor('#txtValTotal', '0.00');

      aplicaMascara();

      $.LoadingOverlay('hide');
    }
  };

  async function preencheFaixa() {
    $.LoadingOverlay('show')
    try {
      const pesquisaParam = {
        tabela: 'PRODUTO',
        camposSelect: ['PRODUTO.FAIXA', 'FAIXA.DESCRICAO DESC_FAIXA'],
        leftJoin: [{ tabela: "FAIXA", condicao: `FAIXA.CODIGO = PRODUTO.FAIXA` }],
        where: [`PRODUTO.CODIGO = '${pegaChave('#txtCodigo')}'`],
      }

      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

      insereValor('#txtFaixa', jsonStr[0].FAIXA, jsonStr[0].DESC_FAIXA);
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }
  }

  $('#btnConfirmarInfos').on('click', async function () {
    $.LoadingOverlay('show')
    try {
      await preencheItens()
      await limpaValoresItens()
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }
  })

  async function preencheItens() {
    const tabelaItens = $('#tabelaItens').DataTable()
    let ordem = tabelaItens.data().toArray().length <= 0 ? 0 : tabelaItens.column(0).data().reduce(function (a, b) {
      return Math.max(a, b)
    })
    ordem = itensAlteracao.length > 0 ? parseInt(itensAlteracao[0].ORDEM) <= 0 ? ordem + 1 : itensAlteracao[0].ORDEM : ordem + 1
    const cor = $('#txtCor').val() == '' ? pegaChave('#txtCorGrade') : pegaChave('#txtCor')
    const descCor = $('#txtCor').val() == '' ? pegaDescricao('#txtCorGrade') : pegaDescricao('#txtCor')
    let qtdeTotal = 0;
    const codigo = $('#txtCodigo').val() != '' ? pegaChave('#txtCodigo') : await RetornaProximo('PROTOTIPO', 'PRODUTO', 'PROTOTIPO', 6)
    const descricao = $('#txtCodigo').val() != '' ? pegaDescricao('#txtCodigo') : ''
    const valorTotal = parseFloat($('#txtValTotal').val())
    for (let i = 0; i < $('#tabelaGrade').DataTable().data().toArray().length; i++) {
      qtdeTotal += parseInt($($('.txtQtdeGrade')[i]).val())
    }
    if (cor == '') {
      throw new Error('Cor da grade não informada')
    }
    if (qtdeTotal <= 0) {
      throw new Error('Quantidade da grade não preenchida, verifique.')
    }
    if (valorTotal <= 0) {
      throw new Error('Itens sem preço, verifique.')
    }

    const tabelaGrade = $('#tabelaGrade').DataTable().data().toArray()

    for (let i = 0; i < tabelaGrade.length; i++) {
      const grade = tabelaGrade[i]

      const obj = {
        ORDEM: ordem,
        CODIGO: codigo,
        DESCRICAO: descricao,
        COR: cor,
        DESCCOR: descCor,
        TAM: grade.TAMANHO,
        QTDE: parseInt($($('.txtQtdeGrade')[i]).val()),
        PRECO: parseFloat(grade.PRECO),
        VALOR: parseFloat(grade.TOTAL),
        CUSTOMIZACAO: parseFloat(0),
        OBS2: $('#txtObsProduto').val(),
        OBS3: $('#txtObsProducao').val(),
        OBSERVACAO: $('#txtObsEspecificacoes').val(),
        FAIXA: pegaChave('#txtFaixa'),
      }

      if (itensAlteracao && itensAlteracao.length > 0) {
        const itemExistente = itensAlteracao.find(item =>
          item.ORDEM == obj.ORDEM &&
          item.CODIGO == obj.CODIGO &&
          item.COR == obj.COR &&
          item.TAM == obj.TAM
        );

        if (itemExistente) {
          tabelaItens.rows(function (idx, data, node) {
            return data.ORDEM == obj.ORDEM && data.CODIGO == obj.CODIGO && data.COR == obj.COR && data.TAM == obj.TAM;
          }).remove().draw(false);
        }
      }

      if (parseInt($($('.txtQtdeGrade')[i]).val()) <= 0) {
        continue
      }

      tabelaItens.row.add(obj).draw(false);
    }
    calculaTotais()
    $('#modalItem').modal('hide')
  }

  function calculaTotais() {
    let qtdeTotal = 0;
    let valorTotal = 0;
    for (let i = 0; i < $('#tabelaItens').DataTable().data().toArray().length; i++) {
      const item = $('#tabelaItens').DataTable().data().toArray()[i]
      qtdeTotal += parseInt(item.QTDE)
      valorTotal = parseFloat(valorTotal) + parseFloat(item.VALOR)
    }

    const novoValor = parseFloat(valorTotal)
    $('.txtTotalQtde').text(qtdeTotal)
    $('.txtValorTotal').html(parseFloat(novoValor.toFixed(2)).toLocaleString("pt-BR", { style: "currency", currency: "BRL", }));
  }

  $('#modalItem').on('hidden.bs.modal', function () {
    $('#tabelaItens').DataTable().columns.adjust().draw(false)
    itensAlteracao = []
    limpaValoresItens()
  })

  $('#tabelaItens').on('click', '#btn-excluir', async function () {
    await msgAguardaConfirmacao('Deseja excluir este registro?', async () => {
      $('#tabelaItens').DataTable().data().rows($('#tabelaItens').DataTable().row($($(this).get(0)).closest('tr')).index()).remove().draw(false);
      calculaTotais()
    })
  })

  $('#tabelaItens').on('click', '#btn-editar', async function () {
    $.LoadingOverlay('show')
    try {
      const data = $('#tabelaItens').DataTable().row($(this).parents('tr')).data()
      itensAlteracao = $('#tabelaItens').DataTable().data().toArray().filter(item => { return item.CODIGO == data.CODIGO && item.ORDEM == data.ORDEM })
      insereValor('#txtCodigo', data.CODIGO, data.DESCRICAO)
      insereValor('#txtCor', data.COR, data.DESCCOR)
      $('#txtQtde').val(1);
      $('#txtPreco').val(data.PRECO);

      $('#modalItem').modal('show')
      $('#txtCodigo').trigger('blur')
      $('#txtObsProduto').val(data.OBS2)
      $('#txtObsProducao').val(data.OBS3)
      $('#txtObsEspecificacoes').val(data.OBSERVACAO)

      if (data.FAIXA) {
        insereValor('#txtFaixa', data.FAIXA, { tabela: 'FAIXA', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: data.FAIXA })
      }
      $('#txtFaixa').prop('disabled', true)
      $('#btnFaixa').prop('disabled', true)
      $('#btnAFaixa').prop('disabled', true)

      $('#txtCodigo').prop('disabled', true)
      $('#btn-Codigo').prop('disabled', true)
      $('#btn-limpa-Codigo').prop('disabled', true)

      $('#txtCor').prop('disabled', true)
      $('#btn-Cor').prop('disabled', true)
      $('#btn-limpa-Cor').prop('disabled', true)

      $('#txtQtde').prop('disabled', true)
    } finally {
      $.LoadingOverlay('hide')
    }
  })

  $('#txtQtde').on('keydown', function (e) {
    if (e.key == ',' || e.key == '.') {
      e.preventDefault();
    }
  });

  $('#txtQtde').on('input', function () {
    this.value = this.value.replace(/[^\d-]/g, '');
    this.value = this.value.replace(/(\d+)[.,](\d+)/, '$1');
  });

  $('#btnVoltar').on('click', async function () {
    await deletaRegistro('ORCAMENTO', getCookie('usuario'), orcamento);
    window.location.href = `${BASE_URI}/orcamento`;
  })

});
