$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false
    });
    driver.defineSteps([

      {
        element: '#btnFiltros',
        popover: {
          title: 'Botão Filtros',
          description: 'Clique aqui para filtrar a consulta.',
          position: 'right'
        }
      },
      {
        element: '#btnIncluir',
        popover: {
          title: 'Botão Incluir',
          description: 'Clique aqui para iniciar o cadastro de uma Modalidade de Pagamento.',
          position: 'right'
        }
      },
      {
        element: '#btnImprimir',
        popover: {
          title: 'Botão Imprimir',
          description: 'Clique aqui para imprimir as solicitações de compras filtradas.',
          position: 'right'
        }
      },
      {
        element: '#tabelaSolCompra',
        popover: {
          title: 'Tabela Solicitações',
          description: 'Aqui estão os dados das solicitações cadastradas.',
          position: 'top'
        }
      }
    ]);
    driver.start();
  });
});

$(document).ready(async function () {

  $('#txtBanco').pesquisa_variosServerside(1, '{ "tabela":"CADBAN", "camposSelect":["BANCO", "NOME_BANCO"],  "where": null}', "BANCO",  "NOME_BANCO");
  $("#btnBanco").pesquisa_serversideSel("#txtBanco", `{"tabela":"CADBAN", "camposSelect":[ "BANCO", "NOME_BANCO" ], "where": null}`, "Pesquisa Banco");
  $('#btnLimpaBanco').on('click', function () {
    $('#txtBanco').empty().trigger('change');
  });

  $('#txtCodigo').pesquisa_variosServerside(1, '{ "tabela":"MODA_PAGTO", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'CODIGO', 'DESCRICAO');
  $('#btnCodigo').pesquisa_serversideSel('#txtCodigo', `{ "tabela":"MODA_PAGTO", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}`, 'Pesquisa Código Modalidade de Pagamento');
  $('#btnLimpaCodigo').on('click', function () {
    $('#txtCodigo').empty().trigger('change');
  });

  $('#btnFiltros').on('click', function () {
    $('#modal-filtros').modal('show');
  });

  $('#btnLimparFiltros').on('click', function () {
    $('#txtBanco').empty().trigger('change');
    $('#txtCodigo').empty().trigger('change')
  });

  const permissaoUsuarioLogado = await permissaoAcessos("MODALIDADE_PAGAMENTO");

  await fazConsulta();

  $('#btnConsultar').on('click', async function () {
    $('#modal-filtros').modal('hide');
    await fazConsulta();
  });

  $('#btnIncluir').on('click', function () {
    if (permissaoUsuarioLogado.INCLUI == 'S') {
      window.location.href = "modalidade_pagamento/create";
    } else {
      msgAlertaSemConfirmacao("Sem permissão para incluir!");
    }
  });

  async function fazConsulta() {
    try {
      $.LoadingOverlay("show");
      let response;
      let listaBanco = await formataListas($('#txtBanco').val().toString());
      let listaCodigo = await formataListas($('#txtCodigo').val().toString());

      let banco = await formataListas($('#txtBanco').val().toString()) != '' ? ` MODA_PAGTO.BANCO IN (${listaBanco})` : '';
      let codigo = await formataListas($('#txtCodigo').val().toString()) != '' ? ` MODA_PAGTO.CODIGO IN (${listaCodigo})` : '';

      response = await requisicao('GET',
        '/Sisplan/Funcoes/V1/pesquisa?',
        `JSON={ 
          "tabela":"MODA_PAGTO", 
          "camposSelect":["MODA_PAGTO.CODIGO", "MODA_PAGTO.DESCRICAO", "MODA_PAGTO.BANCO", "CADBAN.NOME_BANCO", "MODA_PAGTO.DIAS"], 
          "innerjoin": [
              { "tabela" : "CADBAN", "condicao" : "CADBAN.BANCO = MODA_PAGTO.BANCO" }
          ],
          "where": ["1=1", "${banco}", "${codigo}"],
          "orderBy": ["MODA_PAGTO.CODIGO"]
        }`, 1000);

      if (!response) {
        $.LoadingOverlay("hide");
        return;
      }

      let jsonStr = await response.json();
      if (response.status != 200) {
        $.LoadingOverlay("hide");
        msgAlerta(jsonStr.RESULT[0].mensagem);
        return;
      }

      $("#tabelaModalidadePagamento").DataTable({
        destroy: true,
        lengthChange: false,
        language: {
          sEmptyTable: "Nenhum registro encontrado",
          sInfo: "_TOTAL_ registros",
          sInfoEmpty: " 0 registros",
          sInfoFiltered: "(Filtrados de _MAX_ registros)",
          sInfoPostFix: "",
          sInfoThousands: ".",
          sLengthMenu: "_MENU_ resultados",
          sLoadingRecords: "Carregando...",
          sProcessing: "Processando...",
          sZeroRecords: "Nenhum registro encontrado",
          sSearch: "Pesquisar",
          oPaginate: {
            sNext: "Próximo",
            sPrevious: "Anterior",
            sFirst: "Primeiro",
            sLast: "Último",
          },
          oAria: {
            sSortAscending: ": Ordenar colunas de forma ascendente",
            sSortDescending: ": Ordenar colunas de forma descendente",
          },
        },

        autoWidth: true,
        data: jsonStr.RESULT[0],
        columns: [
          {
            title: "Código Banco",
            data: "BANCO",
          },
          {
            title: "Nome Banco",
            data: "NOME_BANCO",
          },
          {
            title: "Código",
            data: "CODIGO",
          },
          {
            title: "Descrição",
            data: "DESCRICAO",
          },
          {
            title: "Dias",
            data: "DIAS",
          },
        ],
        columnDefs: [
          {
            targets: [0], render: function (data, type, row) {
              return retornaBotaoOpcoes(data);
            }
          },
          {
            "targets": [4],
            "className": 'pr-4 text-right'
          }
        ],
      });
      $.LoadingOverlay("hide");
    } catch (error) {
      console.error(error);
      $.LoadingOverlay("hide");
    }
  }

  $("#tabelaModalidadePagamento").unbind("click");

  $('#tabelaModalidadePagamento').on('click', '#btn-excluir', async function () {
    if (permissaoUsuarioLogado.EXCLUI == 'S') {
      msgAlerta('Você realmente deseja excluir esse registro?', async () => {
        const data = $("#tabelaModalidadePagamento").DataTable().row($(this).parents("tr"));
        await excluiRegistro(data);
      });
    } else {
      msgAlertaSemConfirmacao("Sem permissão para excluir!");
    }
  });

  $("#tabelaModalidadePagamento").on('click', '#btn-editar', async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $("#tabelaModalidadePagamento").DataTable().row($(this).parents("tr")).data();
      window.location.href = `modalidade_pagamento/${data.CODIGO}&${data.BANCO}`;
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });



  $("#tabelaModalidadePagamento").on("dblclick", "tr", async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $("#tabelaModalidadePagamento").DataTable().row($(this)).data();
      window.location.href = `modalidade_pagamento/${data.CODIGO}&${data.BANCO}`;
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  async function excluiRegistro(data) {
    try {
      $.LoadingOverlay("show");
      try {
        let valorLinha = data.data();
        let response = await requisicao("DELETE", "/sisplan/cadastros/v1/modalidadepagamento?", `BANCO=${encodeURIComponent(valorLinha.BANCO)}&CODIGO=${encodeURIComponent(valorLinha.CODIGO)}`, null);
        if (!response) {
          return;
        }
        if (response.status != 200) {
          let jsonStr = await response.json();
          msgAlerta(jsonStr.mensagem);
          return;
        }

        toastr.success("Exclusão efetuada com sucesso!", "Confirmação", {
          toastClass: "success",
          iconClasses: {
            error: "alert-error",
            info: "alert-info",
            success: "alert-success",
            warning: "alert-warning",
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000,
          onHidden() {
            data.remove().draw(false);
          },
        }).css({
          "margin-top": "20%",
          width: "500px",
          "max-width": "500px",
        });

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  }

  $('#btnImprimir').on('click', async function () {
    const sBanco = await formataListas($('#txtBanco').val().toString());
    const sCodigo = await formataListas($('#txtCodigo').val().toString());
    try {
      $.LoadingOverlay('show');
      try {
        // alterado a rota
        const url = `/sisplan/impressao/v1/imprimirmodalidadepagamento?`;
        const bImprimeAutomatico = await verificaImprimirAutomatico('ModalidadePagamento');
        const arquivo = await GeraRelatorio(`${url}BANCO=${sBanco}&CODIGO=${sCodigo}`, 'GET', 100000, false, 'ModalidadePagamento');
        if (arquivo != undefined) {
          if (!bImprimeAutomatico) {
            window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
          }
          await limparRelatorios();
        }

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  function retornaBotaoOpcoes(data) {
    var retorno = '<div style="text-align:start;"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" id="tutorialTabela" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + data + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu"> ' +
      '    <button class="dropdown-item" type="button" title="Editar" id="btn-editar">Editar</button>     ' +
      '    <button class="dropdown-item" type="button" title="Excluir" id="btn-excluir">Excluir</button>  ' +
      '</div>';
    return retorno;
  };

});