// eslint-disable-next-line no-unused-vars
class OpcoesMetas {
  constructor(valor, operacao, percentual, item, id, idValor) {
    this.operacao = operacao;
    this.valor = valor;
    this.item = item;
    this.id = id;
    this.idValor = idValor;
    this.tipo = $('#txtTipoDaMeta').val();
    this.Metas = new Metas();
    this.percentual = percentual;

    let arrDias = [];
    $('#tabelaDiasMeta').DataTable().rows().data().map((item, index) => {
      if ($($('.campoSel')[index]).prop('checked')) {
        arrDias.push(item.DATA.substring(0, 10));
      }
    });

    this.dias = arrDias;

    this.url = '/sisplan/metas/v1/opcoes?';
  }

  validar() {
    if (this.operacao == '') {
      msgAlerta('Campo operação não informado! ');
      return false;
    }
    if (this.valor == 0) {
      msgAlerta('Campo valor não informado! ');
      return false;
    }
    if (this.item == '') {
      msgAlerta('Itens da meta não informados! ');
      return false;
    }
    // if (this.percentual == '') {
    //   msgAlerta('Percentual não informado! ')
    //   return false;
    // }

    return true;
  }

  async buscarValoresMetas() {

    $('#tabelaOpcoesMetas').DataTable().rows().clear().draw(false);
    const response = await requisicao('GET', this.url, `ID=${this.idValor}&TIPO=${this.tipo}`, '', 150000);

    if (!response) {
      return;
    }

    const jsonStr = await response.json();
    if (response.status != 200) {
      msgErro(jsonStr.mensagem);
      return;
    }

    return jsonStr;
  }

  async criaModalOpcoesMetas() {
    this.dadosOpcoesMetas = await this.buscarValoresMetas();
    this.dadosOpcoesMetas.forEach((consulta) => {
      $('#tabelaOpcoesMetas').DataTable().row.add(Object.values(consulta)).draw(false);
    });

    $('#modal-OpcoesMetas').modal('show');
    $("#tabelaOpcoesMetas").DataTable().columns.adjust().draw(false);
  }

  async gravarOpcoes() {
    const response = await requisicao('POST', this.url, ``, JSON.stringify(this));

    if (!response) {
      return;
    }

    if (response.status != 200) {
      const jsonStr = await response.json();
      msgErro(jsonStr.mensagem);
      return;
    }
    this.Metas.carregaValoresMeta();
    criaMensagemSucesso('Valor da meta gravada com sucesso!');
  }

  async deletarOpcoes() {

    const response = await requisicao('DELETE', this.url, `ID_VALOR=${this.idValor}`, '', 15000);

    if (!response) {
      return;
    }

    if (response.status != 200) {
      const jsonStr = await response.json();
      msgErro(jsonStr.mensagem);
      return;
    }
    this.Metas.carregaValoresMeta();
    criaMensagemSucesso('Valor da meta deletado com sucesso!');
  }

  async buscaDiasMeta() {
    const selectDias = {
      tabela: 'METADIAS',
      camposSelect: ["DIA"],
      where: [`ID_VALOR = ${this.idValor} AND ID_META = ${this.id}`]
    };
    const sDados = await retornaJsonPesquisaPadrao(JSON.stringify(selectDias));

    if (sDados.length == 0) {
      msgAlerta('Valor sem dias cadastrados.');
      return;
    }

    let dataSetCols = [];
    const keys = Object.keys(sDados[0]);
    for (var k in keys) {
      dataSetCols.push({
        'data': keys[k]
      });
    };

    criaDataTablePadrao('#tabelaDiasValor', false, false, false, false, true, false, '400px', sDados, dataSetCols, [], [0]);

    $('#modalDiasValor').modal('show');
  }
}
