$(document).ready(async function () {

  await setarDataAtual('txtDataMovimentoSaida');
  await buscaValoresPadroes();

  $('#tabela-movimentados').DataTable({
    paging: false,
    filter: false,
    info: false,
    order: false,
    autoWidth: true,
    destroy: true,
    "language": {
      "sEmptyTable": "Nenhum registro encontrado",
      "sInfo": "_TOTAL_ registros",
      "sInfoEmpty": " 0 registros",
      "sInfoFiltered": "(Filtrados de _MAX_ registros)",
      "sInfoPostFix": "",
      "sInfoThousands": ".",
      "sLengthMenu": "_MENU_ resultados",
      "sLoadingRecords": "Carregando...",
      "sProcessing": "Processando...",
      "sZeroRecords": "Nenhum registro encontrado",
      "sSearch": "Pesquisar",
      "oPaginate": {
        "sNext": "Próximo",
        "sPrevious": "Anterior",
        "sFirst": "Primeiro",
        "sLast": "Último"
      },
      "oAria": {
        "sSortAscending": ": Ordenar colunas de forma ascendente",
        "sSortDescending": ": Ordenar colunas de forma descendente"
      }
    },
    columnDefs: [
      {
        "targets": [4],
        "className": 'pr-4 text-right'
      }
    ]
  });

  // let data = new Date();

  // $('#txtDataMovimentoSaida').val(`${data.getUTCFullYear()}-${String(data.getUTCMonth() + 1).padStart(2, 0)}-${String(data.getUTCDate()).padStart(2, 0)}`);

  $('#txtFuncionarioSaidaMat').autocompleta(1, `JSON={ "tabela":"PESSOAL", "camposSelect":["CODIGO CHAVE, NOME DESCRICAO"], "where": [] }`, [], [], []);
  $('#btnFuncionarioSaidaMat').pesquisa_array(['#txtFuncionarioSaidaMat'], ['CODIGO'], ['NOME'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"PESSOAL", "camposSelect":[ "CODIGO", "NOME" ], "where": ["ATIVO = 'S'"]}`, 'Pesquisa Funcionário', 'PESSOAL');
  $('#btnLimpaFuncionarioSaidaMat').on('click', function () {
    $('#txtFuncionarioSaidaMat').val('');
  });

  $('#txtTipoBaixa').autocompleta(1, `JSON={ "tabela":"tabbai", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`, [], [], []);
  $('#btnTipoBaixa').pesquisa_array(['#txtTipoBaixa'], ['CODIGO'], ['DESCRICAO'], '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABBAI", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'Pesquisa Tipo Baixa', 'TABBAI');
  $('#btnLimpaTipoBaixa').on('click', function () {
    $('#txtTipoBaixa').val('');
  });

  $('#txtQualidade').autocompleta(1, `JSON={ "tabela":"TABQUL", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`, [], [], []);
  $('#btnQualidade').pesquisa_array(['#txtQualidade'], ['CODIGO'], ['DESCRICAO'], '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABQUL", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'Pesquisa Qualidade', 'TABQUL');
  $('#btnLimpaQualidade').on('click', function () {
    $('#txtQualidade').val('');
  });

  $('#txtMaterialSaida').autocompleta(3, 
    `JSON={ 
            "tabela":"MATERIAL", 
            "camposSelect":["MATERIAL.CODIGO CHAVE, MATERIAL.DESCRICAO"], 
            "leftJoin": [{"tabela": "MAT_ITEN", "condicao": "MAT_ITEN.CODIGO = MATERIAL.CODIGO"}],
            "where": ["MAT_ITEN.QTDE > 0"],
            "groupBy": ["MATERIAL.CODIGO", "MATERIAL.DESCRICAO"]
          }`, [], [], []);
  $('#btnMaterialSaida').pesquisa_array(['#txtMaterialSaida'], ['CODIGO'], ['DESCRICAO'], 
    `/sisplan/funcoes/v1/pesquisa?JSON={ 
                                          "tabela":"MATERIAL", 
                                          "camposSelect":["MATERIAL.CODIGO, MATERIAL.DESCRICAO"], 
                                          "leftJoin": [{"tabela": "MAT_ITEN", "condicao": "MAT_ITEN.CODIGO = MATERIAL.CODIGO"}],
                                          "where": ["MAT_ITEN.QTDE > 0"],
                                          "groupBy": ["MATERIAL.CODIGO", "MATERIAL.DESCRICAO"]
                                        }`, 'Pesquisa Material', 'MATERIAL');
  $('#btnLimpaMaterial').on('click', function () {
    $('#txtMaterialSaida').val('');
  });

  $('#txtCor').autocompleta(1, `JSON={ "tabela":"CADCOR", "camposSelect":["COR CHAVE, DESCRICAO"], "where": [] }`, [], [], []);
  $('#btnCor').pesquisa_array(['#txtCor'], ['COR'], ['DESCRICAO'], '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CADCOR", "camposSelect":[ "COR", "DESCRICAO" ],"where": null}', 'Pesquisa Cor', 'CADCOR');
  $('#btnLimpaCor').on('click', function () {
    $('#txtCor').val('');
  });

  $('#txtLote').autocompleta(1, `JSON={ "tabela":"MAT_ITEN", "camposSelect":["LOTE CHAVE, LOTE DESCRICAO"], "where": [] }`, [], [], []);
  $('#btnLote').pesquisa_array(['#txtLote'], ['LOTE'], ['LOTE'], '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"MAT_ITEN", "camposSelect":[ "LOTE" ], "where": null}', 'Pesquisa Lote', 'MAT_ITEN');
  $('#btnLimpaLote').on('click', function () {
    $('#txtLote').val('');
  });

  $('#txtDeposito').autocompleta(1, `JSON={ "tabela":"DEPOSITO", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`, [], [], []);
  $('#btnDeposito').pesquisa_array(['#txtDeposito'], ['CODIGO'], ['DESCRICAO'], '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'Pesquisa Depósito', 'DEPOSITO');
  $('#btnLimpaDeposito').on('click', function () {
    $('#txtDeposito').val('');
  });

  $('#txtMaterialSaida').on('blur', async function () {
    await ajustaPesquisaCor()
  });

  async function gravarMovimentacao(EstProd) {
    try {
      const url = '/sisplan/estoque/v1/movimentaestoquematerial?';
      const sLancto = $('#txtLancamento').val();
      const params = `JSON=${encodeURIComponent(JSON.stringify(EstProd))}&LANCTO=${sLancto}&TIPO=SAIDA`;
      const response = await requisicao('POST', url, '', params);
      const codigo = pegaChave('#txtMaterialSaida');
      const codigoDesc = pegaDescricao('#txtMaterialSaida');
      const cor = pegaChave('#txtCor');
      const corDesc = pegaDescricao('#txtCor');
      const lote = pegaChave('#txtLote');
      const qtde = $('#txtQuantidade').val();
      const unidade = $('#UnidadeMedidaMat').val();

      if (!response) {
        return;
      }

      if (response.status != 200) {
        const jsonStr = response.json();
        msgErro(jsonStr.mensagem);
        return;
      }

      $('#tabela-movimentados').DataTable().row.add([codigo, codigoDesc, cor, corDesc, qtde, unidade, lote]).draw(false);

      toastr.success(
        'Movimentação efetuada com sucesso!',
        'Confirmação', {
        toastClass: 'alert',
        iconClasses: {
          error: 'alert-error',
          info: 'alert-info',
          success: 'alert-success',
          warning: 'alert-warning'
        },
        positionClass: "toast-top-center",
        progressBar: true,
        timeOut: 3000,
        fadeOut: 1000,
        onHidden() {
          LimpaCampos();
          setTimeout(() => { $('#txtMaterialSaida').focus(); }, 200);
        }
      }
      ).css({
        "margin-top": "20%",
        width: "500px",
        "max-width": "500px"
      });

    } catch (error) {
      console.error(error);
    }
  }

  retornaHintRelatorio('Imprimir', 'movimentacao_material')

  $('#Imprimir').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      try {
        if ($('#tabela-movimentados').DataTable().rows().count() != 0) {
          let url = `/sisplan/impressao/v1/movmaterial?`;
          const tipoItem = 'M';
          const docto = $('#txtDocumento').val();
          const tipoMov = 'S';
          const bImprimeAutomatico = await verificaImprimirAutomatico('MovimentacaoMaterial');
          let arquivo = await GeraRelatorio(`${url}NUM_DOCTO=${docto}&TIPOITEM=${tipoItem}&TIPOMOV=${tipoMov}&`, 'GET', 100000, false, 'MovimentacaoMaterial');
          if (arquivo != undefined) {
            if (!bImprimeAutomatico) {
              window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
            }
            await limparRelatorios();
          }
        } else {
          msgAlerta('Não há itens para serem imprimidos!');
        }

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $('#txtMaterialSaida').on('blur', async function () {
    await carregaDadosMaterial();
  });

  $('#txtDeposito').on('blur', async function () {
    await carregaDadosMaterial();
  });

  $('#txtQualidade').on('blur', async function () {
    await carregaDadosMaterial();
  });

  $('#txtLote').on('focusout', async function () {
    await carregaDadosMaterial();
  });

  async function carregaDadosMaterial() {
    try {
      let sWhere = '';
      const codigo = pegaChave('#txtMaterialSaida');
      const cor = pegaChave('#txtCor');
      const deposito = pegaChave('#txtDeposito');
      const qualidade = pegaChave('#txtQualidade');
      const lote = pegaChave('#txtLote');

      if (codigo == '') {
        return;
      }

      sWhere = `MATERIAL.CODIGO = '${codigo}' ${cor != '' ? `AND MAT_ITEN.COR = '${cor}'` : ''} ${deposito != '' ? `AND MAT_ITEN.DEPOSITO = '${deposito}'` : ''} ${qualidade != '' ? `AND MAT_ITEN.QUALIDADE = '${qualidade}'` : ''} ${lote  != '' ? ` AND MAT_ITEN.LOTE = '${lote}'` : ''}`;

      const url = `/sisplan/funcoes/v1/pesquisa?`;
      const params = `JSON={"tabela":"MAT_ITEN", "camposSelect":[ "MATERIAL.CODIGO", "MATERIAL.DESCRICAO","MATERIAL.UNIDADE", "CADCOR.COR", "CADCOR.DESCRICAO AS DESCCOR", "MATERIAL.PRECO", "MAT_ITEN.QTDE", "MAT_ITEN.QUALIDADE", "TABQUL.DESCRICAO DESCQUALIDADE"], "leftjoin": [{ "tabela" : "MATERIAL", "condicao" : "MAT_ITEN.CODIGO = MATERIAL.CODIGO " },{ "tabela" : "CADCOR", "condicao" : "MAT_ITEN.COR = CADCOR.COR " },{ "tabela" : "TABQUL", "condicao" : "MAT_ITEN.QUALIDADE = TABQUL.CODIGO " }],"where": ["${sWhere}"]}`;

      const response = await requisicao('GET', url, params, null);

      if (!response) {
        return;
      }

      const jsonStr = await response.json();
      if (response.status != 200) {
        msgErro(jsonStr.mensagem);
        return;
      }

      $('#UnidadeMedidaMat').val(jsonStr.RESULT[0][0].UNIDADE);
      $('#txtPreco').val(jsonStr.RESULT[0][0].PRECO);
      $('#txtEstoque').val(jsonStr.RESULT[0][0].QTDE);
      insereValor('#txtQualidade', jsonStr.RESULT[0][0].QUALIDADE, jsonStr.RESULT[0][0].DESCQUALIDADE);

    } catch (error) {
      console.error(error);
    }
  }

  $('#txtDocumento').on('blur', async function () {
    try {
      $.LoadingOverlay("show");
      let lancamento;
      if ($(this).val() == '') {
        let docto = await RetornaDoctoELancto('DOCTO', 'MAT_MOV', 'NUM_DOCTO', '6');
        lancamento = await RetornaDoctoELancto('LANCTO', 'MAT_MOV', 'NUM_DOCTO', '6');

        insereValor('#txtDocumento', docto);
        insereValor('#txtLancamento', lancamento);

        $(this).attr('disabled', $(this).val() != '');
      } else {
        lancamento = await RetornaDoctoELancto('LANCTO', 'MAT_MOV', 'NUM_DOCTO', '6');
        insereValor('#txtLancamento', lancamento);
        $(this).attr('disabled', $(this).val() != '');

        const dataSet = await RetornaMovimentados($(this).val());
        $('#tabela-movimentados').DataTable().rows().remove().draw(false);
        for (let i = 0; i < dataSet.length; i++) {
          const item = dataSet[i];
          $('#tabela-movimentados').DataTable().row.add([item.CODIGO, item.DESCRICAO, item.COR, item.DESC_COR, item.QUANTIDADE, item.UNIDADE, item.LOTE]).draw(false);
        }
      }

    } finally {
      $.LoadingOverlay("hide");
    }
  });


  function montaObjetoMovimentacao() {
    const objetoMovimentacao = {
      NUM_DOCTO: $('#txtDocumento').val(),
      DT_MOVTO: $('#txtDataMovimentoSaida').val(),
      CODCRE: pegaChave('#txtFuncionarioSaidaMat'),
      TP_MOV: pegaChave('#txtTipoBaixa'),
      CODIGO: pegaChave('#txtMaterialSaida'),
      QUALIDADE: pegaChave('#txtQualidade'),
      COR: pegaChave('#txtCor'),
      LOTE: pegaChave('#txtLote'),
      DEPOSITO: pegaChave('#txtDeposito'),
      QTDE: parseFloat($('#txtQuantidade').val()),
      PRECO: parseFloat($('#txtPreco').val()),
      TIPO: 'MN',
      CODBAIXA: pegaChave('#txtTipoBaixa')
    };

    return objetoMovimentacao;
  }

  $('#limpar_mov').on('click', function () {
    LimpaCampos();
    limpaValor('#txtDocumento');
    limpaValor('#txtLancamento');
    $('#txtDocumento').attr('disabled', false);
    $('#tabela-movimentados').DataTable().rows().remove().draw(false);
    $('#txtDocumento').focus();
  });

  $('#msform').validate({
    ignore: "",
    rules: {
      txtDocumento: {
        required: true,
      },
      txtFuncionarioSaidaMat: {
        required: true,
      },
      txtTipoBaixa: {
        required: true,
      },
      txtQualidade: {
        required: true,
      },
      txtMaterialSaida: {
        required: true,
      },
      txtCor: {
        required: true,
      },
      txtLote: {
        required: true,
      },
      txtDeposito: {
        required: true,
      },
      txtQuantidade: {
        required: true,
      },
      txtPreco: {
        required: true,
      }
    },
    messages: {
      txtDocumento: {
        required: "Gere um documento para continuar."
      },
      txtFuncionarioSaidaMat: {
        required: "Informe um funcionário para continuar."
      },
      txtTipoBaixa: {
        required: "Informe um tipo de baixa para continuar."
      },
      txtQualidade: {
        required: "Informe uma qualidade para continuar."
      },
      txtMaterialSaida: {
        required: "Informe um material para continuar."
      },
      txtCor: {
        required: "Informe uma cor para continuar."
      },
      txtLote: {
        required: "Informe um lote para continuar."
      },
      txtDeposito: {
        required: "Informe um deposito para continuar."
      },
      txtQuantidade: {
        required: "Informe uma quantidade válida para continuar."
      },
      txtPreco: {
        required: "Informe um preço válido para continuar."
      }
    },
    errorElement: 'span',
    errorPlacement(error, element) {
      error.addClass('invalid-feedback');
      element.closest('.form-group').append(error);
    },
    highlight(element) {
      $(element).addClass('is-invalid');
    },
    unhighlight(element) {
      $(element).removeClass('is-invalid');
    }
  });

  $('#confirmar_mov').on('click', async function () {
    try {
      $('#confirmar_mov').prop('disabled', true);
      $.LoadingOverlay('show');
      try {
        let validator = $("#msform").validate();
        validator.form();
        let erros = 0;
        erros = validator.numberOfInvalids();

        if (erros == 0) {
          if (parseFloat($('#txtQuantidade').val()) <= 0) {
            msgErro('Não há quantidade para o material informado, verifique.');
            return;
          }
          if (parseFloat($('#txtQuantidade').val()) > (parseFloat($('#txtEstoque').val()))) {
            msgErro('Quantidade maior que o estoque, verifique.');
            return;
          }

          const objetoMovimentacao = montaObjetoMovimentacao();
          await gravarMovimentacao(objetoMovimentacao);
        }
      } catch (error) {
        console.error(error);
      }

    } finally {
      $('#confirmar_mov').prop('disabled', false);
      $.LoadingOverlay('hide');
    }
  });

  async function RetornaMovimentados(sDocto) {
    try {
      const url = `/sisplan/funcoes/v1/pesquisa?`;
      const params = `JSON={"tabela": "MAT_MOV", "camposSelect": ["MAT_MOV.CODIGO", "MATERIAL.DESCRICAO", "MAT_MOV.COR", "CADCOR.DESCRICAO DESC_COR", "SUM(MAT_MOV.QTDE) QUANTIDADE", "MATERIAL.UNIDADE", "MAT_MOV.LOTE"],"leftjoin": [{ "tabela" : "MATERIAL", "condicao" : "MAT_MOV.CODIGO = MATERIAL.CODIGO" }, { "tabela" : "CADCOR", "condicao" : "CADCOR.COR = MAT_MOV.COR" }],"groupby": ["MAT_MOV.CODIGO", "MATERIAL.DESCRICAO", "MAT_MOV.COR", "CADCOR.DESCRICAO", "MATERIAL.UNIDADE", "MAT_MOV.LOTE"],"where": ["MAT_MOV.NUM_DOCTO = '${sDocto}' AND MAT_MOV.OPERACAO = 'S' "], "orderby": ["MAT_MOV.CODIGO", "MAT_MOV.COR"]}`;
      const response = await requisicao('GET', url, params, null);

      if (!response) {
        return '';
      }

      const jsonStr = await response.json();
      if (response.status != 200) {
        msgErro(jsonStr.mensagem);
        return;
      }

      return jsonStr.RESULT[0];

    } catch (error) {
      console.error(error);
    }
  }

  async function buscaValoresPadroes() {
    $.LoadingOverlay('show');
    try {

      const classValores = { POSICAO: '9' };
      const response = await requisicao('POST', '/sisplan/valorespadroes/v1/buscar?', '', JSON.stringify(classValores), null);

      if (!response) {
        return;
      }

      const jsonStr = await response.json();

      insereValor('#txtTipoBaixa', jsonStr.tipoSaida);
      insereValor('#txtQualidade', jsonStr.qualidade);
      insereValor('#txtDeposito', jsonStr.deposito);
    } catch (error) {
      console.error(error);
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  function LimpaCampos() {
    limpaValor('#txtTipoBaixa');
    limpaValor('#txtQualidade');
    limpaValor('#txtLote');
    limpaValor('#txtEstoque');
    limpaValor('#UnidadeMedidaMat');
    limpaValor('#txtDeposito');
    limpaValor('#txtMaterialSaida');
    limpaValor('#txtCor');
    limpaValor('#txtPreco');
  }

  $('#cbSomenteComEstoque').on('change', async function () {
    if ($(this).is(':checked')){
      $('#txtMaterialSaida').autocompleta(3, 
        `JSON={ 
                "tabela":"MATERIAL", 
                "camposSelect":["MATERIAL.CODIGO CHAVE, MATERIAL.DESCRICAO"], 
                "leftJoin": [{"tabela": "MAT_ITEN", "condicao": "MAT_ITEN.CODIGO = MATERIAL.CODIGO"}],
                "where": ["MAT_ITEN.QTDE > 0"],
                "groupBy": ["MATERIAL.CODIGO", "MATERIAL.DESCRICAO"]
              }`, [], [], []);
      $('#btnMaterialSaida').pesquisa_array(['#txtMaterialSaida'], ['CODIGO'], ['DESCRICAO'], 
        `/sisplan/funcoes/v1/pesquisa?JSON={ 
                                              "tabela":"MATERIAL", 
                                              "camposSelect":["MATERIAL.CODIGO, MATERIAL.DESCRICAO"], 
                                              "leftJoin": [{"tabela": "MAT_ITEN", "condicao": "MAT_ITEN.CODIGO = MATERIAL.CODIGO"}],
                                              "where": ["MAT_ITEN.QTDE > 0"],
                                              "groupBy": ["MATERIAL.CODIGO", "MATERIAL.DESCRICAO"]
                                            }`, 'Pesquisa Material', 'MATERIAL');
    } else {
      $('#txtMaterialSaida').autocompleta(3, `JSON={ "tabela":"MATERIAL", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`, [], [], []);
      $('#btnMaterialSaida').pesquisa_array(['#txtMaterialSaida'], ['CODIGO'], ['DESCRICAO'], '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"MATERIAL", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'Pesquisa Material', 'MATERIAL');
    }

    await ajustaPesquisaCor()
  })

  async function ajustaPesquisaCor(){
    if ($('#cbSomenteComEstoque').is(':checked')){
      $('#txtCor').unbind('autocompleta');
      $('#txtCor').autocompleta(1, 
        `JSON={ "tabela":"MAT_ITEN", 
                "camposSelect":["MAT_ITEN.COR CHAVE, CADCOR.DESCRICAO"], 
                "leftjoin": [{ "tabela" : "CADCOR", "condicao" : "MAT_ITEN.COR = CADCOR.COR" }], 
                "groupBy": ["MAT_ITEN.COR", "CADCOR.DESCRICAO"], 
                "where": ["MAT_ITEN.CODIGO = '${pegaChave('#txtMaterialSaida')}' AND MAT_ITEN.QTDE > 0"] 
              }`, [], [], []);
      $('#btnCor').off();
      $('#btnCor').unbind('pesquisa_array');
      $('#btnCor').pesquisa_array(['#txtCor'], ['COR'], ['DESCRICAO'], 
        `/sisplan/funcoes/v1/pesquisa?JSON={  "tabela":"MAT_ITEN", 
                                              "camposSelect":[ "MAT_ITEN.COR", "CADCOR.DESCRICAO" ],
                                              "leftjoin": [{ "tabela" : "CADCOR", "condicao" : "MAT_ITEN.COR = CADCOR.COR" }],
                                              "groupBy": ["MAT_ITEN.COR", "CADCOR.DESCRICAO"], 
                                              "where": ["MAT_ITEN.CODIGO = '${pegaChave('#txtMaterialSaida')}' AND MAT_ITEN.QTDE > 0 "]
                                            }`, 'Pesquisa Cor', 'CADCOR');
  
      $('#txtCor').on('blur', function () {
        const codigoMaterial = pegaChave('#txtMaterialSaida');
        const codigoCor = pegaChave('#txtCor');

        $('#txtLote').autocompleta(1, 
          `JSON={ "tabela":"MAT_ITEN", 
                  "camposSelect":["LOTE CHAVE", "LOTE DESCRICAO"],  
                  "where": ["MAT_ITEN.CODIGO = '${codigoMaterial}' AND MAT_ITEN.COR = '${codigoCor}' AND MAT_ITEN.QTDE > 0 "] 
                }`, [], [], []);
        $('#btnLote').off();
        $('#btnLote').unbind('pesquisa_array');
        $('#btnLote').pesquisa_array(['#txtLote'], ['LOTE'], ['LOTE'], 
          `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"MAT_ITEN", 
                                                "camposSelect":[ "MAT_ITEN.LOTE" ], 
                                                "where": ["MAT_ITEN.CODIGO = '${codigoMaterial}' AND MAT_ITEN.COR = '${codigoCor}' AND MAT_ITEN.QTDE > 0"]
                                              }`, 'Pesquisa Lote', 'MAT_ITEN');
      });


    } else {
      // $('#txtCor').off();
      $('#txtCor').unbind('autocompleta');
      $('#txtCor').autocompleta(1, 
        `JSON={ "tabela":"MAT_ITEN", 
                "camposSelect":["MAT_ITEN.COR CHAVE, CADCOR.DESCRICAO"], 
                "leftjoin": [{ "tabela" : "CADCOR", "condicao" : "MAT_ITEN.COR = CADCOR.COR" }], 
                "groupBy": ["MAT_ITEN.COR", "CADCOR.DESCRICAO"], 
                "where": ["MAT_ITEN.CODIGO = '${pegaChave('#txtMaterialSaida')}'"] 
              }`, [], [], []);
      $('#btnCor').off();
      $('#btnCor').unbind('pesquisa_array');
      $('#btnCor').pesquisa_array(['#txtCor'], ['COR'], ['DESCRICAO'], 
        `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"MAT_ITEN", 
                                              "camposSelect":[ "MAT_ITEN.COR", "CADCOR.DESCRICAO" ],
                                              "leftjoin": [{ "tabela" : "CADCOR", "condicao" : "MAT_ITEN.COR = CADCOR.COR" }], 
                                              "groupBy": ["MAT_ITEN.COR", "CADCOR.DESCRICAO"], 
                                              "where": ["MAT_ITEN.CODIGO = '${pegaChave('#txtMaterialSaida')}'"]
                                            }`, 'Pesquisa Cor', 'CADCOR');
  
      $('#txtCor').on('blur', function () {
        const codigoMaterial = pegaChave('#txtMaterialSaida');
        const codigoCor = pegaChave('#txtCor');
  
        $('#txtLote').autocompleta(1, `JSON={ "tabela":"MAT_ITEN", "camposSelect":["LOTE CHAVE", "LOTE DESCRICAO"], "where": ["MAT_ITEN.CODIGO = '${codigoMaterial}' AND MAT_ITEN.COR = '${codigoCor}'"] }`, [], [], []);
        $('#btnLote').off();
        $('#btnLote').unbind('pesquisa_array');
        $('#btnLote').pesquisa_array(['#txtLote'], ['LOTE'], ['LOTE'], 
          `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"MAT_ITEN", 
                                                "camposSelect":[ "MAT_ITEN.LOTE" ], 
                                                "where": ["MAT_ITEN.CODIGO = '${codigoMaterial}' AND MAT_ITEN.COR = '${codigoCor}'"]
                                              }`, 'Pesquisa Lote', 'MAT_ITEN');
      });
    }
  }

  const driver = new Driver({
    doneBtnText: 'Sair',
    closeBtnText: 'Fechar',
    nextBtnText: 'Próximo',
    prevBtnText: 'Anterior',
    allowClose: false,
    animate: true,
  });

  driver.defineSteps([{
    element: '#campostour',
    popover: {
      title: 'Dados Gerais',
      description: 'Aqui estão os campos disponíveis para realizar a movimentação.',
      position: 'top'
    }
  },
  {
    element: '#txtDocumento',
    popover: {
      title: 'Campos Obrigatórios',
      description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
      position: 'top'
    }
  },
  {
    element: '#txtDataMovimentoSaida',
    popover: {
      title: 'Campos Obrigatórios',
      description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
      position: 'top'
    }
  },
  {
    element: '#txtFuncionarioSaidaMat',
    popover: {
      title: 'Campos Obrigatórios',
      description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
      position: 'top'
    }
  },
  {
    element: '#txtTipoBaixa',
    popover: {
      title: 'Campos Obrigatórios',
      description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
      position: 'top'
    }
  },
  {
    element: '#txtQualidade',
    popover: {
      title: 'Campos Obrigatórios',
      description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
      position: 'top'
    }
  },
  {
    element: '#txtMaterialSaida',
    popover: {
      title: 'Campos Obrigatórios',
      description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
      position: 'top'
    }
  },
  {
    element: '#txtCor',
    popover: {
      title: 'Campos Obrigatórios',
      description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
      position: 'top'
    }
  },
  {
    element: '#txtLote',
    popover: {
      title: 'Campos Obrigatórios',
      description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
      position: 'top'
    }
  },
  {
    element: '#txtDeposito',
    popover: {
      title: 'Campos Obrigatórios',
      description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
      position: 'top'
    }
  },
  {
    element: '#txtQuantidade',
    popover: {
      title: 'Campos Obrigatórios',
      description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
      position: 'top'
    }
  },
  {
    element: '#txtPreco',
    popover: {
      title: 'Campos Obrigatórios',
      description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
      position: 'top'
    }
  },
  {
    element: '#limpar_mov',
    popover: {
      title: 'Botão Limpar',
      description: 'Clique aqui para limpar os campos.',
      position: 'left'
    }
  },
  {
    element: '#confirmar_mov',
    popover: {
      title: 'Botão Gravar',
      description: 'Clique aqui para gravar a movimentação.',
      position: 'top'
    }
  }
  ]);

  $('#tutorial').on('click', function () {
    driver.start();
  });
});
