$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
    });
    driver.defineSteps([{
      element: '#tabEnvioReceber',
      popover: {
        title: 'Aba de Envio do Receber',
        description: 'Aba para fazer a consulta dos títulos do Receber que foram integrados ou ficaram pendentes no envio para a Senior.',
        position: 'bottom'
      }
    },
    {
      element: '#tabConsultaReceber',
      popover: {
        title: 'Aba de Consulta do Receber',
        description: 'Aba para fazer a consulta dos títulos do Receber que foram integrados ou ficaram pendentes na consulta da Senior.',
        position: 'bottom'
      }
    },
    {
      element: '#tabEnvioPagar',
      popover: {
        title: 'Aba de Envio do Pagar',
        description: 'Aba para fazer a consulta dos títulos do Pagar que foram integrados ou ficaram pendentes no envio para a Senior.',
        position: 'bottom'
      }
    },
    {
      element: '#tabConsultaPagar',
      popover: {
        title: 'Aba de Consulta do Pagar',
        description: 'Aba para fazer a consulta dos títulos do Pagar que foram integrados ou ficaram pendentes na consulta da Senior.',
        position: 'bottom'
      }
    },
    {
      element: '#tabNotaFiscalEntrada',
      popover: {
        title: 'Aba de Nota Fiscal de Entrada',
        description: 'Aba para fazer a consulta das Notas de Entrada que foram integradas ou ficaram pendentes no envio para a Senior.',
        position: 'bottom'
      }
    },
    {
      element: '#tabNotaFiscalSaida',
      popover: {
        title: 'Aba de Nota Fiscal de Saída',
        description: 'Aba para fazer a consulta das Notas de Saída que foram integradas ou ficaram pendentes no envio para a Senior.',
        position: 'bottom'
      }
    },
    {
      element: '#tabNFCE',
      popover: {
        title: 'Aba de NFCE',
        description: 'Aba para fazer a consulta dos NFC-e que foram integrados ou ficaram pendentes no envio para a Senior.',
        position: 'bottom'
      }
    }
    ]);
    driver.start();
  });
});

$(document).ready(async function () {
    
  // EVENTOS DE ELEMENTOS

  $("#divTabs").on("click",  ".abaLink", function () {
    const tabClicada = $(this).attr("id");
    ativaDesativaTabs(tabClicada);    
  })

  $('.card').each(function () {
    $(this).prepend(adicionaBotaoFiltros()); // Adiciona os botões de rádio ao início de cada card
  });

  $(".btnFiltros").on("click", function () {
    $("#modalFiltros").modal("show");
  })

  $("#btnConsultar").on("click", async function () {
    $.LoadingOverlay('show');
    try {
      const registrosPendentes = await consultaRegistrosPendentes();
      preencheTabela(registrosPendentes);
    } finally {
      $.LoadingOverlay('hide');
      $("#modalFiltros").modal("hide");
    }
  })

  // FUNÇÕES

  function ativaDesativaTabs(tabAtivada) {
    const listaTabs = $("#divTabs .abaLink").toArray();

    listaTabs.forEach(elemento => {
      const idDiv = $(elemento).attr("card");
      if (elemento.id != tabAtivada) {        
        $(`#${idDiv}`).addClass("d-none");
      } else {
        $(`#${idDiv}`).removeClass("d-none");
      }
    })

  }

  function retornaParams() {
    let tabela = "";
    let requisicao = "";
    let status = $('.divStatus input[name="status"]:checked').val();
    const idTabAtiva = $("#divTabs .active")[0].id;

    switch (idTabAtiva) {
      case "tabEnvioReceber":
        tabela = `'RECEBER'`;
        requisicao = `'GravarTitulosCR_2','EntradaTitulosLoteCR'`;
        break;
      case "tabConsultaReceber":
        tabela = "'RECEBER','RECEBERB'";
        requisicao = "'RotinaConsultarReceberSenior'";
        status = status == "INTEGRADO" ? "INSERIDO" : status == "ENVIO_PENDENTE" ? "INSERCAO_PENDENTE" : "" ;
        break;
      case "tabEnvioPagar":
        tabela = "'PAGAR'";
        requisicao = "'GravarTitulosCP_4'";
        break;
      case "tabConsultaPagar":
        tabela = "'PAGAR','PAGARB'";
        requisicao = "'RotinaConsultarPagarSenior'";
        status = status == "INTEGRADO" ? "INSERIDO" : status == "ENVIO_PENDENTE" ? "INSERCAO_PENDENTE" : "" ;
        break;
      case "tabNotaFiscalEntrada":
        tabela = "'ENTRADA_NF'";
        requisicao = "'GravarNotasFiscaisEntrada_22'";
        break;
      case "tabNotaFiscalSaida":
        tabela = "'NFE','CANCELAMENTO_NFE'";
        requisicao = "'ImportarNotaAutorizada_17','GravarNotasFiscaisSaida_16'";
        break;
      case "tabNFCE":
        tabela = "'NFCE','CANCELAMENTO_NFCE'";
        requisicao = "'ImportarNfce_7','GravarNotasFiscaisSaida_16'";
        break;
      default:
        break;
    }
    return `TABELA=${tabela}`+
           `&REQUISICAO=${requisicao}`+
           `&STATUS=${status}`;
  }

  async function consultaRegistrosPendentes() {
    const params = retornaParams();

    try {
      
      const response = await requisicao("GET", "/sisplan/senior/v1/registrospendentes?", params, "", 120000);

      if (!response) {
        throw new Error("Não foi possível consultar os registros pendentes");
      }
  
      const json = await response.json();
      if (response.status != 200) {
        throw new Error(json.mensagem);
      }

      return json;

    } catch (error) {
      console.log("Ocorreu erro na rotina consultaRegistrosPendentes: "+error.message);
      msgAlerta(error.message);
      return [];
    }

  }

  function adicionaBotaoFiltros() {
    return `<div class="col-sm-12 mt-3 ml-2 ">
                <button class="btn btn-success btn-sisp btnFiltros" type="button"><span class="fas fa-filter"></span>Filtros</button>
              </div>`;
  }

  function preencheTabela(registros) {

    if (registros.length == 0) {
      return;
    }

    const idTabela = retornaIDTabela();
    const dataSetCols = [];
    const keys = Object.keys(registros[0]);

    if ($.fn.DataTable.isDataTable(`#${idTabela}`)) {
      $(`#${idTabela}`).DataTable().destroy();
      $(`#${idTabela}`).empty();
    };
    
    // dataSetCols.push({
    //   'title': 'SEL',
    //   'data': 'SEL',
    //   'width': '15px'
    // });

    // insereCampoSel(dataSetCols[0], idTabela);

    for (var k in keys) {
      dataSetCols.push({
        'title': keys[k],
        'data': keys[k]
      });
    }

    $(`#${idTabela}`).DataTable({
      paging: true,
      filter: true,
      info: true,
      order: false,
      destroy: true,
      colReorder: true,
      "language": {
        "sEmptyTable": "Nenhum registro encontrado",
        "sInfo": "_TOTAL_ registros",
        "sInfoEmpty": " 0 registros",
        "sInfoFiltered": "(Filtrados de _MAX_ registros)",
        "sInfoPostFix": "",
        "sInfoThousands": ".",
        "sLengthMenu": "_MENU_ resultados",
        "sLoadingRecords": "Carregando...",
        "sProcessing": "Processando...",
        "sZeroRecords": "Nenhum registro encontrado",
        "sSearch": "Pesquisar (geral): ",
        "oPaginate": {
          "sNext": "Próximo",
          "sPrevious": "Anterior",
          "sFirst": "Primeiro",
          "sLast": "Último"
        },
        "oAria": {
          "sSortAscending": ": Ordenar colunas de forma ascendente",
          "sSortDescending": ": Ordenar colunas de forma descendente"
        }
      },
      "data": registros,
      "columns": dataSetCols
    });

    // criaDataTablePadrao(`#${idTabela}`,
    //                     true,
    //                     false,
    //                     false,
    //                     false,
    //                     true,
    //                     false,
    //                     false,
    //                     registros,
    //                     dataSetCols);
    
  }

  // function retornaIDTabela() {
  //   const tabAtiva = $("#divTabs .active");
  //   const idDiv = tabAtiva.attr("href");
  //   const idTabela = $(`${idDiv} table`)[0].id;
  //   return idTabela;
  // }

  function retornaIDTabela() {
    const idTabAtiva = $("#divTabs .active")[0].id;
    let dataTable = "";
      
      switch (idTabAtiva) {
        case "tabEnvioReceber":
          dataTable = "tabelaEnvioReceber";
          break;
        case "tabNotaFiscalSaida":
          dataTable = "tabelaNotaFiscalSaida";
          break;
        case "tabNFCE":
          dataTable = "tabelaNFCE";
          break;
        default:
          break;
      }

      return dataTable;
    }

  function insereCampoSel(posicao, tipo) {
    posicao.render = function (data, type, row, meta) {
      return `<div class="icheck-primary d-inline">
                    <input type="checkbox" id="check_col_${meta.row}_row_${meta.col}" class="campoSel${tipo}">
                    <label for="check_col_${meta.row}_row_${meta.col}"></label>
                </div>`
    }
  }

  function insereCampoSel(posicao, idTabela) {
    posicao.render = function (data, type, row, meta) {
      return `<div class="icheck-primary d-inline">
                    <input type="checkbox" id="check_col_${meta.row}_row_${meta.col}" class="campoSel${idTabela}">
                    <label for="check_col_${meta.row}_row_${meta.col}"></label>
                </div>`
    }
  }

  //  function createRadioButtons() {
  //   return `
  //   <div class="col-sm-3 mt-3 ml-2 teste1">
  //     <fieldset class="form border-Field p-0 d-block d-md-flex">
  //         <legend class="textoBorda pb-0 mb-0">Status</legend>
  //         <div class="icheck-primary mr-2">
  //             <input type="radio" class="radioTodos" name="radioStatus" value="0" checked />
  //             <label for="radioTodos">Todos</label>
  //         </div>
  //         <div class="icheck-primary">
  //             <input type="radio" class="radioIntegrado" name="radioStatus" value="1" />
  //             <label for="radioIntegrado">Integrado</label>
  //         </div>
  //         <div class="icheck-primary ml-2">
  //             <input type="radio" class="radioNaoIntegrado" name="radioStatus" value="2" />
  //             <label for="radioNaoIntegrado">Não Integrado</label>
  //         </div>
  //     </fieldset>
  //   </div>
  //   `;
  // }

  


})