$(document).ready(async function () {

  let colunas = JSON.parse(localStorage.getItem("colunasInvisiveisRelatorios"));

  let controleColunas = 1;

  if (colunas == null || colunas.fechamentoRepComissaoRec == undefined) {
    localStorage.setItem(
      "colunasInvisiveisRelatorios",
      JSON.stringify({ ...colunas, fechamentoRepComissaoRec: [] })
    );
    colunas = JSON.parse(localStorage.getItem("colunasInvisiveisRelatorios"));
  }

  if (colunas == null || colunas.fechamentoRepComissaoRes == undefined) {
    localStorage.setItem(
      "colunasInvisiveisRelatorios",
      JSON.stringify({ ...colunas, fechamentoRepComissaoRes: [] })
    );
    colunas = JSON.parse(localStorage.getItem("colunasInvisiveisRelatorios"));
  }

  $("#btnConfirmarColunas").on("click", async function () {
    try {
      $.LoadingOverlay("show");

      const novasColunas = retornaNovasColunasInvisiveis();
      let cols = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

      if (controleColunas == 1) {
        localStorage.setItem(
          "colunasInvisiveisRelatorios",
          JSON.stringify({ ...cols, fechamentoRepComissaoRec: novasColunas })
        );
        $("#tabelaReceber").DataTable().columns().visible(true);
        $("#tabelaReceber")
          .DataTable()
          .columns()
          .every(function () {
            if (novasColunas.indexOf(this.dataSrc()) != -1) {
              this.visible(false);
            }
          });
      } else {
        localStorage.setItem(
          "colunasInvisiveisRelatorios",
          JSON.stringify({ ...cols, fechamentoRepComissaoRes: novasColunas })
        );
        $("#tabelaResumo").DataTable().columns().visible(true);
        $("#tabelaResumo")
          .DataTable()
          .columns()
          .every(function () {
            if (novasColunas.indexOf(this.dataSrc()) != -1) {
              this.visible(false);
            }
          });
      }
    } finally {
      $.LoadingOverlay("hide");
      $("#modal-ColunasVisiveis").modal("hide");
    }
  });

  // $('#selectOpcaoRelatorio').on('change', function () {
  //   retornaHintRelatorio('btnImprimir', $('#selectOpcaoRelatorio option')
  //     .toArray()
  //     .map(map => { return [map.selected, $(map).attr('nome_prt')] })
  //     .filter(filter => filter[0] == true)[0][1])
  // })

  let contaFs = 1;

  $('.next').click(function () {
    contaFs += 1;

    let validator = $("#msform").validate();
    validator.form();
    let erros = 0;
    erros = validator.numberOfInvalids();

    if (erros == 0) {
      currentFs = $(this).parent().parent();
      nextFs = $(this).parent().parent().next();

      $("#progressbar li").eq($(".abas").index(nextFs)).addClass("active");

      nextFs.show();
      currentFs.animate(
        {
          opacity: 0,
        },
        {
          step(now) {
            opacity = 1 - now;

            currentFs.css({
              display: "none",
              position: "relative",
            });
            nextFs.css({
              opacity,
            });
          },
          duration: 600,
        }
      );
    }
  });

  $('.previous').click(function () {
    contaFs -= 1;

    currentFs = $(this).parent().parent().parent().parent();
    previousFs = $(this).parent().parent().parent().parent().prev();
    $("#progressbar li")
      .eq($(".abas").index(currentFs))
      .removeClass("active");
    previousFs.show();
    currentFs.animate(
      {
        opacity: 0,
      },
      {
        step(now) {
          opacity = 1 - now;
          currentFs.css({
            display: "none",
            position: "relative",
          });
          previousFs.css({
            opacity,
          });
        },
        duration: 600,
      }
    );
  });

  $('#account').on('click', function () {
    if (contaFs == 2) {
      $('.previous').trigger('click');
    }
  });

  $('#confirm').on('click', function () {
    if (contaFs == 1) {
      $('.next').trigger('click');
    }
  });

  // fechamento
  componenteFiltro('representante', true, true);
  componenteFiltro('cliente', true, true, 'Entidade');
  componenteFiltro('ramoAtividade', true, true, 'TipoRepresentante');
  componenteFiltro('regEstado', true, true, 'RegiaoRepresentante');
  componenteFiltro('pedido', true, true);
  componenteFiltro('tipo', true, true, 'TipoPedido');
  componenteFiltro('colecao', true, true, 'ColecaoPedido');
  componenteFiltro('conta', true, true);
  componenteFiltro('classe', true, true);
  componenteFiltro('duplicata', true, true);
  componenteFiltro('moeda', true, true);
  componenteFiltro('grupoCli', true, true, 'GrupoCliente');
  componenteFiltro('cliente', true, true);
  //desconto
  componenteFiltro('cliente', true, true, 'ClienteDesconto');
  componenteFiltro('representante', true, true, 'RepresentanteDesconto');
  componenteFiltro('entidade', true, true, 'CoordenadorDesconto');
  componenteFiltro('duplicata', true, true, 'DuplicataDesconto');

  preencheOrdenacaoTela('FechamentoRepComissao', 'selectOpcaoRelatorio');
  // retornaHintRelatorio('btnImprimir', 'DesempenhoProdResumido')

  $('#btnConsultar').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      await BuscaDados();
    } catch (e) {
      console.log(e);
      msgErro(`Não foi possível buscar os dados: ${e}`);
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $('#btnSelecionarEmpresas').on('click', function () {
    carregaEmpresasDisponiveis();
  });

  async function RetornaFiltros() {
    return {
      vencimento_de: $('#dtVencimentoDe').val() != '' ? $('#dtVencimentoDe').val() : '1200-01-01',
      vencimento_ate: $('#dtVencimentoAte').val() != '' ? $('#dtVencimentoAte').val() : '2500-12-31',
      pagamento_de: $('#dtPagamentoDe').val() != '' ? $('#dtPagamentoDe').val() : '1200-01-01',
      pagamento_ate: $('#dtPagamentoAte').val() != '' ? $('#dtPagamentoAte').val() : '2500-12-31',
      emissao_de: $('#dtEmissaoDe').val() != '' ? $('#dtEmissaoDe').val() : '1200-01-01',
      emissao_ate: $('#dtEmissaoAte').val() != '' ? $('#dtEmissaoAte').val() : '2500-12-31',
      fatura_de: $('#txtFaturaDe').val(),
      fatura_ate: $('#txtFaturaAte').val(),
      filtro: $('#selectFiltro').val(),
      status_representante: $('#selectStatusRepresentante').val(),
      representante: await formataListas($('#txtRepresentante').val().toString()),
      entidade_representante: await formataListas($('#txtEntidade').val().toString()),
      tipo_representante: await formataListas($('#txtTipoRepresentante').val().toString()),
      regiao_representante: await formataListas($('#txtRegiaoRepresentante').val().toString()),
      pedido: await formataListas($('#txtPedido').val().toString()),
      tipo_pedido: await formataListas($('#txtTipoPedido').val().toString()),
      colecao_pedido: await formataListas($('#txtColecaoPedido').val().toString()),
      conta: await formataListas($('#txtConta').val().toString()),
      historico: $('#txtHistorico').val(),
      classe_gerencial: await formataListas($('#txtClasse').val().toString()),
      duplicata: await formataListas($('#txtDuplicata').val().toString()),
      moeda: await formataListas($('#txtMoeda').val().toString()),
      grupo_cliente: await formataListas($('#txtGrupoCliente').val().toString()),
      cliente: await formataListas($('#txtCliente').val().toString()),
      estado: $('#selectEstado').val(),
      comissao_zerada_fat: $('#cbComZeradaFat').prop('checked'),
      comissao_zerada_rec: $('#cbComZeradaRec').prop('checked'),
      comissao_antecipada: $('#cbComAntecipada').prop('checked'),
      antecipar_titulos_pagos: $('#cbAnteciparTitulos').prop('checked'),
      faturamento: $('#cbFaturamento').prop('checked'),
      recebimento: $('#cbRecebimento').prop('checked'),
      manual: $('#cbManual').prop('checked'),
      devolucao: $('#cbDevolucao').prop('checked'),
      estorno: $('#cbEstorno').prop('checked'),
      considerar_ir: $('#cbConsiderarIR').prop('checked'),
      considerar_iss: $('#cbConsiderarISS').prop('checked'),
      todas_empresas: $('.empresa_selecionada:checked').toArray().length > 1 ? true : false,
      empresas: $('.empresa_selecionada:checked').toArray().length > 0 ? $('.empresa_selecionada:checked').toArray().map(input => input.id.substring(input.id.indexOf('-') + 1, input.id.length)).toString()
        : getCookie('emp_id'),
      ordem: $('#selectOpcaoRelatorio').val(),
      desconsiderar_saldo: $('#cbDesconsiderarSaldo').prop('checked'),
      desconsiderar_fechamento: $('#cbDesconsiderarFechamento').prop('checked')
    }
  }

  async function BuscaDados() {
    const filtros = await RetornaFiltros();

    const url = `/sisplan/fechamentorepcomissao/v1/buscadados?`;
    const ordem = `&TELA_ORDENACAO=FechamentoRepComissao&ORDEM_ORDENACAO=${$('#selectOpcaoRelatorio').val()}`;
    const response = await requisicao("GET", url, `&FILTROS=${encodeURIComponent(JSON.stringify(filtros))}${ordem}&COD_USUARIO=${getCookie('cod_usuario')}`, '', 1800000);

    if (!response) {
      return;
    }

    const data = await response.json();

    if (!data.COMISSAO_VALIDADA) {
      CarregaModalDuplicatas(data.DUPLICATAS);
      $('#modal-duplicatas').modal('show');
      msgErro('Duplicatas com problemas no lançamento de comissão. Fechamento de comissão não resultará informações.');
    } else {
      CriaTabelaReceber(data.DUPLICATAS);
      CriaTabelaResumo(data.RESUMO);
    }
  }

  function CarregaModalDuplicatas(info) {
    if ($.fn.DataTable.isDataTable('#tabelaDuplicatas')) {
      $('#tabelaDuplicatas').DataTable().destroy();
      $('#tabelaDuplicatas').empty();
    }

    const cols = [{
      data: 'TIPO',
      title: 'Tipo'
    },
    {
      data: 'NUMERO',
      title: 'Número'
    },
    {
      data: 'CODREP',
      title: 'Codrep'
    },
    {
      data: 'DT_EMISSAO',
      title: 'Emissão'
    },
    {
      data: 'DT_VENCTO',
      title: 'Vencimento'
    },
    {
      data: 'DT_PAGTO',
      title: 'Pagamento'
    }];

    $("#tabelaDuplicatas").DataTable({
      sort: true,
      paging: true,
      destroy: true,
      colReorder: true,
      searching: false,
      lengthChange: false,
      language: {
        sEmptyTable: "Nenhum registro encontrado",
        sInfo: "_TOTAL_ registros",
        sInfoEmpty: " 0 registros",
        sInfoFiltered: "(Filtrados de _MAX_ registros)",
        sInfoPostFix: "",
        sInfoThousands: ".",
        sLengthMenu: "_MENU_ resultados",
        sLoadingRecords: "Carregando...",
        sProcessing: "Processando...",
        sZeroRecords: "Nenhum registro encontrado",
        sSearch: "Pesquisar",
        oPaginate: {
          sNext: "Próximo",
          sPrevious: "Anterior",
          sFirst: "Primeiro",
          sLast: "Último",
        },
        oAria: {
          sSortAscending: ": Ordenar colunas de forma ascendente",
          sSortDescending: ": Ordenar colunas de forma descendente",
        },
      },
      autoWidth: true,
      data: info,
      columns: cols,
      columnDefs: [
        {
          targets: [3, 4, 5],
          type: "date-br",
          render(data) {
            if (data) {
              return new Intl.DateTimeFormat("pt-BR").format(
                new Date(`${data.split(" ")[0]} 23:59:59`)
              );
            } else {
              return '';
            }
          }
        }
      ],
    });
  }

  function CriaTabelaReceber(info) {

    function retornaBotaoSel(meta, data) {
      let marcado = '';
      if (data == 'S') {
        marcado = 'checked';
      }

      return `<div class="icheck-primary">
              <input type="checkbox" ${marcado} id="check_${meta.row}" class="checkSel">
              <label for="check_${meta.row}"></label>
            </div>`
    };

    if ($.fn.DataTable.isDataTable('#tabelaReceber')) {
      $('#tabelaReceber').DataTable().destroy();
      $('#tabelaReceber').empty();
    }

    const cols = [{
      data: 'SEL',
      title: 'Sel'
    },
    {
      data: 'TIPO',
      title: 'Tipo'
    },
    {
      data: 'NUM_DUPLI',
      title: 'Num Dupli'
    },
    {
      data: 'NUMERO',
      title: 'Número'
    },
    {
      data: 'NUM_AP',
      title: 'Número AP'
    },
    {
      data: 'CODCLI',
      title: 'Codcli'
    },
    {
      data: 'NOME',
      title: 'Nome'
    },
    {
      data: 'GRUPO',
      title: 'Grupo'
    },
    {
      data: 'DT_VENCTO',
      title: 'Vencimento'
    },
    {
      data: 'VALOR',
      title: 'Valor'
    },
    {
      data: 'PERC_COM',
      title: 'Perc. Comissão'
    },
    {
      data: 'VALOR_COM',
      title: 'Valor Comissão'
    },
    {
      data: 'OPERACAO',
      title: 'Operação'
    },
    {
      data: 'CODREP',
      title: 'Codrep'
    },
    {
      data: 'NOME_REP',
      title: 'Nome Representante'
    },
    {
      data: 'PEDIDO',
      title: 'Pedido'
    },
    {
      data: 'PED_CLI',
      title: 'Pedido Cliente'
    },
    {
      data: 'DT_PAGTO',
      title: 'Pagamento'
    },
    {
      data: 'DT_EMISSAO',
      title: 'Emissão'
    },
    {
      data: 'LANCAMENTO',
      title: 'Lançamento'
    },
    {
      data: 'DT_PAGTO_COM',
      title: 'Pagamento Comissão'
    },
    {
      data: 'EMP',
      title: 'Empresa'
    },
    {
      data: 'MOEDA',
      title: 'Moeda'
    },
    {
      data: 'GRUPO_CLI',
      title: 'Grupo Cliente'
    },
    {
      data: 'DESC_GRUPO_CLI',
      title: 'Desc. Grupo Cliente'
    },
    {
      data: 'HISTORICO',
      title: 'Histórico'
    },
    {
      data: 'DESC_HISTORICO',
      title: 'Desc. Histórico'
    },
    {
      data: 'CLASSE',
      title: 'Classe'
    },
    {
      data: 'DESC_CLASSE',
      title: 'Desc. Classe'
    },
    {
      data: 'VAL_PED',
      title: 'Valor Pedido'
    },
    {
      data: 'PERC_SALDO',
      title: 'Perc. Saldo'
    },
    {
      data: 'SALDO',
      title: 'Saldo'
    },
    {
      data: 'SALDO_INI',
      title: 'Saldo Ini'
    },
    {
      data: 'SALDO_ABERTO',
      title: 'Saldo Aberto'
    },
    {
      data: 'PROVISAO',
      title: 'Provisão'
    }];

    $("#tabelaReceber").DataTable({
      sort: true,
      paging: true,
      destroy: true,
      colReorder: true,
      searching: false,
      lengthMenu: [[10, 25, 50, 100, -1], [10, 25, 50, 100, 'Todos']],
      language: {
        sEmptyTable: "Nenhum registro encontrado",
        sInfo: "_TOTAL_ registros",
        sInfoEmpty: " 0 registros",
        sInfoFiltered: "(Filtrados de _MAX_ registros)",
        sInfoPostFix: "",
        sInfoThousands: ".",
        sLengthMenu: "_MENU_ resultados",
        sLoadingRecords: "Carregando...",
        sProcessing: "Processando...",
        sZeroRecords: "Nenhum registro encontrado",
        sSearch: "Pesquisar",
        oPaginate: {
          sNext: "Próximo",
          sPrevious: "Anterior",
          sFirst: "Primeiro",
          sLast: "Último",
        },
        oAria: {
          sSortAscending: ": Ordenar colunas de forma ascendente",
          sSortDescending: ": Ordenar colunas de forma descendente",
        },
      },
      autoWidth: true,
      data: info,
      columns: cols,
      columnDefs: [
        {
          targets: [0],
          render: function (data, type, row, meta) {
            return retornaBotaoSel(meta, data);
          }
        },
        {
          targets: [8, 17, 18, 20],
          type: "date-br",
          render(data) {
            if (data) {
              if (data.includes('Z')) {
                return new Date(`${data.substr(1, 10)} 23:59:59`)
              }
              return new Intl.DateTimeFormat("pt-BR").format(
                new Date(`${data.split(" ")[0]} 23:59:59`)
              );
            } else {
              return '';
            }
          }
        },
        {
          targets: [9, 10, 11, 29, 30, 31, 32, 33],
          render: function (data) {
            const v = !data ? 0 : data;
            return parseFloat(v).toLocaleString("pt-br", {
              maximumFractionDigits: 2,
              minimumFractionDigits: 2,
            });
          },
        },
      ],
      rowCallback: async function (row, data) {
        // $(row).css('color', 'var(--color-font-datatable)');
        switch (data.TIPO) {
          case 'FAT': $(row).css('background-color', 'var(--color-fat)'); break;
          case 'LAN': $(row).css('background-color', 'var(--color-lan)'); break;
          case 'REC': $(row).css('background-color', 'var(--color-rec)'); break;
          case 'DEV': $(row).css('background-color', 'var(--color-dev)'); break;
          case 'CHQ': $(row).css('background-color', 'var(--color-chq)'); break;
          case 'MAN': $(row).css('background-color', 'var(--color-man)'); break;
          default: break;
        }
      },
    });

    $('#tabelaReceber').off('change', '.checkSel');
    $('#tabelaReceber').on('change', '.checkSel', async function () {
      let rowIdx = $(this).attr('id').split('_')[1];

      let newData = $('#tabelaReceber').DataTable().row(rowIdx).data();
      await SelecionaRegistro(newData, rowIdx);
    });

    $('#txtValorTotPago').val(parseFloat($('#tabelaReceber').DataTable().data().toArray().reduce((e, o) => {
      return parseFloat(e) + parseFloat(o.VALOR_COM);
    }, 0)).toLocaleString("pt-br", {
      maximumFractionDigits: 2,
      minimumFractionDigits: 2,
    })
    );

    $('#txtValorSelPago').val('0,00');

    const colunasInvisiveis = JSON.parse(
      localStorage.getItem("colunasInvisiveisRelatorios")
    );

    $("#tabelaReceber_length").prepend(
      '<button class="buttonColVis" id="buttonColVisRec"><i class="fas fa-cogs"></i></button>'
    );
    $("#tabelaReceber_length").prepend(
      '<button class="buttonExcel" id="buttonExcelRec"><i class="fas fa-file-excel"></i></button>'
    );

    $("#buttonColVisRec").on("click", async function (e) {
      e.preventDefault();
      controleColunas = 1;
      $.LoadingOverlay("show");
      $("#modal-ColunasVisiveis").modal("show");
      $.LoadingOverlay("hide");
    });

    $("#buttonExcelRec").on("click", async function (e) {
      e.preventDefault();
      const filtros = await RetornaFiltros();
      const url = `/sisplan/fechamentorepcomissao/v1/exportareceber?`;
      const ordem = `&TELA_ORDENACAO=FechamentoRepComissao&ORDEM_ORDENACAO=${$('#selectOpcaoRelatorio').val()}`;
      await exportaCSV(
        url,
        `&FILTROS=${encodeURIComponent(JSON.stringify(filtros))}${ordem}&COD_USUARIO=${getCookie('cod_usuario')}`,
        false,
        1800000,
        "Relatório de Fechamento de Comissão",
        "#tabelaReceber"
      );
    });

    $("#buttonColVisRec").prop("title", "Configurar colunas");
    $("#buttonExcelRec").prop("title", "Exportar CSV");

    $("#tabelaReceber")
      .DataTable()
      .columns()
      .every(function () {
        if (
          colunasInvisiveis.fechamentoRepComissaoRec.indexOf(this.dataSrc()) != -1
        ) {
          this.visible(false);
        }
      });
  }

  $("#modal-ColunasVisiveis").on("show.bs.modal", function () {
    const cols = [];

    let colunasInvisiveis = JSON.parse(
      localStorage.getItem("colunasInvisiveisRelatorios")
    );
    if (controleColunas == 1) {
      $("#tabelaReceber")
        .DataTable()
        .columns()
        .every(function () {
          cols.push({
            title: $(this.header()).text(),
            data: this.dataSrc(),
          });
        });
      adicionaColunas(cols, colunasInvisiveis.fechamentoRepComissaoRec ?? []);
    } else {
      $("#tabelaResumo")
        .DataTable()
        .columns()
        .every(function () {
          cols.push({
            title: $(this.header()).text(),
            data: this.dataSrc(),
          });
        });
      adicionaColunas(cols, colunasInvisiveis.fechamentoRepComissaoRes ?? []);
    }
  });

  function CriaTabelaResumo(info) {
    if ($.fn.DataTable.isDataTable('#tabelaResumo')) {
      $('#tabelaResumo').DataTable().destroy();
      $('#tabelaResumo').empty();
    }

    function carregaInput(valor, indices) {
      try {
        switch (indices.col) {
          case 10: {
            return `<input type="text" id="txtLancarPagar_${indices.row}"
                          class="input-default focus form-control apenasFloat"
                          style="min-width: 15ch; max-width: 20ch" value="${valor}">`;
          }
          case 11: {
            return `<div class="input-group-append">
                        <input type="text" value="${valor}"
                        class="input-default focus form-control validate classClasseResumo" style="min-width: 20ch; max-width: 30ch" id="txtClasseResumo_${indices.row}" name="txtClasseResumo_${indices.row}" placeholder="Classe">
                        <div class="input-group-append">
                            <button class="btn bg-danger" id="btnClasseResumo_${indices.row}" name="btnClasseResumo_${indices.row}" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btnLimpaClasseResumo_${indices.row}" name="btnLimpaClasseResumo_${indices.row}" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                        </div>
                    </div>`;
          }
          case 12: {
            return `<div class="input-group-append">
                        <input type="text" value="${valor}"
                        class="input-default focus form-control validate classHistoricoResumo" style="min-width: 20ch; max-width: 30ch" id="txtHistoricoResumo_${indices.row}" name="txtHistoricoResumo_${indices.row}" placeholder="Histórico">
                        <div class="input-group-append">
                            <button class="btn bg-danger" id="btnHistoricoResumo_${indices.row}" name="btnHistoricoResumo_${indices.row}" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btnLimpaHistoricoResumo_${indices.row}" name="btnLimpaHistoricoResumo_${indices.row}" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                        </div>
                    </div>`;
          }
          case 13: {
            return `<div class="input-group-append">
                        <input type="text" value="${valor}"
                        class="input-default focus form-control validate classBancoResumo" style="min-width: 20ch; max-width: 30ch" id="txtBancoResumo_${indices.row}" name="txtBancoResumo_${indices.row}" placeholder="Banco">
                        <div class="input-group-append">
                            <button class="btn bg-danger" id="btnBancoResumo_${indices.row}" name="btnBancoResumo_${indices.row}" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btnLimpaBancoResumo_${indices.row}" name="btnLimpaBancoResumo_${indices.row}" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                        </div>
                    </div>`;
          }
          case 14: {
            return `<div class="input-group-append">
                        <input type="text" value="${valor}"
                        class="input-default focus form-control validate classSituacaoResumo" style="min-width: 20ch; max-width: 30ch" id="txtSituacaoResumo_${indices.row}" name="txtSituacaoResumo_${indices.row}" placeholder="Situação">
                        <div class="input-group-append">
                            <button class="btn bg-danger" id="btnSituacaoResumo_${indices.row}" name="btnSituacaoResumo_${indices.row}" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btnLimpaSituacaoResumo_${indices.row}" name="btnLimpaSituacaoResumo_${indices.row}" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                        </div>
                    </div>`;
          }
          default:
            return value;
        }
      } catch (e) {
        msgErro(`Não foi possível carregar os dados: ${e}`);
        console.log(e);
      }
    }

    const cols = [
      {
        data: 'CODREP',
        title: 'Codrep'
      },
      {
        data: 'NOME_REP',
        title: 'Nome'
      },
      {
        data: 'VAL_COM',
        title: 'Valor Comissão'
      },
      {
        data: 'VALOR',
        title: 'Valor'
      },
      {
        data: 'DEBITO',
        title: 'Débito'
      },
      {
        data: 'CREDITO',
        title: 'Crédito'
      },
      {
        data: 'VAL_TOT_IR',
        title: 'Valor Total IR'
      },
      {
        data: 'VAL_TOT_ISS',
        title: 'Valor Total ISS'
      },
      {
        data: 'PAGAR',
        title: 'Pagar'
      },
      {
        data: 'RECEBER',
        title: 'Receber'
      },
      {
        data: 'LANCAR_PAGAR',
        title: 'Lançar Pagar'
      },
      {
        data: 'CLASSE',
        title: 'Classe'
      },
      {
        data: 'HISTORICO',
        title: 'Histórico'
      },
      {
        data: 'BANCO',
        title: 'Banco'
      },
      {
        data: 'SITUACAO',
        title: 'Situação'
      },
      {
        data: 'AGENCIA',
        title: 'Agência'
      },
      {
        data: 'CONTA',
        title: 'Conta'
      },
      {
        data: 'BANCO_CLI',
        title: 'Banco Cliente'
      },
      {
        data: 'CHAVE_PIX',
        title: 'Chave Pix'
      }];

    $("#tabelaResumo").DataTable({
      sort: true,
      paging: true,
      destroy: true,
      colReorder: true,
      searching: false,
      // lengthChange: false,
      language: {
        sEmptyTable: "Nenhum registro encontrado",
        sInfo: "_TOTAL_ registros",
        sInfoEmpty: " 0 registros",
        sInfoFiltered: "(Filtrados de _MAX_ registros)",
        sInfoPostFix: "",
        sInfoThousands: ".",
        sLengthMenu: "_MENU_ resultados",
        sLoadingRecords: "Carregando...",
        sProcessing: "Processando...",
        sZeroRecords: "Nenhum registro encontrado",
        sSearch: "Pesquisar",
        oPaginate: {
          sNext: "Próximo",
          sPrevious: "Anterior",
          sFirst: "Primeiro",
          sLast: "Último",
        },
        oAria: {
          sSortAscending: ": Ordenar colunas de forma ascendente",
          sSortDescending: ": Ordenar colunas de forma descendente",
        },
      },
      autoWidth: true,
      data: info,
      columns: cols,
      columnDefs: [
        {
          targets: [2, 4, 5, 6, 7, 8, 9],
          render: function (data) {
            const v = !data ? 0 : data;
            return parseFloat(v).toLocaleString("pt-br", {
              maximumFractionDigits: 2,
              minimumFractionDigits: 2,
            });
          },
        },
        {
          targets: [10, 11, 12, 13, 14],
          render: function (data, v2, v3, index) {
            return carregaInput(data, index);
          }
        }
      ],
    });

    $('#tabelaResumo').on('click', 'tr', async function () {
      $('#tabelaResumo').DataTable().$('tr.selected').removeClass('selected');
      $(this).addClass('selected');
    });

    if ($('#tabelaResumo').DataTable().data().length > 0) {
      $($('#tabelaResumo tr')[1]).trigger('click');
    }

    adicionaPesquisasInputs();
    adicionaMascaraCampos();

    const colunasInvisiveis = JSON.parse(
      localStorage.getItem("colunasInvisiveisRelatorios")
    );

    $("#tabelaResumo_length").prepend(
      '<button class="buttonColVis" id="buttonColVisRes"><i class="fas fa-cogs"></i></button>'
    );
    $("#tabelaResumo_length").prepend(
      '<button class="buttonExcel" id="buttonExcelRes"><i class="fas fa-file-excel"></i></button>'
    );

    $("#buttonColVisRes").on("click", async function (e) {
      e.preventDefault();
      controleColunas = 2;
      $.LoadingOverlay("show");
      $("#modal-ColunasVisiveis").modal("show");
      $.LoadingOverlay("hide");
    });

    $("#buttonExcelRes").on("click", async function (e) {
      e.preventDefault();
      const filtros = await RetornaFiltros();
      const url = `/sisplan/fechamentorepcomissao/v1/exportaresumo?`;
      const ordem = `&TELA_ORDENACAO=FechamentoRepComissao&ORDEM_ORDENACAO=${$('#selectOpcaoRelatorio').val()}`;
      await exportaCSV(
        url,
        `&FILTROS=${encodeURIComponent(JSON.stringify(filtros))}${ordem}&COD_USUARIO=${getCookie('cod_usuario')}`,
        false,
        1800000,
        "Relatório de Fechamento de Comissão - Resumo",
        "#tabelaResumo"
      );
    });

    $("#buttonColVisRes").prop("title", "Configurar colunas");
    $("#buttonExcelRes").prop("title", "Exportar CSV");

    $("#tabelaResumo")
      .DataTable()
      .columns()
      .every(function () {
        if (
          colunasInvisiveis.fechamentoRepComissaoRes.indexOf(this.dataSrc()) != -1
        ) {
          this.visible(false);
        }
      });
  }

  function adicionaMascaraCampos() {
    $('.apenasFloat').maskMoney({
      decimal: ".",
      thousands: "",
      precision: 2,
    });

    $('.apenasInteiros').maskMoney({
      decimal: ".",
      thousands: "",
      precision: 0,
    });
  };

  function adicionaPesquisasInputs() {
    try {
      $('.classClasseResumo').map(function (e, i) {
        $(`#txtBancoResumo_${e}`).autocompleta(1, `JSON={ "tabela":"CADBAN", "camposSelect":[ "BANCO CHAVE", "NOME_BANCO DESCRICAO"], "where": null}`, [`#txtBancoResumo_${e}`], ['CHAVE'], [], () => { }, [true]);
        $(`#btnBancoResumo_${e}`).pesquisa(`#txtBancoResumo_${e}`, 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela": "CADBAN","camposSelect": ["CADBAN.BANCO CODIGO", "CADBAN.NOME_BANCO DESCRICAO"]}`, 'Pesquisa Banco', 'CADBAN', true);
        $(`#btnLimpaBancoResumo_${e}`).on('click', function () {
          $(`#txtBancoResumo_${e}`).val('');
        });

        $(`#txtClasseResumo_${e}`).autocompleta(1, `JSON={ "tabela":"CLASSE_GER", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`, [`#txtClasseResumo_${e}`], ['CHAVE'], [], () => { }, [true]);
        $(`#btnClasseResumo_${e}`).pesquisa(`#txtClasseResumo_${e}`, 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela": "CLASSE_GER","camposSelect": ["CLASSE_GER.CODIGO CODIGO", "CLASSE_GER.DESCRICAO DESCRICAO"]}`, 'Pesquisa Classe', 'CLASSE_GER', true);
        $(`#btnLimpaClasseResumo_${e}`).on('click', function () {
          $(`#txtClasseResumo_${e}`).val('');
        });

        $(`#txtHistoricoResumo_${e}`).autocompleta(1, `JSON={ "tabela":"HISTCP", "camposSelect":[ "HISTORICO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`, [`#txtHistoricoResumo_${e}`], ['CHAVE'], [], () => { }, [true]);
        $(`#btnHistoricoResumo_${e}`).pesquisa(`#txtHistoricoResumo_${e}`, 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela": "HISTCP", "camposSelect": ["HISTCP.HISTORICO CODIGO", "HISTCP.DESCRICAO DESCRICAO"]}`, 'Pesquisa Histórico', 'HISTCP', true);
        $(`#btnLimpaHistoricoResumo_${e}`).on('click', function () {
          $(`#txtHistoricoResumo_${e}`).val('');
        });

        $(`#txtSituacaoResumo_${e}`).autocompleta(1, `JSON={ "tabela":"TABSIT", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`, [`#txtSituacaoResumo_${e}`], ['CHAVE'], [], () => { }, [true]);
        $(`#btnSituacaoResumo_${e}`).pesquisa(`#txtSituacaoResumo_${e}`, 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela": "TABSIT", "camposSelect": ["TABSIT.CODIGO CODIGO", "TABSIT.DESCRICAO DESCRICAO"]}`, 'Pesquisa Situação', 'TABSIT', true);
        $(`#btnLimpaSituacaoResumo_${e}`).on('click', function () {
          $(`#txtSituacaoResumo_${e}`).val('');
        });
      });
    } catch (e) {
      console.log(e);
    }
  }

  $('#btnFechamento').on('click', async function () {
    try {
      const parametroFechamento = await buscaValor('LOJA_PARAM', 'VALOR', `EMP_ID = ${getCookie('emp_id')} AND TIPO = 'RECEBER' AND POSICAO`, '11')
      const { VALOR: valor } = parametroFechamento

      if (valor == '0') {
        msgAlerta(
          'Parâmetro 12 do financeiro não configurado, portanto nenhum registro será inserido no contas à pagar. Deseja continuar?',
          () => { },
          () => { },
          async () => {
            await FechaComissoes()
          }
        )
        return
      }
    } catch (error) {
      console.error('Parâmetro 12 do financeiro não configurado, portanto nenhum registro será inserido no contas à pagar.', error)
    }

    msgAlerta(
      'Deseja realmente fechar o período de comissões?',
      () => { },
      () => { },
      async () => {
        await FechaComissoes()
      }
    )
  })

  function RetornaItensResumo() {
    return $('#tabelaResumo').DataTable().data().toArray().map((e, i) => {
      return {
        CODREP: e.CODREP,
        NOME_REP: e.NOME_REP,
        VAL_COM: e.VAL_COM,
        DEBITO: e.DEBITO,
        CREDITO: e.CREDITO,
        VAL_TOT_IR: e.VAL_TOT_IR,
        VAL_TOT_ISS: e.VAL_TOT_ISS,
        PAGAR: e.PAGAR,
        RECEBER: e.PAGAR,
        LANCAR_PAGAR: !isNaN(parseFloat($(`#txtLancarPagar_${i}`).val())) ? parseFloat($(`#txtLancarPagar_${i}`).val()) : 0,
        CLASSE: $(`#txtClasseResumo_${i}`).val(),
        HISTORICO: $(`#txtHistoricoResumo_${i}`).val(),
        BANCO: $(`#txtBancoResumo_${i}`).val(),
        SITUACAO: $(`#txtSituacaoResumo_${i}`).val(),
        AGENCIA: e.AGENCIA,
        CONTA: e.CONTA,
        BANCO_CLI: e.BANCO_CLI,
        CHAVE_PIX: e.CHAVE_PIX
      }
    });
  }

  async function FechaComissoes() {
    $.LoadingOverlay('show');
    try {
      const obj = {
        data_fechamento: $('#dtFechamento').val() != '' ? $('#dtFechamento').val() : formataData(new Date()),
        data_competencia: $('#dtCompetencia').val() != '' ? $('#dtCompetencia').val() : formataData(new Date()),
        data_vencimento_pagar: $('#dtVenctoPagar').val() != '' ? $('#dtVenctoPagar').val() : formataData(new Date()),
        itens: $('#tabelaReceber').DataTable().data().toArray().filter(e => e.SEL == 'S'),
        itens_resumo: RetornaItensResumo()
      }

      let response = await requisicao("POST", `/Sisplan/fechamentorepcomissao/V1/fechacomissao?&CODUSUARIO=${getCookie('cod_usuario')}&`, ``, `&DADOS=${encodeURIComponent(JSON.stringify(obj))}`, 3600000);

      if (!response) {
        return;
      }

      if (response.status != 200) {
        let json = await response.json();
        msgErro(json.mensagem);
        return;
      }

      toastr.success("Dados gravados com sucesso!", "Confirmação", {
        toastClass: "alert",
        iconClasses: {
          error: "alert-error",
          info: "alert-info",
          success: "alert-success",
          warning: "alert-warning",
        },
        positionClass: "toast-top-center",
        progressBar: true,
        timeOut: 3000,
        fadeOut: 1000,
        onHidden() {
          $('#btnConsultar').trigger('click');
        },
      }).css({
        "margin-top": "20%",
        width: "500px",
        "max-width": "500px",
      });
    } catch (error) {
      console.error(error);
      msgErro('Ocorreu um erro ao realizar o fechamento.');
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  async function SelecionaRegistro(line, index) {

    const registroSelecionado = [line];
    const resumo = RetornaItensResumo();
    const valor_pagto = $('#txtValorSelPago').val().replaceAll('.', '');;
    let response = await requisicao("POST", `/Sisplan/fechamentorepcomissao/V1/selecionaregistro?&CODUSUARIO=${getCookie('cod_usuario')}&`, ``, `&ITEM=${encodeURIComponent(JSON.stringify(registroSelecionado))}&RESUMO=${encodeURIComponent(JSON.stringify(resumo))}&VALOR_PAGTO=${valor_pagto}`, 3600000);

    if (!response) {
      return;
    }

    let json = await response.json();
    if (response.status != 200) {
      msgErro(json.mensagem);
      return;
    }
    $('#tabelaReceber').DataTable().row(index).data(JSON.parse(json.item)[0]).draw(false);
    CriaTabelaResumo(JSON.parse(json.itens_resumo));
    $('#txtValorSelPago').val(json.valor_pagto.toLocaleString("pt-br", {
      maximumFractionDigits: 2,
      minimumFractionDigits: 2,
    }))
  }

  $('#btnLancarPagar').on('click', async function () {
    const index = $('#tabelaResumo').DataTable().row($('tr.selected')).index();
    const data = $('#tabelaResumo').DataTable().row(index).data();
    if (!data) {
      msgErro('Nenhum registro resumido selecionado. Impossível continuar.');
      return;
    }
    data.LANCAR_PAGAR = $(`#txtLancarPagar_${index}`).val();
    data.CLASSE = $(`#txtClasseResumo_${index}`).val();
    data.HISTORICO = $(`#txtHistoricoResumo_${index}`).val();
    data.BANCO = $(`#txtBancoResumo_${index}`).val();
    data.SITUACAO = $(`#txtSituacaoResumo_${index}`).val();
    msgAlerta('Deseja realmente realizar o lançamento para o registro selecionado?', () => { }, () => { }, async () => {
      await LancaPagar(data, index);
    });
  });

  async function LancaPagar(data, index) {
    $.LoadingOverlay('show');
    try {
      const fechamento = $('#dtFechamento').val() != '' ? formataDataBonita($('#dtFechamento').val()) : formataDataBonita(formataData(new Date()));
      const vencimento = $('#dtVencimentoAte').val() != '' ? formataDataBonita($('#dtVencimentoAte').val()) : formataDataBonita(formataData(new Date()));
      let response = await requisicao("POST", `/Sisplan/fechamentorepcomissao/V1/lancapagar?&CODUSUARIO=${getCookie('cod_usuario')}&`, ``, `&ITEM_RESUMO=${encodeURIComponent(JSON.stringify(data))}&VENCIMENTO=${vencimento}&FECHAMENTO=${fechamento}`, 3600000);

      if (!response) {
        return;
      }

      let json = await response.json();
      if (response.status != 200) {
        msgErro(json.mensagem);
        return;
      }

      const dados = $('#tabelaResumo').DataTable().row(index).data();
      dados.PAGAR = dados.PAGAR + json.lancar_pagar;
      dados.LANCAR_PAGAR = 0;
      $('#tabelaResumo').DataTable().row(index).data(dados).draw(false);
      toastr.success("Dados gravados com sucesso!", "Confirmação", {
        toastClass: "alert",
        iconClasses: {
          error: "alert-error",
          info: "alert-info",
          success: "alert-success",
          warning: "alert-warning",
        },
        positionClass: "toast-top-center",
        progressBar: true,
        timeOut: 800,
        fadeOut: 1000,
        onHidden() {
          adicionaMascaraCampos();
        },
      }).css({
        "margin-top": "20%",
        width: "500px",
        "max-width": "500px",
      });
    } catch (e) {
      console.log(e);
      msgErro(`Não foi possível lançar os registros no pagar: ${e}`);
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  async function MarcaSelecionados(tipo, marcar) {
    $.LoadingOverlay('show');
    try {
      const receber = $('#tabelaReceber').DataTable().data().toArray();
      const resumo = RetornaItensResumo();
      const valor_pagto = $('#txtValorSelPago').val().replaceAll('.', '');
      let response = await requisicao("POST", `/Sisplan/fechamentorepcomissao/V1/marcaselecao?&CODUSUARIO=${getCookie('cod_usuario')}&`, ``, `&RECEBER=${encodeURIComponent(JSON.stringify(receber))}&RESUMO=${encodeURIComponent(JSON.stringify(resumo))}&VALOR_PAGTO=${valor_pagto}&TIPO=${tipo}&MARCAR=${marcar}`, 3600000);

      if (!response) {
        return;
      }

      let json = await response.json();
      if (response.status != 200) {
        msgErro(json.mensagem);
        return;
      }

      CriaTabelaReceber(JSON.parse(json.item));
      CriaTabelaResumo(JSON.parse(json.itens_resumo));
      $('#txtValorSelPago').val(json.valor_pagto.toLocaleString("pt-br", {
        maximumFractionDigits: 2,
        minimumFractionDigits: 2,
      }))
    } catch (e) {
      console.log(e);
      msgErro(`Não foi possível selecionar os registros: ${e}`);
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  $('#cbMarcarTodos').on('change', async function () {
    await MarcaSelecionados('', $(this).prop('checked'));
    if (!$(this).prop('checked')) {
      $('#cbMarcarRec, #cbMarcarFat, #cbMarcarDev, #cbMarcarMan').prop('checked', false);
    }
  });

  $('#cbMarcarRec').on('change', async function () {
    await MarcaSelecionados('REC', $(this).prop('checked'));
  });

  $('#cbMarcarFat').on('change', async function () {
    await MarcaSelecionados('FAT', $(this).prop('checked'));
  });

  $('#cbMarcarDev').on('change', async function () {
    await MarcaSelecionados('DEV', $(this).prop('checked'));
  });

  $('#cbMarcarMan').on('change', async function () {
    await MarcaSelecionados('MAN', $(this).prop('checked'));
  });

  $('#btnExcluirLinhas').on('click', async function () {
    msgAlerta('Deseja realmente excluir as linhas selecionadas?', () => { }, () => { }, async () => {
      await ExcluirLinhas();
    })
  });

  async function ExcluirLinhas() {
    $.LoadingOverlay('show');
    try {
      const receber = $('#tabelaReceber').DataTable().data().toArray();
      const vencimento = $('#dtVencimentoAte').val() != '' ? formataDataBonita($('#dtVencimentoAte').val()) : formataDataBonita(formataData(new Date()));
      let response = await requisicao("POST", `/Sisplan/fechamentorepcomissao/V1/excluirlinhas?&CODUSUARIO=${getCookie('cod_usuario')}&`, ``, `&RECEBER=${encodeURIComponent(JSON.stringify(receber))}&VENCIMENTO=${vencimento}`, 3600000);

      if (!response) {
        return;
      }

      let json = await response.json();
      if (response.status != 200) {
        msgErro(json.mensagem);
        return;
      }

      CriaTabelaReceber(JSON.parse(json.item));
      CriaTabelaResumo(JSON.parse(json.itens_resumo));
      $('#txtValorSelPago').val(json.valor_pagto.toLocaleString("pt-br", {
        maximumFractionDigits: 2,
        minimumFractionDigits: 2,
      }))
    } catch (e) {
      console.log(e);
      msgErro(`Não foi possível excluir as linhas seleciondas: ${e}`);
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  $('#btnEstornarPagto').on('click', async function () {
    const data = $('#tabelaReceber').DataTable().data().toArray().find(e => e.SEL == 'S');
    if (!data) {
      msgErro('Nenhum registro selecionado. Impossível continuar.');
      return;
    }
    msgAlerta('Deseja realmente estornas as comissões selecionadas?', () => { }, () => { }, async () => {
      await EstornaPagamentoComissoes();
    });
  })

  async function EstornaPagamentoComissoes() {
    $.LoadingOverlay('show');
    try {
      const receber = $('#tabelaReceber').DataTable().data().toArray();
      let response = await requisicao("POST", `/Sisplan/fechamentorepcomissao/V1/estornapagamento?&CODUSUARIO=${getCookie('cod_usuario')}&`, ``, `&RECEBER=${encodeURIComponent(JSON.stringify(receber))}`, 3600000);

      if (!response) {
        return;
      }

      let json = await response.json();
      if (response.status != 200) {
        msgErro(json.mensagem);
        return;
      }

      CriaTabelaReceber(json);

      toastr.success("Dados gravados com sucesso!", "Confirmação", {
        toastClass: "alert",
        iconClasses: {
          error: "alert-error",
          info: "alert-info",
          success: "alert-success",
          warning: "alert-warning",
        },
        positionClass: "toast-top-center",
        progressBar: true,
        timeOut: 800,
        fadeOut: 1000,
        onHidden() {
        },
      }).css({
        "margin-top": "20%",
        width: "500px",
        "max-width": "500px",
      });
    } catch (e) {
      console.log(e);
      msgErro(`Não foi possível gravar os dados: ${e}`);
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  $('#btnDescontarComissao').on('click', function () {
    $('#modal-descontar-comissao').modal('show');
  })

  $('#btnConsultarDesconto').on('click', async function () {
    await BuscaDadosDesconto();
  });

  async function BuscaDadosDesconto() {
    $.LoadingOverlay('show');
    try {
      const filtros = {
        vencto_ini: $('#dtVencimentoDescontoDe').val() != '' ? $('#dtVencimentoDescontoDe').val() : '1200-01-01',
        vencto_fim: $('#dtVencimentoDescontoAte').val() != '' ? $('#dtVencimentoDescontoAte').val() : '2500-12-31',
        pagto_ini: $('#dtPagamentoDescontoDe').val() != '' ? $('#dtPagamentoDescontoDe').val() : '1200-01-01',
        pagto_fim: $('#dtPagamentoDescontoAte').val() != '' ? $('#dtPagamentoDescontoAte').val() : '2500-12-31',
        cliente: await formataListas($('#txtClienteDesconto').val().toString()),
        representante: await formataListas($('#txtRepresentanteDesconto').val().toString()),
        coordenador: await formataListas($('#txtCoordenadorDesconto').val().toString()),
        duplicata: await formataListas($('#txtDuplicataDesconto').val().toString()),
        buscar_canceladas: $('#selectBuscarCanceladasDesconto').val() == 'S',
        tipo_comissao: $('#selectStatusComissaoDesconto').val()
      }

      const url = `/sisplan/fechamentorepcomissao/v1/buscadadosdesconto?`;
      const response = await requisicao("GET", url, `&FILTROS=${encodeURIComponent(JSON.stringify(filtros))}`, '', 1800000);

      if (!response) {
        return;
      }

      const data = await response.json();

      CriaTabelaDesconto(data);

    } catch (e) {
      console.log(e);
      msgErro(`Não foi possível buscar os dados: ${e}`);
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  function CriaTabelaDesconto(info) {
    function retornaBotaoDescontoSel(meta, data) {
      let marcado = '';
      if (data == 'S') {
        marcado = 'checked';
      }

      return `<div class="icheck-primary">
              <input type="checkbox" ${marcado} id="checkDesconto_${meta.row}" class="checkSelDesconto">
              <label for="checkDesconto_${meta.row}"></label>
            </div>`
    };

    function carregaInput(valor, indices) {
      return `<input type="date" id="txtLancamentoDesconto_${indices.row}"
              class="input-default focus form-control"
              style="width: 22ch" value="${valor.substr(0, 10)}">`;
    }

    if ($.fn.DataTable.isDataTable('#tabelaDesconto')) {
      $('#tabelaDesconto').DataTable().destroy();
      $('#tabelaDesconto').empty();
    }

    const cols = [{
      data: 'SEL',
      title: 'Sel'
    },
    {
      data: 'NUMERO',
      title: 'Número'
    },
    {
      data: 'DT_LANC',
      title: 'Lançamento'
    },
    {
      data: 'DT_EMISSAO',
      title: 'Emissão'
    },
    {
      data: 'DT_VENCTO',
      title: 'Vencimento'
    },
    {
      data: 'CODREP',
      title: 'Codrep'
    },
    {
      data: 'NOME',
      title: 'Nome'
    },
    {
      data: 'FATURA',
      title: 'Fatura'
    },
    {
      data: 'CLIENTE',
      title: 'Cliente'
    },
    {
      data: 'NOME_CLIENTE',
      title: 'Nome Cliente'
    },
    {
      data: 'DT_PAGTO',
      title: 'Pagamento'
    },
    {
      data: 'COM_FAT',
      title: 'Comissão Fat'
    },
    {
      data: 'COM_REC',
      title: 'Comissão rec'
    },
    {
      data: 'COM_DESC',
      title: 'Comissão Desc'
    },
    {
      data: 'VAL_DUP',
      title: 'Valor Duplicata'
    },
    {
      data: 'NOVA_COM_REC',
      title: 'Nova Comissão Rec'
    },
    {
      data: 'DIAS_ATRASO',
      title: 'Dias Atraso'
    },
    {
      data: 'PEDIDO',
      title: 'Pedido'
    },
    {
      data: 'STATUS',
      title: 'Status'
    },
    {
      data: 'VALOR_PAGO',
      title: 'Valor Pago'
    }];

    $("#tabelaDesconto").DataTable({
      sort: true,
      paging: true,
      destroy: true,
      colReorder: true,
      searching: false,
      lengthChange: false,
      language: {
        sEmptyTable: "Nenhum registro encontrado",
        sInfo: "_TOTAL_ registros",
        sInfoEmpty: " 0 registros",
        sInfoFiltered: "(Filtrados de _MAX_ registros)",
        sInfoPostFix: "",
        sInfoThousands: ".",
        sLengthMenu: "_MENU_ resultados",
        sLoadingRecords: "Carregando...",
        sProcessing: "Processando...",
        sZeroRecords: "Nenhum registro encontrado",
        sSearch: "Pesquisar",
        oPaginate: {
          sNext: "Próximo",
          sPrevious: "Anterior",
          sFirst: "Primeiro",
          sLast: "Último",
        },
        oAria: {
          sSortAscending: ": Ordenar colunas de forma ascendente",
          sSortDescending: ": Ordenar colunas de forma descendente",
        },
      },
      autoWidth: true,
      data: info,
      columns: cols,
      columnDefs: [
        {
          targets: [0],
          render: function (data, type, row, meta) {
            return retornaBotaoDescontoSel(meta, data);
          }
        },
        {
          targets: [2],
          render: function (data, v2, v3, index) {
            return carregaInput(data, index);
          }
        },
        {
          targets: [3, 4, 10],
          type: "date-br",
          render(data) {
            if (data) {
              if (data.includes('Z')) {
                return new Date(`${data.substr(1, 10)} 23:59:59`)
              }
              return new Intl.DateTimeFormat("pt-BR").format(
                new Date(`${data.split(" ")[0]} 23:59:59`)
              );
            } else {
              return '';
            }
          }
        },
        {
          targets: [11, 12, 13, 14, 15, 19],
          render: function (data) {
            const v = !data ? 0 : data;
            return parseFloat(v).toLocaleString("pt-br", {
              maximumFractionDigits: 2,
              minimumFractionDigits: 2,
            });
          },
        }
      ],
    });

    $('#tabelaDesconto').off('change', '.checkSelDesconto');
    $('#tabelaDesconto').on('change', '.checkSelDesconto', async function () {
      let rowIdx = $(this).attr('id').split('_')[1];
      let newData = $('#tabelaDesconto').DataTable().row(rowIdx).data();
      newData.SEL = $(this).prop('checked') ? 'S' : 'N';
      $('#tabelaDesconto').DataTable().row(rowIdx).data(newData).draw(false);
    });

  }

  $('#btnGravarDesconto').on('click', async function () {
    const valida = $('#tabelaDesconto').DataTable().data().toArray().find(e => e.SEL == 'S');
    if (!valida) {
      msgErro('Nenhum registro selecionado. Impossível continuar.');
      return;
    }
    await GravaDadosDesconto();
  })

  async function GravaDadosDesconto() {
    $.LoadingOverlay('show');
    try {
      const data = $('#tabelaDesconto').DataTable().data().toArray().filter((e, i) => {
        if (e.SEL == 'S') {
          return {
            SEL: e.SEL,
            NUMERO: e.NUMERO,
            DT_LANC: $(`txtLancamentoDesconto_${i}`).val(),
            DT_EMISSAO: e.DT_EMISSAO,
            DT_VENCTO: e.DT_VENCTO,
            CODREP: e.CODREP,
            NOME: e.NOME,
            FATURA: e.FATURA,
            CLIENTE: e.CLIENTE,
            NOME_CLIENTE: e.NOME_CLIENTE,
            DT_PAGTO: e.DT_PAGTO,
            COM_FAT: e.COM_FAT,
            COM_REC: e.COM_REC,
            COM_DESC: e.COM_DESC,
            VAL_DUP: e.VAL_DUP,
            NOVA_COM_REC: e.NOVA_COM_REC,
            DIAS_ATRASO: e.DIAS_ATRASO,
            PEDIDO: e.PEDIDO,
            STATUS: e.STATUS,
            VALOR_PAGO: e.VALOR_PAGO
          }
        }
      });

      let response = await requisicao("POST", `/Sisplan/fechamentorepcomissao/V1/gravadadosdesconto?&CODUSUARIO=${getCookie('cod_usuario')}&`, ``, `&DADOS=${encodeURIComponent(JSON.stringify({ ITENS: data }))}`, 3600000);

      if (!response) {
        return;
      }

      if (response.status != 200) {
        let json = await response.json();
        msgErro(json.mensagem);
        return;
      }

      toastr.success("Dados gravados com sucesso!", "Confirmação", {
        toastClass: "alert",
        iconClasses: {
          error: "alert-error",
          info: "alert-info",
          success: "alert-success",
          warning: "alert-warning",
        },
        positionClass: "toast-top-center",
        progressBar: true,
        timeOut: 1000,
        fadeOut: 1000,
        onHidden() {
          $('#modal-descontar-comissao').modal('hide');
        },
      }).css({
        "margin-top": "20%",
        width: "500px",
        "max-width": "500px",
      });
    } catch (e) {
      console.log(e);
      msgErro(`Não foi possível gravar os dados: ${e}`);
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  $('#modal-descontar-comissao').on('hide.bs.modal', function () {
    $('#dtVencimentoDescontoDe').val('1200-01-01');
    $('#dtVencimentoDescontoAte').val('2500-12-31');
    $('#dtPagamentoDescontoDe').val('1200-01-01');
    $('#dtPagamentoDescontoAte').val('2500-12-31');
    $('#txtClienteDesconto').empty().trigger('change');
    $('#txtRepresentanteDesconto').empty().trigger('change');
    $('#txtCoordenadorDesconto').empty().trigger('change');
    $('#txtDuplicataDesconto').empty().trigger('change');
    $('#selectBuscarCanceladasDesconto').val('N');
    $('#selectStatusComissaoDesconto').val('');
    CriaTabelaDesconto([]);
  })

  $('#btnImprimir').on('click', async function () {
    await ImprimirRelatorio();
  });

  async function ImprimirRelatorio() {
    try {
      $.LoadingOverlay("show");
      try {
        const ordemOrdenacao = $('#selectOpcaoRelatorio').val();
        const url = `/sisplan/impressao/v1/imprimirrelfechamentorepcomissao?OPCAORELATORIO=${ordemOrdenacao}`;
        const filtros = await RetornaFiltros();
        const ordem = `&TELA_ORDENACAO=FechamentoRepComissao&ORDEM_ORDENACAO=${$('#selectOpcaoRelatorio').val()}`;
        const bImprimeAutomatico = await verificaImprimirAutomatico(
          "RelFechamentoComissao"
        );
        const arquivo = await GeraRelatorio(
          `${url}${ordem}&FILTROS=${encodeURIComponent(JSON.stringify(filtros))}`,
          "POST",
          100000,
          false,
          "RelFechamentoComissao"
        );

        if (arquivo != undefined) {
          if (!bImprimeAutomatico) {
            window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, "_blank");
          }
          await limparRelatorios();
        }
      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  }
});