$('#txtClienteStone').autocompleta(1, `JSON={"tabela":"CLASSE_GER", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
$('#btnClienteStone').pesquisa('#txtClienteStone', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CLASSE_GER", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Classe Gerencial', 'CLASSE_GER');
$('#btnLimpaClienteStone').on('click', function () {
  $('#txtClienteStone').val('');
});

$('#txtBancoStone').autocompleta(1, `JSON={"tabela":"CLASSE_GER", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
$('#btnBancoStone').pesquisa('#txtBancoStone', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CLASSE_GER", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Classe Gerencial', 'CLASSE_GER');
$('#btnLimpaBancoStone').on('click', function () {
  $('#txtBancoStone').val('');
});

$('#txtContaStone').autocompleta(1, `JSON={"tabela":"CLASSE_GER", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
$('#btnContaStone').pesquisa('#txtContaStone', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CLASSE_GER", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Classe Gerencial', 'CLASSE_GER');
$('#btnLimpaContaStone').on('click', function () {
  $('#txtContaStone').val('');
});

$('#txtClasseTaxaStone').autocompleta(1, `JSON={"tabela":"HISTCP", "camposSelect":[ "HISTORICO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
$('#btnClasseTaxaStone').pesquisa_serverside(['#txtClasseTaxaStone'], ['HISTORICO'], ['DESCRICAO'], '{"tabela":"HISTCP", "camposSelect":[ "HISTORICO", "DESCRICAO"], "where": null}', 'Pesquisa de Histórico');
$('#btnLimpaClasseTaxaStone').on('click', function () {
  $('#txtClasseTaxaStone').val('');
});

$('#txtClasseBaixaStone').autocompleta(1, `JSON={"tabela":"HISTCP", "camposSelect":[ "HISTORICO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
$('#btnClasseBaixaStone').pesquisa_serverside(['#txtClasseBaixaStone'], ['HISTORICO'], ['DESCRICAO'], '{"tabela":"HISTCP", "camposSelect":[ "HISTORICO", "DESCRICAO"], "where": null}', 'Pesquisa de Histórico');
$('#btnLimpaClasseBaixaStone').on('click', function () {
  $('#txtClasseBaixaStone').val('');
});

$('#txtClasseDespesaStone').autocompleta(1, `JSON={"tabela":"HISTCP", "camposSelect":[ "HISTORICO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
$('#btnClasseDespesaStone').pesquisa_serverside(['#txtClasseDespesaStone'], ['HISTORICO'], ['DESCRICAO'], '{"tabela":"HISTCP", "camposSelect":[ "HISTORICO", "DESCRICAO"], "where": null}', 'Pesquisa de Histórico');
$('#btnLimpaClasseDespesaStone').on('click', function () {
  $('#txtClasseDespesaStone').val('');
});

$('#txtHistoricoStone').autocompleta(1, `JSON={"tabela":"HISTCP", "camposSelect":[ "HISTORICO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
$('#btnHistoricoStone').pesquisa_serverside(['#txtHistoricoStone'], ['HISTORICO'], ['DESCRICAO'], '{"tabela":"HISTCP", "camposSelect":[ "HISTORICO", "DESCRICAO"], "where": null}', 'Pesquisa de Histórico');
$('#btnLimpaHistóricoStone').on('click', function () {
  $('#txtHistoricoStone').val('');
});

$('#btnVerBaixasStone').on('click', async function () {
  if (!$('#txtArquivo').val()) {
    throw msgAlerta('Nenhum arquivo inserido no campo caminho, impossível visualizar as baixas!');
  }
  await verBaixasStone();
});

async function verBaixasStone() {
  $.LoadingOverlay('show');
  try {
    limpaTabela();
    let params = await coletaDadosInputsStone();

    const body = {
      Stone: JSON.parse($('#conteudoFormatado').val())
    }

    const response = await requisicao('POST', `/sisplan/escretorno/V1/buscabaixasstone?`, `PARAMS=${JSON.stringify(params)}`, JSON.stringify(body), 90000);

    if (!response) {
      return;
    }

    let jsonStr = await response.json();

    dataSetColsStone[0].render = function (data, type, row, meta) {
      let checked = false;
      let bloqueia = false;
      if (row.naoSeleciona == '') {
        row.naoSeleciona = 'S'
      }
      if (row.tag != '0') {
        if (row.sel == 'S' && row.naoSeleciona != 'N') {
          checked = true;
          bloqueia = false;
        }
      }

      if (row.sel == 'N' && row.naoSeleciona == 'N') {
        checked = false;
        bloqueia = true;
      }

      let disabledAttribute = bloqueia ? 'disabled' : '';
      return `<div class="icheck-danger d-inline">
                  <input type="checkbox" ${disabledAttribute} ${checked ? 'checked' : ''} id="check_col_${meta.row}_row_${meta.col}" class="campoConsulta">
                  <label for="check_col_${meta.row}_row_${meta.col}"></label>
              </div>`
    }

    $('#tabelaStone').DataTable({
      paging: true,
      filter: false,
      info: false,
      length: false,
      order: false,
      destroy: true,
      language: {
        sEmptyTable: 'Nenhum registro encontrado',
        sInfo: '_TOTAL_ registros',
        sInfoEmpty: ' 0 registros',
        sInfoFiltered: '(Filtrados de _MAX_ registros)',
        sInfoPostFix: '',
        sInfoThousands: '.',
        sLengthMenu: '_MENU_ resultados',
        sLoadingRecords: 'Carregando...',
        sProcessing: 'Processando...',
        sZeroRecords: 'Nenhum registro encontrado',
        sSearch: 'Pesquisar',
        oPaginate: {
          sNext: 'Próximo',
          sPrevious: 'Anterior',
          sFirst: 'Primeiro',
          sLast: 'Último',
        },
        oAria: {
          sSortAscending: ': Ordenar colunas de forma ascendente',
          sSortDescending: ': Ordenar colunas de forma descendente',
        },
      },
      data: jsonStr,
      columns: dataSetColsStone,
      columnDefs: [{
        targets: [6, 7, 8],
        render: function (data, type, row) {
          if (type === 'display' || type === 'filter') {
            var date = new Date(data);
            var dia = date.getDate();
            var mes = date.getMonth() + 1;
            var ano = date.getFullYear();
            if (dia < 10) {
              dia = '0' + dia;
            }
            if (mes < 10) {
              mes = '0' + mes;
            }
            return dia + '/' + mes + '/' + ano;
          } else {
            return data;
          }
        },
      }],
      rowCallback: async function (row, data) {
        if (data.numero == '') {
          $(row).css('background-color', '#B4524D');
          $(row).css('color', '#ecfdff');
        }
        else if (data.naoSeleciona == 'N') {
          $(row).css('background-color', '#3A5E44');
          $(row).css('color', '#ecfdff');
        }
        else if (data.valorDuplicata != data.valorPago && data.valorPago > 0) {
          $(row).css('background-color', '#04336C');
          $(row).css('color', '#ecfdff');
        }
      },
    });
    $('#checkTodosStone').prop('checked', true);
  } catch (error) {
    console.log(error)
  } finally {
    $.LoadingOverlay('hide');
  }
}

function limpaTabela() {
  if ($.fn.DataTable.isDataTable("#tabelaStone")) {
    $("#tabelaStone").DataTable().destroy();
    $("#tabelaStone").empty();
  }
}

async function validaConfirmacaoStone() {
  if (!($('#txtBancoStone'))) {
    throw msgAlerta('Banco não informado, verifique!');
  }
  if (!($('#txtContaStone'))) {
    throw msgAlerta('Conta não informada, verifique!');
  }
  if (!($('#txtClasseBaixaStone'))) {
    throw msgAlerta('Classe de baixa não informada, verifique!');
  }
  if (!($('#txtClasseTaxaStone'))) {
    throw msgAlerta('Classe de taxa não informada, verifique!');
  }
  if (!($('#txtClasseAntecipacao')) && $('#cbAntecipacaoStone').is(':checked')) {
    throw msgAlerta('Classe de taxa de antecipação não informada, verifique')
  }
  if (!($('#txtHistoricoStone').val())) {
    throw msgAlerta('Histórico não informado, verifique!');
  }
}

$('#btnConfirmarStone').on('click', async function () {
  const Stone = await buscaDadosTabelaStone();
  const params = await coletaDadosInputsStone();

  await validaConfirmacaoStone();

  const body = {
    Stone: Stone
  }

  const response = await requisicao('POST', `/sisplan/escretorno/V1/confirmastone?`, `PARAMS=${JSON.stringify(params)}`, JSON.stringify(body), 90000);

  if (!response) {
    return;
  }
});

$('[name="chkSugestao"]').on('change', function () {
  if ($('#rgPrevisaoStone').is(':checked')) {
    $('#divTabelaStoneResumo').addClass('d-none');
  } else {
    $('#divTabelaStoneResumo').removeClass('d-none');
  }
});

async function buscaDadosTabelaStone() {
  const tabelaStone = $('#tabelaStone').DataTable().rows().data().toArray();

  const objeto = tabelaStone.map((dados) => dados.sel == 'S' ? ({
    sel: dados.sel,
    numero: dados.numero,
    codCli: dados.codCli,
    nome: dados.nome,
    fatura: dados.fatura,
    dataEmissao: dados.dataEmissao,
    dataVencimento: dados.dataVencimento,
    dataPagamento: dados.dataPagamento,
    nsu: dados.nsu,
    numeroTerminal: dados.numeroTerminal,
    parcela: dados.parcela,
    valorBrutoArq: dados.valorBrutoArq,
    valorDuplicata: dados.valorDuplicata,
    valorPago: dados.valorPago,
    valorTarifa: dados.valorTarifa,
    valorLiquido: dados.valorLiquido,
    difMaior: dados.difMaior,
    difMenor: dados.difMenor,
    bandeira: dados.bandeira,
    saldo: dados.saldo,
    banco: dados.banco,
    agencia: dados.agencia,
    conta: dados.conta,
    modalidade: dados.modalidade,
    tipoRecto: dados.tipoRecto,
    tipoLancamento: dados.tipoLancamento,
    taxa: dados.taxa,
    taxaRec: dados.taxaRec
  }) : null).filter((dados) => dados !== null)
  return objeto;
};

function selecionarTodosInputsStone() {
  $(`#tabelaStone`).DataTable().rows().data().$(`.campoConsulta`).toArray().filter((campoSel) => {
    if (!$(campoSel).prop('disabled')) {
      $(campoSel).prop('checked', !campoSel.checked)
      $('#tabelaStone').DataTable().rows(campoSel.closest('tr')).data().toArray()[0].sel = campoSel.checked ? 'S' : 'N';
    }
  });
}

$('#tabelaStone').on('click', '.campoConsulta', async function () {
  lineIsChecked = $('#tabelaStone').DataTable().rows((this).closest('tr')).data().toArray()[0].sel == 'N' ? true : false
  newValue = lineIsChecked ? 'S' : 'N'
  $('#tabelaStone').DataTable().rows((this).closest('tr')).data().toArray()[0].sel = newValue;
});

async function coletaDadosInputsStone() {
  let tipoLancamento = $('#cbPagamentoStone').is(':checked') ? 1 : 0
  let NaoGeraCC = $('#cbNaoGeraCCStone').is(':checked') ? true : false

  objeto = {
    nomeArquivo: $('#txtNomeArquivoStone').val(),
    numeroArquivo: $('#txtNumeroArquivo').val(),
    cliente: pegaChave('#txtClienteStone'),
    dataPagamento: $('#dtPagamentoStone').val(),
    historico: pegaChave('#txtHistoricoStone'),
    conta: pegaChave('#txtContaStone'),
    classeTaxa: pegaChave('#txtClasseTaxaStone'),
    classeBaixa: pegaChave('#txtClasseBaixaStone'),
    classeDespesa: pegaChave('#txtClasseDespesaStone'),
    valorDe: $('#txtValorDeStone').val(),
    valorAte: $('#txtValorAteStone').val(),
    tipoLancamento: tipoLancamento,
    NaoGeraCC: NaoGeraCC,
  }
  return objeto;
}

$('#checkTodosStone').on('click', function () {
  selecionarTodosInputsStone()
});