$(document).ready(async function () {

    $('#tutorial').on('click', function () {
        $(document).ready(async function () {
            const driver = new Driver({
                doneBtnText: 'Sair',
                closeBtnText: 'Fechar',
                nextBtnText: 'Próximo',
                prevBtnText: 'Anterior',
                allowClose: false
            });
            driver.defineSteps([{
                element: '#lotes',
                popover: {
                    title: 'Área dos Lotes',
                    description: 'Nessa área é possível informar os filtros e consultar os lotes.',
                    position: 'bottom'
                }
            },
            {
                element: '#btnConsultar',
                popover: {
                    title: 'Botão Consultar',
                    description: 'Clique aqui para consultar os lotes.',
                    position: 'top'
                }
            },
            {
                element: '#btnLimparTela',
                popover: {
                    title: 'Botão Limpar Tela',
                    description: 'Clique aqui para limpar os dados da tela.',
                    position: 'top'
                }
            },
            {
                element: '#lotesDesdobrados',
                popover: {
                    title: 'Área dos Lotes Desdobrados',
                    description: 'Nessa área é possível informar os dados e em quantos rolos o lote pai será desdobrado.',
                    position: 'top'
                }
            },
            {
                element: '#btnDistribuir',
                popover: {
                    title: 'Botão Distribuir',
                    description: 'Clique aqui para distribuir os lotes.',
                    position: 'top'
                }
            },
            {
                element: '#rodapeTela',
                popover: {
                    title: 'Rodapé',
                    description: 'Aqui é possível gravar e imprimir as informações, também é possível verifcar os totalizadores da tela.',
                    position: 'top'
                }
            },
            ]);
            driver.start();
        });
    });

    let tamanhoSequencialLoteDesdobrado = 4;
    await carregaValoresPadroes();
    await carregaFuncionarioUsuario();
    const existeDepositoEmpresa = await verificaDepositoEmpresa();
    const parametrosVenda = await BuscaParametrosVenda();
    const parametrosMaterial = await BuscaParametrosMaterial();
    const imprimirAoGravar = localStorage.getItem('@desdobralote.imprimirAoGravar') == null
        || localStorage.getItem('@desdobralote.imprimirAoGravar') == 'undefined' ? false
        : localStorage.getItem('@desdobralote.imprimirAoGravar') == 'true';
    $('#cbImprimirAoGravar').prop('checked', imprimirAoGravar);

    $('#cbImprimirAoGravar').on('change', () => {
        localStorage.setItem('@desdobralote.imprimirAoGravar', String($('#cbImprimirAoGravar').prop('checked')));
    });

    $('#txtMaterial').autocompleta(1, `JSON={ "tabela":"MATERIAL", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
    $('#txtCor').autocompleta(1, `JSON={ "tabela":"CADCOR", "camposSelect":[ "COR CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
    $('#txtFuncionario').autocompleta(1, `JSON={ "tabela":"PESSOAL", "camposSelect":[ "CODIGO CHAVE", "NOME DESCRICAO"], "where": null}`);
    $('#txtTpBaixa').autocompleta(1, `JSON={ "tabela":"TABBAI", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
    $('#txtLocalEntrada').autocompleta(1, `JSON={ "tabela":"CAD_LOC_ESTOQ", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);

    $('#btnMaterial').pesquisa('#txtMaterial', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"MATERIAL", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Material', 'MATERIAL');
    $('#btnCor').pesquisa('#txtCor', 'COR', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CADCOR", "camposSelect":[ "COR", "DESCRICAO"]}`, 'Pesquisa Cor', 'CADCOR');
    $('#btnFuncionario').pesquisa('#txtFuncionario', 'CODIGO', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"PESSOAL", "camposSelect":[ "CODIGO", "NOME"]}`, 'Pesquisa Funcionário', 'PESSOAL');
    $('#btnTpBaixa').pesquisa('#txtTpBaixa', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABBAI", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Tipo de Baixa', 'TABBAI');
    $('#btnLocalEntrada').pesquisa('#txtLocalEntrada', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CAD_LOC_ESTOQ", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Local', 'CAD_LOC_ESTOQ');

    if (existeDepositoEmpresa.EMP_DEPOSITO.length <= 0) {
        $('#btnDeposito').pesquisa('#txtDeposito', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Depósito', 'DEPOSITO');
        $('#btnDepositoEntrada').pesquisa('#txtDepositoEntrada', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Depósito', 'DEPOSITO');
        $('#txtDepositoEntrada').autocompleta(1, `JSON={ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
        $('#txtDeposito').autocompleta(1, `JSON={ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
    } else {
        $('#btnDeposito').pesquisa('#txtDeposito', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO", "DESCRICAO"], "where":["CODIGO IN (${existeDepositoEmpresa.EMP_DEPOSITO})"]}`, 'Pesquisa Depósito', 'DEPOSITO');
        $('#btnDepositoEntrada').pesquisa('#txtDepositoEntrada', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO", "DESCRICAO"], "where":["CODIGO IN (${existeDepositoEmpresa.EMP_DEPOSITO})"]}`, 'Pesquisa Depósito', 'DEPOSITO');
        $('#txtDepositoEntrada').autocompleta(1, `JSON={ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where":["CODIGO IN (${existeDepositoEmpresa.EMP_DEPOSITO})"]}`);
        $('#txtDeposito').autocompleta(1, `JSON={ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where":["CODIGO IN (${existeDepositoEmpresa.EMP_DEPOSITO})"]}`);
        ;
    }

    $("#btnLimpaMaterial").on("click", function () {
        $("#txtMaterial").val("");
    })

    $("#btnLimpaCor").on("click", function () {
        $("#txtCor").val("");
    })

    $("#btnLimpaDeposito").on("click", function () {
        $("#txtDeposito").val("");
    })

    $("#btnLimpaFuncionario").on("click", function () {
        $("#txtFuncionario").val("");
    })

    $("#btnLimpaTpBaixa").on("click", function () {
        $("#txtTpBaixa").val("");
    })

    $("#btnLimpaDepositoEntrada").on("click", function () {
        $("#txtDepositoEntrada").val("");
    })

    $("#btnLimpaLocalEntrada").on("click", function () {
        $("#txtLocalEntrada").val("");
    })


    $('#txtLargura').maskMoney({
        decimal: '.',
        thousands: '',
        precision: 2
    });

    $('#txtGramatura').maskMoney({
        decimal: '.',
        thousands: '',
        precision: 2
    });

    $('#txtTara').maskMoney({
        decimal: '.',
        thousands: '',
        precision: 2
    });

    $("#txtLargura").on("blur", function () {
        if ($("#txtLargura").val() == "" || $("#txtLargura").val() == "0") {
            $("#txtLargura").val("0.00");
        }
    })

    $("#txtGramatura").on("blur", function () {
        if ($("#txtGramatura").val() == "" || $("#txtGramatura").val() == "0") {
            $("#txtGramatura").val("0.00");
        }
    })

    $("#txtQtdeRolo").on("blur", function () {
        if ($("#txtQtdeRolo").val() == "") {
            $("#txtQtdeRolo").val("0");
        }
    })

    $("#txtTara").on("blur", function () {
        if ($("#txtTara").val() == "" || $("#txtTara").val() == "0") {
            $("#txtTara").val("0.00");
        }
    })

    $("#btnConsultar").on("click", async function () {
        $.LoadingOverlay("show");
        $("#btnConsultar").prop("disabled", true);
        try {
            await consultaDesdobraLote();
            $("#txtLargura").val("0.00");
            $("#txtGramatura").val("0.00");
            $("#txtTara").val("0.00");
        } finally {
            $.LoadingOverlay("hide");
            $("#btnConsultar").prop("disabled", false);
        }

    })

    $("#btnLimparTela").on("click", async function () {
        limparTela();
        await carregaValoresPadroes();
        await carregaFuncionarioUsuario();
    })

    $("#btnDistribuir").on("click", async function () {
        $.LoadingOverlay("show");
        $("#btnDistribuir").prop("disabled", true);
        try {
            await distribuiLote();
        } finally {
            $.LoadingOverlay("hide");
            $("#btnDistribuir").prop("disabled", false);
        }
    })

    $("#btnGravar").on("click", async function () {
        $.LoadingOverlay("show");
        $("#btnGravar").prop("disabled", true);
        try {


            let bZeraLote = false;
            const saldo = $("#txtSaldo").val();

            if (saldo < 0) {
                throw msgAlerta("Não é possível realizar a operação, saldo negativo.");
            } else {
                if (parametrosMaterial[1].VALOR == '1') {
                    $('#modal-expedicao').modal('show');
                } else {
                    await gravaDesdobraLote(bZeraLote);
                }
            }

        } finally {
            $.LoadingOverlay("hide");
            $("#btnGravar").prop("disabled", false);
        }
    });

    $("#txtLote").on("blur", function () {
        if ($("#txtLote").val() != "") {
            $("#btnConsultar").trigger("click");
        }
    });

    $('#cbEtiquetaTAG').on('click', function () {
        if ($('#cbEtiquetaTAG').prop('checked')) {
            retornaHintRelatorio('btnImprimir', 'desdobraloteTAG')
        } else {
            retornaHintRelatorio('btnImprimir', 'desdobralote')
        }
    })
    retornaHintRelatorio('btnImprimir', 'desdobralote')

    $('#btnImprimir').on('click', async function () {
        $.LoadingOverlay("show");
        try {
            const filtros = retornaFiltros(true);
            const url = `/sisplan/impressao/v1/imprimirdesdobralote?${filtros}`;
            const bImprimeAutomatico = await verificaImprimirAutomatico("DesdobraLote");
            const arquivo = await GeraRelatorio(url, "GET", 100000, false, "DesdobraLote");

            if (arquivo != undefined) {
                if (!bImprimeAutomatico) {
                    window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, "_blank");
                }
                await limparRelatorios();
            }

        } catch (error) {
            console.error(error);
        } finally {
            $.LoadingOverlay("hide");
        }
    });

    async function consultaDesdobraLote() {
        try {
            const params = retornaFiltros();

            const response = await requisicao("GET", "/sisplan/desdobralote/v1/consultadesdobralote?", params, '', 120000);

            if (!response) {
                throw msgAlerta("Não foi possível realizar a consulta do lote.");
            }

            const jsonStr = await response.json();
            if (response.status != 200) {
                throw msgAlerta(jsonStr.mensagem);
            }

            // if (jsonStr[0].length == 0 && jsonStr[1].length == 0) {
            //     return;
            // } 

            if ($.fn.DataTable.isDataTable('#tabelaLotes')) {
                $("#tabelaLotes").DataTable().data().clear().draw(false);
            }

            if ($.fn.DataTable.isDataTable('#tabelaLotesDesdobrados')) {
                $("#tabelaLotesDesdobrados").DataTable().data().clear().draw(false);
            }

            if (jsonStr[0].length > 0) {

                const dataSetCols = [];
                const keys = Object.keys(jsonStr[0][0]);
                for (var k in keys) {
                    dataSetCols.push({
                        'title': keys[k],
                        'data': keys[k]
                    });
                };

                criaDataTablePadrao('#tabelaLotes',
                    false,
                    false,
                    false,
                    false,
                    true,
                    true,
                    false,
                    jsonStr[0],
                    dataSetCols,
                    [1, 2, 5, 6, 11, 12, 14, 15, 18, 19, 25, 26, 27, 29, 30, 31, 33, 34],
                    [22, 23],
                    [],
                    [],
                    {},
                    2,
                    '',
                    '',
                    false,
                    [3, 8, 9, 16, 17, 21, 24, 28, 32]);

                $('#tabelaLotes tbody').unbind('click');
                $('#tabelaLotes tbody').on('click', 'tr', async function () {
                    if ($(this).hasClass('selected')) {
                        $(this).removeClass('selected');
                    } else {
                        $('#tabelaLotes').DataTable().$('tr.selected').removeClass('selected');
                        $(this).addClass('selected');
                    }
                });

                $("#tabelaLotes tbody").unbind("dblclick");
                $("#tabelaLotes tbody").on("dblclick", "tr", async function () {
                    $.LoadingOverlay("show");
                    try {
                        const registroSelecionado = $("#tabelaLotes").DataTable().row($(this)).data();

                        insereValor("#txtMaterial", registroSelecionado.COD_MATERIAL, registroSelecionado.DESC_MATERIAL);
                        insereValor("#txtCor", registroSelecionado.COD_COR, registroSelecionado.DESC_COR);

                        await consultaDesdobraLote();
                        $("#txtLargura").val(registroSelecionado.LARGURA);
                        $("#txtGramatura").val(registroSelecionado.GRAMATURA);
                        $("#txtTara").val(registroSelecionado.TARA);
                        $("#txtLargura").trigger("blur");
                        $("#txtGramatura").trigger("blur");
                        $("#txtTara").trigger("blur");
                    } finally {
                        $.LoadingOverlay("hide");

                    }

                })

                if (jsonStr[0].length == 1) {
                    $($('#tabelaLotes tbody tr')[0]).trigger('click');
                }


            }

            if (jsonStr[1].length > 0 && jsonStr[0].length > 0) {

                const dataSetCols = [];
                const keys = Object.keys(jsonStr[1][0]);
                for (var k in keys) {
                    dataSetCols.push({
                        'title': keys[k],
                        'data': keys[k]
                    });
                };

                jsonStr[1].forEach(item => {
                    // const codigoMaterial = item.MATERIAL.split("-")[0].slice(0, -1);
                    // const codigoCor = item.COR.split("-")[0].slice(0, -1);
                    // item.QTDE = `<input style="width: 5rem;" type="number" id="txtQtdeGrid${item.LOTE}" class="qtdeGrid M${item.COD_MATERIAL}-C${item.COD_COR} focus form-control" qtdeOld="${item.QTDE}" value="${item.QTDE}">`;
                    item.QTDE = `<input style="width: 5rem;" type="number" id="txtQtdeGrid${item.LOTE}" class="qtdeGrid M${item.COD_MATERIAL}-C${item.COD_COR} focus form-control" value="${item.QTDE}" readonly>`;
                });

                criaDataTablePadrao('#tabelaLotesDesdobrados',
                    false,
                    false,
                    false,
                    false,
                    true,
                    true,
                    false,
                    jsonStr[1],
                    dataSetCols,
                    [1, 2, 5, 6, 10, 11, 13, 14, 17, 23, 25, 26, 28, 29, 30, 31, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46],
                    [21, 22],
                    [],
                    [],
                    {},
                    2,
                    '',
                    '',
                    false,
                    [3, 15, 16, 18, 19, 20, 27, 32, 33, 34]);
            }

            adicionaEventoBlurQtde();
            adicionaEventoPesoBalanca();
            $(".qtdeGrid").trigger("blur");
            if ($.fn.DataTable.isDataTable('#tabelaLotesDesdobrados')) {
                setTimeout(function () {
                    $("#tabelaLotesDesdobrados").DataTable().columns.adjust().draw(false);
                    $("#tabelaLotesDesdobrados").DataTable().columns.adjust().draw(false);
                }, 100);
            }

        } catch (error) {
            console.error(error);
        }
    }

    function limparTela() {
        $("#txtLote").val("");
        $("#txtMaterial").val("");
        $("#txtCor").val("");
        $("#txtDeposito").val("");
        $("#txtFuncionario").val("");
        $("#cbLoteExato").prop("checked", false);
        $("#cbPositivos").prop("checked", false);
        $("#cbEtiquetaTAG").prop("checked", false);
        $("#txtTpBaixa").val("");
        $("#txtDepositoEntrada").val("");
        $("#txtLocalEntrada").val("");
        $("#txtObservacao").val("");
        $("#txtLargura").val("0.00");
        $("#txtGramatura").val("0.00");
        $("#txtQtdeRolo").val("0");
        $("#txtTara").val("0.00");
        if ($.fn.DataTable.isDataTable('#tabelaLotes')) {
            $("#tabelaLotes").DataTable().data().clear().draw(false);
        }
        if ($.fn.DataTable.isDataTable('#tabelaLotesDesdobrados')) {
            $("#tabelaLotesDesdobrados").DataTable().data().clear().draw(false);
        }
    }

    function retornaFiltros(bImpressao = false) {
        const qtdeRolos = $("#txtQtdeRolo").val() == '0' ? 0 : $("#txtQtdeRolo").val();
        const lote = $("#txtLote").val();
        const material = pegaChave("#txtMaterial");
        const cor = pegaChave("#txtCor");
        const deposito = pegaChave("#txtDeposito");
        const loteExato = $("#cbLoteExato").prop("checked");
        const somentePositivos = $("#cbPositivos").prop("checked");
        const etiquetaTAG = $("#cbEtiquetaTAG").prop("checked");
        const numeroRolos = bImpressao ? qtdeRolos : 0;

        return `LOTE=${lote}` +
            `&MATERIAL=${material}` +
            `&COR=${cor}` +
            `&DEPOSITO=${deposito}` +
            `&LOTE_EXATO=${loteExato}` +
            `&SOMENTE_POSITIVOS=${somentePositivos}` +
            `&ETIQUETA_TAG=${etiquetaTAG}` +
            `&ROLOS_DESDOBRADOS=${numeroRolos}`;
    }

    async function distribuiLote() {
        const registroSelecionado = $("#tabelaLotes").DataTable().rows(".selected").data().toArray();

        if (registroSelecionado.length <= 0) {
            throw msgAlerta("Nenhum registro selecionado para desdobrar o lote, necessário selecionar um registro no grid.")
        }

        // const material = registroSelecionado[0].MATERIAL.split("-")[0].slice(0, -1);
        const material = registroSelecionado[0].COD_MATERIAL;
        const depositoEntrada = pegaChave("#txtDepositoEntrada");
        // const local = pegaChave("#txtLocalEntrada");
        const qtdeRolo = parseInt($("#txtQtdeRolo").val());
        const existeReservaPendente = await verificaReservaPendente(registroSelecionado[0].LOTE);

        if (registroSelecionado[0].LOTE == "") {
            throw msgAlerta("Lote não informado, necessário informar um lote para prosseguir.");
        }

        if (material == "") {
            throw msgAlerta("Nenhum material informado, necessário informar um material para prosseguir.");
        }

        if (depositoEntrada == "") {
            throw msgAlerta("Nenhum depósito informado, necessário informar um depósito de entrada para prosseguir.");
        }

        if (registroSelecionado[0].QTDE <= 0) {
            throw msgAlerta("Lote selecionado sem quantidade para distribuir.");
        }

        // if (local != "") {
        //     if (await buscaValor("CAD_LOCAL_ESTOQ", "CODIGO", "CODIGO", local) == "") {
        //         throw msgAlerta("Local não encontrado. Verifique!");
        //     }
        // }

        if (qtdeRolo == 0 || qtdeRolo == "") {
            throw msgAlerta("Nenhuma quantidade informada para desdobrar, necessário informar uma quantidade no campo Qtde Rolo para prosseguir.");
        }

        if (existeReservaPendente) {
            throw msgAlerta("Existem reservas pendentes para esse lote, impossível continuar.");
        }

        const lotesDesdobrados = await montaObjetoLoteDesdobrado(registroSelecionado[0], qtdeRolo);

        if ($.fn.DataTable.isDataTable('#tabelaLotesDesdobrados')) {
            $('#tabelaLotesDesdobrados').DataTable().clear();
            $('#tabelaLotesDesdobrados').DataTable().rows.add(lotesDesdobrados).draw(false);
        } else {
            const dataSetCols = [];
            const keys = Object.keys(lotesDesdobrados[0]);
            for (var k in keys) {
                dataSetCols.push({
                    'title': keys[k],
                    'data': keys[k]
                });
            };

            criaDataTablePadrao('#tabelaLotesDesdobrados',
                false,
                false,
                false,
                false,
                true,
                true,
                false,
                lotesDesdobrados,
                dataSetCols,
                [1, 2, 5, 6, 10, 11, 13, 14, 17, 23, 25, 26, 28, 29, 30, 31, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46],
                [21, 22],
                [],
                [],
                {},
                2,
                '',
                '',
                false,
                [3, 15, 16, 18, 19, 20, 27, 32, 33, 34]);
        }

        adicionaEventoBlurQtde();
        adicionaEventoPesoBalanca();

    }

    async function verificaReservaPendente(lote) {
        const pesquisa = {
            tabela: "PED_RESERVA",
            camposSelect: ["NUMERO"],
            where: [`QTDE > 0 AND LOTE = '${lote}'`]
        }

        const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

        if (jsonStr.length <= 0) {
            return false;
        }

        return jsonStr[0].NUMERO != "";
    }

    async function montaObjetoLoteDesdobrado(item, qtdeRolo) {
        let bPossuiDesdobradosGrid = false;
        if ($.fn.DataTable.isDataTable('#tabelaLotesDesdobrados')) {
            bPossuiDesdobradosGrid = $("#tabelaLotesDesdobrados").DataTable().data().toArray().length > 0;
        }
        // const lotesDesdobrados = $.fn.DataTable.isDataTable('#tabelaLotesDesdobrados') ? $("#tabelaLotesDesdobrados").DataTable().data().toArray().length > 0 ? $("#tabelaLotesDesdobrados").DataTable().data().toArray() : [] : [];
        const lotesDesdobrados = bPossuiDesdobradosGrid ? $("#tabelaLotesDesdobrados").DataTable().data().toArray() : [];

        // const loteFilho = await retornaMaximoLote(item.LOTE, bPossuiDesdobradosGrid);
        const sequencialMaximo = await retornaMaximoLote(item.LOTE, bPossuiDesdobradosGrid);
        // let sequencial = loteFilho != "" ? parseInt(loteFilho.slice(-tamanhoSequencialLoteDesdobrado)) + 1 : 1;
        let sequencial = sequencialMaximo != "" ? parseInt(sequencialMaximo) + 1 : 1;

        const tara = $("#txtTara").val();
        const depositoEntrada = $("#txtDepositoEntrada").val();
        const localEntrada = $("#txtLocalEntrada").val();
        // const codigoMaterial = item.MATERIAL.split("-")[0].slice(0, -1);
        const codigoMaterial = item.COD_MATERIAL;
        // const codigoCor = item.COR.split("-")[0].slice(0, -1);
        const codigoCor = item.COD_COR;
        const dadosMaterial = await buscaDadosMaterial(codigoMaterial);
        const observacao = $("#txtObservacao").val();
        const largura = $("#txtLargura").val();
        const gramatura = $("#txtGramatura").val();
        for (let i = 0; i < qtdeRolo; i++) {
            const obj = {
                MATERIAL: item.MATERIAL,
                COD_MATERIAL: codigoMaterial,
                DESC_MATERIAL: item.DESC_MATERIAL,
                UNIDADE: item.UNIDADE,
                COR: item.COR,
                COD_COR: codigoCor,
                DESC_COR: item.DESC_COR,
                LOTE: item.LOTE + sequencial.toString().padStart(tamanhoSequencialLoteDesdobrado, '0'),
                QTDE: `<input style="width: 5rem;" type="number" id="txtQtdeGrid${item.LOTE + sequencial.toString().padStart(tamanhoSequencialLoteDesdobrado, '0')}" class="qtdeGrid M${codigoMaterial}-C${codigoCor} focus form-control" value="0">`,
                DEPOSITO: pegaChave(depositoEntrada) + " - " + pegaDescricao(depositoEntrada),
                COD_DEPOSITO: pegaChave(depositoEntrada),
                DESC_DEPOSITO: pegaDescricao(depositoEntrada),
                LOCAL: localEntrada != "" ? pegaChave(localEntrada) + " - " + pegaDescricao(localEntrada) : "",
                COD_LOCAL: pegaChave(localEntrada),
                DESC_LOCAL: pegaDescricao(localEntrada),
                NRROLO: sequencial,
                QTDE_EST: 0, // NAO PREENCHE NO ERP
                QTDE_ORIG_REPRO: 0, // NAO PREENCHE NO ERP
                LARGURA: largura,
                GRAMATURA: gramatura != 0 ? gramatura : dadosMaterial.GRAMATURA,
                QUALIDADE: item.QUALIDADE,
                DT_FAB: item.DT_FAB,
                DT_VAL: item.DT_VAL,
                RESERVA: 0,
                USUARIO: getCookie("usuario"),
                EDICAO: "S",
                REPROCESSO: "N", // NAO PREENCHE NO ERP
                PRECO_COMPRA: item.PRECO_COMPRA,
                BARRA: await RetornaProximo("MAT_ITEN", "MAT_ITEN", "BARRA", 0),
                // BARRA2: item.MATERIAL.split("-")[0].slice(0, -1) + "*" + item.COR.split("-")[0].slice(0, -1) + "*" + item.LOTE + sequencial.toString().padStart(4, '0'),
                BARRA2: codigoMaterial + "*" + codigoCor + "*" + item.LOTE + sequencial.toString().padStart(tamanhoSequencialLoteDesdobrado, '0'),
                QTDE_ORIG_LOTE: 0, // NÃO PREENCHE NO ERP
                QTDE_ORIG: 0, // NÃO PREENCHE NO ERP
                PRECO_MED: item.PRECO,
                CUSTO_KG: 0, // NÃO PREENCHE NO ERP
                TARA: tara,
                OBS: observacao,
                // CODIGO_ANTERIOR: item.MATERIAL.split("-")[0].slice(0, -1),
                CODIGO_ANTERIOR: codigoMaterial,
                // DESC_ANTERIOR: item.MATERIAL.split("-")[1].substring(1),
                DESC_ANTERIOR: item.DESC_MATERIAL,
                NATUREZA: "", // NAO PREENCHE NO ERP
                CODIGO2: dadosMaterial.CODIGO2,
                DESCRICAO2: dadosMaterial.DESCRICAO2,
                CONCENTRACAO: dadosMaterial.CONCENTRACAO,
                ID_MAT_ITEN: 0, // NAO PREENCHE NO ERP
                ID_MAT_ITEN_ANT: item.ID_MAT_ITEN,
                ID_NF_ENTRA_ITEN: item.ID_NF_ENTRA_ITEN,
                DIVISOR: dadosMaterial.DIVISOR,
                FUNC: "", // NAO PREENCHE NO ERP
                DEPOSITO_SAIDA: item.COD_DEPOSITO,
            }
            lotesDesdobrados.push(obj);
            sequencial++;
        }
        return lotesDesdobrados;
    }

    // async function retornaMaximoLote(lote, bPossuiDesdobradosGrid) {
    //     const url = "/sisplan/desdobralote/v1/retornamaximolote?";
    //     const params = `LOTE=${lote}`+
    //                    `&TAM_SEQ_LOTE_DESDOBRADO=${tamanhoSequencialLoteDesdobrado}`
    //     let jsonStr = "";
    //     try {

    //         const response = await requisicao("GET", url, params, "", 300000);

    //         if (!response) {
    //             console.error("Não foi possível retornar o lote máximo do banco.");
    //         }

    //         if (response.status == 200) {
    //             jsonStr = await response.text();
    //         } else {
    //             const json = await response.json();
    //             console.error(`Não foi possível retornar o lote máximo do banco \n ${json.mensagem}`);                
    //         }

    //         // const loteMaximoGrid = bPossuiDesdobradosGrid ? $("#tabelaLotesDesdobrados").DataTable().column(7).data().toArray().reduce((loteMaximo, lote) => lote > loteMaximo ? lote : loteMaximo) : "";
    //         // const loteMaximoGrid = bPossuiDesdobradosGrid ? $("#tabelaLotesDesdobrados").DataTable().column(7).data().toArray().reduce((loteMaximo, loteRed) => loteMaximo > loteRed.substr(0, lote.length + 4) ? loteMaximo : loteRed.substr(0, lote.length + 4)) : "";
    //         // const regexPadrao = new RegExp(`^${lote}\\d{${tamanhoSequencialLoteDesdobrado}}$`);
    //         const regexPadrao = new RegExp(`^${lote}\\d{1,4}$`);
    //         // const loteMaximoGrid = bPossuiDesdobradosGrid ? $("#tabelaLotesDesdobrados").DataTable().column(7).data().toArray().filter(lote => regexPadrao.test(lote)).reduce((loteMaximo, lote) => lote > loteMaximo ? lote : loteMaximo) : "";
    //         let loteMaximoGrid = "";
    //         if (bPossuiDesdobradosGrid) {
    //             const lotesFiltrados = $("#tabelaLotesDesdobrados").DataTable().column(7).data().toArray().filter(lote => regexPadrao.test(lote));
    //             const sequenciaisLotesFiltrados = lotesFiltrados.map(loteFiltrado => parseInt(loteFiltrado.substring(lote.length)));
    //             if (lotesFiltrados.length > 0) {
    //                 // loteMaximoGrid = lotesFiltrados.reduce((loteMaximo, loteFiltrado) => loteFiltrado > loteMaximo ? loteFiltrado : loteMaximo);
    //                 loteMaximoGrid = sequenciaisLotesFiltrados.reduce((sequencialMaximo, sequencialFiltrado) => sequencialFiltrado > sequencialMaximo ? sequencialFiltrado : sequencialMaximo);
    //             } 
    //         } 

    //         if (jsonStr == "" && !bPossuiDesdobradosGrid) {
    //             console.error("Não existe lote máximo no banco e não possui lote desdobrado no grid.");
    //             return "";
    //         }

    //         const loteMaximoBancoValidado = validaSequencialPadrao(lote, jsonStr);
    //         const loteMaximoGridValidado = validaSequencialPadrao(lote, loteMaximoGrid);

    //         return loteMaximoGridValidado > loteMaximoBancoValidado ? loteMaximoGridValidado : loteMaximoBancoValidado;

    //     } catch (error) {
    //         console.error(error);
    //         return "";
    //     }

    // }

    async function retornaMaximoLote(lote, bPossuiDesdobradosGrid) {
        const url = "/sisplan/desdobralote/v1/retornasequencialmaximo?";
        const params = `LOTE=${lote}`;
        let jsonStr = "";
        try {

            const response = await requisicao("GET", url, params, "", 300000);

            if (!response) {
                console.error("Não foi possível retornar o lote máximo do banco.");
            }

            if (response.status == 200) {
                jsonStr = await response.text();
            } else {
                const json = await response.json();
                console.error(`Não foi possível retornar o lote máximo do banco \n ${json.mensagem}`);
            }

            const regexPadrao = new RegExp(`^${lote}\\d{1,4}$`);

            let sequencialMaximoGrid = "";
            if (bPossuiDesdobradosGrid) {
                const lotesFiltrados = $("#tabelaLotesDesdobrados").DataTable().data().toArray().filter(registro => regexPadrao.test(registro.LOTE));
                const sequenciaisLotesFiltrados = lotesFiltrados.map(loteFiltrado => parseInt(loteFiltrado.NRROLO));
                if (sequenciaisLotesFiltrados.length > 0) {
                    sequencialMaximoGrid = sequenciaisLotesFiltrados.reduce((sequencialMaximo, sequencialFiltrado) => sequencialFiltrado > sequencialMaximo ? sequencialFiltrado : sequencialMaximo);
                }
            }

            if (jsonStr == "" && !bPossuiDesdobradosGrid) {
                console.error("Não existe lote máximo no banco e não possui lote desdobrado no grid.");
                return "";
            }

            // const loteMaximoBancoValidado = validaSequencialPadrao(lote, jsonStr);
            // const loteMaximoGridValidado = validaSequencialPadrao(lote, loteMaximoGrid);

            return parseInt(sequencialMaximoGrid) > parseInt(jsonStr) ? sequencialMaximoGrid : jsonStr;

        } catch (error) {
            console.error(error);
            return "";
        }

    }

    function validaSequencialPadrao(lotePrincipal, loteFilho) {
        // const regexPadrao = new RegExp(`^${lotePrincipal}\\d{${tamanhoSequencialLoteDesdobrado}}$`);
        const regexPadrao = new RegExp(`^${lotePrincipal}\\d{1,4}$`);

        if (regexPadrao.test(loteFilho)) {
            return loteFilho
        } else {
            return ""
        }

    }

    async function buscaDadosMaterial(codigo) {
        const pesquisa = {
            tabela: "MATERIAL",
            camposSelect: ["CODIGO2, DESCRICAO2, GRAMATURA, CONCENTRACAO, DIVISOR"],
            where: [`CODIGO = '${codigo}'`]
        }

        const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

        return jsonStr[0];

    }

    function adicionaEventoBlurQtde() {
        $(".qtdeGrid").unbind("blur");
        $(".qtdeGrid").on("blur", function () {
            if ($(this).val() == "") {
                $(this).val(0);
            }
            atualizaTotais();
            atualizaBaixas(this);
            // atualizaEdicao(this);
        })
    }

    function adicionaEventoPesoBalanca() {
        $(".qtdeGrid").unbind("keydown");
        $(".qtdeGrid").on("keydown", async function (e) {
            if (e.which == 115) {
                const peso = await buscaPesoBalanca(1, parametrosVenda[74]);
                $(this).val(parseFloat(peso.replace(",", ".")));
            }
        })
    }

    function atualizaTotais() {
        // const qtdeTotalLotes = $("#tabelaLotes").DataTable().column(4).data().sum();
        const qtdeTotalLotes = $("#tabelaLotes").DataTable().column(8).data().sum();
        const qtdeTotalLotesDesdobrados = parseFloat($(".qtdeGrid").toArray().reduce((qtdeTotal, input) => qtdeTotal + parseFloat($(input).val()), 0).toFixed(2));
        const qtdeEstLotesDesdobrados = $("#tabelaLotesDesdobrados").DataTable().column(16).data().sum();
        $("#txtTotalLote").val(qtdeTotalLotes + qtdeEstLotesDesdobrados);
        $("#txtTotalBaixa").val(qtdeTotalLotesDesdobrados);
        const saldo = parseFloat((parseFloat($("#txtTotalLote").val()) - qtdeTotalLotesDesdobrados).toFixed(2));
        $("#txtSaldo").val(saldo);
    }

    function atualizaBaixas(elemento) {
        // const rowQtdeAlterada = $("#tabelaLotesDesdobrados").DataTable().rows($(elemento).closest('tr')).data().toArray().map(obj => { return { MATERIAL: obj.MATERIAL, COR: obj.COR } });
        const rowQtdeAlterada = $("#tabelaLotesDesdobrados").DataTable().rows($(elemento).closest('tr')).data().toArray().map(obj => { return { COD_MATERIAL: obj.COD_MATERIAL, COD_COR: obj.COD_COR, DEPOSITO_SAIDA: obj.COD_DEPOSITO } });
        // const codigoMaterial = rowQtdeAlterada[0].MATERIAL.split("-")[0].slice(0, -1);
        const codigoMaterial = rowQtdeAlterada[0].COD_MATERIAL;
        // const codigoCor = rowQtdeAlterada[0].COR.split("-")[0].slice(0, -1);
        const codigoCor = rowQtdeAlterada[0].COD_COR;
        // const lotes = $("#tabelaLotes").DataTable().data().toArray().map(obj => { return { MATERIAL: obj.MATERIAL, COR: obj.COR } });
        const codDepositoSaida = rowQtdeAlterada[0].DEPOSITO_SAIDA
        const lotes = $("#tabelaLotes").DataTable().data().toArray().map(obj => { return { COD_MATERIAL: obj.COD_MATERIAL, COD_COR: obj.COD_COR, DEPOSITO_SAIDA: obj.COD_DEPOSITO } });
        // const index = lotes.findIndex(lote => { return lote.MATERIAL == rowQtdeAlterada[0].MATERIAL && lote.COR == rowQtdeAlterada[0].COR });
        const index = lotes.findIndex(lote => { return lote.COD_MATERIAL == codigoMaterial && lote.COD_COR == codigoCor && lote.DEPOSITO_SAIDA == codDepositoSaida });
        // const qtde = $(`.M${codigoMaterial}-C${codigoCor}`).toArray().reduce((qtdeTotal, input) => qtdeTotal + parseInt($(input).val()), 0);
        const qtde = Array.from(document.getElementsByClassName(`M${codigoMaterial}-C${codigoCor}`)).reduce((qtdeTotal, input) => qtdeTotal + parseFloat($(input).val()), 0);

        if (index != -1) {
            // $("#tabelaLotes").DataTable().cell(index, 5).data(qtde);
            $("#tabelaLotes").DataTable().cell(index, 9).data(qtde);
        }

    }

    // function atualizaEdicao(elemento) {
    //     const qtde = $(elemento).val();
    //     const rowAlteracao = $("#tabelaLotesDesdobrados").DataTable().row($(elemento).closest('tr'))[0];
    //     const qtdeOrig = parseInt($(elemento).attr("qtdeOld"));

    //     if (qtde == qtdeOrig) {
    //         // $("#tabelaLotesDesdobrados").DataTable().cell(rowAlteracao, 16).data("N");
    //         $("#tabelaLotesDesdobrados").DataTable().cell(rowAlteracao, 24).data("N");
    //     } else {
    //         // $("#tabelaLotesDesdobrados").DataTable().cell(rowAlteracao, 16).data("S");
    //         $("#tabelaLotesDesdobrados").DataTable().cell(rowAlteracao, 24).data("S");
    //     }
    // }

    async function gravaDesdobraLote(bZeraLote) {
        try {

            const response = await requisicao("POST", "/sisplan/desdobralote/v1/gravadesdobralote?", montaObjetoGravarLote() + `&ZERALOTE=${bZeraLote}`, "", 300000);

            if (!response) {
                throw msgAlerta("Não foi possível gravar o desdobramento do lote.");
            }

            if (response.status != 200) {
                throw msgAlerta("Não foi possível gravar o desdobramento do lote.");
            }

            // criaMensagemSucesso("Desdobramento do lote gravado com sucesso", () => { window.location.reload(); });

            criaMensagemSucesso("Desdobramento do lote gravado com sucesso", async () => {
                $("#btnConsultar").trigger("click");
                await sleep(4000);
                if ($('#cbImprimirAoGravar').prop('checked')) {
                    console.log('imprimiu automatico');
                    $('#btnImprimir').trigger('click');
                }
            });

        } catch (error) {
            console.error(error);
        }
    }

    function montaObjetoGravarLote() {
        const tabelaLotesDesdobrados = $("#tabelaLotesDesdobrados").DataTable().data().toArray().filter(lotesDesdobrados => lotesDesdobrados.EDICAO == "S");
        const tabelaLotes = $("#tabelaLotes").DataTable().data().toArray();
        // const lotesPai = $("#tabelaLotes").DataTable().data().toArray().map(obj => { return { MATERIAL: obj.MATERIAL, COR: obj.COR } });
        const lotesPai = $("#tabelaLotes").DataTable().data().toArray().map(obj => { return { COD_MATERIAL: obj.COD_MATERIAL, COD_COR: obj.COD_COR, DEPOSITO_SAIDA: obj.COD_DEPOSITO } });
        const listaLotesDesdobrados = [];
        const listaLotes = [];

        tabelaLotesDesdobrados.forEach(lotesDesdobrados => {
            // const codigoMaterial = lotesDesdobrados.MATERIAL.split("-")[0].slice(0, -1);
            const codigoMaterial = lotesDesdobrados.COD_MATERIAL;
            // const codigoCor = lotesDesdobrados.COR.split("-")[0].slice(0, -1);
            const codigoCor = lotesDesdobrados.COD_COR;
            // const deposito = lotesDesdobrados.DEPOSITO.split("-")[0].slice(0, -1);
            const deposito = lotesDesdobrados.COD_DEPOSITO;
            // const local = lotesDesdobrados.LOCAL.split("-")[0].slice(0, -1);
            const local = lotesDesdobrados.COD_LOCAL;
            // const indexTabelaLotes = lotesPai.findIndex(lote => { return lote.MATERIAL == lotesDesdobrados.MATERIAL && lote.COR == lotesDesdobrados.COR });
            const indexTabelaLotes = lotesPai.findIndex(lote => { return lote.COD_MATERIAL == lotesDesdobrados.COD_MATERIAL && lote.COD_COR == lotesDesdobrados.COD_COR && lote.DEPOSITO_SAIDA == lotesDesdobrados.DEPOSITO_SAIDA });
            const qtde = document.getElementById($(lotesDesdobrados.QTDE)[0].id).value;
            // const qtdeOld = document.getElementById($(lotesDesdobrados.QTDE)[0].id).getAttribute('qtdeOld');
            // const qtdeOld = lotesDesdobrados.QTDE_ORIG_REPRO;

            const objLoteDesdobrado = {
                CODIGO: codigoMaterial,
                COR: codigoCor,
                DEPOSITO: deposito,
                LOTE: lotesDesdobrados.LOTE,
                ID_MAT_ITEN: lotesDesdobrados.ID_MAT_ITEN,
                TIPOBAIXA: pegaChave("#txtTpBaixa"), //PEGAR VINCULO DA TABELA
                QUALIDADE: lotesDesdobrados.QUALIDADE,
                FUNCIONARIO: lotesDesdobrados.FUNC,
                // QTDE: qtde - qtdeOld,
                QTDE: qtde,
                // FORNECEDOR deixei de fora
                LOCAL: local,
                LARGURA: lotesDesdobrados.LARGURA,
                BARRA: lotesDesdobrados.BARRA,
                DT_FAB: lotesDesdobrados.DT_FAB,
                QTDE_ORIG: qtde,
                QTDE_ORIG_T: qtde,
                OBS: lotesDesdobrados.OBS,
                NATUREZA: lotesDesdobrados.NATUREZA,
                DT_VAL: lotesDesdobrados.DT_VAL,
                GRAMATURA: lotesDesdobrados.GRAMATURA,
                ID_MAT_ITEN_ANT: lotesDesdobrados.ID_MAT_ITEN_ANT,
                PRECO_MED: lotesDesdobrados.PRECO_MED,
                LOTE_ANT: lotesDesdobrados.LOTE.slice(0, -tamanhoSequencialLoteDesdobrado),
                NRROLO: lotesDesdobrados.NRROLO,
                ID_NF_ENTRA_ITEN: lotesDesdobrados.ID_NF_ENTRA_ITEN,
                PRECO: tabelaLotes[indexTabelaLotes].PRECO_COMPRA,
                DEPOSITO_SAIDA: tabelaLotes[indexTabelaLotes].COD_DEPOSITO,
            }

            listaLotesDesdobrados.push(objLoteDesdobrado);

        })

        const codMatCodCorLotesDesdobrados = [];
        listaLotesDesdobrados.forEach(lotesDesdobrados => {
            // const codMatCodCorValidacao = `M${lotesDesdobrados.CODIGO}-C${lotesDesdobrados.COR}`;
            const codMatCodCorValidacao = `M${lotesDesdobrados.CODIGO}&C${lotesDesdobrados.COR}&D${lotesDesdobrados.DEPOSITO_SAIDA}`;
            if (codMatCodCorLotesDesdobrados.length <= 0) {
                codMatCodCorLotesDesdobrados.push(codMatCodCorValidacao);
            } else if (codMatCodCorLotesDesdobrados.findIndex(codMatCodCor => codMatCodCor == codMatCodCorValidacao) == -1) {
                codMatCodCorLotesDesdobrados.push(codMatCodCorValidacao);
            };

        })

        codMatCodCorLotesDesdobrados.forEach(codMatCodCor => {
            // const codigoMaterial = codMatCodCor.split("-")[0].substring(1);
            const codigoMaterial = codMatCodCor.split("&")[0].substring(1);
            // const codigoCor = codMatCodCor.split("-")[1].substring(1);
            const codigoCor = codMatCodCor.split("&")[1].substring(1);
            const codigoDeposito = codMatCodCor.split('&')[2].substring(1);
            // const indexTabelaLotes = tabelaLotes.map(obj => { return { CODIGO: obj.MATERIAL.split("-")[0].slice(0, -1), COR: obj.COR.split("-")[0].slice(0, -1) } }).findIndex(objFind => objFind.CODIGO == '2002003' && objFind.COR == '122001')
            const indexTabelaLotes = tabelaLotes.map(obj => { return { CODIGO: obj.COD_MATERIAL, COR: obj.COD_COR, DEPOSITO_SAIDA: obj.COD_DEPOSITO } }).findIndex(objFind => objFind.CODIGO == codigoMaterial && objFind.COR == codigoCor && objFind.DEPOSITO_SAIDA == codigoDeposito)

            if (indexTabelaLotes != -1) {
                const objLote = {
                    CODIGO: codigoMaterial,
                    COR: codigoCor,
                    // DEPOSITO: tabelaLotes[indexTabelaLotes].DEPOSITO.split("-")[0].slice(0, -1),
                    DEPOSITO: tabelaLotes[indexTabelaLotes].COD_DEPOSITO,
                    // LOTE: tabelaLotes[indexTabelaLotes].LOTE.split("-")[0].slice(0, -1),
                    LOTE: tabelaLotes[indexTabelaLotes].LOTE,
                    ID_MAT_ITEN: tabelaLotes[indexTabelaLotes].ID_MAT_ITEN,
                    TIPOBAIXA: pegaChave("#txtTpBaixa"),
                    QUALIDADE: tabelaLotes[indexTabelaLotes].QUALIDADE,
                    QTDE: listaLotesDesdobrados.filter(loteDesdobrado => loteDesdobrado.CODIGO == codigoMaterial && loteDesdobrado.COR == codigoCor && loteDesdobrado.DEPOSITO_SAIDA == codigoDeposito).map(loteDesdobrado => parseFloat(loteDesdobrado.QTDE)).reduce((qtdeTotal, qtde) => qtdeTotal + qtde, 0),
                    QTDE_TOTAL: tabelaLotes[indexTabelaLotes].QTDE
                    // FUNCIONARIO: '' PEGAR O COOKIE DO USUARIO QUE ENVIA NA REQ
                }
                listaLotes.push(objLote)
            }
        });

        return `&LISTALOTES=${JSON.stringify({ LISTALOTES: listaLotes })}&LISTALOTESDESDOBRADOS=${JSON.stringify({ LISTALOTESDESDOBRADOS: listaLotesDesdobrados })}`;
    }

    async function carregaFuncionarioUsuario() {
        const pesquisa = {
            tabela: "ACESSO_USUARIOS",
            camposSelect: ["ACESSO_USUARIOS.CODFUN", "ENTIDADE.NOME"],
            innerJoin: [
                {
                    "tabela": "ENTIDADE", "condicao": "ACESSO_USUARIOS.CODFUN = ENTIDADE.CODCLI"
                },
            ],
            where: [`ACESSO_USUARIOS.CODIGO = '${getCookie('cod_usuario')}'`]
        }

        const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

        if (jsonStr.length <= 0) {
            return
        } else {
            $('#txtFuncionario').prop('disabled', true);
            $('#btnFuncionario').prop('disabled', true);
            $('#btnLimpaFuncionario').prop('disabled', true);
            $('#txtFuncionario').val(`[${jsonStr[0].CODFUN}] - ${jsonStr[0].NOME}`);
        };
    };

    async function verificaDepositoEmpresa() {
        const pesquisa = {
            tabela: "EMPRESA",
            camposSelect: ["EMP_DEPOSITO"],
            where: [`EMP_PAT = '${getCookie('empresa')}'`]
        };

        const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

        return jsonStr[0];
    };

    async function carregaValoresPadroes() {
        const pesquisa = {
            camposSelect: ['CAMPO', 'VALOR'],
            tabela: 'TABPADRAO',
            where: [`TABPADRAO.TABELA = 'DESDOBRALOTE'`]
        }
        const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

        jsonStr.map(async item => {
            switch (item.CAMPO) {
                case 'TIPO_BAIXA': {
                    insereValor('#txtTpBaixa', item.VALOR, { tabela: 'TABBAI', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR });
                    break;
                }
                case 'DEPOSITO': {
                    insereValor('#txtDeposito', item.VALOR, { tabela: 'DEPOSITO', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR });
                    break;
                }
                case 'DEPOSITO_ENTRADA': {
                    insereValor('#txtDepositoEntrada', item.VALOR, { tabela: 'DEPOSITO', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR });
                    break;
                }
                case 'LOCAL': {
                    insereValor('#txtLocalEntrada', item.VALOR, { tabela: 'CAD_LOC_ESTOQ', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR });
                    break;
                }
                case "SEQ_LOTE_DESDOBRADO": {
                    tamanhoSequencialLoteDesdobrado = item.VALOR != "" ? parseInt(item.VALOR) : 4;
                    break;
                }
                default: {
                    break;
                }
            }
        });
    }

    function limpaCamposExp(){
        $('#txtExpPedido').val('');
        $('#txtExpPedCli').val('');
        $('#txtExpCliente').val('');
        $('#txtExpRepresentante').val('');
        $('#txtExpEmissao').val('1200-01-01');
        $('#txtExpDigitacao').val('1200-01-01');
        $('#txtExpEntrega').val('1200-01-01');
    }

    $('#modal-expedicao').on('show.bs.modal', async function () {
        $.LoadingOverlay('show')
        try {
            try {

                limpaCamposExp();

                $('#txtExpPedido').autocompleta(3, `JSON={ "tabela":"PEDIDO", "camposSelect":[ "NUMERO CHAVE", "PED_CLI DESCRICAO"], "where": null}`)

                $('#btnExpPedido').pesquisa_serverside(['#txtExpPedido'], ['NUMERO'], ['PED_CLI'], `{ "tabela":"PEDIDO", "camposSelect":[ "NUMERO", "PED_CLI" ], "where": null}`, 'Pesquisa de Pedido');

                $('#btnAExpPedido').on('click', function () { $('#txtExpPedido').val('') })

                const registrosLotesDesdobrados = await montaRegistrosExpedicao()
                const dataSetCols = [];
                const keys = Object.keys(registrosLotesDesdobrados[0])
                for (let k in keys) {
                    dataSetCols.push({
                        'title': keys[k],
                        'data': keys[k]
                    })
                }

                criaDataTablePadrao('#tabelaExpedicao',
                    false,
                    false,
                    false,
                    false,
                    true,
                    true,
                    false,
                    registrosLotesDesdobrados,
                    dataSetCols,
                    [],
                    [],
                    [],
                    [],
                    {},
                    2,
                    '',
                    '',
                    false,
                    []);

                $('#tabelaExpedicao').find('tr').each(function () {
                    $(this).removeClass('linhaVerde')
                    $(this).addClass('linhaVermelha')
                })

                $('#txtExpPedido').on('blur', async function () {
                    if ($('#txtExpPedido').val() != '') {
                        $.LoadingOverlay('show')
                        try {
                            const url = "/sisplan/desdobralote/v1/buscadadospedido?";
                            const filtros = `NUMERO=${pegaChave('#txtExpPedido')}`
                            const response = await requisicao("GET", url, `${filtros}&EMPRESA=${getCookie("empresa")}`, "", 360000);

                            if (!response) {
                                return;
                            }

                            let jsonStr = await response.json();
                            if (response.status != 200) {
                                msgErro(jsonStr['RESULT'][0].mensagem);
                                return;
                            }

                            $('#txtExpPedCli').val(pegaDescricao('#txtExpPedido'));
                            $('#txtExpCliente').val(`${jsonStr[0].CODCLI} - ${jsonStr[0].NOME}`);
                            $('#txtExpRepresentante').val(`${jsonStr[0].CODREP} - ${jsonStr[0].NOME_REP}`);
                            $('#txtExpEntrega').val(jsonStr[0].ENTREGA);
                            $('#txtExpEmissao').val(jsonStr[0].DT_EMISSAO);
                            $('#txtExpDigitacao').val(jsonStr[0].DTDIGITA);

                            $('#tabelaExpedicao').DataTable().rows().every(function () {
                                let data = this.data()
                                data.EXISTEPED = 'N'

                                for (let i = 0; i < jsonStr.length; i++) {
                                    if (data.EXISTEPED == 'N') {
                                        if (data.CODIGO == jsonStr[i].CODIGO && data.COR == jsonStr[i].COR && data.DEPOSITO == jsonStr[i].DEPOSITO && data.QUALIDADE == jsonStr[i].QUALIDADE) {
                                            data.EXISTEPED = 'S'
                                            $(this.node()).removeClass('linhaVermelha').addClass('linhaVerde');
                                            break;
                                        }
                                    }
                                }
                            })
                        } finally {
                            $.LoadingOverlay('hide')
                        }
                    }
                })
            } catch (error) {
                console.error(error)
            }
        } finally {
            $.LoadingOverlay('hide')
        }
    })

    async function montaRegistrosExpedicao() {
        const tabela = $('#tabelaLotesDesdobrados').DataTable().data().toArray();
        const registros = []

        tabela.forEach(lotes => {
            const qtde = document.getElementById($(lotes.QTDE)[0].id).value;

            const obj = {
                CODIGO: lotes.COD_MATERIAL,
                DESCRICAO: lotes.DESC_MATERIAL,
                UNIDADE: lotes.UNIDADE,
                COR: lotes.COD_COR,
                DESCCOR: lotes.DESC_COR,
                QTDE: qtde.replace('.', ','),
                LOTE: lotes.LOTE,
                BARRA: lotes.BARRA,
                DEPOSITO: lotes.COD_DEPOSITO,
                QUALIDADE: lotes.QUALIDADE,
                NRROLO: lotes.NRROLO,
                EXISTEPED: 'N'
            }

            registros.push(obj)
        })

        return registros
    }

    function validacao() {
        let existe = true;

        if ($('#txtExpPedido').val() == '') {
            throw new Error("Pedido não informado, Impossível Continuar!");
        }

        $('#tabelaExpedicao').DataTable().rows().every(function () {
            let data = this.data()

            if (data.EXISTEPED == 'N') {
                existe = false
            }
        })

        if (!existe) {
            throw new Error("Existem Itens Distribuidos que não Existem no Pedido Informado. Favor Verificar!")
        }
    }

    $('#btnConfirmarExp').on('click', async function () {
        $.LoadingOverlay('show')
        try {
            validacao();

            const classe = await montaClasseExp();
            await gravaExpedicao(classe);

            await gravaDesdobraLote(false);
        } catch (error) {
            console.error(error)
            msgErro(error.message)
        } finally {
            $.LoadingOverlay('hide')
        }
    })

    async function montaClasseExp() {
        const classe = {}

        classe.NUMERO = pegaChave('#txtExpPedido');
        classe.OBS = $('#txtObservacao').val();
        classe.CODUSUARIO = getCookie('cod_usuario');
        classe.ITENSEXPEDICAO = await montaArrayItensExp();

        return classe;
    }

    async function montaArrayItensExp() {
        const tabela = $('#tabelaExpedicao').DataTable().data().toArray()
        const array = []
        for (let i = 0; i < tabela.length; i++) {
            const obj = {
                CODIGO: tabela[i].CODIGO,
                DESCRICAO: tabela[i].DESCRICAO,
                UNIDADE: tabela[i].UNIDADE,
                COR: tabela[i].COR,
                DESCCOR: tabela[i].DESCCOR,
                QTDE: tabela[i].QTDE,
                LOTE: tabela[i].LOTE,
                BARRA: tabela[i].BARRA,
                DEPOSITO: tabela[i].DEPOSITO,
                QUALIDADE: tabela[i].QUALIDADE,
                NRROLO: tabela[i].NRROLO
            }

            array.push(obj);
        }

        return array;
    }

    async function gravaExpedicao(classe) {
        $.LoadingOverlay("show");
        try {
            let response = await requisicao(
                "POST",
                "/sisplan/desdobralote/v1/gravaexpedicao?",
                `JSON=${encodeURIComponent(JSON.stringify(classe))}`,
                null
            );

            if (!response) {
                $.LoadingOverlay("hide");
                return;
            }

            let jsonStr = await response.json();
            if (response.status != 200) {
                $.LoadingOverlay("hide");
                msgErro(jsonStr.mensagem);
                return;
            }

            $('#modal-expedicao').modal('hide');
        } catch (error) {
            console.error(error);
            msgErro(`Não foi possível gravar os dados da expedição: ${error}`);
        } finally {
            $.LoadingOverlay("hide");
        }
    }

    $('#btnDesistirExp').on('click', async function () {
        $.LoadingOverlay('show')
        try {
            $('#modal-expedicao').modal('hide');
            await gravaDesdobraLote(false);
        } finally {
            $.LoadingOverlay('hide')
        }
    })

});
