<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Sisplan Web | CF-e</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css?versao=3.2410.16.2">
  <!-- Ionicons -->
  <!-- Ionicons -->
  <link rel="stylesheet" href="https://code.ionicframework.com/ionicons/2.0.1/css/ionicons.min.css?versao=3.2410.16.2">
  <!-- Theme style -->
  <link rel="stylesheet" href="dist/css/adminlte.min.css?versao=3.2410.16.2">
  <!-- overlayScrollbars -->
  <link rel="stylesheet" href="plugins/overlayScrollbars/css/OverlayScrollbars.min.css?versao=3.2410.16.2">
  <!-- Daterange picker -->
  <link href='https://fonts.googleapis.com/css?family=Roboto:400,300,500,600,700,400italic' rel='stylesheet' type='text/css'>

  <link rel="stylesheet" href="dist/css/custom.css?versao=3.2410.16.2">
  <link rel="stylesheet" href="dist/css/sisplan.css?versao=3.2410.16.2">
  <link rel="stylesheet" type="text/css" href="plugins/datatables-keytable/css/keyTable.bootstrap4.min.css?versao=3.2410.16.2">
  <link rel="stylesheet" type="text/css" href="dist/css/dataTables.bootstrap4.min.css?versao=3.2410.16.2" />
  <!-- iCheck for checkboxes and radio inputs -->
  <link rel="stylesheet" href="plugins/icheck-bootstrap/icheck-bootstrap.min.css?versao=3.2410.16.2">
  <link rel="shortcut icon" href="favicon.ico">
  <link rel="stylesheet" href="dist/css/select.bootstrap.min.css?versao=3.2410.16.2">
  <!-- Google Font: Source Sans Pro -->
  <!-- AutoComplete -->
  <link rel="stylesheet" href="dist/css/jquery-ui.css?versao=3.2410.16.2">

  <link rel="stylesheet" type="text/css" href="dist/css/driver.min.css?versao=3.2410.16.2" />

  <style>
    .ui-autocomplete-loading {
      background: white url("dist/img/ui-anim_basic_16x16.gif") center center no-repeat;
    }


    .input-group button,
    .input-group input {
      height: 40px;
    }

    .input-group button {
      min-width: 45px;
    }

    .btn.bg-danger {
      border: 1px solid white;
    }

    .info-box-text {
      font-size: 20px;
      font-weight: bold;
      color: grey;
    }

    .divIntegrador {
      border: 1px groove #ddd !important;
      padding: 0 1.4em 1.4em 1.4em !important;
      margin: 0 0 1.5em 0 !important;
      -webkit-box-shadow: 0px 0px 0px 0px #000;
      box-shadow: 0px 0px 0px 0px #000;
    }

    .divIntegrador .textoIntegrador {
      font-size: 1.2em !important;
      text-align: left !important;
      width: auto;
      padding: 0 10px;
      border-bottom: none;
    }

    .card {
      box-shadow: none !important;
      border-radius: 0 !important;
      margin-bottom: 0 !important;
    }

    .card-header {
      box-shadow: 0px 1px rgb(0 0 0 / 20%) !important;
    }

    .card-body {
      padding-left: 1.25rem !important;
      padding-top: 0px;
      padding-bottom: 0px;
      padding-right: 1.25rem !important;
    }

    .fa-angle-right,
    .fa-angle-down {
      color: #343a40;
    }

    .header-content-page .title-page,
    .title-content-page .title,
    .title-page {
      font-size: 20px;
      line-height: normal;
      font-weight: 500;
      color: #343a40;
      margin: 0;
      font-family: Roboto, Arial, sans-serif;
    }

    .modalText {
      font-size: 16px;
      padding: 3px;
    }

    .opcoesImpressao {
      border-top: 0px;
      background-color: transparent !important;
      color: #869099;
      padding: 1rem;
    }
    .botoesMenu {
      height: 100%;
      padding-left: auto;
      padding-right: auto;
      color: white !important;
      min-width: 150px;
      font-weight: bold;
      margin-left: -4px !important;
      font-size: 1rem !important;
      background-color: #343a40;
      cursor: pointer !important;
    }
  </style>
  <!-- Toastr -->
  <link rel="stylesheet" href="plugins/toastr/toastr.min.css">

</head>

<body class="hold-transition sidebar-mini layout-fixed">
  <div class="wrapper">

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper" id="cfeParametro">
      <!-- Content Header (Page header) -->
      <div class="content-header">
        <div class="container-fluid">
          <div class="row mb-2">
            <div class="col-sm-6 row flex">
              <h4 class="m-0 text-dark" id="titleHeader">Impressão CF-e</h4>
              <button title="Tutorial" type="button" class="btn btn-info btn-sm ml-2" style="color: white;" id="tutorial">
                <i class="fas fa-question-circle"></i>
              </button>
            </div><!-- /.col -->
            <div class="col-sm-6">
              <!-- <ol class="breadcrumb float-sm-right">
              </ol> -->
            </div><!-- /.col -->
          </div><!-- /.row -->
        </div><!-- /.container-fluid -->
      </div>
      <!-- /.content-header -->

      <!-- Main content -->
      <section class="content">
        <div class="card">
          <div class="card-body" style="padding-top: 10px;">
            <div class="container-fluid p-2">
              <div class="row pb-2">
                <div class="col-sm-9">
                  <button id="btn-filtros" class="btn btn-success btn-sisp" type="button" data-toggle="modal">
                    <span class="fas fa-filter"></span> Filtros
                  </button>
                  <button id="btn-Config" class="btn btn-danger btn-sisp" type="button" data-toggle="modal">
                    <i class="fas fa-cogs"></i> Config.
                  </button>
                  <button id="btn-log" class="btn btn-primary btn-sisp" type="button">
                    <i class="fas fa-history"></i> Log
                  </button>
                  <button id="gerarStatus" class="btn btn-warning btn-sisp" type="button">
                    <i class="far fa-list-alt"></i> Status
                  </button>
                </div>

                <div class="col-12 col-sm-3" style="display: flex; align-items: CENTER; justify-content: flex-end; margin-right: 0;">
                  <h7 style="color: green;" id="txtHomologacao"></h7>
                </div>
              </div>
              <div class=" row mb-2">
                <div class="col-sm-12">
                  <h5 id="textTable">Impressão CF-e</h5>
                </div>
              </div>
              <div class="row">
                <div class="col-sm-12 table-responsive">
                  <table id="tabelaCFE" class="table table-sm table-select table-hover" width="100%">
                    <thead>
                      <th>ID</th>
                      <th>FATURA</th>
                      <th>DT_EMISSAO</th>
                      <th>CODCLI</th>
                      <th>CLIENTE_NOME</th>
                      <th>VALOR</th>
                      <th>VALOR_LIQ</th>
                      <th>CODVEN</th>
                      <th>IMPRESSO</th>
                    </thead>
                    <tbody>
                    </tbody>
                  </table>
                </div>
              </div>
            </div>
          </div>
        </div>
      </section>
      <section class="content">
        <div class="modal fade" id="modal-itens">
          <div class="modal-dialog modal-xl">
            <div class="modal-content">
              <div class="modal-header">
                <h4 id="modal-itens-title" class="modal-title">Itens da Nota</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">&times;</span>
                </button>
              </div>
              <div class="modal-body">
                <div class="row">
                  <div class="col-sm-12">
                    <input type="text" placeholder="Nota" class="d-none" id="txtNotaItens" name="txtNotaItens" readonly>
                    <input type="text" placeholder="Serie" class="d-none" id="txtSerieItens" name="txtSerieItens" readonly>
                  </div>
                  <div class="col-sm-12 table-responsive">
                    <table id="tabelaItens" style="width:100%" class="table table-sm table-select table-hover" width="100%">
                      <thead>
                      </thead>
                      <tbody>
                      </tbody>
                    </table>
                  </div>
                </div>
              </div>
              <div class="modal-footer justify-content-between">
                <button type="button" class="btn bg-gradient-danger" data-dismiss="modal">Fechar</button>
                <button id="confirmar_dados" type="button" class="btn bg-gradient-success">Confirmar</button>
              </div>
            </div>
            <!-- /.modal-content -->
          </div>
          <!-- /.modal-dialog -->
        </div>

        <div class="modal fade" id="modal-cancelamento">
          <div class="modal-dialog modal-xl">
            <div class="modal-content">
              <div class="modal-header">
                <h4 id="modal-cancelamento-title" class="modal-title">Cancelar CF-e</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">&times;</span>
                </button>
              </div>
              <div class="modal-body">
                <div class="row">
                  <div class="col-sm-6">
                    <div class="group-default form-group">
                      <label for="txtCancFatura">Fatura:</label>
                      <div class="relative">
                        <input type="number" class="input-default focus form-control validate" id="txtCancFatura" name="txtCancFatura" readonly>
                      </div>
                    </div>
                  </div>
                  <div class="col-sm-6">
                    <div class="group-default form-group">
                      <label for="txtCancSerie">Série:</label>
                      <div class="relative">
                        <input type="number" class="input-default focus form-control validate" id="txtCancSerie" name="txtCancSerie" readonly>
                      </div>
                    </div>
                  </div>
                  <div class="col-sm-12">
                    <div class="group-default form-group">
                      <label data-error="wrong" data-success="right" for="txtCancJustificativa">Justificativa</label>
                      <textarea type="textarea" style="resize: none" placeholder="Justificativa" class="input-default focus form-control validate" id="txtCancJustificativa" name="txtCancJustificativa" required="required" rows="3"></textarea>
                    </div>
                  </div>
                </div>
              </div>
              <div class="modal-footer justify-content-between">
                <button id="btn-confirmar-cancelamento" type="button" class="btn bg-gradient-success btn-sisp">Confirmar</button>
                <button type="button" class="btn bg-gradient-danger btn-sisp" data-dismiss="modal">Fechar</button>
              </div>
            </div>
            <!-- /.modal-content -->
          </div>
          <!-- /.modal-dialog -->
        </div>
      </section>
      <!-- /.content -->
    </div>
    <div id="modal-filtros" class="modal" tabindex="-1" role="dialog">
      <div class="modal-dialog modal-xl" role="document">
        <div class="modal-content" id="modalBody">
          <div class="modal-header">
            <h4 class="modal-title">Filtros</h4>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body">
            <div class="row">
              <div class="col-lg-9 col-12">
                <div class="row">
                  <div class="col-6">
                    <div class="group-default form-group">
                      <label for="dtIni">Data De:</label>
                      <div class="relative">
                        <input type="date" max="2500-12-31" value="" class="input-default focus form-control validate" id="txtDataDe" name="txtDataDe">
                      </div>
                    </div>
                  </div>
                  <div class="col-6">
                    <div class="group-default form-group">
                      <label for="dtFim">Data Até:</label>
                      <div class="relative">
                        <input type="date" max="2500-12-31" value="" class="input-default focus form-control validate" id="txtDataAte" name="txtDataAte">
                      </div>
                    </div>
                  </div>
                  <div class="col-12 col-sm-4">
                    <div class="form-group">
                      <label style="margin-bottom: .1rem!important;" for="txtIdCFE">Id CFE:</label>
                      <div class="relative">
                        <input type="number" class="input-default focus form-control" id="txtIdCFE" name="txtIdCFE" class="form-control" placeholder="ID">
                      </div>
                    </div>
                  </div>
                  <div class="col-12 col-sm-4">
                    <label style="margin-bottom: .1rem!important;" data-error="wrong" data-success="right" for="txtCliente">Cliente</label>
                    <div class="input-group">
                      <input type="text" class="input-default focus form-control" id="txtCliente" name="txtCliente" class="form-control" placeholder="Cliente">
                      <div class="input-group-append">
                        <button class="btn bg-danger" id="btn-cliente" name="btn-cliente" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                        <button class="btn bg-danger" id="btn-limpa-cliente" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                      </div>
                    </div>
                  </div>
                  <div class="col-12 col-sm-4">
                    <label style="margin-bottom: .1rem!important;" data-error="wrong" data-success="right" for="txtVenda">Venda</label>
                    <div class="input-group">
                      <input type="text" class="input-default focus form-control" id="txtVenda" name="txtVenda" class="form-control" placeholder="Venda">
                      <div class="input-group-append">
                        <button class="btn bg-danger" id="btn-venda" name="btn-venda" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                        <button class="btn bg-danger" id="btn-limpa-venda" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
              <div class="col-lg-3 col-12">
                <div class="form-group clearfix">
                  <h6>Status: </h6>
                  <div class="icheck-primary">
                    <input type="radio" id="radioPrimary1" value="0" name="rg_status" checked>
                    <label for="radioPrimary1">Todas
                    </label>
                  </div>
                  <div class="icheck-primary">
                    <input type="radio" id="radioPrimary2" value="1" name="rg_status">
                    <label for="radioPrimary2">Impressa
                    </label>
                  </div>
                  <div class="icheck-primary">
                    <input type="radio" id="radioPrimary3" value="2" name="rg_status">
                    <label for="radioPrimary3">Não Impressa</label>
                  </div>
                  <div class="icheck-primary">
                    <input type="radio" id="radioPrimary4" value="3" name="rg_status">
                    <label for="radioPrimary4">Canceladas
                    </label>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <div class="modal-footer">
            <div class="row">
              <button id="btn-consultar" class="btn btn-primary btn-sisp" type="button">
                <span class="fas fa-search"></span> Consultar
              </button>
            </div>
          </div>
        </div>
      </div>
    </div>
    <div class="modal fade" id="modal-Config">
      <div class="modal-dialog modal-lg">
        <div class="modal-content">
          <div class="modal-header">
            <h4 id="modal-Configuração-title" class="modal-title">Configurações Cupom Fiscal Eletrônico - CFE</h4>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>

          <div class="modal-body">
            <div class="card card-header" role="tab" id="observacao">
              <a style="width:100%;" data-toggle="collapse" data-parent="#cfe" href="#cfe" aria-expanded="true" aria-controls="collapseOne1">
                <div class="row">
                  <div style="max-width:20px;margin-top:auto; margin-bottom: auto" class="col-1">
                    <i class="fas fa-angle-down"></i>
                  </div>
                  <div class="col-11">
                    <h4 class="title-page">
                      CFE
                    </h4>
                  </div>
                </div>
              </a>
            </div>
            <div class="collapse show" id="cfe">
              <div class="card card-body">
                <div class="row">
                  <div class="col-4">
                    <label for="txtVersaoSAT">
                      Versão
                    </label>
                    <div class="relative">
                      <input type="text" class="input-group input-default" id="txtVersaoSAT">
                    </div>
                  </div>
                  <div class="col-4">
                    <label for="txtVersaoDadosEntSAT">
                      Versão Dados Ent.:
                    </label>
                    <div class="relative">
                      <input type="text" class="input-group input-default" id="txtVersaoDadosEntSAT">
                    </div>
                  </div>
                  <div class="col-4">
                    <label for="txtVersaoSBSAT">
                      Versão SB.:
                    </label>
                    <div class="relative">
                      <input type="text" class="input-group input-default" id="txtVersaoSBSAT">
                    </div>
                  </div>
                </div>
                <div class="row">
                  <div class="col-4">
                    <label for="txtAmbienteSAT">
                      Ambiente:
                    </label>
                    <div class="relative">
                      <input type="text" class="input-group input-default" id="txtAmbienteSAT">
                    </div>
                  </div>
                  <div class="col-4">
                    <label for="txtModeloSAT">
                      Modelo:
                    </label>
                    <div class="relative">
                      <input type="text" class="input-group input-default" id="txtModeloSAT" disabled>
                    </div>
                  </div>
                </div>
                <div class="row">
                  <div class="col-6">
                    <label for="txtPastaEnvioSAT">Pasta Envio:</label>
                    <div class="relative">
                      <input type="text" class="input-default" id="txtPastaEnvioSAT">
                    </div>
                  </div>
                  <div class="col-6">
                    <label for="txtPastaVendaSAT">Pasta Venda:</label>
                    <div class="relative">
                      <input type="text" class="input-default" id="txtPastaVendaSAT">
                    </div>
                  </div>
                  <div class="col-12">
                    <label for="txtPastaCencelSAT">Pasta Cancel.:</label>
                    <div class="relative">
                      <input type="text" class="input-default" id="txtPastaCencelSAT" value="10">
                    </div>
                  </div>
                  <div class="col-12">
                    <label for="txtCodAtivacaoSAT">Cod. Ativação:</label>
                    <div class="relative">
                      <input type="text" class="input-default" id="txtCodAtivacaoSAT" value="10">
                    </div>
                  </div>
                </div>
                <div class="row">
                  <div class="col-12">
                    <label style="margin-bottom: .1rem!important;" data-error="wrong" data-success="right" for="txtNaturezaConfig">Natureza</label>
                    <div class="input-group">
                      <input type="text" data-selecionado="false" class="input-default focus form-control" id="txtNaturezaConfig" name="txtNaturezaConfig" class="form-control" placeholder="Natureza">
                      <div class="input-group-append">
                        <button class="btn bg-danger" id="btn-NaturezaConfig" name="btn-NaturezaConfig" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                        <button class="btn bg-danger" id="btn-limpa-NaturezaConfig" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                      </div>
                    </div>
                  </div>
                </div>
                <div class="row">
                  <div class="col-12">
                    <label>Assinatura:</label>
                    <textarea id="txtAssinaturaSAT" placeholder="Observação" class="input-default focus form-control validate" rows="4"></textarea>
                  </div>
                </div>
              </div>
            </div>
            <div class="card card-header mfeIni" role="tab" id="mfeAba">
              <a style="width:100%;" data-toggle="collapse" data-parent="#mfe" href="#mfe" aria-expanded="true" aria-controls="collapseOne1">
                <div class="row">
                  <div style="max-width:20px;margin-top:auto; margin-bottom: auto" class="col-1">
                    <i class="fas fa-angle-right"></i>
                  </div>
                  <div class="col-11">
                    <h4 class="title-page">
                      MFE
                    </h4>
                  </div>
                </div>
              </a>
            </div>
            <div class="collapse mfeIni" id="mfe">
              <div class="card card-body">

                <div class="row">
                  <div class="col-12">
                    <label for="txtChaveValidador">
                      Chave Validador
                    </label>
                    <div class="relative">
                      <input type="text" class="input-group input-default" id="txtChaveValidadorMFE">
                    </div>
                  </div>
                </div>
                <div class="row">
                  <div class="col-10">
                    <label for="txtChaveValidador">
                      Chave Requisição
                    </label>
                    <div class="relative">
                      <input type="text" class="input-group input-default" id="txtChaveRequisicaoMFE">
                    </div>
                  </div>
                  <div class="col=2" style="padding-top: 27px;">
                    <button class="btn btn-primary" id="btnGerarGuid">
                      Gerar
                    </button>
                  </div>
                </div>
                <div class="row mt-2 mb-2">
                  <div class="col-6 col-lg-6 d-flex align-items-center" id="checkMfeConfig">
                    <input type="checkbox" id="checkEmiteCupomNFCe" style="width: 20px; height: 20px; margin-right: 10px;">
                    <label for="checkEmiteCupomNFCe" style="margin-bottom: 0rem!important;">
                      Emite Cupom NFCe
                    </label>
                  </div>
                  <div class="col-6 col-lg-6 d-flex align-items-center" id="checkMfeConfig">
                    <input type="checkbox" id="checkControlerAntiFraude" style="width: 20px; height: 20px; margin-right: 10px;">
                    <label for="checkControlerAntiFraude" style="margin-bottom: 0rem!important;">
                      Controle Anti Fraude
                    </label>
                  </div>
                </div>
                <fieldset class="divIntegrador">
                  <legend class="textoIntegrador">Integrador:</legend>
                  <div class="row">
                    <div class="col-12">
                      <label for="txtPastaEnvioMFE">Pasta Envio</label>
                      <div class="relative">
                        <input type="text" class="input-default" id="txtPastaEnvioMFE">
                      </div>
                    </div>
                    <div class="col-12">
                      <label for="txtPastaResposta">Pasta Resposta</label>
                      <div class="relative">
                        <input type="text" class="input-default" id="txtPastaRespostaMFE">
                      </div>
                    </div>
                    <div class="col-12">
                      <label for="txtTimeOut">Time Out</label>
                      <div class="relative">
                        <input type="number" class="input-default" id="txtTimeOutMFE" value="10">
                      </div>
                    </div>
                  </div>
                </fieldset>
              </div>
            </div>
          </div>
          <div class="modal-footer float-right">
            <button id="btn-confirmar-config" type="button" class="btn bg-gradient-danger btn-sisp">Gravar INI</button>
          </div>
        </div>
      </div>
    </div>

    <div style="z-index:99999999999!important;" class="modal fade" id="modal-cfe">
      <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
          <div class="modal-header">
            <i class="fas fa-exclamation-triangle text-yellow" style="margin-right: 20px;font-size: 35px;margin-right: 20;"></i>
            <h4 id="modal-cfe-titulo" class="modal-title">Atenção</h4>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body" style="min-height: 120px;">
            <div class="modalText" id="modal-cfe-conteudo1"></div>
            <div class="modalText" id="modal-cfe-conteudo2"></div>
          </div>
          <div id="modal-cfe-rodape" class="modal-footer justify-content-between">

          </div>
        </div>
        <!-- /.modal-content -->
      </div>
      <!-- /.modal-dialog -->
    </div>

    <!-- Control Sidebar -->
    <aside class="control-sidebar control-sidebar-dark">
      <!-- Control sidebar content goes here -->
    </aside>
    <!-- /.content-wrapper -->
    <div class="opcoesImpressao">
      <div class="row">
        <div class="col-12">
          <div id="dadosnota" class="row">
            <div class="col-sm-2">
              <div class="group-default form-group">
                <label data-error="wrong" data-success="right" for="txtNumeroCF">Numero CF</label>
                <div class="relative">
                  <input type="text" placeholder="Numero CF" class="input-default focus form-control validate" id="txtNumeroCF" name="txtNumeroCF" readonly>
                </div>
              </div>
            </div>
            <div class="col-2">
              <div class="group-default form-group">
                <label data-error="wrong" data-success="right" for="txtEmissaoCF">Emissão</label>
                <div class="relative">
                  <input type="text" placeholder="Emissão" class="input-default focus form-control validate" id="txtEmissaoCF" name="txtEmissaoCF" readonly>
                  <input type="text" class="input-default focus form-control" id="txtCodVen" name="txtCodVen" hidden>
                </div>
              </div>
            </div>
          <!-- </div>
          <div class="row"> -->
            <div class="col-4">
              <div class="group-default form-group">
                <label data-error="wrong" data-success="right" for="txtChaveCF">Chave</label>
                <div class="relative">
                  <input type="text" placeholder="Chave" class="input-default focus form-control validate" id="txtChaveCF" name="txtChaveCF" readonly>
                </div>
              </div>
            </div>
            <div class="col-4">
              <div class="group-default form-group">
                <label data-error="wrong" data-success="right" for="txtChaveCanc">Chave Canc.</label>
                <div class="relative">
                  <input type="text" placeholder="Chave" class="input-default focus form-control validate" id="txtChaveCanc" name="txtChaveCanc" readonly>
                </div>
              </div>
            </div>
          </div>
        </div>

        <div class="col-12 text-center">
          <div class="btn-group flex-wrap btn-group-justified btn-group-lg" role="group" aria-label="Basic example">
            <button id="btnGerar" class="btn btn-secondary text-white btn-sisp botoesMenu"><span class="fas fa-cogs pr-1"></span>Gerar</button>
            <button id="btnImprimir" class="btn btn-secondary text-white btn-sisp botoesMenu dropdown-toggle">
              <span class="fas fa-print pr-1" style="color: white!important"></span> Imprimir</button>
            <div class="dropdown-menu" style="margin-left: 141px; top: -55px;" id="dropdown-menu">
              <button id="btnImprimirCFe" class="dropdown-item" href="">Imprimir CF-e</button>
              <button id="btnImprimirBoleto" class="dropdown-item" href="">Imprimir Boleto</button>
            </div>
            <button id="btnCancelar" class="btn btn-secondary text-white btn-sisp botoesMenu"><span class="fas fa-ban pr-1"></span>Cancelar</button>
            <button id="btnExcluir" class="btn btn-secondary text-white btn-sisp botoesMenu"><span class="fas fa-trash pr-1"></span>Excluir</button>
          </div>
        </div>


        <!-- <div class="col-12 text-center">
          <div class="btn-group flex-wrap btn-group-justified btn-group-lg" role="group" aria-label="Basic example">
            <button id="btnGerar" style="font-size:20px!important;color:white!important;font-weight:bold;border-radius: 0.3rem;" class="btn btn-primary text-white btn-sisp">Gerar</button>
            <button id="btnImprimir" style="font-size:20px!important;color:white!important;font-weight:bold;border-radius: 0.3rem;" class=" btn btn-info text-white btn-sisp botoesMenu dropdown-toggle"> Imprimir</button>
            <div class="dropdown-menu" style="margin-left: 119px; top: -56px;" id="dropdown-menu">
              <button id="btnImprimirCFe" class="dropdown-item" href="">Imprimir CF-e</button>
              <button id="btnImprimirBoleto" class="dropdown-item" href="">Imprimir Boleto</button>
            </div>
            <input type="submit" id="btnCancelar" style="font-size:20px!important;color:white!important;font-weight:bold;border-radius: 0.3rem;" class=" btn btn-secondary text-white btn-sisp" value="Cancelar">
            <button id="btnExcluir" style="font-size:20px!important;color:white!important;font-weight:bold;border-radius: 0.3rem;" class=" btn btn-danger text-white btn-sisp">Excluir</button>
          </div>
        </div> -->
      </div>
    </div>
    <?php include_once('../../modais.php'); ?>


    <!-- /.control-sidebar -->
  </div>
  <!-- ./wrapper -->

  <script src="plugins/jquery/jquery.min.js?versao=3.2410.16.2"></script>

  <script type="text/javascript" src="dist/js/jquery.dataTables.js?versao=3.2410.16.2"></script>
  <script type="text/javascript" src="dist/js/dataTables.bootstrap4.min.js?versao=3.2410.16.2"></script>
  <script type="text/javascript" src="dist/js/loadingoverlay.min.js?versao=3.2410.16.2"></script>

  <!-- jQuery UI 1.11.4 -->
  <script src="plugins/jquery-ui/jquery-ui.min.js?versao=3.2410.16.2"></script>
  <!-- Resolve conflict in jQuery UI tooltip with Bootstrap tooltip -->
  <script>
    $.widget.bridge('uibutton', $.ui.button)
  </script>
  <!-- Bootstrap 4 -->
  <script src="plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.2410.16.2"></script>
  <!-- AdminLTE App -->
  <script src="dist/js/adminlte.min.js?versao=3.2410.16.2"></script>

  <script src="dist/js/sisplan.js?versao=3.2410.16.2"></script>
  <!-- SweetAlert2 -->
  <script src="plugins/sweetalert2/sweetalert2.min.js?versao=3.2410.16.2"></script>
  <script src="plugins/toastr/toastr.min.js?versao=3.2410.16.2"></script>
  <script src="dist/js/requisicoes.js?versao=3.2410.16.2"></script>
  <script type="text/javascript" src="dist/js/sum().js?versao=3.2410.16.2"></script>
  <script type="text/javascript" src="utils/funcoes.js?versao=3.2410.16.2"></script>
  <script src="plugins/moment/moment.min.js?versao=3.2410.16.2"></script>
  <script src="utils/cookies.js?versao=3.2410.16.2"></script>
  <script src="dist/js/jquery.maskMoney.min.js?versao=3.2410.16.2"></script>
  <script src="pages/loja/js/rotinas.js?versao=3.2410.16.2"></script>
  <script src="dist/js/dataTables.keyTable.js?versao=3.2410.16.2"></script>
  <script src="dist/js/driver.min.js?versao=3.2410.16.2"></script>
  <script type="text/javascript" src="config.js?versao=3.2410.16.2"></script>
  <script>
    $(document).ready(async function() {
      if (getCookie('usuario') == "") {
        window.location.href = `${BASE_URI}/login`;
        return;
      }

      let usuario = getCookie('usuario');
      let empresa = getCookie('empresa');
      let queryString = window.location.href;
      let parametros = queryString.split('/');
      let nomeTela = parametros[parametros.length - 1].toUpperCase();

      ipInterno = IP_INTERNO;
      ipExterno = IP_EXTERNO;
      basicAuth = BASIC_AUTH;
      sArquivo = `${BASE_URI}/pages/cfe/cfe.js?versao=3.2410.16.2`;

      $('#txtVenda').autocompleta(1, `JSON={ "tabela":"venda", "camposSelect":[ "codven CHAVE", "nrcupom descricao"], "where": null}`);
      $('#txtCliente').autocompleta(3, `JSON={ "tabela":"entidade", "camposSelect":[ "codcli chave", "nome descricao"], "where": null}`);

      $('#btn-venda').pesquisa('#txtVenda', 'CODVEN', 'NRCUPOM', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"venda", "camposSelect":[ "codven", "nrcupom"]}`, 'Pesquisa Venda', 'venda');
      $('#btn-cliente').pesquisa('#txtCliente', 'CODCLI', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"entidade", "camposSelect":[ "codcli", "nome"]}`, 'Pesquisa Cliente', 'entidade');

      $('#btn-limpa-venda').on('click', function() {
        $('#txtVenda').val('');
      });

      $('#btn-limpa-cliente').on('click', function() {
        $('#txtCliente').val('');
      });

      $('#txtNaturezaConfig').autocompleta(1, `JSON={ "tabela":"natureza", "camposSelect":[ "natureza chave", "descricao descricao"], "where": null}`);

      $('#btn-NaturezaConfig').pesquisa('#txtNaturezaConfig', 'NATUREZA', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"natureza", "camposSelect":[ "natureza", "descricao"]}`, 'Pesquisa Natureza', 'natureza');

      $('#btn-limpa-NaturezaConfig').on('click', function() {
        $('#txtNaturezaCFe').val('');
      });

      await insereJavaScriptPagina(sArquivo);

      const temAcesso = await temAcessoTela('CFE');
      if (!temAcesso.resultado) {
        toastrAcesso(temAcesso, BASE_URI);
        return;
      }
    });
  </script>
</body>

</html>