$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false
        });
        driver.defineSteps([{
            element: '#btnFiltros',
            popover: {
                title: 'Botão Filtros',
                description: 'Clique aqui para abrir os filtros padrões da tela.',
                position: 'right'
            }
        },
        {
            element: '#btnIncluir',
            popover: {
                title: 'Botão Incluir',
                description: 'Clique aqui para iniciar o cadastro de um Centro de Custo.',
                position: 'right'
            }
        },
        {
            element: '#tabelaAcessoCC_wrapper',
            popover: {
                title: 'Tabela Centro de Custo',
                description: 'Aqui estão os dados dos centros de custo cadastrados.',
                position: 'top'
            }
        }
        ]);
        driver.start();
    });
});
$(document).ready(async function () {
    const permissaoUsuarioLogado = await permissaoAcessos("CENTROCUSTO");

    async function criaPesquisas() {
        // componenteFiltro('centroCusto');
        // componenteFiltro('grupoCCusto');

        $('#txtCentroCusto').autocompleta(1, `JSON={ "tabela":"CENTROCUSTO", "camposSelect":[ "CODIGO chave", "DESCRICAO descricao"], "where": null}`);
        $('#btnCentroCusto').pesquisa_serverside(['#txtCentroCusto'], ['CODIGO'], ['DESCRICAO'], '{"tabela":"CENTROCUSTO", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}', 'Pesquisa Centro de Custo');
        $('#btnLimpaCentroCusto').on('click', function () {
            $('#txtCentroCusto').val('');
        });

        $('#txtGrupoCCusto').autocompleta(1, `JSON={ "tabela":"GRUPO_CCUSTO", "camposSelect":[ "CODIGO chave", "DESCRICAO descricao"], "where": null}`);
        $('#btnGrupoCCusto').pesquisa_serverside(['#txtGrupoCCusto'], ['CODIGO'], ['DESCRICAO'], '{"tabela":"GRUPO_CCUSTO", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}', 'Pesquisa Grupo de Centro de Custo');
        $('#btnLimpaGrupoCCusto').on('click', function () {
            $('#txtGrupoCCusto').val('');
        });
    };

    function retornaBotaoOpcoes(data) {
        var retorno = '<div style="text-align:start;"> ' +
            '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
            '      ' + data + ' ' +
            '    </button> ' +
            '    <div class="dropdown-menu"> ' +
            '    <button class="dropdown-item" type="button" title="Editar" id="btn-editar">Editar</button>     ' +
            '    <button class="dropdown-item" type="button" title="Excluir" id="btn-excluir">Excluir</button>  ' +
            '</div>';
        return retorno;
    };

    async function buscaDados(bConsultou = false) {
        try {
            let response;

            $.LoadingOverlay("show");

            const centroCusto = pegaChave("#txtCentroCusto") != "" ? ` AND CODIGO = '${pegaChave("#txtCentroCusto")}' ` : "";
            const grupoCentroCusto = pegaChave('#txtGrupoCCusto') != "" ? ` AND GRUPO = '${pegaChave('#txtGrupoCCusto')}' ` : "";
            const tipoCentroCusto = $('#rgTipo').val() != '' ? $('#rgTipo').val() != null ? ` AND TIPO = '${$('#rgTipo').val()}' ` : "" : "";

            if (bConsultou) {
                response = await requisicao(
                    "GET",
                    "/Sisplan/Funcoes/V1/pesquisa?",
                    `EMPRESA=${getCookie('empresa')}&JSON={ "tabela":"CENTROCUSTO", 
                            "camposSelect":[ "CODIGO", "DESCRICAO", "ESTRUTURA", "GRUPO", "TIPO", "OBS"], 
                            "where":  ["1=1 ${centroCusto} ${grupoCentroCusto} ${tipoCentroCusto}"]}`
                    , null);
            } else {
                response = await requisicao("GET", "/Sisplan/Funcoes/V1/pesquisa?", 'JSON={ "tabela":"CENTROCUSTO", "camposSelect":[ "CODIGO", "DESCRICAO", "ESTRUTURA", "GRUPO", "TIPO"], "where": null}', null);
            };

            if (!response) {
                $.LoadingOverlay("hide");
                return;
            };

            let jsonStr = await response.json();

            if (response.status != 200) {
                $.LoadingOverlay("hide");

                msgAlerta(jsonStr.RESULT[0].mensagem);

                return;
            };

            $("#tabelaAcessoCC").DataTable({
                destroy: true,
                lengthChange: false,
                serverside: true,
                language: {
                    sEmptyTable: "Nenhum registro encontrado",
                    sInfo: "_TOTAL_ registros",
                    sInfoEmpty: " 0 registros",
                    sInfoFiltered: "(Filtrados de _MAX_ registros)",
                    sInfoPostFix: "",
                    sInfoThousands: ".",
                    sLengthMenu: "_MENU_ resultados",
                    sLoadingRecords: "Carregando...",
                    sProcessing: "Processando...",
                    sZeroRecords: "Nenhum registro encontrado",
                    sSearch: "Pesquisar",
                    oPaginate: {
                        sNext: "Próximo",
                        sPrevious: "Anterior",
                        sFirst: "Primeiro",
                        sLast: "Último",
                    },
                    oAria: {
                        sSortAscending: ": Ordenar colunas de forma ascendente",
                        sSortDescending: ": Ordenar colunas de forma descendente",
                    },
                },

                autoWidth: true,
                data: jsonStr.RESULT[0],
                columns: [
                    {
                        data: "CODIGO",
                    },
                    {
                        data: "DESCRICAO",
                    },
                    {
                        data: "ESTRUTURA",
                    },
                    {
                        data: "GRUPO",
                    },
                    {
                        data: "TIPO",
                    }
                ],
                columnDefs: [
                    {
                        targets: [0], render: function (data, type, row) {
                            return retornaBotaoOpcoes(data);
                        }
                    },
                ],
            });
        } catch (e) {
            console.error(e);

            msgAlerta('Não foi possível buscar os dados. Tente novamente!');

            return;
        } finally {
            $.LoadingOverlay("hide");
        };
    };

    $('#btnFiltros').on('click', function () {
        $('#modal-filtros').modal('show');
    });

    $('#btnConsultar').on('click', async function () {
        $.LoadingOverlay('show')
        try {
            await buscaDados(true)
        } finally {
            $.LoadingOverlay('hide')
            $('#modal-filtros').modal('hide');
        }
    })

    $('#btnLimparFiltros').on('click', function () {
        $('#txtCentroCusto').val('');
        $('#txtGrupoCCusto').val('');
        $("#rgTipo").val('')
    });

    $('#tabelaAcessoCC').on('dblclick', 'tr', async function () {
        if (permissaoUsuarioLogado.ALTERA == 'S') {
            let data = $('#tabelaAcessoCC').DataTable().row($(this)).data();
            let registroLiberado = await verificarRegistro('CENTROCUSTO', data.CODIGO);
            if (registroLiberado) {
                window.location.href = `centrocusto/${data.CODIGO}`;
            }
        } else {
            msgAlertaSemConfirmacao("Sem permissão para alterar!");
        }
    });

    $('#tabelaAcessoCC').on('click', '#btn-editar', async function () {
        if (permissaoUsuarioLogado.ALTERA == 'S') {
            let data = $('#tabelaAcessoCC').DataTable().row($(this).parents('tr')).data();
            let registroLiberado = await verificarRegistro('CENTROCUSTO', data.CODIGO);
            if (registroLiberado) {
                window.location.href = `centrocusto/${data.CODIGO}`;
            }
        } else {
            msgAlertaSemConfirmacao("Sem permissão para alterar!");
        }
    });

    $('#tabelaAcessoCC').on('click', '#btn-excluir', async function () {
        if (permissaoUsuarioLogado.EXCLUI == 'S') {
            msgAlerta('Você realmente deseja excluir esse registro?', async () => {
                const data = $("#tabelaAcessoCC").DataTable().row($(this).parents("tr"));
                await excluiRegistro(data);
            });
        } else {
            msgAlertaSemConfirmacao("Sem permissão para excluir!");
        }
    });

    async function excluiRegistro(data) {
        try {
            $.LoadingOverlay("show");
            try {
                let valorLinha = data.data();
                let response = await requisicao("DELETE", "/Sisplan/Cadastros/v1/centrocusto?", `CODIGOCENTROCUSTO=${encodeURIComponent(valorLinha.CODIGO)}`, null);
                if (!response) {
                    return;
                }
                if (response.status != 200) {
                    let jsonStr = await response.json();
                    msgErro(jsonStr.mensagem);
                    return;
                }

                toastr.success("Exclusão efetuada com sucesso!", "Confirmação", {
                    toastClass: "success",
                    iconClasses: {
                        error: "alert-error",
                        info: "alert-info",
                        success: "alert-success",
                        warning: "alert-warning",
                    },
                    positionClass: "toast-top-center",
                    progressBar: true,
                    timeOut: 3000,
                    fadeOut: 1000,
                    onHidden() {
                        data.remove().draw(false);
                    },
                }).css({
                    "margin-top": "20%",
                    width: "500px",
                    "max-width": "500px",
                });

            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay("hide");
        }
    }

    $('#btnIncluir').on('click', function () {
        if (permissaoUsuarioLogado.INCLUI == 'S') {
            window.location.href = "centrocusto/create";
        } else {
            msgAlertaSemConfirmacao("Sem permissão para incluir!");
        }
    });

    await criaPesquisas();
    await buscaDados();
});