$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false,
      animate: true,
      onNext: (Element) => {
        if ((Element.node.id == 'gravar')) {
          $('.driver-next-btn').on('click', location.reload());
        };
      },
      onPrevious: (Element) => {
        if (Element.node.id == 'formcard1') {
          $('.driver-close-btn').on('click', location.reload());
        };
      }
    });

    driver.defineSteps([{
      element: '#divCashback',
      popover: {
        title: 'Lista de Cashback',
        description: 'Aqui estão os registros de cashback gerados/utilizados pelos clientes.',
        position: 'top'
      }
    },
    {
      element: '#btnFiltros',
      popover: {
        title: 'Filtros',
        description: 'Aqui você pode filtrar o cliente que deseja saber o histórico de cashback',
        position: 'bottom'
      }
    },
    {
      element: '#checkAtivo',
      popover: {
        title: 'Ativo',
        description: 'Selecionando este elemento, marcamos a unidade como ativa.',
        position: 'top'
      }
    },
    {
      element: '#boxDashboard',
      popover: {
        title: 'Totalizadores',
        description: 'Aqui você tem um total resumido dos dados apresentados abaixo',
        position: 'top'
      }
    },
    {
      element: '#txtQuantidade',
      popover: {
        title: 'Quantidade',
        description: 'Adicionamos neste campo a quantidade da unidade.',
        position: 'top'
      }
    },
    {
      element: "#btnVoltar",
      popover: {
        title: "Botão Voltar",
        description:
          "Ao clicar nesse botão você retorna para a tela de consulta.",
        position: "left",
      },
    },
    {
      element: '#gravar',
      popover: {
        title: 'Botão Gravar',
        description: 'Clique aqui para gravar a Unidade.',
        position: 'left'
      }
    }
    ]);
    driver.start();
  });
});


$(document).ready(async function () {
  const permissaoUsuarioLogado = await permissaoAcessos("CASHBACK");

  $('#btnIncluirCliente').pesquisa_serverside(['#txtIncluirCliente'], ["CODCLI"], ["NOME"], `{"tabela":"ENTIDADE", "camposSelect":["CODCLI", "NOME"], "where": ["1=1"]}`, 'Pesquisa de Cliente');
  $('#btn-cliente').pesquisa_serverside(['#txtCliente'], ["CODCLI"], ["NOME"], `{"tabela":"ENTIDADE", "camposSelect":["CODCLI", "NOME"], "where": ["1=1"]}`, 'Pesquisa de Cliente');

  $('#txtIncluirCliente').autocompleta(1, `JSON={ "tabela":"ENTIDADE", "camposSelect":["CODCLI CHAVE", "NOME DESCRICAO"], "where": null}`);
  $('#txtCliente').autocompleta(1, `JSON={ "tabela":"ENTIDADE", "camposSelect":["CODCLI CHAVE", "NOME DESCRICAO"], "where": null}`);

  $('#btnLimpaIncluirCliente').on('click', function () {
    $('#txtIncluirCliente').val('');
  });
  $('#btn-limpa-Cliente').on('click', function () {
    $('#txtCliente').val('');
  });

  $('#btnLimparFiltrosIncluir').on('click', function () {
    $('#txtIncluirCliente').val('');
    $('#txtObs').val('');
    $('#txtValorIncluir').val('');
    $('#txtIncluirPontos').val('');
  });

  $('#btnLimparFiltros').on('click', function () {
    $('#txtCliente').val('');
    $('#txtDateDe').val('');
    $('#txtDateAte').val('');
  });


  function geraTotalizadores() {
    const listaCashback = $('#tabelaCashback').DataTable().data().toArray();
    const totalPontos = listaCashback.reduce((total, item) => total + item.PONTOS, 0);
    const totalValoresGerados = listaCashback.filter((item) => item.VALOR > 0).reduce((total, item) => total + item.VALOR, 0);
    const totalValoresUtilizados = listaCashback.filter((item) => item.VALOR < 0).reduce((total, item) => total + Math.abs(item.VALOR), 0);
    const totalSaldoDisponivel = (totalValoresGerados - totalValoresUtilizados);
    $('#txtTotalPontos').html(ArredondarValor(totalPontos, 2));
    $('#txtValoresGerados').html(formataEmReais(totalValoresGerados));
    $('#txtValoresUtilizados').html(formataEmReais(totalValoresUtilizados));
    $('#txtSaldoDisponivel').html(formataEmReais(totalSaldoDisponivel));
  }

  function retornaColunas() {
    const dataSetCols = [];
    dataSetCols.push({
      "title": "Id",
      "data": "ID",
    });
    dataSetCols.push({
      "title": "Codcli",
      "data": "CODCLI",
    });
    dataSetCols.push({
      "title": "Nome",
      "data": "NOME",
    });
    dataSetCols.push({
      "title": "Valor",
      "data": "VALOR",
    });
    dataSetCols.push({
      "title": "Pontos",
      "data": "PONTOS",
    });
    dataSetCols.push({
      "title": "Data",
      "data": "DATA",
    });
    dataSetCols.push({
      "title": "Docto",
      "data": "DOCTO",
    });
    dataSetCols.push({
      "title": "Tipo",
      "data": "TIPO",
    });
    dataSetCols.push({
      "title": "EmpID",
      "data": "EMP_ID",
    });
    dataSetCols.push({
      "title": "Obs",
      "data": "OBS",
    });
    return dataSetCols;
  };

  $("#btnFiltros").on("click", function () {
    $("#modal-filtros").modal("show");
  });

  $("#btnIncluir").on("click", function () {
    if (permissaoUsuarioLogado.INCLUI == 'S') {
      $("#modal-incluir").modal("show");
    } else {
      msgAlertaSemConfirmacao("Sem permissão para incluir!");
    }
  });

  $("#btnConsultar").on('click', function () {
    $("#modal-filtros").modal("hide");
    carregaDados();
  });

  $("#btnGravar").on('click', function () {
    if ($('#txtIncluirCliente').val() == '') {
      msgErro('Preencha o cliente.');
    } else if ($('#txtObs').val() == '') {
      msgErro('Preencha a observação.');
    } else if ($('#txtValorIncluir').val() == '') {
      msgErro('Preencha o valor.');
    } else if ($('#txtIncluirPontos').val() == '') {
      msgErro('Preencha a pontuação.');
    } else {
      $("#modal-incluir").modal("hide");
      enviaDados();
    }
  });

  $('#tabelaCashback').on('click', '#btn-excluir', async function () {
    if (permissaoUsuarioLogado.EXCLUI == 'S') {
      msgAlerta('Você realmente deseja excluir esse registro?', async () => {
        const data = $("#tabelaCashback").DataTable().row($(this).parents("tr"));
        await excluiRegistro(data);
      });
    } else {
      msgAlertaSemConfirmacao("Sem permissão para excluir!");
    }
  });

  function formatarDataCash(data) {
    return new Intl.DateTimeFormat("pt-BR").format(
      new Date(`${data.split(" ")[0]} 23:59:59`)
    );
  }

  async function carregaDados() {
    try {
      $.LoadingOverlay('show');
      try {
        const where = [];
        if (pegaChave('#txtCliente') != '') {
          where.push(`CASHBACK.CODCLI = '${pegaChave('#txtCliente')}'`);
        }

        if ($('#txtDataDe').val() != '') {
          where.push(`CASHBACK.DATA >= '${$("#txtDataDe").val()}'`);
        }

        if ($('#txtDataAte').val() != '') {
          where.push(`CASHBACK.DATA <= '${$("#txtDataAte").val()}'`);
        }

        const empIDs = $('.empresa_selecionada:checked').toArray().length > 0 ? $('.empresa_selecionada:checked').toArray().map(input => input.id.substring(input.id.indexOf('-') + 1, input.id.length)) : [getCookie('emp_id')];

        where.push(`CASHBACK.EMP_ID IN (${empIDs})`);

        const pesquisa = {
          camposSelect: ['CASHBACK.ID', 'CASHBACK.CODCLI', 'ENTIDADE.NOME', 'CASHBACK.VALOR', 'CASHBACK.PONTOS', 'CASHBACK.DATA', 'CASHBACK.DOCTO', 'CASHBACK.EMP_ID', 'CASHBACK.OBS', 'CASHBACK.TIPO'],
          tabela: 'CASHBACK',
          leftJoin: [{ tabela: 'ENTIDADE', condicao: 'CASHBACK.CODCLI = ENTIDADE.CODCLI' }],
          where,
          orderBy: ['CASHBACK.ID DESC']
        };
        const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));
        const formatedJson = jsonStr.map(js => ({ ...js, DATA: formatarDataCash(js.DATA) }));
        if ($.fn.DataTable.isDataTable('#tabelaCashback')) {
          $("#tabelaCashback").DataTable().destroy();
          $("#tabelaCashback").empty();
        }

        $('#tabelaCashback').DataTable({
          paging: true,
          info: true,
          autoWidth: true,
          destroy: true,
          language: {
            sEmptyTable: "Nenhum registro encontrado",
            sInfo: "_TOTAL_ registros",
            sInfoEmpty: " 0 registros",
            sInfoFiltered: "(Filtrados de _MAX_ registros)",
            sInfoPostFix: "",
            sInfoThousands: ".",
            sLengthMenu: "_MENU_ resultados",
            sLoadingRecords: "Carregando...",
            sProcessing: "Processando...",
            sZeroRecords: "Nenhum registro encontrado",
            sSearch: "Pesquisar",
            oPaginate: {
              sNext: "Próximo",
              sPrevious: "Anterior",
              sFirst: "Primeiro",
              sLast: "Último",

            },
          },
          data: formatedJson,
          columnDefs: [
            { type: 'date-br', targets: 5 },
            { 
              "render": function (data) {
                if (data !== null && data !== undefined && !isNaN(data)) {
                  return parseFloat(data).toLocaleString('pt-BR', {
                    maximumFractionDigits: 2,
                    minimumFractionDigits: 2
                  });
                } else {
                  return '0,00'; 
                }
              },
              targets: [3, 4], 
              className: 'pr-4 text-right' 
            }
          ],
          order: [5, 'desc'],
          columns: retornaColunas(),
          // columnDefs: [
          //   {
          //     targets: [0],
          //     render (data) {
          //       return retornaBotaoOpcoes(data);
          //     }
          //   },
          //   {
          //     "render": function (data) {
          //       return parseFloat(data).toLocaleString('pt-BR', {
          //         maximumFractionDigits: 2,
          //         minimumFractionDigits: 2
          //       });
          //     },
          //     "targets": [3]
          //   },
          // ]
        });
        geraTotalizadores();
      } catch (error) {
        throw msgErro('Não foi possível carregar os dados');
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  //Função para pegar a data de hoje
  function getDataAtual() {
    const dataAtual = new Date();
    const dia = dataAtual.getDate();
    const mes = dataAtual.getMonth() + 1;
    const ano = dataAtual.getFullYear();

    const dataFormatada = `${ano}-${mes.toString().padStart(2, '0')}-${dia.toString().padStart(2, '0')}`;

    return dataFormatada;
  }

  const dataAtual = getDataAtual();

  async function enviaDados() {
    $.LoadingOverlay('show');
    try {
      let obj = {}

      obj.CODCLI = pegaChave('#txtIncluirCliente');
      obj.DOCTO = 'MANUAL';
      obj.EMP_ID = getCookie('emp_id');
      obj.OBS = $('#txtObs').val();

      if ($('#rdEntrada').is(':checked')) {
        obj.TIPO = 'E';
        obj.VALOR = $('#txtValorIncluir').val();
        obj.PONTOS = $('#txtIncluirPontos').val();
      } else {
        obj.TIPO = 'S';
        obj.VALOR = `${-parseFloat($('#txtValorIncluir').val())}`;
        obj.PONTOS = `${-parseFloat($('#txtIncluirPontos').val())}`;
      }

      const response = await requisicao("POST", `/Sisplan/cashback/V1/gravarcashback?`, `JSON=${encodeURIComponent(JSON.stringify(obj))}`, 15000);       //&COD_USUARIO=${getCookie('cod_usuario')}&

      if (!response) {
        $.LoadingOverlay("hide");
        return;
      };

      const jsonStr = await response.json();

      if (response.status != 200) {
        msgAlerta(jsonStr.mensagem);
        return;
      }

      toastr.success(
        'Cadastro efetuado com sucesso!',
        'Confirmação', {
        toastClass: 'alert',
        iconClasses: {
          error: 'alert-error',
          info: 'alert-info',
          success: 'alert-success',
          warning: 'alert-warning'
        },
        positionClass: "toast-top-center",
        progressBar: true,
        timeOut: 3000,
        fadeOut: 1000,
      }
      ).css({
        "margin-top": "20%",
        "width": "500px",
        "max-width": "500px"
      });
    } catch (error) {
      msgErro(`Não foi possível gravar os dados de cashback.`);
    }
    finally {
      $('#txtDataDe').val(dataAtual);
      $('#txtDataAte').val(dataAtual);
      $('#btnConsultar').trigger('click');

      $('#txtIncluirCliente').val('');
      $('#txtObs').val('');
      $('#txtValorIncluir').val('');
      $('#txtIncluirPontos').val('');

      $.LoadingOverlay("hide")
    }
  };

  $('#btnSelecionarEmpresas').on('click', function () {
    carregaEmpresasDisponiveis();
  });

  // carregaDados();

  function retornaBotaoOpcoes(data) {
    const retorno = `<div style="text-align:start;"> ` +
      `    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ` +
      `      ${data} ` +
      `    </button> ` +
      `    <div class="dropdown-menu"> ` +
      `    <button class="dropdown-item" type="button" title="Excluir" id="btn-excluir">Excluir</button>  ` +
      `</div>`;
    return retorno;
  };

  async function excluiRegistro(data) {
    try {
      $.LoadingOverlay("show");
      try {
        const valorLinha = data.data();
        const response = await requisicao('DELETE', '/sisplan/cashback/v1/cashback?', `ID=${encodeURIComponent(valorLinha.ID)}`, null);
        if (!response) {
          return;
        }
        if (response.status != 200) {
          const jsonStr = await response.json();
          msgErro(jsonStr.mensagem);
          return;
        }

        criaMensagemSucesso('Exclusão efetuada com sucesso!', () => { window.location.reload(); });

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  };
});