$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false
    });
    driver.defineSteps([
      {
        element: '#abaGeral',
        popover: {
          title: 'Tabela para Cadastro',
          description: 'Abas referentes às telas, com campos a serem preenchidos com valores padrões.',
          position: 'bottom'
        }
      },
      {
        element: '#btnGravar',
        popover: {
          title: 'Botão Gravar',
          description: 'Clique aqui para gravar os Valores Padrões.',
          position: 'top'
        }
      }
    ]);
    driver.start();
  });
});

$(document).ready(async function () {
  const parametrosVenda = await BuscaParametrosVenda();
  if (!['1', '3', '4'].includes(parametrosVenda[72])) {
    $('#tabCashback').addClass('d-none');
  }
  let valoresPadroes = [
    //PRODUTO
    { TABELA: 'PRODUTO', CAMPO: 'UNIDADE', DESCRICAO: 'UNIDADE DO PRODUTO', VALOR: '' },
    { TABELA: 'PRODUTO', CAMPO: 'UNI_VENDA', DESCRICAO: 'UNIDADE DE VENDA', VALOR: '' },
    { TABELA: 'PRODUTO', CAMPO: 'CODFIS', DESCRICAO: 'CÓDIGO NCM', VALOR: '' },
    { TABELA: 'PRODUTO', CAMPO: 'ICMS', DESCRICAO: 'PERCENTUAL DE ICMS', VALOR: '' },
    { TABELA: 'PRODUTO', CAMPO: 'CODTRIB', DESCRICAO: 'CST DE ICMS', VALOR: '' },
    { TABELA: 'PRODUTO', CAMPO: 'CODIPI', DESCRICAO: 'CST DE IPI DE SAÍDA', VALOR: '' },
    { TABELA: 'PRODUTO', CAMPO: 'CODIPI_ENT', DESCRICAO: 'CST DE IPI DE ENTRADA', VALOR: '' },
    { TABELA: 'PRODUTO', CAMPO: 'TRIBUTACAO', DESCRICAO: 'TRIBUTAÇÃO', VALOR: '' },
    { TABELA: 'PRODUTO', CAMPO: 'IPI', DESCRICAO: 'PERCENTUAL DE IPI', VALOR: '' },
    { TABELA: 'PRODUTO', CAMPO: 'POSSE', DESCRICAO: 'POSSE', VALOR: '' },
    { TABELA: 'PRODUTO', CAMPO: 'STATUS', DESCRICAO: 'STATUS', VALOR: '' },
    { TABELA: 'PRODUTO', CAMPO: 'SPED', DESCRICAO: 'SPED', VALOR: '' },
    { TABELA: 'PRODUTO', CAMPO: 'GRUPO_PRODUTO', DESCRICAO: 'GRUPO DE PRODUTO', VALOR: '' },
    { TABELA: 'PRODUTO', CAMPO: 'ECF_TRIB', DESCRICAO: 'ST DO ICMS', VALOR: '' },
    { TABELA: 'PRODUTO', CAMPO: 'NATUREZA', DESCRICAO: 'NATUREZA', VALOR: '' },
    { TABELA: 'PRODUTO', CAMPO: 'TIPO_VENDA', DESCRICAO: 'TIPO DE VENDA', VALOR: '' },
    { TABELA: 'PRODUTO', CAMPO: 'TIPO_PROD', DESCRICAO: 'TIPO CÓDIGO', VALOR: '' },
    { TABELA: 'PRODUTO', CAMPO: 'SETOR', DESCRICAO: 'SETOR PADRÃO NOS CONSUMOS', VALOR: '' },
    { TABELA: 'PRODUTO', CAMPO: 'APLICACAO', DESCRICAO: 'APLICAÇÃO PADRÃO NOS CONSUMOS', VALOR: '' },
    { TABELA: 'PRODUTO', CAMPO: 'COLECAO', DESCRICAO: 'COLEÇÃO PADRÃO', VALOR: '' },
    { TABELA: 'PRODUTO', CAMPO: 'UNI_EXP', DESCRICAO: 'UNIDADE EXPORTAÇÃO', VALOR: '' },
    { TABELA: 'PRODUTO', CAMPO: 'DIV_EXP', DESCRICAO: 'CONVERSÃO EXPORTAÇÃO', VALOR: '' },
    { TABELA: 'PRODUTO', CAMPO: 'ETIQUETA', DESCRICAO: 'ETIQUETA', VALOR: '' },
    { TABELA: 'PRODUTO', CAMPO: 'LINHA', DESCRICAO: 'LINHA', VALOR: '' },
    { TABELA: 'PRODUTO', CAMPO: 'ATIVO', DESCRICAO: 'ATIVO', VALOR: '' },
    { TABELA: 'PRODUTO', CAMPO: 'COR_ENT_MANUAL', DESCRICAO: 'COR ENTRADA MANUAL', VALOR: '' },
    { TABELA: 'PRODUTO', CAMPO: 'COR_SAI_MANUAL', DESCRICAO: 'COR SAÍDA MANUAL', VALOR: '' },
    { TABELA: 'PRODUTO', CAMPO: 'COR', DESCRICAO: 'COR PADRÃO PARA CADASTRO DE PRODUTO', VALOR: '' },
    { TABELA: 'PRODUTO', CAMPO: 'FAIXA_TAMANHO', DESCRICAO: 'FAIXA DE TAMANHO PADRÃO PARA CADASTRO DE PRODUTO', VALOR: '' },

    //MATERIAL
    { TABELA: 'MATERIAL', CAMPO: 'UNIDADE', DESCRICAO: 'UNIDADE DO MATERIAL', VALOR: '' },
    { TABELA: 'MATERIAL', CAMPO: 'UNI_COM', DESCRICAO: 'UNIDADE DE COMPRA', VALOR: '' },
    { TABELA: 'MATERIAL', CAMPO: 'CODFIS', DESCRICAO: 'CÓDIGO NCM', VALOR: '' },
    { TABELA: 'MATERIAL', CAMPO: 'CODTRI', DESCRICAO: 'CST DE ICMS DE SAÍDA', VALOR: '' },
    { TABELA: 'MATERIAL', CAMPO: 'CODTRI_ENT', DESCRICAO: 'CST DE ICMS DE ENTRADA', VALOR: '' },
    { TABELA: 'MATERIAL', CAMPO: 'CODIPI', DESCRICAO: 'CST DE IPI DE SAÍDA', VALOR: '' },
    { TABELA: 'MATERIAL', CAMPO: 'CODIPI_ENT', DESCRICAO: 'CST DE IPI DE ENTRADA', VALOR: '' },
    { TABELA: 'MATERIAL', CAMPO: 'CDCENTRO', DESCRICAO: 'CENTRO DE CUSTO', VALOR: '' },
    { TABELA: 'MATERIAL', CAMPO: 'IPI', DESCRICAO: 'PERCENTUAL DE IPI', VALOR: '' },
    { TABELA: 'MATERIAL', CAMPO: 'POSSE', DESCRICAO: 'POSSE', VALOR: '' },
    { TABELA: 'MATERIAL', CAMPO: 'SPED', DESCRICAO: 'SPED', VALOR: '' },
    { TABELA: 'MATERIAL', CAMPO: 'TRIBUTACAO', DESCRICAO: 'TRIBUTAÇÃO', VALOR: '' },
    { TABELA: 'MATERIAL', CAMPO: 'ENQUADRA', DESCRICAO: 'ENQUADRAMENTO IPI', VALOR: '' },
    { TABELA: 'MATERIAL', CAMPO: 'NATUREZA', DESCRICAO: 'NATUREZA', VALOR: '' },
    { TABELA: 'MATERIAL', CAMPO: 'STATUS', DESCRICAO: 'STATUS', VALOR: '' },
    { TABELA: 'MATERIAL', CAMPO: 'GRUPO_MA', DESCRICAO: 'GRUPO DO MATERIAL', VALOR: '' },
    { TABELA: 'MATERIAL', CAMPO: 'SUBGRUPO_MA', DESCRICAO: 'SUBGRUPO DO MATERIAL', VALOR: '' },
    { TABELA: 'MATERIAL', CAMPO: 'ATIVO', DESCRICAO: 'ATIVO', VALOR: '' },
    { TABELA: 'MATERIAL', CAMPO: 'ESTOQUE', DESCRICAO: 'CONTROLA ESTOQUE (S = Controla Estoque / N = Não Controla Estoque)', VALOR: '' },

    //ENTIDADE
    { TABELA: 'ENTIDADE', CAMPO: 'CC_CLIENTE', DESCRICAO: 'INICIO CONTA CONTABIL CLIENTE', VALOR: '' },
    { TABELA: 'ENTIDADE', CAMPO: 'CC_FORNECEDOR', DESCRICAO: 'INICIO CONTA CONTABIL FORNECEDOR', VALOR: '' },
    { TABELA: 'ENTIDADE', CAMPO: 'CC_ADIANTAMENTO', DESCRICAO: 'INICIO CONTA CONTABIL ADIANTAMENTO', VALOR: '' },
    { TABELA: 'ENTIDADE', CAMPO: 'CC_DEVOLUCAO', DESCRICAO: 'INICIO CONTA CONTABIL DEVOLUCAO', VALOR: '' },
    { TABELA: 'ENTIDADE', CAMPO: 'CF_ADIANTAMENTO', DESCRICAO: 'INICIO CONTA FORNECEDOR ADIANTAMENTO', VALOR: '' },
    { TABELA: 'ENTIDADE', CAMPO: 'CF_DEVOLUCAO', DESCRICAO: 'INICIO CONTA FORNECEDOR DEVOLUCAO', VALOR: '' },
    { TABELA: 'ENTIDADE', CAMPO: 'GRUPO_CLI', DESCRICAO: 'GRUPO DE ENTIDADE', VALOR: '' },
    { TABELA: 'ENTIDADE', CAMPO: 'HISTORICO', DESCRICAO: 'HISTORICO', VALOR: '' },
    { TABELA: 'ENTIDADE', CAMPO: 'BANCO', DESCRICAO: 'BANCO', VALOR: '' },
    { TABELA: 'ENTIDADE', CAMPO: 'SIT_DUP', DESCRICAO: 'SITUACAO DUPLICATA', VALOR: '' },
    { TABELA: 'ENTIDADE', CAMPO: 'IE_DESTINATARIO', DESCRICAO: 'INDICADOR DO IE DE DESTINATARIO', VALOR: '' },
    { TABELA: 'ENTIDADE', CAMPO: 'CODREP', DESCRICAO: 'REPRESENTANTE', VALOR: '' },
    { TABELA: 'ENTIDADE', CAMPO: 'RAMO_ATIV', DESCRICAO: 'RAMO ATIV', VALOR: '' },
    { TABELA: 'ENTIDADE', CAMPO: 'CONS_FINAL', DESCRICAO: 'CONSUMIDOR FINAL', VALOR: '' },
    { TABELA: 'ENTIDADE', CAMPO: 'NATUREZA', DESCRICAO: 'NATUREZA SAIDA', VALOR: '' },
    { TABELA: 'ENTIDADE', CAMPO: 'NATUREZA_ENTRA', DESCRICAO: 'NATUREZA ENTRADA', VALOR: '' },
    { TABELA: 'ENTIDADE', CAMPO: 'TRANSPORTE', DESCRICAO: 'TRANSPORTADORA', VALOR: '' },
    { TABELA: 'ENTIDADE', CAMPO: 'TP_FRETE', DESCRICAO: 'TIPO DE FRETE', VALOR: '' },
    { TABELA: 'ENTIDADE', CAMPO: 'CLASSE', DESCRICAO: 'CLASSE GERENCIAL', VALOR: '' },
    { TABELA: 'ENTIDADE', CAMPO: 'EMAIL', DESCRICAO: 'EMAIL', VALOR: '' },
    { TABELA: 'ENTIDADE', CAMPO: 'FORMA_PAGTO', DESCRICAO: 'FORMAS DE PAGAMENTO (SEPARAR POR VIRGULA QUANDO + DE 1)', VALOR: '' },
    { TABELA: 'ENTIDADE', CAMPO: 'MARKUP', DESCRICAO: 'MARKUP', VALOR: '' },
    { TABELA: 'ENTIDADE', CAMPO: 'MOEDAS', DESCRICAO: 'MOEDAS (SEPARAR POR VIRGULA QUANDO + DE 1)', VALOR: '' },
    { TABELA: 'ENTIDADE', CAMPO: 'TIPO_ENTIDADE', DESCRICAO: 'TIPO DA ENTIDADE', VALOR: '' },
    { TABELA: 'ENTIDADE', CAMPO: 'VAL_LIMIT_CONSIGNADO', DESCRICAO: 'VALOR INICIAL LIMITE DE CRÉDITO CONSIGNADO', VALOR: '' },
    { TABELA: 'ENTIDADE', CAMPO: 'VAL_LIMIT_VENDA', DESCRICAO: 'VALOR INICIAL LIMITE DE CRÉDITO VENDA', VALOR: '' },
    { TABELA: 'ENTIDADE', CAMPO: 'VAL_LIMIT_MAIOR_12', DESCRICAO: 'VALOR LIMITE DE CRÉDITO PARA CLIENTES CADASTRADOS COM MAIS DE 12 MESES', VALOR: '' },
    { TABELA: 'ENTIDADE', CAMPO: 'PERC_RECALC_LIMIT_CR', DESCRICAO: 'PERCENTUAL PARA RECALCULAR LIMITE DE CRÉDITO', VALOR: '' },
    { TABELA: 'ENTIDADE', CAMPO: 'NUMERO_MESES_RECALC', DESCRICAO: 'NÚMERO DE MESES PARA RECALCULAR LIMITE DE CRÉDITO', VALOR: '' },
    { TABELA: 'ENTIDADE', CAMPO: 'TIPO_PESSOA', DESCRICAO: 'TIPO PESSOA DA ENTIDADE', VALOR: '' },

    //PEDIDO
    { TABELA: 'PEDIDO', CAMPO: 'DEPOSITO', DESCRICAO: 'DEPOSITO', VALOR: '' },
    { TABELA: 'PEDIDO', CAMPO: 'OPER_FISCAL', DESCRICAO: 'OPERAÇÃO FISCAL', VALOR: '' },
    { TABELA: 'PEDIDO', CAMPO: 'STATUS', DESCRICAO: 'STATUS', VALOR: '' },
    { TABELA: 'PEDIDO', CAMPO: 'QUALIDADE', DESCRICAO: 'QUALIDADE', VALOR: '' },
    { TABELA: 'PEDIDO', CAMPO: 'TIPO_OF', DESCRICAO: 'TIPO OF', VALOR: '' },
    { TABELA: 'PEDIDO', CAMPO: 'TIPO', DESCRICAO: 'TIPO', VALOR: '' },
    { TABELA: 'PEDIDO', CAMPO: 'TRANSPORTADORA', DESCRICAO: 'TRANSPORTADORA', VALOR: '' },
    { TABELA: 'PEDIDO', CAMPO: 'SIT_DUP', DESCRICAO: 'SIT_DUP', VALOR: '' },
    { TABELA: 'PEDIDO', CAMPO: 'HISTORICO', DESCRICAO: 'HISTORICO', VALOR: '' },
    { TABELA: 'PEDIDO', CAMPO: 'DEP_FILHO', DESCRICAO: 'DEP_FILHO', VALOR: '' },
    { TABELA: 'PEDIDO', CAMPO: 'STATUS_CANC_API', DESCRICAO: 'STATUS_CANC_API', VALOR: '' },
    { TABELA: 'PEDIDO', CAMPO: 'STATUS_ANTECIPACAO', DESCRICAO: 'STATUS_ANTECIPACAO', VALOR: '' },
    { TABELA: 'PEDIDO', CAMPO: 'ITEM_PADRAO', DESCRICAO: 'ITEM PADRÃO (P/M)', VALOR: '' },
    { TABELA: 'PEDIDO', CAMPO: 'STATUS_DEST', DESCRICAO: 'DEFINE STATUS AO IMPRIMIR O PEDIDO NO RELATÓRIO DE PEDIDOS', VALOR: '' },
    { TABELA: 'PEDIDO', CAMPO: 'TIPO_VENDA', DESCRICAO: 'DEFINE O TIPO DE VENDA', VALOR: '' },
    { TABELA: 'PEDIDO', CAMPO: 'RESPONSAVEL', DESCRICAO: 'DEFINE O RESPONSÁVEL PADRÃO AO INCLUIR PEDIDO', VALOR: '' },
    { TABELA: 'PEDIDO', CAMPO: 'COLECAO', DESCRICAO: 'DEFINE A COLEÇÃO PADRÃO AO INCLUIR PEDIDO', VALOR: '' },
    { TABELA: 'PEDIDO', CAMPO: 'STATUS_LIB_COMERCIAL', DESCRICAO: 'DEFINE O STATUS PADRÃO PARA REALIZAR A LIBERAÇÃO COMERCIAL', VALOR: '' },

    //NOTA_ENTRA
    { TABELA: 'NOTA_ENTRA', CAMPO: 'NATUREZA', DESCRICAO: 'NATUREZA', VALOR: '' },
    { TABELA: 'NOTA_ENTRA', CAMPO: 'NAT_SERVICO', DESCRICAO: 'NATUREZA SERVIÇO', VALOR: '' },
    { TABELA: 'NOTA_ENTRA', CAMPO: 'OPERACAO', DESCRICAO: 'OPERACAO', VALOR: '' },
    { TABELA: 'NOTA_ENTRA', CAMPO: 'DEPOSITO', DESCRICAO: 'DEPOSITO', VALOR: '' },
    { TABELA: 'NOTA_ENTRA', CAMPO: 'TP_MOV', DESCRICAO: 'TIPO DE MOVIMENTAÇÃO', VALOR: '' },
    { TABELA: 'NOTA_ENTRA', CAMPO: 'HISTORICO', DESCRICAO: 'HISTORICO', VALOR: '' },
    { TABELA: 'NOTA_ENTRA', CAMPO: 'SITUACAO', DESCRICAO: 'SITUACAO', VALOR: '' },
    { TABELA: 'NOTA_ENTRA', CAMPO: 'CONTA', DESCRICAO: 'CONTA', VALOR: '' },
    { TABELA: 'NOTA_ENTRA', CAMPO: 'BANCO', DESCRICAO: 'BANCO', VALOR: '' },
    { TABELA: 'NOTA_ENTRA', CAMPO: 'CLASSE', DESCRICAO: 'CLASSE', VALOR: '' },
    { TABELA: 'NOTA_ENTRA', CAMPO: 'TIPO_ITEM', DESCRICAO: 'TIPO ITEM PADRÃO AO CADASTRAR NOVOS ITENS NA ENTRADA DE NF', VALOR: '' },

    //NOTA
    { TABELA: 'NOTA', CAMPO: 'NATUREZA', DESCRICAO: 'NATUREZA', VALOR: '' },
    { TABELA: 'NOTA', CAMPO: 'OPERACAO', DESCRICAO: 'OPERACAO', VALOR: '' },
    { TABELA: 'NOTA', CAMPO: 'DEPOSITO', DESCRICAO: 'DEPOSITO', VALOR: '' },
    { TABELA: 'NOTA', CAMPO: 'UF_EMBARQUE', DESCRICAO: 'UF EMBARQUE', VALOR: '' },
    { TABELA: 'NOTA', CAMPO: 'LOCAL_EMBARQUE', DESCRICAO: 'LOCAL EMBARQUE', VALOR: '' },
    { TABELA: 'NOTA', CAMPO: 'PRESENCA', DESCRICAO: 'PRESENÇA', VALOR: '' },
    { TABELA: 'NOTA', CAMPO: 'MOEDA', DESCRICAO: 'MOEDA', VALOR: '' },
    { TABELA: 'NOTA', CAMPO: 'HISTORICO', DESCRICAO: 'HISTÓRICO', VALOR: '' },
    { TABELA: 'NOTA', CAMPO: 'BANCO', DESCRICAO: 'BANCO', VALOR: '' },
    { TABELA: 'NOTA', CAMPO: 'SITUACAO', DESCRICAO: 'SITUAÇÃO', VALOR: '' },
    { TABELA: 'NOTA', CAMPO: 'CLASSE_GERENCIAL', DESCRICAO: 'CLASSE GERENCIAL', VALOR: '' },
    { TABELA: 'NOTA', CAMPO: 'ENDERECO_A_FATURAR', DESCRICAO: 'ENDEREÇO PARA PUXAR NO FATURAMENTO DA EXPEDIÇÃO', VALOR: '' },
    { TABELA: 'NOTA', CAMPO: 'NAO_ALTERA_DIFAL', DESCRICAO: 'BLOQUEIA EDIÇÃO NO CHECK DIFAL', VALOR: '' },
    { TABELA: 'NOTA', CAMPO: 'RECEITA_DIFAL', DESCRICAO: 'DEFINE O CÓDIGO PADRÃO PARA RECEITA DO DIFAL', VALOR: '' },
    { TABELA: 'NOTA', CAMPO: 'DETALHE_DIFAL', DESCRICAO: 'DEFINE O VALOR PADRÃO PARA DETALHE DO DIFAL', VALOR: '' },
    { TABELA: 'NOTA', CAMPO: 'RECEITA_POBREZA', DESCRICAO: 'DEFINE O CÓDIGO PADRÃO PARA RECEITA DE POBREZA', VALOR: '' },
    { TABELA: 'NOTA', CAMPO: 'DETALHE_POBREZA', DESCRICAO: 'DEFINE VALOR PADRÃO PARA DETALHE DE POBREZA', VALOR: '' },
    { TABELA: 'NOTA', CAMPO: 'COD_BAIXA_CANCEL_NFE', DESCRICAO: 'CÓDIGO DE BAIXA PADRÃO (CANCELAMENTO DE NF-E)', VALOR: '' },
    { TABELA: 'NOTA', CAMPO: 'ENVIA_EMAIL_ATRASO', DESCRICAO: 'EMAILS PARA ENVIAR CLIENTES COM PENDÊNCIA (SEPARADO POR ;)', VALOR: '' },

    //ESTOQUE
    { TABELA: 'ESTOQUE', CAMPO: 'TIPO', DESCRICAO: 'TIPO DE MOVIMENTO', VALOR: '' },
    { TABELA: 'ESTOQUE', CAMPO: 'DEPOSITO', DESCRICAO: 'DEPOSITO', VALOR: '' },
    { TABELA: 'ESTOQUE', CAMPO: 'QUALIDADE', DESCRICAO: 'QUALIDADE', VALOR: '' },
    { TABELA: 'ESTOQUE', CAMPO: 'TIPO_CONFERENCIA', DESCRICAO: 'TIPO CONFERENCIA', VALOR: '' },

    //TRANS_DEPOSITO
    { TABELA: 'TRANSF_DEPOSITO', CAMPO: 'FUNCIONARIO_PROD', DESCRICAO: 'FUNCIONARIO (PRODUTO)', VALOR: '' },
    { TABELA: 'TRANSF_DEPOSITO', CAMPO: 'DEPOSITO_ORIGEM_PROD', DESCRICAO: 'DEPÓSITO ORIGEM (PRODUTO)', VALOR: '' },
    { TABELA: 'TRANSF_DEPOSITO', CAMPO: 'DEPOSITO_DEST_PROD', DESCRICAO: 'DEPÓSITO DESTINO (PRODUTO)', VALOR: '' },
    { TABELA: 'TRANSF_DEPOSITO', CAMPO: 'TIPO_MOVTO_PROD', DESCRICAO: 'TIPO DE MOVIMENTO (PRODUTO)', VALOR: '' },
    { TABELA: 'TRANSF_DEPOSITO', CAMPO: 'FUNCIONARIO_MAT', DESCRICAO: 'FUNCIONARIO (MATERIAL)', VALOR: '' },
    { TABELA: 'TRANSF_DEPOSITO', CAMPO: 'DEPOSITO_ORIGEM_MAT', DESCRICAO: 'DEPÓSITO ORIGEM (MATERIAL)', VALOR: '' },
    { TABELA: 'TRANSF_DEPOSITO', CAMPO: 'DEPOSITO_DEST_MAT', DESCRICAO: 'DEPÓSITO DESTINO (MATERIAL)', VALOR: '' },
    { TABELA: 'TRANSF_DEPOSITO', CAMPO: 'TIPO_MOVTO_MAT', DESCRICAO: 'TIPO DE MOVIMENTO SAÍDA (MATERIAL)', VALOR: '' },
    { TABELA: 'TRANSF_DEPOSITO', CAMPO: 'TIPO_MOVTO_MAT_ENTRA', DESCRICAO: 'TIPO DE MOVIMENTO ENTRADA (MATERIAL)', VALOR: '' },
    { TABELA: 'TRANSF_DEPOSITO', CAMPO: 'COD_BAIXA_ESTR_SAID', DESCRICAO: 'CÓDIGO DE BAIXA DE ENTRADA NO ESTORNO (MATERIAL)', VALOR: '' },
    { TABELA: 'TRANSF_DEPOSITO', CAMPO: 'COD_BAIXA_ESTR_ENTR', DESCRICAO: 'CODIGO DE BAIXA DE SAÍDA NO ESTORNO (MATERIAL)', VALOR: '' },

    //RECEBER
    { TABELA: 'RECEBER', CAMPO: 'CLASSE', DESCRICAO: 'CLASSE GERENCIAL', VALOR: '' },
    { TABELA: 'RECEBER', CAMPO: 'SITUACAO', DESCRICAO: 'SITUAÇÃO', VALOR: '' },
    { TABELA: 'RECEBER', CAMPO: 'STATUS', DESCRICAO: 'STATUS', VALOR: '' },
    { TABELA: 'RECEBER', CAMPO: 'MOEDA', DESCRICAO: 'MOEDA', VALOR: '' },
    { TABELA: 'RECEBER', CAMPO: 'CONTA', DESCRICAO: 'CONTA', VALOR: '' },
    { TABELA: 'RECEBER', CAMPO: 'EMISSAO_DE', DESCRICAO: 'CONSIDERAR O DIA 1º DO MÊS ATUAL PARA A CONSULTA DAS DUPLICATAS (INFORMAR S PARA ATIVAR).', VALOR: '' },
    { TABELA: 'RECEBER', CAMPO: 'VENCIMENTO_DE', DESCRICAO: 'CONSIDERAR O DIA 1º DO MÊS ATUAL PARA A CONSULTA DAS DUPLICATAS (INFORMAR S PARA ATIVAR).', VALOR: '' },
    { TABELA: 'RECEBER', CAMPO: 'PAGAMENTO_DE', DESCRICAO: 'CONSIDERAR O DIA 1º DO MÊS ATUAL PARA A CONSULTA DAS DUPLICATAS (INFORMAR S PARA ATIVAR).', VALOR: '' },
    { TABELA: 'RECEBER', CAMPO: 'CFOP_PAGTO_INTEGRADO', DESCRICAO: 'SERÁ RESPONSÁVEL POR PREENCHER A NATUREZA DA NFCE QUANDO FOR BAIXADO UM RECEBER COM PAGAMENTO INTEGRADO (SOMENTE RS)', VALOR: '' },
    { TABELA: 'RECEBER', CAMPO: 'NCM_PAGTO_INTEGRADO', DESCRICAO: 'INFORMAR O CAMPO CÓDIGO DO CADASTRO DE NCM, SERÁ RESPONSÁVEL POR PREENCHER O NCM DA NFCE QUANDO FOR BAIXADO UM RECEBER COM PAGAMENTO INTEGRADO (SOMENTE RS)', VALOR: '' },

    //PAGTO
    { TABELA: 'PAGTO', CAMPO: 'EMISSAO_DE', DESCRICAO: 'CONSIDERAR O DIA 1º DO MÊS ATUAL PARA A CONSULTA DAS DUPLICATAS (INFORMAR S PARA ATIVAR).', VALOR: '' },
    { TABELA: 'PAGTO', CAMPO: 'VENCIMENTO_DE', DESCRICAO: 'CONSIDERAR O DIA 1º DO MÊS ATUAL PARA A CONSULTA DAS DUPLICATAS (INFORMAR S PARA ATIVAR).', VALOR: '' },
    { TABELA: 'PAGTO', CAMPO: 'INTERVALO_DIAS_EMISSAO', DESCRICAO: 'INTERVALO DE DIAS DE EMISSAO', VALOR: '' },
    { TABELA: 'PAGTO', CAMPO: 'STATUS', DESCRICAO: 'STATUS', VALOR: '' },
    { TABELA: 'PAGTO', CAMPO: 'SITUACAO', DESCRICAO: 'SITUACAO', VALOR: '' },
    { TABELA: 'PAGTO', CAMPO: 'FORNECEDOR', DESCRICAO: 'FORNECEDOR', VALOR: '' },
    { TABELA: 'PAGTO', CAMPO: 'CLASSE_GERENCIAL', DESCRICAO: 'CLASSE GERENCIAL', VALOR: '' },
    { TABELA: 'PAGTO', CAMPO: 'HISTORICO', DESCRICAO: 'HISTÓRICO', VALOR: '' },
    { TABELA: 'PAGTO', CAMPO: 'SITUACAO_CODIGO', DESCRICAO: 'CÓDIGO DA SITUAÇÃO', VALOR: '' },
    { TABELA: 'PAGTO', CAMPO: 'BANCO', DESCRICAO: 'BANCO', VALOR: '' },
    { TABELA: 'PAGTO', CAMPO: 'CONTA', DESCRICAO: 'CONTA', VALOR: '' },
    { TABELA: 'PAGTO', CAMPO: 'SITUACAO_DUP', DESCRICAO: 'SITUAÇÃO DUPLICATA', VALOR: '' },

    //LOJA
    { TABELA: 'LOJA', CAMPO: 'INFORMACOES_CLIENTE', DESCRICAO: 'ABRE A TELA DE INFORMAÇÕES CLIENTE AO SAIR DO CAMPO DE CLIENTE (INFORMAR S PARA ATIVAR)', VALOR: '' },
    { TABELA: 'LOJA', CAMPO: 'RETORNA_USUARIO', DESCRICAO: 'RETORNA USUÁRIO LOGADO AO ABRIR OS FILTROS DO RELATÓRIO DE VENDA (INFORMAR S PARA ATIVAR)', VALOR: '' },
    { TABELA: 'LOJA', CAMPO: 'BUSCA_PRECO_PEDIDO', DESCRICAO: 'MARCA CHECK BUSCA PREÇO PEDIDO NO MODAL DE IMPORTAÇÃO DENTRO DA PRÉ-VENDA (INFORMAR "Sim" PARA ATIVAR)', VALOR: '' },
    { TABELA: 'LOJA', CAMPO: 'LANCAR_ANTECIPACAO', DESCRICAO: 'MARCA CHECK LANÇAR COMO ANTECIPAÇÃO NO MODAL DE CARTÃO PRESENTE DO LOJA (INFORMAR "Sim" PARA ATIVAR)', VALOR: '' },
    { TABELA: 'LOJA', CAMPO: 'DIAS_CARTAO_PRES', DESCRICAO: 'DIAS PADRÃO PARA VALIDADE AO CRIAR O CARTÃO PRESENTE', VALOR: '' },
    { TABELA: 'LOJA', CAMPO: 'VALOR_MAX_NFCE', DESCRICAO: 'VALOR MÁXIMO PERMITIDO PARA GERAR NFCE NA VENDA', VALOR: '' },
    { TABELA: 'LOJA', CAMPO: 'COD_BAIXA_VENDA', DESCRICAO: 'CÓDIGO DE BAIXA PADRÃO (VENDA)', VALOR: '' },
    { TABELA: 'LOJA', CAMPO: 'COD_BAIXA_CANC_VENDA', DESCRICAO: 'CÓDIGO DE BAIXA PADRÃO (CANCELAMENTO DE VENDA)', VALOR: '' },
    { TABELA: 'LOJA', CAMPO: 'COD_BAIXA_DESDOB_SAI', DESCRICAO: 'CÓDIGO DE BAIXA PADRÃO DE SAIDA (DESDOBRAMENTO DE LOTE PELA VENDA)', VALOR: '' },
    { TABELA: 'LOJA', CAMPO: 'COD_BAIXA_DESDOB_ENT', DESCRICAO: 'CÓDIGO DE BAIXA PADRÃO DE ENTRADA (DESDOBRAMENTO DE LOTE PELA VENDA)', VALOR: '' },
    { TABELA: 'LOJA', CAMPO: 'COD_BAIXA_VENDA_PEND', DESCRICAO: 'CÓDIGO DE BAIXA PADRÃO (VENDA PENDENTE)', VALOR: '' },
    { TABELA: 'LOJA', CAMPO: 'COD_BAIXA_BRINDE', DESCRICAO: 'CÓDIGO DE BAIXA PADRÃO (BRINDE)', VALOR: '' },
    { TABELA: 'LOJA', CAMPO: 'COD_BAIXA_C_BRINDE', DESCRICAO: 'CÓDIGO DE BAIXA PADRÃO (CANCELAMENTO DE BRINDE)', VALOR: '' },
    { TABELA: 'LOJA', CAMPO: 'QUALIDADE', DESCRICAO: 'DEFINIRÁ A QUALIDADE PADRÃO NOS ITENS DA VENDA (NECESSÁRIO TER O PARÂMETRO 42 DO VENDAS CONFIGURADO)', VALOR: '' },

    //CASHBACK
    { TABELA: 'CASHBACK', CAMPO: 'VAL_MIN', DESCRICAO: 'VALOR MÍNIMO DA VENDA PARA CONSIDERAR O CASHBACK', VALOR: '' },
    { TABELA: 'CASHBACK', CAMPO: 'PERCENTUAL', DESCRICAO: 'PERCENTUAL', VALOR: '' },
    { TABELA: 'CASHBACK', CAMPO: 'VALIDADE', DESCRICAO: 'TEMPO DE VALIDADE EM DIAS', VALOR: '' },
    { TABELA: 'CASHBACK', CAMPO: 'PERC_MAX', DESCRICAO: 'PERCENTUAL MÁXIMO DE UTILIZAÇÃO NA VENDA', VALOR: '' },

    //DESDOBRALOTE
    { TABELA: 'DESDOBRALOTE', CAMPO: 'TIPO_BAIXA', DESCRICAO: 'TIPO DE BAIXA', VALOR: '' },
    { TABELA: 'DESDOBRALOTE', CAMPO: 'DEPOSITO', DESCRICAO: 'DEPOSITO', VALOR: '' },
    { TABELA: 'DESDOBRALOTE', CAMPO: 'DEPOSITO_ENTRADA', DESCRICAO: 'DEPOSITO DE ENTRADA', VALOR: '' },
    { TABELA: 'DESDOBRALOTE', CAMPO: 'LOCAL', DESCRICAO: 'LOCAL', VALOR: '' },
    { TABELA: 'DESDOBRALOTE', CAMPO: 'SEQ_LOTE_DESDOBRADO', DESCRICAO: 'DEFINIRÁ O TAMANHO DO SEQUENCIAL DO NOVO LOTE GERADO', VALOR: '' },

    //DEVOLUCAO
    { TABELA: 'DEVOLUCAO', CAMPO: 'CLIENTE_PADRAO', DESCRICAO: 'SERÁ RESPONSÁVEL POR PREENCHER AUTOMATICAMENTE O CAMPO CLIENTE NA DEVOLUÇÃO (INFORMAR SOMENTE O CODCLI)', VALOR: '' },
    { TABELA: 'DEVOLUCAO', CAMPO: 'VENC_ANTECIPACAO', DESCRICAO: 'DEFINIRÁ O VENCIMENTO DA ANTECIPAÇÃO A PARTIR DO DIA DE EMISSÃO (INFORMAR QTDE DE DIAS)', VALOR: '' },
    { TABELA: 'DEVOLUCAO', CAMPO: 'BANCO', DESCRICAO: 'DEFINIRÁ O BANCO DA ANTECIPAÇÃO GERADA AO EFETUAR UMA DEVOLUÇÃO', VALOR: '' },
    { TABELA: 'DEVOLUCAO', CAMPO: 'CONTA', DESCRICAO: 'DEFINIRÁ A CONTA DA ANTECIPAÇÃO GERADA AO EFETUAR UMA DEVOLUÇÃO (INFORMAR O NÚMERO DA CONTA)', VALOR: '' },
    { TABELA: 'DEVOLUCAO', CAMPO: 'CLASSE', DESCRICAO: 'DEFINIRÁ A CLASSE DA ANTECIPAÇÃO GERADA AO EFETUAR UMA DEVOLUÇÃO', VALOR: '' },
    { TABELA: 'DEVOLUCAO', CAMPO: 'HISTORICO', DESCRICAO: 'DEFINIRÁ O HISTÓRICO DA ANTECIPAÇÃO GERADA AO EFETUAR UMA DEVOLUÇÃO', VALOR: '' },
    { TABELA: 'DEVOLUCAO', CAMPO: 'SITUACAO', DESCRICAO: 'DEFINIRÁ O SITUAÇÃO DA ANTECIPAÇÃO GERADA AO EFETUAR UMA DEVOLUÇÃO', VALOR: '' },
    { TABELA: 'DEVOLUCAO', CAMPO: 'MOEDA', DESCRICAO: 'DEFINIRÁ A MOEDA DA ANTECIPAÇÃO GERADA AO EFETUAR UMA DEVOLUÇÃO', VALOR: '' },
    { TABELA: 'DEVOLUCAO', CAMPO: 'DEPOSITO', DESCRICAO: 'DEFINIRÁ O DEPÓSITO DE UMA DEVOLUÇÃO', VALOR: '' },
    { TABELA: 'DEVOLUCAO', CAMPO: 'COD_BAIXA_DEVOLUCAO', DESCRICAO: 'CÓDIGO DE BAIXA PADRÃO (DEVOLUÇÃO DE VENDA)', VALOR: '' },
    { TABELA: 'DEVOLUCAO', CAMPO: 'COD_BAIXA_CANC_DEVOL', DESCRICAO: 'CÓDIGO DE BAIXA PADRÃO (CANCELAMENTO DE DEVOLUÇÃO)', VALOR: '' },
    { TABELA: 'DEVOLUCAO', CAMPO: 'COD_BAIXA_DEV_CONS', DESCRICAO: 'CÓDIGO DE BAIXA PADRÃO (DEVOLUÇÃO PARCIAL NO AGRUPAMENTO DE VENDA)', VALOR: '' },

    //ESCRITURAL //RETORNO
    { TABELA: 'RETORNO', CAMPO: 'CARTEIRA_REGISTRO', DESCRICAO: 'DEFINE SE O FLAG "CARTEIRA TEM REGISTRO" VEM SELECIONADO', VALOR: '' },
    { TABELA: 'RETORNO', CAMPO: 'CARTEIRA', DESCRICAO: 'DEFINE O VALOR PADRÃO DO CAMPO CARTEIRA', VALOR: '' },
    { TABELA: 'RETORNO', CAMPO: 'CLASSE_BAIXA', DESCRICAO: 'DEFINE O VALOR VALOR PADRÃO DO CAMPO CLASSE - BAIXA', VALOR: '' },
    { TABELA: 'RETORNO', CAMPO: 'CLASSE_JUROS', DESCRICAO: 'DEFINE O VALOR VALOR PADRÃO DO CAMPO CLASSE - JUROS', VALOR: '' },
    { TABELA: 'RETORNO', CAMPO: 'CLASSE_DESCONTO', DESCRICAO: 'DEFINE O VALOR VALOR PADRÃO DO CAMPO CLASSE - DESCONTO', VALOR: '' },
    { TABELA: 'RETORNO', CAMPO: 'HISTORICO', DESCRICAO: 'DEFINE O VALOR VALOR PADRÃO DO CAMPO HISTÓRICO', VALOR: '' },

    //EXTRATO_CARTAO
    { TABELA: 'EXTRATO_CARTAO', CAMPO: 'VALOR_DIFERENCA', DESCRICAO: 'CENTAVOS PARA ARREDONDAMENTO ENTRE O VALOR DA DUPLICATA E O VALOR PAGO NO CARTÃO', VALOR: '' },

    //LIBERACAO_EXPEDICAO
    { TABELA: 'LIBERACAO_EXPEDICAO', CAMPO: 'STATUS', DESCRICAO: 'STATUS PADRÃO CONSULTA', VALOR: '' },

    //B2B
    { TABELA: 'B2B_MAIS_MIX', CAMPO: 'TIPO', DESCRICAO: 'TIPO DO PEDIDO PADRÃO MAIS MIX', VALOR: '' },
    { TABELA: 'B2B_MAIS_MIX', CAMPO: 'MOTIVO', DESCRICAO: 'CAMPO MOTIVO QUE SERÁ GRAVADO NA ORDEM DE COMPRA', VALOR: '' },
    { TABELA: 'B2B_MAIS_MIX', CAMPO: 'COLECAO', DESCRICAO: 'CAMPO COLEÇÃO QUE SERÁ GRAVADO NA ORDEM DE COMPRA', VALOR: '' },
    { TABELA: 'B2B_MAIS_MIX', CAMPO: 'EMPRESA', DESCRICAO: 'CAMPO EMPRESA QUE SERÁ GRAVADO NA ORDEM DE COMPRA', VALOR: '' },
    { TABELA: 'B2B_MAIS_MIX', CAMPO: 'FRETE', DESCRICAO: 'CAMPO FRETE QUE SERÁ GRAVADO NA ORDEM DE COMPRA', VALOR: '' },
    { TABELA: 'B2B_MAIS_MIX', CAMPO: 'OBS', DESCRICAO: 'CAMPO OBSERVAÇÃO QUE SERÁ GRAVADO NA ORDEM DE COMPRA', VALOR: '' },
    { TABELA: 'B2B_MAIS_MIX', CAMPO: 'LIBERADO', DESCRICAO: 'CAMPO LIBERADO QUE SERÁ GRAVADO NA ORDEM DE COMPRA', VALOR: '' },
    { TABELA: 'B2B_MAIS_MIX', CAMPO: 'TELA', DESCRICAO: 'CAMPO TELA QUE SERÁ GRAVADO NA ORDEM DE COMPRA', VALOR: '' },
    { TABELA: 'B2B_MAIS_MIX', CAMPO: 'VAL_COTACAO', DESCRICAO: 'CAMPO VALOR DE COTAÇÃO QUE SERÁ GRAVADO NA ORDEM DE COMPRA', VALOR: '' },
    { TABELA: 'B2B_MAIS_MIX', CAMPO: 'SITUACAO', DESCRICAO: 'CAMPO SITUACAO QUE SERÁ GRAVADO NOS ITENS DA ORDEM DE COMPRA', VALOR: '' },
    { TABELA: 'B2B_MAIS_MIX', CAMPO: 'C_CUSTO', DESCRICAO: 'CAMPO C_CUSTO QUE SERÁ GRAVADO NOS ITENS DA ORDEM DE COMPRA', VALOR: '' },

    // CRIAR PEDIDO
    { TABELA: 'CRIAR_PEDIDO', CAMPO: 'FATURA', DESCRICAO: 'FATURA DO PEDIDO', VALOR: '' },
    { TABELA: 'CRIAR_PEDIDO', CAMPO: 'PERIODO', DESCRICAO: 'PERÍODO DO PEDIDO', VALOR: '' },
    { TABELA: 'CRIAR_PEDIDO', CAMPO: 'MOEDA', DESCRICAO: 'MOEDA DO PEDIDO', VALOR: '' },
    { TABELA: 'CRIAR_PEDIDO', CAMPO: 'SITUACAO', DESCRICAO: 'SITUAÇÃO DO PEDIDO', VALOR: '' },
    { TABELA: 'CRIAR_PEDIDO', CAMPO: 'DEPOSITO', DESCRICAO: 'DEPÓSITO DO PEDIDO', VALOR: '' },
    { TABELA: 'CRIAR_PEDIDO', CAMPO: 'STATUS', DESCRICAO: 'STATUS DO PEDIDO', VALOR: '' },
    { TABELA: 'CRIAR_PEDIDO', CAMPO: 'DIAS_FATURA', DESCRICAO: 'ACRESCENTA X DIAS NA DATA DE EMISSÃO PARA SUGERIR A DATA DE FATURA', VALOR: '' },
    { TABELA: 'CRIAR_PEDIDO', CAMPO: 'DIAS_ENTREGA', DESCRICAO: 'ACRESCENTA X DIAS NA DATA DE EMISSÃO PARA SUGERIR A DATA DE ENTREGA', VALOR: '' },
    { TABELA: 'CRIAR_PEDIDO', CAMPO: 'DIAS_SAIDA', DESCRICAO: 'ACRESCENTA X DIAS NA DATA DE EMISSÃO PARA SUGERIR A DATA DE SAÍDA', VALOR: '' },
    { TABELA: 'CRIAR_PEDIDO', CAMPO: 'DIAS_SAIDA', DESCRICAO: 'ACRESCENTA X DIAS NA DATA DE EMISSÃO PARA SUGERIR A DATA DE SAÍDA', VALOR: '' },
    { TABELA: 'CRIAR_PEDIDO', CAMPO: 'EMP_FAT', DESCRICAO: 'DEFINE A EMPRESA DE FATURAMENTO DO PEDIDO', VALOR: '' },
    { TABELA: 'CRIAR_PEDIDO', CAMPO: 'OPERACAO_FISCAL', DESCRICAO: 'DEFINE A OPERAÇÃO FISCAL DO PEDIDO', VALOR: '' },

    //PRECO_MEDIO
    { TABELA: 'PRECO_MEDIO', CAMPO: 'CONSIDERAR_COR', DESCRICAO: 'CONSIDERAR A COR PARA CALCULAR O PREÇO MÉDIO DO PRODUTO', VALOR: '' },
    { TABELA: 'PRECO_MEDIO', CAMPO: 'CONSIDERAR_TAM', DESCRICAO: 'CONSIDERAR O TAMANHO PARA CALCULAR O PREÇO MÉDIO DO PRODUTO', VALOR: '' },
    { TABELA: 'PRECO_MEDIO', CAMPO: 'CONSIDERAR_DEPOSITO', DESCRICAO: 'CONSIDERAR O DEPÓSITO PARA CALCULAR O PREÇO MÉDIO DO PRODUTO', VALOR: '' },
    { TABELA: 'PRECO_MEDIO', CAMPO: 'CONSIDERAR_QUALIDADE', DESCRICAO: 'CONSIDERAR A QUALIDADE PARA CALCULAR O PREÇO MÉDIO DO PRODUTO', VALOR: '' },
    { TABELA: 'PRECO_MEDIO', CAMPO: 'CONSIDERAR_LOTE', DESCRICAO: 'CONSIDERAR O LOTE PARA CALCULAR O PREÇO MÉDIO DO PRODUTO', VALOR: '' },
    { TABELA: 'PRECO_MEDIO', CAMPO: 'CONSIDERAR_LOCAL', DESCRICAO: 'CONSIDERAR O LOCAL PARA CALCULAR O PREÇO MÉDIO DO PRODUTO', VALOR: '' },

    // LOJA/VENDA // ANTECIPAÇÃO PEDIDO
    { TABELA: 'ANTECIPACAO_PEDIDO', CAMPO: 'MOEDA', DESCRICAO: 'MOEDA DA ANTECIPAÇÃO', VALOR: '' },
    { TABELA: 'ANTECIPACAO_PEDIDO', CAMPO: 'CONTA', DESCRICAO: 'CONTA DA ANTECIPAÇÃO', VALOR: '' },
    { TABELA: 'ANTECIPACAO_PEDIDO', CAMPO: 'CLASSE', DESCRICAO: 'CLASSE DA ANTECIPAÇÃO', VALOR: '' },
    { TABELA: 'ANTECIPACAO_PEDIDO', CAMPO: 'HISTORICO', DESCRICAO: 'HISTORICO DA ANTECIPAÇÃO', VALOR: '' },
    { TABELA: 'ANTECIPACAO_PEDIDO', CAMPO: 'BANCO', DESCRICAO: 'BANCO DA ANTECIPAÇÃO', VALOR: '' },
    { TABELA: 'ANTECIPACAO_PEDIDO', CAMPO: 'SITUACAO', DESCRICAO: 'SITUACAO DA ANTECIPAÇÃO', VALOR: '' },

    // ORDEM DE PRODUÇÃO
    { TABELA: 'CADOF', CAMPO: 'DEPOSITO', DESCRICAO: 'CÓDIGO DO DEPÓSITO', VALOR: '' },
    { TABELA: 'CADOF', CAMPO: 'PERIODO', DESCRICAO: 'CÓDIGO DO PERÍODO', VALOR: '' },
    { TABELA: 'CADOF', CAMPO: 'TIPO', DESCRICAO: 'ID DO TIPO', VALOR: '' },
    //ORÇAMENTO
    { TABELA: 'ORCAMENTO', CAMPO: 'MOEDA', DESCRICAO: 'CÓDIGO DA MOEDA', VALOR: '' },
    { TABELA: 'ORCAMENTO', CAMPO: 'HISTORICO', DESCRICAO: 'CÓDIGO DO HISTÓRICO', VALOR: '' },
    { TABELA: 'ORCAMENTO', CAMPO: 'BANCO', DESCRICAO: 'CÓDIGO DO BANCO', VALOR: '' },
    { TABELA: 'ORCAMENTO', CAMPO: 'SITUACAO', DESCRICAO: 'CÓDIGO DA SITUAÇÃO', VALOR: '' },
    { TABELA: 'ORCAMENTO', CAMPO: 'CLASSEGER', DESCRICAO: 'CÓDIGO DA CLASSE GERENCIAL', VALOR: '' },
    { TABELA: 'ORCAMENTO', CAMPO: 'TABPRECO', DESCRICAO: 'CÓDIGO DA TABELA DE PREÇO', VALOR: '' },

    //SERVIÇOS
    { TABELA: 'OS', CAMPO: 'MOEDA', DESCRICAO: 'CÓDIGO DA MOEDA', VALOR: '' },
    { TABELA: 'OS', CAMPO: 'STATUS', DESCRICAO: 'CÓDIGO DO STATUS', VALOR: '' },
    { TABELA: 'OS', CAMPO: 'TAB_PRECO', DESCRICAO: 'CÓDIGO DA TABELA DE PREÇO', VALOR: '' },

    //DEMANDA ECOMMERCE
    { TABELA: 'DEMANDA_ECOMMERCE', CAMPO: 'TIPO_BAIXA', DESCRICAO: 'TIPO DE BAIXA TRANSFERÊNCIA', VALOR: '' },
    { TABELA: 'DEMANDA_ECOMMERCE', CAMPO: 'DEPOSITO', DESCRICAO: 'DEPÓSITO TRANSITÓRIO DO E-COMMERCE PARA ONDE IRÃO AS PEÇAS TRANSFERIDAS', VALOR: '' },

  ];

  criaDataTablePadrao('#tabelaProduto', false, false, false, false, true, false, '400px');
  criaDataTablePadrao('#tabelaMaterial', false, false, false, false, true, false, '400px');
  criaDataTablePadrao('#tabelaEntidade', false, false, false, false, true, false, '400px');
  criaDataTablePadrao('#tabelaPedido', false, false, false, false, true, false, '400px');
  criaDataTablePadrao('#tabelaEntradaNf', false, false, false, false, true, false, '400px');
  criaDataTablePadrao('#tabelaFaturamento', false, false, false, false, true, false, '400px');
  criaDataTablePadrao('#tabelaEstoque', false, false, false, false, true, false, '400px');
  criaDataTablePadrao('#tabelaPrecoMedio', false, false, false, false, true, false, '400px');
  criaDataTablePadrao('#tabelaTransfDep', false, false, false, false, true, false, '400px');
  criaDataTablePadrao('#tabelaReceber', false, false, false, false, true, false, '400px');
  criaDataTablePadrao('#tabelaContasPagar', false, false, false, false, true, false, '400px');
  criaDataTablePadrao('#tabelaLoja', false, false, false, false, true, false, '400px');
  criaDataTablePadrao('#tabelaCashback', false, false, false, false, true, false, '400px');
  criaDataTablePadrao('#tabelaDesdobraLote', false, false, false, false, true, false, '400px');
  criaDataTablePadrao('#tabelaDevolucao', false, false, false, false, true, false, '400px');
  criaDataTablePadrao('#tabelaRetorno', false, false, false, false, true, false, '400px');
  criaDataTablePadrao('#tabelaEnvio', false, false, false, false, true, false, '400px');
  criaDataTablePadrao('#tabelaExtratoCartao', false, false, false, false, true, false, '400px');
  criaDataTablePadrao('#tabelaLiberacaoExpedicao', false, false, false, false, true, false, '400px');
  criaDataTablePadrao('#tabelaPedidoB2BMaisMix', false, false, false, false, true, false, '400px');
  criaDataTablePadrao('#tabelaCriarPedido', false, false, false, false, true, false, '400px');
  criaDataTablePadrao('#tabelaAntecipacaoPedido', false, false, false, false, true, false, '400px');
  criaDataTablePadrao('#tabelaCadOf', false, false, false, false, true, false, '400px');
  criaDataTablePadrao('#tabelaOrcamento', false, false, false, false, true, false, '400px');
  criaDataTablePadrao('#tabelaServicos', false, false, false, false, true, false, '400px');
  criaDataTablePadrao('#tabelaDemandaEcommerce', false, false, false, false, true, false, '400px');

  preencheCampos();
  await carregaValores();

  $('#tabPedido, #tabMaterial, #tabProduto, #tabEntidade, #tabEntradaNf, #tabFaturamento, #tabEstoque, #tabTransfDep, #tabReceber, #tabContasPagar, #tabLoja, #tabCashback, #tabDesdobraLote, #tabVenda, #tabDevolucao, #tabCriarPedido, #tabAntecipacaoPedido, #tabRetorno, #tabEnvio, #tabExtratoCartao, #tabLiberacaoExpedicao, #tabMaisMix, #tabCadOf, #tabOrcamento, #tabServicos, #tabDemandaEcommerce').on('click', function () {
    setTimeout(() => {
      $('#tabelaProduto').DataTable().columns.adjust().draw(false);
      $('#tabelaMaterial').DataTable().columns.adjust().draw(false);
      $('#tabelaEntidade').DataTable().columns.adjust().draw(false);
      $('#tabelaPedido').DataTable().columns.adjust().draw(false);
      $('#tabelaEntradaNf').DataTable().columns.adjust().draw(false);
      $('#tabelaFaturamento').DataTable().columns.adjust().draw(false);
      $('#tabelaEstoque').DataTable().columns.adjust().draw(false);
      $('#tabelaPrecoMedio').DataTable().columns.adjust().draw(false);
      $('#tabelaTransfDep').DataTable().columns.adjust().draw(false);
      $('#tabelaReceber').DataTable().columns.adjust().draw(false);
      $('#tabelaContasPagar').DataTable().columns.adjust().draw(false);
      $('#tabelaLoja').DataTable().columns.adjust().draw(false);
      $('#tabelaCashback').DataTable().columns.adjust().draw(false);
      $('#tabelaDesdobraLote').DataTable().columns.adjust().draw(false);
      $("#tabelaDevolucao").DataTable().columns.adjust().draw(false);
      $("#tabelaRetorno").DataTable().columns.adjust().draw(false);
      $("#tabelaEnvio").DataTable().columns.adjust().draw(false);
      $("#tabelaExtratoCartao").DataTable().columns.adjust().draw(false);
      $("#tabelaLiberacaoExpedicao").DataTable().columns.adjust().draw(false);
      $("#tabelaPedidoB2BMaisMix").DataTable().columns.adjust().draw(false);
      $("#tabelaCriarPedido").DataTable().columns.adjust().draw(false);
      $("#tabelaAntecipacaoPedido").DataTable().columns.adjust().draw(false);
      $("#tabelaCadOf").DataTable().columns.adjust().draw(false);
      $("#tabelaOrcamento").DataTable().columns.adjust().draw(false);
      $("#tabelaServicos").DataTable().columns.adjust().draw(false);
      $("#tabelaDemandaEcommerce").DataTable().columns.adjust().draw(false);
    }, 3000);
  });

  $('#btnGravar').on('click', async function () {
    await gravaDados();
  });

  async function preencheCampos() {
    valoresPadroes.map(async item => {
      if (item.TABELA == 'PRODUTO' && item.CAMPO != 'TIPO_VENDA') {
        $('#tabelaProduto').DataTable().row.add([item.CAMPO, item.DESCRICAO, retornaInput(item.TABELA, item.CAMPO)]).draw(false);
      } else if (item.TABELA == 'MATERIAL') {
        $('#tabelaMaterial').DataTable().row.add([item.CAMPO, item.DESCRICAO, retornaInput(item.TABELA, item.CAMPO)]).draw(false);
      } else if (item.TABELA == 'ENTIDADE' && item.CAMPO == "TIPO_ENTIDADE") {
        $('#tabelaEntidade').DataTable().row.add([item.CAMPO, item.DESCRICAO, `<select id="txt${item.TABELA}${item.CAMPO}" class="input-default focus validate">` +
          `<option value="" selected>Selecione um tipo de entidade</option>` +
          `<option value="CLIENTE">Cliente</option>` +
          `<option value="FORNECEDOR">Fornecedor</option>` +
          `<option value="TERCEIROS">Terceiros</option>` +
          `<option value="REPRESENTANTE">Representante</option>` +
          `<option value="PROSPECTO">Prospecto</option>` +
          `<option value="FUNCIONARIO">Funcionário</option>` +
          `</select>`]).draw(false);
      } else if (item.TABELA == 'ENTIDADE' && item.CAMPO == "TIPO_PESSOA") {
        const tabelaEnt = $('#tabelaEntidade').DataTable();
        const pesquisaParam = {
          tabela: 'TPDOCPESSOA',
          camposSelect: ['DESCRICAO', 'MASCARA'],
          where: ['1 = 1'],
        }
        const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

        if (jsonStr.length > 0) {
          const selectOptions = jsonStr.map(valor => `<option value="${valor.MASCARA}">${valor.DESCRICAO}</option>`).join('');
          const selectHtml = `<select id="txt${item.TABELA}${item.CAMPO}" class="input-default focus validate">
                                    <option value="" selected>Nenhum</option>
                                    ${selectOptions}
                                </select>`;
          tabelaEnt.row.add([item.CAMPO, item.DESCRICAO, selectHtml]).draw(false);
        } else {
          tabelaEnt.row.add([item.CAMPO, item.DESCRICAO, `<select id="txt${item.TABELA}${item.CAMPO}" class="input-default focus validate">
                                                            <option value="" selected>Nenhum</option>
                                                            <option value="###.###.###-##">Física</option>
                                                            <option value="##.###.###/####-##">Jurídica</option>
                                                            <option value="##########-#">Exterior</option>
                                                          </select>`]).draw(false);
        }
      } else if (item.TABELA == "ENTIDADE" && item.CAMPO == 'IE_DESTINATARIO') {
        $('#tabelaEntidade').DataTable().row.add([item.CAMPO, item.DESCRICAO, `<select id="txt${item.TABELA}${item.CAMPO}" class="input-default focus validate">
                                                            <option value="" selected>Nenhum</option>
                                                            <option value="1">Contribuinte ICMS (informar a IE do destinatário)</option>
                                                            <option value="2">Contribuinte isento de Inscrição no cadastro de Contribuintes do ICMS</option>
                                                            <option value="9">Não Contribuinte, que pode ou não possuir Inscrição Estadual no Cadastro de Contribuintes do ICMS</option>
                                                          </select>`]).draw(false);
      } else if (item.TABELA == "ENTIDADE") {
        $('#tabelaEntidade').DataTable().row.add([item.CAMPO, item.DESCRICAO, retornaInput(item.TABELA, item.CAMPO)]).draw(false);
      } else if (item.TABELA == 'PEDIDO') {
        $('#tabelaPedido').DataTable().row.add([item.CAMPO, item.DESCRICAO, retornaInput(item.TABELA, item.CAMPO)]).draw(false);
      } else if (item.TABELA == 'NOTA_ENTRA' && item.CAMPO != 'TIPO_ITEM') {
        $('#tabelaEntradaNf').DataTable().row.add([item.CAMPO, item.DESCRICAO, retornaInput(item.TABELA, item.CAMPO)]).draw(false);
      } else if (item.TABELA == 'NOTA' && (item.CAMPO != 'ENDERECO_A_FATURAR') && (item.CAMPO != 'NAO_ALTERA_DIFAL')) {
        $('#tabelaFaturamento').DataTable().row.add([item.CAMPO, item.DESCRICAO, retornaInput(item.TABELA, item.CAMPO)]).draw(false);
      } else if (item.TABELA == 'ESTOQUE') {
        $('#tabelaEstoque').DataTable().row.add([item.CAMPO, item.DESCRICAO, retornaInput(item.TABELA, item.CAMPO)]).draw(false);
      } else if (item.TABELA == 'TRANSF_DEPOSITO') {
        $('#tabelaTransfDep').DataTable().row.add([item.CAMPO, item.DESCRICAO, retornaInput(item.TABELA, item.CAMPO)]).draw(false);
      } else if (item.TABELA == 'RECEBER' && item.CAMPO == 'CLASSE') {
        $('#tabelaReceber').DataTable().row.add([item.CAMPO, item.DESCRICAO, retornaInput(item.TABELA, item.CAMPO)]).draw(false);
      } else if (item.TABELA == 'RECEBER' && item.CAMPO == 'STATUS') {
        $('#tabelaReceber').DataTable().row.add([item.CAMPO, item.DESCRICAO, `<select id="txt${item.TABELA}${item.CAMPO}" class="input-default focus validate">
                                                                             <option value="TODOS">Todos</option>
                                                                             <option value="DUPL" selected>Duplicatas</option>
                                                                             <option value="ANTE">Antecipações</option>
                                                                             <option value="ORCA">Orçamentos</option>
                                                                             <option value="CHEQ">Cheques</option>
                                                                             <option value="CHDE">Cheques Devolvidos</option>
                                                                             <option value="DESD">Desdobradas</option>
                                                                             <option value="AGRU">Agrupadas</option>
                                                                             <option value="CANC">Canceladas</option>
                                                                             <option value="DEVO">Devolução</option>
                                                                             <option value="AVDD">Aviso Débito</option>
                                                                             <option value="PRESENTE">Cartão Presente</option>
                                                                             </select>` ]).draw(false);
      } else if (item.TABELA == 'RECEBER' && item.CAMPO == 'SITUACAO') {
        $('#tabelaReceber').DataTable().row.add([item.CAMPO, item.DESCRICAO, `<select id="txt${item.TABELA}${item.CAMPO}" class="input-default focus validate">
                                                                              <option value="Todos">Todos</option>
                                                                              <option value="Em Aberto" selected>Em Aberto</option>
                                                                              <option value="Perdidas">Perdidas</option>
                                                                              <option value="Pagas">Pagas</option>
                                                                              </select>`]).draw(false);
      } else if (item.TABELA == 'RECEBER') {
        $('#tabelaReceber').DataTable().row.add([item.CAMPO, item.DESCRICAO, retornaInput(item.TABELA, item.CAMPO)]).draw(false);
      } else if (item.TABELA == 'RECEBER' && item.CAMPO == 'EMISSAO_DE') {
        $('#tabelaReceber').DataTable().row.add([item.CAMPO, item.DESCRICAO, retornaInput(item.TABELA, item.CAMPO)]).draw(false);
      } else if (item.TABELA == 'RECEBER' && item.CAMPO == 'VENCIMENTO_DE') {
        $('#tabelaReceber').DataTable().row.add([item.CAMPO, item.DESCRICAO, retornaInput(item.TABELA, item.CAMPO)]).draw(false);
      } else if (item.TABELA == 'RECEBER' && item.CAMPO == 'PAGAMENTO_DE') {
        $('#tabelaReceber').DataTable().row.add([item.CAMPO, item.DESCRICAO, retornaInput(item.TABELA, item.CAMPO)]).draw(false);
      } else if (item.TABELA == 'PAGTO' &&
        (item.CAMPO == 'CONTA' || item.CAMPO == 'BANCO' || item.CAMPO == 'SITUACAO_CODIGO' || item.CAMPO == 'HISTORICO' || item.CAMPO == 'CLASSE_GERENCIAL' || item.CAMPO == 'SITUACAO_DUP' || item.CAMPO == 'FORNECEDOR')) {
        $('#tabelaContasPagar').DataTable().row.add([item.CAMPO, item.DESCRICAO, retornaInput(item.TABELA, item.CAMPO)]).draw(false);
      } else if (item.TABELA == 'PAGTO' && item.CAMPO == 'EMISSAO_DE') {
        $('#tabelaContasPagar').DataTable().row.add([item.CAMPO, item.DESCRICAO, retornaInput(item.TABELA, item.CAMPO)]).draw(false);
      } else if (item.TABELA == 'PAGTO' && item.CAMPO == 'VENCIMENTO_DE') {
        $('#tabelaContasPagar').DataTable().row.add([item.CAMPO, item.DESCRICAO, retornaInput(item.TABELA, item.CAMPO)]).draw(false);
      } else if (item.TABELA == 'PAGTO' && item.CAMPO == 'INTERVALO_DIAS_EMISSAO') {
        $('#tabelaContasPagar').DataTable().row.add([item.CAMPO, item.DESCRICAO, retornaInput(item.TABELA, item.CAMPO)]).draw(false);
      } else if (item.TABELA == 'PAGTO' && item.CAMPO == 'STATUS') {
        $('#tabelaContasPagar').DataTable().row.add([item.CAMPO, item.DESCRICAO, `<select id="txt${item.TABELA}${item.CAMPO}" class="input-default focus validate">
                                                                                  <option value="">Todos</option>
                                                                                  <option value="DUPL">A.Ps</option>
                                                                                  <option value="ANTE">Antecipações</option>
                                                                                  <option value="ORCA">Orçamentos</option>
                                                                                  <option value="CHEQ">Cheques</option>
                                                                                  <option value="CHDE">Cheques Devolvidos</option>
                                                                                  <option value="CHCA">Cheques Cancelados</option>
                                                                                  <option value="DESD">Desdobradas</option>
                                                                                  <option value="AGRU">Agrupadas</option>
                                                                                </select>` ]).draw(false);
      } else if (item.TABELA == 'PAGTO' && item.CAMPO == 'SITUACAO') {
        $('#tabelaContasPagar').DataTable().row.add([item.CAMPO, item.DESCRICAO, `<select id="txt${item.TABELA}${item.CAMPO}" class="input-default focus validate">
                                                                                <option value="">Todos</option>
                                                                                <option value="Aberto">Aberto</option>
                                                                                <option value="Pagas">Pagas</option>
                                                                                <option value="Devolvidas">Devolvidas</option>
                                                                                </select>`]).draw(false);
      } else if (item.TABELA == 'LOJA') {
        $('#tabelaLoja').DataTable().row.add([item.CAMPO, item.DESCRICAO, retornaInput(item.TABELA, item.CAMPO)]).draw(false);
      } else if (item.TABELA == 'CASHBACK') {
        $('#tabelaCashback').DataTable().row.add([item.CAMPO, item.DESCRICAO, retornaInput(item.TABELA, item.CAMPO)]).draw(false);
      } else if (item.TABELA == "DESDOBRALOTE" && item.CAMPO == "SEQ_LOTE_DESDOBRADO") {
        $('#tabelaDesdobraLote').DataTable().row.add([item.CAMPO, item.DESCRICAO, `<select id="txt${item.TABELA}${item.CAMPO}" class="input-default focus validate">` +
          `<option value="" selected>Selecione o tamanho do sequencial</option>` +
          `<option value="1">1</option>` +
          `<option value="2">2</option>` +
          `<option value="3">3</option>` +
          `<option value="4">4</option>` +
          `</select>`]).draw(false);
      }
      else if (item.TABELA == 'DESDOBRALOTE') {
        $('#tabelaDesdobraLote').DataTable().row.add([item.CAMPO, item.DESCRICAO, retornaInput(item.TABELA, item.CAMPO)]).draw(false);
      } else if (item.TABELA == 'EXTRATO_CARTAO') {
        $('#tabelaExtratoCartao').DataTable().row.add([item.CAMPO, item.DESCRICAO, retornaInput(item.TABELA, item.CAMPO)]).draw(false);
      } else if (item.TABELA == 'RETORNO' && item.CAMPO == 'CARTEIRA_REGISTRO') {
        $('#tabelaRetorno').DataTable().row.add([item.CAMPO, item.DESCRICAO, `<select id="txt${item.TABELA}${item.CAMPO}" class="input-default focus validate">
                                                                                  <option value="">Todos</option>
                                                                                  <option value="S">Selecionado</option>
                                                                                  <option value="N">Não Seleciona</option>
                                                                                </select>` ]).draw(false);
      } else if (item.TABELA == 'RETORNO' && item.CAMPO == 'CARTEIRA') {
        $('#tabelaRetorno').DataTable().row.add([item.CAMPO, item.DESCRICAO, retornaInput(item.TABELA, item.CAMPO)]).draw(false);
      } else if (item.TABELA == 'RETORNO' && item.CAMPO == 'CLASSE_BAIXA') {
        $('#tabelaRetorno').DataTable().row.add([item.CAMPO, item.DESCRICAO, retornaInput(item.TABELA, item.CAMPO)]).draw(false);
      } else if (item.TABELA == 'RETORNO' && item.CAMPO == 'CLASSE_JUROS') {
        $('#tabelaRetorno').DataTable().row.add([item.CAMPO, item.DESCRICAO, retornaInput(item.TABELA, item.CAMPO)]).draw(false);
      } else if (item.TABELA == 'RETORNO' && item.CAMPO == 'CLASSE_DESCONTO') {
        $('#tabelaRetorno').DataTable().row.add([item.CAMPO, item.DESCRICAO, retornaInput(item.TABELA, item.CAMPO)]).draw(false);
      } else if (item.TABELA == 'RETORNO' && item.CAMPO == 'HISTORICO') {
        $('#tabelaRetorno').DataTable().row.add([item.CAMPO, item.DESCRICAO, retornaInput(item.TABELA, item.CAMPO)]).draw(false);
      } else if (item.TABELA == 'PRODUTO' && item.CAMPO == 'TIPO_VENDA') {
        $('#tabelaProduto').DataTable().row.add([item.CAMPO, item.DESCRICAO, `<select id="txt${item.TABELA}${item.CAMPO}" class="input-default focus validate">` +
          `<option value="" selected></option>` +
          `<option value="0">Produção</option>` +
          `<option value="1">Revenda</option>` +
          `</select>`]).draw(false);
      } else if (item.TABELA == 'NOTA_ENTRA' && item.CAMPO == 'TIPO_ITEM') {
        $('#tabelaEntradaNf').DataTable().row.add([item.CAMPO, item.DESCRICAO, `<select id="txt${item.TABELA}${item.CAMPO}" class="input-default focus validate">` +
          `<option value="" selected></option>` +
          `<option value="P">P</option>` +
          `<option value="M">M</option>` +
          `</select>`]).draw(false);
      } else if (item.TABELA == 'NOTA' && item.CAMPO == 'ENDERECO_A_FATURAR') {
        $('#tabelaFaturamento').DataTable().row.add([item.CAMPO, item.DESCRICAO, `<select id="txt${item.TABELA}${item.CAMPO}" class="input-default focus validate">` +
          `<option value="P" selected>PADRÃO</option>` +
          `<option value="ENT">ENTREGA</option>` +
          `<option value="COB">COBRANÇA</option>` +
          `<option value="EMP">EMPRESA</option>` +
          `<option value="PED">PEDIDO</option>` +
          `</select>`]).draw(false);
      } else if (item.TABELA == 'NOTA' && item.CAMPO == 'NAO_ALTERA_DIFAL') {
        $('#tabelaFaturamento').DataTable().row.add([item.CAMPO, item.DESCRICAO, `<select id="txt${item.TABELA}${item.CAMPO}" class="input-default focus validate">` +
          `<option value="N" selected>NÃO</option>` +
          `<option value="S">SIM</option>` +
          `</select>`]).draw(false);
      } else if (item.TABELA == "DEVOLUCAO") {
        $('#tabelaDevolucao').DataTable().row.add([item.CAMPO, item.DESCRICAO, retornaInput(item.TABELA, item.CAMPO)]).draw(false);
        if (item.CAMPO == "VENC_ANTECIPACAO") {
          $(`#txt${item.TABELA + item.CAMPO}`).on("blur", function () {
            if ($(`#txt${item.TABELA + item.CAMPO}`).val() == "") {
              $(`#txt${item.TABELA + item.CAMPO}`).val("0");
            }
          })
          $(`#txt${item.TABELA + item.CAMPO}`).trigger("blur");
        }
      } else if (item.TABELA == 'LIBERACAO_EXPEDICAO') {
        $('#tabelaLiberacaoExpedicao').DataTable().row.add([item.CAMPO, item.DESCRICAO, retornaInput(item.TABELA, item.CAMPO)]).draw(false);
      } else if (item.TABELA == 'B2B_MAIS_MIX') {
        $('#tabelaPedidoB2BMaisMix').DataTable().row.add([item.CAMPO, item.DESCRICAO, retornaInput(item.TABELA, item.CAMPO)]).draw(false);
      } else if (item.TABELA == 'CRIAR_PEDIDO' && item.CAMPO == 'EMP_FAT') {
        $('#tabelaCriarPedido').DataTable().row.add([item.CAMPO, item.DESCRICAO, `<select id="txt${item.TABELA}${item.CAMPO}" class="input-default focus validate">`]).draw(false);
      } else if (item.TABELA == 'CRIAR_PEDIDO') {
        $('#tabelaCriarPedido').DataTable().row.add([item.CAMPO, item.DESCRICAO, retornaInput(item.TABELA, item.CAMPO)]).draw(false);
      } else if (item.TABELA == 'ANTECIPACAO_PEDIDO') {
        $('#tabelaAntecipacaoPedido').DataTable().row.add([item.CAMPO, item.DESCRICAO, retornaInput(item.TABELA, item.CAMPO)]).draw(false);
      } else if (item.TABELA == 'PRECO_MEDIO') {
        $('#tabelaPrecoMedio').DataTable().row.add([item.CAMPO, item.DESCRICAO, `<select id="txt${item.TABELA}${item.CAMPO}" class="input-default focus validate">` +
          `<option value="N" selected>Não</option>` +
          `<option value="S">Sim</option>` +
          `</select>`]).draw(false);
      } else if (item.TABELA == "CADOF") {
        $('#tabelaCadOf').DataTable().row.add([item.CAMPO, item.DESCRICAO, retornaInput(item.TABELA, item.CAMPO)]).draw(false);
      } else if (item.TABELA == "ORCAMENTO") {
        $('#tabelaOrcamento').DataTable().row.add([item.CAMPO, item.DESCRICAO, retornaInput(item.TABELA, item.CAMPO)]).draw(false);
      } else if (item.TABELA == "OS") {
        $('#tabelaServicos').DataTable().row.add([item.CAMPO, item.DESCRICAO, retornaInput(item.TABELA, item.CAMPO)]).draw(false);
      } else if (item.TABELA == "DEMANDA_ECOMMERCE") {
        $('#tabelaDemandaEcommerce').DataTable().row.add([item.CAMPO, item.DESCRICAO, retornaInput(item.TABELA, item.CAMPO)]).draw(false);
      }
    });

    await adicionaEmpresas();
  };

  async function adicionaEmpresas() {
    const pesquisaParam = {
      tabela: 'EMPRESA',
      camposSelect: ['EMP_PAT', 'EMP_NOME'],
      where: ['1 = 1'],
      orderBy: ['EMP_PAT']
    }
    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));
    jsonStr.map(emp => {
      $("#txtCRIAR_PEDIDOEMP_FAT").append(new Option(`${emp.EMP_PAT} - ${emp.EMP_NOME}`, emp.EMP_PAT.replace('_', '')));
    });
  };

  function retornaInput(sTabela, sCampo) {
    return `<input type="text" class="input-default focus" id="txt${sTabela}${sCampo}">`;
  };

  async function carregaValores() {
    let valores
    valores = await retornaJsonPesquisaPadrao(JSON.stringify({ tabela: "TABPADRAO", camposSelect: ["CAMPO", "TABELA", "VALOR"] }));
    valores.map(item => { insereValor(`#txt${item.TABELA}${item.CAMPO}`, item.VALOR); });
  };

  $('#tabLoja').on('click', function () {
    $('#tabVenda').trigger('click')
  })

  $('#tabEstoque').on('click', function () {
    $('#tabMovimentacao').trigger('click')
  })

  async function gravaDados() {
    $.LoadingOverlay('show');
    try {
      valoresPadroes.map(item => {
        item.VALOR = pegaValor(`#txt${item.TABELA}${item.CAMPO}`);
      });

      const response = await requisicao('POST', '/sisplan/cadastros/v1/cadpadrao?', '', JSON.stringify({ LISTAITENS: valoresPadroes }), 60000);

      if (!response) {
        msgAlerta('Não foi possível gravar os valores padrões, tente novamente.');
        return;
      };

      if (response.status != 200) {
        msgAlerta('Não foi possível gravar os valores padrões, tente novamente.');
        return;
      };

      criaMensagemSucesso('Valores padrões gravados com sucesso.');

    } catch (error) {
      console.error(error);
    } finally {
      $.LoadingOverlay('hide')
    }
  };

});
