$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
    });
    driver.defineSteps([
      {
        element: "#btnFiltros",
        popover: {
          title: "Botão Filtros",
          description: "Clique aqui para filtrar a consulta.",
          position: "right",
        },
      },
      {
        element: "#btnIncluir",
        popover: {
          title: "Botão Incluir",
          description: "Clique aqui para incluir uma nova ordem de produção.",
          position: "right",
        },
      },
      {
        element: "#btnImprimir",
        popover: {
          title: "Botão Imprimir",
          description: "Clique aqui para imprimir os dados consultados.",
          position: "right",
        },
      },
      {
        element: "#divTabelaOrdemProducao",
        popover: {
          title: "Tabela",
          description: "Aqui estão os dados das ordens de produção consultadas.",
          position: "bottom",
        },
      },
    ]);
    driver.start();
  });
});

$(document).ready(async function () {
  const permissaoUsuarioLogado = await permissaoAcessos("CADOF");

  MontaPesquisa();

  let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

  // aqui so valida se nao existe tem que criar para nao dar erro
  if (colunas == null || colunas.cadof == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, cadof: ['EMPRESA'] }))
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
  }

  $('#btnLimparFiltros').on('click', function () {
    $('#btnLimpaOrdemProducao').trigger('click');
    $('#btnLimpaProduto').trigger('click');
    $('#btnLimpaTipo').trigger('click');
    $('#btnLimpaTabPrazo').trigger('click');
    $('#btnLimpaMaquina').trigger('click');
    $('#btnLimpaDeposito').trigger('click');
    $('#txtDataCadastroIni').val('1200-01-01');
    $('#txtDataCadastroFim').val('2500-12-31');
    $('#txtDataInicioIni').val('1200-01-01');
    $('#txtDataInicioFim').val('2500-12-31');
    $('#txtDataFimIni').val('1200-01-01');
    $('#txtDataFimFim').val('2500-12-31');
  });

  $('#btnFiltros').on('click', function () {
    $('#modal-filtros').modal('show');
  });

  $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
    const cols = [];

    let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

    $('#tabelaOrdemProducao').DataTable().columns().every(function () {
      cols.push({
        'title': $(this.header()).text(),
        'data': this.dataSrc()
      })
    });

    adicionaColunas(cols, colunasInvisiveis.cadof ?? ['EMPRESA']);
  })

  $('#btnConfirmarColunas').on('click', async function () {
    try {
      $.LoadingOverlay('show');

      const novasColunas = retornaNovasColunasInvisiveis();

      localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, cadof: novasColunas }))

      $('#tabelaOrdemProducao').DataTable().columns().visible(true);

      $('#tabelaOrdemProducao').DataTable().columns().every(function () {
        if ((novasColunas).indexOf(this.dataSrc()) != -1) {
          this.visible(false);
        }
      })

    } finally {
      $.LoadingOverlay('hide');
      $('#modal-ColunasVisiveis').modal('hide');
    }
  })

  async function consultaOrdemProducao() {
    $.LoadingOverlay("show");
    try {
      if ($("#txtOrdem option").toArray().lenght > 0) {
        retornaHintRelatorio('btnImprimir', $('#txtOrdem option').toArray().map(map => { return [map.selected, $(map).attr('nome_prt')] }).filter(filter => filter[0] == true)[0][1])
      }
      if ($.fn.DataTable.isDataTable('#tabelaOrdemProducao')) {
        $('#tabelaOrdemProducao').DataTable().destroy();
        $('#tabelaOrdemProducao').empty();
      }
      const url = '/sisplan/cadof/v1/acessocadof?';
      const filtros = await retornaFiltros();
      const response = await requisicao('GET', url, filtros, 50000);

      if (!response) {
        return;
      }

      const jsonStr = await response.json();

      if (jsonStr.length == 0) {
        msgAlerta('Nenhum registro encontrado!');
        return;
      }

      if (response.status != 200) {
        msgAlerta(jsonStr.mensagem);
        return;
      }
      const colunasItens = jsonStr.length > 0 ? Object.entries(jsonStr[0]).map(item => ({
        title: item[0],
        data: item[0]
      })) : [];

      $('#tabelaOrdemProducao').DataTable({
        search: false,
        filter: false,
        order: [],
        sort: true,
        destroy: true,
        "language": {
          "sEmptyTable": "Nenhum registro encontrado",
          "sInfo": "_TOTAL_ registros",
          "sInfoEmpty": " 0 registros",
          "sInfoFiltered": "(Filtrados de _MAX_ registros)",
          "sInfoPostFix": "",
          "sInfoThousands": ".",
          "sLengthMenu": "_MENU_ resultados",
          "sLoadingRecords": "Carregando...",
          "sProcessing": "Processando...",
          "sZeroRecords": "Nenhum registro encontrado",
          "sSearch": "Pesquisar",
          "oPaginate": {
            "sNext": "Próximo",
            "sPrevious": "Anterior",
            "sFirst": "Primeiro",
            "sLast": "Último"
          },
          "oAria": {
            "sSortAscending": ": Ordenar colunas de forma ascendente",
            "sSortDescending": ": Ordenar colunas de forma descendente"
          }
        },

        "autoWidth": true,
        "data": jsonStr,
        "columns": colunasItens,
        autoWidth: true,
        "colReorder": true,
        "columnDefs": [{
          targets: [0], render: function (data, type, row) {
            return retornaBotaoOpcoes(data);
          }
        },
        {
          "type": 'date-br',
          "targets": 1,
          "render": function (data) {
            if (data != undefined) {
              x = data.slice(0, 10).split('-');
              return `${x[2]}/${x[1]}/${x[0]}`;
            } else {
              return ''
            }
          }
        },{
          targets: [7, 8, 9, 10],
          visible: false
        }]
      });

      const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
      $('#tabelaOrdemProducao_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
      $('#tabelaOrdemProducao_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');

      $('#buttonColVis').prop('title', 'Configurar colunas visíveis')
      $('#buttonExcel').prop('title', 'Exportar')

      $('#buttonColVis').on('click', async function () {
        $.LoadingOverlay('show');
        $('#modal-ColunasVisiveis').modal('show');
        $.LoadingOverlay('hide');
      });

      $('#buttonExcel').on('click', async function () {
        const filtros = await retornaFiltros();
        const url = `/sisplan/movimentacaofaccao/v1/movimentacaofaccao?`;

        await exportaCSV(url, filtros, false, null, 'Relatório da aba acesso da movimentação de facção', '#tabelaOrdemProducao');
      })

      $('#tabelaOrdemProducao').DataTable().columns().every(function () {
        if ((colunasInvisiveis.cadof).indexOf(this.dataSrc()) != -1) {
          this.visible(false);
        }
      });

      $.LoadingOverlay("hide");
    } catch (error) {
      console.error(error);
    } finally {
      $.LoadingOverlay("hide");
    }
  }

  function retornaBotaoOpcoes(data) {
    const retorno = '<div style="text-align:start;"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" id="tutorialTabela" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + data + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu"> ' +
      '    <button class="dropdown-item" type="button" title="Alterar" id="btnAlterar">Alterar</button>  ' +
      '    <button class="dropdown-item" type="button" title="Duplicar" id="btnDuplicar">Duplicar</button>  ' +
      '    <button class="dropdown-item" type="button" title="ImprimirIndividual" id="btnImprimirIndividual">Imprimir</button>  ' +
      '    <button class="dropdown-item" type="button" title="Excluir" id="btnExcluir">Excluir</button>  ' +
      '    <button class="dropdown-item" type="button" title="ExcluirConsumos" id="btnExcluirConsumos">Excluir Consumos</button>  ' +
      '    <button class="dropdown-item" type="button" title="ImprimirTag" id="btnImprimirTag">Imprimir Tag</button>  ' +
      '</div>';
    '</div>';
    return retorno;
  };

  $('#tabelaOrdemProducao').on('click', '#btnAlterar', async function () {
    await alterarOF(this);
  });

  $('#tabelaOrdemProducao').on('click', '#btnDuplicar', async function () {
    await duplicarOF(this);
  });

  $('#tabelaOrdemProducao').on('click', '#btnExcluir', async function () {
    await ExcluirOF(this);
  });

  $('#tabelaOrdemProducao').on('click', '#btnExcluirConsumos', async function () {
    await ExcluirConsumosOF(this);
  });

  $('#tabelaOrdemProducao').on('click', '#btnImprimirTag', async function () {
    await ImprimirTag(this);
  });

  $('#tabelaOrdemProducao').on('click', '#btnImprimirIndividual', async function () {
    $.LoadingOverlay("show");
    try {
      const data = $('#tabelaOrdemProducao').DataTable().row($(this).parents('tr')).data();

      const pesquisaParam = {
        tabela: "PA_ITEN",
        camposSelect: [
          "DISTINCT COR"
        ],
        where: [`CODIGO = '${data.CODIGO}'`],
      };

      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));
      const arrayCores = []

      for (let i = 0; i < jsonStr.length; i++) {
        arrayCores.push(jsonStr[i].COR)
      }

      const coresFormatadas = await formataListas(arrayCores.toString())

      const filtros = `NUMERO='${data.NUMERO}'&CODIGO_PROD=${data.CODIGO}&CORES_PROD=${coresFormatadas}`;
      const url = `/sisplan/impressao/v1/acessocadofindividual?${filtros}`;
      const bImprimeAutomatico = await verificaImprimirAutomatico('AcessoCadOFIndividual');
      let arquivo = await GeraRelatorio(`${url}&`, "GET", 15000, false, 'AcessoCadOFIndividual');
      if (arquivo != undefined) {
        if (!bImprimeAutomatico) {
          window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, "_blank");
        }
        await limparRelatorios();
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  });

  $('#tabelaOrdemProducao').on('dblclick', 'tr', async function () {
    await alterarOF(this, true);
  });

  $('#btnConsultar').on('click', async function () {
    $('#modal-filtros').modal('hide');
    await consultaOrdemProducao();
  });

  $('#btnIncluir').on('click', async function () {
    if (permissaoUsuarioLogado.INCLUI == 'S') {
      window.location.href = "cadof/create";
    } else {
      msgAlertaSemConfirmacao("Sem permissão para incluir!");
    }
  });

  preencheOrdenacaoTela('AcessoCadOF')
  retornaHintRelatorio('btnImprimir', 'CadOfAcesso')

  $("#btnImprimir").on("click", async function () {
    try {
      $.LoadingOverlay("show");
      const filtros = await retornaFiltros();
      const url = `/sisplan/impressao/v1/acessocadof?`;
      const ordem = `&TELA_ORDENACAO=CadOfAcesso&ORDEM_ORDENACAO=${$('#txtOrdem').val()}`;
      const bImprimeAutomatico = await verificaImprimirAutomatico('AcessoCadOF');
      const arquivo = await GeraRelatorio(`${url}${filtros}${ordem}&`, "GET", 15000, false, 'AcessoCadOF');
      if (arquivo != undefined) {
        if (!bImprimeAutomatico) {
          window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, "_blank");
        }
        await limparRelatorios();
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  });

  function MontaPesquisa() {
    componenteFiltro('ordemProducao', true);
    componenteFiltro('produto', true);
    componenteFiltro('tipo', true);
    componenteFiltro('tabPrazo', true);
    componenteFiltro('maquina', true);
    componenteFiltro('deposito', true);
  }

  async function retornaFiltros() {
    const dtInicioDe = $('#txtDataInicioIni').val();
    const dtInicioAte = $('#txtDataInicioFim').val();
    const dtFimDe = $('#txtDataFimIni').val();
    const dtFimAte = $('#txtDataFimFim').val();
    const dtCadastroDe = $('#txtDataCadastroIni').val();
    const dtCadastroAte = $('#txtDataCadastroFim').val();
    const numero = await formataListas($('#txtOrdemProducao').val().toString());
    const produto = await formataListas($('#txtProduto').val().toString());
    const tipo = await formataListas($('#txtTipo').val().toString());
    const periodo = await formataListas($('#txtTabPrazo').val().toString());
    const deposito = await formataListas($('#txtDeposito').val().toString());
    const maquina = await formataListas($('#txtMaquina').val().toString());
    const retorno = `DT_INICIO_DE=${dtInicioDe}` +
      `&DT_INICIO_ATE=${dtInicioAte}` +
      `&DT_FINAL_DE=${dtFimDe}` +
      `&DT_FINAL_ATE=${dtFimAte}` +
      `&DATA_CAD_DE=${dtCadastroDe}` +
      `&DATA_CAD_ATE=${dtCadastroAte}` +
      `&NUMERO=${numero}` +
      `&PRODUTO=${produto}` +
      `&TIPO=${tipo}` +
      `&PERIODO=${periodo}` +
      `&DEPOSITO=${deposito}` +
      `&MAQUINA=${maquina}`;

    return retorno;
  }

  async function alterarOF(registro, dblclick = false) {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data
      if (!dblclick) {
        data = $('#tabelaOrdemProducao').DataTable().row($(registro).parents('tr')).data();
      } else {
        data = $('#tabelaOrdemProducao').DataTable().row($(registro)).data();
      }
      let registroLiberado = await verificarRegistro('NUMERO', data.NUMERO);
      if (registroLiberado) {
        window.location.href = `cadof/${data.NUMERO}`;
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  }

  async function duplicarOF(registro) {
    if (permissaoUsuarioLogado.INCLUI == 'S') {
      let data = $('#tabelaOrdemProducao').DataTable().row($(registro).parents('tr')).data();
      let registroLiberado = await verificarRegistro('NUMERO', data.NUMERO);
      if (registroLiberado) {
        window.location.href = `cadof/${data.NUMERO}duplicar`;
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para incluir!");
    }
  }

  async function ExcluirOF(registro) {
    if (permissaoUsuarioLogado.EXCLUI == 'S') {
      const data = $('#tabelaOrdemProducao').DataTable().row($(registro).parents('tr')).data();
      const registroLiberado = await verificarRegistro('NUMERO', data.NUMERO);
      if (registroLiberado) {
        const response = await requisicao('DELETE', '/sisplan/cadof/v1/cadof?', `NUMERO=${encodeURIComponent(data.NUMERO)}`, null);

        if (!response) {
          return;
        }
        if (response.status != 200) {
          const jsonStr = await response.json();
          msgErro(jsonStr.mensagem.mensagem);
          return;
        }

        criaMensagemSucesso('Exclusão efetuada com sucesso!', async () => { await consultaOrdemProducao() });
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para incluir!");
    }
  }

  async function ExcluirConsumosOF(registro) {
    if (permissaoUsuarioLogado.EXCLUI == 'S') {
      const data = $('#tabelaOrdemProducao').DataTable().row($(registro).parents('tr')).data();
      const registroLiberado = await verificarRegistro('NUMERO', data.NUMERO);
      if (registroLiberado) {
        const response = await requisicao('DELETE', '/sisplan/cadof/v1/excluiconsumosof?', `NUMERO=${encodeURIComponent(data.NUMERO)}`, null);

        if (!response) {
          return;
        }
        if (response.status != 200) {
          const jsonStr = await response.json();
          msgErro(jsonStr.mensagem);
          return;
        }

        criaMensagemSucesso('Exclusão efetuada com sucesso!');
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para incluir!");
    }
  }

  async function ImprimirTag(registro) {
    $.LoadingOverlay('show')
    try {
      const data = $('#tabelaOrdemProducao').DataTable().row($(registro).parents('tr')).data()
      localStorage.setItem('numoftag', data.NUMERO)
      localStorage.setItem('codprodtag', data.CODIGO)

      parent.document.querySelector('#menu_relatorio_tag .nav-link').click();
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }
  };
});