<?php include_once('../../config.php') ?>

<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Sisplan Web | Consumos</title>
    <!-- Tell the browser to be responsive to screen width -->
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="../plugins/fontawesome-free/css/all.min.css?versao=3.2410.16.2">

    <!-- Theme style -->
    <link rel="stylesheet" href="../dist/css/adminlte.min.css?versao=3.2410.16.2">
    <link rel="stylesheet" href="../dist/css/custom.css?versao=3.2410.16.2">
    <link rel="stylesheet" href="../dist/css/sisplan.css?versao=3.2410.16.2">
    <link rel="stylesheet" type="text/css" href="../plugins/datatables-keytable/css/keyTable.bootstrap4.min.css?versao=3.2410.16.2">
    <!-- Toastr -->
    <link rel="stylesheet" href="../plugins/toastr/toastr.min.css?versao=3.2410.16.2">
    <link rel="stylesheet" href="../plugins/fontawesome-free/css/all.min.css?versao=3.2410.16.2">
    <link rel="shortcut icon" href="../favicon.ico">
    <link rel="stylesheet" type="text/css" href="../dist/css/driver.min.css?versao=3.2410.16.2" />
    <link rel="stylesheet" href="../dist/css/jquery-ui.css?versao=3.2410.16.2">
    <!-- Google Font: Source Sans Pro -->
    <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">
    <!-- overlayScrollbars -->
    <link rel="stylesheet" href="../plugins/overlayScrollbars/css/OverlayScrollbars.min.css?versao=3.2410.16.2">


</head>
<style>
    #msform {
        text-align: start;
        position: relative;
    }

    .card {
        box-shadow: none !important;
        border-radius: 0 !important;
        margin-bottom: 0 !important;
    }

    .card-header {
        box-shadow: 0px 1px rgb(0 0 0 / 20%) !important;
    }

    .card-body {
        margin-left: 0px !important;
        padding-left: 1.25rem !important;
        padding-top: 0px;
        padding-bottom: 0px;
        padding-right: 1.25rem !important;
    }

    .header-content-page .title-page,
    .title-content-page .title,
    .title-page {
        font-size: 20px;
        line-height: normal;
        font-weight: 500;
        color: #343a40;
        margin: 0;
        font-family: Roboto, Arial, sans-serif;
    }

    .form-group {
        margin-bottom: 0.2rem;
    }

    .border-Field {
        border: 1px groove #ddd !important;
        padding: 0 1.4em 1.4em 1.4em !important;
        margin: 0 0 1.5em 0 !important;
        -webkit-box-shadow: 0px 0px 0px 0px #000;
        box-shadow: 0px 0px 0px 0px #000;
    }

    .border-Field .textoBorda {
        font-size: 1.2em !important;
        text-align: left !important;
        width: auto;
        padding: 0 10px;
        border-bottom: none;
    }

    .marginTop {
        margin-top: 8px;
    }

    .table.dataTable tbody td {
        white-space: nowrap;
        text-overflow: ellipsis;
        overflow: hidden;
    }

    .table.dataTable thead th {
        white-space: nowrap;
        text-overflow: ellipsis;
        overflow: hidden;
    }

    #modal-manutencaoconsumos .modal-dialog {
        max-width: none !important;
        max-height: none !important;
        margin: 0 !important;
        height: 100vh !important;
        padding: 4% !important;
    }

    #modal-manutencaoconsumos .modal-dialog {
        max-width: none !important;
        margin: 0 !important;
        height: 100vh !important;
        padding-top: 1% !important;
    }

    #modal-manutencaoconsumos .modal-content {
        max-height: none !important;
        max-width: none !important;
        height: 95vh !important;
        padding: 0 !important;
    }

    #modal-manutencaoconsumos {
        padding-right: 0 !important;
    }

    .bordaProduto {
        padding: 7px;
        border: solid #e0e4e6;
        border-radius: 4px;
        border-width: 2px;
        margin-top: 5px;
    }

    .label-tamanho {
        display: flex;
        align-items: center;
        justify-content: center;
        flex-direction: column;
        text-align: center;
    }

    .content-wrapper {
        margin-left: 0px !important;
    }

    .main-header,
    .main-sidebar {
        display: none;
    }
</style>


<body class="hold-transition sidebar-mini layout-fixed">

    <script type="text/javascript" src="../config.js"></script>
    <main class="wrapper">

        <?php
        include_once('../../menu.php');
        ?>

        <div class="content-wrapper">
            <div class="content-header">
                <div class="container-fluid">
                    <div class="row mb-2">
                        <div class="col-sm-6">
                            <h3 class="col-mb=2">Consumos do Produto</h3>
                        </div>
                        <div class="col-sm-6">
                            <!-- <ol class="breadcrumb float-sm-right">
                                <li class="breadcrumb-item"><a href="./index">Início</a></li>
                                <li class="breadcrumb-item active">Consumos</li>
                            </ol> -->
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-12">
                            <div class="card" style="height:auto;">
                                <div class="card-header">
                                    <div class="row flex col-12">
                                        <div class="col-md-8 col-12" id="CodigoInfoTour">
                                            <label data-error="wrong" data-success="right" for="txtCodigoConsumo">Código *</label>
                                            <div class="input-group">
                                                <input type="text" autocomplete="off" class="input-default focus form-control" id="txtCodigoConsumo" name="txtCodigoConsumo" class="form-control" placeholder="Código">
                                                <div class="input-group-append">
                                                    <button class="btn bg-danger" id="btn-CodigoConsumo" name="btn-CodigoConsumo" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                    <!-- <button class="btn bg-danger" id="btn-limpa-CodigoConsumo" type="button"><i class="m-0 p-0 fas fa-trash"></i></button> -->
                                                </div>
                                                <label data-error="wrong" data-success="right" class="ml-2 mt-1" for="txtCodigoConsumo">Faixa Prod.:</label>
                                                <div class="mb-1 ml-2"><span id="txtFaixaProduto"></span></div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row flex col-12">
                                        <div class="col-md-8 col-12 form-group" id="CodigoInfoTour">
                                            <label class="mt-3 mb-1 col-md-3 col-3">
                                                <input type="checkbox" id="cbSomenteCorAtiva">
                                                <span class="checkmark" style="white-space: nowrap;">Somente Cor Ativa.</span></label>
                                            <label>
                                        </div>
                                    </div>
                                </div>
                                <fieldset>
                                    <div class="card-body" style="padding-left: 0rem!important; padding-right: 0rem!important;">
                                        <form id="msform" name="msform">
                                            <div class="card card-body" style="padding-top: 10px;">
                                                <div class="row">
                                                    <div class="col-sm-12 table-responsive table-selecttable-lg">
                                                        <table id="tabelaConsumos" class="table table-sm table-select table-hover" width="100%">
                                                            <thead>
                                                            </thead>
                                                            <tbody>
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="ml-auto d-flex justify-content-start">
                                                <button type="button" id="btnVoltar" class="btn btn-secondary btn-sisp mb-2 mt-2 ml-2">Voltar</button>
                                                <button type="button" id="btnManutencao" class="btn btn-primary btn-sisp mb-2 mt-2 ml-2 mr-2">Manutenção</button>
                                                <button type="button" id="btnExcluirConsumos" class="btn btn-danger btn-sisp mb-2 mt-2 mr-2">Excluir</button>
                                                <button type="button" id="btnModificacoes" class="btn btn-dark btn-sisp mb-2 mt-2 mr-2 text-white">Modificações</button>
                                                <button type="button" id="btnImprimir" class="btn btn-secondary btn-sisp mb-2 mt-2 mr-2">Imprimir</button>
                                            </div>
                                        </form>
                                    </div>
                                </fieldset>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="modal fade" id="modal-manutencaoconsumos">
            <div class="modal-dialog modal-xl custom-modal" id="tammodal">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title">Manutenção dos Consumos do Produto - [<span id="txtCodigoProdTittle"></span>]
                        </h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-8 col-sm-8">
                                <div>
                                    <div class="row">
                                        <div class="form-row col-12 col-sm-12">
                                            <div class="col-md-10 col-10" id="InsumoInfoTour">
                                                <div class="d-flex justify-content-between">
                                                    <label data-error="wrong" data-success="right" for="txtInsumo">Código: *</label>
                                                    <label data-error="wrong" data-success="right" for="txtInsumo" class="mr-2" style="font-size: 13px !important;">Consultar: Materiais(F4)/Produtos(F2)</label>
                                                </div>
                                                <div class="input-group">
                                                    <input type="text" autocomplete="off" class="input-default focus form-control" id="txtInsumo" name="txtInsumo" class="form-control" placeholder="Código">
                                                    <div class="input-group-append">
                                                        <button class="btn bg-danger" id="btn-CodigoInsumo" name="btn-CodigoInsumo" data-button="absolute" type="button" title='Pesquisa de Materiais'><i class="m-0 p-0 fas fa-search"></i></button>
                                                        <button class="btn bg-danger d-none" id="btn-CodigoInsumoProd" name="btn-CodigoInsumoProd" data-button="absolute" type="button" title='Pesquisa de Produtos'><i class="m-0 p-0 fas fa-search"></i></button>
                                                        <button class="btn bg-danger" id="btn-limpa-CodigoInsumo" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-2 col-2" id="UnidadeInsumoTour">
                                                <label data-error="wrong" data-success="right" for="txtUndInsumo">Unidade:</label>
                                                <div class="input-group">
                                                    <input type="text" autocomplete="off" readonly class="input-default focus form-control" id="txtUndInsumo" name="txtUndInsumo" class="form-control" placeholder="Unidade">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="form-row col-12 col-sm-12">
                                            <div class="col-md-4 col-4" id="SetorInsumoTour">
                                                <label data-error="wrong" data-success="right" for="txtSetorInsumo">Setor: *</label>
                                                <div class="input-group">
                                                    <input type="text" autocomplete="off" class="input-default focus form-control" id="txtSetorInsumo" name="txtSetorInsumo" class="form-control" placeholder="Setor">
                                                    <div class="input-group-append">
                                                        <button class="btn bg-danger" id="btn-SetorInsumo" name="btn-SetorInsumo" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                        <button class="btn bg-danger" id="btn-limpa-SetorInsumo" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-4 col-4" id="AplicacaoInsumoTour">
                                                <label data-error="wrong" data-success="right" for="txtAplicacaoInsumo">Aplicação: *</label>
                                                <div class="input-group">
                                                    <input type="text" autocomplete="off" class="input-default focus form-control" id="txtAplicacaoInsumo" name="txtAplicacaoInsumo" class="form-control" placeholder="Aplicação">
                                                    <div class="input-group-append">
                                                        <button class="btn bg-danger" id="btn-AplicacaoInsumo" name="btn-AplicacaoInsumo" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                        <button class="btn bg-danger" id="btn-limpa-AplicacaoInsumo" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-4 col-4" id="ParteInsumoTour">
                                                <label data-error="wrong" data-success="right" for="txtParteInsumo">Parte: </label>
                                                <div class="input-group">
                                                    <input type="text" autocomplete="off" class="input-default focus form-control" id="txtParteInsumo" name="txtParteInsumo" class="form-control" placeholder="Parte">
                                                    <div class="input-group-append">
                                                        <button class="btn bg-danger" id="btn-ParteInsumo" name="btn-ParteInsumo" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                        <button class="btn bg-danger" id="btn-limpa-ParteInsumo" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-4 col-sm-4 bordaProduto">
                                <label data-error="wrong" data-success="right" for="txtConsumosPorTamanho">Consumos Por Tamanho:</label>
                                <div class="col-12 col-sm-12" id="divConsumosPTamanho">
                                    <div class="table-selecttable-lg">
                                        <table id="tabelaTamanhosDiv" style="width: 100%" class="table table-sm table-select table-hover" width="100%">
                                            <thead>
                                            </thead>
                                            <tbody>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-8 col-sm-8 mt-1 d-flex">
                                <div class="bordaProduto" style="width: 100%">
                                    <label data-error="wrong" data-success="right" for="coresDoProduto">Cores do Produto:</label>
                                    <div class="table-selecttable-lg">
                                        <table id="tabelaCoresProduto" style="width: 100%" class="table table-sm table-select table-hover" width="100%">
                                            <thead>
                                            </thead>
                                            <tbody>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                            <div class="col-4 col-sm-4 mt-2 d-flex bordaProduto">
                                <div style="width: 100%">
                                    <label data-error="wrong" data-success="right" for="coresDoInsumo">Cores do Insumo:</label>
                                    <div class="table-selecttable-lg">
                                        <table id="tabelaCoresInsumo" style="width: 100%; white-space: nowrap" class="table table-sm table-select table-hover" width="100%">
                                            <thead>
                                            </thead>
                                            <tbody>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12 col-sm-12 mt-2 d-flex">
                                <button class="btn btn-primary mr-1 btn-sisp" id="btnIncluirGrade">Incluir</button>
                                <button class="btn btn-primary mr-1 btn-sisp d-none" id="btnConfirmarGrade">Confirmar</button>
                                <button class="btn btn-danger mr-1 btn-sisp d-none" id="btnCancelarGrade">Cancelar</button>
                                <button class="btn btn-secondary mr-1 btn-sisp d-none" id="btnAbreImportarCons">Importar Cons.</button>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12 pr-0">
                                <div class="bordaProduto" style="width: 100%">
                                    <label data-error="wrong" data-success="right" for="gradeDeTamanho">Grade de Tamanhos:</label>
                                    <div class="table-selecttable-lg" style="overflow: auto">
                                        <table id="tabelaGradeTamanho" style="width: 100%" class="table table-sm table-select table-hover" width="100%">
                                            <thead>
                                            </thead>
                                            <tbody>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer" class="d-flex">
                        <div class="mr-auto">
                            <button class="btn btn-primary btn-sisp" id="btnGravarManutencao">Gravar</button>
                            <button type="button" class="btn btn-danger btn-sisp" data-dismiss="modal" id="btnDesistirManutencao">Desistir</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="modal fade" id="modalImportaConsumos" role="dialog" aria-labelledby="mySmallModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-lg modal-dialog-centered" style="width: 450px;">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Importar Consumos</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <label data-error="wrong" class="labelGeral" data-success="right" for="txtCodigoImportacaoConsumos">Produto:</label>
                        <div class="input-group">
                            <input type="text" data-selecionado="false" size="1" class="input-default focus form-control" id="txtCodigoImportacao" name="txtCodigoImportacao" placeholder="Produto">
                            <div class="input-group-append">
                                <button class="btn bg-danger" id="btn-CodigoImportacaoConsumos" name="btn-CodigoImportacaoConsumos" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                <button class="btn bg-danger" id="btn-limpa-CodigoImportacaoConsumos" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                            </div>
                        </div>
                        <label data-error="wrong" class="labelGeral" data-success="right" for="txtParteImportacaoConsumos">Parte:</label>
                        <div class="input-group">
                            <input type="text" data-selecionado="false" size="1" class="input-default focus form-control" id="txtParteImportacaoConsumos" name="txtParteImportacaoConsumos" placeholder="Parte">
                            <div class="input-group-append">
                                <button class="btn bg-danger" id="btn-ParteImportacaoConsumos" name="btn-ParteImportacaoConsumos" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                <button class="btn bg-danger" id="btn-limpa-ParteImportacaoConsumos" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer justify-content-start">
                        <button class="btn btn-primary btn-sisp" id="btnImportaCons">Importar</button>
                        <button class="btn bg-gradient-danger btn-sisp" id="btnFecharModalImportaCons" data-dismiss="modal">Desistir</button>
                    </div>
                </div>
            </div>
        </div>
        <div class="modal fade" id="modal-modificacoes">
            <div class="modal-dialog modal-xl custom-modal" id="tammodal">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title">Modificações dos Consumos do Produto</h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-12 col-sm-12">
                                <div>
                                    <div class="row">
                                        <div class="form-row col-12 col-sm-12">
                                            <div class="col-md-10 col-10" id="InsumoInfoTour">
                                                <div class="d-flex justify-content-between">
                                                    <label data-error="wrong" data-success="right" for="txtProdutoModificacao">Produto: *</label>
                                                </div>
                                                <div class="input-group">
                                                    <input type="text" autocomplete="off" class="input-default focus form-control" id="txtProdutoModificacao" name="txtProdutoModificacao" class="form-control" placeholder="Código">
                                                    <div class="input-group-append">
                                                        <button class="btn bg-danger" id="btn-CodigoProdutoModificacao" name="btn-CodigoProdutoModificacao" data-button="absolute" type="button" title='Pesquisa de Materiais'><i class="m-0 p-0 fas fa-search"></i></button>
                                                        <button class="btn bg-danger d-none" id="btn-CodigoProdutoModificacaoProd" name="btn-CodigoProdutoModificacaoProd" data-button="absolute" type="button" title='Pesquisa de Produtos'><i class="m-0 p-0 fas fa-search"></i></button>
                                                        <button class="btn bg-danger" id="btn-limpa-CodigoProdutoModificacao" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-2 col-2 mt-auto">
                                                <button type="button" class="btn btn-primary btn-sisp" id="btnConsultarModificacoes">Consultar</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12 col-sm-12 mt-0 d-flex ">
                                <div class="card card-body mt-3" style="width: 100%">
                                    <div class="table-selecttable-xl">
                                        <table id="tabelaModificacoes" style="width: 100%" class="table table-sm table-select table-hover" width="100%">
                                            <thead>
                                            </thead>
                                            <tbody>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer" class="d-flex">
                        <div class="mr-auto">
                            <button type="button" class="btn btn-danger btn-sisp" data-dismiss="modal" id="btnFecharModificacoes">Fechar</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>


        <input type="text" class="d-none" id="ultimoCodigo">

        <!-- Control Sidebar -->
        <aside class="control-sidebar control-sidebar-dark">
            <!-- Control sidebar content goes here -->
        </aside><!-- /.control-sidebar -->
        <?php
        include_once('../../modais.php');
        ?>
    </main>

    <script src="../plugins/jquery/jquery.min.js?versao=3.2410.16.2"></script>
    <script src="../dist/js/jquery.maskMoney.min.js?versao=3.2410.16.2"></script>
    <script src="../plugins/jquery-ui/jquery-ui.min.js?versao=3.2410.16.2"></script>
    <script type="text/javascript" src="../dist/js/jquery.dataTables.js?versao=3.2410.16.2"></script>
    <script type="text/javascript" src="../dist/js/dataTables.bootstrap4.min.js?versao=3.2410.16.2"></script>
    <script src="../plugins/sweetalert2/sweetalert2.min.js?versao=3.2410.16.2"></script>
    <script src="../plugins/toastr/toastr.min.js?versao=3.2410.16.2"></script>
    <script>
        $.widget.bridge('uibutton', $.ui.button);
    </script>
    <script src="../plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.2410.16.2"></script>
    <script src="../dist/js/adminlte.min.js?versao=3.2410.16.2"></script>
    <script src="../dist/js/requisicoes.js?versao=3.2410.16.2"></script>
    <script src="../dist/js/loadingoverlay.min.js?versao=3.2410.16.2"></script>
    <script src="../dist/js/valida_cpf_cnpj.js?versao=3.2410.16.2"></script>
    <script src="../plugins/jquery-validation/jquery.validate.min.js?versao=3.2410.16.2"></script>
    <script src="../dist/js/dataTables.keyTable.js?versao=3.2410.16.2"></script>
    <script src="../dist/js/sisplan.js?versao=3.2410.16.2"></script>
    <script src="../utils/funcoes.js?versao=3.2410.16.2"></script>
    <script src="../utils/cookies.js?versao=3.2410.16.2"></script>
    <script src="../dist/js/driver.min.js?versao=3.2410.16.2"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-scrollTo/2.1.3/jquery.scrollTo.min.js"></script>
    <script>
        $(document).ready(async function() {
            if (getCookie('usuario') == "") {
                window.location.href = `${BASE_URI}/login`;
                return;
            }

            let usuario = getCookie('usuario');
            let empresa = getCookie('empresa');

            $('#btnVoltar').on('click', function(event) {
                event.preventDefault();
                window.history.back();
            });


            sArquivo = `${BASE_URI}/pages/cadconsumo/cadconsumo.js?versao=3.2410.16.2`;
            const nomeTela = ('<?php echo basename(__FILE__) ?>').replace('.php', '');

            const temAcesso = await temAcessoTela('CADCONSUMO');
            if (!temAcesso.resultado) {
                toastrAcesso(temAcesso, BASE_URI);
                return;
            }

            await insereJavaScriptPagina(sArquivo);

            habilitaCamposObrigatoriosTela(nomeTela);
        });
    </script>
</body>

</html>