$(document).ready(async function () {
    let verificaEdicao = false;

    $("#modal-combinacao").on('show.bs.modal', async function () {
        await consultaCombinacao();
        await buscaMaiorOrdem();
        $('.btnsConsulta').attr('disabled', true);
    });

    $("#modal-combinacao").on('shown.bs.modal', async function () {
        $('#tabelaCombinacoes').DataTable().columns.adjust().draw(false);
    });

    $("#modal-combinacao").on('hide.bs.modal', async function () {
        await consultaCombinacao();
        await voltaBotaoHabEdicao();
    });

    async function buscaMaiorOrdem() {
        const maxOrdem = $('#tabelaCombinacoes').DataTable().data().toArray().length;
        if (maxOrdem > 0) {
            $('#txtOrdemComb').val(maxOrdem + 1);
        } else {
            $('#txtOrdemComb').val(1);
        };
    };

    async function desbloqueiaCampos() {
        $('#txtCodMalha').attr('readonly', false);
        $('#txtMalha').attr('readonly', false);
        $('#txtAplicacao').attr('readonly', false);
        $('.input-dinamico').attr('readonly', false);
    };

    $('#btnImportaComb').on('click', function () {
        if (verificaEdicao == true) {
            $('#modalImporta').modal('show');
        } else {
            msgAlerta('Impossível importar sem estar no modo de Edição! Verifique.')
        };
    });

    $('#modalImporta').on('show.bs.modal', async function () {
        $('#txtProdutoImporta').autocompleta(1, `JSON={ "tabela":"produto", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
        $('#btn-produto-importa').pesquisa_serverside(['#txtProdutoImporta'], ['CODIGO'], ['DESCRICAO'], '{"tabela":"produto", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}', 'Pesquisa de Produto');
        $('#btn-limpa-produto').on('click', async function () {
            $('#txtProdutoImporta').val('');
        });
    });

    $('#btnImportaCombinacao').on('click', async function () {
        await buscaCombinacoesDeOutroProd();
    });


    $('#btnImprimirAlt').on('click', async function () {
        try {
            $.LoadingOverlay("show");
            try {
                const produto = $('#txtCodigoProdTittle').val();
                const url = `/sisplan/impressao/v1/imprimircombinacoesprod?CODIGO=${produto}`;
                const bImprimeAutomatico = await verificaImprimirAutomatico('relCombinacoesProd');
                const arquivo = await GeraRelatorio(`${url}`, "GET", 100000, false, 'relCombinacoesProd');
                if (arquivo != undefined) {
                    if (!bImprimeAutomatico) {
                        window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, "_blank");
                    }
                    await limparRelatorios();
                }
            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay("hide");
        }
    });

    async function buscaCombinacoesDeOutroProd() {
        const codigoProdutoImportado = pegaChave('#txtProdutoImporta');
        const codigoProdutoTela = $('#txtCodigoProdTittle').val();
        const pesquisaComb = {
            tabela: 'COMB_PROD',
            camposSelect: ['COD_MALHA AS CODIGO_MALHA',
                'CODIGO AS CODIGO_PROD',
                'COR_PROD AS COR_PRODUTO',
                'COR_COMB AS COR_COMBINACAO',
                'DESCRICAO AS APLICACAO',
                'MALHA',
                'ORDEM'],
            where: [`CODIGO = '${codigoProdutoImportado}'`]
        };
        const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaComb));
        let contador = 1;
        const buscaCombinacoes = [];
        const pesquisaCorUm = {
            tabela: 'PA_ITEN',
            camposSelect: ['DISTINCT COR'],
            where: [`CODIGO = '${codigoProdutoImportado}'`]
        };
        const pesquisaCorDois = {
            tabela: 'PA_ITEN',
            camposSelect: ['DISTINCT COR'],
            where: [`CODIGO = '${codigoProdutoTela}'`]
        }
        let contadorComb = 1
        const corprodimportado = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaCorUm));
        const corprodtela = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaCorDois));
        const corCodigo = []
        for (p in corprodimportado) {
            corCodigo.push(corprodimportado[p].COR)
        };
        while (1 == 1) {
            let teste3 = 0
            let ordemAttInput = $("#tabelaCombinacoes").DataTable().data().toArray().length + 1
            dataComb = jsonStr.filter(comb => comb.ORDEM == contadorComb);
            if (dataComb.length <= 0) {
                break;
            };
            let buscaCombinacoes = [];
            let ordem = dataComb[0].ORDEM;
            let codigomalha = dataComb[0].CODIGO_MALHA;
            let malhadesc = dataComb[0].MALHA;
            let aplicacao = dataComb[0].APLICACAO;
            buscaCombinacoes.push(`<div style="text-align:start;">
                <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes " value="${ordemAttInput}" id="btnOrdemOpcoes${ordemAttInput}" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">${ordemAttInput}</button> 
                <div class="dropdown-menu">
                   <button class="dropdown-item" id="btnExcluiRegistro">Excluir</button>
            </div>
            `);
            buscaCombinacoes.push(` <div class="input-group">
            <input type="text" class="input-default focus form-control input-dinamico"
                id="txtCodigo${ordemAttInput}" value="${codigomalha}">
            <div class="input-group-append">
                <button class="btn bg-danger btn-sm btnsConsulta" id="btnConsultaCodigoMalha${ordemAttInput}" name="btnConsultaCodigoMalha${ordemAttInput}"
                    data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
            </div>
            </div> `
            );
            buscaCombinacoes.push(` <input type="text" class="input-default focus form-control input-dinamico malhaDesc"
            id="txtMalhaDesc${ordemAttInput}" class="form-control"  value="${malhadesc}"> </input> `
            );
            buscaCombinacoes.push(` <div class="input-group">
            <input type="text" class="input-default focus form-control input-dinamico aplCodigo"
                    id="txtAplicacaoCod${ordemAttInput}" value="${aplicacao}">
            <div class="input-group-append">
                <button class="btn bg-danger btn-sm btnsConsulta" id="btnConsultaApl${ordemAttInput}" name="btnConsultaApl${ordemAttInput}"
                    data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
            </div>
            </div> `
            );
            for (i = 0; i < corprodtela.length; i++) {
                if (corCodigo.includes(corprodtela[i].COR)) {
                    let combinacao = dataComb[teste3].COR_COMBINACAO;

                    buscaCombinacoes.push(` <div class="input-group">
                    <input type="text" class="input-default focus form-control input-dinamico"
                        id="txtCombinacao${parseInt(i) + 4}-${ordemAttInput}" value="${combinacao}">
                    <div class="input-group-append">
                        <button class="btn bg-danger btn-sm btnsConsulta" id="btnAdicionaCorComb${parseInt(i) + 4}-${ordemAttInput}" name="btnAdicionaCorComb${parseInt(i) + 4}-${ordemAttInput}"
                            data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                    </div>
                    </div>  `
                    );
                    teste3++
                } else {
                    buscaCombinacoes.push(` <div class="input-group">
                    <input type="text" class="input-default focus form-control input-dinamico"
                        id="txtCombinacao${parseInt(i) + 4}-${ordemAttInput}" value="">
                    <div class="input-group-append">
                        <button class="btn bg-danger btn-sm btnsConsulta" id="btnAdicionaCorComb${parseInt(i) + 4}-${ordemAttInput}" name="btnAdicionaCorComb${parseInt(i) + 4}-${ordemAttInput}"
                            data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                    </div>
                    </div> `
                    )
                };
            }
            $('#tabelaCombinacoes').DataTable().row.add(buscaCombinacoes).draw(false);
            await criaPesquisaAoAdicionar(ordemAttInput);

            for (x = 0; x < corprodtela.length; x++) {
                $(`#btnAdicionaCorComb${parseInt(x) + 4}-${ordemAttInput}`).pesquisa_serverside([
                    `#txtCombinacao${parseInt(x) + 4}-${ordemAttInput}`, `#txtAplicacaoInvi`
                ], 
                ['CADCOR.COR', 'CADCOR.DESCRICAO'], ['CADCOR.DESCRICAO', 'CADCOR.COR'], 
                `{
                    "tabela":"MAT_ITEN", 
                    "camposSelect":[ "CADCOR.COR", "CADCOR.DESCRICAO"], 
                    "innerJoin": [
                        {"tabela": "CADCOR", "condicao": "CADCOR.COR = MAT_ITEN.COR" }
                    ], 
                    "where": ["MAT_ITEN.CODIGO = '${codigomalha}'"], 
                    "groupBy": ["CADCOR.COR", "CADCOR.DESCRICAO"]}`, 
                
                'Pesquisa de Cor', '', [true, true]);
            }

            contadorComb++;
            ordemAttInput++;
            $('#txtOrdemComb').val(ordemAttInput);
        };
        $('#modalImporta').modal('hide');
    };

    $('#modalImporta').on('hide.bs.modal', async function () {
        $('#txtProdutoImporta').val('');
    });

    async function escondeBotaoHabEdicao() {
        $('#btnHabEdicao').addClass('d-none');
        $('#btnGravarComb').removeClass('d-none');
        $('#btnCancelarAlt').removeClass('d-none');
        $('#btnAdicionaComb').removeClass('d-none');
        $('#btnExcluiItem').removeClass('d-none');
        $('#btnImportaComb').removeClass('d-none');
        $('#btnImprimirAlt').addClass('d-none');
        $('#btnAdicionaFoto').addClass('d-none');
        $('#btnSobeUmaLinha').removeClass('d-none');
        $('#btnDesceUmaLinha').removeClass('d-none');
        $('.btnsConsulta').attr('disabled', false);
        verificaEdicao = true;
    };

    async function voltaBotaoHabEdicao() {
        $('#btnHabEdicao').removeClass('d-none');
        $('#btnGravarComb').addClass('d-none');
        $('#btnCancelarAlt').addClass('d-none');
        $('#btnAdicionaComb').addClass('d-none');
        $('#btnExcluiItem').addClass('d-none');
        $('#btnImportaComb').addClass('d-none');
        $('#btnImprimirAlt').removeClass('d-none');
        $('#btnAdicionaFoto').removeClass('d-none');
        $('#btnSobeUmaLinha').addClass('d-none');
        $('#btnDesceUmaLinha').addClass('d-none');
        $('.btnsConsulta').attr('disabled', true);
        verificaEdicao = false;
    };

    $('#btnHabEdicao').on('click', async function () {

        const permissaoUsuarioLogado = await permissaoAcessos('PRODUTO');

        if (permissaoUsuarioLogado.ALTERA == 'S') {
            verificaEdicao = true;
            escondeBotaoHabEdicao();
            await desbloqueiaCampos();
            $("#tabelaCombinacoes tbody").on("click", "tr", async function () {
                $("#tabelaCombinacoes").dataTable().$("tr.selected").removeClass("selected");
                $(this).addClass("selected");
            });
        } else {
            msgAlerta('Sem permissão para alterar!');
            return;
        };
    });

    $('#btnAdicionaComb').on('click', async function () {
        await adicionaCombinacao();
        limpaCampos();
    });

    $('#btnGravarComb').on('click', async function () {
        const qtdeOrdens = $("#tabelaCombinacoes").DataTable().data().toArray().length
        if (qtdeOrdens == 0) {
            await excluiInfoTabela();
            verificaEdicao = false;
        } else {
            await gravaCombinacao();
            verificaEdicao = false;
        };
    });

    async function gravaCombinacao() {
        const dadoscombinacoes = $("#tabelaCombinacoes").DataTable().data().toArray();
        const arrCombinacoes = await Promise.all(dadoscombinacoes.map(async (item, i) => {
            return {
                ORDEM: $(`#btnOrdemOpcoes${i + 1}`).val(),
                CODMALHA: $(`#txtCodigo${i + 1}`).val(),
                MALHA: $(`#txtMalhaDesc${i + 1}`).val(),
                APLICACAO: $(`#txtAplicacaoCod${i + 1}`).val(),
                CODIGO: $('#txtCodigoProdTittle').val(),
                CorCombinacao: await retornaObjetoCorComb(i)
            }
        }));
        let response = await requisicao("POST", "/Sisplan/Cadastros/v1/combinacao?", `LISTACOMBINACOES=${encodeURIComponent(JSON.stringify({ COMBINACOES: arrCombinacoes }))}`, 20000);
        if (response.status === 200) {
            criaMensagemSucesso('Combinação gravada com sucesso!', () => { window.location.href = window.location.href; });
            return;
        };
    };

    $('#btnCancelarAlt').on('click', async function () {
        $('#txtCodMalha').attr('readonly', true);
        $('#txtMalha').attr('readonly', true);
        $('#txtAplicacao').attr('readonly', true);
        $('.input-dinamico').attr('readonly', true);
        await voltaBotaoHabEdicao();
        verificaEdicao = false;
        await consultaCombinacao();
        await buscaMaiorOrdem();
        $('#txtCodMalha').val('');
        $('#txtMalha').val('');
        $('#txtAplicacao').val('');
    });

    $('#btnFechar').on('click', async function () {
        $('#txtCodMalha').attr('readonly', true);
        $('#txtMalha').attr('readonly', true);
        $('#txtAplicacao').attr('readonly', true);
        $('.input-dinamico').attr('readonly', true);
        await voltaBotaoHabEdicao();
        verificaEdicao = false;
        await limpaCampos();
    });

    $('#btnAdicionaFoto').on('click', async function () {
        $('#modalFoto').modal('show');
    });


    $(async function () {
        var modalUpload = $("#mdModalUpload");
        var Arquivo = $('#txtArquivoFoto');
        var Botao = $("#btn-AddArquivo");
        Botao.click(function () {
            modalUpload.click();
        });
        modalUpload.change(async function () {
            var NomeArquivo = $(this).val().split('\\')[$(this).val().split('\\').length - 1];
            Arquivo.val(NomeArquivo);

            let file = document.querySelector('input[type=file]').files[0];
            let reader = new FileReader();
            let baseString;
            reader.onloadend = function () {
                baseString = reader.result;
                $("#imgFoto").attr('src', baseString);
            };
            await reader.readAsDataURL(file);
        });


    });

    $('#btn-LimpaArquivo').on('click', async function () {
        $('#txtArquivoFoto').val('');
        await buscaFotoCombinacao();
    });

    $('#modalFoto').on('show.bs.modal', async function () {
        await buscaFotoCombinacao();
    });

    $('#btnAdicionaAFoto').on('click', async function () {
        await SalvaFotoCombinacao();
    });


    async function buscaFotoCombinacao() {
        codigoComb = $('#txtCodigoProdTittle').val();
        let responsej = await requisicao('GET', '/sisplan/funcoes/v1/caminhofoto?', null);
        if (!responsej) {
            return;
        };
        jsonStr = await responsej.json();
        let pastaFoto = jsonStr.mensagem;
        let pastaCombinacao = pastaFoto + '\\COMBINACOES\\';
        let response = await requisicao('GET', '/sisplan/funcoes/v1/fotocombinacao?', `CODIGO=${codigoComb}&PDIRETORIOSALVAR=${pastaCombinacao}&NOMEARQUIVO=${codigoComb}COMB.jpg`, null);
        jsonRetornado = await response.json();
        if (jsonRetornado.codigo == 200) {
            $("#imgFoto").attr('src', `data:image/png;base64,${jsonRetornado.mensagem}`);
        } else {
            $("#imgFoto").attr('src', `${BASE_URI}/dist/img/prod-1.png`);
        };
    };

    $('#btnExcluiAFoto').on('click', async function () {
        codigoComb = $('#txtCodigoProdTittle').val();
        let responsej = await requisicao('GET', '/sisplan/funcoes/v1/caminhofoto?', null);
        if (!responsej) {
            return;
        };
        jsonStr = await responsej.json();
        let pastaFoto = jsonStr.mensagem;
        let pastaCombinacao = pastaFoto + '\\COMBINACOES\\';
        let response = await requisicao('GET', '/sisplan/funcoes/v1/fotocombinacao?', `CODIGO=${codigoComb}&PDIRETORIOSALVAR=${pastaCombinacao}&NOMEARQUIVO=${codigoComb}COMB.jpg`, null);
        jsonRetornado = await response.json();
        if (jsonRetornado.codigo == 200) {
            msgAlerta('Você realmente deseja excluir a foto da combinação?', async () => {
                await excluiFotoCombinacao();
            })
        } else {
            msgErro('Combinação não tem imagem para excluir!');
            return;
        };
    });


    async function excluiFotoCombinacao() {
        const codigoComb = $('#txtCodigoProdTittle').val();
        let responsel = await requisicao('GET', '/sisplan/funcoes/v1/caminhofoto?', null);
        if (!responsel) {
            return;
        };
        jsonStr = await responsel.json();
        const pastaFoto = jsonStr.mensagem;
        const pastaCombinacao = pastaFoto + '\\COMBINACOES\\'
        let response = await requisicao('DELETE', '/sisplan/funcoes/v1/fotocombinacao?', `PDIRETORIOSALVAR=${pastaCombinacao}&NOMEARQUIVO=${codigoComb}COMB.jpg`, null)
        if (!response) {
            msgAlerta('Não foi possível excluir a foto da combinação! Por favor, verifique.')
        };
        if (response.status != 200) {
            msgAlerta('Não foi possível excluir a imagem da combinação! Tente novamente.')
            return;
        };
        criaMensagemSucesso('Exclusão da foto da combinação efetuada com sucesso!')
        await buscaFotoCombinacao();
    };

    $('#btnImprimeAFoto').on('click', async function () {
        codigoComb = $('#txtCodigoProdTittle').val();
        let responsej = await requisicao('GET', '/sisplan/funcoes/v1/caminhofoto?', null);
        if (!responsej) {
            return;
        };
        jsonStr = await responsej.json();
        let pastaFoto = jsonStr.mensagem;
        let pastaCombinacao = pastaFoto + '\\COMBINACOES\\';
        let response = await requisicao('GET', '/sisplan/funcoes/v1/fotocombinacao?', `CODIGO=${codigoComb}&PDIRETORIOSALVAR=${pastaCombinacao}&NOMEARQUIVO=${codigoComb}COMB.jpg`, null);
        jsonRetornado = await response.json();
        if (jsonRetornado.codigo == 400) {
            msgErro('Não tem imagem para imprimir!');
            return;
        };
        const w = 900;
        const h = 650
        const src = $('#imgFoto')[0].src;
        const dualScreenLeft = window.screenLeft !== undefined ? window.screenLeft : window.screenX;
        const dualScreenTop = window.screenTop !== undefined ? window.screenTop : window.screenY;
        const width = window.innerWidth ? window.innerWidth : document.documentElement.clientWidth ? document.documentElement.clientWidth : screen.width;
        const height = window.innerHeight ? window.innerHeight : document.documentElement.clientHeight ? document.documentElement.clientHeight : screen.height;
        const systemZoom = width / window.screen.availWidth;
        const left = (width - w) / 2 / systemZoom + dualScreenLeft
        const top = (height - h) / 2 / systemZoom + dualScreenTop
        myWindow = window.open('', '', `
            scrollbars=yes,
            width=${w / systemZoom}, 
            height=${h / systemZoom}, 
            top=${top}, 
            left=${left}
            `);
        myWindow.document.write(`<image src='${src}' style='width: 700; height:450;' alt='foto'/>`);
        myWindow.focus();
        myWindow.print();
    });

    async function SalvaFotoCombinacao() {
        produto = $('#txtCodigoProdTittle').val();
        imagem = $('#txtArquivoFoto').val();
        if (imagem == '' || imagem == undefined) {
            msgAlerta('Campo da imagem em branco! Por favor, verifique.')
            return;
        };
        let file = document.querySelector('input[type=file]').files[0];
        let reader = new FileReader();
        let baseString;
        reader.onloadend = function () {
            baseString = reader.result
        };
        await reader.readAsDataURL(file);
        let response = await requisicao('GET', '/sisplan/funcoes/v1/caminhofoto?', null);
        if (!response) {
            return;
        };
        jsonStr = await response.json();
        let pastaFoto = jsonStr.mensagem;
        let pastaCombinacao = pastaFoto + '\\COMBINACOES\\'
        response = await requisicao('POST', '/sisplan/funcoes/v1/fotocombinacao?',
            `PDIRETORIOSALVAR=${pastaCombinacao
            }&NOMEARQUIVO=${produto}COMB.jpg`, `SBASE64=${encodeURIComponent(baseString)}&FILETYPE=${file.type}`);
        if (!response) {
            msgAlerta('Não foi possível gravar imagem da combinação! Tente novamente.')
            return;
        };
        if (response.status != 200) {
            msgAlerta('Não foi possível gravar imagem da combinação! Tente novamente.')
            return;
        };
        criaMensagemSucesso('Imagem da combinação anexada com sucesso.');
        $('#txtArquivoFoto').val('');
        await buscaFotoCombinacao();
    };

    $('#modalFoto').on('hide.bs.modal', async function () {
        $('#txtArquivoFoto').val('');
    });


    $('#tabelaCombinacoes').on('click', '#btnExcluiRegistro', async function () {
        if (verificaEdicao == true) {
            msgAlerta('Você realmente deseja excluir esse registro?', async () => {
                const data = $("#tabelaCombinacoes").DataTable().row($(this).parents("tr"));
                let ordemExcluida = parseInt(data[0]) + 1;
                await atualizaGridAoExcluirRegistro(data, ordemExcluida);
            });
        } else {
            msgErro('Impossível excluir sem estar no modo de Edição! Verifique.')
        };
    });


    $('#btnExcluiItem').on('click', async function () {
        if (verificaEdicao == true) {
            msgAlerta('Você realmente deseja excluir todos as combinações?', async () => {
                const registroData = $("#tabelaCombinacoes").DataTable().rows()
                registroData.remove().draw(false);
            });
        } else {
            msgErro('Impossível excluir sem estar no modo de Edição! Verifique.')
        };
    });

    $('#btnSobeUmaLinha').on('click', async function () {
        await sobeUmaLinha();
    });

    $('#btnDesceUmaLinha').on('click', async function () {
        await desceUmaLinha();

    });

    async function sobeUmaLinha() {

        const indiceSelecionado = $('tr.selected')[0].rowIndex - 1;
        if (indiceSelecionado == 0) {
            msgAlerta('Não existem mais linhas acima!');
            return;
        };
        const linhaSelecionada = $('tr.selected');
        const ordemLinhaSelecionada = linhaSelecionada[0].cells[0].children[0].children[0].value;
        const ordemLinhaAcimaSelecionada = parseInt(ordemLinhaSelecionada) - 1;
        const qtdeCoresDoProduto = await retornaCoresProduto();

        const cdMalhaSelecionado = $(`#txtCodigo${ordemLinhaSelecionada}`).val();
        const cdMalhaAcima = $(`#txtCodigo${ordemLinhaAcimaSelecionada}`).val();
        $(`#txtCodigo${ordemLinhaSelecionada}`).val(cdMalhaAcima);
        $(`#txtCodigo${ordemLinhaAcimaSelecionada}`).val(cdMalhaSelecionado);
        const malhaSelecionado = $(`#txtMalhaDesc${ordemLinhaSelecionada}`).val();
        const malhaAcima = $(`#txtMalhaDesc${ordemLinhaAcimaSelecionada}`).val();
        $(`#txtMalhaDesc${ordemLinhaSelecionada}`).val(malhaAcima);
        $(`#txtMalhaDesc${ordemLinhaAcimaSelecionada}`).val(malhaSelecionado);
        const codAplicacaoSelecionado = $(`#txtAplicacaoCod${ordemLinhaSelecionada}`).val();
        const codAplicacaoAcima = $(`#txtAplicacaoCod${ordemLinhaAcimaSelecionada}`).val();
        $(`#txtAplicacaoCod${ordemLinhaSelecionada}`).val(codAplicacaoAcima);
        $(`#txtAplicacaoCod${ordemLinhaAcimaSelecionada}`).val(codAplicacaoSelecionado);

        for (i = 0; i < qtdeCoresDoProduto.length; i++) {

            let combinacaoSelecionado = $(`#txtCombinacao${parseInt(i) + 4}-${ordemLinhaSelecionada}`).val();
            let combinacaoAcima = $(`#txtCombinacao${parseInt(i + 4)}-${ordemLinhaAcimaSelecionada}`).val();
            $(`#txtCombinacao${parseInt(i) + 4}-${ordemLinhaSelecionada}`).val(combinacaoAcima);
            $(`#txtCombinacao${parseInt(i + 4)}-${ordemLinhaAcimaSelecionada}`).val(combinacaoSelecionado);
        };
        $('tr.selected').removeClass('selected');
        $($('#tabelaCombinacoes tr')[indiceSelecionado]).trigger('click');
    };

    async function desceUmaLinha() {
        const linhaSelecionada = $('tr.selected');
        const ordemLinhaSelecionada = linhaSelecionada[0].cells[0].children[0].children[0].value;
        let qtdeRows = $('#tabelaCombinacoes').DataTable().data().toArray().length;

        if (qtdeRows == ordemLinhaSelecionada) {
            msgAlerta('Não existe mais linhas abaixo!');
            return;
        };

        const indiceSelecionado = $('tr.selected')[0].rowIndex + 1;
        const ordemLinhaAbaixoSelecionado = parseInt(ordemLinhaSelecionada) + 1;
        const qtdeCoresDoProduto = await retornaCoresProduto();
        const cdMalhaSelecionado = $(`#txtCodigo${ordemLinhaSelecionada}`).val();
        const cdMalhaAbaixo = $(`#txtCodigo${ordemLinhaAbaixoSelecionado}`).val();
        $(`#txtCodigo${ordemLinhaSelecionada}`).val(cdMalhaAbaixo);
        $(`#txtCodigo${ordemLinhaAbaixoSelecionado}`).val(cdMalhaSelecionado);
        const malhaSelecionado = $(`#txtMalhaDesc${ordemLinhaSelecionada}`).val();
        const malhaAbaixo = $(`#txtMalhaDesc${ordemLinhaAbaixoSelecionado}`).val();
        $(`#txtMalhaDesc${ordemLinhaSelecionada}`).val(malhaAbaixo);
        $(`#txtMalhaDesc${ordemLinhaAbaixoSelecionado}`).val(malhaSelecionado);
        const codAplicacaoSelecionado = $(`#txtAplicacaoCod${ordemLinhaSelecionada}`).val();
        const codAplicacaoAbaixo = $(`#txtAplicacaoCod${ordemLinhaAbaixoSelecionado}`).val();
        $(`#txtAplicacaoCod${ordemLinhaSelecionada}`).val(codAplicacaoAbaixo);
        $(`#txtAplicacaoCod${ordemLinhaAbaixoSelecionado}`).val(codAplicacaoSelecionado);

        for (i = 0; i < qtdeCoresDoProduto.length; i++) {

            let combinacaoSelecionado = $(`#txtCombinacao${parseInt(i) + 4}-${ordemLinhaSelecionada}`).val();
            let combinacaoAbaixo = $(`#txtCombinacao${parseInt(i + 4)}-${ordemLinhaAbaixoSelecionado}`).val();
            $(`#txtCombinacao${parseInt(i) + 4}-${ordemLinhaSelecionada}`).val(combinacaoAbaixo);
            $(`#txtCombinacao${parseInt(i + 4)}-${ordemLinhaAbaixoSelecionado}`).val(combinacaoSelecionado);
        };
        $('tr.selected').removeClass('selected');
        $($('#tabelaCombinacoes tr')[indiceSelecionado]).trigger('click');
    };

    async function atualizaGridAoExcluirRegistro(sData, sOrdemExcluida) {
        const ordemExc = sOrdemExcluida;
        const arrayDataTable = $("#tabelaCombinacoes").DataTable().data().toArray();
        const arrDataTable = await Promise.all(arrayDataTable.map(async (item, i) => {
            return {
                ordem: $(`#btnOrdemOpcoes${i + 1}`).val(),
                codmalha: $(`#txtCodigo${i + 1}`).val(),
                malha: $(`#txtMalhaDesc${i + 1}`).val(),
                aplicacao: $(`#txtAplicacaoCod${i + 1}`).val(),
                codigo: $('#txtCodigoProdTittle').val(),
                CorCombinacao: await retornaObjetoCorComb(i)
            }
        }));
        await excluiRegistroNaEdicao(sData);
        const qtdeOrdens = arrDataTable.length + 1;
        const ordensAtt = ordemExc + 1;
        const qtdeCoresProd = await retornaCoresProduto();
        const qtdeCoresProdFor = qtdeCoresProd.length
        for (l = ordensAtt; l < qtdeOrdens; l++) {
            let novoId = parseInt(l) - 1;
            $(`#btnConsultaCodigoMalha${l}`).off();
            $(`#btnConsultaApl${l}`).off();
            $(`#btnOrdemOpcoes${l}`).attr('id', `btnOrdemOpcoes${novoId}`);
            $(`#btnOrdemOpcoes${novoId}`).val(novoId);
            $(`#btnOrdemOpcoes${novoId}`).text(novoId)
            $(`#txtCodigo${l}`).attr('id', `txtCodigo${novoId}`);
            $(`#btnConsultaCodigoMalha${l}`).attr('id', `btnConsultaCodigoMalha${novoId}`)
            $(`#txtMalhaDesc${l}`).attr('id', `txtMalhaDesc${novoId}`);
            $(`#txtAplicacaoCod${l}`).attr('id', `txtAplicacaoCod${novoId}`);
            $(`#btnConsultaApl${l}`).attr('id', `btnConsultaApl${novoId}`);
            $(`#btnConsultaApl${novoId}`).pesquisa_serverside([`#txtAplicacaoCod${novoId}`, `#txtAplicacaoInvi`], ['DESCRICAO', 'DESCRICAO'], ['CODIGO', 'DESCRICAO'], '{"tabela":"pcpapl", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}', 'Pesquisa de Aplicação', '', [true, true]);
            $(`#btnConsultaCodigoMalha${novoId}`).pesquisa_serverside([`#txtCodigo${novoId}`, `#txtMalhaDesc${novoId}`], ['CODIGO', 'DESCRICAO'], ['DESCRICAO', 'DESCRICAO'], '{"tabela":"material", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}', 'Pesquisa de Material', '', [true, true]);

            for (t = 0; t < qtdeCoresProdFor; t++) {
                $(`#txtCombinacao${parseInt(t) + 4}-${l}`).attr('id', `txtCombinacao${parseInt(t) + 4}-${novoId}`);
                $(`#btnAdicionaCorComb${parseInt(t) + 4}-${l}`).attr('id', `btnAdicionaCorComb${parseInt(t) + 4}-${novoId}`);
                $(`#btnAdicionaCorComb${parseInt(t) + 4}-${novoId}`).pesquisa_serverside([`#txtCombinacao${parseInt(t) + 4}-${novoId}`, `#txtAplicacaoInvi`], ['DESCRICAO', 'DESCRICAO'], ['COR', 'DESCRICAO'], '{"tabela":"cadcor", "camposSelect":[ "COR", "DESCRICAO"], "where": null}', 'Pesquisa de Cores', '', [true, true]);
            };
        };
        $('#txtOrdemComb').val($('#txtOrdemComb').val() - 1);
    };

    async function excluiRegistroNaEdicao(sDataRow) {
        sDataRow.remove().draw(false);
    };

    async function excluiInfoTabela() {
        const codigoProd = $('#txtCodigoProdTittle').val();
        let response = await requisicao("DELETE", "/Sisplan/Cadastros/v1/combinacao?", `CODIGO=${encodeURIComponent(codigoProd)}`, null);
        if (response.status === 200) {
            criaMensagemSucesso('Combinações excluídas com sucesso!', () => { window.location.href = window.location.href; });
            return;
        }
    };

    async function consultaCombinacao() {
        if ($.fn.DataTable.isDataTable('#tabelaCombinacoes')) {
            $('#tabelaCombinacoes').DataTable().destroy();
            $('#tabelaCombinacoes').empty();
        };
        const pesquisaParam = {
            tabela: 'COMB_PROD',
            camposSelect: ['COD_MALHA AS CODIGO_MALHA',
                'CODIGO AS CODIGO_PROD',
                'COR_COMB AS COR_COMBINACAO',
                'DESCRICAO AS APLICACAO',
                'MALHA',
                'ORDEM'],
            where: [`CODIGO = '${$('#txtCodigoProdTittle').val()}'`]
        };
        const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));
        const dataSetCols = [];
        const coresProduto = await retornaCoresProduto();
        dataSetCols.push({
            'title': 'ORDEM'
        });
        dataSetCols.push({
            'title': 'CD MALHA'
        });
        dataSetCols.push({
            'title': 'MALHA'
        });
        dataSetCols.push({
            'title': 'APLICAÇÃO'
        });
        for (let j in coresProduto) {
            dataSetCols.push({
                'title': coresProduto[j]
            });
        };
        let contador = 1;
        const dadosDataTableTeste = [];
        let teste1 = 1;
        while (1 == 1) {
            data = jsonStr.filter(combinacao => combinacao.ORDEM == contador);
            if (data.length <= 0) {
                break;
            };

            let dadosDataTable = [];
            const ordem = data[0].ORDEM;
            const codigomalha = data[0].CODIGO_MALHA;
            const malhadesc = data[0].MALHA;
            const aplicacao = data[0].APLICACAO;
            dadosDataTable.push(`<div style="text-align:start;">
                <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" value="${ordem}" id="btnOrdemOpcoes${contador}" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">${ordem}</button> 
                <div class="dropdown-menu"> 
                   <button class="dropdown-item" id="btnExcluiRegistro">Excluir</button></div>
            `);
            dadosDataTable.push(` <div class="input-group">
            <input type="text" readonly class="input-default focus form-control input-dinamico codigoMalha"
                id="txtCodigo${contador}" value="${codigomalha}">
            <div class="input-group-append">
                <button class="btn bg-danger btn-sm btnsConsulta" disabled id="btnConsultaCodigoMalha${contador}" name="btnConsultaCodigoMalha${contador}"
                    data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
            </div>
            </div>`
            );
            dadosDataTable.push(` <input type="text" readonly class="input-default focus form-control input-dinamico malhaDesc"
            id="txtMalhaDesc${contador}" value="${malhadesc}"></input> `
            );
            dadosDataTable.push(` <div class="input-group">
            <input type="text" readonly class="input-default focus form-control input-dinamico aplCodigo"
                    id="txtAplicacaoCod${contador}" value="${aplicacao}">
            <div class="input-group-append">
                <button class="btn bg-danger btn-sm btnsConsulta" disabled id="btnConsultaApl${contador}" name="btnConsultaApl${contador}"
                    data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
            </div>
            </div> `
            );
            const CorCombinacao = await retornaCoresProduto();
            for (let y = 0; y < CorCombinacao.length; y++) {
                let combinacao = data[y].COR_COMBINACAO;

                dadosDataTable.push(` <div class="input-group">
                <input type="text" readonly class="input-default focus form-control input-dinamico"
                    id="txtCombinacao${parseInt(y) + 4}-${contador}" value="${combinacao}">
                <div class="input-group-append">
                    <button class="btn bg-danger btn-sm btnsConsulta" disabled id="btnAdicionaCorComb${parseInt(y) + 4}-${contador}" name="btnAdicionaCorComb${parseInt(y) + 4}-${contador}"
                        data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                </div>
                </div> `
                );
            };
            contador++;
            teste1++;
            dadosDataTableTeste.push(dadosDataTable);

        };

        $("#tabelaCombinacoes").DataTable({
            bPaginate: false,
            destroy: true,
            search: false,
            filter: false,
            lengthChange: false,
            scrollX: true,
            serverside: false,
            order: false,
            language: {
                sEmptyTable: "Nenhum registro encontrado",
                sInfo: "_TOTAL_ registros",
                sInfoEmpty: " 0 registros",
                sInfoFiltered: "(Filtrados de _MAX_ registros)",
                sInfoPostFix: "",
                sInfoThousands: ".",
                sLengthMenu: "_MENU_ resultados",
                sLoadingRecords: "Carregando...",
                sProcessing: "Processando...",
                sZeroRecords: "Nenhum registro encontrado",
                sSearch: "Pesquisar",
                oPaginate: {
                    sNext: "Próximo",
                    sPrevious: "Anterior",
                    sFirst: "Primeiro",
                    sLast: "Último",
                },
                oAria: {
                    sSortAscending: ": Ordenar colunas de forma ascendente",
                    sSortDescending: ": Ordenar colunas de forma descendente",
                },
            },
            autoWidth: true,
            data: dadosDataTableTeste,
            columns: dataSetCols
        });

        const CorCombinacao = await retornaCoresProduto();

        for (let i = 0; i < contador; i++) {
            $(`#btnConsultaApl${i}`).pesquisa_serverside([`#txtAplicacaoCod${i}`, `#txtAplicacaoInvi`], ['DESCRICAO', 'DESCRICAO'], ['CODIGO', 'DESCRICAO'], '{"tabela":"pcpapl", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}', 'Pesquisa de Aplicação', '', [true, true]);
            $(`#btnConsultaCodigoMalha${i}`).pesquisa_serverside([`#txtCodigo${i}`, `#txtMalhaDesc${i}`], ['CODIGO', 'DESCRICAO'], ['DESCRICAO', 'DESCRICAO'], '{"tabela":"material", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}', 'Pesquisa de Material', '', [true, true]);

            for (let t = 0; t < CorCombinacao.length; t++) {

                $(`#btnAdicionaCorComb${parseInt(t) + 4}-${i}`).pesquisa_serverside([`#txtCombinacao${parseInt(t) + 4}-${i}`, `#txtAplicacaoInvi`], ['CADCOR.DESCRICAO', 'CADCOR.DESCRICAO'], ['CADCOR.DESCRICAO', 'CADCOR.COR'], 
                `{
                    "tabela":"MAT_ITEN", 
                    "camposSelect":[ "CADCOR.COR", "CADCOR.DESCRICAO"], 
                    "innerJoin": [
                        {"tabela": "CADCOR", "condicao": "CADCOR.COR = MAT_ITEN.COR" }
                    ], 
                    "where": null, 
                    "groupBy": ["CADCOR.COR", "CADCOR.DESCRICAO"]}`, 
                
                'Pesquisa de Cor', '', [true, true]);
            };
        };


        $(`#btnConsultaCodMalha`).pesquisa_serverside([`#txtCodMalha`, `#txtMalha`], ['CODIGO', 'DESCRICAO'], ['DESCRICAO', 'DESCRICAO'], '{"tabela":"material", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}', 'Pesquisa de Material', '', [true, true]);
        $(`#btnConsultaApl`).pesquisa_serverside([`#txtAplicacao`, `#txtAplicacaoInvi`], ['DESCRICAO', 'DESCRICAO'], ['CODIGO', 'DESCRICAO'], '{"tabela":"pcpapl", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}', 'Pesquisa de Aplicação', '', [true, true]);

    };

    async function retornaCoresProduto() {
        const pesquisaParam = {
            tabela: 'PA_ITEN',
            camposSelect: ['DISTINCT PA_ITEN.COR', 'CADCOR.DESCRICAO'],
            where: [`PA_ITEN.CODIGO = '${$('#txtCodigoProdTittle').val()}'`],
            innerJoin: [{ tabela: "CADCOR", condicao: "PA_ITEN.COR = CADCOR.COR" }]
        };
        const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));
        if (jsonStr.length == 0) {
            return;
        };
        const jsonFormatado = [];
        for (let i = 0; i < jsonStr.length; i++) {
            jsonFormatado.push(jsonStr[i].COR + '|' + jsonStr[i].DESCRICAO)
        };
        return jsonFormatado;
    };

    async function adicionaCombinacao() {
        const listaDeInputs = [];
        let ordem = parseInt($('#txtOrdemComb').val());
        const codmalha = $('#txtCodMalha').val();
        const malha = $('#txtMalha').val();
        const aplicacao = $('#txtAplicacao').val();
        const CorCombinacao = await retornaCoresProduto();
        const qtdeOrdensRow = $('#tabelaCombinacoes').DataTable().data().toArray().length + 1;

        if (codmalha == '' || malha == '' || aplicacao == '') {
            msgErro('Existe algum campo vazio! Verifique.')
            return;
        };
        listaDeInputs.push(
            `<div style="text-align:start;">
            <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" id="btnOrdemOpcoes${ordem}" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" value="${ordem}">
         ${ordem}
            </button> 
            <div class="dropdown-menu"> 
               <button class="dropdown-item" id="btnExcluiRegistro">Excluir</button>
        </div>
        `
        );
        listaDeInputs.push(` <div class="input-group">
            <input type="text" class="input-default focus form-control input-dinamico codigoMalha"
                id="txtCodigo${ordem}" value="${codmalha}">
            <div class="input-group-append">
                <button class="btn bg-danger btn-sm btnsConsulta" id="btnConsultaCodigoMalha${ordem}" name="btnConsultaCodigoMalha${ordem}"
                    data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
            </div>
            </div> `
        );
        listaDeInputs.push(
            `<input type="text" class="input-default focus form-control input-dinamico malhaDesc"
            id="txtMalhaDesc${ordem}"   value="${malha}"> 
            </input>`
        );
        listaDeInputs.push(` <div class="input-group">
            <input type="text" class="input-default focus form-control input-dinamico aplCodigo"
                    id="txtAplicacaoCod${ordem}" value="${aplicacao}">
            <div class="input-group-append">
                <button class="btn bg-danger btn-sm btnsConsulta" id="btnConsultaApl${ordem}" name="btnConsultaApl${ordem}"
                    data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
            </div>
            </div> `
        );
        for (let k in CorCombinacao) {
            listaDeInputs.push(
                `<div class="input-group">
                <input type="text" class="input-default focus form-control input-dinamico"
                    id="txtCombinacao${parseInt(k) + 4}-${ordem}">
                <div class="input-group-append">
                    <button class="btn bg-danger btn-sm btnsConsulta" id="btnAdicionaCorComb${parseInt(k) + 4}-${ordem}" name="btnAdicionaCorComb${parseInt(k) + 4}-${ordem}"
                        data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                </div>
                </div>`);

        };
        $('#tabelaCombinacoes').DataTable().row.add(listaDeInputs).draw(false);
        await criaPesquisaAoAdicionar(ordem);
        for (let p in CorCombinacao) {
            $(`#btnAdicionaCorComb${parseInt(p) + 4}-${ordem}`).pesquisa_serverside([`#txtCombinacao${parseInt(p) + 4}-${ordem}`, `#txtAplicacaoInvi`], ['CADCOR.DESCRICAO', 'CADCOR.DESCRICAO'], ['CADCOR.DESCRICAO', 'CADCOR.COR'], 
            `{
                "tabela":"MAT_ITEN", 
                "camposSelect":[ "CADCOR.COR", "CADCOR.DESCRICAO"], 
                "innerJoin": [
                    {"tabela": "CADCOR", "condicao": "CADCOR.COR = MAT_ITEN.COR" }
                ], 
                "where": null, 
                "groupBy": ["CADCOR.COR", "CADCOR.DESCRICAO"]}`, 
            
            'Pesquisa de Cor', '', [true, true]);
        }
        ordem++;
        $('#txtOrdemComb').val(ordem);


    };

    async function criaPesquisaAoAdicionar(ordem) {

        $(`#btnConsultaApl${ordem}`).pesquisa_serverside([`#txtAplicacaoCod${ordem}`, `#txtAplicacaoInvi`], ['DESCRICAO', 'DESCRICAO'], ['CODIGO', 'DESCRICAO'], '{"tabela":"pcpapl", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}', 'Pesquisa de Aplicação', '', [true, true]);
        $(`#btnConsultaCodigoMalha${ordem}`).pesquisa_serverside([`#txtCodigo${ordem}`, `#txtMalhaDesc${ordem}`], ['CODIGO', 'DESCRICAO'], ['DESCRICAO', 'DESCRICAO'], '{"tabela":"material", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}', 'Pesquisa de Material', '', [true, true]);
    };

    async function limpaCampos() {
        $('#txtCodMalha').val('');
        $('#txtMalha').val('');
        $('#txtAplicacao').val('');
    };

    async function retornaObjetoCorComb(index) {

        const dados = $("#tabelaCombinacoes").DataTable().row(index).data();
        const arrayCorCombinacoes = [];
        for (let i = 4; i < dados.length; i++) {
            const tituloColuna = $('#tabelaCombinacoes').DataTable().settings().init().columns[i].title;
            const corProduto = tituloColuna.substring(0, tituloColuna.indexOf('|'));
            arrayCorCombinacoes.push({
                CorComb: $(`#txtCombinacao${i}-${index + 1}`).val(),
                CorProd: corProduto,
            })
        }
        return arrayCorCombinacoes;
    };
});