$(document).ready(async function () {
  const permissaoUsuarioLogado = await permissaoAcessos("TIPOPESSOA");

  $("#btnFiltros").on("click", async function () {
    $("#modal-filtros").modal("show");
  });

  $("#btnNovaClaTrib").on("click", async function () {
    if (permissaoUsuarioLogado.INCLUI == 'S') {
      window.location.href = "tipopessoa/create";
    } else {
      msgAlertaSemConfirmacao("Sem permissão para incluir!");
    }
  });

  $("#txtTpPessoaconsulta").autocompleta(
    1,
    `JSON={ "tabela":"TPDOCPESSOA", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`
  );
  // pesquisa
  $("#btn-TpPessoa").pesquisa(
    "#txtTpPessoaconsulta",
    "CODIGO",
    "DESCRICAO",
    `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TPDOCPESSOA", "camposSelect":[ "codigo", "descricao"]}`,
    "Pesquisa Tipo Pessoa",
    "TPDOCPESSOA"
  );
  // limpaCampo
  $("#btn-limpa-TpPessoa").on("click", function () {
    $("#txtTpPessoaconsulta").val("");
  });

  function retornaBotaoOpcoes(data) {
    var retorno = '<div style="text-align:start;"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + data + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu"> ' +
      '    <button class="dropdown-item" type="button" title="Editar" id="btn-editar">Editar</button>    ' +
      '    <button class="dropdown-item" type="button" title="Excluir" id="btn-excluir">Excluir</button>  ' +
      '</div>';
    return retorno;
  };

  consultaTpPessoa();

  $("#btnConsultar").on("click", async function () {
    await consultaTpPessoa(true);
    $("#modal-filtros").modal("hide");
  });

  $("#btnLimparFiltros").on("click", async function () {
    $("#txtTpPessoaconsulta").val("");
  });

  async function consultaTpPessoa(bBotao = false) {
    let response;
    try {
      $.LoadingOverlay("show");

      let codigo =
        pegaChave("#txtTpPessoaconsulta") != ""
          ? ` AND CODIGO = '${pegaChave("#txtTpPessoaconsulta")}'`
          : "";
      if (bBotao) {
        response = await requisicao(
          "GET",
          "/Sisplan/Funcoes/V1/pesquisa?",
          `JSON={ "tabela":"TPDOCPESSOA", "camposSelect":[ "codigo", "descricao", "mascara"], "where": ["1=1 ${codigo}"]}`,
          null
        );
      } else {
        response = await requisicao(
          "GET",
          "/Sisplan/Funcoes/V1/pesquisa?",
          'JSON={ "tabela":"TPDOCPESSOA", "camposSelect":[ "codigo", "descricao", "mascara"], "where": null}',
          null
        );
      }

      if (!response) {
        $.LoadingOverlay("hide");
        return;
      }

      let jsonStr = await response.json();
      if (response.status != 200) {
        $.LoadingOverlay("hide");
        msgErro(jsonStr.RESULT[0].mensagem);
        return;
      }

      let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
      if (colunasInvisiveis == null || colunasInvisiveis.acessoCadTipoPessoa == undefined) {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunasInvisiveis, acessoCadTipoPessoa: ['EMPRESA'] }));
        colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
      }

      $("#tabelaTpPessoa").DataTable({
        destroy: true,
        lengthChange: true,
        paging: true,
        searching: true,
        scrollX: true,
        scrollY: '350px',
        autoWidth: true,
        data: jsonStr.RESULT[0],
        columns: [
          {
            data: "CODIGO",
            title: "Código"
          },
          {
            data: "DESCRICAO",
            title: "Descrição"
          },
          {
            data: "MASCARA",
            title: "Máscara"
          },
        ],
        columnDefs: [
          {
            targets: [0], render: function (data, type, row) {
              return retornaBotaoOpcoes(data);
            }
          },
        ],
      });

      $('#tabelaTpPessoa_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
      $('#tabelaTpPessoa_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');

      $('#buttonColVis').prop('title', 'Configurar colunas visíveis')
      $('#buttonExcel').prop('title', 'Exportar')

      $('#buttonColVis').on('click', async function () {
        $.LoadingOverlay('show');
        $('#modal-ColunasVisiveis').modal('show');
        $.LoadingOverlay('hide');
      });

      $('#buttonExcel').on('click', async function () {
        const dados = $("#tabelaTpPessoa").DataTable().data().toArray();
        await exportaCSV("", "", undefined, null, 'Relatório da aba de acesso cadastro de Tipo de Pessoa', '', '', 999, false, false, dados);
      });

      $('#tabelaTpPessoa').DataTable().columns().every(function () {
        if ((colunasInvisiveis.acessoCadTipoPessoa).indexOf(this.dataSrc()) != -1) {
          this.visible(false);
        }
      });

      $.LoadingOverlay("hide");
    } catch (error) {
      console.error(error);
      $.LoadingOverlay("hide");
    }
  }

  $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
    const cols = [];
    colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

    $('#tabelaTpPessoa').DataTable().columns().every(function () {
      cols.push({
        'title': $(this.header()).text(),
        'data': this.dataSrc()
      });
    });

    adicionaColunas(cols, colunasInvisiveis.acessoCadTipoPessoa ?? ['EMPRESA']);
  });

  $('#btnConfirmarColunas').on('click', async function () {
    try {
      $.LoadingOverlay('show');

      const novasColunas = retornaNovasColunasInvisiveis();
      removeColunasFixas(novasColunas, ["CODIGO"]);
      localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunasInvisiveis, acessoCadTipoPessoa: novasColunas }));

      $('#tabelaTpPessoa').DataTable().columns().visible(true);

      $('#tabelaTpPessoa').DataTable().columns().every(function () {
        if ((novasColunas).indexOf(this.dataSrc()) != -1) {
          this.visible(false);
        }
      });

    } finally {
      $.LoadingOverlay('hide');
      $('#modal-ColunasVisiveis').modal('hide');
    }
  });

  $("#tabelaTpPessoa").on("click", "#btn-editar", async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $("#tabelaTpPessoa").DataTable().row($(this).parents("tr")).data();
      let registroLiberado = await verificarRegistro("TIPOPESSOA", data.CODIGO);
      if (registroLiberado) {
        window.location.href = `tipopessoa/${data.CODIGO}`;
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }

  });

  $("#tabelaTpPessoa").on("dblclick", "tr", async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $("#tabelaTpPessoa").DataTable().row($(this)).data();
      let registroLiberado = await verificarRegistro("TIPOPESSOA", data.CODIGO);
      if (registroLiberado) {
        window.location.href = `tipopessoa/${data.CODIGO}`;
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });


  $('#tabelaTpPessoa').on('click', '#btn-excluir', async function () {
    if (permissaoUsuarioLogado.EXCLUI == 'S') {
      msgAlerta('Você realmente deseja excluir esse registro?', async () => {
        const data = $("#tabelaTpPessoa").DataTable().row($(this).parents("tr"));
        await excluiRegistro(data);
      });
    } else {
      msgAlertaSemConfirmacao("Sem permissão para excluir!");
    }


  });

  async function excluiRegistro(data) {
    try {
      $.LoadingOverlay("show");
      try {
        let valorLinha = data.data();
        let response = await requisicao("DELETE", "/Sisplan/Cadastros/v1/tipopessoa?", `CODIGO=${encodeURIComponent(valorLinha.CODIGO)}`, null);
        if (!response) {
          return;
        }
        if (response.status != 200) {
          let jsonStr = await response.json();
          msgErro(jsonStr.mensagem);
          return;
        }

        toastr.success("Exclusão efetuada com sucesso!", "Confirmação", {
          toastClass: "success",
          iconClasses: {
            error: "alert-error",
            info: "alert-info",
            success: "alert-success",
            warning: "alert-warning",
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000,
          onHidden() {
            data.remove().draw(false);
          },
        }).css({
          "margin-top": "20%",
          width: "500px",
          "max-width": "500px",
        });

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  }
});

$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
    });
    driver.defineSteps([
      {
        element: "#btnFiltros",
        popover: {
          title: "Botão Filtros",
          description: "Clique aqui para filtrar a busca.",
          position: "right",
        },
      },
      {
        element: "#btnNovaClaTrib",
        popover: {
          title: "Botão Incluir",
          description:
            "Clique aqui para iniciar o cadastro de um tipo de pessoa.",
          position: "right",
        },
      },
      {
        element: "#tabelaTpPessoa",
        popover: {
          title: "Tabela de Tipos de Pessoas",
          description: "Aqui estão os dados dos tipos de pessoas cadastrados.",
          position: "top",
        },
      },
    ]);
    driver.start();
  });
});
