$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false,
      animate: true
    });

    driver.defineSteps([{
      element: '#conteudo',
      popover: {
        title: 'Dados Gerais',
        description: 'Aqui estão os campos disponíveis para o cadastro.',
        position: 'top'
      }
    },
    {
      element: '#txtCodigo',
      popover: {
        title: 'Código do Tipo Fiscal',
        description: 'Esse campo é o código identificador do Tipo Fiscal, caso não preencha esse campo, ele é preenchido automaticamente ao gravar.',
        position: 'top'
      }
    },
    {
      element: '#txtDescricao',
      popover: {
        title: 'Campos Obrigatórios',
        description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome, ele serve para descrever o Tipo Fiscal cadastrado ou o novo cadastro.',
        position: 'top'
      }
    },
    {
      element: "#btnVoltar",
      popover: {
        title: "Botão Voltar",
        description:
          "Ao clicar nesse botão você retorna para a tela de consulta.",
        position: "left",
      },
    },
    {
      element: '#btnGravar',
      popover: {
        title: 'Botão Gravar',
        description: 'Clique aqui para gravar o Tipo Fiscal.',
        position: 'left'
      }
    }
    ]);
    driver.start();
  });
});

$(document).ready(async function () {
  let queryString = window.location.href;
  let parametros = queryString.split("/");
  let codigoTipoFiscal = parametros[parametros.length - 1];

  if (codigoTipoFiscal != "" && codigoTipoFiscal != "create") {
    try {
      $.LoadingOverlay("show");
      try {
        let response = await requisicao(
          "GET",
          "/Sisplan/Funcoes/v1/pesquisa?",
          `JSON={ "tabela":"TIPO_FISCAL", 
          "camposSelect":[
          "CODIGO", "DESCRICAO","ABREVI", "EXPORTA", "MOD_NF_XML", "TIPO_DOC"
          ],
          "where": ["CODIGO = '${codigoTipoFiscal}'"]}`,
          null
        );

        if (!response) {
          return;
        }

        let jsonStr = await response.json();
        if (response.status != 200) {
          msgAlerta(jsonStr.RESULT[0].mensagem);
          return;
        }

        $("#txtCodigo").val(jsonStr.RESULT[0][0].CODIGO);
        $('#txtDescricao').val(jsonStr.RESULT[0][0].DESCRICAO);
        $('#txtAbreviacao').val(jsonStr.RESULT[0][0].ABREVI);
        if (jsonStr.RESULT[0][0].EXPORTA == "S") {
          $('#cbExportar').prop('checked', true);
        }
        if (jsonStr.RESULT[0][0].MOD_NF_XML == "S") {
          $('#cbModeloNfXML').prop('checked', true);
        }
        if (jsonStr.RESULT[0][0].TIPO_DOC == "S") {
          $('#cbTipoConTransp').prop('checked', true);
        }
      } catch (error) {
        console.error(error);
        msgAlerta(`Não foi possível buscar os dados:`);
      }
    } finally {
      $.LoadingOverlay("hide");
      $('#txtCodigo').prop('disabled', true);
      $('#txtCodigo').prop('readonly', true);
    }
  }

  $('#btnVoltar').on('click', function () {
    window.location.href = `${BASE_URI}/tipo_fiscal`;
  })

  $('#txtCodigo').on('blur', async function () {
    const sNumero = $('#txtCodigo').val();
    if (sNumero == '') {
      $('#txtCodigo').val(await RetornaProximo('CODIGO', 'TIPO_FISCAL', 'CODIGO', 2));
      $('#txtCodigo').prop('disabled', true);
      $('#txtCodigo').prop('readonly', true);
    }
  });

  async function gravaStatus() {
    $.LoadingOverlay('show')
    try {
      if ($('#txtDescricao').val() == '') {
        msgAlerta('Preencha o campo Descrição');
        return;
      }

      const sNumero = $('#txtCodigo').val();
      if (sNumero == '') {
        $('#txtCodigo').val(await RetornaProximo('CODIGO', 'TIPO_FISCAL', 'CODIGO', 2));
        $('#txtCodigo').prop('disabled', true);
        $('#txtCodigo').prop('readonly', true);
      }

      let novoTipoFIscal = {}

      novoTipoFIscal.CODIGO = $('#txtCodigo').val();
      novoTipoFIscal.DESCRICAO = $('#txtDescricao').val().toUpperCase();
      novoTipoFIscal.ABREVI = $("#txtAbreviacao").val().toUpperCase();
      if ($('#cbExportar').is(':checked')) {
        novoTipoFIscal.EXPORTA = 'S'
      };
      if ($('#cbModeloNfXML').is(':checked')) {
        novoTipoFIscal.MODNFXML = 'S'
      };
      if ($('#cbTipoConTransp').is(':checked')) {
        novoTipoFIscal.TIPODOC = 'S'
      };

      let response = await requisicao("POST", `/Sisplan/cadastros/V1/tipofiscal?`, `JSON=${JSON.stringify(novoTipoFIscal)}`, 15000);
      if (!response) {
        return;
      }

      let jsonStr = await response.json();
      if (jsonStr.codigo != 200) {
        msgAlerta(jsonStr.mensagem);
        return;
      }
      toastr.success(
        `Cadastro efetuado com sucesso!
         Tipo Fiscal: ${novoTipoFIscal.CODIGO}`,
        'Confirmação', {
        toastClass: 'alert',
        iconClasses: {
          error: 'alert-error',
          info: 'alert-info',
          success: 'alert-success',
          warning: 'alert-warning'
        },
        positionClass: "toast-top-center",
        progressBar: true,
        timeOut: 3000,
        fadeOut: 1000,
        onHidden() {
          window.location.href = `${BASE_URI}/tipo_fiscal`;
        }
      }).css({
        "margin-top": "20%",
        "width": "500px",
        "max-width": "500px"
      });
    } catch (err) {
      console.log(err);
      msgAlerta('Não foi possivel gravar os dados.')
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  $('#btnGravar').on('click', async function () {
    await gravaStatus()
  })
});
