$(document).ready(async function () {
    let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

    // aqui so valida se nao existe tem que criar para nao dar erro
    if (colunas == null || colunas.relTabPrecosProd == undefined) {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, relTabPrecosProd: [] }));
        colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
    }

    // confirma as colunas
    $('#btnConfirmarColunas').on('click', async function () {
        try {
            $.LoadingOverlay('show');

            const novasColunas = retornaNovasColunasInvisiveis();
            localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, relTabPrecosProd: novasColunas }))

            $('#tabelaPrecosProduto').DataTable().columns().visible(true);
            // $('#tabelaPrecosProduto').DataTable().columns(novasColunas).visible(false);

            $('#tabelaPrecosProduto').DataTable().columns().every(
                function () {
                    if ((novasColunas).indexOf(this.dataSrc()) != -1) {
                        this.visible(false);
                    }
                })

        } finally {
            $.LoadingOverlay('hide');
            $('#modal-ColunasVisiveis').modal('hide');
        }
    })

    $('#tutorial').on('click', function () {
        $(document).ready(async function () {
            const driver = new Driver({
                doneBtnText: 'Sair',
                closeBtnText: 'Fechar',
                nextBtnText: 'Próximo',
                prevBtnText: 'Anterior',
                allowClose: false
            });
            driver.defineSteps([{
                element: '#btnFiltros',
                popover: {
                    title: 'Botão Filtros',
                    description: 'Clique aqui para abrir os filtros e realizar uma consulta.',
                    position: 'right'
                }
            },
            {
                element: '#btnImprimir',
                popover: {
                    title: 'Botão Imprimir',
                    description: 'Clique aqui para imprimir um relatório.',
                    position: 'right'
                }
            },
            {
                element: '#PrecosProduto',
                popover: {
                    title: 'Tabela Tabelas de Preço do Produto',
                    description: 'Aqui, após clicar em consultar ficam os dados filtrados.',
                    position: 'bottom'
                }
            }
            ]);
            driver.start();
        });
    });

    $('#radioMaterial').on('change', function () {
        $('#txtCodigo').attr('placeholder', 'Código do Material');

    });

    $('#radioProduto').on('change', function () {
        $('#txtCodigo').attr('placeholder', 'Código do Produto');
    });


    $('#btnFiltros').on('click', async function () {
        $('#modal-filtros').modal('show');
    });

    var ultimaColunaOrdenada = {
        nome: '',
        ordenacao: 'ASC'
    };

    $('#btnLimpar').on('click', async function () {
        $('#txtCodigo').val('');
        $('#txtTabPreco').val('');
    });

    $('#btn-limpar-Codigo').on('click', async function () {
        $('#txtCodigo').val('');
    })

    $('#btn-limpar-TabPreco').on('click', async function () {
        $('#txtTabPreco').val('');
    })

    $('#btnFiltros').on('click', async function () {
        $('#modal-filtros').modal('show')
    });

    $('#btnConsultar').on('click', async function () {
        await fazConsultaTabPrecosProd();
        $('#modal-filtros').modal('hide')
    })

    const utilizaParam = await CopiaParametro('VENDA', 17);
    let utilizandoProd;
    let utilizandoMat;

    $('#btn-TabPreco').pesquisa_serverside(['#txtTabPreco'], ["REGIAO"], ["DESCRICAO"], `{"tabela":"REGIAO", "camposSelect":["REGIAO", "DESCRICAO"], "where": ["LIBERADO = 'S'"]}`, 'Pesquisa de Tabela de Preço');
    $('#txtTabPreco').autocompleta(1, `JSON={ "tabela":"regiao", "camposSelect":["REGIAO CHAVE, DESCRICAO DESCRICAO"], "where": ["LIBERADO = 'S'"]}`);

    if (utilizaParam === '1') {
        utilizandoMat = true;
        utilizandoProd = false;
        $('#radioMaterial').prop('checked', true);
        $('#btn-Codigo').pesquisa_serverside(['#txtCodigo'], ["CODIGO"], ["DESCRICAO"], `{"tabela":"MATERIAL", "camposSelect":["CODIGO", "DESCRICAO"], "where": ["ATIVO = 'S'"]}`, 'Pesquisa de Material');
        $('#btn-TabPreco').pesquisa_serverside(['#txtTabPreco'], ["REGIAO"], ["DESCRICAO"], `{"tabela":"REGIAO", "camposSelect":["REGIAO", "DESCRICAO"], "where": ["LIBERADO = 'S'"]}`, 'Pesquisa de Tabela de Preço');
        $('#txtTabPreco').autocompleta(1, `JSON={ "tabela":"regiao", "camposSelect":["REGIAO CHAVE, DESCRICAO DESCRICAO"], "where": ["LIBERADO = 'S'"]}`);
        $('#txtCodigo').autocompleta(1, `JSON={ "tabela":"produto", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": ["ATIVO = 'S'"]}`)
    } else {
        utilizandoProd = true;
        utilizandoMat = false;
        $('#radioProduto').prop('checked', true);
        $('#btn-Codigo').pesquisa_serverside(['#txtCodigo'], ["CODIGO"], ["DESCRICAO"], `{"tabela":"PRODUTO", "camposSelect":["CODIGO", "DESCRICAO"], "where": ["ATIVO = 'S'"]}`, 'Pesquisa de Produto');
        $('#txtCodigo').autocompleta(1, `JSON={ "tabela":"produto", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": ["ATIVO = 'S'"]}`);
    }

    $('#radioProduto').change('checked', async function () {
        utilizandoProd = true;
        utilizandoMat = false;
        $('#btn-Codigo').pesquisa_serverside(['#txtCodigo'], ["CODIGO"], ["DESCRICAO"], `{"tabela":"PRODUTO", "camposSelect":["CODIGO", "DESCRICAO"], "where": ["ATIVO = 'S'"]}`, 'Pesquisa de Produto');
        $('#txtCodigo').autocompleta(1, `JSON={ "tabela":"produto", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": ["ATIVO = 'S'"]}`);
        $('#txtCodigo').val('');
        $('#txtTabPreco').val('');
    })

    $('#radioMaterial').change('checked', async function () {
        utilizandoMat = true;
        utilizandoProd = false;
        $('#btn-Codigo').pesquisa_serverside(['#txtCodigo'], ["CODIGO"], ["DESCRICAO"], `{"tabela":"MATERIAL", "camposSelect":["CODIGO", "DESCRICAO"], "where": ["ATIVO = 'S'"]}`, 'Pesquisa de Material');
        $('#btn-TabPreco').pesquisa_serverside(['#txtTabPreco'], ["REGIAO"], ["DESCRICAO"], `{"tabela":"REGIAO", "camposSelect":["REGIAO", "DESCRICAO"], "where": ["LIBERADO = 'S'"]}`, 'Pesquisa de Tabela de Preço');
        $('#txtTabPreco').autocompleta(1, `JSON={ "tabela":"regiao", "camposSelect":["REGIAO CHAVE, DESCRICAO DESCRICAO"], "where": ["LIBERADO = 'S'"]}`);
        $('#txtCodigo').autocompleta(1, `JSON={ "tabela":"produto", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": ["ATIVO = 'S'"]}`);
        $('#txtCodigo').val('');
        $('#txtTabPreco').val('');
    })






    async function fazConsultaTabPrecosProd(numeroIndice = '', ordenacao = '') {
        $.LoadingOverlay('show');
        try {

            // const ajaxData = {
            //     "EMPRESA": getCookie('empresa'),
            //     "JSON": `{"tabela": "${tipoItem}", 
            //           "camposSelect": ["${camposSql}"], 
            //           "leftJoin": [${ligacaoTabPreco}], 
            //           "where": ["1=1 ${where}"],
            //           "orderby": ["${orderby}"]
            //         }`,
            //     "CLIENTE": 'N',
            // };
            // if ($.fn.DataTable.isDataTable('#tabelaPrecosProduto')) {
            //     $("#tabelaPrecosProduto").DataTable().destroy();
            //     $("#tabelaPrecosProduto").empty();
            // }

            const pesquisa = montaPesquisa(numeroIndice, ordenacao);

            const columns = [{
                title: 'CODIGO',
                data: 'CODIGO'
            },
            {
                title: 'DESCRICAO',
                data: 'DESCRICAO'
            },
            {
                title: 'TABELA',
                data: 'TABELA'
            },
            {
                title: 'DESC_TAB',
                data: 'DESC_TAB'
            },
            {
                title: 'PRECO_00',
                data: 'PRECO_00'
            },
            {
                title: 'PRECO_07',
                data: 'PRECO_07'
            },
            {
                title: 'PRECO_14',
                data: 'PRECO_14'
            },
            {
                title: 'PRECO_21',
                data: 'PRECO_21'
            },
            {
                title: 'PRECO_28',
                data: 'PRECO_28'
            },
            {
                title: 'PRECO_35',
                data: 'PRECO_35'
            },
            {
                title: 'PRECO_42',
                data: 'PRECO_42'
            },
            {
                title: 'PRECO_49',
                data: 'PRECO_49'
            },
            {
                title: 'PRECO_56',
                data: 'PRECO_56'
            },
            {
                title: 'PRECO_63',
                data: 'PRECO_63'
            },
            {
                title: 'PRECO_70',
                data: 'PRECO_70'
            },
            {
                title: 'PRECO_77',
                data: 'PRECO_77'
            },
            {
                title: 'PRECO_84',
                data: 'PRECO_84'
            },
            {
                title: 'PRECO_91',
                data: 'PRECO_91'
            },
            {
                title: 'ATIVO',
                data: 'ATIVO'
            },
            {
                title: 'PRECO_PROMO',
                data: 'PRECO_PROMO'
            },
            {
                title: 'DT_PROMOINI',
                data: 'DT_PROMOINI'
            },
            {
                title: 'DT_PROMOFIM',
                data: 'DT_PROMOFIM'
            }];

            const colsData = columns.map(e => e.data);

            $.LoadingOverlay('show');
            try {
                $('#tabelaPrecosProduto').DataTable({
                    paging: true,
                    lengthChange: true,
                    serverSide: true,
                    filter: false,
                    colReorder: true,
                    destroy: true,
                    ajax: {
                        url: `${getCookie('protocolo')}://${getCookie('ip_api')}/sisplan/funcoes/v1/pesquisadatatable`,
                        type: "POST",
                        headers: {
                            'Authorization': BASIC_AUTH
                        },
                        data: {
                            EMPRESA: getCookie('empresa'),
                            JSON: JSON.stringify(pesquisa),
                            CLIENTE: 'N'
                        },
                        dataSrc: function (data) {
                            const cols = colsData;
                            const array = data.data;
                            return array.map(row => {
                                return row.reduce((obj, value, index) => {
                                    obj[cols[index]] = value;
                                    return obj;
                                }, {});
                            });
                        }
                    },
                    columns: columns,
                    columnDefs: [{
                        "className": 'pr-4 text-right',
                        targets: [4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 19]
                    }]
                });
            }
            finally {
                $.LoadingOverlay('hide');
            }

            const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

            $('#tabelaPrecosProduto_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
            $('#tabelaPrecosProduto_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');

            $('#buttonColVis').prop('title', 'Configurar colunas visíveis')
            $('#buttonExcel').prop('title', 'Exportar')

            $('#buttonColVis').on('click', async function () {
                $.LoadingOverlay('show');
                $('#modal-ColunasVisiveis').modal('show');
                $.LoadingOverlay('hide');
            });

            $('#buttonExcel').on('click', async function () {
                const url = '/Sisplan/Funcoes/v1/pesquisa?';
                const pesquisa = montaPesquisa();
                await exportaCSV(url, `JSON=${encodeURIComponent(JSON.stringify(pesquisa))}`, true, null, 'Relatório de Tabelas de Preço do Produto', '#tabelaPrecosProduto');
            })


            $('#tabelaPrecosProduto').DataTable().columns().every(
                function () {
                    if ((colunasInvisiveis.relTabPrecosProd).indexOf(this.dataSrc()) != -1) {
                        this.visible(false);
                    }
                })

            // $('#tabelaPrecosProduto').DataTable().columns(colunasInvisiveis.relTabPrecosProd ?? []).visible(false);
            // adicionaColunas(columns, colunasInvisiveis.relTabPrecosProd ?? [])

            $('#tabelaPrecosProduto th').unbind('click');
            $('#tabelaPrecosProduto th').on('click', async function () {
                const table = $('#tabelaPrecosProduto').DataTable();
                const numeroIndice = table.column(this).index();
                let ordenacao = ultimaColunaOrdenada.ordenacao;
                ultimaColunaOrdenada.ordenacao = ultimaColunaOrdenada.ordenacao == 'ASC' ? 'DESC' : 'ASC'
                await fazConsultaTabPrecosProd(numeroIndice, ordenacao);
            });
        } finally {
            $.LoadingOverlay('hide');
        }
    }

    $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
        const cols = [];

        let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

        $('#tabelaPrecosProduto').DataTable().columns().every(function () {
            cols.push({
                'title': $(this.header()).text(),
                'data': this.dataSrc()
            })
        });

        adicionaColunas(cols, colunasInvisiveis.relTabPrecosProd ?? [])
    })

    function montaPesquisa(numeroIndice = '', ordenacao = '') {
        try {
            const tipoItem = $('#radioProduto').is(':checked') ? 'PRODUTO' : 'MATERIAL'
            const codigoProd = pegaChave('#txtCodigo');
            const tabPreco = pegaChave('#txtTabPreco');
            let orderby = $('#radioProduto').is(':checked') ? `${tipoItem}.CODIGO, TABPRECO.REGIAO` : `${tipoItem}.CODIGO, TABPRECO.REGIAO`;

            let camposSql;


            if (tipoItem === 'MATERIAL') {
                camposSql = ["MATERIAL.CODIGO", "MATERIAL.DESCRICAO", "TABPRECO.REGIAO AS TABELA", "TABPRECO.DESCRICAO DESC_TAB", "TABPRECO.PRECO_00", "TABPRECO.PRECO_07", "TABPRECO.PRECO_14", "TABPRECO.PRECO_21", "TABPRECO.PRECO_28", "TABPRECO.PRECO_35",
                    "TABPRECO.PRECO_42", "TABPRECO.PRECO_49", "TABPRECO.PRECO_56", "TABPRECO.PRECO_63", "TABPRECO.PRECO_70", "TABPRECO.PRECO_77", "TABPRECO.PRECO_84", "TABPRECO.PRECO_91", "MATERIAL.ATIVO", "TABPRECO.PRECO_PROMO", "TABPRECO.DT_PROMOINI", "TABPRECO.DT_PROMOFIM"];
            } else {
                camposSql = ["PRODUTO.CODIGO", "PRODUTO.DESCRICAO", "TABPRECO.REGIAO TABELA", "TABPRECO.DESCRICAO DESC_TAB", "TABPRECO.PRECO_00", "TABPRECO.PRECO_07", "TABPRECO.PRECO_14", "TABPRECO.PRECO_21", "TABPRECO.PRECO_28", "TABPRECO.PRECO_35", "TABPRECO.PRECO_42",
                    "TABPRECO.PRECO_49", "TABPRECO.PRECO_56", "TABPRECO.PRECO_63", "TABPRECO.PRECO_70", "TABPRECO.PRECO_77", "TABPRECO.PRECO_84", "TABPRECO.PRECO_91", "PRODUTO.ATIVO", "TABPRECO.PRECO_PROMO", "TABPRECO.DT_PROMOINI", "TABPRECO.DT_PROMOFIM"];
            }
            const ligacaoTabPreco = { "tabela": "TABPRECO", "condicao": `TABPRECO.CODIGO = ${tipoItem}.CODIGO` };
            let where = '';

            if (tipoItem === 'MATERIAL') {
                if (codigoProd !== '' && codigoProd !== undefined) {
                    where += ` AND MATERIAL.CODIGO = '${codigoProd}'`;
                }
            } else {
                if (codigoProd !== '' && codigoProd !== undefined) {
                    where += ` AND PRODUTO.CODIGO = '${codigoProd}'`;
                }
            }
            if (tabPreco !== '' && tabPreco !== undefined && tabPreco !== null) {
                where += ` AND TABPRECO.REGIAO = '${tabPreco}'`;
            }
            if (numeroIndice !== '') {
                orderby = `${camposSql[numeroIndice].split(' ')[0]} ${ordenacao}`;
            }

            return {
                tabela: tipoItem,
                camposSelect: camposSql,
                leftjoin: [ligacaoTabPreco],
                where: [`1=1 ${where}`],
                orderby: [orderby]
            }
        } catch (e) {
            console.log(e);
            msgErro(`Não foi possível buscar os dados: ${e}`);
        }
    }

    retornaHintRelatorio('btnImprimir', 'RelTabPrecosProd')
    await preencheOrdenacaoTela('RelTabPrecosProd');

    $('#btnImprimir').on('click', async function () {
        try {
            $.LoadingOverlay('show');
            try {
                let tipoCodigo;
                if (utilizandoMat === true) {
                    tipoCodigo = 'MATERIAL'
                } else {
                    tipoCodigo = 'PRODUTO'
                }
                let url = `/sisplan/impressao/v1/imprimirreltabprecosprod?`;
                const regiaoTabPreco = pegaChave('#txtTabPreco');
                const codigo = pegaChave('#txtCodigo');
                const filtros = `TIPO_ITEM=${tipoCodigo}&CODIGO=${codigo}&REGIAO=${regiaoTabPreco}`
                const ordem = `&TELA_ORDENACAO=RelTabPrecosProd&ORDEM_ORDENACAO=${$('#txtOrdem').val()}`;

                const bImprimeAutomatico = await verificaImprimirAutomatico('RelTabPrecosProd');
                let arquivo = await GeraRelatorio(`${url}${filtros}${ordem}`, 'GET', 1000000, false, 'RelTabPrecosProd');
                if (arquivo != undefined) {
                    if (!bImprimeAutomatico) {
                        window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
                    }
                    await limparRelatorios();
                }

            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    });

    // async function exportaCSV() {
    //     try {
    //         $.LoadingOverlay('show');
    //         try {

    //             const pesquisa = montaPesquisa();

    //             const response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
    //                 `JSON=${encodeURIComponent(JSON.stringify(pesquisa))}`, null);

    //             if (!response) {
    //                 return;
    //             }

    //             let jsonStr = await response.json();
    //             if (response.status != 200) {
    //                 msgErro(jsonStr.RESULT[0].mensagem);
    //                 return;
    //             }

    //             if (jsonStr.RESULT[0].length == 0) {
    //                 return;
    //             }

    //             const dados = jsonStr.RESULT[0];

    //             $('#tabelaPrecosProduto').DataTable().colReorder.reset();

    //             geraArquivoCSV(dados, 'Relatório de Tabelas de Preço do Produto', '#tabelaPrecosProduto');

    //         } catch (e) {
    //             console.error(e);
    //             msgErro(`Não foi possível realizar a exportação: ${e}`);
    //         }

    //     } finally {
    //         $.LoadingOverlay('hide');
    //     }
    // }
});



