/* eslint-disable prefer-destructuring */
$('#tutorial').on('click', function () {
    $('#geral-tab').trigger('click');
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false,
            onHighlightStarted: (Element) => {
                if (Element.node.id == 'geral') {
                    if (!$('#multiCollapseExample1').hasClass('show'));
                    $('#multiCollapseExample1').collapse('show');
                } else if (Element.node.id == 'documentoaba') {
                    if (!$('#collapseFiltros').hasClass('show')) {
                        $('#documento').collapse('show');
                        $('#multiCollapseExample2').collapse('show');
                    }
                } else if (Element.node.id == 'endereco') {
                    if (!$('#multiCollapseExample3').hasClass('show')) {
                        $('#multiCollapseExample3').collapse('show');
                        $('#enderecoGeral').collapse('show');
                    }
                } else if (Element.node.id == 'geral') {
                    if (!$('#collapseFiltros').hasClass('show')) {
                        $('#endereco_geral-tab').trigger('click');
                    }
                } else if (Element.node.id == 'endereco_entrega_geral') {
                    if (!$('#collapseFiltros').hasClass('show')) {
                        $('#enderecoEntrega').collapse('show');
                    }
                } else if (Element.node.id == 'endereco_cobranca_geral') {
                    if (!$('#collapseFiltros').hasClass('show')) {
                        $('#enderecoCobranca').collapse('show');
                    }
                } else if (Element.node.id == 'venda') {
                    if (!$('#collapseFiltros').hasClass('show')) {
                        $('#multiCollapseExample3').collapse('show');
                    }
                } else if (Element.node.id == 'compra') {
                    if (!$('#collapseFiltros').hasClass('show')) {
                        $('#multiCollapseExample4').collapse('show');
                    }
                }
            },
            onPrevious: (Element) => {
                if ((Element.node.id == 'documento-tab') || (Element.node.id == 'documentoaba')) {
                    if (!$('#geral>a').hasClass('collapsed')) {
                        $('#multiCollapseExample2').collapse('show');
                        // $('#geral').addClass('active show');
                    }
                } else if (Element.node.id == 'endereco') {
                    if (!$('#documento>a').hasClass('collapsed')) {
                        $('#documentoaba').collapse('show');
                        // $('#documento').addClass('active show');
                    }
                } else if (Element.node.id == 'endereco_entrega_geral-tab') {
                    if (!$('#endereco_geral').hasClass('active')) {
                        $('#endereco_geral-tab').trigger('click');
                        $('#endereco_geral').addClass('active show');
                    }
                } else if (Element.node.id == 'endereco_cobranca_geral-tab') {
                    if (!$('#endereco_entrega_geral').hasClass('active')) {
                        $('#endereco_entrega_geral-tab').trigger('click');
                        $('#endereco_entrega_geral').addClass('active show');
                    }
                }
            }
        });

        driver.defineSteps([{
            element: '#geral-tab',
            popover: {
                title: 'Aba Geral',
                description: 'Clique aqui para abrir a aba geral.',
                position: 'top'
            }
        },
        {
            element: '#geral',
            popover: {
                title: 'Cadastro Geral',
                description: 'Aqui você pode informar os dados gerais de cadastro do produto.',
                position: 'top'
            }
        },
        {
            element: '#multiCollapseExample1',
            popover: {
                title: 'Dados de Cadastro Geral',
                description: 'Esses são os campos que você informará os dados gerais de cadastro.',
                position: 'top'
            }
        },
        {
            element: '#tourcodigo',
            popover: {
                title: 'Campos Obrigatórios',
                description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#tourdesc',
            popover: {
                title: 'Campos Obrigatórios',
                description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#tourfaixa',
            popover: {
                title: 'Campos Obrigatórios',
                description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#tourund',
            popover: {
                title: 'Campos Obrigatórios',
                description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#tourundvenda',
            popover: {
                title: 'Campos Obrigatórios',
                description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#tourcolecao',
            popover: {
                title: 'Campos Obrigatórios',
                description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#tourgrupo',
            popover: {
                title: 'Campos Obrigatórios',
                description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#tourstatus',
            popover: {
                title: 'Campos Obrigatórios',
                description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#tourtabelacores',
            popover: {
                title: 'Tabela Cores',
                description: 'Aqui fica a tabela onde você pode inserir as cores.',
                position: 'top'
            }
        },
        {
            element: '#documentoaba',
            popover: {
                title: 'Aba Tributações',
                description: 'Clique aqui para abrir aba tributações.',
                position: 'top'
            }
        },
        {
            element: '#multiCollapseExample2',
            popover: {
                title: 'Dados de Tributações',
                description: 'Aqui ficam os dados de tributações a serem preenchidos.',
                position: 'top'
            }
        },
        {
            element: '#tourncm',
            popover: {
                title: 'Campos Obrigatórios',
                description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#touricms',
            popover: {
                title: 'Campos Obrigatórios',
                description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#toursped',
            popover: {
                title: 'Campos Obrigatórios',
                description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#toureipi',
            popover: {
                title: 'Campos Obrigatórios',
                description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#toursipi',
            popover: {
                title: 'Campos Obrigatórios',
                description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#tourposse',
            popover: {
                title: 'Campos Obrigatórios',
                description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#venda',
            popover: {
                title: 'Aba Cadastro de Cores',
                description: 'Aqui você pode adicionar as cores que o produto possui.',
                position: 'top'
            }
        },
        {
            element: '#compra',
            popover: {
                title: 'Aba Cadastro de Tipo de Venda/Regra',
                description: 'Aqui você pode adicionar os tipos de venda/regra ao produto.',
                position: 'top'
            }
        },
        {
            element: '#tourtabelavenda',
            popover: {
                title: 'Tabela Tipo de Venda/Regra',
                description: 'Aqui fica a tabela onde você pode inserir os tipos de venda/regra.',
                position: 'top'
            }
        },
        {
            element: "#btnVoltar",
            popover: {
                title: "Botão Voltar",
                description:
                    "Ao clicar nesse botão você retorna para a tela de consulta.",
                position: "left",
            },
        },
        {
            element: '#gravar',
            popover: {
                title: 'Botão Gravar',
                description: 'Ao clicar nesse botão você grava os dados inseridos.',
                position: 'left'
            }
        }
        ]);

        driver.start();
    });
});
$(document).ready(async function () {
    const empFaccao = false

    const parametrosSistema = await BuscaParametrosSistema('S');
    const quantidadeCasasDecimaisParametro = parametrosSistema[1] ?? 0;
    const quantidadeCasasDecimaisCampo = (+quantidadeCasasDecimaisParametro) + 2;
    let novoCodigoProduto

    $('#checkAtivo').attr('checked', true);

    let tipoVendaPadrao = '';
    let indexCor = -1;
    let alterandoCor = false;

    $('#txtPesoLiq').maskMoney({
        decimal: '.',
        thousands: '',
        precision: 2
    });
    $('#txtPesoMed').maskMoney({
        decimal: '.',
        thousands: '',
        precision: 2
    });
    $('#txtCusto').maskMoney({
        decimal: '.',
        thousands: '',
        precision: 2
    });
    $('#txtPrecoCompra').maskMoney({
        decimal: '.',
        thousands: '',
        precision: 2
    });
    $('#txtPrecoVenda').maskMoney({
        decimal: '.',
        thousands: '',
        precision: quantidadeCasasDecimaisCampo
    });
    $('#txtPrecoRepos').maskMoney({
        decimal: '.',
        thousands: '',
        precision: 2
    });
    $('#txtIpi').maskMoney({
        decimal: '.',
        thousands: '',
        precision: 2
    });
    $('#txtIcms').maskMoney({
        decimal: '.',
        thousands: '',
        precision: 2
    });

    $('#tabelaVendaRegra').DataTable({
        paging: false,
        filter: false,
        info: false,
        order: false,
        destroy: true,
        autowidth: true,
    });

    $('#tabelaFaixaCor').DataTable({
        scrollY: "178px",
        scrollX: true,
        scrollCollapse: true,
        paging: false,
        filter: false,
        info: false,
        order: false,
        destroy: true,
        autowidth: true,
        columnDefs: [
            {
                targets: [0], render: function (data, type, row) {
                    return retornaBotaoOpcoes(data);
                },
            },
        ],
    });

    $('#tabelaFaixaCor tbody').on('click', 'tr', function () {
        if ($(this).hasClass('selected')) {
            $(this).removeClass('selected');
        } else {
            $('#tabelaFaixaCor').DataTable().$('tr.selected').removeClass('selected');
            $(this).addClass('selected');
        }
    });

    $('#tabelaContas').DataTable({
        paging: false,
        filter: false,
        info: false,
        order: false,
        destroy: true,
        autowidth: true,
    });

    $('#tabelaEcomCor').DataTable({
        scrollY: '200px',
        scrollX: false,
        scrollCollapse: true,
        paging: false,
        filter: false,
        info: true,
        order: false,
        destroy: true,
        autowidth: true,
        columnDefs: [
            {
                targets: [0], render: function (data, type, row, meta) {
                    return '<div class="form-check pl-0">' +
                        '<div class="icheck-primary">' +
                        `<input style="height:20px" type="checkbox" id="check_ecomCor_col_${meta.col}_row_${meta.row}" class="align-self-center campoCheck"><label for="check_ecomCor_col_${meta.col}_row_${meta.row}"></label>` +
                        '</div>' +
                        '</div>';
                },
            },
        ],
    });

    $('.radio-group .radio').click(function () {
        $(this).parent().find('.radio').removeClass('selected');
        $(this).addClass('selected');
    });

    $(".submit").click(function () {
        return false;
    });

    $('#btnTributacoes').on('click', function () {
        $('#modalTrib').modal('show');
    });

    $('#btnFaixaCor').on('click', function () {
        $('#modalFaixaCor').modal('show');
    });

    $('#btnVendaRegra').on('click', function () {
        $('#modalVendaRegra').modal('show');
    });

    $('#txtCodigo2').on('blur', async function () {
        if ($(this).val() == '') {
            return
        }
        $.LoadingOverlay('show')
        try {
            const prodCodigo2 = await codigo2Existente($(this).val())

            if (prodCodigo2) {
                $(this).val('')
                throw new Error(`Codigo2 já utilizado no produto: ${prodCodigo2}. Impossível utilizar novamente!`)
            }

        } catch (error) {
            console.error(error)
            msgAlerta(error.message)
        } finally {
            $.LoadingOverlay('hide')
        }
    })

    // autocompleta
    $('#txtFaixaTam').autocompleta(1, `JSON={ "tabela":"faixa", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtFaixaTam').autocompleta(1, `JSON={ "tabela":"faixa", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);

    $('#txtFaixaTam').autocompleta(1, `JSON={ "tabela":"faixa", "camposSelect":[ "codigo chave", "descricao descricao"], "where": ["ativo = 'S'"]}`);
    $('#txtUnidade').autocompleta(1, `JSON={ "tabela":"unidade", "camposSelect":[ "unidade chave", "descricao descricao"], "where": null}`);
    $('#txtModelo').autocompleta(1, `JSON={ "tabela":"MODELO", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtUnidadeVenda').autocompleta(1, `JSON={ "tabela":"unidade", "camposSelect":[ "unidade chave", "descricao descricao"], "where": null}`);
    $('#txtUnidadeExp').autocompleta(1, `JSON={ "tabela":"unidade", "camposSelect":[ "unidade chave", "descricao descricao"], "where": null}`);
    $('#txtColecao').autocompleta(1, `JSON={ "tabela":"colecao", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtCodFornec').autocompleta(3, `JSON={ "tabela":"entidade", "camposSelect":[ "codcli chave", "nome descricao"], "where": null}`);
    $('#txtStatus').autocompleta(1, `JSON={ "tabela":"SITPROD", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtGrupo').autocompleta(1, `JSON={ "tabela":"GRUPO_PA", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtMarca').autocompleta(1, `JSON={ "tabela":"MARCA", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtEtiqueta').autocompleta(1, `JSON={ "tabela":"ETQ_PROD", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtCodCliente').autocompleta(3, `JSON={ "tabela":"entidade", "camposSelect":[ "codcli chave", "nome descricao"], "where": null}`);
    $('#txtLinha').autocompleta(1, `JSON={ "tabela":"tablin", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtNcm').autocompleta(1, `JSON={ "tabela":"tabfis", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtCstIcms').autocompleta(1, `JSON={ "tabela":"TABTRI", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtCstIpiSaida').autocompleta(1, `JSON={ "tabela":"TABIPI", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtCstIpiEntrada').autocompleta(1, `JSON={ "tabela":"TABIPI", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtSped').autocompleta(1, `JSON={ "tabela":"TABSPED", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtEnqIpi').autocompleta(1, `JSON={ "tabela":"ENQUADRA", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtNatureza').autocompleta(1, `JSON={ "tabela":"NATUREZA", "camposSelect":[ "natureza chave", "descricao descricao"], "where": null}`);
    $('#txtEmpresaRegra').autocompleta(1, `JSON={ "tabela":"empresa", "camposSelect":[ "emp_pat chave, emp_nome descricao" ], "where": null}`);
    $('#txtRegra').autocompleta(1, `JSON={ "tabela":"regra", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtCondPagto').autocompleta(1, `JSON={ "tabela":"cadcor", "camposSelect":[ "cor chave", "descricao descricao"], "where": null}`);
    $('#txtStatusCor').autocompleta(1, `JSON={ "tabela":"sitprod", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);

    $('#txtEmpresaRegra').change(async function () {
        valor = $('#txtEmpresaRegra').val();
        $('#txtEmpresaRegra').val(valor.replace('_', ''));
    });


    $('#btnEstilista').pesquisa('#txtEstilista', 'CODIGO', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"PESSOAL", "camposSelect":[ "PESSOAL.CODIGO", "PESSOAL.NOME", "FUNCAO.DESCRICAO"], "leftJoin": [{"tabela": "FUNCAO", "condicao": "FUNCAO.CODIGO = PESSOAL.FUNCAO"}], "where": ["FUNCAO.DESCRICAO LIKE '[PERCENTUAL]ESTILISTA[PERCENTUAL]'"]}`, 'Pesquisa de Estilista', 'PESSOAL');
    $('#txtEstilista').autocompleta(1, `JSON={ "tabela":"PESSOAL", "camposSelect":[ "PESSOAL.CODIGO chave", "PESSOAL.NOME descricao"], "leftJoin": [{"tabela": "FUNCAO", "condicao": "FUNCAO.CODIGO = PESSOAL.FUNCAO"}], "where": ["FUNCAO.DESCRICAO LIKE '[PERCENTUAL]ESTILISTA[PERCENTUAL]'"]}`);

    $('#btnModelista').pesquisa('#txtModelista', 'CODIGO', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"PESSOAL", "camposSelect":[ "PESSOAL.CODIGO", "PESSOAL.NOME", "FUNCAO.DESCRICAO"], "leftJoin": [{"tabela": "FUNCAO", "condicao": "FUNCAO.CODIGO = PESSOAL.FUNCAO"}], "where": ["FUNCAO.DESCRICAO LIKE '[PERCENTUAL]MODELISTA[PERCENTUAL]'"]}`, 'Pesquisa de Modelista', 'PESSOAL');
    $('#txtModelista').autocompleta(1, `JSON={ "tabela":"PESSOAL", "camposSelect":[ "PESSOAL.CODIGO chave", "PESSOAL.NOME descricao"], "leftJoin": [{"tabela": "FUNCAO", "condicao": "FUNCAO.CODIGO = PESSOAL.FUNCAO"}], "where": ["FUNCAO.DESCRICAO LIKE '[PERCENTUAL]MODELISTA[PERCENTUAL]'"]}`);

    $('#btnSimbologia').pesquisa('#txtSimbologia', 'CODIGO', 'PRODUTO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"ETIQUETA", "camposSelect":["CODIGO","COR","PRODUTO","LINHA01 ","LINHA02","LINHA03","LINHA04","LINHA05","LINHA06","LINHA07","LINHA08"]}`, 'Pesquisa de Simbologia', 'SIMBOLOGIA');

    componenteFiltro('cuidado', false);
    componenteFiltro('auxiliar', false, false, 'Categoria');
    componenteFiltro('tipoProduto', false, false)

    // $('#btnModelista').pesquisa('#txtEstilista', 'CODIGO', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"PESSOAL", "camposSelect":[ "codigo", "NOME", "tipo"]}`, 'Pesquisa de Estilista', 'TABFIS');

    $('#btnNcm').pesquisa('#txtNcm', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABFIS", "camposSelect":[ "codigo", "descricao", "observacao", "tipo"]}`, 'Pesquisa NCM', 'TABFIS');
    $('#btnCstIcms').pesquisa('#txtCstIcms', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABTRI", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa CST ICMS', 'TABTRI');
    $('#btnCstIpiSaida').pesquisa('#txtCstIpiSaida', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABIPI", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa IPI Saída', 'TABIPI');
    $('#btnCstIpiEntrada').pesquisa('#txtCstIpiEntrada', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABIPI", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa IPI Entrada', 'TABIPI');
    $('#btnSped').pesquisa('#txtSped', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABSPED", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa Código SPED', 'TABSPED');
    $('#btnEnqIpi').pesquisa('#txtEnqIpi', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"ENQUADRA", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa Enquadramento IPI', 'ENQUADRA');
    $('#btnNatureza').pesquisa('#txtNatureza', 'NATUREZA', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"NATUREZA", "camposSelect":[ "natureza", "descricao"]}`, 'Pesquisa Natureza', 'NATUREZA');
    $('#btnEmpresaRegra').pesquisa('#txtEmpresaRegra', 'EMP_PAT', 'EMP_NOME', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"empresa", "camposSelect":[ "replace(emp_pat,'_','') as EMP_PAT", "emp_nome"]}`, 'Pesquisa Empresa', 'empresa');
    $('#btnRegra').pesquisa('#txtRegra', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"regra", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa Regra', 'regra');
    $('#btnCodFornerc').pesquisa('#txtCodFornec', 'CODCLI', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"entidade", "camposSelect":[ "codcli", "nome"]}`, 'Pesquisa Fornecedor', 'entidade');
    $('#btnFaixaTam').pesquisa('#txtFaixaTam', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"faixa", "camposSelect":[ "codigo", "descricao", "descricao2"], "where": ["ativo = 'S'"]}`, 'Pesquisa Faixa de Tamanho', 'faixa');
    $('#btnGrupo').pesquisa('#txtGrupo', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"GRUPO_PA", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa Grupo', 'GRUPO_PA');
    $('#btnMarca').pesquisa('#txtMarca', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"MARCA", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa Marca', 'marca');
    $('#btnEtiqueta').pesquisa('#txtEtiqueta', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"ETQ_PROD", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa Etiqueta', 'ETQ_PROD');
    $('#btnCodCliente').pesquisa('#txtCodCliente', 'CODCLI', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"entidade", "camposSelect":[ "codcli", "nome"]}`, 'Pesquisa Fornecedor', 'entidade');
    $('#btnColecao').pesquisa('#txtColecao', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"colecao", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa Coleção', 'colecao');
    $('#btnLinha').pesquisa('#txtLinha', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"tablin", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa Linha', 'tablin');
    $('#btnStatus').pesquisa('#txtStatus', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"SITPROD", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa Status', 'SITPROD');
    $('#btnTag').pesquisa('#txtTag', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CADTAG", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa TAG', 'CADTAG');
    $('#btnFaixaDesc').pesquisa('#txtFaixaDesc', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"FAIXA_DESCONTO", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa Faixa Desconto', 'FAIXA_DESCONTO');
    $('#btnUnidade').pesquisa('#txtUnidade', 'UNIDADE', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"unidade", "camposSelect":[ "unidade", "descricao"]}`, 'Pesquisa Unidade', 'unidade');
    $('#btnModelo').pesquisa('#txtModelo', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"modelo", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa Modelo', 'modelo');
    $('#btnUnidadeVenda').pesquisa('#txtUnidadeVenda', 'UNIDADE', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"unidade", "camposSelect":[ "unidade", "descricao"]}`, 'Pesquisa Unidade', 'unidade');
    $('#btnUnidadeExp').pesquisa('#txtUnidadeExp', 'UNIDADE', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"unidade", "camposSelect":[ "unidade", "descricao"]}`, 'Pesquisa Unidade', 'unidade');
    $('#btn-StatusCor').pesquisa('#txtStatusCor', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"sitprod", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa Status', 'codigo');

    // limpa campos
    $('#btnANcm').on('click', function () {
        $('#txtNcm').val('');
    });
    $('#btnACstIcms').on('click', function () {
        $('#txtCstIcms').val('');
    });
    $('#btnACstIpiSaida').on('click', function () {
        $('#txtCstIpiSaida').val('');
    });
    $('#btnACstIpiEntrada').on('click', function () {
        $('#txtCstIpiEntrada').val('');
    });
    $('#btnASped').on('click', function () {
        $('#txtSped').val('');
    });
    $('#btnAEnqIpi').on('click', function () {
        $('#txtEnqIpi').val('');
    });
    $('#btnANatureza').on('click', function () {
        $('#txtNatureza').val('');
    });
    $('#btnAEmpresaRegra').on('click', function () {
        $('#txtEmpresaRegra').val('');
    });
    $('#btnARegra').on('click', function () {
        $('#txtRegra').val('');
    });
    $('#btnACodFornerc').on('click', function () {
        $('#txtCodFornec').val('');
    });
    $('#btnAFaixaTam').on('click', function () {
        $('#txtFaixaTam').val('');
    });
    $('#btnAGrupo').on('click', function () {
        $('#txtGrupo').val('');
    });
    $('#btnAMarca').on('click', function () {
        $('#txtMarca').val('');
    });
    $('#btnAEtiqueta').on('click', function () {
        $('#txtEtiqueta').val('');
    });
    $('#btnACodCliente').on('click', function () {
        $('#txtCodCliente').val('');
    });
    $('#btnAColecao').on('click', function () {
        $('#txtColecao').val('');
    });
    $('#btnALinha').on('click', function () {
        $('#txtLinha').val('');
    });
    $('#btnAStatus').on('click', function () {
        $('#txtStatus').val('');
    });
    $('#btnATag').on('click', function () {
        $('#txtTag').val('');
    });
    $('#btnAFaixaDesc').on('click', function () {
        $('#txtFaixaDesc').val('');
    });
    $('#btnAUnidade').on('click', function () {
        $('#txtUnidade').val('');
    });
    $('#btnAUnidadeVenda').on('click', function () {
        $('#txtUnidadeVenda').val('');
    });
    $('#btnAUnidadeExp').on('click', function () {
        $('#txtUnidadeExp').val('');
    });
    $('#btnAModelo').on('click', function () {
        $('#txtModelo').val('');
    });
    $('#btnAbrirCondicao').on('click', function () {
        $('#modalCondicao').modal('show');
        $('#btn-limpa-CondPagto').trigger('click');
        $('#btn-limpa-StatusCor').trigger('click');
    });
    $('#btnAbrirVendaRegra').on('click', function () {
        $('#modalAdicionarVendaRegra').modal('show');
    });
    $('#btn-limpa-CondPagto').on('click', function () {
        $('#txtCondPagto').val('');
        $('#txtCodigo2Cor').val('');
    });
    $('#btnAEstilista').on('click', function () {
        $('#txtEstilista').val('');
    });
    $('#btnAModelista').on('click', function () {
        $('#txtModelista').val('');
    });
    $('#btnASimbologia').on('click', function () {
        $('#txtSimbologia').val('');
    });
    $('#btnACuidado').on('click', function () {
        $('#txtCuidado').val('');
    });
    $('#btn-limpa-CondPagto').on('click', function () {
        $('#txtStatusCor').val('');
    });

    $('#txtCondPagto').on('blur', async function () {
        let cor = pegaChave('#txtCondPagto');
        if (cor != '') {
            try {
                response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                    `JSON={ "tabela":"CADCOR",
          "camposSelect":["CODIGO2"],
          "where": ["COR = '${cor}'"]}`, null);

                if (!response) {
                    return;
                }
                let jsonStr = await response.json();
                if (response.status != 200) {
                    console.error(jsonStr[0].mensagem);
                    return;
                }

                $('#txtCodigo2Cor').val(jsonStr.RESULT[0][0].CODIGO2);
            } catch (error) {
                console.error(error);
            }
        }
    })

    $('#btnAdicionar').on('click', async function () {
        let desc = $('#txtCondPagto').val();
        if (desc == '') {
            msgAlerta('Selecione uma cor');
            return;
        }
        addValorCond();
        $('#txtCondPagto').val('');
        $('#txtCodigo2Cor').val('');
        $('#txtStatusCor').val('');
        $('#cbCorAtiva').prop('checked', true);
    });


    async function addValorCond() {
        let codCond = pegaChave('#txtCondPagto');
        let descCond = pegaDescricao('#txtCondPagto');
        let codigo2 = $('#txtCodigo2Cor').val();
        let codStatus = pegaChave('#txtStatusCor');
        let descStatus = pegaDescricao('#txtStatusCor');
        let ativo = $('#cbCorAtiva').is(':checked') ? 'S' : 'N';
        const datatable = $('#tabelaFaixaCor').DataTable()

        if (alterandoCor && indexCor >= 0) {
            if (datatable.data().toArray().some((item, index) => item[0] === codCond && index !== indexCor)) {
                msgErro('Cor informada já existe para o produto.')
                return
            }
            datatable.row(indexCor).data([codCond, codigo2, descCond, ativo, codStatus, descStatus,
                '<div class="divBtn-Opcoes p-0"> ' +
                `   <img class="imagemAnexoCor" id="fotoAnexoCor" src="${BASE_URI}/dist/img/fotoProdPadrao.png" alt="Imagem de anexo a esta cor" title="Imagem de anexo a esta cor" style="width: 50px; height: 50px; cursor: pointer;">` +
                '</div>'
            ]).draw(false);
            $('#modalCondicao').modal('hide');
        } else {
            if (datatable.data().toArray().some((item) => item[0] === codCond)) {
                msgErro('Cor informada já existe para o produto.')
                return
            }
            datatable.row.add([codCond, codigo2, descCond, ativo, codStatus, descStatus,
                '<div class="divBtn-Opcoes p-0"> ' +
                `   <img class="imagemAnexoCor" id="fotoAnexoCor" src="${BASE_URI}/dist/img/fotoProdPadrao.png" alt="Imagem de anexo a esta cor" title="Imagem de anexo a esta cor" style="width: 50px; height: 50px; cursor: pointer;">` +
                '</div>'
            ]).draw(false);
        }
    };
    let coresExcluir = [];

    $('#tabelaFaixaCor').on('click', '#btnExluirCond', async function () {
        event.preventDefault();
        let table = $('#tabelaFaixaCor').DataTable();
        let rowData = table.row($(this).parents('tr')).data();
        let produto = $("#txtCodigo").val();
        let cor = rowData[0];

        let corTabela = {
            CODIGO: produto,
            COR: cor,
            TIPO: 'P'
        }

        let response = await requisicao(
            "GET",
            "/Sisplan/Cadastros/v1/validausocor?",
            `JSON=${encodeURIComponent(JSON.stringify(corTabela))}`,
            null
        );

        if (!response) {
            $.LoadingOverlay("hide");
            return;
        };
        let jsonStr = await response.json();
        if (response.status != 200) {
            $.LoadingOverlay("hide");
            msgErro(jsonStr.mensagem);
            return;
        } else {
            coresExcluir.push(corTabela);
            table.row($(this).parents('tr')).remove().draw(false);
        }
    });

    $('#tabelaFaixaCor').on('click', '#btnAlterarCond', async function () {
        event.preventDefault();
        $.LoadingOverlay('show')
        try {
            const item = $('#tabelaFaixaCor').DataTable().row($(this).parents('tr')).data()
            indexCor = $('#tabelaFaixaCor').DataTable().row($(this).parents('tr')).index()
            $('#modalCondicao').modal('show');
            $('#btn-limpa-CondPagto').trigger('click');
            $('#btn-limpa-StatusCor').trigger('click');
            insereValor('#txtCondPagto', item[0], item[2])
            insereValor('#txtStatusCor', item[4], item[5])
            insereValor('#txtCodigo2Cor', item[1])
            $('#cbCorAtiva').prop('checked', item[3] == 'S')
            alterandoCor = true;
        } finally {
            $.LoadingOverlay('hide')
        }
    });

    $('#modalCondicao').on('hidden.bs.modal', function () {
        indexCor = -1;
        alterandoCor = false;
    })

    $('#tabelaVendaRegra').on('click', '#btnExluirCond', async function () {
        let table = $('#tabelaVendaRegra').DataTable();
        table
            .row($(this).parents('tr'))
            .remove()
            .draw(false);
    });

    $('#btnAdicionarTipoRegra').on('click', async function () {
        const tipoVenda = $('#txtTipoVenda').val();
        const empresaTipo = pegaChave('#txtEmpresaRegra')
        const regra = pegaChave('#txtRegra');
        const regraDesc = pegaDescricao('#txtRegra');
        const tributacao = pegaValor('#selectTrib')
        const codsped = pegaChave('#txtSped')

        addTipoRegra(tipoVenda, empresaTipo, regra, regraDesc, tributacao, codsped);

        toastr.success(
            `Registro adicionado com sucesso!`,
            'Confirmação', {
            toastClass: 'alert',
            iconClasses: {
                error: 'alert-error',
                info: 'alert-info',
                success: 'alert-success',
                warning: 'alert-warning'
            },
            positionClass: "toast-top-center",
            progressBar: true,
            timeOut: 5000,
            fadeOut: 3000
        }
        ).css({
            "margin-top": "20%",
            "width": "500px",
            "max-width": "500px"
        });

        $('#txtTipoVenda').val('');
        $('#txtEmpresaRegra').val('');
        $('#txtRegra').val('');
        ;
    });

    async function addTipoRegra(tipoVenda, empresaTipo, regra, regraDesc, tributacao, codsped) {
        try {
            $.LoadingOverlay('show');

            if (!tipoVenda || !empresaTipo || !tributacao || !codsped) {
                msgAlerta('Favor preencher todos os campos obrigatórios!');
                return;
            }

            $('#tabelaVendaRegra').DataTable().row.add([tipoVenda, empresaTipo, regra, regraDesc, tributacao, codsped,
                '<div style="text-align:center;"> ' +
                '   <button class="btn btn-info btn-sm" id="btnExluirTipo" type="button"> ' +
                '      Excluir' +
                '   </button> ' +
                '</div>'
            ]).draw(false);

        } finally {
            $.LoadingOverlay('hide');
        }
    };

    $('#tabelaVendaRegra').on('click', '#btnExluirTipo', async function () {
        let table = $('#tabelaVendaRegra').DataTable();
        table
            .row($(this).parents('tr'))
            .remove()
            .draw(false);
    });

    $('#msform').validate({
        debug: false,
        ignore: "",
        rules: {
            txtDescricaoProduto: {
                required: true,
                validarCaracteres: true,
            },
            txtFaixaTam: {
                required: true,
            },
            txtUnidade: {
                required: true,
            },
            txtUnidadeVenda: {
                required: true,
            },
            txtStatus: {
                required: true,
            },
            txtGrupo: {
                required: true,
            },
            txtNcm: {
                required: true,
            },
            txtCstIcms: {
                required: true,
            },
            txtSped: {
                required: true,
            },
            txtCstIpiEntrada: {
                required: true,
            },
            txtCstIpiSaida: {
                required: true,
            }
        },
        messages: {
            txtDescricaoProduto: {
                required: "Informe uma descrição válida.",
                validarCaracteres: "A descrição do produto não pode conter os seguintes caracteres: ? ! &quot; * &lt; &gt; | ",
            },
            txtFaixaTam: {
                required: "Informe uma faixa de tamanho válida.",
            },
            txtUnidade: {
                required: "Informe uma unidade válida."
            },
            txtUnidadeVenda: {
                required: "Informe uma unidade válida."
            },
            txtStatus: {
                required: "Informe um status válido."
            },
            txtGrupo: {
                required: "Informe um grupo válido."
            },
            txtNcm: {
                required: "Informe um NCM válido."
            },
            txtCstIcms: {
                required: "Informe um CST ICMS válido."
            },
            txtSped: {
                required: "Informe um SPED válido."
            },
            txtCstIpiEntrada: {
                required: "Informe um CST IPI válido."
            },
            txtCstIpiSaida: {
                required: "Informe um CST IPI válido."
            }
        },
        errorElement: 'span',
        errorPlacement(error, element) {
            error.addClass('invalid-feedback');
            element.closest('.form-group').append(error);
        },
        highlight(element) {
            $(element).addClass('is-invalid');
        },
        unhighlight(element) {
            $(element).removeClass('is-invalid');
        }
    });

    async function buscaFoto(codigo) {
        try {
            let urlRequisicao = '/Sisplan/Funcoes/v1/FotoItem?';
            let response = await requisicao('GET', urlRequisicao, `codigo=${codigo}`, null);

            if (!response) {
                return;
            }
            let jsonStr = await response.json();
            if (response.status !== 200) {
                $("#infoprodimagem").attr('src', `${BASE_URI}/dist/img/prod-1.png`);
                return;
            }

            let sBase64 = jsonStr.mensagem;

            let extension = "png";
            let contentType = response.headers.get('content-type');
            if (contentType && contentType.indexOf('image/') === 0) {
                extension = contentType.replace('image/', '');
            }

            if (extension === "png") {
                $("#infoprodimagem").attr('src', `data:image/png;base64,${sBase64}`);
            } else {
                let jpegBase64 = await convertToJPEG(sBase64);
                $("#infoprodimagem").attr('src', `data:image/jpg;base64,${jpegBase64}`);
            }

        } catch (error) {
            console.error(error);
            $("#infoprodimagem").attr('src', `${BASE_URI}/dist/img/prod-1.png`);
        }
    }

    async function verificaSeCorExiste(CorInformada) {
        const PesquisaCor = {
            tabela: 'CADCOR',
            camposSelect: ['CADCOR.COR'],
            where: [`CADCOR.COR = '${CorInformada}'`]
        };

        const jsonStrCor = await retornaJsonPesquisaPadrao(JSON.stringify(PesquisaCor));

        if (jsonStrCor.length > 0) {
            return true
        } else {
            return false
        };
    };

    async function verificaSeFaixaExiste(FaixaInformada) {
        const PesquisaFaixa = {
            tabela: 'FAIXA',
            camposSelect: ['CODIGO'],
            where: [`FAIXA.CODIGO = '${FaixaInformada}'`]
        };

        const jsonStrFaixa = await retornaJsonPesquisaPadrao(JSON.stringify(PesquisaFaixa));

        if (jsonStrFaixa.length > 0) {
            return true
        } else {
            return false
        };
    };

    $('#fileimagem').change(async function () {

        try {
            $.LoadingOverlay("show");
            const leitorDeArquivos = new FileReader();
            const previaDaImagem = document.querySelector('.imagem');
            const inputArquivo = document.querySelector('.upload');

            let imagemEnviada = inputArquivo.files[0];
            let extencao = imagemEnviada.name.match(/\.([^\.]+)$/)[1]
            if (['jpg', 'png', 'jpeg'].indexOf(extencao) == -1) {
                msgAlerta('Impossivel adicionar arquivos diferentes de .JPG e .PNG')
                return
            }
            leitorDeArquivos.readAsDataURL(imagemEnviada);
            leitorDeArquivos.addEventListener('loadend', function (load) {
                previaDaImagem.src = load.target.result;
            });

        } finally {
            $.LoadingOverlay('hide');
        }
    });

    $('#btn-CondPagto').pesquisa('#txtCondPagto', 'COR', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"cadcor", "camposSelect":["cor", "codigo2", "descricao"]}`, 'Pesquisa Cor', 'cadcor');

    let queryString = window.location.href;
    let parametros = queryString.split('/');
    let produto = parametros[parametros.length - 1] == 'create' ? parametros[parametros.length - 1] : descriptografaUrl(parametros[parametros.length - 1]);
    await buscaFoto(produto);

    if (produto != 'create') {
        $('#txtCodigo').prop('disabled', true);
        $('#txtCodigo').prop('readonly', true);
        // try {
        //     let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
        //         `JSON={ "tabela":"produto_ordem",
        //     "camposSelect":["CODIGO"],
        //     "where": ["codigo = '${produto}'"]}`, null);
        //     let jsonStr = await response.json();

        //     if (jsonStr.RESULT[0] != '') {
        //         $('#txtFaixaTam').attr('readonly', true);
        //         $('#btnFaixaTam').addClass('d-none');
        //         $('#btnAFaixaTam').addClass('d-none');
        //     }
        // } catch (error) {
        //     console.error(error);
        // }

        // try {
        //     response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
        //         `JSON={ "tabela":"pcpft2",
        //     "camposSelect":["CODIGO"],
        //     "where": ["codigo = '${produto}'"]}`, null);
        //     jsonStr = await response.json();

        //     if (jsonStr.RESULT[0] != '') {
        //         $('#txtFaixaTam').attr('readonly', true);
        //         $('#btnFaixaTam').addClass('d-none');
        //         $('#btnAFaixaTam').addClass('d-none');
        //     }
        // } catch (error) {
        //     console.error(error);
        // }

        // $('#txtCodigo').attr('readonly', true);

        $('#btnAlterarObsMontagem').prop('disabled', false);
        $('#btnExcluirFotoMontagem').prop('disabled', false);
    }


    function validarCaracteres(value) {
        if (value == "") return 0;
        const regex = /[?!\"*<>|']/;
        return regex.test(value) ? 1 : 0;
    }

    if (produto != '' && produto != 'create') {
        $('#txtCodigo').prop('disabled', true);
        $('#txtCodigo').prop('readonly', true);

        // if (await liberarRegistro('PRODUTO', produto) == false) {
        //     window.location.href = '../produto';
        // } else {

        try {
            $.LoadingOverlay("show");
            try {
                // const obj = {
                //     "tabela": "produto",
                //     "camposSelect": ["CODIGO", "DESCRICAO", "CODIGO2", "PROTOTIPO", "QTDE_MIN", "DESCRICAO2",
                //         "PESO_TALHADO", "PESO", "CUSTO", "PRECO_COM", "PRECO", "PRECO_REPOS",
                //         "CODEXTIPI", "IPI", "ICMS", "ATIVO", "LIBERADO", "FAIXA", "FORNECEDOR",
                //         "GRUPO", "CODCLI", "STATUS", "MARCA", "COLECAO", "ETIQUETA", "LINHA",
                //         "FAIXA_DESCONTO", "UNIDADE", "UNI_VENDA", "UNI_EXP", "CODFIS", "CODTRIB", "CODIPI",
                //         "CODIPI_ENT", "CODSPED", "NATUREZA", "ENQUADRA", "TIPO_IMPORTACAO", "POSSE",
                //         "TRIBUTACAO", "ECF_TRIB", "ESTILISTA", "MODELISTA", "REFERENCIA", "ETQ_COMPOSI"
                //     ],
                //     "where": [`codigo = '${produto}'`]
                // };
                // let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                // `JSON=${encodeURIComponent(JSON.stringify(obj))}`, null);
                let response = await requisicao('GET', '/Sisplan/cadastros/v1/produto?',
                    `CODIGO=${produto}`, null);

                if (!response) {
                    return;
                }
                let jsonStr = await response.json();
                if (response.status != 200) {
                    msgErro(jsonStr[0].mensagem);
                    return;
                }

                $('#txtCodigo').val(jsonStr[0].CODIGO);
                $('#txtDescricaoProduto').val(jsonStr[0].DESCRICAO);
                $('#txtCodigo2').val(jsonStr[0].CODIGO2);
                $('#txtPrototipo').val(jsonStr[0].PROTOTIPO);

                parseFloat($('#txtEstMin').val(jsonStr[0].QTDE_MIN));
                $('#txtComplemento').val(jsonStr[0].DESCRICAO2);
                parseFloat($('#txtPesoLiq').val(jsonStr[0].PESO_TALHADO));
                parseFloat($('#txtPesoMed').val(jsonStr[0].PESO));
                parseFloat($('#txtCusto').val(jsonStr[0].CUSTO));
                parseFloat($('#txtPrecoCompra').val(jsonStr[0].PRECO_COM));
                parseFloat($('#txtPrecoVenda').val(jsonStr[0].PRECO));
                parseFloat($('#txtPrecoRepos').val(jsonStr[0].PRECO_REPOS));
                $('#txtExtIpi').val(jsonStr[0].CODEXTIPI);
                $('#txtIpi').val(jsonStr[0].IPI);
                $('#txtReferencia').val(jsonStr[0].REFERENCIA);
                parseFloat($('#txtIcms').val(jsonStr[0].ICMS));

                if (jsonStr[0].ATIVO == "S") {
                    $('#checkAtivo').prop('checked', true);
                } else {
                    $('#checkAtivo').prop('checked', false);
                }

                if (jsonStr[0].LIBERADO == "S") {
                    $('#checkLiberado').prop('checked', true);
                } else {
                    $('#checkLiberado').prop('checked', false);
                }

                if (jsonStr[0].TIPO_IMPORTACAO == "N") {
                    $('#selectImp').val(0);
                }
                if (jsonStr[0].TIPO_IMPORTACAO == "D") {
                    $('#selectImp').val(1);
                }
                if (jsonStr[0].TIPO_IMPORTACAO == "I") {
                    $('#selectImp').val(2);
                }

                if (jsonStr[0].TRIBUTACAO == "N") {
                    $('#selectTrib').val(0);
                }
                if (jsonStr[0].TRIBUTACAO == "D") {
                    $('#selectTrib').val(1);
                }
                if (jsonStr[0].TRIBUTACAO == "1") {
                    $('#selectTrib').val(2);
                }
                if (jsonStr[0].TRIBUTACAO == "2") {
                    $('#selectTrib').val(3);
                }
                if (jsonStr[0].TRIBUTACAO == "3") {
                    $('#selectTrib').val(4);
                }
                if (jsonStr[0].TRIBUTACAO == "4") {
                    $('#selectTrib').val(5);
                }
                if (jsonStr[0].TRIBUTACAO == "5") {
                    $('#selectTrib').val(6);
                }
                if (jsonStr[0].TRIBUTACAO == "6") {
                    $('#selectTrib').val(7);
                }
                if (jsonStr[0].TRIBUTACAO == "7") {
                    $('#selectTrib').val(8);
                }
                if (jsonStr[0].TRIBUTACAO == "8") {
                    $('#selectTrib').val(9);
                }

                if (jsonStr[0].ECF_TRIB == "I") {
                    $('#selectTribEcf').val(0);
                }
                if (jsonStr[0].ECF_TRIB == "N") {
                    $('#selectTribEcf').val(1);
                }
                if (jsonStr[0].ECF_TRIB == "F") {
                    $('#selectTribEcf').val(2);
                }
                if (jsonStr[0].ECF_TRIB == "T") {
                    $('#selectTribEcf').val(3);
                }
                if (jsonStr[0].ECF_TRIB == "S") {
                    $('#selectTribEcf').val(4);
                }

                if (jsonStr[0].POSSE == "0") {
                    $('#selectPosse').val(0);
                }
                if (jsonStr[0].POSSE == "1") {
                    $('#selectPosse').val(1);
                }
                if (jsonStr[0].POSSE == "2") {
                    $('#selectPosse').val(2);
                }

                try {
                    let responseEstilista = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"PESSOAL",
                "camposSelect":["CODIGO, NOME"],
                "where": ["CODIGO = '${jsonStr[0].ESTILISTA}'"]}`, null);

                    if (!responseEstilista) {
                        return;
                    }
                    let jsonStrEstilista = await responseEstilista.json();
                    if (responseEstilista.status != 200) {
                        msgErro(jsonStrEstilista.RESULT[0].mensagem);
                        return;
                    }
                    insereValor('#txtEstilista', jsonStr[0].ESTILISTA, jsonStrEstilista.RESULT[0][0].NOME);

                } catch (error) {
                    console.error(error);
                }

                try {
                    let responseModelista = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"PESSOAL",
                "camposSelect":["CODIGO, NOME"],
                "where": ["CODIGO = '${jsonStr[0].MODELISTA}'"]}`, null);

                    if (!responseModelista) {
                        return;
                    }
                    let jsonStrModelista = await responseModelista.json();
                    if (responseModelista.status != 200) {
                        msgErro(jsonStrModelista.RESULT[0].mensagem);
                        return;
                    }
                    insereValor('#txtModelista', jsonStr[0].MODELISTA, jsonStrModelista.RESULT[0][0].NOME);

                } catch (error) {
                    console.error(error);
                }

                try {
                    let responseEtiqueta = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"ETIQUETA",
                "camposSelect":["CODIGO", "PRODUTO"],
                "where": ["CODIGO = '${jsonStr[0].ETQ_COMPOSI}'"]}`, null);

                    if (!responseEtiqueta) {
                        return;
                    }
                    let jsonStrEtiqueta = await responseEtiqueta.json();
                    if (responseEtiqueta.status != 200) {
                        msgErro(jsonStrEtiqueta.RESULT[0].mensagem);
                        return;
                    }
                    insereValor('#txtSimbologia', jsonStr[0].ETQ_COMPOSI, jsonStrEtiqueta.RESULT[0][0].PRODUTO);

                } catch (error) {
                    console.error(error);
                }

                try {
                    let responseClasse = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"faixa",
                "camposSelect":["DESCRICAO"],
                "where": ["CODIGO = '${jsonStr[0].FAIXA}'"]}`, null);

                    if (!responseClasse) {
                        return;
                    }
                    let jsonStrClasse = await responseClasse.json();
                    if (responseClasse.status != 200) {
                        msgErro(jsonStrClasse.RESULT[0].mensagem);
                        return;
                    }
                    insereValor('#txtFaixaTam', jsonStr[0].FAIXA, jsonStrClasse.RESULT[0][0].DESCRICAO);

                } catch (error) {
                    console.error(error);
                }

                try {
                    let responseClasse = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"entidade",
                "camposSelect":["NOME"],
                "where": ["CODCLI = '${jsonStr[0].FORNECEDOR}'"]}`, null);

                    if (!responseClasse) {
                        return;
                    }
                    let jsonStrClasse = await responseClasse.json();
                    if (responseClasse.status != 200) {
                        msgErro(jsonStrClasse.RESULT[0].mensagem);
                        return;
                    }
                    insereValor('#txtCodFornec', jsonStr[0].FORNECEDOR, jsonStrClasse.RESULT[0][0].NOME);
                } catch (error) {
                    console.error(error);
                }

                try {
                    let responseClasse = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"GRUPO_PA",
                "camposSelect":["DESCRICAO"],
                "where": ["CODIGO = '${jsonStr[0].GRUPO}'"]}`, null);

                    if (!responseClasse) {
                        return;
                    }
                    let jsonStrClasse = await responseClasse.json();
                    if (responseClasse.status != 200) {
                        msgErro(jsonStrClasse.RESULT[0].mensagem);
                        return;
                    }
                    insereValor('#txtGrupo', jsonStr[0].GRUPO, jsonStrClasse.RESULT[0][0].DESCRICAO);
                } catch (error) {
                    console.error(error);
                }

                try {
                    let responseClasse = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"entidade",
                "camposSelect":["NOME"],
                "where": ["CODCLI = '${jsonStr[0].CODCLI}'"]}`, null);

                    if (!responseClasse) {
                        return;
                    }
                    let jsonStrClasse = await responseClasse.json();
                    if (responseClasse.status != 200) {
                        msgErro(jsonStrClasse.RESULT[0].mensagem);
                        return;
                    }
                    insereValor('#txtCodCliente', jsonStr[0].CODCLI, jsonStrClasse.RESULT[0][0].NOME);
                } catch (error) {
                    console.error(error);
                }

                try {
                    let responseClasse = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"SITPROD",
                "camposSelect":["DESCRICAO"],
                "where": ["CODIGO = '${jsonStr[0].STATUS}'"]}`, null);

                    if (!responseClasse) {
                        return;
                    }
                    let jsonStrClasse = await responseClasse.json();
                    if (responseClasse.status != 200) {
                        msgErro(jsonStrClasse.RESULT[0].mensagem);
                        return;
                    }
                    insereValor('#txtStatus', jsonStr[0].STATUS, jsonStrClasse.RESULT[0][0].DESCRICAO);
                } catch (error) {
                    console.error(error);
                }

                if (jsonStr[0].MARCA != '') {
                    try {
                        let responseClasse = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                            `JSON={ "tabela":"MARCA",
                "camposSelect":["DESCRICAO"],
                "where": ["CODIGO = '${jsonStr[0].MARCA}'"]}`, null);

                        if (!responseClasse) {
                            return;
                        }
                        let jsonStrClasse = await responseClasse.json();
                        if (responseClasse.status != 200) {
                            msgErro(jsonStrClasse.RESULT[0].mensagem);
                            return;
                        }
                        insereValor('#txtMarca', jsonStr[0].MARCA, jsonStrClasse.RESULT[0][0].DESCRICAO);
                    } catch (error) {
                        console.error(error);
                    }
                }

                try {
                    let responseClasse = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"COLECAO",
                "camposSelect":["DESCRICAO"],
                "where": ["CODIGO = '${jsonStr[0].COLECAO}'"]}`, null);

                    if (!responseClasse) {
                        return;
                    }
                    let jsonStrClasse = await responseClasse.json();
                    if (responseClasse.status != 200) {
                        msgErro(jsonStrClasse.RESULT[0].mensagem);
                        return;
                    }
                    insereValor('#txtColecao', jsonStr[0].COLECAO, jsonStrClasse.RESULT[0][0].DESCRICAO);
                } catch (error) {
                    console.error(error);
                }

                try {
                    let responseClasse = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"ETQ_PROD",
                "camposSelect":["DESCRICAO"],
                "where": ["CODIGO = '${jsonStr[0].ETIQUETA}'"]}`, null);

                    if (!responseClasse) {
                        return;
                    }
                    let jsonStrClasse = await responseClasse.json();
                    if (responseClasse.status != 200) {
                        msgErro(jsonStrClasse.RESULT[0].mensagem);
                        return;
                    }
                    insereValor('#txtEtiqueta', jsonStr[0].ETIQUETA, jsonStrClasse.RESULT[0][0].DESCRICAO);
                } catch (error) {
                    console.error(error);
                }

                try {
                    let responseClasse = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"TABLIN",
                "camposSelect":["DESCRICAO"],
                "where": ["CODIGO = '${jsonStr[0].LINHA}'"]}`, null);

                    if (!responseClasse) {
                        return;
                    }
                    let jsonStrClasse = await responseClasse.json();
                    if (responseClasse.status != 200) {
                        msgErro(jsonStrClasse.RESULT[0].mensagem);
                        return;
                    }
                    insereValor('#txtLinha', jsonStr[0].LINHA, jsonStrClasse.RESULT[0][0].DESCRICAO);
                } catch (error) {
                    console.error(error);
                }

                try {
                    let responseClasse = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"FAIXA_DESCONTO",
                "camposSelect":["DESCRICAO"],
                "where": ["CODIGO = '${jsonStr[0].FAIXA_DESCONTO}'"]}`, null);

                    if (!responseClasse) {
                        return;
                    }
                    let jsonStrClasse = await responseClasse.json();
                    if (responseClasse.status != 200) {
                        msgErro(jsonStrClasse.RESULT[0].mensagem);
                        return;
                    }
                    insereValor('#txtFaixaDesc', jsonStr[0].FAIXA_DESCONTO, jsonStrClasse.RESULT[0][0].DESCRICAO);
                } catch (error) {
                    console.error(error);
                }

                try {
                    let responseClasse = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"unidade",
                "camposSelect":["DESCRICAO"],
                "where": ["unidade = '${jsonStr[0].UNIDADE}'"]}`, null);

                    if (!responseClasse) {
                        return;
                    }
                    let jsonStrClasse = await responseClasse.json();
                    if (responseClasse.status != 200) {
                        msgErro(jsonStrClasse.RESULT[0].mensagem);
                        return;
                    }
                    insereValor('#txtUnidade', jsonStr[0].UNIDADE, jsonStrClasse.RESULT[0][0].DESCRICAO);
                } catch (error) {
                    console.error(error);
                }

                try {
                    let responseClasse = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"unidade",
                "camposSelect":["DESCRICAO"],
                "where": ["unidade = '${jsonStr[0].UNI_VENDA}'"]}`, null);

                    if (!responseClasse) {
                        return;
                    }
                    let jsonStrClasse = await responseClasse.json();
                    if (responseClasse.status != 200) {
                        msgErro(jsonStrClasse.RESULT[0].mensagem);
                        return;
                    }
                    insereValor('#txtUnidadeVenda', jsonStr[0].UNI_VENDA, jsonStrClasse.RESULT[0][0].DESCRICAO);
                } catch (error) {
                    console.error(error);
                }

                try {
                    let responseClasse = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"unidade",
                "camposSelect":["DESCRICAO"],
                "where": ["unidade = '${jsonStr[0].UNI_EXP}'"]}`, null);

                    if (!responseClasse) {
                        return;
                    }
                    let jsonStrClasse = await responseClasse.json();
                    if (responseClasse.status != 200) {
                        msgErro(jsonStrClasse.RESULT[0].mensagem);
                        return;
                    }
                    insereValor('#txtUnidadeExp', jsonStr[0].UNI_EXP, jsonStrClasse.RESULT[0][0].DESCRICAO);
                } catch (error) {
                    console.error(error);
                }

                try {
                    let responseClasse = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"tabfis",
                "camposSelect":["DESCRICAO"],
                "where": ["codigo = '${jsonStr[0].CODFIS}'"]}`, null);

                    if (!responseClasse) {
                        return;
                    }
                    let jsonStrClasse = await responseClasse.json();
                    if (responseClasse.status != 200) {
                        msgErro(jsonStrClasse.RESULT[0].mensagem);
                        return;
                    }
                    insereValor('#txtNcm', jsonStr[0].CODFIS, jsonStrClasse.RESULT[0][0].DESCRICAO);
                } catch (error) {
                    console.error(error);
                }

                try {
                    let responseClasse = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"TABTRI",
                "camposSelect":["DESCRICAO"],
                "where": ["codigo = '${jsonStr[0].CODTRIB}'"]}`, null);

                    if (!responseClasse) {
                        return;
                    }
                    let jsonStrClasse = await responseClasse.json();
                    if (responseClasse.status != 200) {
                        msgErro(jsonStrClasse.RESULT[0].mensagem);
                        return;
                    }
                    insereValor('#txtCstIcms', jsonStr[0].CODTRIB, jsonStrClasse.RESULT[0][0].DESCRICAO);
                } catch (error) {
                    console.error(error);
                }

                try {
                    let responseClasse = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"TABIPI",
                "camposSelect":["DESCRICAO"],
                "where": ["codigo = '${jsonStr[0].CODIPI}'"]}`, null);

                    if (!responseClasse) {
                        return;
                    }
                    let jsonStrClasse = await responseClasse.json();
                    if (responseClasse.status != 200) {
                        msgErro(jsonStrClasse.RESULT[0].mensagem);
                        return;
                    }
                    insereValor('#txtCstIpiSaida', jsonStr[0].CODIPI, jsonStrClasse.RESULT[0][0].DESCRICAO);
                } catch (error) {
                    console.error(error);
                }

                try {
                    let responseClasse = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"TABIPI",
                "camposSelect":["DESCRICAO"],
                "where": ["codigo = '${jsonStr[0].CODIPI_ENT}'"]}`, null);

                    if (!responseClasse) {
                        return;
                    }
                    let jsonStrClasse = await responseClasse.json();
                    if (responseClasse.status != 200) {
                        msgErro(jsonStrClasse.RESULT[0].mensagem);
                        return;
                    }
                    insereValor('#txtCstIpiEntrada', jsonStr[0].CODIPI_ENT, jsonStrClasse.RESULT[0][0].DESCRICAO);
                } catch (error) {
                    console.error(error);
                }

                try {
                    let responseClasse = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"TABSPED",
                "camposSelect":["DESCRICAO"],
                "where": ["codigo = '${jsonStr[0].CODSPED}'"]}`, null);

                    if (!responseClasse) {
                        return;
                    }
                    let jsonStrClasse = await responseClasse.json();
                    if (responseClasse.status != 200) {
                        msgErro(jsonStrClasse.RESULT[0].mensagem);
                        return;
                    }
                    insereValor('#txtSped', jsonStr[0].CODSPED, jsonStrClasse.RESULT[0][0].DESCRICAO);
                } catch (error) {
                    console.error(error);
                }

                try {
                    let responseClasse = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"NATUREZA",
                "camposSelect":["DESCRICAO"],
                "where": ["natureza = '${jsonStr[0].NATUREZA}'"]}`, null);

                    if (!responseClasse) {
                        return;
                    }
                    let jsonStrClasse = await responseClasse.json();
                    if (responseClasse.status != 200) {
                        msgErro(jsonStrClasse.RESULT[0].mensagem);
                        return;
                    }
                    insereValor('#txtNatureza', jsonStr[0].NATUREZA, jsonStrClasse.RESULT[0][0].DESCRICAO);
                } catch (error) {
                    console.error(error);
                }

                try {
                    let responseClasse = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"MODELO",
                "camposSelect":["DESCRICAO"],
                "where": ["codigo = '${jsonStr[0].MODELO}'"]}`, null);

                    if (!responseClasse) {
                        return;
                    }
                    let jsonStrClasse = await responseClasse.json();
                    if (responseClasse.status != 200) {
                        msgErro(jsonStrClasse.RESULT[0].mensagem);
                        return;
                    }
                    insereValor('#txtModelo', jsonStr[0].MODELO, jsonStrClasse.RESULT[0][0].DESCRICAO);
                } catch (error) {
                    console.error(error);
                }

                try {
                    let responseClasse = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"ENQUADRA",
                "camposSelect":["DESCRICAO"],
                "where": ["codigo = '${jsonStr[0]?.ENQUADRA}'"]}`, null);

                    if (!responseClasse) {
                        return;
                    }
                    let jsonStrClasse = await responseClasse.json();
                    if (responseClasse.status != 200) {
                        msgErro(jsonStrClasse.RESULT[0]?.mensagem);
                        return;
                    }
                    insereValor('#txtEnqIpi', jsonStr[0]?.ENQUADRA, jsonStrClasse?.RESULT[0][0]?.DESCRICAO);
                } catch (error) {
                    console.error(error);
                }

                try {
                    let responseCategoria = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"AUXILIAR",
                "camposSelect":["DESCRICAO"],
                "where": ["ID = ${jsonStr[0].CATEGORIA}"]}`, null);

                    if (!responseCategoria) {
                        return;
                    }
                    let jsonStrCategoria = await responseCategoria.json();
                    if (responseCategoria.status != 200) {
                        msgErro(jsonStrCategoria.RESULT[0].mensagem);
                        return;
                    }
                    insereValor('#txtCategoria', jsonStr[0].CATEGORIA, jsonStrCategoria.RESULT[0][0].DESCRICAO);
                } catch (error) {
                    console.error(error);
                }

                try {
                    insereValor('#txtTipoProduto', jsonStr[0]?.TIPO, { tabela: 'CAD_TIPO_PROD', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: jsonStr[0]?.TIPO })
                } catch (error) {
                    console.error(error)
                }

                try {
                    let response = await requisicao('GET', '/sisplan/funcoes/v1/pesquisa?', `JSON={
                        "tabela":"PA_ITEN",
                        "camposSelect":["CADCOR.COR", "CADCOR.DESCRICAO", "CADCOR.CODIGO2", "PA_ITEN.ATIVO", "PA_ITEN.STATUS", "SITPROD.DESCRICAO DESC_STATUS"],
                        "innerJoin": [{"tabela": "CADCOR", "condicao": "PA_ITEN.COR = CADCOR.COR"}],
                        "leftJoin": [{"tabela": "SITPROD", "condicao": "SITPROD.CODIGO = PA_ITEN.STATUS"}],
                        "where": ["PA_ITEN.CODIGO = '${produto}'"]
                    }`, null);

                    if (!response) {
                        return;
                    }

                    let jsonStr = await response.json();
                    if (response.status != 200) {
                        msgErro(jsonStr.RESULT[0].mensagem);
                        return;
                    }

                    let listaCond = jsonStr;
                    let controlador = [];
                    for (let i = 0; i < listaCond.RESULT[0].length; i++) {
                        if (controlador.includes(listaCond.RESULT[0][i].COR) == false) {
                            controlador.push(listaCond.RESULT[0][i].COR);

                            let chave = produto + ` / ` + listaCond.RESULT[0][i].COR;
                            let tela = 'PRODUTO';

                            const pesquisaParam = {
                                tabela: "ANEXO",
                                camposSelect: [
                                    "ANEXO.TELA",
                                    "ANEXO.ARQUIVO",
                                    "ANEXO.DESCRICAO",
                                    "ANEXO.DATA",
                                    "ANEXO.CAMPO_CHAVE",
                                    "ANEXO.ORDEM",
                                    "ANEXO.DT_VALIDADE",
                                    "ANEXO.USUARIO",
                                    "USUARIO.NOME"
                                ],
                                leftJoin: [
                                    { tabela: 'ACESSO_USUARIOS', alias: "USUARIO", condicao: 'USUARIO.CODIGO = ANEXO.USUARIO' },
                                ],
                                where: [`CAMPO_CHAVE = '${chave}' AND TELA='${tela}' AND EMP_PAT='${getCookie('g_empresa_logada')}'`]
                            };

                            let imgSrc;

                            const jsonStr = await retornaJsonPesquisaPadrao(encodeURIComponent(JSON.stringify(pesquisaParam)));
                            if (jsonStr.length !== 0) {
                                let foto = jsonStr[0].ARQUIVO;
                                let url = '/Sisplan/Funcoes/v1/AnexoArquivo?';
                                let responseImg = await requisicao('GET', url, `ARQUIVO=${foto}&TELA=${tela}&CHAVE=${encodeURIComponent(chave)}&EMP_PAT=${getCookie('g_empresa_logada')}`, null);

                                if (responseImg) {
                                    let jsonStrImg = await responseImg.json();
                                    if (responseImg.status == 200 && jsonStrImg.codigo == 200) {
                                        let sBase64 = jsonStrImg.mensagem;
                                        imgSrc = `data:image/png;base64,${sBase64}`;
                                    }
                                }
                            } else {
                                imgSrc = `${BASE_URI}/dist/img/fotoProdPadrao.png`; // Imagem padrão
                            }

                            $('#tabelaFaixaCor').DataTable().row.add([
                                listaCond.RESULT[0][i].COR,
                                listaCond.RESULT[0][i].CODIGO2,
                                listaCond.RESULT[0][i].DESCRICAO,
                                listaCond.RESULT[0][i].ATIVO,
                                listaCond.RESULT[0][i].STATUS,
                                listaCond.RESULT[0][i].DESC_STATUS,
                                '<div class="divBtn-Opcoes p-0">' +
                                `   <img class="imagemAnexoCor" src="${imgSrc}" alt="Imagem de anexo a esta cor" title="Imagem de anexo a esta cor" style="width: 50px; height: 50px; cursor: pointer;">` +
                                '</div>'
                            ]).draw(false);
                        }
                    }

                    // Abrir o modal com a imagem da cor
                    $("#tabelaFaixaCor").on('click', '.imagemAnexoCor', function () {
                        let imgSrc = $(this).attr('src');
                        if (imgSrc.includes('fotoProdPadrao.png')) {
                            msgErro('Essa cor não possui foto cadastrada!');
                        } else {
                            $("#infoAnexoImagem").attr('src', imgSrc);
                            $('#imagemodal').modal('show');
                        }
                    });

                } catch (error) {
                    console.error(error);
                    msgErro(`Não foi possível buscar os dados da região: ${error}`);
                }

                try {


                    let responseProdInf = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"PROD_INFO", 
                    "camposSelect":["PROD_INFO.ETIQUETA", "ETIQUETA.PRODUTO"], 
                    "leftJoin":[{"tabela": "ETIQUETA", "condicao": "ETIQUETA.CODIGO = PROD_INFO.ETIQUETA"}],
                    "where": ["PROD_INFO.CODIGO = '${produto}'"]}`, null);

                    if (!responseProdInf) {
                        return;
                    }
                    let jsonProdInf = await responseProdInf.json();
                    if (responseProdInf.status != 200) {
                        msgErro(jsonProdInf.RESULT[0].mensagem);
                        return;
                    }
                    if (jsonProdInf.RESULT[0][0].CODIGO !== '') {
                        await insereValorPesquisaVarios('txtCuidado', 'ETIQUETA', 'PRODUTO', jsonProdInf.RESULT[0])
                    }
                } catch (error) {
                    console.error(error);
                }

                try {
                    response = await requisicao('GET', '/sisplan/funcoes/v1/pesquisa?', `JSON={
                "tabela":"TPVENDA_REGRA",
                "camposSelect":["TPVENDA_REGRA.TIPO_VENDA", "replace(TPVENDA_REGRA.EMPRESA, '_', '') as EMPRESA", "TPVENDA_REGRA.COD_REGRA", "REGRA.DESCRICAO", "TPVENDA_REGRA.TRIBUTACAO", "TPVENDA_REGRA.CODSPED"],
                "leftJoin": [{"tabela": "REGRA",
                "condicao": "TPVENDA_REGRA.COD_REGRA = REGRA.CODIGO"}],
                "where": ["TPVENDA_REGRA.CODIGO = '${produto}'"]}`, null);

                    if (!response) {
                        return;
                    }
                    jsonStr = await response.json();
                    if (response.status != 200) {
                        msgErro(jsonStr.RESULT[0].mensagem);
                        return;
                    }
                    let listaCond = jsonStr;
                    for (let i = 0; i < listaCond.RESULT[0].length; i++) {
                        $('#tabelaVendaRegra').DataTable().row.add([
                            listaCond.RESULT[0][i].TIPO_VENDA,
                            listaCond.RESULT[0][i].EMPRESA,
                            listaCond.RESULT[0][i].COD_REGRA,
                            listaCond.RESULT[0][i].DESCRICAO,
                            listaCond.RESULT[0][i].TRIBUTACAO,
                            listaCond.RESULT[0][i].CODSPED,
                            '<div style="text-align:center;"> ' +
                            '   <button class="btn btn-info btn-sm" id="btnExluirCond" type="button"> ' +
                            '      Excluir' +
                            '   </button> ' +
                            '</div>'
                        ]).draw(false);
                    }
                } catch (error) {
                    console.error(error);
                    msgErro(`Não foi possível buscar os dados da região: ${error}`);
                }

                try {
                    let responseEcommerce = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"PROD_ECOM",
                "camposSelect":["TELEVENDAS"],
                "where": ["CODIGO = '${produto}'"]}`, null);

                    if (!responseEcommerce) {
                        return;
                    }
                    let jsonStrEcommerce = await responseEcommerce.json();
                    if (responseEcommerce.status != 200) {
                        msgErro(jsonStrEcommerce.RESULT[0].mensagem);
                        return;
                    }

                    $('#checkTelevendas').prop('checked', jsonStrEcommerce.RESULT[0][0].TELEVENDAS == 'S')

                } catch (error) {
                    console.error(error);
                }

                try {
                    let responseEcomCor = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"PA_ITEN",
                "camposSelect":["PA_ITEN.COR", "PROD_ECOM_COR.ATIVO", "CADCOR.DESCRICAO"],
                "leftjoin": [{ "tabela": "PROD_ECOM_COR", "condicao": "PROD_ECOM_COR.CODIGO = PA_ITEN.CODIGO AND  PROD_ECOM_COR.COR = PA_ITEN.COR"},
                            { "tabela": "CADCOR", "condicao": "CADCOR.COR = PA_ITEN.COR"}],
                "where": ["PA_ITEN.CODIGO = '${produto}'"],
                "groupby": ["PA_ITEN.COR", "PROD_ECOM_COR.ATIVO", "CADCOR.DESCRICAO"]}`, null);

                    if (!responseEcomCor) {
                        return;
                    }
                    let jsonStrEcomCor = await responseEcomCor.json();
                    if (responseEcomCor.status != 200) {
                        msgErro(jsonStrEcomCor.RESULT[0].mensagem);
                        return;
                    }

                    let listaEcom = jsonStrEcomCor;
                    for (let i = 0; i < listaEcom.RESULT[0].length; i++) {
                        $('#tabelaEcomCor').DataTable().row.add([
                            listaEcom.RESULT[0][i].ATIVO,
                            listaEcom.RESULT[0][i].COR,
                            listaEcom.RESULT[0][i].DESCRICAO
                        ]).draw(false);
                    }

                } catch (error) {
                    console.error(error);
                }

            } catch (error) {
                console.error(error);
                msgErro(`Não foi possível buscar os dados da região: ${error}`);
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    }
    else {
        await carregaValoresPadroes();
    };

    async function carregaValoresPadroes() {
        const objTpVenda = {
            tributacao: '',
            regra: '',
            descRegra: '',
            sped: '',
            tpVenda: '',
        }
        const jsonStr = await buscaValoresPadroes('PRODUTO')

        jsonStr.map(async item => {
            switch (item.CAMPO) {
                case 'UNIDADE': {
                    insereValor('#txtUnidade', item.VALOR, { tabela: 'UNIDADE', campoBusca: 'DESCRICAO', campoWhere: 'UNIDADE', valorWhere: item.VALOR });
                    break;
                }
                case 'UNI_VENDA': {
                    insereValor('#txtUnidadeVenda', item.VALOR, { tabela: 'UNIDADE', campoBusca: 'DESCRICAO', campoWhere: 'UNIDADE', valorWhere: item.VALOR });
                    break;
                }
                case 'CODFIS': {
                    insereValor('#txtNcm', item.VALOR, { tabela: 'TABFIS', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR });
                    break;
                }
                case 'ICMS': {
                    insereValor('#txtIcms', item.VALOR);
                    break;
                }
                case 'CODTRIB': {
                    insereValor('#txtCstIcms', item.VALOR, { tabela: 'TABTRI', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR });
                    break;
                }
                case 'CODIPI': {
                    insereValor('#txtCstIpiSaida', item.VALOR, { tabela: 'TABIPI', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR });
                    break;
                }
                case 'CODIPI_ENT': {
                    insereValor('#txtCstIpiEntrada', item.VALOR, { tabela: 'TABIPI', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR });
                    break;
                }
                case 'IPI': {
                    insereValor('#txtIpi', item.VALOR);
                    break;
                }
                case 'STATUS': {
                    insereValor('#txtStatus', item.VALOR, { tabela: 'SITPROD', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR });
                    break;
                }
                case 'TRIBUTACAO': {
                    objTpVenda.tributacao = item.VALOR
                    $('#selectTrib').val(item.VALOR).change();
                    break;
                }
                case 'SPED': {
                    objTpVenda.sped = item.VALOR
                    insereValor('#txtSped', item.VALOR, { tabela: 'TABSPED', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR });
                    break;
                }
                case 'REGRA': {
                    objTpVenda.regra = item.VALOR
                    insereValor('#txtRegra', item.VALOR, { tabela: 'REGRA', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR });
                    break;
                }
                case 'TIPO_VENDA': {
                    objTpVenda.tpVenda = item.VALOR
                    if (item.VALOR != '' && item.VALOR != undefined && item.VALOR != null) {
                        tipoVendaPadrao = item.VALOR;
                    };
                    break;
                }
                case 'GRUPO_PRODUTO': {
                    insereValor('#txtGrupo', item.VALOR, { tabela: 'GRUPO_PA', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR });
                    break;
                }
                case 'ECF_TRIB': {
                    $('#selectTribEcf').val(item.VALOR).change();
                    break;
                }
                case 'NATUREZA': {
                    insereValor('#txtNatureza', item.VALOR, { tabela: 'NATUREZA', campoBusca: 'DESCRICAO', campoWhere: 'NATUREZA', valorWhere: item.VALOR });
                    break;
                }
                case 'ETIQUETA': {
                    insereValor('#txtEtiqueta', item.VALOR, { tabela: 'ETQ_PROD', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR });
                    break;
                }
                case 'LINHA': {
                    insereValor('#txtLinha', item.VALOR, { tabela: 'TABLIN', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR });
                    break;
                }
                case 'COLECAO': {
                    insereValor('#txtColecao', item.VALOR, { tabela: 'COLECAO', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR });
                    break;
                }
                case 'POSSE': {
                    $('#selectPosse').val(item.VALOR).change();
                    break;
                }
                case 'MARCA': {
                    insereValor('#txtMarca', item.VALOR, { tabela: 'MARCA', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR });
                    break;
                }
                case 'COR': {
                    if (item.VALOR != '' && item.VALOR != undefined && item.VALOR != null) {
                        const existeCor = await verificaSeCorExiste(item.VALOR);
                        if (existeCor) {
                            buscaValor('CADCOR', 'DESCRICAO', 'COR', item.VALOR).then((result) => {
                                insereValor('#txtCondPagto', item.VALOR, result.DESCRICAO);
                                addValorCond()
                            })
                            break;
                        } else {
                            break;
                        }
                    } else {
                        break;
                    }
                }
                case 'FAIXA_TAMANHO': {
                    if (item.VALOR != '' && item.VALOR != undefined && item.VALOR != null) {
                        const existeFaixa = await verificaSeFaixaExiste(item.VALOR);
                        if (existeFaixa) {
                            insereValor('#txtFaixaTam', item.VALOR, { tabela: 'FAIXA', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR });
                            break;
                        } else {
                            break;
                        }
                    } else {
                        break;
                    }
                }
            }
        });

        if (objTpVenda.tributacao != '' && objTpVenda.sped != '' && objTpVenda.tpVenda != '') {
            await preenhceTpVendaPadrao(objTpVenda)
        }

        const codigo = await RetornaProximo('PRODUTO', 'PRODUTO', 'CODIGO', 6);
        novoCodigoProduto = codigo
        $('#txtCodigo').val(codigo);
        $('#txtCodigo').focus();
    };

    $('#modalAdicionarVendaRegra').on('shown.bs.modal', async function () {
        if (tipoVendaPadrao != '') {
            $('#txtTipoVenda').val(tipoVendaPadrao);
        }
    });

    await buscaFotoMontagem(produto, 0);

    $('#txtCodigo').on('focusout', async function () {
        if ($(this).val() != '') {
            await baixaCodigo('PRODUTO', 'CODIGO', novoCodigoProduto)
            novoCodigoProduto = this.value
            const bProduto = await Existe('PRODUTO', ['CODIGO'], [$(this).val()]);
            const bMaterial = await Existe('MATERIAL', ['CODIGO'], [$(this).val()]);
            const bServico = await Existe('SERVICO', ['CODIGO'], [$(this).val()]);
            if (bProduto || bMaterial || bServico) {
                const tabela = bProduto ? 'produto' : bMaterial ? 'material' : bServico ? 'serviço' : '';
                msgAlerta(`Já existe um ${tabela} cadastrado com o código ${$(this).val()}, necessário informar outro código.`);
                $(this).val('');
                $(this).focus();
            } else {
                $('#txtCodigo').prop('disabled', true);
                $('#txtCodigo').prop('readonly', true);
            }
        } else {
            if (novoCodigoProduto) {
                baixaCodigo('PRODUTO', 'CODIGO', novoCodigoProduto).then(() => {
                    RetornaProximo('PRODUTO', 'PRODUTO', 'CODIGO', 6).then((codigo) => {
                        novoCodigoProduto = codigo
                        $('#txtCodigo').val(novoCodigoProduto)
                    })
                })
                return
            }
            novoCodigoProduto = await RetornaProximo('PRODUTO', 'PRODUTO', 'CODIGO', 6)
            $('#txtCodigo').val(novoCodigoProduto)
        }
    });

    $('#txtCodigo').on('input', function () {
        const valor = $(this).val();
        $(this).val(valor.replace(/[\\/:*?"<>|,']/g, ''));
    });

    $('#btnAlterarObsMontagem').on('click', function () {
        $.LoadingOverlay('show');
        try {
            $('#modal-obsmontagem').modal('show');
            $('#txtIdObsMontagem').val('0');
        } finally {
            $.LoadingOverlay('hide');
        }
    });

    await buscaObsMontagem();

    async function buscaObsMontagem() {
        try {
            const pesquisa = {
                tabela: "OBS_MONT_PROD",
                leftjoin: [{ tabela: "CADFLUXO", condicao: "OBS_MONT_PROD.SETOR = CADFLUXO.CODIGO" },
                { tabela: "CADCOR", condicao: "OBS_MONT_PROD.COR = CADCOR.COR" }],
                camposSelect: ["OBS_MONT_PROD.ORDEM", "OBS_MONT_PROD.DATA", "OBS_MONT_PROD.SETOR", "CADFLUXO.DESCRICAO DESC_SETOR", "OBS_MONT_PROD.COR", "CADCOR.DESCRICAO DESC_COR", "OBS_MONT_PROD.OBS", "OBS_MONT_PROD.ID"],
                where: [`1=1 AND OBS_MONT_PROD.CODIGO = '${produto}'`]
            };

            const dados = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

            if (!dados) {
                return;
            }

            dados.forEach((e) => {
                e.OBS = removeFormatacao(e.OBS);
            })

            criaTabelaObsMontagem(dados);
        } finally {
        }
    }

    function criaTabelaObsMontagem(dados = []) {

        function retornaOpcoes(sChave) {

            return '<div style="text-align:start;"> ' +
                '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
                '      ' + sChave + ' ' +
                '    </button> ' +
                '    <div class="dropdown-menu"> ' +
                '       <button class="dropdown-item" id="btn-alterar-obsmontagem">Alterar</button>  ' +
                '       <button class="dropdown-item" id="btn-excluir-obsmontagem">Excluir</button>  ' +
                '</div>';
        };

        try {

            if ($.fn.DataTable.isDataTable('#tabelaObsMontagem')) {
                $('#tabelaObsMontagem').DataTable().destroy();
                $('#tabelaObsMontagem').empty();
            };

            const dataSetCols = [
                {
                    data: 'ORDEM',
                    title: 'Ordem'
                },
                {
                    data: 'DATA',
                    title: 'Data'
                },
                {
                    data: 'SETOR',
                    title: 'Setor'
                },
                {
                    data: 'DESC_SETOR',
                    title: 'Desc. Setor'
                },
                {
                    data: 'COR',
                    title: 'Cor'
                },
                {
                    data: 'DESC_COR',
                    title: 'Desc. Cor'
                },
                {
                    data: 'OBS',
                    title: 'Obs1'
                },
                {
                    data: 'ID',
                    title: 'Id'
                }
            ];

            $('#tabelaObsMontagem').DataTable({
                bPaginate: false,
                destroy: true,
                search: false,
                filter: false,
                lengthChange: false,
                pageLength: 5,
                info: true,
                ordering: [1],
                autoWidth: true,
                columns: dataSetCols,
                data: dados,
                columnDefs: [
                    {
                        targets: [7],
                        visible: false
                    },
                    {
                        type: 'date-br',
                        targets: [1],
                        render(data) {
                            if (data === '1899-12-30') {
                                return '';
                            } else if (data) {
                                return new Intl.DateTimeFormat('pt-BR').format(new Date(`${data.split(' ')[0]} 23:59:59`));
                            } else {
                                return '';
                            }
                        }
                    },
                    {
                        targets: [0],
                        render: function (data) {
                            return retornaOpcoes(data);
                        }
                    }]
            });

        } catch (e) {

        }
    }

    $('#tabelaObsMontagem').on('click', '#btn-alterar-obsmontagem', function (e) {
        e.preventDefault();
        $.LoadingOverlay('show');
        try {
            if ($('#tabelaObsMontagem').DataTable().data().length > 0) {
                const id = $('#tabelaObsMontagem').DataTable().row($(this).parents('tr')).data().ID;
                if (id == undefined) {
                    return;
                }
                $('#txtIdObsMontagem').val(id);
                $('#tabelaObsMontagem').DataTable().$('tr.selected').removeClass('selected');
                // $(this).parents('tr').addClass('selected');
                $('#modal-obsmontagem').modal('show');
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    });

    $('#tabelaObsMontagem').on('click', '#btn-excluir-obsmontagem', function (e) {
        e.preventDefault();
        msgAlerta('Deseja realmente excluir este registro?', async () => { }, async () => { }, async () => { await excluiObsMontagem($('#tabelaObsMontagem').DataTable().row($(this).parents('tr')).data()) });
    })

    $('#modal-obsmontagem').on('hide.bs.modal', async function () {
        await buscaObsMontagem();
        $('#editor .ql-editor').html('');
        $('#fileimagem2').val('');
        $("#imgobsmontagem").attr('src', `${BASE_URI}/dist/img/prod-1.png`);
    })

    $('#tabelaObsMontagem').on('click', 'tr', async function () {
        if (!$(this).hasClass('selected')) {
            $('#tabelaObsMontagem tr.selected').removeClass('selected');
            $.LoadingOverlay('show');
            try {
                $(this).addClass('selected');
                let data = $('#tabelaObsMontagem').DataTable().row($(this)).data();
                await buscaInfoObsMontagem(produto, data.ID);
                await buscaFotoMontagem(produto, data.ORDEM);
            } finally {
                $.LoadingOverlay('hide');
            }
        }
    });

    $('#btnVoltar').on('click', async function () {
        $.LoadingOverlay('show')
        const valorInputCodigo = pegaValor('#txtCodigo')
        const timeout = valorInputCodigo ? 0 : 1500
        setTimeout(async () => {
            const sProduto = $(window.location.href.split('/')).get(-1);
            const sCodigo = novoCodigoProduto ?? valorInputCodigo;
            if (sProduto == 'create' && sCodigo != '') {
                await baixaCodigo('PRODUTO', 'CODIGO', sCodigo);
            }
            await deletaRegistro('PRODUTO', getCookie('usuario'), sProduto);
            $.LoadingOverlay('hide')
            window.location.href = `${BASE_URI}/produto`;
        }, timeout)
    });

    async function buscaInfoObsMontagem(codigo, id) {
        try {
            const result = await buscaValor('OBS_MONT_PROD', 'OBS', `CODIGO = '${codigo}' AND ID`, id);

            const html = formataHtml(result.OBS);

            $('#editor .ql-editor').html(html);
        } catch (e) {
            console.log(e);
        }
    }

    async function excluiObsMontagem(data) {
        $.LoadingOverlay('show');
        try {
            try {
                let response = await requisicao("DELETE", `/Sisplan/Cadastros/V1/obsmontagem?`, `ID=${data.ID}&CODIGO=${produto}&ORDEM=${data.ORDEM}`, null);

                if (!response) {
                    return;
                }

                let jsonStr = await response.json();
                if (response.status != 200) {
                    msgAlerta(jsonStr.mensagem);
                    return;
                }

                toastr
                    .success("Registro excluído com sucesso!", "Confirmação", {
                        toastClass: "alert",
                        iconClasses: {
                            error: "alert-error",
                            info: "alert-info",
                            success: "alert-success",
                            warning: "alert-warning",
                        },
                        positionClass: "toast-top-center",
                        progressBar: true,
                        timeOut: 3000,
                        fadeOut: 1000,
                        async onHidden() {
                            await buscaObsMontagem();
                            $('#editor .ql-editor').html('');
                        },
                    })
                    .css({
                        "margin-top": "20%",
                        width: "500px",
                        "max-width": "500px",
                    });
            } catch (e) {
                msgErro(`Não foi possível excluir o registro: ${e}`);
                console.log(e);
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    }

    async function buscaFotoMontagem(codigo, ordem) {
        try {

            function convertToJPEG(base64String) {
                return new Promise((resolve, reject) => {
                    const img = new Image();
                    img.onload = function () {
                        const canvas = document.createElement('canvas');
                        canvas.width = img.width;
                        canvas.height = img.height;
                        const ctx = canvas.getContext('2d');
                        ctx.drawImage(img, 0, 0);
                        const jpegDataURL = canvas.toDataURL('image/jpeg');
                        resolve(jpegDataURL);
                    };
                    img.src = base64String;
                });
            }

            $('#fileimagem2').val('');

            let diretorio = await buscaCaminhoFoto();

            let urlRequisicao = '/Sisplan/Funcoes/v1/fotogenerica?';
            let response = await requisicao('GET', urlRequisicao, `DIRETORIO=${diretorio + '\\OBSMONTAGEM'}&ARQUIVO=${(codigo.toString()) + (ordem.toString())}`, null);

            if (!response) {
                return;
            }
            let jsonStr = await response.json();
            if (response.status !== 200) {
                $("#imgobsmontagem").attr('src', `${BASE_URI}/dist/img/prod-1.png`);
                return;
            }

            let sBase64 = jsonStr.mensagem;

            if (sBase64 == '') {
                $("#imgobsmontagem").attr('src', `${BASE_URI}/dist/img/prod-1.png`);
                return;
            }

            let extension = "png";
            let contentType = response.headers.get('content-type');
            if (contentType && contentType.indexOf('image/') === 0) {
                extension = contentType.replace('image/', '');
            }

            if (extension === "png") {
                $("#imgobsmontagem").attr('src', `data:image/png;base64,${sBase64}`);
            } else {
                let jpegBase64 = await convertToJPEG(sBase64);
                $("#imgobsmontagem").attr('src', `data:image/jpg;base64,${jpegBase64}`);
            }

        } catch (error) {
            console.error(error);
            $("#imgobsmontagem").attr('src', `${BASE_URI}/dist/img/prod-1.png`);
        }
    }

    async function gravaFotoMontagem(codigo) {
        try {

            let ordem = $('#tabelaObsMontagem').DataTable().row('.selected').data().ORDEM;

            if (ordem == undefined) {
                throw ('');
            }

            let file = document.querySelector('input[id=fileimagem2]').files[0];
            let reader = new FileReader();
            let baseString;
            reader.onloadend = function () {
                baseString = reader.result;
            };
            reader.readAsDataURL(file);

            function convertToJPEG(base64String) {
                return new Promise((resolve, reject) => {
                    const img = new Image();
                    img.onload = function () {
                        const canvas = document.createElement('canvas');
                        canvas.width = img.width;
                        canvas.height = img.height;
                        const ctx = canvas.getContext('2d');
                        ctx.drawImage(img, 0, 0);
                        const jpegDataURL = canvas.toDataURL('image/jpeg');
                        resolve(jpegDataURL);
                    };
                    img.src = base64String;
                });
            }

            await new Promise((resolve) => setTimeout(resolve, 100));
            baseString = await convertToJPEG(baseString);

            const pastaFoto = (await buscaCaminhoFoto()) + '\\OBSMONTAGEM';

            if (pastaFoto == '\\OBSMONTAGEM') {
                msgAlerta('Diretório da Pasta fotos não informado na apiWeb, entre em contato com o Suporte da Sisplan.');
                return;
            }

            response = await requisicao(
                'POST',
                '/sisplan/funcoes/v1/FotoItem?',
                `PDIRETORIOSALVAR=${pastaFoto}&NOMEARQUIVO=${(codigo.toString()) + (ordem.toString())}.${file.name.split('.').pop()}`,
                `SBASE64=${encodeURIComponent(baseString)}`
            );

            const jsonStr = await response.json();

            if (jsonStr?.codigo != 200) {
                msgAlerta(jsonStr?.mensagem);
                return;
            }

            await buscaFotoMontagem(codigo, ordem);

        } catch (error) {
            msgErro(`Não foi possível gravar a imagem: ${error}`)
            console.error(error);
        }
    }

    $('#fileimagem2').on('click', function (e) {
        if ($('#tabelaObsMontagem').DataTable().row('.selected').length == 0) {
            e.preventDefault();
            msgErro('Nenhum registro selecionado na tabela, necessário selecionar ou incluir um novo registro no botão "Incluir/Alterar Obs".');
            return;
        }
    })

    $('#fileimagem2').change(async function () {

        try {
            $.LoadingOverlay("show");
            const leitorDeArquivos = new FileReader();
            const previaDaImagem = document.querySelector('.imagem2');
            const inputArquivo = document.querySelector('.upload2');

            let imagemEnviada = inputArquivo.files[0];
            leitorDeArquivos.readAsDataURL(imagemEnviada);
            leitorDeArquivos.addEventListener('loadend', async function (load) {
                previaDaImagem.src = load.target.result;
            });

            await gravaFotoMontagem(produto);

        } finally {
            $.LoadingOverlay('hide');
        }
    });

    async function buscaCaminhoFoto() {
        const caminhoFoto = await requisicao('GET', '/sisplan/funcoes/v1/caminhofoto?', null);
        if (!caminhoFoto) {
            return;
        };

        if (caminhoFoto.status != 200) {
            return;
        };

        jsonStr = await caminhoFoto.json();
        return jsonStr.mensagem;
    }

    $('#btnExcluirFotoMontagem').on('click', async function () {
        try {
            const data = $('#tabelaObsMontagem').DataTable().row('.selected').data();
            if (data.length == 0) {
                msgErro('Nenhum registro selecionado. Impossível continuar.');
                return;
            }
            $.LoadingOverlay('show');

            msgAlerta('Deseja realmente excluir essa foto?', () => { }, () => { }, async () => { $.LoadingOverlay('show'); await excluiFotoMontagem(produto, data.ORDEM); $.LoadingOverlay('hide'); });
        } finally {
            $.LoadingOverlay('hide');
        }
    })

    async function excluiFotoMontagem(codigo, ordem) {
        try {

            let diretorio = await buscaCaminhoFoto();

            let urlRequisicao = '/Sisplan/Funcoes/v1/fotogenerica?';
            let response = await requisicao('DELETE', urlRequisicao, `DIRETORIO=${diretorio + '\\OBSMONTAGEM'}&ARQUIVO=${(codigo.toString()) + (ordem.toString())}`, null);

            if (!response) {
                return;
            }
            let jsonStr = await response.json();
            if (response.status !== 200) {
                $("#imgobsmontagem").attr('src', `${BASE_URI}/dist/img/prod-1.png`);
                return;
            }

            await buscaFotoMontagem(codigo, ordem);
        } catch (e) {
            msgErro(`Não foi possível excluir a foto: ${e}`);
            console.log(e);
        }
    }

    $("#gravar").click(

        async function () {

            if ($('#tabelaFaixaCor').DataTable().rows().count() < 1) {
                msgAlerta('Insira pelo menos uma cor ao produto.');
                return;
            }

            let validaFaixa = true;
            let adicionarTamanhos = [];

            const existeProduto = produto != 'create';

            if (existeProduto) {
                adicionarTamanhos.push('true');
            }

            $('#multiCollapseExample2').collapse('show');
            jQuery.validator.addMethod("validarCaracteres", function (value) {
                return validarCaracteres(value) === 0;
            });

            $('#txtDescricaoProduto').on('input', function () {
                if (validarCaracteres($("#txtDescricaoProduto").val()) > 0) {
                    $("#txtDescricaoProduto").rules("add", "validarCaracteres");
                    $("#txtDescricaoProduto").focus();
                }
            });

            let validator = $("#msform").validate();
            validator.form();
            let erros = 0;
            erros = validator.numberOfInvalids();

            if (erros == 0) {

                try {
                    let faixaAntiga = '';
                    if (existeProduto) {

                        responseClasse = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                            `JSON={ "tabela": "produto",
                                "camposSelect":["faixa_iten.TAMANHO"],
                                "leftJoin": [{"tabela": "faixa_iten",
                                "condicao": "produto.faixa = faixa_iten.faixa"}],
                                "where":["produto.CODIGO = '${$('#txtCodigo').val()}'"]}`, null);
                        jsonStr = await responseClasse.json();

                        faixaAntiga = jsonStr.RESULT[0];
                    }

                    let novaFaixaCodigo = pegaChave('#txtFaixaTam');

                    responseClasse = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela": "faixa_iten",
                            "camposSelect":["TAMANHO"],
                            "where":["faixa = '${novaFaixaCodigo}'"]}`, null);
                    jsonStr = await responseClasse.json();

                    let novaFaixa = jsonStr.RESULT[0];

                    let listaNovaFaixa = [];
                    for (let i = 0; i < novaFaixa.length; i++) {
                        listaNovaFaixa.push(novaFaixa[i].TAMANHO);
                    }

                    for (let i = 0; i < faixaAntiga.length; i++) {
                        if (jQuery.inArray(faixaAntiga[i].TAMANHO, listaNovaFaixa) == -1) {
                            validaFaixa = false;
                        }
                    }

                    if (validaFaixa == false) {
                        msgAlerta('Verifique a nova faixa de tamanho informada, ela não contém os tamanhos da anterior. Campo preenchido com a faixa anterior do produto.');

                        responseClasse = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                            `JSON={ "tabela": "produto",
                            "camposSelect":["faixa.codigo", "faixa.descricao"],
                            "leftJoin": [{"tabela": "faixa",
                            "condicao": "produto.faixa = faixa.codigo"}],
                            "where":["produto.CODIGO = '${$('#txtCodigo').val()}'"]}`, null);
                        jsonStr = await responseClasse.json();
                        insereValor('#txtFaixaTam', jsonStr.RESULT[0][0].CODIGO, jsonStr.RESULT[0][0].DESCRICAO);
                    } else {
                        let listaTamanhosAntigos = [];
                        for (let i = 0; i < faixaAntiga.length; i++) {
                            listaTamanhosAntigos.push(faixaAntiga[i].TAMANHO);
                        }
                        for (let i = 0; i < listaNovaFaixa.length; i++) {
                            adicionarTamanhos.push(listaNovaFaixa[i]);
                        }
                    }

                } catch (error) {
                    console.error(error);
                }

                if (validaFaixa) {

                    try {
                        $.LoadingOverlay("show");

                        try {
                            produto = $('#txtCodigo').val();
                            let file = $('input[type=file]')[0].files[0];
                            let reader = new FileReader();
                            let baseString;
                            reader.onloadend = function () {
                                baseString = reader.result;
                            };
                            reader.readAsDataURL(file);

                            function convertToJPEG(base64String) {
                                return new Promise((resolve, reject) => {
                                    const img = new Image();
                                    img.onload = function () {
                                        const canvas = document.createElement('canvas');
                                        canvas.width = img.width;
                                        canvas.height = img.height;
                                        const ctx = canvas.getContext('2d');
                                        ctx.drawImage(img, 0, 0);
                                        const jpegDataURL = canvas.toDataURL('image/jpeg');
                                        resolve(jpegDataURL);
                                    };
                                    img.src = base64String;
                                });
                            }

                            await new Promise((resolve) => setTimeout(resolve, 100));
                            baseString = await convertToJPEG(baseString);

                            let response = await requisicao('GET', '/sisplan/funcoes/v1/caminhofoto?', null);
                            if (!response) {
                                return;
                            }
                            jsonStr = await response.json();
                            let pastaFoto = jsonStr.mensagem;

                            response = await requisicao(
                                'POST',
                                '/sisplan/funcoes/v1/FotoItem?',
                                `PDIRETORIOSALVAR=${pastaFoto}&NOMEARQUIVO=${produto}.${file.name.split('.').pop()}`,
                                `SBASE64=${encodeURIComponent(baseString)}`
                            );
                        } catch (error) {
                            console.error(error);
                        }

                        produto = {};

                        produto.CODIGO = $('#txtCodigo').val() == '' ? await RetornaProximo('PRODUTO', 'PRODUTO', 'CODIGO', 6) : $('#txtCodigo').val();
                        $('#txtCodigo').val(produto.CODIGO);
                        produto.DESCRICAO = $('#txtDescricaoProduto').val();
                        produto.CODIGO2 = $('#txtCodigo2').val();
                        produto.PROTOTIPO = $('#txtPrototipo').val();
                        produto.QTDE_MIN = parseFloat($('#txtEstMin').val().replace(',', '.'));
                        produto.DESCRICAO2 = $('#txtComplemento').val();
                        produto.PESO_TALHADO = parseFloat($('#txtPesoLiq').val().replace(',', '.'));
                        produto.PESO = parseFloat($('#txtPesoMed').val().replace(',', '.'));
                        produto.CUSTO = parseFloat($('#txtCusto').val().replace(',', '.'));
                        produto.PRECO_COM = parseFloat($('#txtPrecoCompra').val().replace(',', '.'));
                        produto.PRECO = parseFloat($('#txtPrecoVenda').val().replace(',', '.'));
                        produto.PRECO_REPOS = parseFloat($('#txtPrecoRepos').val().replace(',', '.'));
                        produto.CODEXTIPI = $('#txtExtIpi').val();
                        produto.REFERENCIA = $('#txtReferencia').val();
                        produto.IPI = parseFloat($('#txtIpi').val().replace(',', '.'));
                        produto.ICMS = parseFloat($('#txtIcms').val().replace(',', '.'));
                        produto.POSSE = $('#selectPosse').val();
                        produto.CORESDELETA = coresExcluir;

                        if ($('#checkAtivo').prop('checked')) {
                            produto.ATIVO = 'S';
                        } else {
                            produto.ATIVO = 'N';
                        }

                        if ($('#checkLiberado').prop('checked')) {
                            produto.LIBERADO = 'S';
                        } else {
                            produto.LIBERADO = 'N';
                        }

                        produto.MODELISTA = pegaChave($('#txtModelista').val(), produto.MODELISTA);
                        produto.ESTILISTA = pegaChave($('#txtEstilista').val(), produto.ESTILISTA);
                        produto.ETQ_COMPOSI = pegaChave($('#txtSimbologia').val(), produto.ETQ_COMPOSI);
                        produto.FAIXA = pegaChave($('#txtFaixaTam').val(), produto.FAIXA);
                        produto.FORNECEDOR = pegaChave($('#txtCodFornec').val(), produto.FORNECEDOR);
                        produto.GRUPO = pegaChave($('#txtGrupo').val(), produto.GRUPO);
                        produto.CODCLI = pegaChave($('#txtCodCliente').val(), produto.CODCLI);
                        produto.STATUS = pegaChave($('#txtStatus').val(), produto.STATUS);
                        produto.MARCA = pegaChave($('#txtMarca').val(), produto.MARCA);
                        produto.COLECAO = pegaChave($('#txtColecao').val(), produto.COLECAO);
                        produto.ETIQUETA = pegaChave($('#txtEtiqueta').val(), produto.ETIQUETA);
                        produto.LINHA = pegaChave($('#txtLinha').val(), produto.LINHA);
                        produto.UNIDADE = pegaChave($('#txtUnidade').val(), produto.UNIDADE);
                        produto.UNI_VENDA = pegaChave($('#txtUnidadeVenda').val(), produto.UNI_VENDA);
                        produto.UNI_EXP = pegaChave($('#txtUnidadeExp').val(), produto.UNI_EXP);
                        produto.CODFIS = pegaChave($('#txtNcm').val(), produto.CODFIS);
                        produto.CODTRIB = pegaChave($('#txtCstIcms').val(), produto.CODTRIB);
                        produto.CODIPI = pegaChave($('#txtCstIpiSaida').val(), produto.CODIPI);
                        produto.CODIPI_ENT = pegaChave($('#txtCstIpiEntrada').val(), produto.CODIPI_ENT);
                        produto.CODSPED = pegaChave($('#txtSped').val(), produto.CODSPED);
                        produto.NATUREZA = pegaChave($('#txtNatureza').val(), produto.NATUREZA);
                        produto.ENQUADRA = pegaChave($('#txtEnqIpi').val(), produto.ENQUADRA);
                        produto.MODELO = pegaChave($('#txtModelo').val(), produto.MODELO);
                        produto.CATEGORIA = pegaChave($('#txtCategoria').val(), produto.CATEGORIA);
                        produto.TIPO = pegaChave('#txtTipoProduto')

                        if ($('#selectImp').val() == 0) {
                            produto.TIPO_IMPORTACAO = "N";
                        }
                        if ($('#selectImp').val() == 1) {
                            produto.TIPO_IMPORTACAO = "D";
                        }
                        if ($('#selectImp').val() == 2) {
                            produto.TIPO_IMPORTACAO = "I";
                        }

                        if ($('#selectTribEcf').val() == 5) {
                            produto.ECF_TRIB = "";
                        }

                        if ($('#selectTribEcf').val() == 0) {
                            produto.ECF_TRIB = "I";
                        }
                        if ($('#selectTribEcf').val() == 1) {
                            produto.ECF_TRIB = "N";
                        }
                        if ($('#selectTribEcf').val() == 2) {
                            produto.ECF_TRIB = "F";
                        }
                        if ($('#selectTribEcf').val() == 3) {
                            produto.ECF_TRIB = "T";
                        }
                        if ($('#selectTribEcf').val() == 4) {
                            produto.ECF_TRIB = "S";
                        }

                        if ($('#selectTrib').val() == 0) {
                            produto.TRIBUTACAO = "N";
                        }
                        if ($('#selectTrib').val() == 1) {
                            produto.TRIBUTACAO = "D";
                        }
                        if ($('#selectTrib').val() == 2) {
                            produto.TRIBUTACAO = "1";
                        }
                        if ($('#selectTrib').val() == 3) {
                            produto.TRIBUTACAO = "2";
                        }
                        if ($('#selectTrib').val() == 4) {
                            produto.TRIBUTACAO = "3";
                        }
                        if ($('#selectTrib').val() == 5) {
                            produto.TRIBUTACAO = "4";
                        }
                        if ($('#selectTrib').val() == 6) {
                            produto.TRIBUTACAO = "5";
                        }
                        if ($('#selectTrib').val() == 7) {
                            produto.TRIBUTACAO = "6";
                        }
                        if ($('#selectTrib').val() == 8) {
                            produto.TRIBUTACAO = "7";
                        }
                        if ($('#selectTrib').val() == 9) {
                            produto.TRIBUTACAO = "8";
                        }

                        if ($('#txtCuidado').val().length > 0) {
                            produto.cuidado = $('#txtCuidado').val().map((etiqueta) => {
                                return {
                                    Codigo: $('#txtCodigo').val(),
                                    Etiqueta: etiqueta,
                                    Tipo: 'C'
                                }
                            })
                        }

                        try {
                            let responseClasse2 = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                                `JSON={ "tabela":"FAIXA_ITEN",
                                "camposSelect":["TAMANHO"],
                                "where": ["faixa = '${produto.FAIXA}'"]}`, null);

                            if (!responseClasse2) {
                                return;
                            }
                            let jsonStrClasse = await responseClasse2.json();
                            if (responseClasse2.status != 200) {
                                msgErro(jsonStrClasse.RESULT[0].mensagem);
                                return;
                            }

                        } catch (error) {
                            console.error(error);
                        }

                        if (adicionarTamanhos[0] == 'true') {
                            let arrayCores = [];
                            for (let index = 0; index < $('#tabelaFaixaCor').DataTable().rows().count(); index++) {
                                let data = $('#tabelaFaixaCor').DataTable().row(index).data();
                                for (let cont = 1; cont < adicionarTamanhos.length; cont++) {
                                    let cor = {};
                                    cor.CODIGO = $('#txtCodigo').val();
                                    cor.COR = data[0];
                                    cor.ATIVO = data[3];
                                    cor.STATUS = data[4];
                                    cor.TAM = adicionarTamanhos[cont];
                                    arrayCores.push(cor);
                                }
                            }
                            produto.CORES = arrayCores;
                        } else {
                            let arrayCores = [];
                            for (let index = 0; index < $('#tabelaFaixaCor').DataTable().rows().count(); index++) {
                                let data = $('#tabelaFaixaCor').DataTable().row(index).data();
                                for (let cont = 0; cont < adicionarTamanhos.length; cont++) {
                                    let cor = {};
                                    cor.CODIGO = $('#txtCodigo').val();
                                    cor.COR = data[0];
                                    cor.ATIVO = data[3];
                                    cor.STATUS = data[4];
                                    cor.TAM = adicionarTamanhos[cont];
                                    arrayCores.push(cor);
                                }
                            }
                            produto.CORES = arrayCores;
                        }

                        let arrayTipoVendas = [];
                        for (let index = 0; index < $('#tabelaVendaRegra').DataTable().rows().count(); index++) {
                            let data = $('#tabelaVendaRegra').DataTable().row(index).data();
                            let tipovenda = {};
                            tipovenda.CODIGO = $('#txtCodigo').val();;
                            tipovenda.TIPO_VENDA = data[0];
                            tipovenda.EMPRESA = `_${data[1]}`;
                            tipovenda.COD_REGRA = data[2];
                            tipovenda.TRIBUTACAO = data[4];
                            tipovenda.CODSPED = data[5];
                            arrayTipoVendas.push(tipovenda);
                        }
                        produto.TIPOVENDAS = arrayTipoVendas;

                        if (produto.TIPOVENDAS.length == 0) {
                            msgAlerta('Necessário preencher pelo menos um tipo de venda/regra.');
                            $.LoadingOverlay("hide");
                            return;
                        }

                        produto.TELEVENDAS = $('#checkTelevendas').is(':checked') ? 'S' : 'N'

                        let arrayEcommerceCor = [];
                        for (let w = 0; w < $('#tabelaEcomCor').DataTable().rows().count(); w++) {
                            let data = $('#tabelaEcomCor').DataTable().row(w).data();
                            let ecommerceCor = {};
                            ecommerceCor.ATIVO = $(`#check_ecomCor_col_0_row_${w}`).is(':checked') ? 'S' : 'N';
                            ecommerceCor.COR = data[1];
                            arrayEcommerceCor.push(ecommerceCor);
                        }
                        produto.ECOMMERCECORES = arrayEcommerceCor;

                        response1 = await requisicao('POST', '/Sisplan/Cadastros/v1/produto?', '', JSON.stringify(produto), 600000);

                        if (!response1) {
                            $.LoadingOverlay("hide");
                            return;
                        };

                        let jsonStr1 = await response1.json();
                        if (response1.status != 200) {
                            $.LoadingOverlay("hide");
                            msgErro(jsonStr1.mensagem);
                            return;
                        }
                        $.LoadingOverlay("hide");
                        toastr.success(
                            `Cadastro efetuado com sucesso!
                            Produto: ${produto.CODIGO}`,
                            'Confirmação', {
                            toastClass: 'alert',
                            iconClasses: {
                                error: 'alert-error',
                                info: 'alert-info',
                                success: 'alert-success',
                                warning: 'alert-warning'
                            },
                            positionClass: "toast-top-center",
                            progressBar: true,
                            timeOut: 5000,
                            fadeOut: 3000,
                            onHidden() {
                                window.location.href = `${BASE_URI}/produto`;
                            }
                        }
                        ).css({
                            "margin-top": "20%",
                            "width": "500px",
                            "max-width": "500px"
                        });

                    } catch (error) {
                        $.LoadingOverlay("hide");
                        console.error(error);
                    }
                }
            }
        }
    );

    $('.collapse').on('shown.bs.collapse', function (e) {
        let clicked = $(document).find(`[href='#${$(e.target).attr('id')}']`);
        clicked
            .parent()
            .find(".fa-angle-right")
            .removeClass("fa-angle-right")
            .addClass("fa-angle-down");
    })
        .on('hidden.bs.collapse', function (e) {
            let clicked = $(document).find(`[href='#${$(e.target).attr('id')}']`);
            clicked
                .parent()
                .find(".fa-angle-down")
                .removeClass("fa-angle-down")
                .addClass("fa-angle-right");
        });


    //285820 - Apresentar foto de anexo para cor do produto

    function retornaBotaoOpcoes(data) {
        var retorno = '<div> ' +
            '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
            '      ' + data + ' ' +
            '    </button> ' +
            '    <div class="dropdown-menu"> ' +
            '    <button class="dropdown-item" title="Editar" id="btnAlterarCond">Editar</button>     ' +
            '    <button class="dropdown-item" title="Excluir" id="btnExluirCond">Excluir</button>     ' +
            '    <button class="dropdown-item"" title="Anexos" id="btnAnexos">Foto por Cor</button>     ' +
            '</div>';
        return retorno;
    };

    $("#tabelaFaixaCor").on('click', "#btnAnexos", async function () {
        event.preventDefault();
        const data = $('#tabelaFaixaCor').DataTable().row($(this).parents('tr')).data();
        await abreModalAnexos(produto + ` / ` + data[0], data[1], 'PRODUTO');

        let tituloModal = $('#modal-anexos h4.modal-title').html();
        let tituloAlterado = tituloModal.replace('Gestão Documentos', 'Anexo Foto por Cor');
        $('#modal-anexos h4.modal-title').html(tituloAlterado);
    });

    $("#divImagemProduto").removeClass("d-none");

    $(".menu_secao").click(function (e) {
        e.preventDefault();
        var target = $(this).attr("href");
        $(".divOculta").addClass("d-none");
        $(target).removeClass("d-none");
    })

    $('#multiCollapseExample6').on('shown.bs.collapse', async function () {
        $.LoadingOverlay('show')
        try {
            if ($('.campoCheck:checked').length <= 0) {
                $('#tabelaEcomCor').DataTable().columns.adjust().draw(false)

                for (let i = 0; i < $('#tabelaEcomCor').DataTable().data().toArray().length; i++) {
                    if ($('#tabelaEcomCor').DataTable().data().toArray()[i][0] == 'S') {
                        $(`#check_ecomCor_col_0_row_${i}`).prop('checked', true)
                    }
                }
            }
        } catch (error) {
            console.error(error)
            msgAlerta(error.message)
        } finally {
            $.LoadingOverlay('hide')
        }
    })

    async function codigo2Existente(codigo2) {
        const pesquisa = {
            camposSelect: ['CODIGO', 'DESCRICAO'],
            tabela: 'PRODUTO',
            where: [`UPPER(CODIGO2) = '${codigo2.toUpperCase()}'`]
        }
        const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

        if (jsonStr && jsonStr.length > 0 && jsonStr[0].CODIGO != $('#txtCodigo').val()) {
            return `${jsonStr[0].CODIGO} - ${jsonStr[0].DESCRICAO}`
        }

        return ''
    }

    async function preenhceTpVendaPadrao(obj) {
        const descRegra = obj.regra != '' ? await buscaValor('REGRA', 'DESCRICAO', 'CODIGO', obj.regra) : ''
        obj.descRegra = descRegra?.DESCRICAO ?? ''

        const pesquisa = {
            camposSelect: [`REPLACE(EMPRESA.EMP_PAT,'_','') EMPRESA`],
            tabela: `EMPRESA`,
            orderBy: ['EMPRESA.EMP_PAT'],
        };
        const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

        if (jsonStr && jsonStr.length > 0) {
            for (let i = 0; i < jsonStr.length; i++) {
                addTipoRegra(obj.tpVenda, jsonStr[i].EMPRESA, obj.regra, obj.descRegra, obj.tributacao, obj.sped)
            }
        }
    }

    // $("#tabelaFaixaCor").on('click', '.imagemAnexoCor', async function () {
    //     const data = $('#tabelaFaixaCor').DataTable().row($(this).parents('tr')).data();

    //     let chave = produto + ` / ` + data[0];
    //     let tela = 'PRODUTO';

    //     const pesquisaParam = {
    //         tabela: "ANEXO",
    //         camposSelect: [
    //             "ANEXO.TELA",
    //             "ANEXO.ARQUIVO",
    //             "ANEXO.DESCRICAO",
    //             "ANEXO.DATA",
    //             "ANEXO.CAMPO_CHAVE",
    //             "ANEXO.ORDEM",
    //             "ANEXO.DT_VALIDADE",
    //             "ANEXO.USUARIO",
    //             "USUARIO.NOME"
    //         ],
    //         leftJoin: [
    //             { tabela: 'ACESSO_USUARIOS', alias: "USUARIO", condicao: 'USUARIO.CODIGO = ANEXO.USUARIO' },
    //         ],
    //         where: [`CAMPO_CHAVE = '${chave}' AND TELA='${tela}'`]
    //     };

    //     const jsonStr = await retornaJsonPesquisaPadrao(encodeURIComponent(JSON.stringify(pesquisaParam)));

    //     if (!jsonStr || jsonStr.length <= 0){
    //         msgErro('Esta cor não possui foto em anexo!');
    //         $("#infoAnexoImagem").attr('src', `${BASE_URI}/dist/img/prod-1.png`);
    //         console.log(jsonStr);
    //     } else {
    //         const extensao = jsonStr[0].ARQUIVO.split('.')[1];
    //         await buscaFotoAnexosCor(jsonStr[0].ARQUIVO, extensao, tela, chave);
    //         $('.imagemAnexoCor').modal('show');
    //     }
    // });

    // async function buscaFotoAnexosCor(sFoto, sExtensao, tela, chave) {
    //     try {
    //         let url = '/Sisplan/Funcoes/v1/AnexoArquivo?';
    //         let response = await requisicao('GET', url, `ARQUIVO=${sFoto}&TELA=${tela}&CHAVE=${encodeURIComponent(chave)}&EMP_PAT=${getCookie('g_empresa_logada')}`, null);

    //         let jsonStr = await response.json();

    //         if (response.status != 200) {
    //             $("#infoAnexoImagem").attr('src', `${BASE_URI}/dist/img/prod-1.png`);
    //             throw msgAlerta(jsonStr.mensagem);
    //         }

    //         let sBase64 = jsonStr;

    //         $(".imagemAnexoCor").attr('src', `data:image/png;base64,${sBase64.mensagem}`);


    //     } catch (error) {
    //         console.error(error);
    //         $("#infoAnexoImagem").attr('src', `${BASE_URI}/dist/img/prod-1.png`);
    //     }
    // }   



});
