/* eslint-disable guard-for-in */
let campoOrdenacao
let ordenacao


const columnsProdutosRelacionados = [
    {
        title: 'Id',
        data: 'ID',
    },
    {
        title: 'Código',
        data: 'CODIGO',
    },
    {
        title: 'Descrição',
        data: 'DESCRICAO',
    },
    {
        title: 'Cor',
        data: 'COR',
    },
    {
        title: 'Descrição Cor',
        data: 'DESC_COR',
    },
    {
        title: 'Tamanho',
        data: 'TAM',
    },
    {
        title: 'Opções',
        data: 'OPCOES',
    }
];
const columnsProdutosFilhosRelacionados = [
    {
        title: 'Id',
        data: 'ID',
    },
    {
        title: 'Código',
        data: 'CODIGO',
    },
    {
        title: 'Descrição',
        data: 'DESCRICAO',
    },
    {
        title: 'Cor',
        data: 'COR',
    },
    {
        title: 'Descrição Cor',
        data: 'DESC_COR',
    },
    {
        title: 'Tamanho',
        data: 'TAM',
    },
    {
        title: 'Quantidade',
        data: 'QUANTIDADE',
    },
    {
        title: 'Ordem',
        data: 'ORDEM',
    },
    {
        title: 'Opções',
        data: 'OPCOES',
    }
];

$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false
        });
        driver.defineSteps([{
            element: '#btnFiltros',
            popover: {
                title: 'Botão Filtros',
                description: 'Clique aqui para abrir os filtros padrões da tela.',
                position: 'right'
            }
        },
        {
            element: '#btnNovoProduto',
            popover: {
                title: 'Botão Incluir',
                description: 'Clique aqui para iniciar o cadastro de um produto.',
                position: 'right'
            }
        },
        {
            element: '#tabelaCadProduto_wrapper',
            popover: {
                title: 'Tabela Produtos',
                description: 'Aqui estão os dados dos produtos cadastrados.',
                position: 'top'
            }
        }
        ]);
        driver.start();
    });
});
$(document).ready(async function () {
    const permissaoUsuarioLogado = await permissaoAcessos("PRODUTO");
    const acessoFaccao = await permissaoAcessos('FACPRECO');
    const esconderColunasCustoGerarBarras = await retornarEsconderColunasCusto()

    function retornaBotaoOpcoes(sCodigo) {
        var retorno = '<div style="text-align:start;"> ' +
            '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
            '      ' + sCodigo + ' ' +
            '    </button> ' +
            '    <div class="dropdown-menu dropDownProduto" style="z-index: 999999;scrollbar-gutter: stable;"> ' +
            '       <button class="dropdown-item" id="btn-editar">Editar</button>     ' +
            '       <button class="dropdown-item" id="btn-excluir">Excluir</button>  ' +
            '       <button class="dropdown-item" id="btn-duplicar">Duplicar</button>  ' +
            '       <button class="dropdown-item" id="btn-barra">Gera Barras</button>  ' +
            '       <button class="dropdown-item" id="btnAnexos">Gestão Documentos</button>     ' +
            '       <button class="dropdown-item" id="btnMedidas">Medidas</button>     ' +
            '       <button class="dropdown-item" id="btnCombProd">Combinações</button>     ' +
            '       <button class="dropdown-item" id="btnHistProd">Modificações</button>     ' +
            '       <button class="dropdown-item" id="btnFluxoProd">Fluxo</button> ' +
            '       <button class="dropdown-item" id="btnProdItensEst">Consulta Estoque</button>     ' +
            '       <button class="dropdown-item" id="btnRelacionarProdutos">Relacionar Produtos</button>     ' +
            '       <button class="dropdown-item" id="btnCadConsumo">Consumos</button>     ' +
            '       <button class="dropdown-item" id="btnImprimirFT">Imprimir FT</button>     ' +
            '       <button class="dropdown-item" id="btnPrecoFaccao">Preço Facção</button>     ' +
            '       <button class="dropdown-item" id="btnItensEstProd">Estoque de Produto</button>     ' +
                '</div>';
        return retorno;
    }

    function retornaBotaoOpcoesRelacionamentoFilhos() {
        const opcoes = `
         <div class="col-lg-1 col-12">
            <div class="btn-group grupo_botao" role="group" aria-label="Basic example">
               <button type="button" class="btn btn-opcao bg-button nofocus btnDeletarOpcoesFilhos">
                    <i class="fas fa-trash text-red" style="font-weight: bold;margin-left: 10px;font-size: 18px;"></i>
                </button>
            </div>
        </div>
        `
        return opcoes
    }
    function retornaBotaoOpcoesRelacionamentoPais() {
        const opcoes = `
            <div class="col-lg-1 col-12">
                <div class="btn-group grupo_botao" role="group" aria-label="Basic example">
                <button type="button" class="btn btn-opcao bg-button nofocus btnDeletarOpcoesPais">
                        <i class="fas fa-trash text-red" style="font-weight: bold;margin-left: 10px;font-size: 18px;"></i>
                    </button>
                </div>
            </div>
        `

        return opcoes
    }

    consultaProduto();

    $('#btnFiltros').on('click', function () {
        $('#modal-filtros').modal('show');
    });

    $('#btnNovoProduto').on('click', function () {
        if (permissaoUsuarioLogado.INCLUI == 'S') {
            window.location.href = "produto/create";
        } else {
            msgAlertaSemConfirmacao("Sem permissão para incluir!");
        }
    });

    // autocompleta filtros

    componenteFiltro('produto', true)
    componenteFiltro('colecao', true)
    componenteFiltro('marca', true)
    componenteFiltro('grupo', true)
    componenteFiltro('linha', true)
    componenteFiltro('status', true)
    componenteFiltro('etiqueta', true)
    componenteFiltro('cliente', true)
    componenteFiltro('auxiliar', true, true, 'Categoria')
    componenteFiltro('tipoProduto', true)
    componenteFiltro('modelo', true)
    componenteFiltro('ncm', true, true, 'CodigoNcm')
    componenteFiltro('cstIcms', true)
    componenteFiltro('cstIpi', true, true, 'CstIpiSaida')
    componenteFiltro('cstIpi', true, true, 'CstIpiEntrada')
    componenteFiltro('etiqueta', true, true, 'Faixa')
    componenteFiltro('cor', true)

    $('#btnConsultar').on('click', async function () {
        $('#modal-filtros').modal('hide');
        await consultaProduto();
    });

    $('#btnLimparFiltros').on('click', async function () {
        $('input[name="cbStatusProd"]')?.filter('#cbTodos')?.prop('checked', true)
        $('#txtCadastroDe').val('1200-01-01')
        $('#txtCadastroAte').val('2500-12-31')
        $('#txtAlteracaoDe').val('1200-01-01')
        $('#txtAlteracaoAte').val('2500-12-31')
        $('#txtProduto').empty().trigger('change')
        $('#txtColecao').empty().trigger('change')
        $('#txtMarca').empty().trigger('change')
        $('#txtGrupo').empty().trigger('change')
        $('#txtLinha').empty().trigger('change')
        $('#txtStatus').empty().trigger('change')
        $('#txtEtiqueta').empty().trigger('change')
        $('#txtCliente').empty().trigger('change')
        $('#txtCategoria').empty().trigger('change')
        $('#txtTipoProduto').empty().trigger('change')
        $('#txtModelo').empty().trigger('change')
        $('#txtCodigoNcm').empty().trigger('change')
        $('#txtCstIcms').empty().trigger('change')
        $('#txtCstIpiSaida').empty().trigger('change')
        $('#txtCstIpiEntrada').empty().trigger('change')
        $('#txtFaixa').empty().trigger('change')
        $('#txtCor').empty().trigger('change')
        $('#selectTipoVenda').val('')
        $('#selectPosse').val('')
        $('#selectImportado').val('')
    });

    function criptografaCodigo(codigo) {
        return btoa(codigo).replaceAll('=', '');
    }

    $('#txtProdutoFilhoRelacionamento').autocompleta(3, `JSON={ "tabela":"PRODUTO", "camposSelect":[ "CODIGO chave", "DESCRICAO descricao"], "where": null}`);
    $('#btn-ProdutoFilhoRelacionamento').pesquisa_serverside(['#txtProdutoFilhoRelacionamento'], ['CODIGO'], ['DESCRICAO'], '{"tabela":"produto", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}', 'Pesquisa de Produto');

    $('#txtProdutoFilhoRelacionamento').on('blur', function () {
        $('#txtCorFilhoRelacionamento').unbind('autocompleta');
        $('#txtTamanhoFilhoRelacionamento').unbind('autocompleta');
        $('#txtCorFilhoRelacionamento').autocompleta(1, `JSON={ "tabela":"pa_iten", "camposSelect":["PA_ITEN.COR CHAVE, CADCOR.DESCRICAO"], "leftjoin": [{ "tabela" : "cadcor", "condicao" : "pa_iten.cor = cadcor.cor" }], "groupBy": ["pa_iten.cor", "cadcor.descricao"], "where": ["PA_ITEN.CODIGO = '${$(this).attr('data-chave')}'"] }`, [], [], []);
        $('#txtTamanhoFilhoRelacionamento').autocompleta(1, `JSON={ "tabela":"pa_iten", "camposSelect":["TABTAM.ID CHAVE, TABTAM.TAM DESCRICAO"], "leftjoin": [{ "tabela" : "TABTAM", "condicao" : "pa_iten.TAM = TABTAM.TAM" }], "groupBy": ["TABTAM.ID", "TABTAM.TAM"], "where": ["PA_ITEN.CODIGO = '${$(this).attr('data-chave')}'"] }`, [], [], []);

        $('#btn-CorFilhoRelacionamento').off();
        $('#btn-TamanhoFilhoRelacionamento').off();
        $('#btn-CorFilhoRelacionamento').unbind('pesquisa');
        $('#btn-TamanhoFilhoRelacionamento').unbind('pesquisa');
        $('#btn-CorFilhoRelacionamento').pesquisa('#txtCorFilhoRelacionamento', 'COR', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"pa_iten", "camposSelect":[ "PA_ITEN.COR COR", "CADCOR.DESCRICAO DESCRICAO" ],"leftjoin": [{ "tabela" : "cadcor", "condicao" : "pa_iten.cor = cadcor.cor" }], "groupBy": ["pa_Iten.cor", "cadcor.descricao"], "where": ["PA_ITEN.CODIGO = '${$(this).attr('data-chave')}'"]}`, 'Pesquisa Cor', 'CADCOR');
        $('#btn-TamanhoFilhoRelacionamento').pesquisa('#txtTamanhoFilhoRelacionamento', 'ID', 'TAM', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"PA_ITEN", "camposSelect":[ "TABTAM.ID", "TABTAM.TAM" ],"leftjoin": [{ "tabela" : "TABTAM", "condicao" : "pa_iten.TAM = TABTAM.TAM" }], "groupBy": ["TABTAM.ID", "TABTAM.TAM"], "where": ["PA_ITEN.CODIGO = '${$(this).attr('data-chave')}'"]}`, 'Pesquisa Tamanho', 'TABTAM');
    });

    $('#txtFaixaTam').autocompleta(1, `JSON={ "tabela":"faixa", "camposSelect":[ "codigo chave", "descricao descricao"], "where": ["ativo = 'S'"]}`);
    $('#btnSearchFaixaTam').pesquisa('#txtFaixaTam', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"faixa", "camposSelect":[ "codigo", "descricao"], "where": ["ativo = 'S'"]}`, 'Pesquisa Faixa de Tamanho', 'faixa');
    $('#btnClearFaixaTam').on('click', function () {
        $('#txtFaixaTam').val('');
    });

    const dataMinima = new Date(1899, 11, 30)
    const retornarDate = (dateString) => {
        const arrayDate = dateString.split('-')
        const [ano, mes, dia] = arrayDate
        return new Date(ano, parseInt(mes) - 1, dia)
    }

    async function retornaFiltrosConsulta() {
        const ativo = $('input[name="cbStatusProd"]:checked').val()
        const filtroDataCadastroDe = $('#txtCadastroDe').val()
        const filtroDataCadastroAte = $('#txtCadastroAte').val()
        const filtroDataAlteracaoDe = $('#txtAlteracaoDe').val()
        const filtroDataAlteracaoAte = $('#txtAlteracaoAte').val()
        const listaProduto = await formataListas($('#txtProduto').val().toString())
        const listaColecao = await formataListas($('#txtColecao').val().toString())
        const listaMarca = await formataListas($('#txtMarca').val().toString())
        const listaGrupo = await formataListas($('#txtGrupo').val().toString())
        const listaLinha = await formataListas($('#txtLinha').val().toString())
        const listaStatus = await formataListas($('#txtStatus').val().toString())
        const listaEtiqueta = await formataListas($('#txtEtiqueta').val().toString())
        const listaCliente = await formataListas($('#txtCliente').val().toString())
        const listaCategoria = await formataListas($('#txtCategoria').val().toString())
        const listaTipoProduto = await formataListas($('#txtTipoProduto').val().toString())
        const listaModelo = await formataListas($('#txtModelo').val().toString())
        const listaCodigoNcm = await formataListas($('#txtCodigoNcm').val().toString())
        const listaCstIcms = await formataListas($('#txtCstIcms').val().toString())
        const listaIpiSaida = await formataListas($('#txtCstIpiSaida').val().toString())
        const listaIpiEntrada = await formataListas($('#txtCstIpiEntrada').val().toString())
        const listaFaixa = await formataListas($('#txtFaixa').val().toString())
        const listaCor = await formataListas($('#txtCor').val().toString())
        const filtroTipoVenda = $('#selectTipoVenda').val()
        const filtroPosse = $('#selectPosse').val()
        const filtroImportado = $('#selectImportado').val()

        return {
            ativo: ativo,
            dataCadastroDe: filtroDataCadastroDe,
            dataCadastroAte: filtroDataCadastroAte,
            dataAlteracaoDe: filtroDataAlteracaoDe,
            dataAlteracaoAte: filtroDataAlteracaoAte,
            produto: listaProduto,
            colecao: listaColecao,
            marca: listaMarca,
            grupo: listaGrupo,
            linha: listaLinha,
            status: listaStatus,
            etiqueta: listaEtiqueta,
            cliente: listaCliente,
            categoria: listaCategoria,
            tipoProduto: listaTipoProduto,
            modelo: listaModelo,
            codigoNcm: listaCodigoNcm,
            cstIcms: listaCstIcms,
            ipiSaida: listaIpiSaida,
            ipiEntrada: listaIpiEntrada,
            faixa: listaFaixa,
            cor: listaCor,
            tipoVenda: filtroTipoVenda,
            posse: filtroPosse,
            importado: filtroImportado,
        }
    }

    let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

    if (colunas == null || colunas.produto == undefined) {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, produto: [] }))
        colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
    }

    if (colunas == null || colunas.produtoCores == undefined) {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, produtoCores: [] }))
        colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
    }

    $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
        const cols = [];
        let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
        let tabela = ''

        if (activeColVis == 'buttonColVis') {
            tabela = '#tabelaCadProduto'
        }
        if (activeColVis == 'buttonColVisItens') {
            tabela = '#tabelaCores'
        }
        $(tabela).DataTable().columns().every(function () {
            cols.push({
                'title': $(this.header()).text().trim(),
                'data': this.dataSrc()
            })
        });

        if (activeColVis == 'buttonColVis') {
            adicionaColunas(cols, colunasInvisiveis.produto ?? [], ['Pedido'])
        }
        if (activeColVis == 'buttonColVisItens') {
            adicionaColunas(cols, colunasInvisiveis.produtoCores ?? [], [])

        }
    })

    async function montaPesquisa(ordenacaoPesquisa = '') {
        const filtros = await retornaFiltrosConsulta();
        const tipoBanco = await retornaDatabase();
        atualizarFiltrosAbasAcessoSessionStorage('produto', filtros);
        let dataCadastroDe
        let dataCadastroAte
        let dataAlteracaoDe
        let dataAlteracaoAte
        if (tipoBanco == 'ORACLE') {
            dataCadastroDe = filtros.dataCadastroDe && retornarDate(filtros.dataCadastroDe) > dataMinima && ` AND PRODUTO.DATA_CAD >= TO_TIMESTAMP('${filtros.dataCadastroDe} 00:00:00', 'YYYY-MM-DD HH24:MI:SS')` || ''
            dataCadastroAte = filtros.dataCadastroAte && filtros.dataCadastroAte !== '2500-12-31' && ` AND PRODUTO.DATA_CAD <= TO_TIMESTAMP('${filtros.dataCadastroAte} 00:00:00', 'YYYY-MM-DD HH24:MI:SS')` || ''
            dataAlteracaoDe = filtros.dataAlteracaoDe && retornarDate(filtros.dataAlteracaoDe) > dataMinima && ` AND PRODUTO.DT_ALTERACAO >= TO_TIMESTAMP('${filtros.dataAlteracaoDe} 00:00:00', 'YYYY-MM-DD HH24:MI:SS')` || ''
            dataAlteracaoAte = filtros.dataAlteracaoAte && filtros.dataAlteracaoAte !== '2500-12-31' && ` AND PRODUTO.DT_ALTERACAO <= TO_TIMESTAMP('${filtros.dataAlteracaoAte} 00:00:00', 'YYYY-MM-DD HH24:MI:SS')` || ''
        } else {
            dataCadastroDe = filtros.dataCadastroDe && retornarDate(filtros.dataCadastroDe) > dataMinima && ` AND PRODUTO.DATA_CAD >= '${filtros.dataCadastroDe}'` || ''
            dataCadastroAte = filtros.dataCadastroAte && filtros.dataCadastroAte !== '2500-12-31' && ` AND PRODUTO.DATA_CAD <= '${filtros.dataCadastroAte}'` || ''
            dataAlteracaoDe = filtros.dataAlteracaoDe && retornarDate(filtros.dataAlteracaoDe) > dataMinima && ` AND PRODUTO.DT_ALTERACAO >= '${filtros.dataAlteracaoDe}'` || ''
            dataAlteracaoAte = filtros.dataAlteracaoAte && filtros.dataAlteracaoAte !== '2500-12-31' && ` AND PRODUTO.DT_ALTERACAO <= '${filtros.dataAlteracaoAte}'` || ''
        }
        const produto = filtros.produto && ` AND PRODUTO.CODIGO IN (${filtros.produto})` || ''
        const colecao = filtros.colecao && ` AND PRODUTO.COLECAO IN (${filtros.colecao})` || ''
        const marca = filtros.marca && ` AND PRODUTO.MARCA IN (${filtros.marca})` || ''
        const grupo = filtros.grupo && ` AND PRODUTO.GRUPO IN (${filtros.grupo})` || ''
        const linha = filtros.linha && ` AND PRODUTO.LINHA IN (${filtros.linha})` || ''
        const status = filtros.status && ` AND PRODUTO.STATUS IN (${filtros.status})` || ''
        const etiqueta = filtros.etiqueta && ` AND PRODUTO.ETIQUETA IN (${filtros.etiqueta})` || ''
        const cliente = filtros.cliente && ` AND PRODUTO.CODCLI IN (${filtros.cliente})` || ''
        const categoria = filtros.categoria && ` AND PRODUTO.CATEGORIA IN (${filtros.categoria})` || ''
        const tipoProduto = filtros.tipoProduto && ` AND PRODUTO.TIPO IN (${filtros.tipoProduto})` || ''
        const modelo = filtros.modelo && ` AND PRODUTO.MODELO IN (${filtros.modelo})` || ''
        const codigoNcm = filtros.codigoNcm && ` AND PRODUTO.CODFIS IN (${filtros.codigoNcm})` || ''
        const cstIcms = filtros.cstIcms && ` AND PRODUTO.CODTRIB IN (${filtros.cstIcms})` || ''
        const ipiSaida = filtros.ipiSaida && ` AND PRODUTO.CODIPI IN (${filtros.ipiSaida})` || ''
        const ipiEntrada = filtros.ipiEntrada && ` AND PRODUTO.CODIPI_ENT IN (${filtros.ipiEntrada})` || ''
        const faixa = filtros.faixa && ` AND PRODUTO.FAIXA IN (${filtros.faixa})` || ''
        const tipoVenda = filtros.tipoVenda && ` AND PRODUTO.CODIGO IN (SELECT CODIGO FROM [TPVENDA_REGRA] WHERE TIPO_VENDA = '${filtros.tipoVenda}')` || ''
        const posse = filtros.posse && ` AND PRODUTO.POSSE = '${filtros.posse}'` || ''
        const importado = filtros.importado && ` AND PRODUTO.TIPO_IMPORTACAO = '${filtros.importado}'` || ''
        const objTipoBanco = {
            'FIREBIRD': `((PRODUTO.CODIGO IS NOT NULL) AND (PRODUTO.CODIGO <> ''))`,
            'ORACLE': `((PRODUTO.CODIGO IS NOT NULL) OR (PRODUTO.CODIGO <> ''))`,
            'POSTGRES': `((PRODUTO.CODIGO IS NOT NULL) AND (PRODUTO.CODIGO <> ''))`,
            'SQLSERVER': `((PRODUTO.CODIGO IS NOT NULL) AND (PRODUTO.CODIGO <> ''))`
        }
        const whereInicial = objTipoBanco[tipoBanco];
        let statusProduto = filtros.ativo === '' ? '' : ` AND PRODUTO.ATIVO = '${filtros.ativo}'`;

        const innerJoin = filtros.cor && [
            {
                tabelaSelect: `(
                    SELECT
                        CODIGO,
                        COR
                    FROM
                        [PA_ITEN]
                    WHERE
                        COR IN (${filtros.cor})
                    GROUP BY
                        CODIGO,
                        COR
                )`,
                alias: 'PA_ITEN',
                condicao: 'PRODUTO.CODIGO = PA_ITEN.CODIGO',
            }
        ] || []

        return {
            tabela: "produto",
            camposSelect: [
                "'' SEL", "PRODUTO.CODIGO", "PRODUTO.CODIGO2", "PRODUTO.IMAGEM4", "PRODUTO.DESCRICAO", "PRODUTO.DATA_CAD", "PRODUTO.PRECO", "PRODUTO.ATIVO",
                "PRODUTO.FAIXA", "FAIXA.DESCRICAO DESC_FAIXA", "PRODUTO.GRUPO", "GRUPO_PA.DESCRICAO DESC_GRUPO", "PRODUTO.MARCA", "MARCA.DESCRICAO DESC_MARCA",
                "PRODUTO.COLECAO", "COLECAO.DESCRICAO DESC_COLECAO", "PRODUTO.UNIDADE", "PRODUTO.UNI_VENDA"
            ],
            camposWhereServerSide: ["PRODUTO.CODIGO", "PRODUTO.CODIGO2", "PRODUTO.DESCRICAO"],
            where: [
                `${whereInicial} ${produto} ${colecao} ${grupo} ${marca} ${linha} ${status} ${etiqueta} ${statusProduto} ${cliente} ${categoria} ${tipoProduto} ${modelo} ${codigoNcm} ${cstIcms} ${ipiSaida} ${ipiEntrada} ${faixa} ${tipoVenda} ${posse} ${importado} ${dataCadastroDe} ${dataCadastroAte} ${dataAlteracaoDe} ${dataAlteracaoAte}`
            ],
            innerJoin,
            leftJoin: [
                { tabela: 'FAIXA ', condicao: 'FAIXA.CODIGO = PRODUTO.FAIXA' },
                { tabela: 'GRUPO_PA', condicao: 'GRUPO_PA.CODIGO = PRODUTO.GRUPO' },
                { tabela: 'MARCA', condicao: 'MARCA.CODIGO = PRODUTO.MARCA' },
                { tabela: 'COLECAO', condicao: 'COLECAO.CODIGO = PRODUTO.COLECAO' },
            ],
            groupBy: [
                "PRODUTO.CODIGO", "PRODUTO.CODIGO2", "PRODUTO.IMAGEM4", "PRODUTO.DESCRICAO", "PRODUTO.DATA_CAD", "PRODUTO.PRECO", "PRODUTO.ATIVO",
                "PRODUTO.FAIXA", "FAIXA.DESCRICAO", "PRODUTO.GRUPO", "GRUPO_PA.DESCRICAO", "PRODUTO.MARCA", "MARCA.DESCRICAO",
                "PRODUTO.COLECAO", "COLECAO.DESCRICAO", "PRODUTO.UNIDADE", "PRODUTO.UNI_VENDA"],
            orderBy: [`${ordenacaoPesquisa == '' ? 'PRODUTO.CODIGO' : ordenacaoPesquisa} DESC`]
        };
    }

    async function consultaProduto(ordenacaoPesquisa = '', orderTable = []) {
        try {
            $.LoadingOverlay("show");
            const objPesquisa = await montaPesquisa(ordenacaoPesquisa)

            registrosSelecionados.length = 0

            const order = orderTable.length <= 0 ? [0, 'asc'] : orderTable

            $("#tabelaCadProduto").DataTable({
                destroy: true,
                lengthChange: false,
                search: false,
                filter: true,
                serverSide: true,
                colReorder: true,
                processing: true,
                order: [order],
                scrollX: true,
                scrollY: '48vh',
                pageLength: 15,
                lengthMenu: [[10, 15, 25, 50, 100], [10, 15, 25, 50, 100]],
                paging: true,
                autoWidth: true,
                info: true,
                lengthChange: true,
                sortable: true,
                ajax: {
                    url: `${getCookie('protocolo')}://${getCookie(
                        "ip_api"
                    )}/sisplan/funcoes/v1/pesquisadatatable`,
                    type: "POST",
                    headers: { Authorization: BASIC_AUTH },
                    data: {
                        EMPRESA: getCookie("empresa"),
                        JSON: JSON.stringify(objPesquisa),
                        CLIENTE: "S",
                    },
                    error: function (xhr, error, thrown) {
                        console.error("Erro no AJAX:", xhr.responseText);
                    }
                },
                columnDefs: [
                    {
                        targets: [0], render: function (_data, _type, row, meta) {
                            return `<div class="icheck-primary d-inline">
                                  <input type="checkbox" ${registrosSelecionados.find(e => e.codigo === row[1]) && 'checked'} id="check_col_${meta.row}_row_${meta.col}" class="checkSel">
                                  <label for="check_col_${meta.row}_row_${meta.col}"></label>
                                </div>`
                        },
                    },
                    {
                        targets: [1], render: function (data, type, row) {
                            return retornaBotaoOpcoes(row[1]);
                        }
                    },
                    {
                        targets: [3], visible: false,
                    },
                    {
                        targets: [5], render: function (data, type, row, meta) {
                            const preco = (Math.round(row[5])).toFixed(2);
                            return preco == "NaN" ? row[5] : preco;

                        }
                    }

                ],
                rowCallback: function (row, data) {
                    const isChecked = registrosSelecionados.some(e => e.codigo === data[1])
                    $(row).toggleClass('selected', isChecked)
                }
            });
            $('#cbSelAll').prop('checked', false)
            adicionarEventoSelecionarTodos()

            let tabelaProduto = $('#tabelaCadProduto').DataTable();
            tabelaProduto.on('draw.dt', function () {
                const info = tabelaProduto.page.info();
                const paginaAtual = info.page + 1;

                if (paginaAtual === info.pages) {
                    if ((info.end - info.start) < 10) {
                        $('.dropDownProduto').each((i, t) => {
                            $($('.dropDownProduto')[i]).addClass('dropProduto');
                        });
                    }
                }
            });

            $('#tabelaCadProduto').on('click', '#btn-editar', async function () {
                if (permissaoUsuarioLogado.ALTERA == 'S') {
                    let data = $('#tabelaCadProduto').DataTable().row($(this).parents('tr')).data();
                    let registroLiberado = await verificarRegistro('PRODUTO', data[1]);
                    if (registroLiberado) {
                        window.location.href = `produto/${criptografaUrl(data[1])}`;
                    }
                } else {
                    msgAlertaSemConfirmacao("Sem permissão para alterar!");
                }
            });

            $('#tabelaCadProduto').on('dblclick', 'tr', async function () {
                if (permissaoUsuarioLogado.ALTERA == 'S') {
                    let data = $('#tabelaCadProduto').DataTable().row($(this)).data();
                    let registroLiberado = await verificarRegistro('PRODUTO', data[1]);
                    if (registroLiberado) {
                        window.location.href = `produto/${criptografaUrl(data[1])}`;
                    }
                } else {
                    msgAlertaSemConfirmacao("Sem permissão para alterar!");
                }
            });

            $('#tabelaCadProduto_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-file-excel"></i></button>');
            $('#tabelaCadProduto_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');

            $('#buttonExcel').prop('title', 'Exportar')
            $('#buttonColVisItens').prop('title', 'Configurar colunas visíveis');

            $('#buttonColVis').on('click', async function () {
                $.LoadingOverlay('show')
                try {
                    activeColVis = 'buttonColVis'
                    $('#modal-ColunasVisiveis').modal('show');
                } finally {
                    $.LoadingOverlay('hide')
                }
            });

            $('#buttonColVis').on('click', async function () {
                $.LoadingOverlay('show')
                try {
                    activeColVis = 'buttonColVis'
                    $('#modal-ColunasVisiveis').modal('show');
                } finally {
                    $.LoadingOverlay('hide')
                }
            });

            $("#btnConfirmarColunas").off();
            $("#btnConfirmarColunas").on("click", async function () {
                try {
                    $.LoadingOverlay("show");
                    let tabela = ''

                    const novasColunas = retornaNovasColunasInvisiveis();
                    if (activeColVis == 'buttonColVis') {
                        tabela = '#tabelaCadProduto'
                        localStorage.setItem(
                            "colunasInvisiveisRelatorios",
                            JSON.stringify({
                                ...colunas,
                                produto: novasColunas,
                            })
                        );
                    }
                    if (activeColVis == 'buttonColVisItens') {
                        tabela = '#tabelaCores'
                        localStorage.setItem(
                            "colunasInvisiveisRelatorios",
                            JSON.stringify({
                                ...colunas,
                                produtoCores: novasColunas,
                            })
                        );
                    }

                    $(tabela).DataTable().columns().visible(true);

                    $(tabela)
                        .DataTable()
                        .columns()
                        .every(function () {
                            const colAtual = String(this.dataSrc());
                            if (novasColunas.indexOf(colAtual) != -1) {
                                this.visible(false);
                            }
                        });

                } finally {
                    $.LoadingOverlay("hide");
                    $("#modal-ColunasVisiveis").modal("hide");
                }
            });

            $('#buttonExcel').on('click', async function () {
                if (!ordenacao) {
                    ordenacao = 'ASC';
                }
                if (!campoOrdenacao) {
                    campoOrdenacao = 'PRODUTO.CODIGO';
                }
                const url = '/Sisplan/Funcoes/v1/pesquisa?';
                const pesquisa = await montaPesquisa(`${campoOrdenacao} ${ordenacao}`, [$(this).index(), ordenacao.toLowerCase() == 'desc' ? 'asc' : 'desc']);
                await exportaCSV(url, `JSON=${encodeURIComponent(JSON.stringify(pesquisa))}`, true, null, 'Acesso Produto');
            })

            $('#buttonExcel').prop('title', 'Exportar')

            $('#tabelaCadProduto th').on('click', async function () {
                const nomeColuna = $(this).html();
                const novaOrdenacao = ultimaColunaOrdenada.ordenacao == 'ASC' ? 'DESC' : 'ASC';
                const ordenacao = ultimaColunaOrdenada.nome == nomeColuna ? novaOrdenacao : 'ASC';
                await buscaDados(nomeColuna + ' ' + ordenacao);
            });

            $('#tabelaCadProduto').on('click', 'tr', async function () {
                const data = $('#tabelaCadProduto').DataTable().row($(this)).data();

                if ($(this).hasClass('selected')) {
                    $(this).removeClass('selected');
                    await buscaFoto()
                } else {
                    $('#tabelaCadProduto').DataTable().$('tr.selected').removeClass('selected');
                    $(this).addClass('selected');
                    await buscaFoto(data[1])
                }

                await retornaCores(data[1]);
            });

            setTimeout(() => {
                $($($('#tabelaCadProduto').children()[1]).children()[0]).closest('tr').trigger('click');
            }, 1000);

            $.LoadingOverlay("hide");
        } catch (error) {
            $.LoadingOverlay("hide");
            console.error(error);
            msgErro(`Não foi possível buscar os dados do produto`);
        }
    }

    async function retornaCores(sCodigo) {
        $.LoadingOverlay('show');
        try {
            const dadosSelect = {
                tabela: 'PA_ITEN',
                camposSelect: [
                    'DISTINCT PA_ITEN.COR',
                    'CADCOR.DESCRICAO',
                    'CADCOR.PANTONE',
                    'CADCOR.CODIGO2',
                    'CADCOR.OBS',
                    'CADCOR.RGB',
                    'PA_ITEN.ATIVO'
                ],
                leftJoin: [
                    { tabela: 'CADCOR ', condicao: 'PA_ITEN.COR = CADCOR.COR' },
                ],
                where: [`PA_ITEN.CODIGO = '${sCodigo}'`],
                orderBy: ['PA_ITEN.COR']
            };
            const dados = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));
            if (!dados) {
                msgAlerta('Não foi possível buscar os dados das cores.');
                return;
            }

            if ($.fn.DataTable.isDataTable('#tabelaCores')) {
                $('#tabelaCores').DataTable().destroy()
                $('#tabelaCores').empty()
            }

            const columns = [
                {
                    data: 'COR',
                    title: 'Cor',
                },
                {
                    data: 'DESCRICAO',
                    title: 'Descrição',
                },
                {
                    data: 'PANTONE',
                    title: 'Pantone',
                },
                {
                    data: 'CODIGO2',
                    title: 'Código 2',
                },
                {
                    data: 'OBS',
                    title: 'Observação',
                },
                {
                    data: 'RGB',
                    title: 'RBG',
                },
                {
                    data: 'ATIVO',
                    title: 'Ativo',
                },
            ]

            $('#tabelaCores').DataTable({
                search: false,
                filter: true,
                order: [],
                sort: false,
                destroy: true,
                scrollX: true,
                scrollY: '48vh',
                pageLength: 10,
                paging: true,
                "autoWidth": true,
                "data": dados,
                "columns": columns,
                autoWidth: false,
                "colReorder": true,
                columnDefs: [
                    {
                        targets: [5],
                        render: function (data, type, row) {
                            return retornaCampoRGB(row.RGB);
                        }
                    },
                ]
            });

            $('#tabelaCores_length').prepend('<button class="buttonColVis" id="buttonColVisItens"><i class="fas fa-cogs"></i></button>');
            $('#tabelaCores_length').prepend('<button class="buttonExcel" id="buttonExcel2"><i class="fas fa-file-excel"></i></button>');

            $('#buttonColVisItens').prop('title', 'Configurar colunas visíveis');
            $('#buttonExcel2').prop('title', 'Exportar');

            $('#buttonColVisItens').on('click', async function () {
                $.LoadingOverlay('show')
                try {
                    activeColVis = 'buttonColVisItens'
                    $('#modal-ColunasVisiveis').modal('show');
                } finally {
                    $.LoadingOverlay('hide')
                }
            });

            $('#buttonExcel2').off()
            $('#buttonExcel2').on('click', async function () {
                const dados = $("#tabelaCores").DataTable().data().toArray();
                await exportaCSV("", "", undefined, null, 'Relatório de Cores de Produto', '', '', 999, false, false, dados);
            });
        } finally {
            $.LoadingOverlay('hide');
        }
    }

    function retornaCampoRGB(rgb) {
        const r = rgb.substring(0, 3);
        const g = rgb.substring(3, 6);
        const b = rgb.substring(6, 9);

        const hexR = ("0" + parseInt(r, 10).toString(16)).slice(-2);
        const hexG = ("0" + parseInt(g, 10).toString(16)).slice(-2);
        const hexB = ("0" + parseInt(b, 10).toString(16)).slice(-2);

        const hex = '#' + hexR + hexG + hexB;

        var retorno = '<div class="form-group" style="margin-bottom: 0.2rem !important; margin-top: 0.2rem !important"> ' +
            `     <input type="color" disabled class="input-default" value="${hex}" id="inputColorRGBAcesso" style="height: 30px; width: 50px;"></input>` +
            '</div>';

        return retorno;
    };

    $('#tabelaCadProduto').on('click', '#btn-excluir', async function () {
        if (permissaoUsuarioLogado.EXCLUI == 'S') {
            msgAlerta('Você realmente deseja excluir esse registro?', async () => {
                const data = $('#tabelaCadProduto').DataTable().row($(this).parents('tr')).data();
                await excluiRegistro(data[1]);
            });
        } else {
            msgAlertaSemConfirmacao("Sem permissão para excluir!");
        }
    });

    async function excluiRegistro(codigo) {
        try {
            $.LoadingOverlay("show");
            try {
                let response = await requisicao("DELETE", "/Sisplan/Cadastros/v1/produto?", `CODIGOPRODUTO=${encodeURIComponent(codigo)}`, null);
                if (!response) {
                    return;
                }
                if (response.status != 200) {
                    let jsonStr = await response.json();
                    msgErro(jsonStr.mensagem);
                    return;
                }

                toastr.success("Exclusão efetuada com sucesso!", "Confirmação", {
                    toastClass: "success",
                    iconClasses: {
                        error: "alert-error",
                        info: "alert-info",
                        success: "alert-success",
                        warning: "alert-warning",
                    },
                    positionClass: "toast-top-center",
                    progressBar: true,
                    timeOut: 3000,
                    fadeOut: 1000,
                    onHidden() {
                        window.location.reload();
                    },
                }).css({
                    "margin-top": "20%",
                    width: "500px",
                    "max-width": "500px",
                });

            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay("hide");
        }
    }

    let guardaLinha;

    $('#tabelaCadProduto').on('click', '#btnRelacionarProdutos', async function () {
        const data = $('#tabelaCadProduto').DataTable().rows($(this).closest('tr')).data();
        $('#txtCodigoProdutoPai').val(data[0][1])
        $('#modalRelacionarProduto').modal('show');
    })

    async function retornarEsconderColunasCusto() {
        const pesquisa = {
            tabela: 'PERMISSOES_TELA',
            camposSelect: ['PERMISSAO'],
            where: [`TELA = 'GERA_BARRAS_PRODUTO'`, `ACAO = 'ESCONDER_COLUNAS_CUSTO'`, `USUARIO = '${getCookie('cod_usuario')}'`],
        }

        const [resultado] = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa))

        if (!resultado || resultado.PERMISSAO === 'N')
            return false

        return true
    }

    // barra
    $('#tabelaCadProduto').on('click', '#btn-barra', async function () {
        if (permissaoUsuarioLogado.INCLUI == 'S') {
            // ao dar o click ele vai consultar as barras
            let data = $('#tabelaCadProduto').DataTable().rows($(this).closest('tr')).data();
            guardaLinha = $(this).closest('tr');
            let jsonBarra;
            $('#txtCodigoProduto').val(data[0][1]);
            $('#txtDescricaoProduto').val(data[0][4]);
            jsonBarra = await buscaBarras(data[0][1]);

            for (let i = 0; i < jsonBarra[0].length; i++) {
                jsonBarra[0][i].BARRA =
                    `
                <input type="text" style="width: 15em;" value="${jsonBarra[0][i].BARRA}" class="input-default focus form-control txtBarraIten" name="txtBarraIten">
                
                `;
                jsonBarra[0][i].BARRA28 =
                    `
                    <input type="text" style="width: 15em;" value="${jsonBarra[0][i].BARRA28}" class="input-default focus form-control txtBarra28" name="txtBarra28">
                    
                `;
                jsonBarra[0][i].BARRACLI =
                    `
                    <input type="text" style="width: 15em;" value="${jsonBarra[0][i].BARRACLI}" class="input-default focus form-control txtBarracli" name="txtBarracli">
                    
                `;
                if (!esconderColunasCustoGerarBarras) {
                    jsonBarra[0][i].CUSTO =
                        `
                    <input type="number" style="width: 6em;" value="${jsonBarra[0][i].CUSTO ?? 0}" class="input-default focus form-control txtCusto" name="txtCusto">
                    
                `;
                    jsonBarra[0][i].PRECO_REPOS =
                        `
                    <input type="number" style="width: 6em;" value="${jsonBarra[0][i].PRECO_REPOS ?? 0}" class="input-default focus form-control txtPrecoRepos" name="txtPrecoRepos">
                    
                `;
                    jsonBarra[0][i].PRECO_COM =
                        `
                    <input type="number" style="width: 6em;" value="${jsonBarra[0][i].PRECO_COM ?? 0}" class="input-default focus form-control txtPrecoCom" name="txtPrecoCom">
                    
                `;
                    jsonBarra[0][i].PRECO_VEN =
                        `
                    <input type="number" style="width: 6em;" value="${jsonBarra[0][i].PRECO_VEN ?? 0}" class="input-default focus form-control txtPrecoVen" name="txtPrecoVen">
                    
                `;
                }
            }

            let dataSetCols = [];

            let keys = Object.keys(jsonBarra[0][0]);

            for (let k in keys) {
                dataSetCols.push({
                    'title': keys[k],
                    'data': keys[k]
                });
            }

            let rowDuplicado = []

            for (let j = 0; j < jsonBarra[0].length; j++) {
                for (let i = j + 1; i < jsonBarra[0].length; i++) {
                    if (jsonBarra[0][j].COR == jsonBarra[0][i].COR && jsonBarra[0][j].TAM == jsonBarra[0][i].TAM) {
                        rowDuplicado.push(i);
                    }
                }
            }

            const duplicados = rowDuplicado.filter(function (itens, pos) {
                return rowDuplicado.indexOf(itens) == pos;
            })

            let colunasInvisiveis = [0, 1, 2, 3, 11, 12, 13, 14, 15, 16, 17]
            if (esconderColunasCustoGerarBarras) {
                colunasInvisiveis = [...colunasInvisiveis, 18, 19, 20, 21]
            }

            tabelaBarra = $('#tabelaBarra').DataTable({
                paging: false,
                filter: false,
                info: true,
                order: true,
                destroy: true,
                "data": jsonBarra[0],
                "columns": dataSetCols,
                "columnDefs": [{
                    "targets": colunasInvisiveis,
                    "visible": false
                }],
                autoWidth: true,
            });

            if (duplicados.length > 0) {
                $('#tabelaBarra').DataTable().rows([duplicados.toString()]).remove().draw(false);
            }

            $('#modalBarra').modal('show');
        } else {
            msgAlertaSemConfirmacao("Sem permissão para incluir!");
        }
    });

    $("#modalBarra").on("shown.bs.modal", function () {
        $("#tabelaBarra").DataTable().columns.adjust().draw(false);
    });

    async function abreProdutosFilhosRelacionados(data) {
        try {
            $.LoadingOverlay('show');
            const url = '/sisplan/produto/v1/produtos_filhos_relacionados?';
            const response = await requisicao('GET', url, `ID=${data.ID}`, '', 30000);

            if (!response) {
                return;
            };
            $('.divProdutosFilhos').removeClass('d-none');
            if (response.status != 200) {
                await criaTabelaProdutosFilhosRelacionados();
                return;
            }

            const jsonStr = await response.json();
            if (!jsonStr.produtos) {
                await criaTabelaProdutosFilhosRelacionados();
                return;
            }

            const produtos = jsonStr.produtos.map((prod) => {
                return {
                    ID: prod.id,
                    CODIGO: prod.codigo,
                    DESCRICAO: prod.desc_Prod,
                    COR: prod.cor,
                    DESC_COR: prod.desc_Cor,
                    TAM: prod.tam,
                    QUANTIDADE: prod.quantidade,
                    ORDEM: prod.ordem,
                    OPCOES: retornaBotaoOpcoesRelacionamentoFilhos()
                }
            })

            await criaTabelaProdutosFilhosRelacionados(produtos);

        } finally {
            $.LoadingOverlay('hide');
        }
    }

    async function criaTabelaProdutosFilhosRelacionados(data) {

        if ($.fn.DataTable.isDataTable("#tabelaProdutosFilhosRelacionados")) {
            $('#tabelaProdutosFilhosRelacionados').DataTable().destroy();
            $('#tabelaProdutosFilhosRelacionados').empty();
        }

        let objetoTabela = {
            paging: false,
            filter: false,
            info: false,
            order: false,
            destroy: true,
            columns: columnsProdutosFilhosRelacionados,
            columnDefs: [
                {
                    targets: [2], // índice da coluna que você quer definir o tamanho
                    width: "250px",

                }
            ]
        }
        if (data) {
            objetoTabela = { ...objetoTabela, data: data }
        }

        $('#tabelaProdutosFilhosRelacionados').DataTable(objetoTabela);

        $('.btnDeletarOpcoesFilhos').on('click', function () {
            try {
                msgAlerta('Você realmente deseja excluir esse registro?', async () => {
                    const dados = $('#tabelaProdutosFilhosRelacionados').DataTable().row($(this).parents('tr')).data();

                    const url = '/sisplan/produto/v1/produto_filho_relacionado?';
                    const response = await requisicao('DELETE', url, `ID=${dados.ID}`, '', 15000);

                    if (!response) {
                        return;
                    }

                    if (response.status != 200) {
                        const jsonStr = await response.json();
                        msgErro(jsonStr.mensagem);
                        return;
                    }
                    criaMensagemSucesso('Produto deletado do relacionamento!');

                    const dadosProdutoPai = $("#tabelaProdutosPaisRelacionados").DataTable().row(".selected").data()
                    $('#txtOrdemItensFilho').val('0')
                    await abreProdutosFilhosRelacionados(dadosProdutoPai)
                });
            } catch (error) {
                console.error(error);
            }
        });

        $('#tabelaProdutosFilhosRelacionados tbody').on('click', 'tr', async function () {
            if ($(this).hasClass('selected')) {
                $(this).removeClass('selected');
                $('#txtOrdemItensFilho').val(0);
            } else {
                $('#tabelaProdutosFilhosRelacionados').DataTable().$('tr.selected').removeClass('selected');
                $(this).addClass('selected');
                const data = $('#tabelaProdutosFilhosRelacionados').DataTable().row(this.rowIndex - 1).data();
                $('#txtOrdemItensFilho').val(data.ORDEM);
            }
        });
    }

    async function criaTabelaProdutosPaisRelacionados(data) {

        if ($.fn.DataTable.isDataTable("#tabelaProdutosPaisRelacionados")) {
            $('#tabelaProdutosPaisRelacionados').DataTable().destroy();
            $('#tabelaProdutosPaisRelacionados').empty();
        }
        if ($.fn.DataTable.isDataTable("#tabelaProdutosFilhosRelacionados")) {
            $('#tabelaProdutosFilhosRelacionados').DataTable().destroy();
            $('#tabelaProdutosFilhosRelacionados').empty();
        }

        let objetoTabela = {
            paging: false,
            filter: false,
            info: false,
            order: false,
            destroy: true,
            scrollX: '250px',
            scrollY: '150px',
            columns: columnsProdutosRelacionados,
        }
        if (data) {
            objetoTabela = { ...objetoTabela, data: data }
        }

        $('#tabelaProdutosPaisRelacionados').DataTable(objetoTabela);

        $('#tabelaProdutosPaisRelacionados tbody').on('click', 'tr', async function () {
            if ($(this).hasClass('selected')) {
                $(this).removeClass('selected');
            } else {
                $('#tabelaProdutosPaisRelacionados').DataTable().$('tr.selected').removeClass('selected');
                $(this).addClass('selected');
                const data = $('#tabelaProdutosPaisRelacionados').DataTable().row(this.rowIndex - 1).data();
                await abreProdutosFilhosRelacionados(data)
            }
        });

        $('.btnDeletarOpcoesPais').on('click', function () {
            try {
                msgAlerta('Você realmente deseja excluir esse registro?', async () => {
                    const dados = $('#tabelaProdutosPaisRelacionados').DataTable().row($(this).parents('tr')).data();

                    const url = '/sisplan/produto/v1/produto_pai_relacionado?';
                    const response = await requisicao('DELETE', url, `ID=${dados.ID}`, '', 15000);

                    if (!response) {
                        return;
                    }

                    if (response.status != 200) {
                        const jsonStr = await response.json();
                        msgErro(jsonStr.mensagem);
                        return;
                    }
                    criaMensagemSucesso('Produto deletado do relacionamento!');

                    await abreProdutosPaisRelacionados()
                });
            } catch (error) {
                console.error(error);
            }
        });

        if ($('#tabelaProdutosPaisRelacionados').DataTable().rows().count() === 1) {
            $($('#tabelaProdutosPaisRelacionados tbody tr')[0]).trigger('click')
        }

        $('#txtCorPaiRelacionamento').autocompleta(1, `JSON={ "tabela":"pa_iten", "camposSelect":["PA_ITEN.COR CHAVE, CADCOR.DESCRICAO"], "leftjoin": [{ "tabela" : "cadcor", "condicao" : "pa_iten.cor = cadcor.cor" }], "groupBy": ["pa_iten.cor", "cadcor.descricao"], "where": ["PA_ITEN.CODIGO = '${$('#txtCodigoProdutoPai').val()}'"] }`, [], [], []);
        $('#txtTamanhoPaiRelacionamento').autocompleta(1, `JSON={ "tabela":"pa_iten", "camposSelect":["TABTAM.ID CHAVE, TABTAM.TAM DESCRICAO"], "leftjoin": [{ "tabela" : "TABTAM", "condicao" : "pa_iten.TAM = TABTAM.TAM" }], "groupBy": ["TABTAM.ID", "TABTAM.TAM"], "where": ["PA_ITEN.CODIGO = '${$('#txtCodigoProdutoPai').val()}'"] }`, [], [], []);
        $('#btn-CorPaiRelacionamento').pesquisa('#txtCorPaiRelacionamento', 'COR', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"pa_iten", "camposSelect":[ "PA_ITEN.COR COR", "CADCOR.DESCRICAO DESCRICAO" ],"leftjoin": [{ "tabela" : "cadcor", "condicao" : "pa_iten.cor = cadcor.cor" }], "groupBy": ["pa_Iten.cor", "cadcor.descricao"], "where": ["PA_ITEN.CODIGO = '${$('#txtCodigoProdutoPai').val()}'"]}`, 'Pesquisa Cor', 'CADCOR');
        $('#btn-TamanhoPaiRelacionamento').pesquisa('#txtTamanhoPaiRelacionamento', 'ID', 'TAM', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"PA_ITEN", "camposSelect":[ "TABTAM.ID", "TABTAM.TAM" ],"leftjoin": [{ "tabela" : "TABTAM", "condicao" : "pa_iten.TAM = TABTAM.TAM" }], "groupBy": ["TABTAM.ID", "TABTAM.TAM"], "where": ["PA_ITEN.CODIGO = '${$('#txtCodigoProdutoPai').val()}'"]}`, 'Pesquisa Tamanho', 'TABTAM');

    }

    $('#btnAdicionarProdutoPai').on('click', async function () {
        const corPai = pegaChave('#txtCorPaiRelacionamento')
        const tamPai = pegaChave('#txtTamanhoPaiRelacionamento')
        if (corPai === '') {
            msgAlerta('Cor não informada!')
            return;
        }
        if (tamPai === '') {
            msgAlerta('Tamanho não informado!')
            return;
        }

        const objeto = {
            Id_Prod: 0,
            Id: 0,
            Id_Cor: 0,
            Id_Tam: tamPai,
        }

        const url = '/sisplan/produto/v1/produto_pai_relacionado?';
        const response = await requisicao('POST', url, `CODIGO=${$('#txtCodigoProdutoPai').val()}&COR=${corPai}`, JSON.stringify(objeto), 30000);

        if (!response) {
            return;
        };

        if (response.status != 200) {
            msgAlerta(`Erro ao gravar relacionamento`);
            return;
        }

        await abreProdutosPaisRelacionados();
        criaMensagemSucesso('Produto Pai adicionado com sucesso!');

    })

    $('#btnAdicionarProdutoFilho').on('click', async function () {
        if ($("#tabelaProdutosPaisRelacionados").DataTable().rows(".selected").count() == 0) {
            msgAlerta('Nenhum produto pai selecionado!');
            return;
        }

        const dadosProdutoPai = $("#tabelaProdutosPaisRelacionados").DataTable().row(".selected").data()
        const corFilho = pegaChave('#txtCorFilhoRelacionamento')
        const tamFilho = pegaChave('#txtTamanhoFilhoRelacionamento')
        const produtoFilho = pegaChave('#txtProdutoFilhoRelacionamento')
        const qtdeFilho = parseInt($('#txtQuantidadeFilho').val())
        const dataFilhos = $("#tabelaProdutosFilhosRelacionados").DataTable().rows().data().toArray();
        const ordem = []
        dataFilhos.forEach((data) => ordem.push(data.ORDEM))

        const ordemFilho = $('#txtOrdemItensFilho').val() == '0' ? ordem.length === 0 ? 1 : Math.max(...ordem) + 1 : parseInt($('#txtOrdemItensFilho').val());

        if (corFilho === '') {
            msgAlerta('Cor não informada!')
            return;
        }
        if (tamFilho === '') {
            msgAlerta('Tamanho não informado!')
            return;
        }
        if (produtoFilho === '') {
            msgAlerta('Produto não informado!')
            return;
        }
        if (!qtdeFilho || qtdeFilho == 0) {
            msgAlerta('Quantidade não informada!')
            return;
        }

        const objeto = {
            Id_Prod: 0,
            Id: 0,
            Id_Cor: 0,
            Id_Tam: tamFilho,
            Id_Pai: dadosProdutoPai.ID,
            Quantidade: qtdeFilho,
            Ordem: ordemFilho
        }

        const url = '/sisplan/produto/v1/produto_filho_relacionado?';
        const response = await requisicao('POST', url, `CODIGO=${pegaChave('#txtProdutoFilhoRelacionamento')}&COR=${corFilho}`, JSON.stringify(objeto), 30000);

        if (!response) {
            return;
        };

        if (response.status != 200) {
            msgAlerta(`Erro ao gravar relacionamento`);
            return;
        }

        await abreProdutosFilhosRelacionados(dadosProdutoPai)

        criaMensagemSucesso('Produto adicionado ao relacionamento com sucesso!');
    })

    $('#btnConfirmarRelacionamento').on('click', async function () {
        $('#modalRelacionarProduto').modal('hide');
    })

    $("#modalRelacionarProduto").on("hidden.bs.modal", async function () {
        limpaValor('#txtCorFilhoRelacionamento');
        limpaValor('#txtProdutoFilhoRelacionamento');
        limpaValor('#txtTamanhoFilhoRelacionamento');
        $('#txtCodigoProdutoPai').val('');
        $('.divProdutosFilhos').addClass('d-none');
    });

    async function abreProdutosPaisRelacionados() {
        try {
            $.LoadingOverlay('show');
            const url = '/sisplan/produto/v1/produtos_relacionados?';
            const response = await requisicao('GET', url, `CODIGO=${$('#txtCodigoProdutoPai').val()}`, '', 30000);

            if (!response) {
                return;
            };

            if (response.status != 200) {
                await criaTabelaProdutosPaisRelacionados();
                return;
            }

            const jsonStr = await response.json();

            if (!jsonStr.produtos) {
                await criaTabelaProdutosPaisRelacionados();
                return;
            }

            const produtos = jsonStr.produtos.map((prod) => {
                return {
                    ID: prod.id,
                    CODIGO: prod.codigo,
                    DESCRICAO: prod.desc_Prod,
                    COR: prod.cor,
                    DESC_COR: prod.desc_Cor,
                    TAM: prod.tam,
                    OPCOES: retornaBotaoOpcoesRelacionamentoPais()
                }
            })

            await criaTabelaProdutosPaisRelacionados(produtos);

        } finally {
            $.LoadingOverlay('hide');
        }
    }

    $("#modalRelacionarProduto").on("shown.bs.modal", async function () {
        await abreProdutosPaisRelacionados()
    });

    async function consultaCor(codigoProduto) {
        const pesquisaParam = {
            tabela: 'PA_ITEN',
            camposSelect: ['DISTINCT PA_ITEN.COR'],
            where: [`PA_ITEN.CODIGO = '${codigoProduto}'`],
            innerJoin: [{ tabela: "CADCOR", condicao: "PA_ITEN.COR = CADCOR.COR" }]
        };
        const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

        if (jsonStr.length == 0) {
            return;
        };

        const listaCores = [];

        for (i in jsonStr) {
            listaCores.push(jsonStr[i].COR);
        };

        const listaFormatada = await formataListas(listaCores.toString());

        return listaFormatada
    };

    async function recarregaBarras(linha) {
        // ao dar o click ele vai consultar as barras
        let data = $('#tabelaCadProduto').DataTable().rows(linha).data();
        let jsonBarra;
        $('#txtCodigoProduto').val(data[0][1]);
        $('#txtDescricaoProduto').val(data[0][4]);
        jsonBarra = await buscaBarras(data[0][1]);

        let dataSetCols = [];

        let keys = Object.keys(jsonBarra[0][0]);

        for (let k in keys) {
            dataSetCols.push({
                'title': keys[k],
                'data': keys[k]
            });
        }
        for (let i = 0; i < jsonBarra[0].length; i++) {
            jsonBarra[0][i].BARRA =
                `
            <input type="text" style="width: 15em;" value="${jsonBarra[0][i].BARRA}" class="input-default focus form-control txtBarraIten" name="txtBarraIten">
            
            `;
            jsonBarra[0][i].BARRA28 =
                `
                <input type="text" style="width: 15em;" value="${jsonBarra[0][i].BARRA28}" class="input-default focus form-control txtBarra28" name="txtBarra28">
                
            `;
            jsonBarra[0][i].BARRACLI =
                `
                <input type="text" style="width: 15em;" value="${jsonBarra[0][i].BARRACLI}" class="input-default focus form-control txtBarracli" name="txtBarracli">
                
            `;

            if (!esconderColunasCustoGerarBarras) {
                jsonBarra[0][i].CUSTO =
                    `
                <input type="number" style="width: 6em;" value="${jsonBarra[0][i].CUSTO ?? 0}" class="input-default focus form-control txtCusto" name="txtCusto">
                
            `;
                jsonBarra[0][i].PRECO_REPOS =
                    `
                <input type="number" style="width: 6em;" value="${jsonBarra[0][i].PRECO_REPOS ?? 0}" class="input-default focus form-control txtPrecoRepos" name="txtPrecoRepos">
                
            `;
                jsonBarra[0][i].PRECO_COM =
                    `
                <input type="number" style="width: 6em;" value="${jsonBarra[0][i].PRECO_COM ?? 0}" class="input-default focus form-control txtPrecoCom" name="txtPrecoCom">
                
            `;
                jsonBarra[0][i].PRECO_VEN =
                    `
                <input type="number" style="width: 6em;" value="${jsonBarra[0][i].PRECO_VEN ?? 0}" class="input-default focus form-control txtPrecoVen" name="txtPrecoVen">
                
            `;
            }
        }

        let rowDuplicado = []

        for (let j = 0; j < jsonBarra[0].length; j++) {
            for (let i = j + 1; i < jsonBarra[0].length; i++) {
                if (jsonBarra[0][j].COR == jsonBarra[0][i].COR && jsonBarra[0][j].TAM == jsonBarra[0][i].TAM) {
                    rowDuplicado.push(i);
                }
            }
        }

        const duplicados = rowDuplicado.filter(function (itens, pos) {
            return rowDuplicado.indexOf(itens) == pos;
        })

        let colunasInvisiveis = [0, 1, 2, 3, 11, 12, 13, 14, 15, 16, 17]
        if (esconderColunasCustoGerarBarras) {
            colunasInvisiveis = [...colunasInvisiveis, 18, 19, 20, 21]
        }

        tabelaBarra = $('#tabelaBarra').DataTable({
            paging: false,
            filter: false,
            info: true,
            order: true,
            destroy: true,
            autoWidth: true,
            "data": jsonBarra[0],
            "columns": dataSetCols,
            "columnDefs": [{
                "targets": colunasInvisiveis,
                "visible": false
            }]
        });

        if (duplicados.length > 0) {
            $('#tabelaBarra').DataTable().rows([duplicados.toString()]).remove().draw(false);
        }
    };

    async function buscaBarras(codigo) {
        try {
            $.LoadingOverlay('hide');
            try {
                let url = `/sisplan/funcoes/v1/pesquisa?`;
                let response = await requisicao('GET', url, `JSON={
                    "tabela": "PRODUTO",
                    "camposSelect": ["SUM(QUANTIDADE) AS QTDE", "PRODUTO.CODIGO", "PRODUTO.DESCRICAO", "PRODUTO.UNIDADE", "PA_ITEN.TIPO QUALIDADE", "PA_ITEN.COR", "CADCOR.DESCRICAO DESC_COR", "PA_ITEN.TAM",
                        "PA_ITEN.BARRA", "PA_ITEN.BARRA28", "PA_ITEN.BARRACLI", "PA_ITEN.ORDEM", "PA_ITEN.QTDE_MIN",
                        " CASE WHEN MAX(PA_ITEN.COD_PROD_CLI) IS NULL THEN '' ELSE MAX(PA_ITEN.COD_PROD_CLI) END AS COD_PROD_CLI",
                        " PA_ITEN.ATIVO", " MAX(PA_ITEN.COMPOSICAO2) COMPOSICAO2", "MAX(PA_ITEN.COMPOSICAO3) COMPOSICAO3", "PA_ITEN.QTDE_BARRA", "MAX(PA_ITEN.CUSTO) CUSTO", "MAX(PA_ITEN.PRECO_REPOS) PRECO_REPOS",
                        " MAX(PA_ITEN.PRECO_COM) PRECO_COM", "MAX(PA_ITEN.PRECO_VEN) PRECO_VEN"],
                    "where": ["PRODUTO.CODIGO = '${codigo}'"],
                    "innerJoin": [
                        { "tabela": "PA_ITEN", "condicao": "PA_ITEN.CODIGO = PRODUTO.CODIGO" },
                        { "tabela": "CADCOR", "condicao": "PA_ITEN.COR = CADCOR.COR" },
                        { "tabela": "FAIXA_ITEN", "condicao": "PRODUTO.FAIXA = FAIXA_ITEN.FAIXA AND FAIXA_ITEN.TAMANHO = PA_ITEN.TAM" }],
                    "groupby": ["PRODUTO.CODIGO", "PRODUTO.DESCRICAO", "PRODUTO.UNIDADE", "PA_ITEN.TIPO", "PA_ITEN.COR", "CADCOR.DESCRICAO", "PA_ITEN.QTDE_MIN",
                        "PA_ITEN.TAM", "PA_ITEN.BARRA", "PA_ITEN.BARRA28", "PA_ITEN.BARRACLI", "PA_ITEN.ORDEM", "PA_ITEN.QTDE_BARRA",
                        "FAIXA_ITEN.POSICAO", "PA_ITEN.ATIVO"],
                    "orderby": ["PA_ITEN.ORDEM", "PA_ITEN.COR", "FAIXA_ITEN.POSICAO"]
                }`, null, 20000);

                if (!response) {
                    return;
                }

                let jsonStr = await response.json();
                if (response.status != 200) {
                    msgErro(jsonStr.RESULT[0].mensagem);
                    return;
                }

                return jsonStr.RESULT;
            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    }

    async function barraExistente({ barra, codigo }) {
        if (!barra || barra.trim() === ""){
            return 0;
        }
        
        const pesquisa = {
            tabela: "PA_ITEN",
            camposSelect: ["COUNT(CODIGO)"],
            where: [`CODIGO <> '${codigo}' AND ((BARRA28 IN (${barra})) OR (BARRACLI IN (${barra})))`]
        }
        const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));
        
        return jsonStr[0]?.COUNT ?? 0;
    }

    async function barra28Existente({ barra28, codigo }) {
        const pesquisa = {
            tabela: "PA_ITEN",
            camposSelect: ["COUNT(CODIGO)"],
            where: [`CODIGO <> '${codigo}' AND ((BARRA IN (${barra28})) OR (BARRACLI IN (${barra28})))`]
        }
        const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

        return jsonStr[0]?.COUNT
    }

    async function barraCliExistente({ barraCli, codigo }) {
        const pesquisa = {
            tabela: "PA_ITEN",
            camposSelect: ["COUNT(CODIGO)"],
            where: [`CODIGO <> '${codigo}' AND ((BARRA IN (${barraCli})) OR (BARRA28 IN (${barraCli})))`]
        }
        const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

        return jsonStr[0]?.COUNT
    }

    async function validacoesGravarBarra({ barra, barra28, barraCli, codigo }) {
        $.LoadingOverlay('show');
        try {
            const existeBarra = await barraExistente({ barra, codigo });
            if (existeBarra) {
                const continuar = await msgAguardaConfirmacao(
                    `Foi encontrada uma Barra já utilizada em outro produto (nos campos Barra28 ou BarraCli). Deseja continuar mesmo assim?`,
                    async () => true,
                    async () => false
                );
                if (!continuar) throw new Error('Cancelado!');
            }

            const existeBarra28 = await barra28Existente({ barra28, codigo });
            if (existeBarra28) {
                const continuar = await msgAguardaConfirmacao(
                    `Foi encontrada uma Barra28 já utilizada em outro produto (nos campos Barra ou BarraCli). Deseja continuar mesmo assim?`,
                    async () => true,
                    async () => false
                );
                if (!continuar) throw new Error('Cancelado!');
            }

            const existeBarraCli = await barraCliExistente({ barraCli, codigo });
            if (existeBarraCli) {
                const continuar = await msgAguardaConfirmacao(
                    `Foi encontrada uma BarraCli já utilizada em outro produto (nos campos Barra ou Barra28). Deseja continuar mesmo assim?`,
                    async () => true,
                    async () => false
                );
                if (!continuar) throw new Error('Cancelado!');
            }

            return true;
        } catch (error) {
            throw error;
        } finally {
            $.LoadingOverlay('hide');
        }
    }


    // confirma barra
    $('#btnConfirmarBarra').on('click', async function () {
        $.LoadingOverlay('show');
        try {
            let data = $('#tabelaBarra').DataTable().rows().data();
            const url = '/sisplan/barra/v1/gerabarra?';
            let jsonStr;
            let arrayBarra = [];
            let ProdutoBarra = {};

            for (let i = 0; i < data.length; i++) {
                let InfoBarras = {
                    CODIGO: data[i].CODIGO,
                    COR: data[i].COR,
                    TAMANHO: data[i].TAM,
                    BARRAITEN: $('.txtBarraIten')[i].value,
                    BARRA28: $('.txtBarra28')[i].value,
                    BARRA: $('.txtBarracli')[i].value,
                    TIPO: 'P',
                    ESPECIEBARRA: 'BARRACLI',
                    CUSTO: esconderColunasCustoGerarBarras ? data[i]?.CUSTO : parseFloat($('.txtCusto')[i].value).toFixed(2),
                    PRECOREPOS: esconderColunasCustoGerarBarras ? data[i]?.PRECO_REPOS : parseFloat($('.txtPrecoRepos')[i].value).toFixed(2),
                    PRECOCOM: esconderColunasCustoGerarBarras ? data[i]?.PRECO_COM : parseFloat($('.txtPrecoCom')[i].value).toFixed(2),
                    PRECOVEN: esconderColunasCustoGerarBarras ? data[i]?.PRECO_VEN : parseFloat($('.txtPrecoVen')[i].value).toFixed(2),
                };
                arrayBarra.push(InfoBarras);
            };
            ProdutoBarra.TIPOBARRA = 4;
            ProdutoBarra.BARRAS = arrayBarra;

            const barraCli = await formataListas(arrayBarra.map(item => item.BARRA).toString())
            const barra = await formataListas(arrayBarra.map(item => item.BARRAITEN).toString())
            const barra28 = await formataListas(arrayBarra.map(item => item.BARRA28).toString())

            await validacoesGravarBarra({ barra, barra28, barraCli, codigo: $('#txtCodigoProduto').val() });

            const response = await requisicao('POST', url, '', `JSON=${encodeURIComponent(JSON.stringify(ProdutoBarra))}`, 30000);

            if (!response) {
                return;
            };

            if (response.status != 200) {
                jsonStr = await response.json();
                msgAlerta(jsonStr.mensagem);
            }

            await recarregaBarras(guardaLinha);

        } catch (error) {
            msgErro(error);
            console.error(error);
        } finally {
            $.LoadingOverlay('hide');
        }
        $('#modalBarra').modal('hide');
    });
    // gera Ean13
    $('#btnGeraEan13').on('click', async function () {
        try {
            $.LoadingOverlay('show');
            try {
                let data = $('#tabelaBarra').DataTable().rows().data();
                const url = '/sisplan/barra/v1/gerabarra?';
                let jsonStr;
                let arrayBarra = [];
                let ProdutoBarra = {};

                for (let i = 0; i < data.length; i++) {
                    let InfoBarras = {
                        CODIGO: data[i].CODIGO,
                        COR: data[i].COR,
                        TAMANHO: data[i].TAM,
                        BARRA: $($('.txtBarraIten')[i]).val(),
                        TIPO: 'P',
                        ESPECIEBARRA: 'BARRA'
                    };
                    arrayBarra.push(InfoBarras);
                };
                ProdutoBarra.TIPOBARRA = 1;
                ProdutoBarra.BARRAS = arrayBarra;

                const response = await requisicao('POST', url, '', `JSON=${encodeURIComponent(JSON.stringify(ProdutoBarra))}`, 30000);

                if (!response) {
                    return;
                };

                if (response.status != 200) {
                    jsonStr = await response.json();
                    msgAlerta(jsonStr.mensagem);
                }

                await recarregaBarras(guardaLinha);

            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    });
    // gera Barra128
    $('#btnGeraBarra128').on('click', async function () {
        try {
            $.LoadingOverlay('show');
            try {
                let data = $('#tabelaBarra').DataTable().rows().data();
                const url = '/sisplan/barra/v1/gerabarra?';
                let jsonStr;
                let arrayBarra = [];
                let ProdutoBarra = {};

                for (let i = 0; i < data.length; i++) {
                    let InfoBarras = {
                        CODIGO: data[i].CODIGO,
                        COR: data[i].COR,
                        TAMANHO: data[i].TAM,
                        // BARRA: data[i].BARRA28,
                        BARRA: $('.txtBarra28')[i].value,
                        TIPO: 'P',
                        ESPECIEBARRA: 'BARRA28'
                    };
                    arrayBarra.push(InfoBarras);
                };
                ProdutoBarra.TIPOBARRA = 2;
                ProdutoBarra.BARRAS = arrayBarra;

                const response = await requisicao('POST', url, '', `JSON=${encodeURIComponent(JSON.stringify(ProdutoBarra))}`, 30000);

                if (!response) {
                    return;
                };

                if (response.status != 200) {
                    jsonStr = await response.json();
                    msgAlerta(jsonStr.mensagem);
                }

                await recarregaBarras(guardaLinha);

            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    });

    $('#tabelaBarra').on('blur', '.txtBarra28', async function () {
        let barra28 = $(this).val();
        if (barra28 !== '' && (barra28.length < 6 || barra28.length > 9)) {
            msgAlerta("O código de barra28 deve ter entre 6 e 9 dígitos.");
            $(this).val('');
            return;
        }
        await verificaUsoBarra28(barra28)
    });

    async function verificaUsoBarra28(barra28) {
        let url = `/sisplan/funcoes/v1/pesquisa?`;
        try {
            let response = await requisicao(
                "GET",
                url,
                `JSON={ "tabela":"PA_ITEN", "camposSelect":[ "BARRA28", "CODIGO"], "where": ["BARRA28 = '${barra28}'"] }`,
                null
            );

            if (!response) {
                return;
            }

            let jsonStr = await response.json();
            if (response.status != 200) {
                msgErro(jsonStr.RESULT[0].mensagem);
                return;
            }

            if (barra28 !== '' && barra28 !== barra28) {
                msgAlerta(`A barra28: ${barra28}, já está em uso no produto ${jsonStr.RESULT[0][0].CODIGO}!`)
            }

        } catch (error) {
            console.error(error);
            msgErro("Não foi possível buscar os dados dos vencimentos.");
        }
    }

    // gera Dun14
    $('#btnGeraDun14Barra').on('click', async function () {
        try {
            $.LoadingOverlay('show');
            try {
                let data = $('#tabelaBarra').DataTable().rows().data();
                const url = '/sisplan/barra/v1/gerabarra?';
                let jsonStr;
                let arrayBarra = [];
                let ProdutoBarra = {};

                for (let i = 0; i < data.length; i++) {
                    let InfoBarras = {
                        CODIGO: data[i].CODIGO,
                        COR: data[i].COR,
                        TAMANHO: data[i].TAM,
                        BARRA: data[i].BARRACLI,
                        TIPO: 'P',
                        ESPECIEBARRA: 'BARRACLI'
                    };
                    arrayBarra.push(InfoBarras);
                };
                ProdutoBarra.TIPOBARRA = 3;
                ProdutoBarra.BARRAS = arrayBarra;

                const response = await requisicao('POST', url, '', `JSON=${encodeURIComponent(JSON.stringify(ProdutoBarra))}`, 30000);

                if (!response) {
                    return;
                };

                if (response.status != 200) {
                    jsonStr = await response.json();
                    msgAlerta(jsonStr.mensagem);
                }

                await recarregaBarras(guardaLinha);

            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    });

    $("#tabelaCadProduto").on('click', "#btnAnexos", async function () {
        const data = $('#tabelaCadProduto').DataTable().row($(this).parents('tr')).data();

        await abreModalAnexos(data[1], data[4], 'PRODUTO');
    });

    $('#tabelaCadProduto').on('click', '#btnMedidas', async function () {
        const data = $('#tabelaCadProduto').DataTable().row($(this).parents('tr')).data();

        await abreModalMedidas(data[1], data[4]);
    })

    $("#tabelaCadProduto").on('click', "#btnCombProd", async function () {
        const data = $('#tabelaCadProduto').DataTable().row($(this).parents('tr')).data();

        await abreModalCombinacao(data[1], data[4]);
    });

    $("#tabelaCadProduto").on('click', "#btnHistProd", async function () {
        const data = $('#tabelaCadProduto').DataTable().row($(this).parents('tr')).data();

        await abreModalHistProd(data[1], data[4]);
    });

    $("#tabelaCadProduto").on('click', "#btnFluxoProd", async function () {
        const data = $('#tabelaCadProduto').DataTable().row($(this).parents('tr')).data();

        await abreModalFluxoProd(data[1], data[4]);

    });

    $("#tabelaCadProduto").on('click', "#btnProdItensEst", async function () {
        const data = $('#tabelaCadProduto').DataTable().row($(this).parents('tr')).data();

        await abreModalProdItensEst(data[1], data[4]);

    });

    $('#tabelaCadProduto').on('click', '#btnCadConsumo', async function () {
        const data = $('#tabelaCadProduto').DataTable().row($(this).parents('tr')).data();

        await abreCadConsumo(data[1], data[4]);
    });

    $('#tabelaCadProduto').on('click', "#btn-duplicar", async function () {
        if (permissaoUsuarioLogado.ALTERA == 'S') {
            let data = $('#tabelaCadProduto').DataTable().row($(this).parents('tr')).data();
            $('#txtProdutoOriginalDuplicar').val(data[1])
            $('#modalDuplicar').modal('show')
        } else {
            msgAlertaSemConfirmacao("Sem permissão para alterar!");
        }
    });

    $('#tabelaCadProduto').on('click', "#btnImprimirFT", async function () {
        try {
            $.LoadingOverlay("show");
            const data = $('#tabelaCadProduto').DataTable().row($(this).parents('tr')).data();
            const codigoProduto = data[1];
            const coresProd = await consultaCor(codigoProduto);
            const url = `/sisplan/impressao/v1/imprimirft?CODIGO_PROD=${codigoProduto}&CORES_PROD=${coresProd}`;
            const bImprimeAutomatico = await verificaImprimirAutomatico('FichaTecnica');
            let arquivo = await GeraRelatorio(`${url}&`, "GET", 15000, false, 'FichaTecnica');
            if (arquivo != undefined) {
                if (!bImprimeAutomatico) {
                    window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, "_blank");
                }
                await limparRelatorios();
            }
        } finally {
            $.LoadingOverlay("hide");
        }
    });

    $('#tabelaCadProduto').on('click', '#btnPrecoFaccao', async function () {
        if (acessoFaccao.ALTERA == 'S') {
            $.LoadingOverlay('show');
            try {
                const data = $('#tabelaCadProduto').DataTable().row($(this).parents('tr')).data();
                const response = await requisicao('GET',
                    '/Sisplan/Funcoes/V1/pesquisa?',
                    `JSON={ "tabela":"PRO_FLUXO", 
                        "camposSelect":["PRO_FLUXO.PARTE", "TIPO_APL.DESCRICAO"],
                        "leftjoin": [{"tabela": "TIPO_APL", "condicao": "PRO_FLUXO.PARTE = TIPO_APL.CODIGO"}],
                        "where": ["PRO_FLUXO.CODIGO = '${data[1]}'", "TIPO_APL.ATIVO = 'S'"]}`, null);

                if (!response) {
                    return;
                }

                let jsonStr = await response.json();
                if (response.status !== 200) {
                    msgErro(jsonStr.RESULT[0].mensagem);
                    return;
                }
                jsonStr = jsonStr.RESULT[0];

                if (jsonStr.length == 0) {
                    msgErro('Esse produto não possui nenhuma parte. Impossível continuar.');
                    return;
                }

                let tabelaPadrao = await buscaParametroERP('FAC', '310', '3', '3');

                if (tabelaPadrao == '') {
                    tabelaPadrao = (await buscaValor('REGIAO', 'REGIAO', 'PADRAO_PROD', 'S')).REGIAO;
                }

                if (jsonStr.length > 1) {

                    $('#txtTabPadrao').val(tabelaPadrao);
                    $('#txtCodigoFaccao').val(data[1]);

                    $('#txtParte').html('');

                    jsonStr.map((e) => {
                        $('#txtParte').append(`<option class="drilldown-item" value="${e.PARTE}">${e.PARTE} - ${e.DESCRICAO}</option>`);
                    });

                    $('#modalPartes').modal('show');

                } else {
                    $.LoadingOverlay('show');
                    try {
                        window.location.href = `facpreco/${data[1]}#${tabelaPadrao}#${jsonStr[0].PARTE}`;
                    } finally {
                        $.LoadingOverlay('hide');
                    }
                }
            } finally {
                $.LoadingOverlay('hide');
            }
        } else {
            msgAlertaSemConfirmacao("Sem permissão para alterar!");
        }
    });

    $('#tabelaCadProduto').on('click', '#btnItensEstProd', function () {
        const data = $('#tabelaCadProduto').DataTable().row($(this).parents('tr')).data();
        abreProdItensEst(data[1]);
    });

    $('#btnConfirmarPartes').on('click', async function () {
        if ($('#txtParte').val() != '') {
            $.LoadingOverlay('show');
            try {
                window.location.href = `facpreco/${$('#txtCodigoFaccao').val()}#${$('#txtTabPadrao').val()}#${$('#txtParte').val()}`;
            } finally {
                $.LoadingOverlay('hide');
            }
        } else {
            msgErro('Nenhuma parte selecionada, impossível continuar!');
            return;
        }
    });

    $('#btnFecharPartes').on('click', function () {
        $('#modalPartes').modal('hide');
    });

    async function retornaFiltros() {
        const filtros = retornarFiltrosSelecionarTodos()

        const retorno =
            `&ATIVO=${filtros.ativo}` +
            `&CADASTRO_DE=${filtros.dataCadastroDe}` +
            `&CADASTRO_ATE=${filtros.dataCadastroAte}` +
            `&ALTERACAO_DE=${filtros.dataAlteracaoDe}` +
            `&ALTERACAO_ATE=${filtros.dataAlteracaoAte}` +
            `&PRODUTO=${filtros.produto}` +
            `&COLECAO=${filtros.colecao}` +
            `&MARCA=${filtros.marca}` +
            `&GRUPO=${filtros.grupo}` +
            `&LINHA=${filtros.linha}` +
            `&STATUS=${filtros.status}` +
            `&ETIQUETA=${filtros.etiqueta}` +
            `&CLIENTE=${filtros.cliente}` +
            `&CATEGORIA=${filtros.categoria}` +
            `&TIPO_PRODUTO=${filtros.tipoProduto}` +
            `&MODELO=${filtros.modelo}` +
            `&CODIGO_NCM=${filtros.codigoNcm}` +
            `&CST_ICMS=${filtros.cstIcms}` +
            `&IPI_SAIDA=${filtros.ipiSaida}` +
            `&IPI_ENTRADA=${filtros.ipiEntrada}` +
            `&FAIXA=${filtros.faixa}` +
            `&COR=${filtros.cor}` +
            `&TIPO_VENDA=${filtros.tipoVenda}` +
            `&POSSE=${filtros.posse}` +
            `&IMPORTADO=${filtros.importado}`

        return retorno;
    }

    retornaHintRelatorio('btnImprimir', 'RelAcessoProduto')

    async function limpaRelatorioAcessoProd() {
        try {
            try {
                $.LoadingOverlay("show");
                let response = await requisicao(
                    "GET",
                    "/Sisplan/funcoes/v1/limparImpressos?",
                    "",
                    null
                );

                if (!response) {
                    $.LoadingOverlay("hide");
                    return;
                }

                let jsonStr = await response.json();
                if (response.status != 200) {
                    $.LoadingOverlay("hide");
                    return;
                }
            } finally {
                $.LoadingOverlay("hide");
            }
        } catch (error) {
            $.LoadingOverlay("hide");
        }

    }

    retornaHintRelatorio('btnImprimirAcessoProd', 'RelAcessoProduto')
    preencheOrdenacaoTela('RelAcessoProduto')

    $('#btnImprimirAcessoProd').on('click', async function () {
        let str = $('#tabelaCadProduto_info').text();
        str = str.replace('.', '');
        let endIndex = str.indexOf(' registro');

        let contadorRegistros = parseFloat(str.substring(0, endIndex));

        if (parseFloat(contadorRegistros) > 1000) {
            msgAlerta(`Existem ${contadorRegistros} produtos filtrados, a impressão poderá demorar. Deseja Continuar?`, async () =>
                await imprimirAcessoProd()
            )
        } else {
            await imprimirAcessoProd()
        }
    });

    async function imprimirAcessoProd() {
        try {
            $.LoadingOverlay('show');
            try {
                const url = `/sisplan/impressao/v1/imprimiracessoproduto?`;
                const filtros = await retornaFiltros();
                const ordem = `&TELA_ORDENACAO=RelAcessoProduto&ORDEM_ORDENACAO=${$('#txtOrdem').val()}`;
                const bImprimeAutomatico = await verificaImprimirAutomatico('RelAcessoProduto');
                const arquivo = await GeraRelatorio(`${url}${filtros}${ordem}&`, 'GET', 3600000, false, 'RelAcessoProduto');
                if (arquivo != undefined) {
                    if (!bImprimeAutomatico) {
                        window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
                    }
                    await limpaRelatorioAcessoProd();
                }

            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    }

    $("#tabelaCadProduto").off('click', 'th')
    $("#tabelaCadProduto").on('click', 'th', function () {
        if ($(this).index() === 0) return

        switch ($(this).index()) {
            case 1:
                campoOrdenacao = 'PRODUTO.CODIGO'
                break;
            case 2:
                campoOrdenacao = 'PRODUTO.CODIGO2'
                break;
            case 3:
                campoOrdenacao = 'PRODUTO.DESCRICAO'
                break;
            case 5:
                campoOrdenacao = 'PRODUTO.DATA_CAD'
                break
            case 6:
                campoOrdenacao = 'PRODUTO.PRECO'
                break
            default:
                break;
        }

        if ($(this)[0].ariaSort == 'descending') {
            ordenacao = 'DESC'
        } else {
            ordenacao = 'ASC'
        }

        consultaProduto(`${campoOrdenacao} ${ordenacao}`, [$(this).index(), ordenacao.toLowerCase() == 'desc' ? 'asc' : 'desc'])
    })

    let registrosSelecionados = []
    const retornarFiltrosSelecionarTodos = () => {
        const filtrosSessionStorage = sessionStorage.getItem('filtrosConsultasAbasAcesso')
        let filtros = {
            ativo: '',
            dataCadastroDe: '1200-01-01',
            dataCadastroAte: '2500-12-31',
            dataAlteracaoDe: '1200-01-01',
            dataAlteracaoAte: '2500-12-31',
            produto: '',
            colecao: '',
            marca: '',
            grupo: '',
            linha: '',
            status: '',
            etiqueta: '',
            cliente: '',
            categoria: '',
            tipoProduto: '',
            modelo: '',
            codigoNcm: '',
            cstIcms: '',
            ipiSaida: '',
            ipiEntrada: '',
            faixa: '',
            cor: '',
            tipoVenda: '',
            posse: '',
            importado: '',
        }
        if (filtrosSessionStorage) {
            const { produto: filtrosProduto } = JSON.parse(filtrosSessionStorage)
            if (filtrosProduto)
                filtros = filtrosProduto
        }
        return filtros
    }

    $("#tabelaCadProduto").on('change', '.checkSel', function () {
        const linha = $(this).closest('tr')
        const data = $('#tabelaCadProduto').DataTable().rows(linha).data()
        const isChecked = this.checked
        $(linha.toggleClass('selectedCheck', isChecked))

        if (!isChecked)
            registrosSelecionados = registrosSelecionados.filter(e => e.codigo !== data[0][1])
        else
            registrosSelecionados.push({
                codigo: data[0][1]
            })

        $(this).closest('tr').trigger('click');
    })

    function adicionarEventoSelecionarTodos() {
        $('#cbSelAll').off('change')
        $('#cbSelAll').on('change', function () {
            const isChecked = this.checked
            if (!isChecked) {
                registrosSelecionados.length = 0
                $('#tabelaCadProduto').DataTable().draw(false)
                return
            }
            const filtros = retornarFiltrosSelecionarTodos()

            $.LoadingOverlay('show')
            requisicao(
                'POST',
                `/sisplan/produto/v1/retornar_produtos_selecionar_todos_acesso?`,
                '',
                JSON.stringify(filtros),
                3600000
            ).then(async (response) => {
                const data = await response.json()
                if (data) {
                    const { resultado, mensagem } = data
                    if (mensagem?.codigo !== 200) {
                        throw mensagem?.mensagem
                    }

                    if (resultado) {
                        const { itens } = resultado
                        registrosSelecionados = itens || []
                        $('#tabelaCadProduto').DataTable().draw(false)
                        return
                    }
                }
            }).catch((error) => {
                console.error(error)
                msgErro('Ocorreu um erro ao selecionar os registros, tente novamente.')
            }).finally(() => $.LoadingOverlay('hide'))
        })
    }

    componenteFiltro('status', false, false, 'StatusAlterarDados')
    componenteFiltro('grupoPA', false, false, 'GrupoAlterarDados')
    componenteFiltro('marca', false, false, 'MarcaAlterarDados')
    componenteFiltro('etiqueta', false, false, 'EtiquetaAlterarDados')
    componenteFiltro('entidade', false, false, 'CodigoClienteAlterarDados')
    componenteFiltro('linha', false, false, 'LinhaAlterarDados')
    componenteFiltro('colecao', false, false, 'ColecaoAlterarDados')
    componenteFiltro('auxiliar', false, false, 'CategoriaAlterarDados')
    componenteFiltro('tipoProduto', false, false, 'TipoProdutoAlterarDados')
    componenteFiltro('modelo', false, false, 'ModeloAlterarDados')
    componenteFiltro('ncm', false, false, 'CodigoNcmAlterarDados')
    componenteFiltro('cstIcms', false, false, 'CstIcmsAlterarDados')
    componenteFiltro('cstIpi', false, false, 'CstIpiSaidaAlterarDados')
    componenteFiltro('cstIpi', false, false, 'CstIpiEntradaAlterarDados')

    $('#btnConfirmarAlterarDados').on('click', () => msgAlerta(
        'Deseja atualizar os dados de todos os registros selecionados?',
        () => null,
        () => null,
        () => confirmarAlterarDados(),
    ))

    const confirmarAlterarDados = async () => {
        const dadosAlteracao = retornarDadosAlteracao()
        if (!dadosAlteracao) return
        alterarDados(dadosAlteracao).then((resultado) => {
            if (!resultado || resultado !== 'OK') return
            $('#btnConsultar').trigger('click')

            toastr.success("Dados gravados com sucesso!", "Confirmação", {
                toastClass: "alert",
                iconClasses: {
                    error: "alert-error",
                    info: "alert-info",
                    success: "alert-success",
                    warning: "alert-warning",
                },
                positionClass: "toast-top-center",
                progressBar: true,
                timeOut: 1000,
                fadeOut: 1000,
                onHidden() {
                    $('#modalAlterarDadosEmMassa').modal('hide')
                },
            }).css({
                "margin-top": "20%",
                width: "500px",
                "max-width": "500px",
            })
        }).catch((error) => {
            console.error(error)
            msgErro('Ocorreu um erro ao gravar os dados, tente novamente.')
        })
    }

    const retornarDadosAlteracao = () => {
        const descricao = $('#txtDescricaoAlterarDados').val()
        const regex = /^[a-zA-ZÀ-ÿ0-9&@#\.,\(\)\-\s]+$/;
        const valido = regex.test(descricao)
        if (descricao && !valido) {
            msgErro(
                'Descrição não pode conter caracteres especiais, impossível continuar.',
                () => $('#txtDescricaoAlterarDados').focus(),
                () => $('#txtDescricaoAlterarDados').focus(),
            )
            return
        }
        const codigo2 = $('#txtCodigo2AlterarDados').val()
        const descricao2 = $('#txtDescricao2AlterarDados').val()
        const status = pegaChave('#txtStatusAlterarDados')
        const grupo = pegaChave('#txtGrupoAlterarDados')
        const marca = pegaChave('#txtMarcaAlterarDados')
        const etiqueta = pegaChave('#txtEtiquetaAlterarDados')
        const codigoCliente = pegaChave('#txtCodigoClienteAlterarDados')
        const linha = pegaChave('#txtLinhaAlterarDados')
        const colecao = pegaChave('#txtColecaoAlterarDados')
        const categoria = pegaChave('#txtCategoriaAlterarDados')
        const tipoProduto = pegaChave('#txtTipoProdutoAlterarDados')
        const modelo = pegaChave('#txtModeloAlterarDados')
        const codigoNcm = pegaChave('#txtCodigoNcmAlterarDados')
        const cstIcms = pegaChave('#txtCstIcmsAlterarDados')
        const cstIpiSaida = pegaChave('#txtCstIpiSaidaAlterarDados')
        const cstIpiEntrada = pegaChave('#txtCstIpiEntradaAlterarDados')
        const posse = $('#selectPosseAlterarDados').val()
        const importado = $('#selectImportadoAlterarDados').val()
        const ativo = $('#selectAtivoAlterarDados').val()

        const dadosAlteracao = {
            codigo2,
            descricao,
            descricao2,
            status,
            grupo,
            marca,
            etiqueta,
            codigoCliente,
            linha,
            colecao,
            categoria,
            tipoProduto,
            modelo,
            codigoNcm,
            cstIcms,
            cstIpiSaida,
            cstIpiEntrada,
            posse,
            importado,
            ativo,
        }

        const produtosAlteracao = registrosSelecionados

        return {
            dadosAlteracao,
            produtosAlteracao,
        }
    }

    const alterarDados = async (dados) => {
        try {
            $.LoadingOverlay('show')
            const response = await requisicao(
                'POST',
                `/sisplan/produto/v1/alterar_dados_produtos_em_massa?`,
                '',
                JSON.stringify(dados),
                3600000
            )

            const json = await response.json()

            if (json) {
                const { resultado, mensagem } = json
                if (mensagem?.codigo !== 200) {
                    throw mensagem?.mensagem
                }

                return resultado
            }
        } finally {
            $.LoadingOverlay('hide')
        }
    }

    $('#btnAlterarDadosEmMassa').on('click', () => {
        if (registrosSelecionados?.length > 0)
            $('#modalAlterarDadosEmMassa').modal('show')
        else
            msgErro('Nenhum registro selecionado, impossível continuar.')
    })
    $('#modalAlterarDadosEmMassa').on('hide.bs.modal', () => $('.campoAlterarDadosEmMassa').val(''))
    $('#btnLimparCamposAlterarDados').on('click', () => $('.campoAlterarDadosEmMassa').val(''))

    componenteFiltro('produto', true, true, 'ProdutoUtilizacao')
    componenteFiltro('colecao', true, true, 'ColecaoUtilizacao')
    componenteFiltro('marca', true, true, 'MarcaUtilizacao')
    componenteFiltro('grupoPA', true, true, 'GrupoUtilizacao')
    componenteFiltro('linha', true, true, 'LinhaUtilizacao')
    componenteFiltro('status', true, true, 'StatusUtilizacao')
    componenteFiltro('etiqueta', true, true, 'EtiquetaUtilizacao')
    componenteFiltro('modelo', true, true, 'ModeloUtilizacao')
    componenteFiltro('cor', true, true, 'CorUtilizacao')

    $('#btnUtilizacao').on('click', () => carregarModalUtilizacao())

    const carregarModalUtilizacao = () => {
        $('#modalUtilizacao').modal('show')
        if (registrosSelecionados.length > 0) {
            $('#modalUtilizacao').on('shown.bs.modal', function () {
                $('#tabelaItensUtilizacao').DataTable().columns.adjust().draw()
                $('#tabelaProdutosUtilizacao').DataTable().columns.adjust().draw()
                $('#tabelaCoresUtilizacao').DataTable().columns.adjust().draw()
            })
            const filtros = {
                produtos: registrosSelecionados.map((e) => `'${e.codigo}'`).join(',')
            }
            retornarUtilizacaoProdutosSelecionados(filtros)
        }
    }

    $('#modalUtilizacao').on('hide.bs.modal', () => {
        if ($.fn.DataTable.isDataTable('#tabelaItensUtilizacao')) {
            $('#tabelaItensUtilizacao').DataTable().destroy()
            $('#tabelaItensUtilizacao').empty()
        }

        if ($.fn.DataTable.isDataTable('#tabelaProdutosUtilizacao')) {
            $('#tabelaProdutosUtilizacao').DataTable().destroy()
            $('#tabelaProdutosUtilizacao').empty()
        }

        if ($.fn.DataTable.isDataTable('#tabelaCoresUtilizacao')) {
            $('#tabelaCoresUtilizacao').DataTable().destroy()
            $('#tabelaCoresUtilizacao').empty()
        }
        limparFiltrosUtilizacao()
        $('#modalUtilizacao').off('shown.bs.modal')
    })

    $('#btnConsultarUtilizacao').on('click', () => consultarUtilizacao())

    const consultarUtilizacao = () => {
        retornarFiltrosUtilizacao().then((filtros) => filtros && retornarDadosUtilizacao(filtros))
    }

    const retornarFiltrosUtilizacao = async () => {
        const filtros = {
            produtos: await formataListas($('#txtProdutoUtilizacao').val().toString()),
            colecoes: await formataListas($('#txtColecaoUtilizacao').val().toString()),
            marcas: await formataListas($('#txtMarcaUtilizacao').val().toString()),
            grupos: await formataListas($('#txtGrupoUtilizacao').val().toString()),
            linhas: await formataListas($('#txtLinhaUtilizacao').val().toString()),
            status: await formataListas($('#txtStatusUtilizacao').val().toString()),
            etiquetas: await formataListas($('#txtEtiquetaUtilizacao').val().toString()),
            modelos: await formataListas($('#txtModeloUtilizacao').val().toString()),
            cores: await formataListas($('#txtCorUtilizacao').val().toString()),
            situacao: $('#selectSituacaoUtilizacao').val(),
            situacaoCor: $('#selectSituacaoCorUtilizacao').val(),
        }

        return filtros
    }

    const retornarDadosUtilizacao = (filtros) => {
        $.LoadingOverlay('show')
        requisicao(
            'POST',
            `/sisplan/produto/v1/retornar_dados_utilizacao?`,
            '',
            JSON.stringify(filtros),
            3600000
        ).then(async (response) => {
            const dados = await response.json()
            if (dados) {
                const { resultado, mensagem } = dados
                if (mensagem?.codigo !== 200) {
                    throw mensagem?.mensagem
                }

                if (!resultado) return
                const { itens, produtos, cores } = resultado

                if (!itens || !itens.length) {
                    msgErro('Nenhum item encontrado.')
                }

                criarTabelaItensUtilizacao(itens ?? [])
                criarTabelaProdutosUtilizacao(produtos ?? [])
                criarTabelaCoresUtilizacao(cores ?? [])
            }
        }).catch((error) => {
            console.error(error)
            msgErro('Ocorreu um erro ao buscar os dados.')
        }).finally(() => $.LoadingOverlay('hide'))
    }

    const retornarDadosItemUtilizacao = (insumo, situacaoCor) => {
        $.LoadingOverlay('show')
        requisicao(
            'GET',
            `/sisplan/produto/v1/retornar_dados_item_utilizacao?`,
            `INSUMO=${encodeURIComponent(insumo)}&SITUACAO_COR=${encodeURIComponent(situacaoCor)}`,
            '',
            3600000
        ).then(async (response) => {
            const dados = await response.json()
            if (dados) {
                const { resultado, mensagem } = dados
                if (mensagem?.codigo !== 200) {
                    throw mensagem?.mensagem
                }

                if (!resultado) return
                const { produtos, cores } = resultado

                if (!produtos || !produtos.length) {
                    msgErro('Nenhum produto encontrado.')
                }

                criarTabelaProdutosUtilizacao(produtos ?? [])
                criarTabelaCoresUtilizacao(cores ?? [])
            }
        }).catch((error) => {
            console.error(error)
            msgErro('Ocorreu um erro ao buscar os dados.')
        }).finally(() => $.LoadingOverlay('hide'))
    }

    const retornarDadosProdutoUtilizacao = (insumo, produto, situacaoCor) => {
        $.LoadingOverlay('show')
        requisicao(
            'GET',
            `/sisplan/produto/v1/retornar_dados_produto_utilizacao?`,
            `INSUMO=${encodeURIComponent(insumo)}&PRODUTO=${encodeURIComponent(produto)}&SITUACAO_COR=${encodeURIComponent(situacaoCor)}`,
            '',
            3600000
        ).then(async (response) => {
            const dados = await response.json()
            if (dados) {
                const { resultado, mensagem } = dados
                if (mensagem?.codigo !== 200) {
                    throw mensagem?.mensagem
                }

                if (!resultado) return
                const { cores } = resultado

                if (!cores || !cores.length) {
                    msgErro('Nenhuma cor encontrada.')
                }

                criarTabelaCoresUtilizacao(cores ?? [])
            }
        }).catch((error) => {
            console.error(error)
            msgErro('Ocorreu um erro ao buscar os dados.')
        }).finally(() => $.LoadingOverlay('hide'))
    }

    const criarTabelaItensUtilizacao = (data) => {
        if ($.fn.DataTable.isDataTable('#tabelaItensUtilizacao')) {
            $('#tabelaItensUtilizacao').DataTable().destroy()
            $('#tabelaItensUtilizacao').empty()
        }

        const columns = [
            {
                data: 'codigo',
                title: 'Código',
            },
            {
                data: 'descricao',
                title: 'Descrição',
            },
        ]

        const table = $('#tabelaItensUtilizacao').DataTable({
            sort: false,
            paging: false,
            destroy: true,
            lengthChange: false,
            filter: false,
            info: false,
            ordering: false,
            sorting: false,
            order: false,

            autoWidth: true,
            data,
            columns,
            scrollX: true,
            scrollY: '150px',
            select: {
                style: 'single',
                toggleable: false,
            },
        })
        table.off('select')
        $('#tabelaItensUtilizacao').DataTable().row(':first').select()

        table.on('select', function (_e, _dt, type, indexes) {
            if (type === 'row') {
                const data = table.rows(indexes[0]).data().toArray()
                const situacaoCor = $('#selectSituacaoCorUtilizacao').val()
                retornarDadosItemUtilizacao(data[0]?.codigo, situacaoCor)
            }
        })
    }

    const criarTabelaProdutosUtilizacao = (data) => {
        if ($.fn.DataTable.isDataTable('#tabelaProdutosUtilizacao')) {
            $('#tabelaProdutosUtilizacao').DataTable().destroy()
            $('#tabelaProdutosUtilizacao').empty()
        }

        const columns = [
            {
                data: 'codigo',
                title: 'Código',
            },
            {
                data: 'descricao',
                title: 'Descrição',
            },
            {
                data: 'consumoUnitario',
                title: 'Consumo Unitário',
                render: function (data) {
                    if (!data) {
                        return parseFloat(0).toLocaleString("pt-br", {
                            maximumFractionDigits: 6,
                            minimumFractionDigits: 6,
                        })
                    }
                    return parseFloat(data).toLocaleString("pt-br", {
                        maximumFractionDigits: 6,
                        minimumFractionDigits: 6,
                    })
                },
                className: 'text-right pr-2'
            },
            {
                data: 'ativo',
                title: 'Ativo',
            },
            {
                data: 'codigo2',
                title: 'Código 2',
            },
            {
                data: 'colecao',
                title: 'Coleção',
            },
            {
                data: 'descricaoColecao',
                title: 'Descrição Coleção',
            },
            {
                data: 'tipo',
                title: 'Tipo',
            },
            {
                data: 'linha',
                title: 'Linha',
            },
            {
                data: 'descricaoLinha',
                title: 'Descrição Linha',
            },
            {
                data: 'dataCadastroProduto',
                title: 'Data Cadastro Produto',
                type: 'date-br',
                render(data) {
                    return new Intl.DateTimeFormat('pt-BR').format(new Date(`${data.split('T')[0]} 23:59:59`));
                }
            },
        ]

        const table = $('#tabelaProdutosUtilizacao').DataTable({
            sort: false,
            paging: false,
            destroy: true,
            lengthChange: false,
            filter: false,
            info: false,
            ordering: false,
            sorting: false,
            order: false,
            autoWidth: true,
            data,
            columns,
            scrollX: true,
            scrollY: '125px',
            select: {
                style: 'single',
                toggleable: false,
            },
        })
        table.off('select')
        $('#tabelaProdutosUtilizacao').DataTable().row(':first').select()

        table.on('select', function (_e, _dt, type, indexes) {
            if (type === 'row') {
                const data = table.rows(indexes[0]).data().toArray()
                const situacaoCor = $('#selectSituacaoCorUtilizacao').val()
                const datatableItens = $('#tabelaItensUtilizacao').DataTable()
                const [selectedRowIndex] = datatableItens?.rows({ selected: true }).indexes().toArray()
                const insumo = datatableItens?.row(selectedRowIndex).data()?.codigo || ''
                retornarDadosProdutoUtilizacao(insumo, data[0]?.codigo, situacaoCor)
            }
        })
    }

    const criarTabelaCoresUtilizacao = (data) => {
        if ($.fn.DataTable.isDataTable('#tabelaCoresUtilizacao')) {
            $('#tabelaCoresUtilizacao').DataTable().destroy()
            $('#tabelaCoresUtilizacao').empty()
        }

        const columns = [
            {
                data: 'codigo',
                title: 'Código',
            },
            {
                data: 'cor',
                title: 'Cor',
            },
            {
                data: 'descricaoCor',
                title: 'Descrição Cor',
            },
        ]

        $('#tabelaCoresUtilizacao').DataTable({
            sort: false,
            paging: false,
            destroy: true,
            lengthChange: false,
            filter: false,
            info: false,
            ordering: false,
            sorting: false,
            order: false,
            autoWidth: true,
            data,
            columns,
            scrollX: true,
            scrollY: '150px',
        })
    }

    $('#btnLimparFiltrosUtilizacao').on('click', () => {
        limparFiltrosUtilizacao()
    })

    const limparFiltrosUtilizacao = () => {
        $('#txtProdutoUtilizacao').empty().trigger('change')
        $('#txtColecaoUtilizacao').empty().trigger('change')
        $('#txtMarcaUtilizacao').empty().trigger('change')
        $('#txtGrupoUtilizacao').empty().trigger('change')
        $('#txtLinhaUtilizacao').empty().trigger('change')
        $('#txtStatusUtilizacao').empty().trigger('change')
        $('#txtEtiquetaUtilizacao').empty().trigger('change')
        $('#txtModeloUtilizacao').empty().trigger('change')
        $('#txtCorUtilizacao').empty().trigger('change')
        $('#selectSituacaoUtilizacao').val('')
        $('#selectSituacaoCorUtilizacao').val('')
    }

    const retornarUtilizacaoProdutosSelecionados = (filtros) => {
        $.LoadingOverlay('show')
        requisicao(
            'POST',
            `/sisplan/produto/v1/retornar_dados_utilizacao_produtos_selecionados?`,
            '',
            JSON.stringify(filtros),
            3600000
        ).then(async (response) => {
            const dados = await response.json()
            if (dados) {
                const { resultado, mensagem } = dados
                if (mensagem?.codigo !== 200) {
                    throw mensagem?.mensagem
                }

                if (!resultado) return
                const { itens, produtos, cores, produtosSelecionados } = resultado

                produtosSelecionados.forEach((item) => adicionaValorPadraoVarios('produtoUtilizacao', item.codigo, item.descricao))

                if (!itens || !itens.length) {
                    msgErro('Nenhum item encontrado.')
                }

                criarTabelaItensUtilizacao(itens ?? [])
                criarTabelaProdutosUtilizacao(produtos ?? [])
                criarTabelaCoresUtilizacao(cores ?? [])
            }
        }).catch((error) => {
            console.error(error)
            msgErro('Ocorreu um erro ao buscar os dados.')
        }).finally(() => $.LoadingOverlay('hide'))
    }

    let codigoNovoProduto
    $('#modalDuplicar').on('show.bs.modal', async function () {
        codigoNovoProduto = await RetornaProximo('PRODUTO', 'PRODUTO', 'CODIGO', 6)
        $('#txtProdutoDuplicar').val(codigoNovoProduto);
        $('#txtProdutoDuplicar').focus();

        const { codFaixa, descricao } = await buscaFaixaTamanho($("#txtProdutoOriginalDuplicar").val());
        insereValor("#txtFaixaTam", codFaixa, descricao);
    })

    async function buscaFaixaTamanho(codProduto) {
        const pesquisaFaixaTamanho = {
            camposSelect: [
                "PRODUTO.FAIXA",
                "FAIXA.DESCRICAO"
            ],
            tabela: "PRODUTO",
            leftJoin: [
                { tabela: 'FAIXA', condicao: 'FAIXA.CODIGO=PRODUTO.FAIXA' },
            ],
            where: [`PRODUTO.CODIGO = '${codProduto}'`],
        }
        const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaFaixaTamanho));
        return { codFaixa: jsonStr[0].FAIXA, descricao: jsonStr[0].DESCRICAO };
    }

    // $('#txtProdutoDuplicar').on('focusout', async function () {

    // })

    async function validacaoCodigoProduto() {
        const codigoInput = $('#txtProdutoDuplicar').val();
        if (codigoInput != '') {
            await baixaCodigo('PRODUTO', 'CODIGO', codigoNovoProduto);
            codigoNovoProduto = $('#txtProdutoDuplicar').val();
            const bProduto = await Existe('PRODUTO', ['CODIGO'], [codigoInput]);
            const bMaterial = await Existe('MATERIAL', ['CODIGO'], [codigoInput]);
            const bServico = await Existe('SERVICO', ['CODIGO'], [codigoInput]);
            if (bProduto || bMaterial || bServico) {
                const tabela = bProduto ? 'produto' : bMaterial ? 'material' : bServico ? 'serviço' : '';
                msgAlerta(`Já existe um ${tabela} cadastrado com o código ${codigoInput}, necessário informar outro código.`);
                $('#txtProdutoDuplicar').val('');
                $('#txtProdutoDuplicar').focus();
            }
        } else {
            if (codigoNovoProduto) {
                baixaCodigo('PRODUTO', 'CODIGO', codigoNovoProduto).then(() => {
                    RetornaProximo('PRODUTO', 'PRODUTO', 'CODIGO', 6).then((codigo) => {
                        codigoNovoProduto = codigo;
                        $('#txtProdutoDuplicar').val(codigoNovoProduto);
                    });
                });
                return;
            }
            codigoNovoProduto = await RetornaProximo('PRODUTO', 'PRODUTO', 'CODIGO', 6);
            $('#txtProdutoDuplicar').val(codigoNovoProduto);
        }
        return true;
    }

    $('#txtProdutoDuplicar').on('input', function () {
        const valor = $(this).val();
        $(this).val(valor.replace(/[\\/:*?"<>|,']/g, ''));
    });

    $('#btnConfirmarDuplicar').on('click', async () => {
        if (!await validacaoCodigoProduto()) {
            return;
        };
        const codigoNovo = $('#txtProdutoDuplicar').val()
        const codigoOriginal = $('#txtProdutoOriginalDuplicar').val()
        if (!codigoNovo) return
        const codigoFaixaNova = pegaChave("#txtFaixaTam");
        if (!codigoFaixaNova) {
            msgAlerta("Informe a faixa de tamanho.");
            return;
        }
        await duplicaCadastroProduto({ codigoOriginal, codigoNovo, codigoFaixaNova })
    })

    async function buscaFoto(codigo) {
        try {
            if (!codigo) {
                $("#infoimagem").attr('src', `${BASE_URI}/dist/img/prod-1.png`)
                return
            }

            let urlRequisicao = '/Sisplan/Funcoes/v1/FotoItem?';
            let response = await requisicao('GET', urlRequisicao, `codigo=${codigo}`, null);

            if (!response) {
                return;
            }
            let jsonStr = await response.json();
            if (response.status !== 200) {
                $("#infoimagem").attr('src', `${BASE_URI}/dist/img/prod-1.png`);
                return;
            }

            let sBase64 = jsonStr.mensagem;

            let extension = "png";
            let contentType = response.headers.get('content-type');
            if (contentType && contentType.indexOf('image/') === 0) {
                extension = contentType.replace('image/', '');
            }

            if (extension === "png") {
                $("#infoimagem").attr('src', `data:image/png;base64,${sBase64}`);
            } else {
                let jpegBase64 = await convertToJPEG(sBase64);
                $("#infoimagem").attr('src', `data:image/jpg;base64,${jpegBase64}`);
            }

        } catch (error) {
            console.error(error);
            $("#infoimagem").attr('src', `${BASE_URI}/dist/img/prod-1.png`);
        }
    }
})
