$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false
    })
    driver.defineSteps([
      {
        element: "#tutorial-step1",
        popover: {
          title: "Campos",
          description:
            "Aqui se encontram os campos essenciais para consultar e gravar as informações.",
          position: "bottom",
        },
      },
      {
        element: '#btnVoltar',
        popover: {
          title: 'Voltar',
          description: 'Aqui está o botão para voltar à consulta.',
          position: 'bottom'
        }
      },
      {
        element: '#btnGravar',
        popover: {
          title: 'Gravar',
          description: 'Aqui está o botão para gravar as informações.',
          position: 'bottom'
        }
      }
    ])
    driver.start()
  })
})

$(document).ready(async function () {
  const url = window.location.href
  const id = url.split('/')[url.split('/').length - 1]

  if (id && id !== 'create') {
    carregarCadastro(id)
  } else {
  }

  $('.integerFormat').maskMoney({
    thousands: "",
    precision: 0,
  })

  $('.quatroCasasDecimaisQuantityFormat').maskMoney({
    decimal: ".",
    thousands: "",
    precision: 4,
  })

  $('.duasCasasDecimaisCurrencyFormat').maskMoney({
    decimal: ",",
    thousands: "",
    precision: 2,
  })

  $('.tresCasasDecimaisCurrencyFormat').maskMoney({
    decimal: ",",
    thousands: "",
    precision: 3,
  })

  $('.quatroCasasDecimaisCurrencyFormat').maskMoney({
    decimal: ",",
    thousands: "",
    precision: 4,
  })

  componenteFiltro('parte', false, false)
  componenteFiltro('maquina', false, false, 'Maquina', [`ATIVO = 'S'`])

  // $('#selectTipo').on('change', function () {
  //   if (this.value === 'Micro-Operações') $('#tabMicroOperacoes').removeClass('d-none')
  //   else $('#tabMicroOperacoes').addClass('d-none')
  // })

  function criarTabelaMicroOperacoes(data) {
    if ($.fn.DataTable.isDataTable('#tabelaMicroOperacoes')) {
      $('#tabelaMicroOperacoes').DataTable().destroy()
      $('#tabelaMicroOperacoes').empty()
    }

    function retornarBotaoOpcoes(data) {
      const retorno = '<div style="text-align:start;"> ' +
        '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" id="tutorialTabela" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
        '      ' + data + ' ' +
        '    </button> ' +
        '    <div class="dropdown-menu"> ' +
        '    <button class="dropdown-item" type="button" title="Alterar" id="btnAlterar">Alterar</button>     ' +
        '</div>'
      return retorno
    }

    const columns = [
      {
        data: 'ordem',
        title: 'Ordem',
        render: function (data) {
          return '<div style="text-align:start;"> ' +
            '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" id="tutorialTabela" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
            '      ' + data + ' ' +
            '    </button> ' +
            '    <div class="dropdown-menu"> ' +
            '    <button class="dropdown-item" type="button" title="Alterar" id="btnAlterar">Alterar</button>     ' +
            '</div>'
        }
      },
      {
        data: 'operacao',
        title: 'Operação',
      },
      {
        data: 'descricao',
        title: 'Descrição',
      },
      {
        data: 'usarMaquina',
        title: 'Usar Máquina',
      },
      {
        data: 'tempo',
        title: 'Tempo',
        render: function (data) {
          if (!data) {
            return parseFloat(0).toLocaleString("pt-br", {
              maximumFractionDigits: 4,
              minimumFractionDigits: 4,
            })
          }
          return parseFloat(data).toLocaleString("pt-br", {
            maximumFractionDigits: 4,
            minimumFractionDigits: 4,
          })
        },
        className: 'text-right',
      },
      {
        data: 'quantidade',
        title: 'Quantidade',
        render: function (data) {
          if (!data) {
            return parseFloat(0).toLocaleString("pt-br", {
              maximumFractionDigits: 4,
              minimumFractionDigits: 4,
            })
          }
          return parseFloat(data).toLocaleString("pt-br", {
            maximumFractionDigits: 4,
            minimumFractionDigits: 4,
          })
        },
        className: 'text-right',
      },
      {
        data: 'frequencia',
        title: 'Frequência',
        render: function (data) {
          if (!data) {
            return parseFloat(0).toLocaleString("pt-br", {
              maximumFractionDigits: 4,
              minimumFractionDigits: 4,
            })
          }
          return parseFloat(data).toLocaleString("pt-br", {
            maximumFractionDigits: 4,
            minimumFractionDigits: 4,
          })
        },
        className: 'text-right',
      },
      {
        data: 'tempoTotal',
        title: 'Tempo Total',
        render: function (data) {
          if (!data) {
            return parseFloat(0).toLocaleString("pt-br", {
              maximumFractionDigits: 4,
              minimumFractionDigits: 4,
            })
          }
          return parseFloat(data).toLocaleString("pt-br", {
            maximumFractionDigits: 4,
            minimumFractionDigits: 4,
          })
        },
        className: 'text-right',
      },
    ]

    $('#tabelaMicroOperacoes').DataTable({
      sort: false,
      paging: false,
      destroy: true,
      lengthChange: false,
      filter: false,
      info: false,
      ordering: false,
      sorting: false,
      order: false,
      autoWidth: true,
      data,
      columns,
      scrollCollapse: true,
      select: {
        style: 'single',
        toggleable: false,
      },
    })
  }

  function carregarCadastro(codigoOperacao) {
    $.LoadingOverlay('show')
    buscarDadosCadastro(codigoOperacao).then(({ capa }) => {
      if (capa) preencherDadosCapa(capa)
      // criarTabelaMicroOperacoes(microOperacoes ?? [])
    }).catch((error) => {
      console.error(error)
      msgErro('Ocorreu um erro ao buscar os dados.')
    }).finally(() => $.LoadingOverlay('hide'))
  }

  async function buscarDadosCadastro(codigo) {
    const filtros = encodeURIComponent(JSON.stringify({ codigo }))
    const response = await requisicao("GET", `/sisplan/operacaotempos/v1/retornardadoscadastro?`, `&FILTROS=${filtros}`, '', 3600000)

    const json = await response.json()

    if (json) {
      const { resultado, mensagem } = json
      if (mensagem?.codigo !== 200) {
        throw mensagem?.mensagem
      }

      return resultado
    }
  }

  function preencherDadosCapa(data) {
    $('#cbAtivo1').prop('checked', data.ativo === 'S')
    $('#cbGerarKanban').prop('checked', data.gerarKanban === 'S')
    $('#cbApontamentoProducao').prop('checked', data.apontamento === 'S')
    insereValor('#txtCodigo', data.codigo)
    insereValor('#txtDescricao', data.descricao)
    insereValor('#txtParte', data.parte, data.descricaoParte)
    insereValor('#txtMaquina', data.maquina, data.descricaoMaquina)
    $('#selectTipo').val(data.tipo)
    insereValor('#txtAlteracao', String(data.alteracao).substring(0, 10))
    insereValor('#txtObservacao', data.observacao)
    insereValor('#txtComplemento', data.complemento)
    insereValor('#txtRotacao', data.rotacao ?? 0)
    insereValor('#txtTempoHora', data.tempoHora)
    insereValor('#txtInterferencia', parseFloat(data.interferencia ?? 0).toLocaleString("pt-br", {
      maximumFractionDigits: 2,
      minimumFractionDigits: 2,
    }))
    insereValor('#txtConcessoes', parseFloat(data.concessoes ?? 0).toLocaleString("pt-br", {
      maximumFractionDigits: 2,
      minimumFractionDigits: 2,
    }))
    insereValor('#txtValor', parseFloat(data.valor ?? 0).toLocaleString("pt-br", {
      maximumFractionDigits: 3,
      minimumFractionDigits: 3,
    }))
    insereValor('#txtTempo', parseFloat(data.tempo ?? 0).toLocaleString("pt-br", {
      maximumFractionDigits: 4,
      minimumFractionDigits: 4,
    }))
    insereValor('#txtTempoTotal', parseFloat(data.tempoTotal ?? 0).toLocaleString("pt-br", {
      maximumFractionDigits: 4,
      minimumFractionDigits: 4,
    }))
    insereValor('#txtComprimento', parseFloat(data.comprimento ?? 0).toLocaleString("pt-br", {
      maximumFractionDigits: 2,
      minimumFractionDigits: 2,
    }))
    insereValor('#txtQuantidade', data.quantidade ?? 0)
  }

  $('#txtTempoHora').mask('00:00:00')

  $('#btnGravar').on('click', function () {
    const data = retornarDadosGravar()
    if (validarDadosGravar(data)) {
      $.LoadingOverlay('show')
      gravarDados(data).then(() => {
        toastr.success("Dados gravados com sucesso!", "Confirmação", {
          toastClass: "alert",
          iconClasses: {
            error: "alert-error",
            info: "alert-info",
            success: "alert-success",
            warning: "alert-warning",
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 1000,
          fadeOut: 1000,
          onHidden() {
            window.location.href = `${BASE_URI}/operacao_tempos`
          },
        }).css({
          "margin-top": "20%",
          width: "500px",
          "max-width": "500px",
        })
      }).catch((error) => {
        console.error(error)
        msgErro('Ocorreu um erro ao gravar os dados.')
      }).finally(() => $.LoadingOverlay('hide'))
    }
  })

  function retornarDadosGravar() {
    const ativo = $('#cbAtivo1').prop('checked') ? 'S' : 'N'
    const gerarKanban = $('#cbGerarKanban').prop('checked') ? 'S' : 'N'
    const apontamento = $('#cbApontamentoProducao').prop('checked') ? 'S' : 'N'
    const codigo = $('#txtCodigo').val()
    const descricao = $('#txtDescricao').val()
    const parte = pegaChave('#txtParte')
    const maquina = pegaChave('#txtMaquina')
    const tipo = $('#selectTipo').val()
    const alteracao = $('#txtAlteracao').val() || formataData(new Date())
    const observacao = $('#txtObservacao').val()
    const complemento = $('#txtComplemento').val()
    const rotacao = $('#txtRotacao').val()
    const tempoHora = $('#txtTempoHora').val() || '00:00:00'
    let aux = parseFloat(String($('#txtInterferencia').val()).replace(',', '.'))
    const interferencia = isNaN(aux) ? 0 : aux ?? 0
    aux = parseFloat(String($('#txtConcessoes').val()).replace(',', '.'))
    const concessoes = isNaN(aux) ? 0 : aux ?? 0
    aux = parseFloat(String($('#txtValor').val()).replace(',', '.'))
    const valor = isNaN(aux) ? 0 : aux ?? 0
    aux = parseFloat(String($('#txtTempo').val()).replace(',', '.'))
    const tempo = isNaN(aux) ? 0 : aux ?? 0
    aux = parseFloat(String($('#txtTempoTotal').val()).replace(',', '.'))
    const tempoTotal = isNaN(aux) ? 0 : aux ?? 0
    aux = parseFloat(String($('#txtComprimento').val()).replace(',', '.'))
    const comprimento = isNaN(aux) ? 0 : aux ?? 0
    const quantidade = $('#txtQuantidade').val()

    return {
      ativo,
      gerarKanban,
      apontamento,
      codigo,
      descricao,
      parte,
      maquina,
      tipo,
      alteracao,
      observacao,
      complemento,
      rotacao,
      tempoHora,
      interferencia,
      concessoes,
      valor,
      tempo,
      tempoTotal,
      comprimento,
      quantidade,
    }
  }

  function validarDadosGravar(data) {
    if (!data) return false

    if (!data.codigo) {
      msgErro('Código não informado, impossível continuar.')
      return false
    }

    if (!data.descricao) {
      msgErro('Descrição não informada, impossível continuar.')
      return false
    }

    if (!data.maquina) {
      msgErro('Máquina não informada, impossível continuar.')
      return false
    }

    if (!data.parte) {
      msgErro('Parte não informada, impossível continuar.')
      return false
    }

    return true
  }

  async function gravarDados(data) {
    const response = await requisicao("POST", `/sisplan/operacaotempos/v1/gravar?`, '', JSON.stringify(data), 3600000)

    const json = await response.json()

    if (json) {
      const { resultado, mensagem } = json
      if (mensagem?.codigo !== 200) {
        throw mensagem?.mensagem
      }

      return resultado
    }
  }

  $('#btnVoltar').on('click', function () {
    window.location.href = `${BASE_URI}/operacao_tempos`
  })
})