<?php include_once('../../config.php') ?>

<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Sisplan Web | Liberação Pedido Financeiro</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css?versao=3.2510.21.1">
  <link rel="stylesheet" href="dist/css/adminlte.min.css?versao=3.2510.21.1">
  <link href='https://fonts.googleapis.com/css?family=Roboto:400,300,500,600,700,400italic' rel='stylesheet' type='text/css'>
  <link rel="stylesheet" href="dist/css/custom.css?versao=3.2510.21.1">
  <link rel="stylesheet" href="dist/css/sisplan.css?versao=3.2510.21.1">
  <link rel="stylesheet" type="text/css" href="dist/css/dataTables.bootstrap4.min.css?versao=3.2510.21.1" />
  <link rel="shortcut icon" href="favicon.ico">
  <link rel="stylesheet" href="plugins/toastr/toastr.min.css?versao=3.2510.21.1">
  <link rel="stylesheet" type="text/css" href="dist/css/driver.min.css?versao=3.2510.21.1" />
  <link rel="stylesheet" href="dist/css/jquery-ui.css?versao=3.2510.21.1">
  <style>
    .radioStyle {
      border: solid #e0e4e6;
      border-radius: 4px;
      border-width: 2px;
      padding: 6px;
    }

    .campoSel {
      display: inline-block;
      position: absolute;
      width: 22px;
      height: 22px;
      border: 1px solid #D3CFC8;
      border-radius: 0;
    }

    .border-Field {
      border: 1px solid var(--font-color) !important;
      padding: 0 1.0em 0 1.0em !important;
      margin: 0 0 1.0em 0 !important;
      -webkit-box-shadow: 0px 0px 0px 0px #000;
      box-shadow: 0px 0px 0px 0px #000;
      border-radius: 3px;
    }

    .border-Field .textoBorda {
      font-size: 1.1em !important;
      text-align: left !important;
      width: auto;
      padding: 0 10px;
      border-bottom: none;
    }

    .icon-blue {
      color: var(--blue);
      transition: color 0.2s ease;
    }

    .icon-blue:hover {
      color: #4da6ff;
    }
  </style>
</head>

<body class="hold-transition sidebar-mini layout-fixed">
  <div class="wrapper">

    <div class="content-wrapper">
      <div class="content-header">
        <div class="container-fluid">
          <div class="row mb-2">
            <div class="col-sm-6 flex">
              <h1 class="m-0 text-dark">Liberação de Pedido Financeiro</h1>
              <button type="button" class="btn btn-info btn-sm ml-2" title="Tutorial" style="color: white;" id="tutorial">
                <i class="fas fa-question-circle"></i></button>
            </div>
            <div class="col-sm-6">

            </div>
          </div>
        </div>
        <div class="container-fluid card">
          <div class="row card-body" id="abaGeral">

            <div class="col-lg-4 form-group">
              <label data-error="wrong" data-success="right" for="txtDtFaturaDe">Período Fatura (de/até)</label>
              <div class="input-group">
                <input type="date" max="2500-12-31" class="input-default focus form-control" id="txtDtFaturaDe" name="txtDtFaturaDe">
                <input type="date" max="2500-12-31" class="input-default focus form-control" id="txtDtFaturaAte" name="txtDtFaturaAte">
              </div>
            </div>

            <div class="col-lg-8 form-group">
              <label data-error="wrong" data-success="right" for="txtPedido">Pedido </label>
              <div class="input-group">
                <input type="text" class="input-default col-lg-3 col-12 focus form-control" id="txtPedido" name="txtPedido" class="form-control" placeholder="Pedido">
                <button class="btn bg-danger" id="btn-PedidoConsulta" name="btn-PedidoConsulta" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                <input type="text" id="txtListaPedidos" class="form-group col-lg-9 col-12 input-default focus form-control" placeholder="Lista de Pedidos" disabled>
                <button class="btn bg-danger" id="btn-limpa-Pedido" name="btn-limpa-Pedido" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
              </div>
            </div>

            <div class="col-lg-4 form-group">
              <label data-error="wrong" data-success="right" for="txtDtEmissaoDe">Período Emissão (de/até)</label>
              <div class="input-group">
                <input type="date" max="2500-12-31" class="input-default focus form-control" id="txtDtEmissaoDe" name="txtDtEmissaoDe">
                <input type="date" max="2500-12-31" class="input-default focus form-control" id="txtDtEmissaoAte" name="txtDtEmissaoAte">
              </div>
            </div>

            <div class="col-lg-4 form-group">
              <label data-error="wrong" data-success="right" for="txtCliente">Cliente </label>
              <div class="input-group">
                <input type="text" class="input-default focus form-control" id="txtCliente" name="txtCliente" placeholder="Cliente">
                <div class="input-group-append">
                  <button class="btn bg-danger" id="btn-Cliente" name="btn-Cliente" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                  <button class="btn bg-danger" id="btn-limpa-Cliente" name="btn-limpa-Cliente" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
              </div>
            </div>

            <div class="col-lg-4 form-group">
              <label data-error="wrong" data-success="right" for="txtRepresentante">Representante </label>
              <div class="input-group">
                <input type="text" class="input-default focus form-control" id="txtRepresentante" name="txtRepresentante" placeholder="Representante">
                <div class="input-group-append">
                  <button class="btn bg-danger" id="btn-Representante" name="btn-Representante" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                  <button class="btn bg-danger" id="btn-limpa-Representante" name="btn-limpa-Representante" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
              </div>
            </div>

            <div class="col-lg-4 form-group">
              <label data-error="wrong" data-success="right" for="txtDtSaidaDe">Data de Saída (de/até)</label>
              <div class="input-group">
                <input type="date" max="2500-12-31" class="input-default focus form-control" id="txtDtSaidaDe" name="txtDtSaidaDe">
                <input type="date" max="2500-12-31" class="input-default focus form-control" id="txtDtSaidaAte" name="txtDtSaidaAte">
              </div>
            </div>

            <div class="col-lg-4 form-group">
              <label data-error="wrong" data-success="right" for="txtColecao">Coleção </label>
              <div class="input-group">
                <input type="text" class="input-default focus form-control" id="txtColecao" name="txtColecao" placeholder="Coleção">
                <div class="input-group-append">
                  <button class="btn bg-danger" id="btn-Colecao" name="btn-Colecao" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                  <button class="btn bg-danger" id="btn-limpa-Colecao" name="btn-limpa-Colecao" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
              </div>
            </div>

            <div class="col-lg-2 form-group">
              <label data-error="wrong" data-success="right" for="txtPeriodoEntDe">Período Entrega de </label>
              <div class="input-group">
                <input type="text" class="input-default focus form-control" id="txtPeriodoEntDe" name="txtPeriodoEntDe" placeholder="de">
                <div class="input-group-append">
                  <button class="btn bg-danger" id="btn-PeriodoEntDe" name="btn-PeriodoEntDe" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                  <button class="btn bg-danger" id="btn-limpa-PeriodoEntDe" name="btn-limpa-PeriodoEntDe" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
              </div>
            </div>

            <div class="col-lg-2 form-group">
              <label data-error="wrong" data-success="right" for="txtPeriodoEntAte"> até </label>
              <div class="input-group">
                <input type="text" class="input-default focus form-control" id="txtPeriodoEntAte" name="txtPeriodoEntAte" placeholder="até">
                <div class="input-group-append">
                  <button class="btn bg-danger" id="btn-PeriodoEntAte" name="btn-PeriodoEntAte" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                  <button class="btn bg-danger" id="btn-limpa-PeriodoEntAte" name="btn-limpa-PeriodoEntAte" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
              </div>
            </div>

            <div class="col-sm-8 form-group mb-0">
              <fieldset class="form border-Field mb-0 pb-0">
                <legend class="textoBorda mb-0 pb-0">Financeiro/Comercial</legend>
                <div class="form-row">
                  <div class="form-group ml-2 icheck-primary">
                    <input type="radio" checked="checked" id="radioTodos" name="tipo">
                    <label class="form-check-label pr-1" for="radioTodos">Todos</label>
                  </div>
                  <div class="form-group ml-2 icheck-primary">
                    <input type="radio" id="radioBloqVendas" name="tipo">
                    <label class="form-check-label pr-1" for="radioBloqVendas">Bloq. Vendas</label>
                  </div>
                  <div class="form-group ml-2 icheck-primary">
                    <input type="radio" id="radioBloqFinan" name="tipo">
                    <label class="form-check-label pr-1" for="radioBloqFinan">Bloq. Finan.</label>
                  </div>
                  <div class="form-group ml-2 icheck-primary">
                    <input type="radio" id="radioBloqFinanLibVend" name="tipo">
                    <label class="form-check-label pr-1" for="radioBloqFinanLibVend">Bloq. Finan. / Lib. Vendas</label>
                  </div>
                  <div class="form-group ml-2 icheck-primary">
                    <input type="radio" id="radioBloqExp" name="tipo">
                    <label class="form-check-label pr-1" for="radioBloqExp">Bloq. Expedição</label>
                  </div>
                </div>
              </fieldset>
            </div>

            <div class="col-lg-2 form-group pt-2">
              <button class=" btn btn-primary btn-sisp" id="btnConsultar"><span class="fas fa-search"></span> Consultar</button>
            </div>


            <div class="col-sm-12 table-responsive card-body py-0">
              <h5>Pedidos</h5>
              <table id="tabelaPedido" class="table table-sm-sisp table-select table-hover" style="white-space: nowrap;" width="100%">
                <thead>
                </thead>
                <tbody>
                </tbody>
              </table>
            </div>

            <div class="col-sm-6 table-responsive card-body pt-0">
              <h5>Itens</h5>
              <table id="tabelaItens" class="table table-sm-sisp table-select table-hover" width="100%">
                <thead>
                  <tr>
                    <th class="th-sm">Código
                    </th>
                    <th class="th-sm">Descrição
                    </th>
                    <th class="th-sm">Cor
                    </th>
                    <th class="th-sm">Tam
                    </th>
                    <th class="th-sm">Qtde
                    </th>
                  </tr>
                </thead>
                <tbody>
                </tbody>
              </table>
            </div>

            <div class="col-sm-6 table-responsive card-body pt-0">
              <h5>Receber Em Aberto</h5>
              <table id="tabelaReceber" class="table table-sm-sisp table-select table-hover" width="100%" style="white-space: nowrap;">
                <thead>
                </thead>
                <tbody>
                </tbody>
              </table>
            </div>

            <div class="col-sm-12 d-flex justify-content-end align-items-end">
              <div class="col-12 d-flex justify-content-end">
                <div class="col-lg-6 d-none" id="divMotivo">
                  <label data-error="wrong" data-success="right" for="txtMotivo">Motivo: * </label>
                  <div class="input-group">
                    <input type="text" class="input-default focus form-control" id="txtMotivo" name="txtMotivo" placeholder="Motivo">
                  </div>
                </div>
                <div class="radioStyle mt-2 pt-1">
                  <div class="form-row pr-2">
                    <div class="form-group ml-2 icheck-primary flex align-items-center pt-1">
                      <input type="radio" class="liberarBloq" checked name="liberarBloq" id="radioLiberar">
                      <label class="form-check-label pr-1" style="font-weight: bold;" for="radioLiberar">Liberar</label>
                    </div>
                    <div class="form-group ml-2 icheck-primary flex align-items-center pt-1">
                      <input type="radio" class="liberarBloq" name="liberarBloq" id="radioBloquear">
                      <label class="form-check-label pr-1" style="font-weight: bold;" for="radioBloquear">Bloquear</label>
                    </div>
                    <button id="btnLiberar" class="btn btn-danger btn-sisp">Confirmar</button>
                  </div>
                </div>
              </div>
            </div>

          </div>
        </div>
      </div>
      <!-- modal  -->
    </div>
  </div>
  <?php
  include_once('../../modais.php');
  ?>
  <aside class="control-sidebar control-sidebar-dark">
  </aside>
  </div>
  <script src="plugins/jquery/jquery.min.js?versao=3.2510.21.1"></script>
  <script type="text/javascript" src="dist/js/jquery.dataTables.js?versao=3.2510.21.1"></script>
  <script type="text/javascript" src="dist/js/dataTables.bootstrap4.min.js?versao=3.2510.21.1"></script>
  <script src="plugins/jquery-ui/jquery-ui.min.js?versao=3.2510.21.1"></script>
  <script>
    $.widget.bridge('uibutton', $.ui.button);
  </script>
  <script src="plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.2510.21.1"></script>
  <script src="dist/js/adminlte.min.js?versao=3.2510.21.1"></script>
  <script src="dist/js/sisplan.js?versao=3.2510.21.1"></script>
  <script src="utils/funcoes.js?versao=3.2510.21.1"></script>
  <script src="utils/cookies.js?versao=3.2510.21.1"></script>
  <script src="dist/js/requisicoes.js?versao=3.2510.21.1"></script>
  <script src="dist/js/loadingoverlay.min.js?versao=3.2510.21.1"></script>
  <script src="dist/js/driver.min.js?versao=3.2510.21.1"></script>
  <script src="plugins/toastr/toastr.min.js?versao=3.2510.21.1"></script>
  <script src="plugins/select2/js/select2.full.min.js?versao=3.2510.21.1"></script>
  <script src="plugins/datatables-colreorder/js/dataTables.colReorder.min.js?versao=3.2510.21.1"></script>
  <script type="text/javascript" src="dist/js/sum().js?versao=3.2510.21.1"></script>
  <script type="text/javascript" src="config.js?versao=3.2510.21.1"></script>
  <script>
    $(document).ready(async function() {
      if (getCookie('usuario') == "") {
        window.location.href = `${BASE_URI}/login`;
        return;
      }

      let usuario = getCookie('usuario');
      let empresa = getCookie('empresa');

      ipInterno = IP_INTERNO;
      ipExterno = IP_EXTERNO;
      basicAuth = BASIC_AUTH;

      const temAcesso = await temAcessoTela('LIBERACAO_FINANCEIRO');
      if (!temAcesso.resultado) {
        toastrAcesso(temAcesso, BASE_URI);
        return;
      }

      sArquivo = `${BASE_URI}/pages/liberacao_financeiro/liberacao_financeiro.js?versao=3.2510.21.1`;
      insereJavaScriptPagina(sArquivo);

    });
  </script>
</body>

</html>