$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
    });
    driver.defineSteps([
      {
        element: "#btnFiltros",
        popover: {
          title: "Botão Filtros",
          description: "Clique aqui para filtrar a consulta.",
          position: "right",
        },
      },
      {
        element: "#btnNovoFluxo",
        popover: {
          title: "Botão Incluir",
          description: "Clique aqui para incluir um novo fluxo.",
          position: "right",
        },
      },
      {
        element: "#tabelaFluxo",
        popover: {
          title: "Tabela Fluxo",
          description: "Aqui estão os dados dos fluxos cadastrados.",
          position: "top",
        },
      },
    ]);
    driver.start();
  });
});

$(document).ready(async function () {
  const permissaoUsuarioLogado = await permissaoAcessos("FLUXO");

  $('#txtFluxoConsulta').autocompleta(1, `JSON={ "tabela":"roteiro", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
  $('#btnFluxo').pesquisa('#txtFluxoConsulta', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"roteiro", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa Fluxo', 'roteiro');

  $('#btnLimpaFluxo').on('click', function () {
    $('#txtFluxoConsulta').val('');
  });

  $('#btnLimparFiltros').on('click', function () {
    $('#txtFluxoConsulta').val('');
    $('#txtBaixaLivreConsulta').val('');
    $('#txtAtivoConsulta').val('');
  });

  $('#btnFiltros').on('click', function () {
    $('#modal-filtros').modal('show');
  });

  $('#btnNovoFluxo').on('click', function () {
    if (permissaoUsuarioLogado.INCLUI == 'S') {
    window.location.href = "fluxo/create";
    } else {
        msgAlertaSemConfirmacao("Sem permissão para incluir!");
    }
  });

  await consultaFluxo();

  async function consultaFluxo() {
    try {
      $.LoadingOverlay("show");
      try {

        let params = '[ " 1=1 ';

        if ($('#txtFluxoConsulta').val() != '') {
          params += ` AND CODIGO = '${pegaChave('#txtFluxoConsulta')}'`
        }

        if ($('#txtBaixaLivreConsulta').val() != '') {
          params += ` AND BAIXALIVRE = '${$('#txtBaixaLivreConsulta').val()}'`
        }

        if ($('#txtAtivoConsulta').val() != '') {
          params += ` AND ATIVO = '${$('#txtAtivoConsulta').val()}'`
        }

        params += ' " ]'

        $("#tabelaFluxo").DataTable({
          destroy: true,
          lengthChange: false,
          serverSide: true,
          processing: true,
          ajax: {
            url: `${getCookie('protocolo')}://${getCookie("ip_api")}/sisplan/funcoes/v1/pesquisadatatable`,
            type: "POST",
            headers: { Authorization: BASIC_AUTH },
            data: {
              EMPRESA: getCookie("empresa"),
              JSON: `{"tabela":"ROTEIRO", "camposSelect":[ "CODIGO", "DESCRICAO", "ATIVO", "BAIXALIVRE"], "where": ${params}}`,
            },
          },
          columnDefs: [
            {
              targets: [0], render: function (data) {
                return retornaBotaoOpcoes(data);
              },
            },
          ],
        });
        $("input[type='search']").focus();

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay("hide");
    }

  }

  function retornaBotaoOpcoes(data) {
    var retorno = '<div style="text-align:start;"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" id="tutorialTabela" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + data + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu"> ' +
      '    <button class="dropdown-item" type="button" title="Editar" id="btn-editar">Editar</button>     ' +
      '    <button class="dropdown-item" type="button" title="Imprimir" id="btn-imprimir">Imprimir</button>     ' +
      '    <button class="dropdown-item" type="button" title="Excluir" id="btn-excluir">Excluir</button>  ' +
      '</div>';
    return retorno;
  };

  $('#tabelaFluxo').on('click', '#btn-editar', async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $('#tabelaFluxo').DataTable().row($(this).parents('tr')).data();
      let registroLiberado = await verificarRegistro('FLUXO', data[0]);
      if (registroLiberado) {
        window.location.href = `fluxo/${data[0]}`;
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  $('#tabelaFluxo').on('dblclick', 'tr', async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $('#tabelaFluxo').DataTable().row($(this)).data();
      let registroLiberado = await verificarRegistro('FLUXO', data[0]);
      if (registroLiberado) {
        window.location.href = `fluxo/${data[0]}`;
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  $('#btnConsultar').on('click', async function () {
    $('#modal-filtros').modal('hide');
    await consultaFluxo(true);
  });

  $('#tabelaFluxo').on('click', '#btn-excluir', async function () {

    const data = $('#tabelaFluxo').DataTable().row($(this).parents('tr')).data();

    if (permissaoUsuarioLogado.EXCLUI == 'S') {
        msgAlerta('Você realmente deseja excluir esse registro?', async () => {
            await excluiRegistro(data[0]);
        });
    } else {
        msgAlertaSemConfirmacao("Sem permissão para excluir!");
    }
});

async function excluiRegistro(codigo) {
    try {
        $.LoadingOverlay("show");
        try {
            let response = await requisicao("DELETE", "/sisplan/facfluxo/v1/fluxo?", `CODIGO=${encodeURIComponent(codigo)}&EMP_ID=${getCookie('emp_id')}`, null);
            if (!response) {
                return;
            }
            if (response.status != 200) {
                let jsonStr = await response.json();
                msgErro(jsonStr.mensagem);
                return;
            }

            toastr.success("Exclusão efetuada com sucesso!", "Confirmação", {
                toastClass: "success",
                iconClasses: {
                    error: "alert-error",
                    info: "alert-info",
                    success: "alert-success",
                    warning: "alert-warning",
                },
                positionClass: "toast-top-center",
                progressBar: true,
                timeOut: 3000,
                fadeOut: 1000,
                onHidden() {
                    window.location.reload();
                },
            }).css({
                "margin-top": "20%",
                width: "500px",
                "max-width": "500px",
            });

        } catch (error) {
            console.error(error);
        }
    } finally {
        $.LoadingOverlay("hide");
    }
}

  $("#tabelaFluxo").on("click", "#btn-imprimir", async function () {
    try {
      $.LoadingOverlay("show");

      let data = $("#tabelaFluxo").DataTable().row($(this).parents("tr")).data();
      let url = `/sisplan/impressao/v1/relfacfluxo?codigo=${data[0]}`;
      const bImprimeAutomatico = await verificaImprimirAutomatico('FacFluxo');
      let arquivo = await GeraRelatorio(`${url}&`, "GET", 15000, false, 'Fluxo Facção');
      if (arquivo != undefined) {
        if (!bImprimeAutomatico) {
          window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, "_blank");
        }
        await limparRelatorios();
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  });

});