$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
    });
    driver.defineSteps([
      {
        element: "#btnFiltros",
        popover: {
          title: "Botão Filtros",
          description:
            "Clique aqui para ter acesso aos filtros e iniciar uma consulta das posições.",
          position: "right",
        },
      },
      {
        element: "#btnIncluir",
        popover: {
          title: "Botão Incluir",
          description:
            "Clique aqui para iniciar o cadastro de uma posição.",
          position: "right",
        },
      },
      {
        element: "#btnImprimir",
        popover: {
          title: "Botão Imprimir",
          description: "Clique aqui para imprimir os dados.",
          position: "top",
        },
      },
      {
        element: "#tabelaDados",
        popover: {
          title: "Tabela",
          description: "Aqui estão os dados das posições.",
          position: "top",
        },
      },
    ]);
    driver.start();
  });
});


$(document).ready(async function () {
  const permissaoUsuarioLogado = await permissaoAcessos("ESCPOSICAO");

  componenteFiltro('banco', true);
  componenteFiltro('carteira', true);
  componenteFiltro('camposPosEscritural', true);

  $("#btnFiltros").on("click", function () {
    $("#modal-filtros").modal("show");
  });

  function retornaBotaoOpcoes(data) {
    var retorno = '<div style="text-align:start;"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + data + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu"> ' +
      '    <button class="dropdown-item" title="Editar" id="btn-editar">Editar</button>     ' +
      '    <button class="dropdown-item" title="Excluir" id="btn-excluir">Excluir</button>     ' +
      // '    <button class="dropdown-item"" title="Anexos" id="btnAnexos">Gestão Documentos</button>     ' +
      '</div>';
    return retorno;
  };

  await consultaDados();

  $("#btnConsultar").on("click", async function () {
    await consultaDados();
    $("#modal-filtros").modal("hide");
  });

  limparFiltros(true);

  async function consultaDados() {
    try {
      $.LoadingOverlay("show");
      let dataSetCols = [];
      const filtros = await retornaFiltros();

      let where = `"1=1`;

      if (filtros.banco != '') {
        where += ` AND POSICAO.BANCO IN (${filtros.banco})`;
      }

      if (filtros.carteira != '') {
        where += ` AND POSICAO.CARTEIRA IN (${filtros.carteira})`;
      }

      if (filtros.campos != '') {
        where += ` AND POSICAO.CAMPO IN (${filtros.campos})`;
      }

      if (filtros.tipo != '') {
        where += ` AND POSICAO.TIPO = '${filtros.tipo}'`;
      }

      where += '"';
      camposSelect = ["POSICAO.BANCO", "CADBAN.NOME_BANCO", "POSICAO.CAMPO", "POSICAO.INICIO",
        "POSICAO.TAMANHO", "POSICAO.TIPO", "POSICAO.SEPARADOR",
        "POSICAO.CARTEIRA", "POSICAO.IDENT_SEGUIMENTO", "POSICAO.POSICOES_240"]

      colunas = ["BANCO", "NOME _ANCO", "CAMPO", "INICIO", "TAMANHO", "TIPO", "SEPARADOR", "CARTEIRA", "IDENT_SEGUIMENTO"];

      const ligacaoBanco = { "tabela": "CADBAN", "condicao": `POSICAO.BANCO = CADBAN.BANCO` };

      const pesquisa = {
        tabela: 'POSICAO',
        camposSelect: camposSelect,
        leftjoin: [ligacaoBanco],
        where: [where],
      }

      for (let i = 0; i < colunas.length; i++) {
        dataSetCols.push({
          'title': colunas[i],
          'data': colunas[i]
        });
      }

      $("#tabelaDados").DataTable({
        destroy: true,
        lengthChange: false,
        serverSide: true,
        processing: true,
        ajax: {
          url: `${getCookie('protocolo')}://${getCookie("ip_api")}/sisplan/funcoes/v1/pesquisadatatable`,
          type: "POST",
          headers: { Authorization: BASIC_AUTH },
          data: {
            EMPRESA: getCookie("empresa"),
            JSON: JSON.stringify(pesquisa),
            CLIENTE: "S",
          },
        },
        columnDefs: [
          {
            targets: [0], render: function (data, type, row) {
              return retornaBotaoOpcoes(data);
            },
          },
          {
            "targets": [3, 4],
            "className": 'pr-4 text-right'
          }
        ],
      });
      $("input[type='search']").focus();
      $.LoadingOverlay("hide");
    } catch (error) {
      console.error(error);
      $.LoadingOverlay("hide");
      msgErro(`Não foi possível buscar os dados das posições: ${error}`);
    }
  }

  $("#tabelaDados").on("click", "#btn-editar", async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $("#tabelaDados").DataTable().row($(this).parents("tr")).data();
      let chave = `${data[0]}-${data[2]}-${data[5]}-${data[7]}-${data[9]}`;
      window.location.href = `escposicao/${chave}`;
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  $("#tabelaDados").on("dblclick", "tr", async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $("#tabelaDados").DataTable().row($(this)).data();
      let chave = `${data[0]}-${data[2]}-${data[5]}-${data[7]}-${data[9]}`;
      window.location.href = `escposicao/${chave}`;
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  async function retornaFiltros() {
    const filtros = {
      banco: await formataListas($('#txtBanco').val().toString()),
      carteira: await formataListas($('#txtCarteira').val().toString()),
      campos: await formataListas($('#txtCamposPosEscritural').val().toString()),
      tipo: $('#txtTipo').val()
    }

    return filtros;
  }

  $('#btnIncluir').on('click', function () {
    if (permissaoUsuarioLogado.INCLUI == 'S') {
      window.location.href = `${BASE_URI}/escposicao/create`;
    } else {
      msgAlertaSemConfirmacao("Sem permissão para incluir!");
    }
  })

  $('#tabelaDados').on('click', '#btn-excluir', function () {
    if (permissaoUsuarioLogado.EXCLUI == 'S') {
      msgAlerta('Deseja excluir este registro?', async () => {
        let data = $("#tabelaDados").DataTable().row($(this).parents("tr")).data();
        await excluiRegistro(data);
      })
    } else {
      msgAlertaSemConfirmacao("Sem permissão para excluir!");
    }
  })

  async function excluiRegistro(data) {
    try {
      $.LoadingOverlay('show');
      try {

        let response = await requisicao("DELETE", "/sisplan/cadastros/v1/escposicao?", `BANCO=${data[0]}&CAMPO=${data[2]}&TIPO=${data[5]}&CARTEIRA=${data[7]}`, null);
        if (!response) {
          return;
        }
        if (response.status != 200) {
          let jsonStr = await response.json();
          msgErro(jsonStr.mensagem);
          return;
        }

        toastr.success("Exclusão efetuada com sucesso!", "Confirmação", {
          toastClass: "success",
          iconClasses: {
            error: "alert-error",
            info: "alert-info",
            success: "alert-success",
            warning: "alert-warning",
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000,
          onHidden() {
            window.location.reload();
          },
        }).css({
          "margin-top": "20%",
          width: "500px",
          "max-width": "500px",
        });
      } catch (e) {
        console.log(e);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  $('#btnImprimir').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      try {
        const url = '/sisplan/impressao/v1/escposicao?';
        const filtros = await retornaFiltros();

        const params = `
          &BANCO=${filtros.banco}
          &CAMPOS=${filtros.campos}
          &TIPO=${filtros.tipo}
          &CARTEIRA=${filtros.carteira}`;

        let arquivo = await GeraRelatorio(`${url + params}&`, 'POST', 100000, false);
        if (arquivo != undefined) {
          window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
          await limparRelatorios();
        }

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  });
});
