$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false
        });
        driver.defineSteps([

            {
                element: '#btnFiltros',
                popover: {
                    title: 'Botão Filtros',
                    description: 'Clique aqui para filtrar a consulta.',
                    position: 'right'
                }
            },
            {
                element: '#btnNovoDashboard',
                popover: {
                    title: 'Botão Incluir',
                    description: 'Clique aqui para iniciar o cadastro de um dashboard.',
                    position: 'right'
                }
            },
            {
                element: '#tabelaDashboard',
                popover: {
                    title: 'Tabela Dashboards',
                    description: 'Aqui estão os dados dos dashboards cadastradas.',
                    position: 'top'
                }
            }
        ]);
        driver.start();
    });
});
$(document).ready(async function () {
    $('#txtDashboard').pesquisa_variosServerside(1, `{ "tabela":"DASH_ERP", "camposSelect":[ "ID_DASH", "TITULO_DASH" ], "where":  ["TIPO_DASH = 'M'"], "groupBy": ["TITULO_DASH", "ID_DASH"]}`, 'ID_DASH', 'TITULO_DASH');
    $('#btnDashboard').pesquisa_serversideSel('#txtDashboard', `{ "tabela":"DASH_ERP", "camposSelect":[ "ID_DASH", "TITULO_DASH" ], "where":  ["TIPO_DASH = 'M'"], "groupBy": ["TITULO_DASH", "ID_DASH"]}`, 'Pesquisa de Dashboard');
    $('#btnLimpaDashboard').on('click', function () { $('#txtDashboard').empty().trigger('change') })


    const permissaoUsuarioLogado = await permissaoAcessos("DASHBOARDAPP");

    $('#btnFiltros').on('click', function () {
        $('#modal-filtros').modal('show');
    });


    function retornaBotaoOpcoes(data) {
        var retorno = '<div style="text-align:start;"> ' +
            '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
            '      ' + data + ' ' +
            '    </button> ' +
            '    <div class="dropdown-menu"> ' +
            '    <button class="dropdown-item" type="button" title="Editar" id="btn-editar">Editar</button>     ' +
            '</div>';
        return retorno;
    };

    consultaDashboard();

    $('#btnConsultar').on('click', async function () {
        await consultaDashboard(true);
        $('#modal-filtros').modal('hide');
    });

    $('#btnLimparFiltros').on('click', async function () {
        $('#txtDashboard').empty().trigger('change')
    });

    async function consultaDashboard(bBotao = false) {
        try {
            $.LoadingOverlay("show");
            let response;
            const filtro = await formataListas($('#txtDashboard').val().toString())
            const idDash = filtro != '' ? ` AND ID_DASH IN (${filtro})` : '';
            if (bBotao) {
                response = await requisicao('GET', '/Sisplan/Funcoes/V1/pesquisa?', `JSON={ "tabela":"DASH_ERP", "camposSelect":[ "ID_DASH", "TITULO_DASH"],"where": ["TIPO_DASH = 'M' ${idDash}"], "groupBy": ["TITULO_DASH", "ID_DASH"]}`, null);
            } else {
                response = await requisicao('GET', '/Sisplan/Funcoes/V1/pesquisa?', `JSON={ "tabela":"DASH_ERP", "camposSelect":[ "ID_DASH", "TITULO_DASH"], "where": ["TIPO_DASH = 'M'"], "groupBy": ["TITULO_DASH", "ID_DASH"]}`, null);
            }

            if (!response) {
                $.LoadingOverlay("hide");
                return;
            }

            let jsonStr = await response.json();
            if (response.status != 200) {
                $.LoadingOverlay("hide");
                msgErro(jsonStr.RESULT[0].mensagem);
                return;
            }

            $('#tabelaDashboard').DataTable({
                destroy: true,
                lengthChange: false,
                serverside: true,

                "autoWidth": true,
                "data": jsonStr.RESULT[0],
                "columns": [{
                    "data": "ID_DASH"
                },
                {
                    "data": "TITULO_DASH"
                },
                ],
                "columnDefs": [{
                    targets: [0], render: function (data, type, row) {
                        return retornaBotaoOpcoes(data);
                    }
                }]
            });

            $.LoadingOverlay("hide");
        } catch (error) {
            console.error(error);
            $.LoadingOverlay("hide");
        }

    }

    $('#btnNovoDashboard').on('click', function () {
        if (permissaoUsuarioLogado.INCLUI == 'S') {
            window.location.href = "dashboardapp/create";
        } else {
            msgAlertaSemConfirmacao("Sem permissão para incluir!");
        }
    });

    $('#tabelaDashboard').on('click', '#btn-editar', async function () {
        if (permissaoUsuarioLogado.ALTERA == 'S') {
            let data = $('#tabelaDashboard').DataTable().row($(this).parents('tr')).data();
            let registroLiberado = await verificarRegistro('DASHBOARDAPP', data.ID_DASH);
            if (registroLiberado) {
                window.location.href = `dashboardapp/${data.ID_DASH}`;
            }
        } else {
            msgAlertaSemConfirmacao("Sem permissão para alterar!");
        }
    });

    $('#tabelaDashboard').on('dblclick', 'tr', async function () {
        if (permissaoUsuarioLogado.ALTERA == 'S') {
            let data = $('#tabelaDashboard').DataTable().row($(this)).data();
            let registroLiberado = await verificarRegistro('DASHBOARDAPP', data.ID_DASH);
            if (registroLiberado) {
                window.location.href = `dashboardapp/${data.ID_DASH}`;
            }
        } else {
            msgAlertaSemConfirmacao("Sem permissão para alterar!");
        }
    });
});