const driver = new Driver({
  doneBtnText: "Sair",
  closeBtnText: "Fechar",
  nextBtnText: "Próximo",
  prevBtnText: "Anterior",
  allowClose: false,
});
driver.defineSteps([
  {
    element: "#divSerigrafia",
    popover: {
      title: "Dados Gerais",
      description: "Aqui estão as abas disponíveis para o cadastro e alteração, os campos obrigatórios terão o * ao lado do nome.",
      position: "top",
    },
  },
  {
    element: "#tabSerigrafia",
    popover: {
      title: "Serigrafia",
      description:
        "Aqui temos o cadastro e alteração do Local, Tamanho e Tipo de Serigrafia.",
      position: "bottom",
    },
  },
  {
    element: "#tabBordado",
    popover: {
      title: "Bordado",
      description:
        "Aqui temos o cadastro e alteração do Local, Programação e Tamanho de Bordado.",
      position: "bottom",
    },
  },
  {
    element: "#tabSublimacao",
    popover: {
      title: "Sublimação",
      description:
        "Aqui temos o cadastro e alteração da Sublimação.",
      position: "bottom",
    },
  },
  {
    element: "#tabTermotape",
    popover: {
      title: "Termotape",
      description:
        "Aqui temos o cadastro e alteração do Termotape.",
      position: "bottom",
    },
  },
  {
    element: "#tabDTF",
    popover: {
      title: "DTF",
      description:
        "Aqui temos o cadastro e alteração do DTF.",
      position: "bottom",
    },
  },
  {
    element: "#SerigrafiaLocal",
    popover: {
      title: "Seções",
      description:
        "As abas, podem conter seções de consulta, cadastro, alteração ou exclusão.",
      position: "top",
    },
  },
  {
    element: "#tabelaLocalSerigrafia",
    popover: {
      title: "Registros -  Editar / Excluir",
      description:
        "Ao cadastrar um registro, ele será adicionado na tabela, e ao seu ID, possuirá um botão onde podemos habilita a edição do item, ou a exclusão do mesmo.",
      position: "top",
    },
  },
  {
    element: "#btnIncluirLocalSerigrafia",
    popover: {
      title: "Incluir",
      description:
        "Ao clicar, conseguimos incluir um registro na seção, cada seção tem o seu botão de incluir.",
      position: "left",
    },
  },

]);

$("#tutorial").on('click', function () {
  driver.start();
})

$(document).ready(async function () {

  const permissaoUsuarioLogado = await permissaoAcessos("CUSTOMIZACAO");
  // Aplica display none nas div, ao clicar nos itens do menu da página
  $("#divSerigrafia").removeClass("d-none");

  $(".menu_secao").click(function (e) {
    e.preventDefault();
    var target = $(this).attr("href");
    $(".tab-pane").addClass("d-none");
    $(target).removeClass("d-none");
  })


  // Pesquisas e AutoCompleta
  $('#txtSetorLocalSerigrafia').autocompleta(1, `JSON={ "tabela":"CADFLUXO", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
  $('#btnSetorLocalSerigrafia').pesquisa('#txtSetorLocalSerigrafia', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CADFLUXO", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa de Setor', 'CADFLUXO');

  $('#txtTamanhoTipoSerigrafia').autocompleta(1, `JSON={ "tabela":"CUSTOMIZA", "camposSelect":[ "ID CHAVE", "DESCRICAO DESCRICAO"], "where": ["TIPO = 'SERIGTAM'"]}`);
  $('#btnTamanhoTipoSerigrafia').pesquisa('#txtTamanhoTipoSerigrafia', 'ID', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CUSTOMIZA", "camposSelect":[ "ID", "DESCRICAO"], "where": ["TIPO = 'SERIGTAM'"]}`, 'Pesquisa de Tamanho', 'CUSTOMIZA');

  $('#txtSetorLocalBordado').autocompleta(1, `JSON={ "tabela":"CADFLUXO", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
  $('#btnSetorLocalBordado').pesquisa('#txtSetorLocalBordado', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CADFLUXO", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa de Setor', 'CADFLUXO');

  $('#txtSetorLocalDTF').autocompleta(1, `JSON={ "tabela":"CADFLUXO", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
  $('#btnSetorLocalDTF').pesquisa('#txtSetorLocalDTF', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CADFLUXO", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa de Setor', 'CADFLUXO');

  $('#txtSetorSublimacao').autocompleta(1, `JSON={ "tabela":"CADFLUXO", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
  $('#btnSetorSublimacao').pesquisa('#txtSetorSublimacao', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CADFLUXO", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa de Setor', 'CADFLUXO');

  $('#txtSetorTermotape').autocompleta(1, `JSON={ "tabela":"CADFLUXO", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
  $('#btnSetorTermotape').pesquisa('#txtSetorTermotape', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CADFLUXO", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa de Setor', 'CADFLUXO');

  // Botões de limpar dos inputs
  $('#btnLimpaSetorLocalSerigrafia').on('click', function () {
    $('#txtSetorLocalSerigrafia').val("");
  });

  $('#btnLimpaTamanhoTipoSerigrafia').on('click', function () {
    $('#txtTamanhoTipoSerigrafia').val("");
  });

  $('#btnLimpaSetorLocalBordado').on('click', function () {
    $('#txtSetorLocalBordado').val("");
  });

  $('#btnLimpaSetorLocalDTF').on('click', function () {
    $('#txtSetorLocalDTF').val("");
  });

  $('#btnLimpaSetorSublimacao').on('click', function () {
    $('#txtSetorSublimacao').val("");
  });

  $('#btnLimpaSetorTermotape').on('click', function () {
    $('#txtSetorTermotape').val("");
  });


  function retornaBotaoOpcoes(data) {
    let retorno = ''
    retorno = '<div style="text-align:start;"> ' +
      '    <button id="editaOpcoes" class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + data + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu" > ' +
      '    <button class="dropdown-item" type="button" title="Editar" id="btn-editar">Editar</button>     ' +
      '    <button class="dropdown-item" type="button" title="Excluir" id="btn-excluir">Excluir</button>  ' +
      '</div>';
    return retorno;
  };


  //Criação das tabelas

  // Tabela Local Serigrafia
  async function tabSerigLocal() {
    let dataSetCols = [];
    try {
      $.LoadingOverlay("show");
      response = await requisicao("GET", `/sisplan/funcoes/v1/pesquisa?`, `JSON={"tabela":"CUSTOMIZA","camposSelect":["ID", "DESCRICAO", "PRECO", "MARGEM", "ATIVO", "SETOR"],"where": ["TIPO = 'SERIGLOCAL'"],"limit": 1000}`, null, 20000);
      if (!response) {
        return;
      }
      const jsonStr = await response.json();
      if (response.status != 200) {
        msgErro(jsonStr.RESULT[0].mensagem);
        return;
      }
      if ($.isEmptyObject(jsonStr.RESULT[0])) {
        $('#tabelaLocalSerigrafia').html(`<p class='d-flex justify-content-center border-Field' style="padding-top: 6px !important;">Nenhum registro encontrado</p>`);
        return;
      }
      const dataSet = jsonStr.RESULT[0];
      const keys = Object.keys(dataSet[0]);
      keys.forEach((value) => { dataSetCols.push({ title: value, data: value, }); });
      const botaoDinamico = {
        targets: [0],
        funcao: (data, type, row) => { return retornaBotaoOpcoes(data); }
      }

      criaDataTablePadrao('#tabelaLocalSerigrafia', true, true, false, true, false, false, '200px', dataSet, dataSetCols, [], [], [], [2], botaoDinamico, 2, '', '', false, [], [3]);

      if ($('#tabelaLocalSerigrafia').DataTable().rows().count() < 4) {
        $('#tabelaLocalSerigrafia').css('min-height', '75px');
      }
    } catch (error) {
      console.error(error);
      msgErro("Não foi possível buscar os dados de Local da Serigrafia.");
    } finally {
      $.LoadingOverlay("hide");
    }
    $("#tabelaLocalSerigrafia").DataTable().columns.adjust().draw(false);
  }

  // Tabela Tamanho Serigrafia
  async function tabSerigTamanho() {
    let dataSetCols = [];
    try {
      $.LoadingOverlay("show");
      response = await requisicao("GET", `/sisplan/funcoes/v1/pesquisa?`, `JSON={"tabela":"CUSTOMIZA","camposSelect":["ID", "DESCRICAO", "ATIVO"],"where": ["TIPO = 'SERIGTAM'"],"limit": 1000}`, null, 20000)
      if (!response) {
        return;
      }
      const jsonStr = await response.json();
      if (response.status != 200) {
        msgErro(jsonStr.RESULT[0].mensagem);
        return;
      }
      if ($.isEmptyObject(jsonStr.RESULT[0])) {
        $('#tabelaTamanhoSerigrafia').html(`<p class='d-flex justify-content-center border-Field' style="padding-top: 6px !important;">Nenhum registro encontrado</p>`);
        return;
      }
      const dataSet = jsonStr.RESULT[0];
      const keys = Object.keys(dataSet[0]);
      keys.forEach((value) => { dataSetCols.push({ title: value, data: value, }); });
      const botaoDinamico = {
        targets: [0],
        funcao: (data, type, row) => { return retornaBotaoOpcoes(data); }
      }
      criaDataTablePadrao('#tabelaTamanhoSerigrafia', true, true, false, true, false, false, '200px', dataSet, dataSetCols, [], [], [], [], botaoDinamico);
      if ($('#tabelaTamanhoSerigrafia').DataTable().rows().count() < 4) {
        $('#tabelaTamanhoSerigrafia').css('min-height', '75px');
      }

    } catch (error) {
      console.error(error);
      msgErro("Não foi possível buscar os dados de Local da Serigrafia.");
    } finally {
      $.LoadingOverlay("hide");
    }
  }

  // Tabela Tipo Serigrafia
  async function tabSerigTipo() {
    let dataSetCols = [];
    try {
      $.LoadingOverlay("show");
      response = await requisicao("GET", `/sisplan/funcoes/v1/pesquisa?`, `JSON={
        "tabela": "CUSTOMIZA",
        "camposSelect": [
          "CUSTOMIZA.ID",
          "CUSTOMIZA.DESCRICAO",
          "CUSTOMIZA.MARGEM",
          "CUSTOMIZA.VAL_TELA",
          "CUSTOMIZA.VAL_FOTO",
          "CUSTOMIZA.VAL_COR",
          "CUSTOMIZA.QTDE_COR",
          "CUSTOMIZA.TEMPO",
          "CUSTOMIZA.ID_TAMANHO",
          "CAD_CUST_TAM.DESCRICAO DESC_TAM",
          "CUSTOMIZA.ATIVO"
        ],
        "leftjoin": [
          {
            "tabela": "CUSTOMIZA",
            "alias": "CAD_CUST_TAM",
            "condicao": "CAD_CUST_TAM.ID = CUSTOMIZA.ID_TAMANHO"
          }
        ],
        "where": ["CUSTOMIZA.TIPO = 'SERIGTIPO'"]
      }`, null, 20000)
      if (!response) {
        return;
      }
      const jsonStr = await response.json();
      if (response.status != 200) {
        msgErro(jsonStr.RESULT[0].mensagem);
        return;
      }
      if ($.isEmptyObject(jsonStr.RESULT[0])) {
        $('#tabelaTipoSerigrafia').html(`<p class='d-flex justify-content-center border-Field' style="padding-top: 6px !important;">Nenhum registro encontrado</p>`);
        return;
      }
      const dataSet = jsonStr.RESULT[0];
      const keys = Object.keys(dataSet[0]);
      keys.forEach((value) => { dataSetCols.push({ title: value, data: value, }); });
      const botaoDinamico = {
        targets: [0],
        funcao: (data, type, row) => { return retornaBotaoOpcoes(data); }
      }
      criaDataTablePadrao('#tabelaTipoSerigrafia', true, true, false, true, false, false, '200px', dataSet, dataSetCols, [], [], [], [3, 4, 5], botaoDinamico, 2, '', '', false, [], [2, 6, 7]);
      if ($('#tabelaTipoSerigrafia').DataTable().rows().count() < 4) {
        $('#tabelaTipoSerigrafia').css('min-height', '75px');
      }
    } catch (error) {
      console.error(error);
      msgErro("Não foi possível buscar os dados de Tipo da Serigrafia.");
    } finally {
      $.LoadingOverlay("hide");
    }
  }

  // Tabela Local Bordado
  async function tabBordLocal() {
    let dataSetCols = [];
    try {
      $.LoadingOverlay("show");
      response = await requisicao("GET", `/sisplan/funcoes/v1/pesquisa?`, `JSON={"tabela":"CUSTOMIZA ","camposSelect":["ID", "DESCRICAO", "PRECO", "MARGEM", "ATIVO", "SETOR"],"where": ["TIPO = 'BORDLOCAL'"],"limit": 1000}`, null, 20000)
      if (!response) {
        return;
      }
      const jsonStr = await response.json();
      if (response.status != 200) {
        msgErro(jsonStr.RESULT[0].mensagem);
        return;
      }
      if ($.isEmptyObject(jsonStr.RESULT[0])) {
        $('#tabelaLocalBordado').html(`<p class='d-flex justify-content-center border-Field' style="padding-top: 6px !important;">Nenhum registro encontrado</p>`);
        return;
      }
      const dataSet = jsonStr.RESULT[0];
      const keys = Object.keys(dataSet[0]);
      keys.forEach((value) => { dataSetCols.push({ title: value, data: value, }); });
      const botaoDinamico = {
        targets: [0],
        funcao: (data, type, row) => { return retornaBotaoOpcoes(data); }
      }
      criaDataTablePadrao('#tabelaLocalBordado', true, true, false, true, false, false, '200px', dataSet, dataSetCols, [], [], [], [2], botaoDinamico, 2, '', '', false, [], [3]);
      if ($('#tabelaLocalBordado').DataTable().rows().count() < 4) {
        $('#tabelaLocalBordado').css('min-height', '75px');
      }
    } catch (error) {
      console.error(error);
      msgErro("Não foi possível buscar os dados de Local do Bordado.");
    } finally {
      $.LoadingOverlay("hide");
    }
  }

  // Tabela Programação Bordado
  async function tabBordProgramacao() {
    let dataSetCols = [];
    try {
      $.LoadingOverlay("show");
      response = await requisicao("GET", `/sisplan/funcoes/v1/pesquisa?`, `JSON={"tabela":"CUSTOMIZA","camposSelect":["ID", "DESCRICAO", "PRECO", "ATIVO"],"where": ["TIPO = 'BORDPROG'"],"limit": 1000}`, null, 20000)
      if (!response) {
        return;
      }
      const jsonStr = await response.json();
      if (response.status != 200) {
        msgErro(jsonStr.RESULT[0].mensagem);
        return;
      }
      if ($.isEmptyObject(jsonStr.RESULT[0])) {
        $('#tabelaProgramacaoBordado').html(`<p class='d-flex justify-content-center border-Field' style="padding-top: 6px !important;">Nenhum registro encontrado</p>`);
        return;
      }
      const dataSet = jsonStr.RESULT[0];
      const keys = Object.keys(dataSet[0]);
      keys.forEach((value) => { dataSetCols.push({ title: value, data: value, }); });
      const botaoDinamico = {
        targets: [0],
        funcao: (data, type, row) => { return retornaBotaoOpcoes(data); }
      }
      criaDataTablePadrao('#tabelaProgramacaoBordado', true, true, false, true, false, false, '200px', dataSet, dataSetCols, [], [], [], [2], botaoDinamico);
      if ($('#tabelaProgramacaoBordado').DataTable().rows().count() < 4) {
        $('#tabelaProgramacaoBordado').css('min-height', '75px');
      }
    } catch (error) {
      console.error(error);
      msgErro("Não foi possível buscar os dados de Programação do Bordado.");
    } finally {
      $.LoadingOverlay("hide");
    }
  }

  // Tabela Tamanho Bordado
  async function tabBordTamanho() {
    let dataSetCols = [];
    try {
      $.LoadingOverlay("show");
      response = await requisicao("GET", `/sisplan/funcoes/v1/pesquisa?`, `JSON={"tabela":"CUSTOMIZA","camposSelect":["ID", "DESCRICAO", "PRECO", "ATIVO", "PONTOS", "TEMPO"],"where": ["TIPO = 'BORDTAM'"],"limit": 1000}`, null, 20000)
      if (!response) {
        return;
      }
      const jsonStr = await response.json();
      if (response.status != 200) {
        msgErro(jsonStr.RESULT[0].mensagem);
        return;
      }
      if ($.isEmptyObject(jsonStr.RESULT[0])) {
        $('#tabelaTamanhoBordado').html(`<p class='d-flex justify-content-center border-Field' style="padding-top: 6px !important;">Nenhum registro encontrado</p>`);
        return;
      }
      const dataSet = jsonStr.RESULT[0];
      const keys = Object.keys(dataSet[0]);
      keys.forEach((value) => { dataSetCols.push({ title: value, data: value, }); });
      const botaoDinamico = {
        targets: [0],
        funcao: (data, type, row) => { return retornaBotaoOpcoes(data); }
      }
      criaDataTablePadrao('#tabelaTamanhoBordado', true, true, false, true, false, false, '200px', dataSet, dataSetCols, [], [], [], [2], botaoDinamico, 2, '', '', false, [], [4, 5]);
      if ($('#tabelaTamanhoBordado').DataTable().rows().count() < 4) {
        $('#tabelaTamanhoBordado').css('min-height', '75px');
      }
    } catch (error) {
      console.error(error);
      msgErro("Não foi possível buscar os dados de Tamanho do Bordado.");
    } finally {
      $.LoadingOverlay("hide");
    }
  }

  // Tabela Sublimação
  async function tabSublimacao() {
    let dataSetCols = [];
    try {
      $.LoadingOverlay("show");
      response = await requisicao("GET", `/sisplan/funcoes/v1/pesquisa?`, `JSON={"tabela":"CUSTOMIZA","camposSelect":["ID", "DESCRICAO", "MARGEM", "VAL_PROG", "VAL_UNIT", "ATIVO", "SETOR", "TEMPO"],"where": ["TIPO = 'SUBLI'"],"limit": 1000}`, null, 20000)
      if (!response) {
        return;
      }
      const jsonStr = await response.json();
      if (response.status != 200) {
        msgErro(jsonStr.RESULT[0].mensagem);
        return;
      }
      if ($.isEmptyObject(jsonStr.RESULT[0])) {
        $('#tabelaSublimacao').html(`<p class='d-flex justify-content-center border-Field' style="padding-top: 6px !important;">Nenhum registro encontrado</p>`);
        return;
      }
      const dataSet = jsonStr.RESULT[0];
      const keys = Object.keys(dataSet[0]);
      keys.forEach((value) => { dataSetCols.push({ title: value, data: value, }); });
      const botaoDinamico = {
        targets: [0],
        funcao: (data, type, row) => { return retornaBotaoOpcoes(data); }
      }
      criaDataTablePadrao('#tabelaSublimacao', true, true, false, true, false, false, '200px', dataSet, dataSetCols, [], [], [], [2, 3, 4], botaoDinamico, 2, '', '', false, [], [7]);
      if ($('#tabelaSublimacao').DataTable().rows().count() < 4) {
        $('#tabelaSublimacao').css('min-height', '75px');
      }
    } catch (error) {
      console.error(error);
      msgErro("Não foi possível buscar os dados de Sublimação.");
    } finally {
      $.LoadingOverlay("hide");
    }
  }

  // Tabela Termotape
  async function tabTermotape() {
    let dataSetCols = [];
    try {
      $.LoadingOverlay("show");
      response = await requisicao("GET", `/sisplan/funcoes/v1/pesquisa?`, `JSON={"tabela":"CUSTOMIZA","camposSelect":["ID", "DESCRICAO", "MARGEM", "VAL_PROG", "VAL_UNIT", "ATIVO", "SETOR", "TEMPO"],"where": ["TIPO = 'TERMO'"],"limit": 1000}`, null, 20000)
      if (!response) {
        return;
      }
      const jsonStr = await response.json();
      if (response.status != 200) {
        msgErro(jsonStr.RESULT[0].mensagem);
        return;
      }
      if ($.isEmptyObject(jsonStr.RESULT[0])) {
        $('#tabelaTermotape').html(`<p class='d-flex justify-content-center border-Field' style="padding-top: 6px !important;">Nenhum registro encontrado</p>`);
        return;
      }
      const dataSet = jsonStr.RESULT[0];
      const keys = Object.keys(dataSet[0]);
      keys.forEach((value) => { dataSetCols.push({ title: value, data: value, }); });
      const botaoDinamico = {
        targets: [0],
        funcao: (data, type, row) => { return retornaBotaoOpcoes(data); }
      }
      criaDataTablePadrao('#tabelaTermotape', true, true, false, true, false, false, '200px', dataSet, dataSetCols, [], [], [], [2, 3, 4], botaoDinamico, 2, '', '', false, [], [7]);
      if ($('#tabelaTermotape').DataTable().rows().count() < 4) {
        $('#tabelaTermotape').css('min-height', '75px');
      }
    } catch (error) {
      console.error(error);
      msgErro("Não foi possível buscar os dados de Termotape.");
    } finally {
      $.LoadingOverlay("hide");
    }
  }

  // Tabela Local DTF
  async function tabDTFLocal() {
    let dataSetCols = [];
    try {
      $.LoadingOverlay("show");
      response = await requisicao("GET", `/sisplan/funcoes/v1/pesquisa?`, `JSON={"tabela":"CUSTOMIZA ","camposSelect":["ID", "DESCRICAO", "PRECO", "MARGEM", "ATIVO", "SETOR"],"where": ["TIPO = 'DTFLOCAL'"],"limit": 1000}`, null, 20000)
      if (!response) {
        return;
      }
      const jsonStr = await response.json();
      if (response.status != 200) {
        msgErro(jsonStr.RESULT[0].mensagem);
        return;
      }
      if ($.isEmptyObject(jsonStr.RESULT[0])) {
        $('#tabelaLocalDTF').html(`<p class='d-flex justify-content-center border-Field' style="padding-top: 6px !important;">Nenhum registro encontrado</p>`);
        return;
      }
      const dataSet = jsonStr.RESULT[0];
      const keys = Object.keys(dataSet[0]);
      keys.forEach((value) => { dataSetCols.push({ title: value, data: value, }); });
      const botaoDinamico = {
        targets: [0],
        funcao: (data, type, row) => { return retornaBotaoOpcoes(data); }
      }
      criaDataTablePadrao('#tabelaLocalDTF', true, true, false, true, false, false, '200px', dataSet, dataSetCols, [], [], [], [2], botaoDinamico, 2, '', '', false, [], [3]);
      if ($('#tabelaLocalDTF').DataTable().rows().count() < 4) {
        $('#tabelaLocalDTF').css('min-height', '75px');
      }
    } catch (error) {
      console.error(error);
      msgErro("Não foi possível buscar os dados de Local do DTF.");
    } finally {
      $.LoadingOverlay("hide");
    }
  }

  // Tabela Programação DTF
  async function tabDTFProgramacao() {
    let dataSetCols = [];
    try {
      $.LoadingOverlay("show");
      response = await requisicao("GET", `/sisplan/funcoes/v1/pesquisa?`, `JSON={"tabela":"CUSTOMIZA","camposSelect":["ID", "DESCRICAO", "PRECO", "ATIVO"],"where": ["TIPO = 'DTFPROG'"],"limit": 1000}`, null, 20000)
      if (!response) {
        return;
      }
      const jsonStr = await response.json();
      if (response.status != 200) {
        msgErro(jsonStr.RESULT[0].mensagem);
        return;
      }
      if ($.isEmptyObject(jsonStr.RESULT[0])) {
        $('#tabelaProgramacaoDTF').html(`<p class='d-flex justify-content-center border-Field' style="padding-top: 6px !important;">Nenhum registro encontrado</p>`);
        return;
      }
      const dataSet = jsonStr.RESULT[0];
      const keys = Object.keys(dataSet[0]);
      keys.forEach((value) => { dataSetCols.push({ title: value, data: value, }); });
      const botaoDinamico = {
        targets: [0],
        funcao: (data, type, row) => { return retornaBotaoOpcoes(data); }
      }
      criaDataTablePadrao('#tabelaProgramacaoDTF', true, true, false, true, false, false, '200px', dataSet, dataSetCols, [], [], [], [2], botaoDinamico);
      if ($('#tabelaProgramacaoDTF').DataTable().rows().count() < 4) {
        $('#tabelaProgramacaoDTF').css('min-height', '75px');
      }
    } catch (error) {
      console.error(error);
      msgErro("Não foi possível buscar os dados de Programação do DTF.");
    } finally {
      $.LoadingOverlay("hide");
    }
  }

  // Tabela Tamanho DTF
  async function tabDTFTamanho() {
    let dataSetCols = [];
    try {
      $.LoadingOverlay("show");
      response = await requisicao("GET", `/sisplan/funcoes/v1/pesquisa?`, `JSON={"tabela":"CUSTOMIZA","camposSelect":["ID", "DESCRICAO", "PRECO", "ATIVO", "PONTOS", "TEMPO"],"where": ["TIPO = 'DTFTAM'"],"limit": 1000}`, null, 20000)
      if (!response) {
        return;
      }
      const jsonStr = await response.json();
      if (response.status != 200) {
        msgErro(jsonStr.RESULT[0].mensagem);
        return;
      }
      if ($.isEmptyObject(jsonStr.RESULT[0])) {
        $('#tabelaTamanhoDTF').html(`<p class='d-flex justify-content-center border-Field' style="padding-top: 6px !important;">Nenhum registro encontrado</p>`);
        return;
      }
      const dataSet = jsonStr.RESULT[0];
      const keys = Object.keys(dataSet[0]);
      keys.forEach((value) => { dataSetCols.push({ title: value, data: value, }); });
      const botaoDinamico = {
        targets: [0],
        funcao: (data, type, row) => { return retornaBotaoOpcoes(data); }
      }
      criaDataTablePadrao('#tabelaTamanhoDTF', true, true, false, true, false, false, '200px', dataSet, dataSetCols, [], [], [], [2], botaoDinamico, 2, '', '', false, [], [4, 5]);
      if ($('#tabelaTamanhoDTF').DataTable().rows().count() < 4) {
        $('#tabelaTamanhoDTF').css('min-height', '75px');
      }
    } catch (error) {
      console.error(error);
      msgErro("Não foi possível buscar os dados de Tamanho do DTF.");
    } finally {
      $.LoadingOverlay("hide");
    }
  }

  await tabSerigLocal();
  await tabSerigTamanho();
  await tabSerigTipo();
  await tabBordLocal();
  await tabBordProgramacao();
  await tabBordTamanho();
  await tabSublimacao();
  await tabTermotape();
  await tabDTFLocal();
  await tabDTFProgramacao();
  await tabDTFTamanho();

  // Editar Local Serigrafia
  $('#tabelaLocalSerigrafia').on('click', '#btn-editar', async function () {
    $('#tabelaLocalSerigrafia').prop('disabled', true);
    $('#tabelaLocalSerigrafia button').prop('disabled', true);
    $('#tabelaLocalSerigrafia tr.selected').removeClass('selected');
    $(this).closest('tr').addClass('selected');

    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $('#tabelaLocalSerigrafia').DataTable().row($(this).parents('tr')).data();
      let id = Object.values(data)[0];
      let registroLiberado = await verificarRegistro('CUSTOMIZACAO', data[0]);

      if (registroLiberado) {
        // window.location.href = `aplicacao_pcp/${data[0]}`;
        try {
          $.LoadingOverlay("show");
          try {
            response = await requisicao("GET", `/sisplan/funcoes/v1/pesquisa?`, `JSON={"tabela":"CUSTOMIZA","camposSelect":["ID", "DESCRICAO", "PRECO", "MARGEM", "ATIVO", "SETOR"],"where": ["TIPO = 'SERIGLOCAL'", "ID = '${id}'"],"limit": 1000}`, null, 20000);
            if (!response) {
              return;
            }
            let jsonStr = await response.json();
            if (response.status != 200) {
              msgAlerta(jsonStr.RESULT[0].mensagem);
              return;
            }

            if (jsonStr.RESULT[0][0].ATIVO == "S") {
              $('#cbSerigrafiaLocal').prop('checked', true);
            }
            $("#txtIdLocalSerigrafia").val(jsonStr.RESULT[0][0].ID);
            $("#txtDescricaoLocalSerigrafia").val(jsonStr.RESULT[0][0].DESCRICAO);

            if (jsonStr.RESULT[0][0].SETOR !== '') {
              concatenado = await buscaValor("CADFLUXO", "DESCRICAO", "CODIGO", jsonStr.RESULT[0][0].SETOR);
              insereValor("#txtSetorLocalSerigrafia", jsonStr.RESULT[0][0].SETOR, concatenado.DESCRICAO);
            }

            $('#txtPrecoVUnitarioLocalSerigrafia').val(jsonStr.RESULT[0][0].PRECO);
            $('#txtMargemExpressLocalSerigrafia').val(jsonStr.RESULT[0][0].MARGEM);

            $(`#cbSerigrafiaLocal, 
              #txtDescricaoLocalSerigrafia, 
              #txtSetorLocalSerigrafia, #btnSetorLocalSerigrafia, #btnLimpaSetorLocalSerigrafia, 
              #txtPrecoVUnitarioLocalSerigrafia,
              #txtMargemExpressLocalSerigrafia`).prop("disabled", false);

            $(`#btnCancelarLocalSerigrafia, #btnGravarLocalSerigrafia`).removeClass('d-none')
            $(`#btnIncluirLocalSerigrafia`).addClass('d-none')

            $("#txtDescricaoLocalSerigrafia").focus();
          } catch (error) {
            console.error(error);
            msgAlerta(`Não foi possível buscar os dados:`);
          }
        } finally {
          $.LoadingOverlay("hide");
        }
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  // Editar Tamanho Serigrafia
  $('#tabelaTamanhoSerigrafia').on('click', '#btn-editar', async function () {
    $('#tabelaTamanhoSerigrafia').prop('disabled', true);
    $('#tabelaTamanhoSerigrafia button').prop('disabled', true);
    $('#tabelaTamanhoSerigrafia tr.selected').removeClass('selected');
    $(this).closest('tr').addClass('selected');

    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $('#tabelaTamanhoSerigrafia').DataTable().row($(this).parents('tr')).data();
      let id = Object.values(data)[0];
      let registroLiberado = await verificarRegistro('CUSTOMIZACAO', data[0]);

      if (registroLiberado) {
        try {
          $.LoadingOverlay("show");
          try {
            response = await requisicao("GET", `/sisplan/funcoes/v1/pesquisa?`, `JSON={"tabela":"CUSTOMIZA","camposSelect":["ID", "DESCRICAO", "ATIVO"],"where": ["TIPO = 'SERIGTAM'", "ID = '${id}'"],"limit": 1000}`, null, 20000);
            if (!response) {
              return;
            }
            let jsonStr = await response.json();
            if (response.status != 200) {
              msgAlerta(jsonStr.RESULT[0].mensagem);
              return;
            }

            if (jsonStr.RESULT[0][0].ATIVO == "S") {
              $('#cbTamanhoSerigrafia').prop('checked', true);
            }
            $("#txtIdTamanhoSerigrafia").val(jsonStr.RESULT[0][0].ID);
            $("#txtDescricaoTamanhoSerigrafia").val(jsonStr.RESULT[0][0].DESCRICAO);


            $(`#cbTamanhoSerigrafia, #txtDescricaoTamanhoSerigrafia`).prop("disabled", false);

            $(`#btnCancelarTamanhoSerigrafia, #btnGravarTamanhoSerigrafia`).removeClass('d-none')
            $(`#btnIncluirTamanhoSerigrafia`).addClass('d-none')

            $("#txtDescricaoTamanhoSerigrafia").focus();
          } catch (error) {
            console.error(error);
            msgAlerta(`Não foi possível buscar os dados:`);
          }
        } finally {
          $.LoadingOverlay("hide");
        }
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  // Editar Tipo Serigrafia
  $('#tabelaTipoSerigrafia').on('click', '#btn-editar', async function () {
    $('#tabelaTipoSerigrafia').prop('disabled', true);
    $('#tabelaTipoSerigrafia button').prop('disabled', true);
    $('#tabelaTipoSerigrafia tr.selected').removeClass('selected');
    $(this).closest('tr').addClass('selected');

    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $('#tabelaTipoSerigrafia').DataTable().row($(this).parents('tr')).data();
      let id = Object.values(data)[0];
      let registroLiberado = await verificarRegistro('CUSTOMIZACAO', data[0]);

      if (registroLiberado) {
        try {
          $.LoadingOverlay("show");
          try {
            response = await requisicao("GET", `/sisplan/funcoes/v1/pesquisa?`, `JSON={
              "tabela": "CUSTOMIZA",
              "camposSelect": [
                "CUSTOMIZA.ID",
                "CUSTOMIZA.DESCRICAO",
                "CUSTOMIZA.MARGEM",
                "CUSTOMIZA.VAL_TELA",
                "CUSTOMIZA.VAL_FOTO",
                "CUSTOMIZA.VAL_COR",
                "CUSTOMIZA.QTDE_COR",
                "CUSTOMIZA.ID_TAMANHO",
                "CAD_CUST_TAM.DESCRICAO DESC_TAM",
                "CUSTOMIZA.ATIVO",
                "CAD_CUST_TAM.ID ID_TAM",
                "CUSTOMIZA.TEMPO"
              ],
              "leftjoin": [
                {
                  "tabela": "CUSTOMIZA",
                  "alias": "CAD_CUST_TAM",
                  "condicao": "CAD_CUST_TAM.ID = CUSTOMIZA.ID_TAMANHO"
                }
              ],
              "where": ["CUSTOMIZA.TIPO = 'SERIGTIPO'", "CUSTOMIZA.ID = '${id}'"]
            }`, null, 20000)
            if (!response) {
              return;
            }
            let jsonStr = await response.json();
            if (response.status != 200) {
              msgAlerta(jsonStr.RESULT[0].mensagem);
              return;
            }

            if (jsonStr.RESULT[0][0].ATIVO == "S") {
              $('#cbSerigrafiaTipo').prop('checked', true);
            }
            $("#txtIdTipoSerigrafia").val(jsonStr.RESULT[0][0].ID);
            $("#txtDescricaoTipoSerigrafia").val(jsonStr.RESULT[0][0].DESCRICAO);

            concatenado = await buscaValor("CUSTOMIZA", "DESCRICAO", "ID", jsonStr.RESULT[0][0].ID_TAM);
            insereValor("#txtTamanhoTipoSerigrafia", jsonStr.RESULT[0][0].ID_TAM, concatenado.DESCRICAO);

            $("#txtPercMargemTipoSerigrafia").val(jsonStr.RESULT[0][0].MARGEM);
            $("#txtTempoTipoSerigrafia").val(jsonStr.RESULT[0][0].TEMPO);
            $("#txtTelaTipoSerigrafia").val(jsonStr.RESULT[0][0].VAL_TELA);
            $("#txtFotolitoTipoSerigrafia").val(jsonStr.RESULT[0][0].VAL_FOTO);
            $("#txtValorCorTipoSerigrafia").val(jsonStr.RESULT[0][0].VAL_COR);
            $("#txtQuantidadeCorTipoSerigrafia").val(jsonStr.RESULT[0][0].QTDE_COR);


            $(`#cbSerigrafiaTipo, 
            #txtDescricaoTipoSerigrafia, 
            #txtTamanhoTipoSerigrafia, #btnTamanhoTipoSerigrafia, #btnLimpaTamanhoTipoSerigrafia, 
            #txtPercMargemTipoSerigrafia,
            #txtTempoTipoSerigrafia,
            #txtTelaTipoSerigrafia, #txtFotolitoTipoSerigrafia,
            #txtValorCorTipoSerigrafia, #txtQuantidadeCorTipoSerigrafia`).prop("disabled", false);

            $(`#btnCancelarTipoSerigrafia, #btnGravarTipoSerigrafia`).removeClass('d-none')
            $(`#btnIncluirTipoSerigrafia`).addClass('d-none')

            $("#txtDescricaoTipoSerigrafia").focus();
          } catch (error) {
            console.error(error);
            msgAlerta(`Não foi possível buscar os dados:`);
          }
        } finally {
          $.LoadingOverlay("hide");
        }
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  // Editar Local Bordado
  $('#tabelaLocalBordado').on('click', '#btn-editar', async function () {
    $('#tabelaLocalBordado').prop('disabled', true);
    $('#tabelaLocalBordado button').prop('disabled', true);
    $('#tabelaLocalBordado tr.selected').removeClass('selected');
    $(this).closest('tr').addClass('selected');

    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $('#tabelaLocalBordado').DataTable().row($(this).parents('tr')).data();
      let id = Object.values(data)[0];
      let registroLiberado = await verificarRegistro('CUSTOMIZACAO', data[0]);

      if (registroLiberado) {
        // window.location.href = `aplicacao_pcp/${data[0]}`;
        try {
          $.LoadingOverlay("show");
          try {
            response = await requisicao("GET", `/sisplan/funcoes/v1/pesquisa?`, `JSON={"tabela":"CUSTOMIZA ","camposSelect":["ID", "DESCRICAO", "PRECO", "MARGEM", "ATIVO", "SETOR"],"where": ["TIPO = 'BORDLOCAL'", "ID = '${id}'"],"limit": 1000}`, null, 20000);
            if (!response) {
              return;
            }
            let jsonStr = await response.json();
            if (response.status != 200) {
              msgAlerta(jsonStr.RESULT[0].mensagem);
              return;
            }

            if (jsonStr.RESULT[0][0].ATIVO == "S") {
              $('#cbBordadoLocal').prop('checked', true);
            }
            $("#txtIdLocalBordado").val(jsonStr.RESULT[0][0].ID);
            $("#txtDescricaoLocalBordado").val(jsonStr.RESULT[0][0].DESCRICAO);

            if (jsonStr.RESULT[0][0].SETOR !== '') {
              concatenado = await buscaValor("CADFLUXO", "DESCRICAO", "CODIGO", jsonStr.RESULT[0][0].SETOR);
              insereValor("#txtSetorLocalBordado", jsonStr.RESULT[0][0].SETOR, concatenado.DESCRICAO);
            }

            $('#txtPrecoVUnitarioLocalBordado').val(jsonStr.RESULT[0][0].PRECO);
            $('#txtMargemExpressLocalBordado').val(jsonStr.RESULT[0][0].MARGEM);

            $(`#cbBordadoLocal, 
            #txtDescricaoLocalBordado, 
            #txtSetorLocalBordado, #btnSetorLocalBordado, #btnLimpaSetorLocalBordado,
            #txtPrecoVUnitarioLocalBordado, #txtMargemExpressLocalBordado
            `).prop("disabled", false);

            $(`#btnCancelarLocalBordado, #btnGravarLocalBordado`).removeClass('d-none')
            $(`#btnIncluirLocalBordado`).addClass('d-none')

            $("#txtDescricaoLocalBordado").focus();
          } catch (error) {
            console.error(error);
            msgAlerta(`Não foi possível buscar os dados:`);
          }
        } finally {
          $.LoadingOverlay("hide");
        }
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  // Editar Programação Bordado
  $('#tabelaProgramacaoBordado').on('click', '#btn-editar', async function () {
    $('#tabelaProgramacaoBordado').prop('disabled', true);
    $('#tabelaProgramacaoBordado button').prop('disabled', true);
    $('#tabelaProgramacaoBordado tr.selected').removeClass('selected');
    $(this).closest('tr').addClass('selected');

    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $('#tabelaProgramacaoBordado').DataTable().row($(this).parents('tr')).data();
      let id = Object.values(data)[0];
      let registroLiberado = await verificarRegistro('CUSTOMIZACAO', data[0]);

      if (registroLiberado) {
        // window.location.href = `aplicacao_pcp/${data[0]}`;
        try {
          $.LoadingOverlay("show");
          try {
            response = await requisicao("GET", `/sisplan/funcoes/v1/pesquisa?`, `JSON={"tabela":"CUSTOMIZA","camposSelect":["ID", "DESCRICAO", "PRECO", "ATIVO"],"where": ["TIPO = 'BORDPROG'", "ID = '${id}'"],"limit": 1000}`, null, 20000)
            if (!response) {
              return;
            }
            let jsonStr = await response.json();
            if (response.status != 200) {
              msgAlerta(jsonStr.RESULT[0].mensagem);
              return;
            }

            if (jsonStr.RESULT[0][0].ATIVO == "S") {
              $('#cbProgramacaoBordado').prop('checked', true);
            }
            $("#txtIdProgramacaoBordado").val(jsonStr.RESULT[0][0].ID);
            $("#txtDescricaoProgramacaoBordado").val(jsonStr.RESULT[0][0].DESCRICAO);
            $('#txtPrecoVProgramacaoBordado').val(jsonStr.RESULT[0][0].PRECO);

            $(`#cbProgramacaoBordado, 
            #txtDescricaoProgramacaoBordado, 
            #txtPrecoVProgramacaoBordado`).prop("disabled", false);

            $(`#btnCancelarProgramacaoBordado, #btnGravarProgramacaoBordado`).removeClass('d-none')
            $(`#btnIncluirProgramacaoBordado`).addClass('d-none')

            $("#txtDescricaoProgramacaoBordado").focus();
          } catch (error) {
            console.error(error);
            msgAlerta(`Não foi possível buscar os dados:`);
          }
        } finally {
          $.LoadingOverlay("hide");
        }
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  // Editar Tamanho Bordado
  $('#tabelaTamanhoBordado').on('click', '#btn-editar', async function () {
    $('#tabelaTamanhoBordado').prop('disabled', true);
    $('#tabelaTamanhoBordado button').prop('disabled', true);
    $('#tabelaTamanhoBordado tr.selected').removeClass('selected');
    $(this).closest('tr').addClass('selected');

    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $('#tabelaTamanhoBordado').DataTable().row($(this).parents('tr')).data();
      let id = Object.values(data)[0];
      let registroLiberado = await verificarRegistro('CUSTOMIZACAO', data[0]);

      if (registroLiberado) {
        // window.location.href = `aplicacao_pcp/${data[0]}`;
        try {
          $.LoadingOverlay("show");
          try {
            response = await requisicao("GET", `/sisplan/funcoes/v1/pesquisa?`, `JSON={"tabela":"CUSTOMIZA","camposSelect":["ID", "DESCRICAO", "PRECO", "ATIVO", "PONTOS", "TEMPO"],"where": ["TIPO = 'BORDTAM'", "ID = '${id}'"],"limit": 1000}`, null, 20000)
            if (!response) {
              return;
            }
            let jsonStr = await response.json();
            if (response.status != 200) {
              msgAlerta(jsonStr.RESULT[0].mensagem);
              return;
            }

            if (jsonStr.RESULT[0][0].ATIVO == "S") {
              $('#cbBordadoTamanho').prop('checked', true);
            }
            $("#txtIdTamanhoBordado").val(jsonStr.RESULT[0][0].ID);
            $("#txtDescricaoTamanhoBordado").val(jsonStr.RESULT[0][0].DESCRICAO);
            $('#txtPrecoVTamanhoBordado').val(jsonStr.RESULT[0][0].PRECO);
            $('#txtQtdePontosTamanhoBordado').val(jsonStr.RESULT[0][0].PONTOS);
            $('#txtTempoTamanhoBordado').val(jsonStr.RESULT[0][0].TEMPO);

            $(`#cbBordadoTamanho,
            #txtDescricaoTamanhoBordado, 
            #txtPrecoVTamanhoBordado, 
            #txtQtdePontosTamanhoBordado,
            #txtTempoTamanhoBordado`).prop("disabled", false);

            $(`#btnCancelarTamanhoBordado, #btnGravarTamanhoBordado`).removeClass('d-none')
            $(`#btnIncluirTamanhoBordado`).addClass('d-none')

            $("#txtDescricaoTamanhoBordado").focus();
          } catch (error) {
            console.error(error);
            msgAlerta(`Não foi possível buscar os dados:`);
          }
        } finally {
          $.LoadingOverlay("hide");
        }
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  // Editar Sublimação
  $('#tabelaSublimacao').on('click', '#btn-editar', async function () {
    $('#tabelaSublimacao').prop('disabled', true);
    $('#tabelaSublimacao button').prop('disabled', true);
    $('#tabelaSublimacao tr.selected').removeClass('selected');
    $(this).closest('tr').addClass('selected');

    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $('#tabelaSublimacao').DataTable().row($(this).parents('tr')).data();
      let id = Object.values(data)[0];
      let registroLiberado = await verificarRegistro('CUSTOMIZACAO', data[0]);

      if (registroLiberado) {
        try {
          $.LoadingOverlay("show");
          try {
            response = await requisicao("GET", `/sisplan/funcoes/v1/pesquisa?`, `JSON={"tabela":"CUSTOMIZA","camposSelect":["ID", "DESCRICAO", "MARGEM", "VAL_PROG", "VAL_UNIT", "ATIVO", "SETOR", "TEMPO"],"where": ["TIPO = 'SUBLI'", "ID = '${id}'"],"limit": 1000}`, null, 20000)
            if (!response) {
              return;
            }
            let jsonStr = await response.json();
            if (response.status != 200) {
              msgAlerta(jsonStr.RESULT[0].mensagem);
              return;
            }

            if (jsonStr.RESULT[0][0].ATIVO == "S") {
              $('#cbSublimacaoAtivo').prop('checked', true);
            }
            $("#txtIdSublimacao").val(jsonStr.RESULT[0][0].ID);
            $("#txtDescricaoSublimacao").val(jsonStr.RESULT[0][0].DESCRICAO);

            if (jsonStr.RESULT[0][0].SETOR !== '') {
              concatenado = await buscaValor("CADFLUXO", "DESCRICAO", "CODIGO", jsonStr.RESULT[0][0].SETOR);
              insereValor("#txtSetorSublimacao", jsonStr.RESULT[0][0].SETOR, concatenado.DESCRICAO);
            }

            $('#txtTempoSublimacao').val(jsonStr.RESULT[0][0].TEMPO);
            $('#txtMargemExpressSublimacao').val(jsonStr.RESULT[0][0].MARGEM);
            $('#txtValProgramacaoSublimacao').val(jsonStr.RESULT[0][0].VAL_PROG);
            $('#txtValUnitarioSublimacao').val(jsonStr.RESULT[0][0].VAL_UNIT);

            $(`#cbSublimacaoAtivo,
            #txtDescricaoSublimacao,
            #txtSetorSublimacao, #btnSetorSublimacao, #btnLimpaSetorSublimacao,
            #txtTempoSublimacao,
            #txtMargemExpressSublimacao, 
            #txtValProgramacaoSublimacao,
            #txtValUnitarioSublimacao`).prop("disabled", false);

            $(`#btnCancelarSublimacao, #btnGravarSublimacao`).removeClass('d-none');
            $(`#btnIncluirSublimacao`).addClass('d-none');

            $("#txtDescricaoSublimacao").focus();
          } catch (error) {
            console.error(error);
            msgAlerta(`Não foi possível buscar os dados:`);
          }
        } finally {
          $.LoadingOverlay("hide");
        }
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  // Editar Termotape
  $('#tabelaTermotape').on('click', '#btn-editar', async function () {
    $('#tabelaTermotape').prop('disabled', true);
    $('#tabelaTermotape button').prop('disabled', true);
    $('#tabelaTermotape tr.selected').removeClass('selected');
    $(this).closest('tr').addClass('selected');
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $('#tabelaTermotape').DataTable().row($(this).parents('tr')).data();
      let id = Object.values(data)[0];
      let registroLiberado = await verificarRegistro('CUSTOMIZACAO', data[0]);

      if (registroLiberado) {
        // window.location.href = `aplicacao_pcp/${data[0]}`;
        try {
          $.LoadingOverlay("show");
          try {
            response = await requisicao("GET", `/sisplan/funcoes/v1/pesquisa?`, `JSON={"tabela":"CUSTOMIZA","camposSelect":["ID", "DESCRICAO", "MARGEM", "VAL_PROG", "VAL_UNIT", "ATIVO", "SETOR", "TEMPO"],"where": ["TIPO = 'TERMO'", "ID = '${id}'"],"limit": 1000}`, null, 20000)
            if (!response) {
              return;
            }
            let jsonStr = await response.json();
            if (response.status != 200) {
              msgAlerta(jsonStr.RESULT[0].mensagem);
              return;
            }

            if (jsonStr.RESULT[0][0].ATIVO == "S") {
              $('#cbTermotapeAtivo').prop('checked', true);
            }
            $("#txtIdTermotape").val(jsonStr.RESULT[0][0].ID);
            $("#txtDescricaoTermotape").val(jsonStr.RESULT[0][0].DESCRICAO);

            if (jsonStr.RESULT[0][0].SETOR !== '') {
              concatenado = await buscaValor("CADFLUXO", "DESCRICAO", "CODIGO", jsonStr.RESULT[0][0].SETOR);
              insereValor("#txtSetorTermotape", jsonStr.RESULT[0][0].SETOR, concatenado.DESCRICAO);
            }

            $('#txtTempoTermotape').val(jsonStr.RESULT[0][0].TEMPO);
            $('#txtMargemExpressTermotape').val(jsonStr.RESULT[0][0].MARGEM);
            $('#txtValProgramacaoTermotape').val(jsonStr.RESULT[0][0].VAL_PROG);
            $('#txtValUnitarioTermotape').val(jsonStr.RESULT[0][0].VAL_UNIT);


            $(`#cbTermotapeAtivo,
            #txtDescricaoTermotape,
            #txtSetorTermotape, #btnSetorTermotape, #btnLimpaSetorTermotape,
            #txtTempoTermotape, #txtMargemExpressTermotape, #txtValProgramacaoTermotape, #txtValUnitarioTermotape`).prop("disabled", false);

            $(`#btnCancelarTermotape, #btnGravarTermotape`).removeClass('d-none')
            $(`#btnIncluirTermotape`).addClass('d-none')

            $("#txtDescricaoTermotape").focus();
          } catch (error) {
            console.error(error);
            msgAlerta(`Não foi possível buscar os dados:`);
          }
        } finally {
          $.LoadingOverlay("hide");
        }
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  // Editar Lolcal DTF
  $('#tabelaLocalDTF').on('click', '#btn-editar', async function () {
    $('#tabelaLocalDTF').prop('disabled', true);
    $('#tabelaLocalDTF button').prop('disabled', true);
    $('#tabelaLocalDTF tr.selected').removeClass('selected');
    $(this).closest('tr').addClass('selected');

    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $('#tabelaLocalDTF').DataTable().row($(this).parents('tr')).data();
      let id = Object.values(data)[0];
      let registroLiberado = await verificarRegistro('CUSTOMIZACAO', data[0]);

      if (registroLiberado) {
        try {
          $.LoadingOverlay("show");
          try {
            response = await requisicao("GET", `/sisplan/funcoes/v1/pesquisa?`, `JSON={"tabela":"CUSTOMIZA ","camposSelect":["ID", "DESCRICAO", "PRECO", "MARGEM", "ATIVO", "SETOR"],"where": ["TIPO = 'DTFLOCAL'", "ID = '${id}'"],"limit": 1000}`, null, 20000);
            if (!response) {
              return;
            }
            let jsonStr = await response.json();
            if (response.status != 200) {
              msgAlerta(jsonStr.RESULT[0].mensagem);
              return;
            }

            if (jsonStr.RESULT[0][0].ATIVO == "S") {
              $('#cbDTFLocal').prop('checked', true);
            }
            $("#txtIdLocalDTF").val(jsonStr.RESULT[0][0].ID);
            $("#txtDescricaoLocalDTF").val(jsonStr.RESULT[0][0].DESCRICAO);

            if (jsonStr.RESULT[0][0].SETOR !== '') {
              concatenado = await buscaValor("CADFLUXO", "DESCRICAO", "CODIGO", jsonStr.RESULT[0][0].SETOR);
              insereValor("#txtSetorLocalDTF", jsonStr.RESULT[0][0].SETOR, concatenado.DESCRICAO);
            }

            $('#txtPrecoVUnitarioLocalDTF').val(jsonStr.RESULT[0][0].PRECO);
            $('#txtMargemExpressLocalDTF').val(jsonStr.RESULT[0][0].MARGEM);

            $(`#cbDTFLocal, 
            #txtDescricaoLocalDTF, 
            #txtSetorLocalDTF, #btnSetorLocalDTF, #btnLimpaSetorLocalDTF,
            #txtPrecoVUnitarioLocalDTF, #txtMargemExpressLocalDTF
            `).prop("disabled", false);

            $(`#btnCancelarLocalDTF, #btnGravarLocalDTF`).removeClass('d-none')
            $(`#btnIncluirLocalDTF`).addClass('d-none')

            $("#txtDescricaoLocalDTF").focus();
          } catch (error) {
            console.error(error);
            msgAlerta(`Não foi possível buscar os dados:`);
          }
        } finally {
          $.LoadingOverlay("hide");
        }
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  // Editar Programação DTF
  $('#tabelaProgramacaoDTF').on('click', '#btn-editar', async function () {
    $('#tabelaProgramacaoDTF').prop('disabled', true);
    $('#tabelaProgramacaoDTF button').prop('disabled', true);
    $('#tabelaProgramacaoDTF tr.selected').removeClass('selected');
    $(this).closest('tr').addClass('selected');

    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $('#tabelaProgramacaoDTF').DataTable().row($(this).parents('tr')).data();
      let id = Object.values(data)[0];
      let registroLiberado = await verificarRegistro('CUSTOMIZACAO', data[0]);

      if (registroLiberado) {
        try {
          $.LoadingOverlay("show");
          try {
            response = await requisicao("GET", `/sisplan/funcoes/v1/pesquisa?`, `JSON={"tabela":"CUSTOMIZA","camposSelect":["ID", "DESCRICAO", "PRECO", "ATIVO"],"where": ["TIPO = 'DTFPROG'", "ID = '${id}'"],"limit": 1000}`, null, 20000)
            if (!response) {
              return;
            }
            let jsonStr = await response.json();
            if (response.status != 200) {
              msgAlerta(jsonStr.RESULT[0].mensagem);
              return;
            }

            if (jsonStr.RESULT[0][0].ATIVO == "S") {
              $('#cbProgramacaoDTF').prop('checked', true);
            }
            $("#txtIdProgramacaoDTF").val(jsonStr.RESULT[0][0].ID);
            $("#txtDescricaoProgramacaoDTF").val(jsonStr.RESULT[0][0].DESCRICAO);
            $('#txtPrecoVProgramacaoDTF').val(jsonStr.RESULT[0][0].PRECO);

            $(`#cbProgramacaoDTF, 
            #txtDescricaoProgramacaoDTF, 
            #txtPrecoVProgramacaoDTF`).prop("disabled", false);

            $(`#btnCancelarProgramacaoDTF, #btnGravarProgramacaoDTF`).removeClass('d-none')
            $(`#btnIncluirProgramacaoDTF`).addClass('d-none')

            $("#txtDescricaoProgramacaoDTF").focus();
          } catch (error) {
            console.error(error);
            msgAlerta(`Não foi possível buscar os dados:`);
          }
        } finally {
          $.LoadingOverlay("hide");
        }
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  // Editar Tamanho DTF
  $('#tabelaTamanhoDTF').on('click', '#btn-editar', async function () {
    $('#tabelaTamanhoDTF').prop('disabled', true);
    $('#tabelaTamanhoDTF button').prop('disabled', true);
    $('#tabelaTamanhoDTF tr.selected').removeClass('selected');
    $(this).closest('tr').addClass('selected');

    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $('#tabelaTamanhoDTF').DataTable().row($(this).parents('tr')).data();
      let id = Object.values(data)[0];
      let registroLiberado = await verificarRegistro('CUSTOMIZACAO', data[0]);

      if (registroLiberado) {
        // window.location.href = `aplicacao_pcp/${data[0]}`;
        try {
          $.LoadingOverlay("show");
          try {
            response = await requisicao("GET", `/sisplan/funcoes/v1/pesquisa?`, `JSON={"tabela":"CUSTOMIZA","camposSelect":["ID", "DESCRICAO", "PRECO", "ATIVO", "PONTOS", "TEMPO"],"where": ["TIPO = 'DTFTAM'", "ID = '${id}'"],"limit": 1000}`, null, 20000)
            if (!response) {
              return;
            }
            let jsonStr = await response.json();
            if (response.status != 200) {
              msgAlerta(jsonStr.RESULT[0].mensagem);
              return;
            }

            if (jsonStr.RESULT[0][0].ATIVO == "S") {
              $('#cbDTFTamanho').prop('checked', true);
            }
            $("#txtIdTamanhoDTF").val(jsonStr.RESULT[0][0].ID);
            $("#txtDescricaoTamanhoDTF").val(jsonStr.RESULT[0][0].DESCRICAO);
            $('#txtPrecoVTamanhoDTF').val(jsonStr.RESULT[0][0].PRECO);
            $('#txtQtdePontosTamanhoDTF').val(jsonStr.RESULT[0][0].PONTOS);
            $('#txtTempoTamanhoDTF').val(jsonStr.RESULT[0][0].TEMPO);

            $(`#cbDTFTamanho,
            #txtDescricaoTamanhoDTF, 
            #txtPrecoVTamanhoDTF, 
            #txtQtdePontosTamanhoDTF,
            #txtTempoTamanhoDTF`).prop("disabled", false);

            $(`#btnCancelarTamanhoDTF, #btnGravarTamanhoDTF`).removeClass('d-none')
            $(`#btnIncluirTamanhoDTF`).addClass('d-none')

            $("#txtDescricaoTamanhoDTF").focus();
          } catch (error) {
            console.error(error);
            msgAlerta(`Não foi possível buscar os dados:`);
          }
        } finally {
          $.LoadingOverlay("hide");
        }
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });



  // Botões de gravar
  $('#btnGravarLocalSerigrafia').on('click', async function () {
    await gravaLocalSerigrafia()
  })

  $('#btnGravarTamanhoSerigrafia').on('click', async function () {
    await gravaTamanhoSerigrafia()
  })

  $('#btnGravarTipoSerigrafia').on('click', async function () {
    await gravaTipoSerigrafia()
  })

  $('#btnGravarLocalBordado').on('click', async function () {
    await gravaLocalBordado()
  })

  $('#btnGravarProgramacaoBordado').on('click', async function () {
    await gravaProgramacaoBordado()
  })

  $('#btnGravarTamanhoBordado').on('click', async function () {
    await gravaTamanhoBordado()
  })

  $('#btnGravarSublimacao').on('click', async function () {
    await gravaSublimacao()
  })

  $('#btnGravarTermotape').on('click', async function () {
    await gravaTermotape()
  })

  $('#btnGravarLocalDTF').on('click', async function () {
    await gravaLocalDTF()
  })

  $('#btnGravarProgramacaoDTF').on('click', async function () {
    await gravaProgramacaoDTF()
  })

  $('#btnGravarTamanhoDTF').on('click', async function () {
    await gravaTamanhoDTF()
  })

  // Função Gravar Local Serigrafia
  async function gravaLocalSerigrafia() {
    $.LoadingOverlay('show')
    try {
      if ($('#txtDescricaoLocalSerigrafia').val() == '') {
        msgAlerta('Preencha o campo Descrição');
        return;
      }
      let objeto = {}

      objeto.ATIVO = $('#cbSerigrafiaLocal').is(':checked') ? 'S' : 'N';
      objeto.ID = $('#txtIdLocalSerigrafia').val() == '' ? await RetornaProximo("ID", "CUSTOMIZA", "ID", 4) : $('#txtIdLocalSerigrafia').val();
      objeto.DESCRICAO = $('#txtDescricaoLocalSerigrafia').val().toUpperCase();
      objeto.PRECO = $('#txtPrecoVUnitarioLocalSerigrafia').val();
      objeto.MARGEM = $("#txtMargemExpressLocalSerigrafia").val();
      objeto.TIPO = "SERIGLOCAL";
      objeto.SETOR = pegaChave("#txtSetorLocalSerigrafia");

      let response = await requisicao("POST", `/Sisplan/cadastros/V1/customizacao?`, `EMP_ID=${getCookie('emp_id')}&JSON=${JSON.stringify(objeto)}`, 15000);
      if (!response) {
        return;
      }
      if (response.objeto != 200) {
        toastr.success(
          `Cadastro efetuado com sucesso!
           Local Serigrafia: ${objeto.ID}`,
          'Confirmação', {
          toastClass: 'alert',
          iconClasses: {
            error: 'alert-error',
            info: 'alert-info',
            success: 'alert-success',
            warning: 'alert-warning'
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000,
          onHidden() {
            window.location.href = `${BASE_URI}/customizacao`;
          }
        }).css({
          "margin-top": "20%",
          "width": "500px",
          "max-width": "500px"
        });
        return;
      }
    } catch (err) {
      console.log(err);
      msgAlerta('Não foi possivel gravar os dados.')
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  // Função Gravar Tamanho Serigrafia
  async function gravaTamanhoSerigrafia() {
    $.LoadingOverlay('show')
    try {
      if ($('#txtDescricaoTamanhoSerigrafia').val() == '') {
        msgAlerta('Preencha o campo Descrição');
        return;
      }
      let objeto = {}

      objeto.ATIVO = $('#cbTamanhoSerigrafia').is(':checked') ? 'S' : 'N';
      objeto.ID = $('#txtIdTamanhoSerigrafia').val() == '' ? await RetornaProximo("ID", "CUSTOMIZA", "ID", 4) : $('#txtIdTamanhoSerigrafia').val();
      objeto.DESCRICAO = $('#txtDescricaoTamanhoSerigrafia').val().toUpperCase();
      objeto.TIPO = "SERIGTAM";

      let response = await requisicao("POST", `/Sisplan/cadastros/V1/customizacao?`, `EMP_ID=${getCookie('emp_id')}&JSON=${JSON.stringify(objeto)}`, 15000);
      if (!response) {
        return;
      }
      if (response.objeto != 200) {
        toastr.success(
          `Cadastro efetuado com sucesso!
           Tamanho Serigrafia: ${objeto.ID}`,
          'Confirmação', {
          toastClass: 'alert',
          iconClasses: {
            error: 'alert-error',
            info: 'alert-info',
            success: 'alert-success',
            warning: 'alert-warning'
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000,
          onHidden() {
            window.location.href = `${BASE_URI}/customizacao`;
          }
        }).css({
          "margin-top": "20%",
          "width": "500px",
          "max-width": "500px"
        });
        return;
      }
    } catch (err) {
      console.log(err);
      msgAlerta('Não foi possivel gravar os dados.')
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  // Função Gravar Tipo Serigrafia
  async function gravaTipoSerigrafia() {
    $.LoadingOverlay('show')
    try {
      if ($('#txtDescricaoTipoSerigrafia').val() == '') {
        msgAlerta('Preencha o campo Descrição');
        return;
      }
      if ($('#txtTamanhoTipoSerigrafia').val() == '') {
        msgAlerta('Preencha o campo Tamanho');
        return;
      }
      let objeto = {}

      objeto.ATIVO = $('#cbSerigrafiaTipo').is(':checked') ? 'S' : 'N';
      objeto.TIPO = "SERIGTIPO";
      objeto.ID = $('#txtIdTipoSerigrafia').val() == '' ? await RetornaProximo("ID", "CUSTOMIZA", "ID", 4) : $('#txtIdTipoSerigrafia').val();
      objeto.DESCRICAO = $('#txtDescricaoTipoSerigrafia').val().toUpperCase();
      objeto.MARGEM = $("#txtPercMargemTipoSerigrafia").val();
      objeto.ID_TAMANHO = pegaChave("#txtTamanhoTipoSerigrafia");
      objeto.VAL_TELA = $("#txtTelaTipoSerigrafia").val();
      objeto.VAL_FOTO = $("#txtFotolitoTipoSerigrafia").val();
      objeto.VAL_COR = $("#txtValorCorTipoSerigrafia").val();
      objeto.QTDE_COR = $("#txtQuantidadeCorTipoSerigrafia").val();
      objeto.TEMPO = $("#txtTempoTipoSerigrafia").val();


      let response = await requisicao("POST", `/Sisplan/cadastros/V1/customizacao?`, `EMP_ID=${getCookie('emp_id')}&JSON=${JSON.stringify(objeto)}`, 15000);
      if (!response) {
        return;
      }
      if (response.objeto != 200) {
        toastr.success(
          `Cadastro efetuado com sucesso!
           Tipo Serigrafia: ${objeto.ID}`,
          'Confirmação', {
          toastClass: 'alert',
          iconClasses: {
            error: 'alert-error',
            info: 'alert-info',
            success: 'alert-success',
            warning: 'alert-warning'
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000,
          onHidden() {
            window.location.href = `${BASE_URI}/customizacao`;
          }
        }).css({
          "margin-top": "20%",
          "width": "500px",
          "max-width": "500px"
        });
        return;
      }
    } catch (err) {
      console.log(err);
      msgAlerta('Não foi possivel gravar os dados.')
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  // Função Gravar Local Bordado
  async function gravaLocalBordado() {
    $.LoadingOverlay('show')
    try {
      if ($('#txtDescricaoLocalBordado').val() == '') {
        msgAlerta('Preencha o campo Descrição');
        return;
      }
      let objeto = {}

      objeto.ATIVO = $('#cbBordadoLocal').is(':checked') ? 'S' : 'N';
      objeto.ID = $('#txtIdLocalBordado').val() == '' ? await RetornaProximo("ID", "CUSTOMIZA", "ID", 4) : $('#txtIdLocalBordado').val();
      objeto.DESCRICAO = $('#txtDescricaoLocalBordado').val().toUpperCase();
      objeto.PRECO = $('#txtPrecoVUnitarioLocalBordado').val();
      objeto.MARGEM = $("#txtMargemExpressLocalBordado").val();
      objeto.TIPO = "BORDLOCAL";
      objeto.SETOR = pegaChave("#txtSetorLocalBordado");

      let response = await requisicao("POST", `/Sisplan/cadastros/V1/customizacao?`, `EMP_ID=${getCookie('emp_id')}&JSON=${JSON.stringify(objeto)}`, 15000);
      if (!response) {
        return;
      }
      if (response.objeto != 200) {
        toastr.success(
          `Cadastro efetuado com sucesso!
           Local Bordado: ${objeto.ID}`,
          'Confirmação', {
          toastClass: 'alert',
          iconClasses: {
            error: 'alert-error',
            info: 'alert-info',
            success: 'alert-success',
            warning: 'alert-warning'
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000,
          onHidden() {
            window.location.href = `${BASE_URI}/customizacao`;
          }
        }).css({
          "margin-top": "20%",
          "width": "500px",
          "max-width": "500px"
        });
        return;
      }
    } catch (err) {
      console.log(err);
      msgAlerta('Não foi possivel gravar os dados.')
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  // Função Gravar Programação Bordado
  async function gravaProgramacaoBordado() {
    $.LoadingOverlay('show')
    try {
      if ($('#txtDescricaoProgramacaoBordado').val() == '') {
        msgAlerta('Preencha o campo Descrição');
        return;
      }
      let objeto = {}

      objeto.ATIVO = $('#cbProgramacaoBordado').is(':checked') ? 'S' : 'N';
      objeto.ID = $('#txtIdProgramacaoBordado').val() == '' ? await RetornaProximo("ID", "CUSTOMIZA", "ID", 4) : $('#txtIdProgramacaoBordado').val();
      objeto.DESCRICAO = $('#txtDescricaoProgramacaoBordado').val().toUpperCase();
      objeto.TIPO = "BORDPROG";
      objeto.PRECO = $('#txtPrecoVProgramacaoBordado').val();

      let response = await requisicao("POST", `/Sisplan/cadastros/V1/customizacao?`, `EMP_ID=${getCookie('emp_id')}&JSON=${JSON.stringify(objeto)}`, 15000);
      if (!response) {
        return;
      }
      if (response.objeto != 200) {
        toastr.success(
          `Cadastro efetuado com sucesso!
             Programação Bordado: ${objeto.ID}`,
          'Confirmação', {
          toastClass: 'alert',
          iconClasses: {
            error: 'alert-error',
            info: 'alert-info',
            success: 'alert-success',
            warning: 'alert-warning'
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000,
          onHidden() {
            window.location.href = `${BASE_URI}/customizacao`;
          }
        }).css({
          "margin-top": "20%",
          "width": "500px",
          "max-width": "500px"
        });
        return;
      }
    } catch (err) {
      console.log(err);
      msgAlerta('Não foi possivel gravar os dados.')
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  // Função Gravar Tamanho Bordado
  async function gravaTamanhoBordado() {
    $.LoadingOverlay('show')
    try {
      if ($('#txtDescricaoTamanhoBordado').val() == '') {
        msgAlerta('Preencha o campo Descrição');
        return;
      }
      let objeto = {}

      objeto.ATIVO = $('#cbBordadoTamanho').is(':checked') ? 'S' : 'N';
      objeto.ID = $('#txtIdTamanhoBordado').val() == '' ? await RetornaProximo("ID", "CUSTOMIZA", "ID", 4) : $('#txtIdTamanhoBordado').val();
      objeto.DESCRICAO = $('#txtDescricaoTamanhoBordado').val().toUpperCase();
      objeto.TIPO = "BORDTAM";
      objeto.PRECO = $('#txtPrecoVTamanhoBordado').val();
      objeto.PONTOS = $('#txtQtdePontosTamanhoBordado').val();
      objeto.TEMPO = $('#txtTempoTamanhoBordado').val();

      let response = await requisicao("POST", `/Sisplan/cadastros/V1/customizacao?`, `EMP_ID=${getCookie('emp_id')}&JSON=${JSON.stringify(objeto)}`, 15000);
      if (!response) {
        return;
      }
      if (response.objeto != 200) {
        toastr.success(
          `Cadastro efetuado com sucesso!
             Tamanho Bordado: ${objeto.ID}`,
          'Confirmação', {
          toastClass: 'alert',
          iconClasses: {
            error: 'alert-error',
            info: 'alert-info',
            success: 'alert-success',
            warning: 'alert-warning'
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000,
          onHidden() {
            window.location.href = `${BASE_URI}/customizacao`;
          }
        }).css({
          "margin-top": "20%",
          "width": "500px",
          "max-width": "500px"
        });
        return;
      }
    } catch (err) {
      console.log(err);
      msgAlerta('Não foi possivel gravar os dados.')
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  // Função Gravar Sublimação
  async function gravaSublimacao() {
    $.LoadingOverlay('show')
    try {
      if ($('#txtDescricaoSublimacao').val() == '') {
        msgAlerta('Preencha o campo Descrição');
        return;
      }
      let objeto = {}

      objeto.ATIVO = $('#cbSublimacaoAtivo').is(':checked') ? 'S' : 'N';
      objeto.ID = $('#txtIdSublimacao').val() == '' ? await RetornaProximo("ID", "CUSTOMIZA", "ID", 4) : $('#txtIdSublimacao').val();
      objeto.DESCRICAO = $('#txtDescricaoSublimacao').val().toUpperCase();
      objeto.TIPO = "SUBLI";
      objeto.MARGEM = $('#txtMargemExpressSublimacao').val();
      objeto.VAL_PROG = $('#txtValProgramacaoSublimacao').val();
      objeto.VAL_UNIT = $('#txtValUnitarioSublimacao').val();
      objeto.SETOR = pegaChave('#txtSetorSublimacao');
      objeto.TEMPO = $('#txtTempoSublimacao').val();

      let response = await requisicao("POST", `/Sisplan/cadastros/V1/customizacao?`, `EMP_ID=${getCookie('emp_id')}&JSON=${JSON.stringify(objeto)}`, 15000);
      if (!response) {
        return;
      }
      if (response.objeto != 200) {
        toastr.success(
          `Cadastro da Sublimação efetuado com sucesso!
             ID: ${objeto.ID}`,
          'Confirmação', {
          toastClass: 'alert',
          iconClasses: {
            error: 'alert-error',
            info: 'alert-info',
            success: 'alert-success',
            warning: 'alert-warning'
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000,
          onHidden() {
            window.location.href = `${BASE_URI}/customizacao`;
          }
        }).css({
          "margin-top": "20%",
          "width": "500px",
          "max-width": "500px"
        });
        return;
      }
    } catch (err) {
      console.log(err);
      msgAlerta('Não foi possivel gravar os dados.')
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  // Função Gravar Termotape
  async function gravaTermotape() {
    $.LoadingOverlay('show')
    try {
      if ($('#txtDescricaoTermotape').val() == '') {
        msgAlerta('Preencha o campo Descrição');
        return;
      }
      let objeto = {}

      objeto.ATIVO = $('#cbTermotapeAtivo').is(':checked') ? 'S' : 'N';
      objeto.ID = $('#txtIdTermotape').val() == '' ? await RetornaProximo("ID", "CUSTOMIZA", "ID", 4) : $('#txtIdTermotape').val();
      objeto.DESCRICAO = $('#txtDescricaoTermotape').val().toUpperCase();
      objeto.TIPO = "TERMO";
      objeto.MARGEM = $('#txtMargemExpressTermotape').val();
      objeto.VAL_PROG = $('#txtValProgramacaoTermotape').val();
      objeto.VAL_UNIT = $('#txtValUnitarioTermotape').val();
      objeto.SETOR = pegaChave('#txtSetorTermotape');
      objeto.TEMPO = $('#txtTempoTermotape').val();

      let response = await requisicao("POST", `/Sisplan/cadastros/V1/customizacao?`, `EMP_ID=${getCookie('emp_id')}&JSON=${JSON.stringify(objeto)}`, 15000);
      if (!response) {
        return;
      }
      if (response.objeto != 200) {
        toastr.success(
          `Cadastro do Termotape efetuado com sucesso!
               ID: ${objeto.ID}`,
          'Confirmação', {
          toastClass: 'alert',
          iconClasses: {
            error: 'alert-error',
            info: 'alert-info',
            success: 'alert-success',
            warning: 'alert-warning'
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000,
          onHidden() {
            window.location.href = `${BASE_URI}/customizacao`;
          }
        }).css({
          "margin-top": "20%",
          "width": "500px",
          "max-width": "500px"
        });
        return;
      }
    } catch (err) {
      console.log(err);
      msgAlerta('Não foi possivel gravar os dados.')
    } finally {
      $.LoadingOverlay('hide');
    }
  }

    // Função Gravar Local DTF
    async function gravaLocalDTF() {
      $.LoadingOverlay('show')
      try {
        if ($('#txtDescricaoLocalDTF').val() == '') {
          msgAlerta('Preencha o campo Descrição');
          return;
        }
        let objeto = {}
  
        objeto.ATIVO = $('#cbDTFLocal').is(':checked') ? 'S' : 'N';
        objeto.ID = $('#txtIdLocalDTF').val() == '' ? await RetornaProximo("ID", "CUSTOMIZA", "ID", 4) : $('#txtIdLocalDTF').val();
        objeto.DESCRICAO = $('#txtDescricaoLocalDTF').val().toUpperCase();
        objeto.PRECO = $('#txtPrecoVUnitarioLocalDTF').val();
        objeto.MARGEM = $("#txtMargemExpressLocalDTF").val();
        objeto.TIPO = "DTFLOCAL";
        objeto.SETOR = pegaChave("#txtSetorLocalDTF");
  
        let response = await requisicao("POST", `/Sisplan/cadastros/V1/customizacao?`, `EMP_ID=${getCookie('emp_id')}&JSON=${JSON.stringify(objeto)}`, 15000);
        if (!response) {
          return;
        }
        if (response.objeto != 200) {
          toastr.success(
            `Cadastro efetuado com sucesso!
             Local DTF: ${objeto.ID}`,
            'Confirmação', {
            toastClass: 'alert',
            iconClasses: {
              error: 'alert-error',
              info: 'alert-info',
              success: 'alert-success',
              warning: 'alert-warning'
            },
            positionClass: "toast-top-center",
            progressBar: true,
            timeOut: 3000,
            fadeOut: 1000,
            onHidden() {
              window.location.href = `${BASE_URI}/customizacao`;
            }
          }).css({
            "margin-top": "20%",
            "width": "500px",
            "max-width": "500px"
          });
          return;
        }
      } catch (err) {
        console.log(err);
        msgAlerta('Não foi possivel gravar os dados.')
      } finally {
        $.LoadingOverlay('hide');
      }
    }

  // Função Gravar Programação DTF
  async function gravaProgramacaoDTF() {
    $.LoadingOverlay('show')
    try {
      if ($('#txtDescricaoProgramacaoDTF').val() == '') {
        msgAlerta('Preencha o campo Descrição');
        return;
      }
      let objeto = {}

      objeto.ATIVO = $('#cbProgramacaoDTF').is(':checked') ? 'S' : 'N';
      objeto.ID = $('#txtIdProgramacaoDTF').val() == '' ? await RetornaProximo("ID", "CUSTOMIZA", "ID", 4) : $('#txtIdProgramacaoDTF').val();
      objeto.DESCRICAO = $('#txtDescricaoProgramacaoDTF').val().toUpperCase();
      objeto.TIPO = "DTFPROG";
      objeto.PRECO = $('#txtPrecoVProgramacaoDTF').val();

      let response = await requisicao("POST", `/Sisplan/cadastros/V1/customizacao?`, `EMP_ID=${getCookie('emp_id')}&JSON=${JSON.stringify(objeto)}`, 15000);
      if (!response) {
        return;
      }
      if (response.objeto != 200) {
        toastr.success(
          `Cadastro efetuado com sucesso!
             Programação DTF: ${objeto.ID}`,
          'Confirmação', {
          toastClass: 'alert',
          iconClasses: {
            error: 'alert-error',
            info: 'alert-info',
            success: 'alert-success',
            warning: 'alert-warning'
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000,
          onHidden() {
            window.location.href = `${BASE_URI}/customizacao`;
          }
        }).css({
          "margin-top": "20%",
          "width": "500px",
          "max-width": "500px"
        });
        return;
      }
    } catch (err) {
      console.log(err);
      msgAlerta('Não foi possivel gravar os dados.')
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  // Função Gravar Tamanho DTF
  async function gravaTamanhoDTF() {
    $.LoadingOverlay('show')
    try {
      if ($('#txtDescricaoTamanhoDTF').val() == '') {
        msgAlerta('Preencha o campo Descrição');
        return;
      }
      let objeto = {}

      objeto.ATIVO = $('#cbDTFTamanho').is(':checked') ? 'S' : 'N';
      objeto.ID = $('#txtIdTamanhoDTF').val() == '' ? await RetornaProximo("ID", "CUSTOMIZA", "ID", 4) : $('#txtIdTamanhoDTF').val();
      objeto.DESCRICAO = $('#txtDescricaoTamanhoDTF').val().toUpperCase();
      objeto.TIPO = "DTFTAM";
      objeto.PRECO = $('#txtPrecoVTamanhoDTF').val();
      objeto.PONTOS = $('#txtQtdePontosTamanhoDTF').val();
      objeto.TEMPO = $('#txtTempoTamanhoDTF').val();

      let response = await requisicao("POST", `/Sisplan/cadastros/V1/customizacao?`, `EMP_ID=${getCookie('emp_id')}&JSON=${JSON.stringify(objeto)}`, 15000);
      if (!response) {
        return;
      }
      if (response.objeto != 200) {
        toastr.success(
          `Cadastro efetuado com sucesso!
             Tamanho DTF: ${objeto.ID}`,
          'Confirmação', {
          toastClass: 'alert',
          iconClasses: {
            error: 'alert-error',
            info: 'alert-info',
            success: 'alert-success',
            warning: 'alert-warning'
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000,
          onHidden() {
            window.location.href = `${BASE_URI}/customizacao`;
          }
        }).css({
          "margin-top": "20%",
          "width": "500px",
          "max-width": "500px"
        });
        return;
      }
    } catch (err) {
      console.log(err);
      msgAlerta('Não foi possivel gravar os dados.')
    } finally {
      $.LoadingOverlay('hide');
    }
  }


  // Excluir Local Serigrafia
  $('#tabelaLocalSerigrafia').on('click', '#btn-excluir', async function () {
    if (permissaoUsuarioLogado.EXCLUI == 'S') {
      msgAlerta('Você realmente deseja excluir esse registro?', async () => {
        const data = $('#tabelaLocalSerigrafia').DataTable().row($(this).parents('tr')).data();
        await excluiRegistro(data, "SERIGLOCAL");
      });
    } else {
      msgAlertaSemConfirmacao("Sem permissão para excluir!");
    }
  });

  // Excluir Tamanho Serigrafia
  $('#tabelaTamanhoSerigrafia').on('click', '#btn-excluir', async function () {
    if (permissaoUsuarioLogado.EXCLUI == 'S') {
      msgAlerta('Você realmente deseja excluir esse registro?', async () => {
        const data = $('#tabelaTamanhoSerigrafia').DataTable().row($(this).parents('tr')).data();
        await excluiRegistro(data, "SERIGTAM");
      });
    } else {
      msgAlertaSemConfirmacao("Sem permissão para excluir!");
    }
  });

  // Excluir Tipo Serigrafia
  $('#tabelaTipoSerigrafia').on('click', '#btn-excluir', async function () {
    if (permissaoUsuarioLogado.EXCLUI == 'S') {
      msgAlerta('Você realmente deseja excluir esse registro?', async () => {
        const data = $('#tabelaTipoSerigrafia').DataTable().row($(this).parents('tr')).data();
        await excluiRegistro(data, "SERIGTIPO");
      });
    } else {
      msgAlertaSemConfirmacao("Sem permissão para excluir!");
    }
  });

  // Excluir Local Bordado
  $('#tabelaLocalBordado').on('click', '#btn-excluir', async function () {
    if (permissaoUsuarioLogado.EXCLUI == 'S') {
      msgAlerta('Você realmente deseja excluir esse registro?', async () => {
        const data = $('#tabelaLocalBordado').DataTable().row($(this).parents('tr')).data();
        await excluiRegistro(data, "BORDLOCAL");
      });
    } else {
      msgAlertaSemConfirmacao("Sem permissão para excluir!");
    }
  });

  // Excluir Programação Bordado
  $('#tabelaProgramacaoBordado').on('click', '#btn-excluir', async function () {
    if (permissaoUsuarioLogado.EXCLUI == 'S') {
      msgAlerta('Você realmente deseja excluir esse registro?', async () => {
        const data = $('#tabelaProgramacaoBordado').DataTable().row($(this).parents('tr')).data();
        await excluiRegistro(data, "BORDPROG");
      });
    } else {
      msgAlertaSemConfirmacao("Sem permissão para excluir!");
    }
  });

  // Excluir Tamanho Bordado
  $('#tabelaTamanhoBordado').on('click', '#btn-excluir', async function () {
    if (permissaoUsuarioLogado.EXCLUI == 'S') {
      msgAlerta('Você realmente deseja excluir esse registro?', async () => {
        const data = $('#tabelaTamanhoBordado').DataTable().row($(this).parents('tr')).data();
        await excluiRegistro(data, "BORDTAM");
      });
    } else {
      msgAlertaSemConfirmacao("Sem permissão para excluir!");
    }
  });

  // Excluir Sublimação
  $('#tabelaSublimacao').on('click', '#btn-excluir', async function () {
    if (permissaoUsuarioLogado.EXCLUI == 'S') {
      msgAlerta('Você realmente deseja excluir esse registro?', async () => {
        const data = $('#tabelaSublimacao').DataTable().row($(this).parents('tr')).data();
        await excluiRegistro(data, "SUBLI");
      });
    } else {
      msgAlertaSemConfirmacao("Sem permissão para excluir!");
    }
  });

  // Excluir Termotape
  $('#tabelaTermotape').on('click', '#btn-excluir', async function () {
    if (permissaoUsuarioLogado.EXCLUI == 'S') {
      msgAlerta('Você realmente deseja excluir esse registro?', async () => {
        const data = $('#tabelaTermotape').DataTable().row($(this).parents('tr')).data();
        await excluiRegistro(data, "TERMO");
      });
    } else {
      msgAlertaSemConfirmacao("Sem permissão para excluir!");
    }
  });

  // Excluir Local DTF
  $('#tabelaLocalDTF').on('click', '#btn-excluir', async function () {
    if (permissaoUsuarioLogado.EXCLUI == 'S') {
      msgAlerta('Você realmente deseja excluir esse registro?', async () => {
        const data = $('#tabelaLocalDTF').DataTable().row($(this).parents('tr')).data();
        await excluiRegistro(data, "DTFLOCAL");
      });
    } else {
      msgAlertaSemConfirmacao("Sem permissão para excluir!");
    }
  });

  // Excluir Programação DTF
  $('#tabelaProgramacaoDTF').on('click', '#btn-excluir', async function () {
    if (permissaoUsuarioLogado.EXCLUI == 'S') {
      msgAlerta('Você realmente deseja excluir esse registro?', async () => {
        const data = $('#tabelaProgramacaoDTF').DataTable().row($(this).parents('tr')).data();
        await excluiRegistro(data, "DTFPROG");
      });
    } else {
      msgAlertaSemConfirmacao("Sem permissão para excluir!");
    }
  });

  // Excluir Tamanho DTF
  $('#tabelaTamanhoDTF').on('click', '#btn-excluir', async function () {
    if (permissaoUsuarioLogado.EXCLUI == 'S') {
      msgAlerta('Você realmente deseja excluir esse registro?', async () => {
        const data = $('#tabelaTamanhoDTF').DataTable().row($(this).parents('tr')).data();
        await excluiRegistro(data, "DTFTAM");
      });
    } else {
      msgAlertaSemConfirmacao("Sem permissão para excluir!");
    }
  });


  // Excluir
  async function excluiRegistro(data, tipo) {
    try {
      $.LoadingOverlay("show");
      try {

        let response = await requisicao('DELETE', '/Sisplan/cadastros/V1/customizacao?', `ID=${encodeURIComponent(data.ID)}&TIPO=${encodeURIComponent(tipo)}`, null)
        if (!response) {
          return;
        }
        if (response.status != 200) {
          let jsonStr = await response.json();
          msgErro(jsonStr.mensagem);
          return;
        }

        toastr.success("Exclusão efetuada com sucesso!", "Confirmação", {
          toastClass: "success",
          iconClasses: {
            error: "alert-error",
            info: "alert-info",
            success: "alert-success",
            warning: "alert-warning",
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000,
          onHidden() {
            window.location.href = `${BASE_URI}/customizacao`;
          },
        }).css({
          "margin-top": "20%",
          width: "500px",
          "max-width": "500px",
        });

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  }

  // Código para aplicar o adjust nas tabelas.

  $("#BordadoLocal, #tabSerigrafia").on("click", async function () {
    await sleep(50)
    $("#tabelaLocalSerigrafia").DataTable().columns.adjust().draw(false);
  });

  $("#SerigrafiaTamanho").on("click", async function () {
    await sleep(50)
    $("#tabelaTamanhoSerigrafia").DataTable().columns.adjust().draw(false);
  });

  $("#SerigrafiaTipo").on("click", async function () {
    await sleep(50)
    $("#tabelaTipoSerigrafia").DataTable().columns.adjust().draw(false);
  });

  $("#BordadoLocal, #tabBordado").on("click", async function () {
    await sleep(50)
    $("#tabelaLocalBordado").DataTable().columns.adjust().draw(false);
  });

  $("#BordadoProgramacao").on("click", async function () {
    await sleep(50)
    $("#tabelaProgramacaoBordado").DataTable().columns.adjust().draw(false);
  });

  $("#BordadoTamanho").on("click", async function () {
    await sleep(50)
    $("#tabelaTamanhoBordado").DataTable().columns.adjust().draw(false);
  });

  $("#tabSublimacao").on("click", async function () {
    await sleep(50)
    $("#tabelaSublimacao").DataTable().columns.adjust().draw(false);
  });

  $("#tabTermotape").on("click", async function () {
    await sleep(50)
    $("#tabelaTermotape").DataTable().columns.adjust().draw(false);
  });

  $("#DTFLocal, #tabDTF").on("click", async function () {
    await sleep(50)
    $("#tabelaLocalDTF").DataTable().columns.adjust().draw(false);
  });

  $("#DTFProgramacao").on("click", async function () {
    await sleep(50)
    $("#tabelaProgramacaoDTF").DataTable().columns.adjust().draw(false);
  });

  $("#DTFTamanho").on("click", async function () {
    await sleep(50)
    $("#tabelaTamanhoDTF").DataTable().columns.adjust().draw(false);
  });

  // Funções para habilitar e ocultar os inputs de cada seção
  //Serigrafia Local
  $("#btnIncluirLocalSerigrafia").click(function () {
    $('#tabelaLocalSerigrafia').prop('disabled', true);
    $('#tabelaLocalSerigrafia button').prop('disabled', true);
    $('#tabelaLocalSerigrafia tr.selected').removeClass('selected');
    $(`#cbSerigrafiaLocal, 
      #txtDescricaoLocalSerigrafia, 
      #txtSetorLocalSerigrafia, #btnSetorLocalSerigrafia, #btnLimpaSetorLocalSerigrafia, 
      #txtPrecoVUnitarioLocalSerigrafia,
      #txtMargemExpressLocalSerigrafia`).prop("disabled", false);

    $(`#btnCancelarLocalSerigrafia, #btnGravarLocalSerigrafia`).removeClass('d-none')
    $(`#btnIncluirLocalSerigrafia`).addClass('d-none')
  });

  $("#btnCancelarLocalSerigrafia").click(function () {
    $('#tabelaLocalSerigrafia').prop('disabled', true);
    $('#tabelaLocalSerigrafia button').prop('disabled', false);
    $('#tabelaLocalSerigrafia tr.selected').removeClass('selected');
    $(`#txtDescricaoLocalSerigrafia, 
      #txtSetorLocalSerigrafia, #btnSetorLocalSerigrafia, #btnLimpaSetorLocalSerigrafia, 
      #txtPrecoVUnitarioLocalSerigrafia,
      #txtMargemExpressLocalSerigrafia`).val("");

    $("#cbSerigrafiaLocal").prop("checked", false);

    $(`#cbSerigrafiaLocal, 
      #txtDescricaoLocalSerigrafia, 
      #txtSetorLocalSerigrafia, #btnSetorLocalSerigrafia, #btnLimpaSetorLocalSerigrafia, 
      #txtPrecoVUnitarioLocalSerigrafia,
      #txtMargemExpressLocalSerigrafia`).prop("disabled", true);

    $(`#btnCancelarLocalSerigrafia, #btnGravarLocalSerigrafia`).addClass('d-none')
    $(`#btnIncluirLocalSerigrafia`).removeClass('d-none')
  });

  //Serigrafia Tamanho
  $("#btnIncluirTamanhoSerigrafia").click(function () {
    $('#tabelaTamanhoSerigrafia').prop('disabled', true);
    $('#tabelaTamanhoSerigrafia button').prop('disabled', true);
    $('#tabelaTamanhoSerigrafia tr.selected').removeClass('selected');

    $(`#cbTamanhoSerigrafia, #txtDescricaoTamanhoSerigrafia`).prop("disabled", false);

    $(`#btnCancelarTamanhoSerigrafia, #btnGravarTamanhoSerigrafia`).removeClass('d-none')
    $(`#btnIncluirTamanhoSerigrafia`).addClass('d-none')
  });

  $("#btnCancelarTamanhoSerigrafia").click(function () {
    $('#tabelaTamanhoSerigrafia').prop('disabled', true);
    $('#tabelaTamanhoSerigrafia button').prop('disabled', false);
    $('#tabelaTamanhoSerigrafia tr.selected').removeClass('selected');

    $(`#txtDescricaoTamanhoSerigrafia`).val("");
    $(`#cbTamanhoSerigrafia`).prop("checked", false);

    $(`#cbTamanhoSerigrafia, #txtDescricaoTamanhoSerigrafia`).prop("disabled", true);

    $(`#btnCancelarTamanhoSerigrafia, #btnGravarTamanhoSerigrafia`).addClass('d-none')
    $(`#btnIncluirTamanhoSerigrafia`).removeClass('d-none')
  });

  //Serigrafia Tipo
  $("#btnIncluirTipoSerigrafia").click(function () {
    $('#tabelaTipoSerigrafia').prop('disabled', true);
    $('#tabelaTipoSerigrafia button').prop('disabled', true);
    $('#tabelaTipoSerigrafia tr.selected').removeClass('selected');

    $(`#cbSerigrafiaTipo, 
    #txtDescricaoTipoSerigrafia, 
    #txtTamanhoTipoSerigrafia, #btnTamanhoTipoSerigrafia, #btnLimpaTamanhoTipoSerigrafia, 
    #txtPercMargemTipoSerigrafia,
    #txtTempoTipoSerigrafia,
    #txtTelaTipoSerigrafia, #txtFotolitoTipoSerigrafia,
    #txtValorCorTipoSerigrafia, #txtQuantidadeCorTipoSerigrafia`).prop("disabled", false);

    $(`#btnCancelarTipoSerigrafia, #btnGravarTipoSerigrafia`).removeClass('d-none')
    $(`#btnIncluirTipoSerigrafia`).addClass('d-none')
  });

  $("#btnCancelarTipoSerigrafia").click(function () {
    $('#tabelaTipoSerigrafia').prop('disabled', true);
    $('#tabelaTipoSerigrafia button').prop('disabled', false);
    $('#tabelaTipoSerigrafia tr.selected').removeClass('selected');

    $(`#txtDescricaoTipoSerigrafia, 
    #txtTamanhoTipoSerigrafia, #btnTamanhoTipoSerigrafia, #btnLimpaTamanhoTipoSerigrafia, 
    #txtPercMargemTipoSerigrafia,
    #txtTempoTipoSerigrafia,
    #txtTelaTipoSerigrafia, #txtFotolitoTipoSerigrafia,
    #txtValorCorTipoSerigrafia, #txtQuantidadeCorTipoSerigrafia`).val("");

    $(`#cbSerigrafiaTipo`).prop("checked", false);

    $(`#cbSerigrafiaTipo, 
    #txtDescricaoTipoSerigrafia, 
    #txtTamanhoTipoSerigrafia, #btnTamanhoTipoSerigrafia, #btnLimpaTamanhoTipoSerigrafia, 
    #txtPercMargemTipoSerigrafia,
    #txtTempoTipoSerigrafia,
    #txtTelaTipoSerigrafia, #txtFotolitoTipoSerigrafia,
    #txtValorCorTipoSerigrafia, #txtQuantidadeCorTipoSerigrafia`).prop("disabled", true);

    $(`#btnCancelarTipoSerigrafia, #btnGravarTipoSerigrafia`).addClass('d-none')
    $(`#btnIncluirTipoSerigrafia`).removeClass('d-none')
  });


  //Bordado Local
  $("#btnIncluirLocalBordado").click(function () {
    $('#tabelaLocalBordado').prop('disabled', true);
    $('#tabelaLocalBordado button').prop('disabled', true);
    $('#tabelaLocalBordado tr.selected').removeClass('selected');

    $(`#cbBordadoLocal, 
    #txtDescricaoLocalBordado, 
    #txtSetorLocalBordado, #btnSetorLocalBordado, #btnLimpaSetorLocalBordado,
    #txtPrecoVUnitarioLocalBordado, #txtMargemExpressLocalBordado
    `).prop("disabled", false);

    $(`#btnCancelarLocalBordado, #btnGravarLocalBordado`).removeClass('d-none')
    $(`#btnIncluirLocalBordado`).addClass('d-none')
  });

  $("#btnCancelarLocalBordado").click(function () {
    $('#tabelaLocalBordado').prop('disabled', true);
    $('#tabelaLocalBordado button').prop('disabled', false);
    $('#tabelaLocalBordado tr.selected').removeClass('selected');

    $(`#txtDescricaoLocalBordado, 
    #txtSetorLocalBordado, #btnSetorLocalBordado, #btnLimpaSetorLocalBordado,
    #txtPrecoVUnitarioLocalBordado, #txtMargemExpressLocalBordado
    `).val("");

    $(`#cbBordadoLocal`).prop("checked", false);

    $(`#cbBordadoLocal, 
    #txtDescricaoLocalBordado, 
    #txtSetorLocalBordado, #btnSetorLocalBordado, #btnLimpaSetorLocalBordado,
    #txtPrecoVUnitarioLocalBordado, #txtMargemExpressLocalBordado
    `).prop("disabled", true);

    $(`#btnCancelarLocalBordado, #btnGravarLocalBordado`).addClass('d-none')
    $(`#btnIncluirLocalBordado`).removeClass('d-none')
  });

  //Bordado Programação
  $("#btnIncluirProgramacaoBordado").click(function () {
    $('#tabelaProgramacaoBordado').prop('disabled', true);
    $('#tabelaProgramacaoBordado button').prop('disabled', true);
    $('#tabelaProgramacaoBordado tr.selected').removeClass('selected');

    $(`#cbProgramacaoBordado, 
    #txtDescricaoProgramacaoBordado, 
    #txtPrecoVProgramacaoBordado`).prop("disabled", false);

    $(`#btnCancelarProgramacaoBordado, #btnGravarProgramacaoBordado`).removeClass('d-none')
    $(`#btnIncluirProgramacaoBordado`).addClass('d-none')
  });

  $("#btnCancelarProgramacaoBordado").click(function () {
    $('#tabelaProgramacaoBordado').prop('disabled', true);
    $('#tabelaProgramacaoBordado button').prop('disabled', false);
    $('#tabelaProgramacaoBordado tr.selected').removeClass('selected');

    $(`#txtDescricaoProgramacaoBordado,  #txtPrecoVProgramacaoBordado`).val("");
    $(`#cbProgramacaoBordado`).prop("checked", false);

    $(`#cbProgramacaoBordado, 
    #txtDescricaoProgramacaoBordado, 
    #txtPrecoVProgramacaoBordado`).prop("disabled", true);

    $(`#btnCancelarProgramacaoBordado, #btnGravarProgramacaoBordado`).addClass('d-none')
    $(`#btnIncluirProgramacaoBordado`).removeClass('d-none')
  });

  //Bordado Tamanho
  $("#btnIncluirTamanhoBordado").click(function () {
    $('#tabelaTamanhoBordado').prop('disabled', true);
    $('#tabelaTamanhoBordado button').prop('disabled', true);
    $('#tabelaTamanhoBordado tr.selected').removeClass('selected');

    $(`#cbBordadoTamanho,
    #txtDescricaoTamanhoBordado, 
    #txtPrecoVTamanhoBordado, 
    #txtQtdePontosTamanhoBordado,
    #txtTempoTamanhoBordado`).prop("disabled", false);

    $(`#btnCancelarTamanhoBordado, #btnGravarTamanhoBordado`).removeClass('d-none')
    $(`#btnIncluirTamanhoBordado`).addClass('d-none')
  });

  $("#btnCancelarTamanhoBordado").click(function () {
    $('#tabelaTamanhoBordado').prop('disabled', true);
    $('#tabelaTamanhoBordado button').prop('disabled', false);
    $('#tabelaTamanhoBordado tr.selected').removeClass('selected');

    $(`#txtDescricaoTamanhoBordado, 
    #txtPrecoVTamanhoBordado, 
    #txtQtdePontosTamanhoBordado,
    #txtTempoTamanhoBordado`).val("");

    $(`#cbBordadoTamanho`).prop("checked", false);

    $(`#cbBordadoTamanho,
    #txtDescricaoTamanhoBordado, 
    #txtPrecoVTamanhoBordado, 
    #txtQtdePontosTamanhoBordado,
    #txtTempoTamanhoBordado`).prop("disabled", true);

    $(`#btnCancelarTamanhoBordado, #btnGravarTamanhoBordado`).addClass('d-none')
    $(`#btnIncluirTamanhoBordado`).removeClass('d-none')
  });


  //Sublimação
  $("#btnIncluirSublimacao").click(function () {
    $('#tabelaSublimacao').prop('disabled', true);
    $('#tabelaSublimacao button').prop('disabled', true);
    $('#tabelaSublimacao tr.selected').removeClass('selected');

    $(`
    #cbSublimacaoAtivo,
    #txtDescricaoSublimacao,
    #txtSetorSublimacao, #btnSetorSublimacao, #btnLimpaSetorSublimacao,
    #txtTempoSublimacao,
    #txtMargemExpressSublimacao, 
    #txtValProgramacaoSublimacao,
    #txtValUnitarioSublimacao`).prop("disabled", false);

    $(`#btnCancelarSublimacao, #btnGravarSublimacao`).removeClass('d-none')
    $(`#btnIncluirSublimacao`).addClass('d-none')
  });

  $("#btnCancelarSublimacao").click(function () {
    $('#tabelaSublimacao').prop('disabled', true);
    $('#tabelaSublimacao button').prop('disabled', false);
    $('#tabelaSublimacao tr.selected').removeClass('selected');

    $('#tabelaSublimacao tr.selected').removeClass('selected');
    $(`#txtDescricaoSublimacao,
    #txtSetorSublimacao, #btnSetorSublimacao, #btnLimpaSetorSublimacao,
    #txtTempoSublimacao,
    #txtMargemExpressSublimacao, 
    #txtValProgramacaoSublimacao,
    #txtValUnitarioSublimacao`).val("");

    $(`#cbSublimacaoAtivo`).prop("checked", false);
    $('#tabelaSublimacao tr.selected').removeClass('selected');
    $(`#cbSublimacaoAtivo,
    #txtDescricaoSublimacao,
    #txtSetorSublimacao, #btnSetorSublimacao, #btnLimpaSetorSublimacao,
    #txtTempoSublimacao,
    #txtMargemExpressSublimacao, 
    #txtValProgramacaoSublimacao,
    #txtValUnitarioSublimacao`).prop("disabled", true);

    $(`#btnCancelarSublimacao, #btnGravarSublimacao`).addClass('d-none')
    $(`#btnIncluirSublimacao`).removeClass('d-none')
  });


  //Termotape
  $("#btnIncluirTermotape").click(function () {
    $('#tabelaTermotape').prop('disabled', true);
    $('#tabelaTermotape button').prop('disabled', true);
    $('#tabelaTermotape tr.selected').removeClass('selected');

    $(`
      #cbTermotapeAtivo,
      #txtDescricaoTermotape,
      #txtSetorTermotape, #btnSetorTermotape, #btnLimpaSetorTermotape,
      #txtTempoTermotape, #txtMargemExpressTermotape, #txtValProgramacaoTermotape, #txtValUnitarioTermotape`).prop("disabled", false);

    $(`#btnCancelarTermotape, #btnGravarTermotape`).removeClass('d-none')
    $(`#btnIncluirTermotape`).addClass('d-none')
  });

  $("#btnCancelarTermotape").click(function () {
    $('#tabelaTermotape').prop('disabled', true);
    $('#tabelaTermotape button').prop('disabled', false);
    $('#tabelaTermotape tr.selected').removeClass('selected');

    $(`#txtDescricaoTermotape,
    #txtSetorTermotape, #btnSetorTermotape, #btnLimpaSetorTermotape,
    #txtTempoTermotape, #txtMargemExpressTermotape, #txtValProgramacaoTermotape, #txtValUnitarioTermotape`).val("");

    $(` #cbTermotapeAtivo`).prop("checked", false);

    $(`
      #cbTermotapeAtivo,
      #txtDescricaoTermotape,
      #txtSetorTermotape, #btnSetorTermotape, #btnLimpaSetorTermotape,
      #txtTempoTermotape, #txtMargemExpressTermotape, #txtValProgramacaoTermotape, #txtValUnitarioTermotape`).prop("disabled", true);

    $(`#btnCancelarTermotape, #btnGravarTermotape`).addClass('d-none')
    $(`#btnIncluirTermotape`).removeClass('d-none')
  });

  //DTF Local
  $("#btnIncluirLocalDTF").click(function () {
    $('#tabelaLocalDTF').prop('disabled', true);
    $('#tabelaLocalDTF button').prop('disabled', true);
    $('#tabelaLocalDTF tr.selected').removeClass('selected');

    $(`#cbDTFLocal, 
    #txtDescricaoLocalDTF, 
    #txtSetorLocalDTF, #btnSetorLocalDTF, #btnLimpaSetorLocalDTF,
    #txtPrecoVUnitarioLocalDTF, #txtMargemExpressLocalDTF
    `).prop("disabled", false);

    $(`#btnCancelarLocalDTF, #btnGravarLocalDTF`).removeClass('d-none')
    $(`#btnIncluirLocalDTF`).addClass('d-none')
  });

  $("#btnCancelarLocalDTF").click(function () {
    $('#tabelaLocalDTF').prop('disabled', true);
    $('#tabelaLocalDTF button').prop('disabled', false);
    $('#tabelaLocalDTF tr.selected').removeClass('selected');

    $(`#txtDescricaoLocalDTF, 
    #txtSetorLocalDTF, #btnSetorLocalDTF, #btnLimpaSetorLocalDTF,
    #txtPrecoVUnitarioLocalDTF, #txtMargemExpressLocalDTF
    `).val("");

    $(`#cbDTFLocal`).prop("checked", false);

    $(`#cbDTFLocal, 
    #txtDescricaoLocalDTF, 
    #txtSetorLocalDTF, #btnSetorLocalDTF, #btnLimpaSetorLocalDTF,
    #txtPrecoVUnitarioLocalDTF, #txtMargemExpressLocalDTF
    `).prop("disabled", true);

    $(`#btnCancelarLocalDTF, #btnGravarLocalDTF`).addClass('d-none')
    $(`#btnIncluirLocalDTF`).removeClass('d-none')
  });

  //DTF Programação
  $("#btnIncluirProgramacaoDTF").click(function () {
    $('#tabelaProgramacaoDTF').prop('disabled', true);
    $('#tabelaProgramacaoDTF button').prop('disabled', true);
    $('#tabelaProgramacaoDTF tr.selected').removeClass('selected');

    $(`#cbProgramacaoDTF, 
    #txtDescricaoProgramacaoDTF, 
    #txtPrecoVProgramacaoDTF`).prop("disabled", false);

    $(`#btnCancelarProgramacaoDTF, #btnGravarProgramacaoDTF`).removeClass('d-none')
    $(`#btnIncluirProgramacaoDTF`).addClass('d-none')
  });

  $("#btnCancelarProgramacaoDTF").click(function () {
    $('#tabelaProgramacaoDTF').prop('disabled', true);
    $('#tabelaProgramacaoDTF button').prop('disabled', false);
    $('#tabelaProgramacaoDTF tr.selected').removeClass('selected');

    $(`#txtDescricaoProgramacaoDTF,  #txtPrecoVProgramacaoDTF`).val("");
    $(`#cbProgramacaoDTF`).prop("checked", false);

    $(`#cbProgramacaoDTF, 
    #txtDescricaoProgramacaoDTF, 
    #txtPrecoVProgramacaoDTF`).prop("disabled", true);

    $(`#btnCancelarProgramacaoDTF, #btnGravarProgramacaoDTF`).addClass('d-none')
    $(`#btnIncluirProgramacaoDTF`).removeClass('d-none')
  });

  //DTF Tamanho
  $("#btnIncluirTamanhoDTF").click(function () {
    $('#tabelaTamanhoDTF').prop('disabled', true);
    $('#tabelaTamanhoDTF button').prop('disabled', true);
    $('#tabelaTamanhoDTF tr.selected').removeClass('selected');

    $(`#cbDTFTamanho,
    #txtDescricaoTamanhoDTF, 
    #txtPrecoVTamanhoDTF, 
    #txtQtdePontosTamanhoDTF,
    #txtTempoTamanhoDTF`).prop("disabled", false);

    $(`#btnCancelarTamanhoDTF, #btnGravarTamanhoDTF`).removeClass('d-none')
    $(`#btnIncluirTamanhoDTF`).addClass('d-none')
  });

  $("#btnCancelarTamanhoDTF").click(function () {
    $('#tabelaTamanhoDTF').prop('disabled', true);
    $('#tabelaTamanhoDTF button').prop('disabled', false);
    $('#tabelaTamanhoDTF tr.selected').removeClass('selected');

    $(`#txtDescricaoTamanhoDTF, 
    #txtPrecoVTamanhoDTF, 
    #txtQtdePontosTamanhoDTF,
    #txtTempoTamanhoDTF`).val("");

    $(`#cbDTFTamanho`).prop("checked", false);

    $(`#cbDTFTamanho,
    #txtDescricaoTamanhoDTF, 
    #txtPrecoVTamanhoDTF, 
    #txtQtdePontosTamanhoDTF,
    #txtTempoTamanhoDTF`).prop("disabled", true);

    $(`#btnCancelarTamanhoDTF, #btnGravarTamanhoDTF`).addClass('d-none')
    $(`#btnIncluirTamanhoDTF`).removeClass('d-none')
  });

})

