$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false,
      animate: true,
      onNext: (Element) => {
        if ((Element.node.id == 'avancar1')) {
          $('#avancar1').trigger('click');
        };
      },
      onPrevious: (Element) => {
        if (Element.node.id == 'contas') {
          $('#voltar').trigger('click');
        }
      }
    });

    driver.defineSteps([{
      element: '#formcard1',
      popover: {
        title: 'Dados Gerais',
        description: 'Aqui estão os campos disponíveis para o cadastro, os campos obrigatórios terão o * ao lado do nome.',
        position: 'top'
      }
    },
    {
      element: '#txtCodigo',
      popover: {
        title: 'Código',
        description: 'O campo de código é preenchido automaticamente após gravar o registro.',
        position: 'top'
      }
    },
    {
      element: '#txtDescricao',
      popover: {
        title: 'Descrição',
        description: 'Neste campo adicionamos a descrição para o caixa.',
        position: 'top'
      }
    },
    {
      element: '#btnVoltar',
      popover: {
        title: 'Botão Voltar',
        description: 'Clique aqui para voltar para a tela de consulta.',
        position: 'left'
      }
    },
    {
      element: '#avancar1',
      popover: {
        title: 'Botão Avançar',
        description: 'Clique aqui para ir para a próxima aba.',
        position: 'left'
      }
    },
    {
      element: '#formcard2',
      popover: {
        title: 'Configurações da condição de pagamento',
        description: 'Aqui você selecionará algumas configurações.',
        position: 'top'
      }
    },
    {
      element: '#btnGravar',
      popover: {
        title: 'Botão Gravar',
        description: 'Clique aqui para gravar a condição de pagamento.',
        position: 'left'
      }
    }
    ]);
    driver.start();
  });
});


$(document).ready(async function () {
  $('#tabelaParcelaPrazo').DataTable({
    paging: false,
    filter: false,
    info: false,
    order: true,
    destroy: true,
    scrollY: '205px',
  });

  $("#checkAtivo").attr("checked", true);

  let queryString = window.location.href;
  let parametros = queryString.split("/");
  let condicao = parametros[parametros.length - 1];

  $("#btnDistribuir").on("click", function () {
    let NumeroParcela = $("#txtNumeroParcelas").val();
    let PrazoInicial = $("#txtPrazoInicial").val();
    let DiasEntreParcela = $("#txtDiasEntreParcelas").val();

    if (NumeroParcela == "") {
      msgAlerta('Necessário informar número de parcelas');
      return;
    }
    if (PrazoInicial == "") {
      msgAlerta('Necessário informar prazo inicial');
      return;
    }
    if (DiasEntreParcela == "") {
      msgAlerta('Necessário informar dias entre parcelas');
      return;
    }

    LimpaTabela();

    let dias = 0;
    let Prazo = 0;
    for (let i = 1; i <= NumeroParcela; i++) {
      if ($('#tabelaParcelaPrazo').DataTable().rows().count() == 0) {
        Prazo = PrazoInicial;
      }
      else {
        Prazo = parseFloat(PrazoInicial) + ((parseFloat(i) - 1) * parseFloat(DiasEntreParcela));
      }
      $('#tabelaParcelaPrazo').DataTable().row.add([
        i,
        `<input type="number" class="input-default focus form-control validate PrazoParcela" value="${Prazo}">`
      ]).draw(false);
      dias = parseFloat(dias) + parseFloat(Prazo);
    }
    $("#txtPrazoMedio").val(parseFloat(dias) / parseFloat($("#txtNumeroParcelas").val()));
  });

  async function LimpaTabela() {
    $('#tabelaParcelaPrazo').DataTable().clear().draw(false);
  };

  let contaFs = 1;

  $(".next").click(function () {
    contaFs += 1;

    let validator = $("#msform").validate();
    validator.form();
    let erros = 0;
    erros = validator.numberOfInvalids();

    if (erros == 0) {
      currentFs = $(this).parent();
      nextFs = $(this).parent().next();

      $("#progressbar li").eq($("#msform > fieldset").index(nextFs)).addClass("active");

      nextFs.show();
      currentFs.animate(
        {
          opacity: 0,
        },
        {
          step(now) {
            opacity = 1 - now;

            currentFs.css({
              display: "none",
              position: "relative",
            });
            nextFs.css({
              'opacity': opacity
            });
          },
          duration: 600,
        }
      );
      $("#tabelaParcelaPrazo").DataTable().columns.adjust().draw(false);
    }
  });



  $(".previous").click(function () {
    contaFs -= 1;

    currentFs = $(this).parent();
    previousFs = $(this).parent().prev();
    $("#progressbar li")
      .eq($("#msform > fieldset").index(currentFs))
      .removeClass("active");
    previousFs.show();
    currentFs.animate(
      {
        opacity: 0,
      },
      {
        step(now) {
          opacity = 1 - now;
          currentFs.css({
            display: "none",
            position: "relative",
          });
          previousFs.css({
            opacity,
          });
        },
        duration: 600,
      }
    );
  });

  $("#account").on("click", function () {
    if (contaFs == 2) {
      $("#voltar").trigger("click");
    }
    if (contaFs == 2) {
      $("#voltar2").trigger("click");
      $("#voltar").trigger("click");
    }
});

$("#payment").on("click", function () {
    if (contaFs == 1) {
      $("#avancar1").trigger("click");
    }
    if (contaFs == 2) {
      $("#voltar2").trigger("click");
    }
});

  $("#btnVoltar").on("click", async function () {
    window.location.href = `${BASE_URI}/condicaopagamento`;
  });

  if (condicao != 'create') {
    if ((await liberarRegistro("CONDICAOPAGAMENTO", condicao)) == false) {
      window.location.href = "../condicaopagamento";
    }
    try {

      let response = await requisicao(
        "GET",
        "/Sisplan/Funcoes/v1/pesquisa?",
        `JSON={ "tabela":"CONDICAO", 
                "camposSelect":["CODCOND", "DESCRICAO","ATIVO", "DIAVE", "DESCMAX", "ENTRADA", "NRPAR", "PRAZOINI", "NRDIA", "PRZ_MEDIO", "USA_TAXA_BANDEIRA"], 
                "where": ["CODCOND = '${condicao}'"]}`,
        null
      );

      if (!response) {
        return;
      }
      let jsonStr = await response.json();
      if (response.status != 200) {
        msgErro(jsonStr.RESULT[0].mensagem);
        return;
      }

      jsonStr = jsonStr.RESULT[0][0];

      $("#txtCodigo").val(jsonStr.CODCOND);
      $("#txtDescricao").val(jsonStr.DESCRICAO);
      $("#txtDescontoMaximo").val(parseInt(jsonStr.DESCMAX));
      $("#txtDiaVencimento").val(parseInt(jsonStr.DIAVE));
      $("#txtNumeroParcelas").val(jsonStr.NRPAR);
      $("#txtPrazoInicial").val(parseInt(jsonStr.PRAZOINI));
      $("#txtPrazoMedio").val(parseInt(jsonStr.PRZ_MEDIO));
      $("#txtDiasEntreParcelas").val(parseInt(jsonStr.NRDIA));
      $("#checkAtivo").prop('checked', jsonStr.ATIVO == 'S');
      $("#checkEntrada").prop('checked', parseInt(jsonStr.ENTRADA) == 1);
      $('#cbTaxaBandeira').prop('checked', jsonStr.USA_TAXA_BANDEIRA == 'S');
      MontaGridParcelaPrazo();

    } catch (error) {
      console.error(error);
      msgErro(`Não foi possível buscar os dados do tamanho: ${error}`);
    }
  };
  async function RetornaItensCondicao() {
    let arrayPrazoParcela = [];
    let rows = $('#tabelaParcelaPrazo').DataTable().data();
    for (let i = 0; i < rows.length; i++) {
      let ParcelaPrazo = {
        PRAZO: parseInt($($('.PrazoParcela')[i]).val()),
        PARCELA: parseInt(rows[i][0])
      }
      arrayPrazoParcela.push(ParcelaPrazo);
    }
    return arrayPrazoParcela;
  };

  $("#btnGravar").click(async function () {
    let validator = $("#msform").validate();
    validator.form();
    let erros = 0;
    erros = validator.numberOfInvalids();

    if (erros == 0) {
      try {
        $.LoadingOverlay("show");

        let CondicaoPagamento = {
          DESCRICAO: $("#txtDescricao").val().toUpperCase(),
          DIAVE: $("#txtDiaVencimento").val(),
          NRDIA: $("#txtDiasEntreParcelas").val(),
          NRPAR: $("#txtNumeroParcelas").val(),
          PRAZOINI: $("#txtPrazoInicial").val(),
          PRZ_MEDIO: $("#txtPrazoMedio").val(),
          DESCMAX: $("#txtDescontoMaximo").val(),

          ATIVO: $("#checkAtivo").prop("checked")
            ? "S"
            : "N",
          ENTRADA: $("#checkEntrada").prop("checked")
            ? 1
            : 0,
          USA_TAXA_BANDEIRA: $("#cbTaxaBandeira").prop("checked")
            ? "S"
            : "N",
          ITENS: await RetornaItensCondicao(),
          CODCOND: $("#txtCodigo").val() == ""
            ? await RetornaProximo("condicao", "condicao", "CODCOND", 2)
            : $("#txtCodigo").val()
        };

        let response = await requisicao(
          "POST",
          "/Sisplan/Cadastros/v1/condicaopagamento?",
          "",
          `${JSON.stringify(CondicaoPagamento)}`,
          null
        );

        if (!response) {
          $.LoadingOverlay("hide");
          return;
        }

        if (response.status != 200) {
          let jsonStr = await response.json();
          $.LoadingOverlay("hide");
          msgErro(jsonStr.mensagem);
          return;
        }
        $.LoadingOverlay("hide");
        toastr
          .success("Cadastro efetuado com sucesso!", "Confirmação", {
            toastClass: "alert",
            iconClasses: {
              error: "alert-error",
              info: "alert-info",
              success: "alert-success",
              warning: "alert-warning",
            },
            positionClass: "toast-top-center",
            progressBar: true,
            timeOut: 3000,
            fadeOut: 1000,
            onHidden() {
              window.location.href = `${BASE_URI}/condicaopagamento`;
            },
          })
          .css({
            "margin-top": "20%",
            width: "500px",
            "max-width": "500px",
          });
      } catch (error) {
        console.error(error);
        $.LoadingOverlay("hide");
        msgErro(`Não foi possível gravar os dados : ${error}`);
      }
    }
  });


  async function MontaGridParcelaPrazo() {
    let queryString = window.location.href;
    let parametros = queryString.split("/");
    let cond_item = parametros[parametros.length - 1];
    let response = await requisicao(
      "GET",
      "/Sisplan/Funcoes/v1/pesquisa?",
      `JSON={ "tabela":"COND_ITEM", 
              "camposSelect":["CODCOND", "PRAZO", "PARCELA"], 
              "where": ["CODCOND = '${cond_item}'"]}`,
      null
    );

    if (!response) {
      return;
    }
    let jsonStr = await response.json();
    if (response.status != 200) {
      msgErro(jsonStr.RESULT[0].mensagem);
      return;
    }

    jsonStr = jsonStr.RESULT[0];

    for (let i = 0; i < parseInt(jsonStr.length); i++) {
      $('#tabelaParcelaPrazo').DataTable().row.add([
        i + 1,
        `<input type="number" class="input-default focus form-control validate PrazoParcela" value="${jsonStr[i].PRAZO}">`
      ]).draw(false);
    }

  }

  $("#msform").validate({
    debug: false,
    ignore: "",
    rules: {
      txtDescricao: {
        required: true,
      },
    },
    messages: {
      txtDescricao: {
        required: "Informe uma descrição válida.",
      },
    },
    errorElement: "span",
    errorPlacement(error, element) {
      error.addClass("invalid-feedback");
      element.closest(".form-group").append(error);
    },
    highlight(element) {
      $(element).addClass("is-invalid");
    },
    unhighlight(element) {
      $(element).removeClass("is-invalid");
    },
  });

});